//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// wrapRange.template.cpp file to make changes.

#include "pxr/base/gf/range{{ SUFFIX }}.h"
{% for S in SCALARS if S != SCL %}
#include "pxr/base/gf/range{{ DIM }}{{ S[0] }}.h"
{% endfor %}

#include "pxr/base/tf/pyUtils.h"
#include "pxr/base/tf/wrapTypeHelpers.h"
#include "pxr/base/tf/pyContainerConversions.h"

#include <boost/python/class.hpp>
#include <boost/python/copy_const_reference.hpp>
#include <boost/python/operators.hpp>
#include <boost/python/return_arg.hpp>

#include <string>

using namespace boost::python;

using std::string;

static const int _dimension = {{ DIM }};

static string _Repr({{ RNG }} const &self) {
    return TF_PY_REPR_PREFIX + "Range{{ SUFFIX }}(" +
        TfPyRepr(self.GetMin()) + ", " + TfPyRepr(self.GetMax()) + ")";
}

static size_t __hash__({{ RNG }} const &r) { return hash_value(r); }

void wrapRange{{ SUFFIX }}()
{    
    object getMin = make_function(&{{ RNG }}::GetMin,
                                  return_value_policy<return_by_value>());

    object getMax = make_function(&{{ RNG }}::GetMax,
                                  return_value_policy<return_by_value>());

    class_<{{ RNG }}>("Range{{ SUFFIX }}", init<>())
        .def(init<{{ RNG }}>())
        .def(init<{{ MINMAXPARM }}, {{ MINMAXPARM }}>())
        
        .def(TfTypePythonClass())

        .def_readonly("dimension", _dimension)
        
        .add_property("min", getMin, &{{ RNG }}::SetMin)
        .add_property("max", getMax, &{{ RNG }}::SetMax)

        .def("GetMin", getMin)
        .def("GetMax", getMax)

        .def("GetSize", &{{ RNG }}::GetSize)
    
        .def("SetMin", &{{ RNG }}::SetMin)
        .def("SetMax", &{{ RNG }}::SetMax)
    
        .def("IsEmpty", &{{ RNG }}::IsEmpty)
    
        .def("SetEmpty", &{{ RNG }}::SetEmpty)

        .def("Contains", (bool ({{ RNG }}::*)({{ MINMAXPARM }}) const)
             &{{ RNG }}::Contains)
        .def("Contains", (bool ({{ RNG }}::*)(const {{ RNG }} &) const)
             &{{ RNG }}::Contains)
    
        .def("GetUnion", &{{ RNG }}::GetUnion)
        .staticmethod("GetUnion")
    
        .def("UnionWith", (const {{ RNG }} & ({{ RNG }}::*)({{ MINMAXPARM }}))
             &{{ RNG }}::UnionWith, return_self<>())
        .def("UnionWith", (const {{ RNG }} & ({{ RNG }}::*)(const {{ RNG }} &))
             &{{ RNG }}::UnionWith, return_self<>())
    
        .def("GetIntersection", &{{ RNG }}::GetIntersection)
        .staticmethod("GetIntersection")
    
        .def("IntersectWith", (const {{ RNG }} & ({{ RNG }}::*)(const {{ RNG }} &))
             &{{ RNG }}::IntersectWith, return_self<>())
    
        .def("GetDistanceSquared", &{{ RNG }}::GetDistanceSquared)
    
        .def(str(self))
        .def(self += self)
        .def(self -= self)
        .def(self *= double())
        .def(self /= double())
        .def(self + self)
        .def(self - self)
        .def(double() * self)
        .def(self * double())
        .def(self / double())
{% for S in SCALARS if S != SCL %}
        .def(self == {{ RNGNAME(DIM, S) }}())
        .def(self != {{ RNGNAME(DIM, S) }}())
{% endfor %}
        .def(self == self)
        .def(self != self)
    
        .def("__repr__", _Repr)
        .def("__hash__", __hash__)

{% if DIM == 2 %}
        .def("GetCorner", &{{ RNG }}::GetCorner)
        .def("GetQuadrant", &{{ RNG }}::GetQuadrant)
        .def_readonly("unitSquare", &{{ RNG }}::UnitSquare)
{% elif DIM == 3 %}
        .def("GetCorner", &{{ RNG }}::GetCorner)
        .def("GetOctant", &{{ RNG }}::GetOctant)
        .def_readonly("unitCube", &{{ RNG }}::UnitCube)
{% endif %}
        
        ;
    to_python_converter<std::vector<{{ RNG }}>,
        TfPySequenceToPython<std::vector<{{ RNG }}> > >();
    
}
