# 0.20.0 Migration Guide

## Removals

### Command removals

The following commands were previously deprecated and were removed in this release.

- `apps`: Use `apps:list` instead.
- `certs`: Use `certs:report` instead.
- `certs:info`: Use `certs:report` instead.
- `checks`: Use `checks:report` instead.
- `docker-options`: Use `docker-options:report` instead.
- `domains`: Use `domains:report` instead.
- `plugin`: Use `plugin:list` instead.
- `proxy`: Use `proxy:report` instead.
- `trace`: Use `trace:on` or `trace:off` instead.
- `ps`: Use `enter` with a container ID instead to run `ps auxww` within a container.

The refactor of the proxy plugin removes the following functions from being sourced in plugins:

- `proxy#get_app_proxy_port_map()`
- `proxy#list_app_proxy_ports()`
- `proxy#filter_app_proxy_ports()`
- `proxy#add_proxy_ports()`
- `proxy#remove_proxy_ports()`
- `proxy#set_proxy_ports()`

The informal policy is to allow removal of functions within a `functions` file if they are not used in OSS plugins. Should you be affected by any such removals, please file an issue to expose the functionality via a plugin trigger.

### Function renames

- `tar#tar_in_cmd` was renamed to `tar#cmd-tar-in`. Users should avoid using `cmd-*` commands directly, and instead file an issue to have them exposed via a plugin trigger.
- `tar#tar_from_cmd` was renamed to `tar#cmd-tar-from`. Users should avoid using `cmd-*` commands directly, and instead file an issue to have them exposed via a plugin trigger.

### Remove support for Unsupported Operating Systems

Dokku will no longer distribute packages for Ubuntu versions that have reached either End of Life or End of Standard Support (for LTS releases). This currently includes the following releases:

- Ubuntu 14.04 (trusty)
- Ubuntu 14.10 (utopic)
- Ubuntu 15.04 (vivid)
- Ubuntu 15.10 (wily)
- Ubuntu 16.10 (yakkety)
- Ubuntu 17.04 (zesty)
- Ubuntu 17.10 (artful)

Dokku will no longer distribute packages for Debian versions that are not `stable` or `oldstable`. This currently includes the following releases:

- Debian 7 (wheezy)
- Debian 8 (jessie)

### Removed App report flags

The `--git-sha` flag was moved from the `apps:report` command to the `git:report` command.

## App report output

When an app is not deployed, the `apps:report` command no longer shows the message `not deployed`. Please use the `--deployed` flag on `ps:report` instead to see if the app has been deployed.

## Changes

### App report flags

The following changes on the `apps:report` command were made in this release:

- The `--deploy-source` flag was renamed to `--app-deploy-source`.
- The `--locked` flag was renamed to `--app-locked`.

### Network report flags

The following changes on the `network:report` command were made in this release:

- The `--network-listeners` flag was renamed to `--network-web-listeners`.

### Plugin Triggers

- The `network-get-port` trigger was incorrectly documented to have the `isHerokuishContainer` argument as the third argument. The code has been fixed to respect the documentation.
- The `network-get-listeners` trigger now takes an additional `processType` argument. If not specified, it defaults to `web`. This default will be removed in an upcoming release.

## Deprecations

- `nginx:show-conf` has been deprecated in favor of `nginx:show-config`.
- `proxy#is_app_proxy_enabled()` is deprecated in favor of `plugn trigger proxy-is-enabled`.
- `proxy#get_app_proxy_type()` is deprecated in favor of `plugn trigger proxy-type`.
- `apps#apps_create()` is deprecated in favor of `plugn trigger app-create`.
- `apps#apps_destroy()` is deprecated in favor of `plugn trigger app-destroy`.
- `apps#apps_exists()` is deprecated in favor of `plugn trigger app-exists`.
- `apps#apps_maybe_create()` is deprecated in favor of `plugn trigger app-maybe-create`.
- `plugin trigger network-get-listeners` usage without a second `processType` argument is deprecated.
- `.NGINX_PORT` variable usage within `nginx.conf.sigil` templates is deprecated in favor of `.PROXY_PORT`.
- `.NGINX_SSL_PORT` variable usage within `nginx.conf.sigil` templates is deprecated in favor of `.PROXY_SSL_PORT`.
- `.DOKKU_APP_LISTENERS` variable usage within `nginx.conf.sigil` templates is deprecated in favor of `.DOKKU_APP_WEB_LISTENERS`.
