# 0.34.0 Migration Guide

## Removals

- The `disable-chown` property of the `scheduler-docker-local` plugin has been removed. Mounted paths will no longer have file permissions changed during the pre-deploy phase. Files baked into the container image for herokuish builds will always be owned by the correct user.
- The `git:unlock` command has been removed. It was previously used to "unlock" a temporary directory that already existed. The directory the `git:unlock` command used to cleanup is now properly removed on exit of the `git:from-image` command.
- The k3s plugin no longer supports port mappings other than `https:443` and `http:80`. If no matching port map is specified, Dokku will use expose the app on the first port mapping, with priority given to `https` mappings over `http`.
- Golang functions to invoke plugin triggers named `PlugnTrigger*` have been removed in favor of `CallPlugnTrigger`.

## Changes

- The k3s scheduler now creates an Ingress object per domain instead of one per port mapping. This will cause a short amount of downtime during the next app deploy after upgrading to 0.34.0
- App lock files have been removed from the `/home/dokku` directory and moved into the `data/apps` directory.
- Logs are now rotated via `copytruncate` instead of `create` in logrotate.
- The k3s scheduler now defaults to nginx as it's default proxy implementation. The traefik proxy implementation is still available, though users will need to set the global `ingress-class` k3s property to `traefik` via the following command:

    ```shell
    dokku scheduler-k3s:set --global ingress-class traefik
    ```

## Deprecations

The `pre-deploy` plugin trigger is deprecated as of `0.34.4`. It is currently invoked during the `post-release-builder` plugin trigger, where image mutation is heavily discouraged. Users should instead move any trigger usage to the `pre-release-builder` plugin trigger. The `pre-deploy` plugin trigger will be removed in a future release.
