# 0.25.0 Migration Guide

## Registry Plugin

The [dokku-registry](https://github.com/dokku/dokku-registry) plugin is now built-in. This comes with a few changes:

- Builder plugins should call `post-release-builder` at the end of the build.
- The `push` and `pull` command are not implemented. Users wishing to deploy a remote image should use `git:from-image`. Image pushing is not available at this time.
- At this time, remote docker repositories are not automatically created for AWS, and users must create those repositories for their applications as necessary. This may be implemented in the future.
- Docker images are only pushed when configured to do so. See the [registry management documentation](/docs/advanced-usage/registry-management.md) for more details.

Before upgrading, uninstall the registry plugin via `dokku plugin:uninstall registry`. Not doing so will cause issues with Dokku.

## Other

### Changes

- The network plugin can now set an `initial-network` for all containers on creation. This is a replacement for specifying the `--network` flag via the `docker-options` plugin. Please see the [network documentation](/docs/networking/network.md#attaching-an-app-to-a-network) for more information.
- The `dokku run` command now always removes the ephemeral container on exit. Users that need a persistent container should instead specify a `console` process type in their `Procfile` specifying an available shell (usually either `bash` or `sh`) and scale that container appropriately.
- The `pre-deploy` plugin trigger is now called internally by Dokku. Scheduler plugins should avoid calling this trigger, as any image changes introduced by subsequent trigger calls will be ignored.
- The default image used for Herokuish Buildpack builds is now `gliderlabs/herokuish:latest-20`, and is based on both the `heroku-20` stack as well as Ubuntu 20.04. Users that wish to stick with the old, `heroku-18`/Ubuntu 18.04 builder may specify `gliderlabs/herokuish:latest-18` as their builder image. Please see the [herokuish buildpack deployment documentation](/docs/deployment/builders/herokuish-buildpacks.md#customizing-the-buildpack-stack-builder) for more information on how to specify a custom buildpack stack builder.
    - This change does not impact any users of Cloud Native Buildpacks.
- We fixed an issue that required extracting Procfiles at the beginning of a deploy. Due to this change, a `Dockerfile` app contains a `Procfile` that does not specify a `web` process will fail to start. Usage of a `Procfile` with _only_ a `release` command should be replaced with a `scripts.dokku.postdeploy` deployment task in the `app.json` file. The alternative is to define the `web` process in the `Procfile`. See the [deployment task documentation](/docs/advanced-usage/deployment-tasks.md) for more information.

### Deprecations

- In previous versions of Dokku, the only way to specify a custom `Dockerfile` was to use the `docker-options` plugin to set the `--file` flag for a docker build. As of 0.25.0, the `builder-dockerfile:set` command should be used instead, as outlined in the [docs here](/docs/deployment/builders/dockerfiles.md#changingthe-dockerfile-location). Usage of the old method should be migrated to the new method.
- The `--rm` and `--rm-container` flags may be specified but no longer have any effect on `dokku run`.
- The `--detach` flag is deprecated in favor of the `run:detached` command.
- The `DOKKU_SCALE` file is deprecated. Please see the [process management documentation](/docs/processes/process-management.md#manually-managing-process-scaling) for more information on it's replacement with the `formation` key of the `app.json` file.
- The hooks `post-release-buildpack`, `post-release-dockerfile`, and `post-release-pack` are deprecated in favor of `post-release-builder`. See the [plugin triggers documentation](https://dokku.com/docs/development/plugin-triggers/#post-release-builder) for more details.

## Removals

- As of April 2021, Ubuntu 16.04 is no longer an LTS release, and support has been removed. Packages may still install on older versions of Ubuntu, but are no longer tested, and therefore no support will be provided.
- The web installer has been removed. Users are now required to setup Dokku via cli commands. This change was made to combat potential security issues where users ignored the web installer, allowing unauthorized users to add their keys to the host.
- The `scheduler-docker-cleanup` plugin trigger has been removed from the scheduler interface, and is no longer invoked.
