# 0.31.0 Migration Guide

## Changes

- Herokuish build cache is now mounted from a docker volume - eg. `cache-node-js-app` - instead of the local filesystem. All existing app cache will be cleared upon upgrading past 0.29.0.
- The `vector` container integration now mounts config to `/etc/vector` instead of the path `/etc/vector/vector.json`, allowing users the ability to provide extra configuration for Vector Sinks. To take advantage of the new functionality, the vector container should be stopped (via `dokku logs:vector-stop`) and then started (via `dokku logs:vector-start`).
- The `traefik` integration now mounts config to `/data` instead of the path `/acme.json`, fixing permissions issues under certain architectures. To take advantage of the new functionality, the traefik container should be stopped (via `dokku traefik:stop`) and then started (via `dokku traefik:start`).
- Users no longer need to clear the `source-image` git property when transitioning from image-based deploys (`git:from-image` and `git:load-image`) to other deployment methods (git push, `git:from-archive`, `git:sync`).
- For deploys via the `git:from-image` and `git:load-image` commands, the `CHECKS` file is now extracted from the configured `WORKDIR` property of the image. For all other deploys - git push, `git:from-archive`, `git:sync` - will have the `CHECKS` extracted directly from the source code. The filename in both cases is `CHECKS` and cannot be modified.
- Port mappings are now auto-detected during the build process. Users may override detected port mappings via the `ports` plugin. A default port mapping of `http:80:5000` will be used if none is otherwise specified.
- Users building docker images that run Dokku will need to use a new sudoer wrapper for the `docker-container-healthchecker` binary to work correctly. A reference version has been placed in the `docker` skeleton directory. This should only impact platform developers, and users of our Docker image will already have the file available.
- The default image used for Herokuish Buildpack builds is now `gliderlabs/herokuish:latest-22`, and is based on both the `heroku-22` stack as well as Ubuntu 22.04. Users that wish to stick with the old, `heroku-20`/Ubuntu 20.04 builder may specify `gliderlabs/herokuish:latest-20` as their builder image. Please see the [herokuish buildpack deployment documentation](/docs/deployment/builders/herokuish-buildpacks.md#customizing-the-buildpack-stack-builder) for more information on how to specify a custom buildpack stack builder.
- The default image used for Cloud Native Buildpack builds is now `heroku/builder:22`, and is based on both the `heroku-22` stack as well as Ubuntu 22.04. Users that wish to stick with the old, `heroku-20`/Ubuntu 20.04 builder may specify `heroku/buildpacks:20` as their builder image. Please see the [herokuish buildpack deployment documentation](/docs/deployment/builders/herokuish-buildpacks.md#customizing-the-buildpack-stack-builder) for more information on how to specify a custom buildpack stack builder.

## Deprecations

- The `proxy:ports*` commands have been replaced with the new `ports` plugin. Users will be able to use the old `proxy:ports*` commands for a single minor release, and they will be removed in the next minor release.
- The `common#get_available_port()` function has been deprecated and will be removed in the next release. Users should avoid interacting with this function and instead use the `ports-get-available` plugin trigger for fetching an available port.
- The `proxy-configure-ports` plugin trigger has been deprecated and will be removed in the next release. Users should instead trigger the `ports-configure` plugin trigger.
- The `common#get_dockerfile_exposed_ports()` function is deprecated and will be removed in the next release. There is no replacement for this as it's only use in Dokku core was in the `builder-dockerfile` plugin.
- The `common#get_exposed_ports_from_image()` function is deprecated and will be removed in the next release. There is no replacement for this as it's only use in Dokku core was during the build process.
- The environment variable `DOKKU_PROXY_PORT_MAP` has been migrated to the properties system. Direct changes to the value will be ignored, and users should interact with port maps via the `ports` plugin.
- The `CHECKS` file is deprecated in favor of defining healthchecks in the `app.json` file. The [docker-container-healthchecker](https://github.com/dokku/docker-container-healthchecker) tool can be used to generate healthcheck entries in `app.json` format from existing `CHECKS` files. See the [zero-downtime deploy documentation](/docs/deployment/zero-downtime-deploys.md) for more information on how the new zero downtime check format works.
- ARM support is now deprecated, and will be removed in the next minor release. ARM releases are not tested in CI and do not get testing locally. Users of ARM installations on platforms such as the Raspberry PI should consider migrating to ARM64. ARM64 will continue to be supported by Dokku, and there are no plans to remove support for ARM64.

## Un-Deprecations

- The bare `apps` and `config` cli aliases are no longer deprecated. This better follows Heroku's output and is more useful to users. The subcommands will be treated as the primary, documented versions, while the aliases are there for convenience.

## Removals

- The variable `RAW_TCP_PORTS` is no longer exposed for `nginx.conf.sigil` templating.
- The environment variable `DOKKU_DOCKERFILE_PORTS` is no longer in use. Users wishing to change port mappings should instead use the `ports` plugin.
- The `common#get_app_raw_tcp_ports()` function has been removed in the next release. Users should instead use the `ports-get` plugin trigger for fetching ports for an app.
- The plugin trigger `network-compute-ports` has been removed. It's only use was in the `scheduler-docker-local` plugin, for exposing ports. It's functionality is now implemented via the `ports` plugin.
- The plugin trigger `network-get-port` has been removed. It's only use was in the `scheduler-docker-local` plugin, for recording ports. It's functionality is now implemented via the `ports` plugin.
