# 0.30.0 Migration Guide

> **Important**: Due to the removal of `DOKKU_SCALE` support, users with a version older than 0.25.x are heavily encouraged to upgrade to 0.29.x prior to 0.30.x. Not doing so will result in all app containers stopping on rebuild due to having no scale settings.

## Deprecations

- Support for Ubuntu 18.04 has been deprecated. Please upgrade your host OS in advance of the [End Of Life in April 2023](https://wiki.ubuntu.com/BionicBeaver/ReleaseNotes).

## Changes

- The `app.json` file is now extracted from the source code instead of the built image. For deploys via `git:from-image`, the file is extracted from the built image.

## Removals

- Support for [SPDY](https://en.wikipedia.org/wiki/SPDY) has been removed. No major browser supports it as of 2021. Custom `nginx.conf.sigil` templates referencing spdy-related variables will continue to build until the 1.0.0 release.
- Support for the `DOKKU_SCALE` file - deprecated in 0.25.0 - has been removed in favor of the `formation` key in the `app.json` file. Please see the [process management documentation](/docs/processes/process-management.md#manually-managing-process-scaling) for more information on how to use the `formation` key of the `app.json` file.
- The deprecated `--detach` global flag for `dokku run` was removed. Please see the [one-off tasks documentation](/docs/processes/one-off-tasks.md#running-a-detached-container) for more information on running detached containers.
- The following deprecated trigger have been removed in favor of the `post-release-builder` trigger. See the [plugin triggers documentation](https://dokku.com/docs/development/plugin-triggers/#post-release-builder) for more details.
    - `post-release-buildpack`
    - `post-release-dockerfile`
    - `post-release-pack`
- The ability to call `logs:failed` without specifying an app or `--all` flag has been removed. This was deprecated in 0.22.0. Please see the [logs:failed](/docs/deployment/logs.md#failed-deploy-logs).
- The following app shell functions - deprecated since 0.20.0 - have been removed in favor of their plugin trigger equivalents. Sourcing the `app/functions` file will fail going forward.
    - `apps#apps_create()` is removed in favor of `plugn trigger app-create`.
    - `apps#apps_destroy()` is removed in favor of `plugn trigger app-destroy`.
    - `apps#apps_exists()` is removed in favor of `plugn trigger app-exists`.
    - `apps#apps_maybe_create()` is removed in favor of `plugn trigger app-maybe-create`.
- The following common shell functions have been removed:
    - `common#is_container_running()` (deprecated since 0.12.6) is removed in favor of `common#is_container_status()`.
    - `common#is_app_running()` (deprecated since 0.22.0) is removed in favor of `ps#fn-ps-is-app-running()`.
- The global `--rm-container` and `--rm` flags - deprecated since 0.25.0 - have been removed.
- The following git shell functions have been removed:
    - `git#use_git_worktree()` (deprecated since 0.23.7) has been removed. There is no alternative as the function has been made internal.
    - `git#git_deploy_branch()`(deprecated since 0.21.0) has been removed in favor of `plugn trigger git-deploy-branch`.
- The following nginx commands - deprecated since 0.20.0 - have been removed:
    - `nginx:show-conf` has been removed in favor of `nginx:show-config`.
    - `nginx:validate` has been removed in favor of `nginx:validate-config`.
    - `nginx:build-config` - deprecated since 0.21.0 - has been removed in favor of `proxy:build-config`.
- The following proxy functions - deprecated since 0.20.0 - have been removed in favor of their plugin trigger equivalents. Sourcing the `proxy/functions` file will fail going forward.
    - `proxy#is_app_proxy_enabled()` is removed in favor of `plugn trigger proxy-is-enabled`.
    - `proxy#get_app_proxy_type()` is removed in favor of `plugn trigger proxy-type`.
