// This file is auto-generated by @hey-api/openapi-ts

export type APIVersion = 'V1' | 'V2';

export type AddChunkToGroupReqPayload = {
    /**
     * Id of the chunk to make a member of the group.
     */
    chunk_id?: (string) | null;
    /**
     * Tracking Id of the chunk to make a member of the group.
     */
    chunk_tracking_id?: (string) | null;
};

export type ApiKeyRespBody = {
    created_at: string;
    dataset_ids?: Array<(string)> | null;
    id: string;
    name: string;
    organization_ids?: Array<(string)> | null;
    role: number;
    updated_at: string;
    user_id: string;
};

export type AuthQuery = {
    /**
     * Code sent via email as a result of successful call to send_invitation
     */
    inv_code?: (string) | null;
    /**
     * ID of organization to authenticate into
     */
    organization_id?: (string) | null;
    /**
     * URL to redirect to after successful login
     */
    redirect_uri?: (string) | null;
};

export type AutocompleteReqPayload = {
    /**
     * Set content_only to true to only returning the chunk_html of the chunks. This is useful for when you want to reduce amount of data over the wire for latency improvement (typically 10-50ms). Default is false.
     */
    content_only?: (boolean) | null;
    /**
     * If specified to true, this will extend the search results to include non-exact prefix matches of the same search_type such that a full page_size of results are returned. Default is false.
     */
    extend_results?: (boolean) | null;
    filters?: ((ChunkFilter) | null);
    highlight_options?: ((HighlightOptions) | null);
    /**
     * Page size is the number of chunks to fetch. This can be used to fetch more than 10 chunks at a time.
     */
    page_size?: (number) | null;
    /**
     * Query is the search query. This can be any string. The query will be used to create an embedding vector and/or SPLADE vector which will be used to find the result set.
     */
    query: string;
    /**
     * If true, stop words (specified in server/src/stop-words.txt in the git repo) will be removed. Queries that are entirely stop words will be preserved.
     */
    remove_stop_words?: (boolean) | null;
    /**
     * Set score_threshold to a float to filter out chunks with a score below the threshold. This threshold applies before weight and bias modifications. If not specified, this defaults to 0.0.
     */
    score_threshold?: (number) | null;
    scoring_options?: ((ScoringOptions) | null);
    search_type: SearchMethod;
    /**
     * Set slim_chunks to true to avoid returning the content and chunk_html of the chunks. This is useful for when you want to reduce amount of data over the wire for latency improvement (typically 10-50ms). Default is false.
     */
    slim_chunks?: (boolean) | null;
    sort_options?: ((SortOptions) | null);
    typo_options?: ((TypoOptions) | null);
    /**
     * If true, quoted and - prefixed words will be parsed from the queries and used as required and negated words respectively. Default is false.
     */
    use_quote_negated_terms?: (boolean) | null;
    /**
     * User ID is the id of the user who is making the request. This is used to track user interactions with the search results.
     */
    user_id?: (string) | null;
};

export type BatchQueuedChunkResponse = {
    chunk_metadata: Array<ChunkMetadata>;
    /**
     * The current position the last access item is in the queue
     */
    pos_in_queue: number;
};

export type CTRAnalytics = {
    filter?: ((SearchAnalyticsFilter) | null);
    type: 'search_ctr_metrics';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    page?: (number) | null;
    type: 'searches_with_clicks';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    page?: (number) | null;
    type: 'searches_without_clicks';
} | {
    filter?: ((RecommendationAnalyticsFilter) | null);
    type: 'recommendation_ctr_metrics';
} | {
    filter?: ((RecommendationAnalyticsFilter) | null);
    page?: (number) | null;
    type: 'recommendations_with_clicks';
} | {
    filter?: ((RecommendationAnalyticsFilter) | null);
    page?: (number) | null;
    type: 'recommendations_without_clicks';
};

export type type = 'search_ctr_metrics';

export type CTRAnalyticsResponse = SearchCTRMetrics | CTRSearchQueryWithoutClicksResponse | CTRSearchQueryWithClicksResponse | RecommendationCTRMetrics | CTRRecommendationsWithoutClicksResponse | CTRRecommendationsWithClicksResponse;

export type CTRDataRequestBody = {
    /**
     * The ID of chunk that was clicked
     */
    clicked_chunk_id?: (string) | null;
    /**
     * The tracking ID of the chunk that was clicked
     */
    clicked_chunk_tracking_id?: (string) | null;
    ctr_type: CTRType;
    /**
     * Any metadata you want to include with the event i.e. action, user_id, etc.
     */
    metadata?: unknown;
    /**
     * The position of the clicked chunk
     */
    position: number;
    /**
     * The request id for the CTR data
     */
    request_id: string;
};

export type CTRRecommendationsWithClicksResponse = {
    recommendations: Array<RecommendationsWithClicksCTRResponse>;
};

export type CTRRecommendationsWithoutClicksResponse = {
    recommendations: Array<RecommendationsWithoutClicksCTRResponse>;
};

export type CTRSearchQueryWithClicksResponse = {
    queries: Array<SearchQueriesWithClicksCTRResponse>;
};

export type CTRSearchQueryWithoutClicksResponse = {
    queries: Array<SearchQueriesWithoutClicksCTRResponse>;
};

export type CTRType = 'search' | 'recommendation';

export type ChatMessageProxy = {
    content: string;
    role: RoleProxy;
};

/**
 * Filters is a JSON object which can be used to filter chunks. This is useful for when you want to filter chunks by arbitrary metadata. Unlike with tag filtering, there is a performance hit for filtering on metadata.
 */
export type ChunkFilter = {
    /**
     * JOSNB prefilter tells the server to perform a full scan over the metadata JSONB column instead of using the filtered HNSW. Datasets on the enterprise plan with custom metadata indices will perform better with the filtered HNSW instead. When false, the server will use the filtered HNSW index to filter chunks. When true, the server will perform a full scan over the metadata JSONB column to filter chunks. Default is true.
     */
    jsonb_prefilter?: (boolean) | null;
    /**
     * All of these field conditions have to match for the chunk to be included in the result set.
     */
    must?: Array<ConditionType> | null;
    /**
     * None of these field conditions can match for the chunk to be included in the result set.
     */
    must_not?: Array<ConditionType> | null;
    /**
     * Only one of these field conditions has to match for the chunk to be included in the result set.
     */
    should?: Array<ConditionType> | null;
};

export type ChunkGroup = {
    created_at: string;
    dataset_id: string;
    description: string;
    id: string;
    metadata?: unknown;
    name: string;
    tag_set?: Array<((string) | null)> | null;
    tracking_id?: (string) | null;
    updated_at: string;
};

export type ChunkGroupAndFileId = {
    created_at: string;
    dataset_id: string;
    description: string;
    file_id?: (string) | null;
    id: string;
    metadata?: unknown;
    name: string;
    tag_set?: Array<((string) | null)> | null;
    tracking_id?: (string) | null;
    updated_at: string;
};

export type ChunkGroups = Array<ChunkGroup>;

export type ChunkMetadata = {
    chunk_html?: (string) | null;
    created_at: string;
    dataset_id: string;
    id: string;
    image_urls?: Array<((string) | null)> | null;
    link?: (string) | null;
    location?: ((GeoInfo) | null);
    metadata?: unknown;
    num_value?: (number) | null;
    tag_set?: Array<((string) | null)> | null;
    time_stamp?: (string) | null;
    tracking_id?: (string) | null;
    updated_at: string;
    weight: number;
};

export type ChunkMetadataStringTagSet = {
    chunk_html?: (string) | null;
    created_at: string;
    dataset_id: string;
    id: string;
    image_urls?: Array<((string) | null)> | null;
    link?: (string) | null;
    location?: ((GeoInfo) | null);
    metadata?: unknown;
    num_value?: (number) | null;
    tag_set?: (string) | null;
    time_stamp?: (string) | null;
    tracking_id?: (string) | null;
    updated_at: string;
    weight: number;
};

export type ChunkMetadataTypes = SlimChunkMetadata | ChunkMetadataStringTagSet | ContentChunkMetadata;

export type ChunkMetadataWithScore = {
    chunk_html?: (string) | null;
    created_at: string;
    dataset_id: string;
    id: string;
    link?: (string) | null;
    metadata?: unknown;
    score: number;
    tag_set?: (string) | null;
    time_stamp?: (string) | null;
    tracking_id?: (string) | null;
    updated_at: string;
    weight: number;
};

export type ChunkReqPayload = {
    /**
     * HTML content of the chunk. This can also be plaintext. The innerText of the HTML will be used to create the embedding vector. The point of using HTML is for convienience, as some users have applications where users submit HTML content.
     */
    chunk_html?: (string) | null;
    /**
     * Convert HTML to raw text before processing to avoid adding noise to the vector embeddings. By default this is true. If you are using HTML content that you want to be included in the vector embeddings, set this to false.
     */
    convert_html_to_text?: (boolean) | null;
    fulltext_boost?: ((FullTextBoost) | null);
    /**
     * Group ids are the Trieve generated ids of the groups that the chunk should be placed into. This is useful for when you want to create a chunk and add it to a group or multiple groups in one request. Groups with these Trieve generated ids must be created first, it cannot be arbitrarily created through this route.
     */
    group_ids?: Array<(string)> | null;
    /**
     * Group tracking_ids are the user-assigned tracking_ids of the groups that the chunk should be placed into. This is useful for when you want to create a chunk and add it to a group or multiple groups in one request. If a group with the tracking_id does not exist, it will be created.
     */
    group_tracking_ids?: Array<(string)> | null;
    /**
     * Image urls are a list of urls to images that are associated with the chunk. This is useful for when you want to associate images with a chunk.
     */
    image_urls?: Array<(string)> | null;
    /**
     * Link to the chunk. This can also be any string. Frequently, this is a link to the source of the chunk. The link value will not affect the embedding creation.
     */
    link?: (string) | null;
    location?: ((GeoInfo) | null);
    /**
     * Metadata is a JSON object which can be used to filter chunks. This is useful for when you want to filter chunks by arbitrary metadata. Unlike with tag filtering, there is a performance hit for filtering on metadata.
     */
    metadata?: unknown;
    /**
     * Num value is an arbitrary numerical value that can be used to filter chunks. This is useful for when you want to filter chunks by numerical value. There is no performance hit for filtering on num_value.
     */
    num_value?: (number) | null;
    semantic_boost?: ((SemanticBoost) | null);
    /**
     * If semantic_content is present, it will be used for creating semantic embeddings instead of the innerText `chunk_html`. `chunk_html` will still be the only thing stored and always used for fulltext functionality.
     */
    semantic_content?: (string) | null;
    /**
     * Split avg is a boolean which tells the server to split the text in the chunk_html into smaller chunks and average their resulting vectors. This is useful for when you want to create a chunk from a large piece of text and want to split it into smaller chunks to create a more fuzzy average dense vector. The sparse vector will be generated normally with no averaging. By default this is false.
     */
    split_avg?: (boolean) | null;
    /**
     * Tag set is a list of tags. This can be used to filter chunks by tag. Unlike with metadata filtering, HNSW indices will exist for each tag such that there is not a performance hit for filtering on them.
     */
    tag_set?: Array<(string)> | null;
    /**
     * Time_stamp should be an ISO 8601 combined date and time without timezone. It is used for time window filtering and recency-biasing search results.
     */
    time_stamp?: (string) | null;
    /**
     * Tracking_id is a string which can be used to identify a chunk. This is useful for when you are coordinating with an external system and want to use the tracking_id to identify the chunk.
     */
    tracking_id?: (string) | null;
    /**
     * Upsert when a chunk with the same tracking_id exists. By default this is false, and the request will fail if a chunk with the same tracking_id exists. If this is true, the chunk will be updated if a chunk with the same tracking_id exists.
     */
    upsert_by_tracking_id?: (boolean) | null;
    /**
     * Weight is a float which can be used to bias search results. This is useful for when you want to bias search results for a chunk. The magnitude only matters relative to other chunks in the chunk's dataset dataset.
     */
    weight?: (number) | null;
};

export type ChunkReturnTypes = ChunkMetadata | ChunkMetadataStringTagSet;

export type ChunksWithPositions = {
    chunk_id: string;
    position: number;
};

export type ClusterAnalytics = {
    filter?: ((ClusterAnalyticsFilter) | null);
    type: 'cluster_topics';
} | {
    cluster_id: string;
    page?: (number) | null;
    type: 'cluster_queries';
};

export type type2 = 'cluster_topics';

export type ClusterAnalyticsFilter = {
    date_range?: ((DateRange) | null);
};

export type ClusterAnalyticsResponse = SearchClusterResponse | SearchQueryResponse;

export type ConditionType = FieldCondition | HasIDCondition;

export type ContentChunkMetadata = {
    chunk_html?: (string) | null;
    id: string;
    image_urls?: Array<((string) | null)> | null;
    num_value?: (number) | null;
    time_stamp?: (string) | null;
    tracking_id?: (string) | null;
    weight: number;
};

export type CountChunkQueryResponseBody = {
    count: number;
};

export type CountChunksReqPayload = {
    filters?: ((ChunkFilter) | null);
    /**
     * Set limit to restrict the maximum number of chunks to count. This is useful for when you want to reduce the latency of the count operation. By default the limit will be the number of chunks in the dataset.
     */
    limit?: (number) | null;
    query: QueryTypes;
    /**
     * Set score_threshold to a float to filter out chunks with a score below the threshold. This threshold applies before weight and bias modifications. If not specified, this defaults to 0.0.
     */
    score_threshold?: (number) | null;
    search_type: CountSearchMethod;
    /**
     * If true, quoted and - prefixed words will be parsed from the queries and used as required and negated words respectively. Default is false.
     */
    use_quote_negated_terms?: (boolean) | null;
};

export type CountSearchMethod = 'fulltext' | 'semantic' | 'bm25';

export type CreateBatchChunkGroupReqPayload = Array<CreateSingleChunkGroupReqPayload>;

export type CreateBatchChunkReqPayload = Array<ChunkReqPayload>;

export type CreateChunkGroupReqPayloadEnum = CreateSingleChunkGroupReqPayload | CreateBatchChunkGroupReqPayload;

export type CreateChunkGroupResponseEnum = ChunkGroup | ChunkGroups;

export type CreateChunkReqPayloadEnum = ChunkReqPayload | CreateBatchChunkReqPayload;

export type CreateDatasetRequest = {
    /**
     * Name of the dataset.
     */
    dataset_name: string;
    /**
     * Organization ID that the dataset will belong to.
     */
    organization_id: string;
    server_configuration?: ((DatasetConfigurationDTO) | null);
    /**
     * Optional tracking ID for the dataset. Can be used to track the dataset in external systems. Must be unique within the organization. Strongly recommended to not use a valid uuid value as that will not work with the TR-Dataset header.
     */
    tracking_id?: (string) | null;
};

export type CreateMessageReqPayload = {
    /**
     * If concat user messages query is set to true, all of the user messages in the topic will be concatenated together and used as the search query. If not specified, this defaults to false. Default is false.
     */
    concat_user_messages_query?: (boolean) | null;
    filters?: ((ChunkFilter) | null);
    highlight_options?: ((HighlightOptions) | null);
    llm_options?: ((LLMOptions) | null);
    /**
     * The content of the user message to attach to the topic and then generate an assistant message in response to.
     */
    new_message_content: string;
    /**
     * Page size is the number of chunks to fetch during RAG. If 0, then no search will be performed. If specified, this will override the N retrievals to include in the dataset configuration. Default is None.
     */
    page_size?: (number) | null;
    /**
     * Set score_threshold to a float to filter out chunks with a score below the threshold. This threshold applies before weight and bias modifications. If not specified, this defaults to 0.0.
     */
    score_threshold?: (number) | null;
    /**
     * Query is the search query. This can be any string. The search_query will be used to create a dense embedding vector and/or sparse vector which will be used to find the result set. If not specified, will default to the last user message or HyDE if HyDE is enabled in the dataset configuration. Default is None.
     */
    search_query?: (string) | null;
    search_type?: ((SearchMethod) | null);
    /**
     * The ID of the topic to attach the message to.
     */
    topic_id: string;
    /**
     * The user_id is the id of the user who is making the request. This is used to track user interactions with the RAG results.
     */
    user_id?: (string) | null;
};

export type CreateOrganizationReqPayload = {
    /**
     * The arbitrary name which will be used to identify the organization. This name must be unique.
     */
    name: string;
};

export type CreateSetupCheckoutSessionResPayload = {
    url: string;
};

export type CreateSingleChunkGroupReqPayload = {
    /**
     * Description to assign to the chunk_group. Convenience field for you to avoid having to remember what the group is for.
     */
    description?: (string) | null;
    /**
     * Optional metadata to assign to the chunk_group. This is a JSON object that can store any additional information you want to associate with the chunks inside of the chunk_group.
     */
    metadata?: unknown;
    /**
     * Name to assign to the chunk_group. Does not need to be unique.
     */
    name?: (string) | null;
    /**
     * Optional tags to assign to the chunk_group. This is a list of strings that can be used to categorize the chunks inside the chunk_group.
     */
    tag_set?: Array<(string)> | null;
    /**
     * Optional tracking id to assign to the chunk_group. This is a unique identifier for the chunk_group.
     */
    tracking_id?: (string) | null;
    /**
     * Upsert when a chunk_group with the same tracking_id exists. By default this is false, and the request will fail if a chunk_group with the same tracking_id exists. If this is true, the chunk_group will be updated if a chunk_group with the same tracking_id exists.
     */
    upsert_by_tracking_id?: (boolean) | null;
};

export type CreateSingleChunkReqPayload = ChunkReqPayload;

export type CreateTopicReqPayload = {
    /**
     * The first message which will belong to the topic. The topic name is generated based on this message similar to how it works in the OpenAI chat UX if a name is not explicitly provided on the name request body key.
     */
    first_user_message?: (string) | null;
    /**
     * The name of the topic. If this is not provided, the topic name is generated from the first_user_message.
     */
    name?: (string) | null;
    /**
     * The owner_id of the topic. This is typically a browser fingerprint or your user's id. It is used to group topics together for a user.
     */
    owner_id: string;
};

export type Dataset = {
    created_at: string;
    deleted: number;
    id: string;
    name: string;
    organization_id: string;
    server_configuration: unknown;
    tracking_id?: (string) | null;
    updated_at: string;
};

export type DatasetAnalytics = {
    avg_latency: number;
    p50: number;
    p95: number;
    p99: number;
    search_rps: number;
    total_queries: number;
};

export type DatasetAndUsage = {
    dataset: DatasetDTO;
    dataset_usage: DatasetUsageCount;
};

/**
 * Lets you specify the configuration for a dataset
 */
export type DatasetConfigurationDTO = {
    /**
     * The average length of the chunks in the index for BM25
     */
    BM25_AVG_LEN?: (number) | null;
    /**
     * The BM25 B parameter
     */
    BM25_B?: (number) | null;
    /**
     * Whether to use BM25
     */
    BM25_ENABLED?: (boolean) | null;
    /**
     * The BM25 K parameter
     */
    BM25_K?: (number) | null;
    DISTANCE_METRIC?: ((DistanceMetric) | null);
    /**
     * The base URL for the embedding API
     */
    EMBEDDING_BASE_URL?: (string) | null;
    /**
     * The name of the embedding model to use
     */
    EMBEDDING_MODEL_NAME?: (string) | null;
    /**
     * The prefix to use for the embedding query
     */
    EMBEDDING_QUERY_PREFIX?: (string) | null;
    /**
     * The size of the embeddings
     */
    EMBEDDING_SIZE?: (number) | null;
    /**
     * The frequency penalty to use
     */
    FREQUENCY_PENALTY?: (number) | null;
    /**
     * Whether to use fulltext search
     */
    FULLTEXT_ENABLED?: (boolean) | null;
    /**
     * Whether to only use indexed chunks
     */
    INDEXED_ONLY?: (boolean) | null;
    /**
     * The base URL for the LLM API
     */
    LLM_BASE_URL?: (string) | null;
    /**
     * The default model to use for the LLM
     */
    LLM_DEFAULT_MODEL?: (string) | null;
    /**
     * Whether the dataset is locked to prevent changes or deletion
     */
    LOCKED?: (boolean) | null;
    /**
     * The maximum limit for the number of chunks for counting
     */
    MAX_LIMIT?: (number) | null;
    /**
     * The maximum number of tokens to use in LLM Response
     */
    MAX_TOKENS?: (number) | null;
    /**
     * The prompt to use for converting a message to a query
     */
    MESSAGE_TO_QUERY_PROMPT?: (string) | null;
    /**
     * The number of retrievals to include with the RAG model
     */
    N_RETRIEVALS_TO_INCLUDE?: (number) | null;
    /**
     * The presence penalty to use
     */
    PRESENCE_PENALTY?: (number) | null;
    /**
     * The prompt to use for the RAG model
     */
    RAG_PROMPT?: (string) | null;
    /**
     * The base URL for the reranker API
     */
    RERANKER_BASE_URL?: (string) | null;
    /**
     * Whether to use semantic search
     */
    SEMANTIC_ENABLED?: (boolean) | null;
    /**
     * The stop tokens to use
     */
    STOP_TOKENS?: Array<(string)> | null;
    /**
     * The system prompt to use for the LLM
     */
    SYSTEM_PROMPT?: (string) | null;
    /**
     * The temperature to use
     */
    TEMPERATURE?: (number) | null;
    /**
     * Whether to use the message to query prompt
     */
    USE_MESSAGE_TO_QUERY_PROMPT?: (boolean) | null;
};

export type DatasetDTO = {
    created_at: string;
    id: string;
    name: string;
    organization_id: string;
    tracking_id?: (string) | null;
    updated_at: string;
};

export type DatasetUsageCount = {
    chunk_count: number;
    dataset_id: string;
    id: string;
};

export type DateRange = {
    gt?: (string) | null;
    gte?: (string) | null;
    lt?: (string) | null;
    lte?: (string) | null;
};

export type DeleteTopicData = {
    /**
     * The id of the topic to target.
     */
    topic_id: string;
};

export type DeleteUserApiKeyRequest = {
    /**
     * The id of the api key to delete.
     */
    api_key_id: string;
};

export type DeprecatedSearchOverGroupsResponseBody = {
    corrected_query?: (string) | null;
    group_chunks: Array<GroupScoreChunk>;
    total_chunk_pages: number;
};

export type DistanceMetric = 'euclidean' | 'cosine' | 'manhattan' | 'dot';

export type EditMessageReqPayload = {
    /**
     * If concat user messages query is set to true, all of the user messages in the topic will be concatenated together and used as the search query. If not specified, this defaults to false. Default is false.
     */
    concat_user_messages_query?: (boolean) | null;
    filters?: ((ChunkFilter) | null);
    highlight_options?: ((HighlightOptions) | null);
    llm_options?: ((LLMOptions) | null);
    /**
     * The sort order of the message to edit.
     */
    message_sort_order: number;
    /**
     * The new content of the message to replace the old content with.
     */
    new_message_content: string;
    /**
     * Page size is the number of chunks to fetch during RAG. If 0, then no search will be performed. If specified, this will override the N retrievals to include in the dataset configuration. Default is None.
     */
    page_size?: (number) | null;
    /**
     * Set score_threshold to a float to filter out chunks with a score below the threshold. This threshold applies before weight and bias modifications. If not specified, this defaults to 0.0.
     */
    score_threshold?: (number) | null;
    /**
     * Query is the search query. This can be any string. The search_query will be used to create a dense embedding vector and/or sparse vector which will be used to find the result set. If not specified, will default to the last user message or HyDE if HyDE is enabled in the dataset configuration. Default is None.
     */
    search_query?: (string) | null;
    search_type?: ((SearchMethod) | null);
    /**
     * The id of the topic to edit the message at the given sort order for.
     */
    topic_id: string;
    /**
     * The user_id is the id of the user who is making the request. This is used to track user interactions with the RAG results.
     */
    user_id?: (string) | null;
};

export type ErrorResponseBody = {
    message: string;
};

export type EventReturn = {
    events: Array<WorkerEvent>;
    page_count: number;
};

export type EventTypeRequest = 'file_uploaded' | 'file_upload_failed' | 'chunks_uploaded' | 'chunk_action_failed' | 'chunk_updated' | 'bulk_chunks_deleted' | 'dataset_delete_failed' | 'qdrant_upload_failed' | 'bulk_chunk_upload_failed' | 'group_chunks_updated' | 'group_chunks_action_failed';

export type EventTypes = {
    /**
     * The name of the event
     */
    event_name: string;
    event_type: 'view';
    /**
     * The items that were viewed
     */
    items: Array<(string)>;
    /**
     * Any other metadata associated with the event
     */
    metadata?: unknown;
    /**
     * The request id of the event to associate it with a request
     */
    request_id?: (string) | null;
    /**
     * The user id of the user who viewed the items
     */
    user_id?: (string) | null;
} | {
    /**
     * The name of the event
     */
    event_name: string;
    event_type: 'add_to_cart';
    /**
     * Whether the event is a conversion event
     */
    is_conversion?: (boolean) | null;
    /**
     * The items that were added to the cart
     */
    items: Array<(string)>;
    /**
     * Any other metadata associated with the event
     */
    metadata?: unknown;
    /**
     * The request id of the event to associate it with a request
     */
    request_id?: (string) | null;
    /**
     * The user id of the user who added the items to the cart
     */
    user_id?: (string) | null;
} | {
    clicked_items: ChunksWithPositions;
    /**
     * The name of the event
     */
    event_name: string;
    event_type: 'click';
    /**
     * Whether the event is a conversion event
     */
    is_conversion?: (boolean) | null;
    /**
     * The request id of the event to associate it with a request
     */
    request_id?: (string) | null;
    /**
     * The user id of the user who clicked the items
     */
    user_id?: (string) | null;
} | {
    /**
     * The currency of the purchase
     */
    currency?: (string) | null;
    /**
     * The name of the event
     */
    event_name: string;
    event_type: 'purchase';
    /**
     * Whether the event is a conversion event
     */
    is_conversion?: (boolean) | null;
    /**
     * The items that were purchased
     */
    items: Array<(string)>;
    /**
     * The request id of the event to associate it with a request
     */
    request_id?: (string) | null;
    /**
     * The user id of the user who purchased the items
     */
    user_id?: (string) | null;
    /**
     * The value of the purchase
     */
    value?: (number) | null;
} | {
    /**
     * The name of the event
     */
    event_name: string;
    event_type: 'filter_clicked';
    /**
     * Whether the event is a conversion event
     */
    is_conversion?: (boolean) | null;
    /**
     * The filter items that were clicked in a hashmap ie. {filter_name: filter_value} where filter_name is filter_type::field_name
     */
    items: {
        [key: string]: (string);
    };
    /**
     * The request id of the event to associate it with a request
     */
    request_id?: (string) | null;
    /**
     * The user id of the user who clicked the items
     */
    user_id?: (string) | null;
};

export type event_type = 'view';

export type FieldCondition = {
    date_range?: ((DateRange) | null);
    /**
     * Field is the name of the field to filter on. The field value will be used to check for an exact substring match on the metadata values for each existing chunk. This is useful for when you want to filter chunks by arbitrary metadata. To access fields inside of the metadata that you provide with the card, prefix the field name with `metadata.`.
     */
    field: string;
    geo_bounding_box?: ((LocationBoundingBox) | null);
    geo_polygon?: ((LocationPolygon) | null);
    geo_radius?: ((LocationRadius) | null);
    /**
     * Match all lets you pass in an array of values that will return results if all of the items match. The match value will be used to check for an exact substring match on the metadata values for each existing chunk. If both match_all and match_any are provided, the match_any condition will be used.
     */
    match_all?: Array<MatchCondition> | null;
    /**
     * Match any lets you pass in an array of values that will return results if any of the items match. The match value will be used to check for an exact substring match on the metadata values for each existing chunk. If both match_all and match_any are provided, the match_any condition will be used.
     */
    match_any?: Array<MatchCondition> | null;
    range?: ((Range) | null);
};

export type File = {
    created_at: string;
    dataset_id: string;
    file_name: string;
    id: string;
    link?: (string) | null;
    metadata?: unknown;
    size: number;
    tag_set?: Array<((string) | null)> | null;
    time_stamp?: (string) | null;
    updated_at: string;
};

export type FileDTO = {
    created_at: string;
    file_name: string;
    id: string;
    link?: (string) | null;
    metadata?: unknown;
    s3_url: string;
    size: number;
    updated_at: string;
};

/**
 * Boost phrase is useful for when you want to boost certain phrases in the fulltext (SPLADE) and BM25 search results. I.e. making sure that the listing for AirBNB itself ranks higher than companies who make software for AirBNB hosts by boosting the in-document-frequency of the AirBNB token (AKA word) for its official listing. Conceptually it multiples the in-document-importance second value in the tuples of the SPLADE or BM25 sparse vector of the chunk_html innerText for all tokens present in the boost phrase by the boost factor like so: (token, in-document-importance) -> (token, in-document-importance*boost_factor).
 */
export type FullTextBoost = {
    /**
     * Amount to multiplicatevly increase the frequency of the tokens in the phrase by
     */
    boost_factor: number;
    /**
     * The phrase to boost in the fulltext document frequency index
     */
    phrase: string;
};

export type GenerateOffChunksReqPayload = {
    /**
     * The ids of the chunks to be retrieved and injected into the context window for RAG.
     */
    chunk_ids: Array<(string)>;
    /**
     * Frequency penalty is a number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim. Default is 0.7.
     */
    frequency_penalty?: (number) | null;
    /**
     * Set highlight_results to false for a slight latency improvement (1-10ms). If not specified, this defaults to true. This will add `<b><mark>` tags to the chunk_html of the chunks to highlight matching splits.
     */
    highlight_results?: (boolean) | null;
    /**
     * The maximum number of tokens to generate in the chat completion. Default is None.
     */
    max_tokens?: (number) | null;
    /**
     * Presence penalty is a number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics. Default is 0.7.
     */
    presence_penalty?: (number) | null;
    /**
     * The previous messages to be placed into the chat history. There must be at least one previous message.
     */
    prev_messages: Array<ChatMessageProxy>;
    /**
     * Prompt will be used to tell the model what to generate in the next message in the chat. The default is 'Respond to the previous instruction and include the doc numbers that you used in square brackets at the end of the sentences that you used the docs for:'. You can also specify an empty string to leave the final message alone such that your user's final message can be used as the prompt. See docs.trieve.ai or contact us for more information.
     */
    prompt?: (string) | null;
    /**
     * Stop tokens are up to 4 sequences where the API will stop generating further tokens. Default is None.
     */
    stop_tokens?: Array<(string)> | null;
    /**
     * Whether or not to stream the response. If this is set to true or not included, the response will be a stream. If this is set to false, the response will be a normal JSON response. Default is true.
     */
    stream_response?: (boolean) | null;
    /**
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. Default is 0.5.
     */
    temperature?: (number) | null;
    /**
     * User ID is the id of the user who is making the request. This is used to track user interactions with the RAG results.
     */
    user_id?: (string) | null;
};

/**
 * Location that you want to use as the center of the search.
 */
export type GeoInfo = {
    lat: GeoTypes;
    lon: GeoTypes;
};

/**
 * Location bias lets you rank your results by distance from a location. If not specified, this has no effect. Bias allows you to determine how much of an effect the location of chunks will have on the search results. If not specified, this defaults to 0.0. We recommend setting this to 1.0 for a gentle reranking of the results, >3.0 for a strong reranking of the results.
 */
export type GeoInfoWithBias = {
    /**
     * Bias lets you specify how much of an effect the location of chunks will have on the search results. If not specified, this defaults to 0.0. We recommend setting this to 1.0 for a gentle reranking of the results, >3.0 for a strong reranking of the results.
     */
    bias: number;
    location: GeoInfo;
};

export type GeoTypes = number;

export type GetAllTagsReqPayload = {
    /**
     * Page number to return, 1-indexed. Default is 1.
     */
    page?: (number) | null;
    /**
     * Number of items to return per page. Default is 20.
     */
    page_size?: (number) | null;
};

export type GetAllTagsResponse = {
    tags: Array<TagsWithCount>;
    total: number;
};

export type GetChunksData = {
    ids: Array<(string)>;
};

export type GetChunksInGroupResponse = GetChunksInGroupsResponseBody | GroupsBookmarkQueryResult;

export type GetChunksInGroupsResponseBody = {
    chunks: Array<ChunkMetadata>;
    group: ChunkGroupAndFileId;
    total_pages: number;
};

export type GetDatasetsPagination = {
    limit?: (number) | null;
    offset?: (number) | null;
};

export type GetEventsData = {
    /**
     * The types of events to get. Any combination of file_uploaded, chunk_uploaded, chunk_action_failed, chunk_updated, or qdrant_index_failed. Leave undefined to get all events.
     */
    event_types?: Array<EventTypeRequest> | null;
    /**
     * The page number to get. Default is 1.
     */
    page?: (number) | null;
    /**
     * The number of items per page. Default is 10.
     */
    page_size?: (number) | null;
};

export type GetGroupsForChunksReqPayload = {
    chunk_ids: Array<(string)>;
};

export type GetTopDatasetsRequestBody = {
    date_range?: ((DateRange) | null);
    type: TopDatasetsRequestTypes;
};

export type GetTrackingChunksData = {
    tracking_ids: Array<(string)>;
};

export type Granularity = 'minute' | 'second' | 'hour' | 'day';

export type GroupData = {
    groups: Array<ChunkGroupAndFileId>;
    total_pages: number;
};

export type GroupScoreChunk = {
    file_id?: (string) | null;
    group_created_at: string;
    group_dataset_id: string;
    group_description?: (string) | null;
    group_id: string;
    group_metadata?: unknown;
    group_name?: (string) | null;
    group_tag_set?: Array<((string) | null)> | null;
    group_tracking_id?: (string) | null;
    group_updated_at: string;
    metadata: Array<ScoreChunkDTO>;
};

export type GroupsBookmarkQueryResult = {
    chunks: Array<ChunkMetadataStringTagSet>;
    group: ChunkGroupAndFileId;
    total_pages: number;
};

export type GroupsForChunk = {
    chunk_uuid: string;
    slim_groups: Array<ChunkGroupAndFileId>;
};

export type HasIDCondition = {
    ids?: Array<(string)> | null;
    tracking_ids?: Array<(string)> | null;
};

export type HeadQueries = {
    count: number;
    query: string;
};

export type HeadQueryResponse = {
    queries: Array<HeadQueries>;
};

/**
 * Highlight Options lets you specify different methods to highlight the chunks in the result set. If not specified, this defaults to the score of the chunks.
 */
export type HighlightOptions = {
    /**
     * Set highlight_delimiters to a list of strings to use as delimiters for highlighting. If not specified, this defaults to ["?", ",", ".", "!"]. These are the characters that will be used to split the chunk_html into splits for highlighting. These are the characters that will be used to split the chunk_html into splits for highlighting.
     */
    highlight_delimiters?: Array<(string)> | null;
    /**
     * Set highlight_max_length to control the maximum number of tokens (typically whitespace separated strings, but sometimes also word stems) which can be present within a single highlight. If not specified, this defaults to 8. This is useful to shorten large splits which may have low scores due to length compared to the query. Set to something very large like 100 to highlight entire splits.
     */
    highlight_max_length?: (number) | null;
    /**
     * Set highlight_max_num to control the maximum number of highlights per chunk. If not specified, this defaults to 3. It may be less than 3 if no snippets score above the highlight_threshold.
     */
    highlight_max_num?: (number) | null;
    /**
     * Set highlight_results to false for a slight latency improvement (1-10ms). If not specified, this defaults to true. This will add `<b><mark>` tags to the chunk_html of the chunks to highlight matching splits and return the highlights on each scored chunk in the response.
     */
    highlight_results?: (boolean) | null;
    highlight_strategy?: ((HighlightStrategy) | null);
    /**
     * Set highlight_threshold to a lower or higher value to adjust the sensitivity of the highlights applied to the chunk html. If not specified, this defaults to 0.8. The range is 0.0 to 1.0.
     */
    highlight_threshold?: (number) | null;
    /**
     * Set highlight_window to a number to control the amount of words that are returned around the matched phrases. If not specified, this defaults to 0. This is useful for when you want to show more context around the matched words. When specified, window/2 whitespace separated words are added before and after each highlight in the response's highlights array. If an extended highlight overlaps with another highlight, the overlapping words are only included once. This parameter can be overriden to respect the highlight_max_length param.
     */
    highlight_window?: (number) | null;
};

export type HighlightStrategy = 'exactmatch' | 'v1';

export type InvitationData = {
    /**
     * The url of the app that the user will be directed to in order to set their password. Usually admin.trieve.ai, but may differ for local dev or self-hosted setups.
     */
    app_url: string;
    /**
     * The email of the user to invite. Must be a valid email as they will be sent an email to register.
     */
    email: string;
    /**
     * The id of the organization to invite the user to.
     */
    organization_id: string;
    /**
     * The url that the user will be redirected to after setting their password.
     */
    redirect_uri: string;
    /**
     * The role the user will have in the organization. 0 = User, 1 = Admin, 2 = Owner.
     */
    user_role: number;
};

/**
 * LLM options to use for the completion. If not specified, this defaults to the dataset's LLM options.
 */
export type LLMOptions = {
    /**
     * Completion first decides whether the stream should contain the stream of the completion response or the chunks first. Default is false. Keep in mind that || is used to separate the chunks from the completion response. If || is in the completion then you may want to split on ||{ instead.
     */
    completion_first?: (boolean) | null;
    /**
     * Frequency penalty is a number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim. Default is 0.7.
     */
    frequency_penalty?: (number) | null;
    /**
     * The maximum number of tokens to generate in the chat completion. Default is None.
     */
    max_tokens?: (number) | null;
    /**
     * Presence penalty is a number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics. Default is 0.7.
     */
    presence_penalty?: (number) | null;
    /**
     * Stop tokens are up to 4 sequences where the API will stop generating further tokens. Default is None.
     */
    stop_tokens?: Array<(string)> | null;
    /**
     * Whether or not to stream the response. If this is set to true or not included, the response will be a stream. If this is set to false, the response will be a normal JSON response. Default is true.
     */
    stream_response?: (boolean) | null;
    /**
     * Optionally, override the system prompt in dataset server settings.
     */
    system_prompt?: (string) | null;
    /**
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. Default is 0.5.
     */
    temperature?: (number) | null;
};

export type LatencyGraphResponse = {
    latency_points: Array<SearchLatencyGraph>;
};

export type LocationBoundingBox = {
    bottom_right: GeoInfo;
    top_left: GeoInfo;
};

export type LocationPolygon = {
    exterior: Array<GeoInfo>;
    interior?: Array<Array<GeoInfo>> | null;
};

export type LocationRadius = {
    center: GeoInfo;
    radius: number;
};

export type MatchCondition = string | number;

export type Message = {
    completion_tokens?: (number) | null;
    content: string;
    created_at: string;
    dataset_id: string;
    deleted: boolean;
    id: string;
    prompt_tokens?: (number) | null;
    role: string;
    sort_order: number;
    topic_id: string;
    updated_at: string;
};

/**
 * MultiQuery allows you to construct a dense vector from multiple queries with a weighted sum. This is useful for when you want to emphasize certain features of the query. This only works with Semantic Search and is not compatible with cross encoder re-ranking or highlights.
 */
export type MultiQuery = {
    /**
     * Query to embed for the final weighted sum vector.
     */
    query: string;
    /**
     * Float value which is applies as a multiplier to the query vector when summing.
     */
    weight: number;
};

export type NewChunkMetadataTypes = SlimChunkMetadataWithArrayTagSet | ChunkMetadata | ContentChunkMetadata;

export type Organization = {
    created_at: string;
    deleted: number;
    id: string;
    name: string;
    registerable?: (boolean) | null;
    updated_at: string;
};

export type OrganizationUsageCount = {
    chunk_count: number;
    dataset_count: number;
    file_storage: number;
    id: string;
    message_count: number;
    org_id: string;
    user_count: number;
};

export type PopularFilters = {
    clause: string;
    common_values: {
        [key: string]: (number);
    };
    count: number;
    field: string;
    filter_type: string;
};

export type PopularFiltersResponse = {
    popular_filters: Array<PopularFilters>;
};

/**
 * Sort by lets you specify a method to sort the results by. If not specified, this defaults to the score of the chunks. If specified, this can be any key in the chunk metadata. This key must be a numeric value within the payload.
 */
export type QdrantSortBy = SortByField | SortBySearchType;

export type QueryCountResponse = {
    total_queries: Array<SearchTypeCount>;
};

/**
 * Query is the search query. This can be any string. The query will be used to create an embedding vector and/or SPLADE vector which will be used to find the result set.  You can either provide one query, or multiple with weights. Multi-query only works with Semantic Search and is not compatible with cross encoder re-ranking or highlights.
 */
export type QueryTypes = string | Array<MultiQuery>;

export type RAGAnalytics = {
    filter?: ((RAGAnalyticsFilter) | null);
    page?: (number) | null;
    sort_by?: ((RAGSortBy) | null);
    sort_order?: ((SortOrder) | null);
    type: 'rag_queries';
} | {
    filter?: ((RAGAnalyticsFilter) | null);
    type: 'rag_usage';
} | {
    filter?: ((RAGAnalyticsFilter) | null);
    granularity?: ((Granularity) | null);
    type: 'rag_usage_graph';
};

export type type3 = 'rag_queries';

export type RAGAnalyticsFilter = {
    date_range?: ((DateRange) | null);
    rag_type?: ((RagTypes) | null);
};

export type RAGAnalyticsResponse = RagQueryResponse | RAGUsageResponse | RAGUsageGraphResponse;

export type RAGSortBy = 'created_at' | 'latency';

export type RAGUsageGraphResponse = {
    usage_points: Array<UsageGraphPoint>;
};

export type RAGUsageResponse = {
    total_queries: number;
};

export type RagQueryEvent = {
    created_at: string;
    dataset_id: string;
    id: string;
    rag_type: string;
    results: Array<ChunkMetadataStringTagSet>;
    search_id: string;
    user_id: string;
    user_message: string;
};

export type RagQueryResponse = {
    queries: Array<RagQueryEvent>;
};

export type RagTypes = 'chosen_chunks' | 'all_chunks';

export type Range = {
    gt?: ((RangeCondition) | null);
    gte?: ((RangeCondition) | null);
    lt?: ((RangeCondition) | null);
    lte?: ((RangeCondition) | null);
};

export type RangeCondition = number;

export type RateQueryRequest = {
    note?: (string) | null;
    query_id: string;
    rating: number;
};

export type ReRankOptions = 'semantic' | 'fulltext' | 'bm25' | 'cross_encoder';

export type RecommendChunksRequest = {
    filters?: ((ChunkFilter) | null);
    /**
     * The number of chunks to return. This is the number of chunks which will be returned in the response. The default is 10.
     */
    limit?: (number) | null;
    /**
     * The ids of the chunks to be used as negative examples for the recommendation. The chunks in this array will be used to filter out similar chunks.
     */
    negative_chunk_ids?: Array<(string)> | null;
    /**
     * The tracking_ids of the chunks to be used as negative examples for the recommendation. The chunks in this array will be used to filter out similar chunks.
     */
    negative_tracking_ids?: Array<(string)> | null;
    /**
     * The ids of the chunks to be used as positive examples for the recommendation. The chunks in this array will be used to find similar chunks.
     */
    positive_chunk_ids?: Array<(string)> | null;
    /**
     * The tracking_ids of the chunks to be used as positive examples for the recommendation. The chunks in this array will be used to find similar chunks.
     */
    positive_tracking_ids?: Array<(string)> | null;
    recommend_type?: ((RecommendType) | null);
    /**
     * Set slim_chunks to true to avoid returning the content and chunk_html of the chunks. This is useful for when you want to reduce amount of data over the wire for latency improvement (typicall 10-50ms). Default is false.
     */
    slim_chunks?: (boolean) | null;
    strategy?: ((RecommendationStrategy) | null);
    /**
     * User ID is the id of the user who is making the request. This is used to track user interactions with the recommendation results.
     */
    user_id?: (string) | null;
};

export type RecommendChunksResponseBody = {
    chunks: Array<ScoreChunk>;
    id: string;
};

export type RecommendGroupsReqPayload = {
    filters?: ((ChunkFilter) | null);
    /**
     * The number of chunks to fetch for each group. This is the number of chunks which will be returned in the response for each group. The default is 3. If this is set to a large number, we recommend setting slim_chunks to true to avoid returning the content and chunk_html of the chunks so as to reduce latency due to content download and serialization.
     */
    group_size?: (number) | null;
    /**
     * The number of groups to return. This is the number of groups which will be returned in the response. The default is 10.
     */
    limit?: (number) | null;
    /**
     * The ids of the groups to be used as negative examples for the recommendation. The groups in this array will be used to filter out similar groups.
     */
    negative_group_ids?: Array<(string)> | null;
    /**
     * The ids of the groups to be used as negative examples for the recommendation. The groups in this array will be used to filter out similar groups.
     */
    negative_group_tracking_ids?: Array<(string)> | null;
    /**
     * The ids of the groups to be used as positive examples for the recommendation. The groups in this array will be used to find similar groups.
     */
    positive_group_ids?: Array<(string)> | null;
    /**
     * The ids of the groups to be used as positive examples for the recommendation. The groups in this array will be used to find similar groups.
     */
    positive_group_tracking_ids?: Array<(string)> | null;
    recommend_type?: ((RecommendType) | null);
    /**
     * Set slim_chunks to true to avoid returning the content and chunk_html of the chunks. This is useful for when you want to reduce amount of data over the wire for latency improvement (typicall 10-50ms). Default is false.
     */
    slim_chunks?: (boolean) | null;
    strategy?: ((RecommendationStrategy) | null);
    /**
     * The user_id is the id of the user who is making the request. This is used to track user interactions with the rrecommendation results.
     */
    user_id?: (string) | null;
};

export type RecommendGroupsResponse = RecommendGroupsResponseBody | GroupScoreChunk;

export type RecommendGroupsResponseBody = {
    id: string;
    results: Array<SearchOverGroupsResults>;
};

export type RecommendResponseTypes = RecommendChunksResponseBody | Array<ChunkMetadataWithScore>;

/**
 * The type of recommendation to make. This lets you choose whether to recommend based off of `semantic` or `fulltext` similarity. The default is `semantic`.
 */
export type RecommendType = 'semantic' | 'fulltext' | 'bm25';

export type RecommendationAnalytics = {
    filter?: ((RecommendationAnalyticsFilter) | null);
    page?: (number) | null;
    threshold?: (number) | null;
    type: 'low_confidence_recommendations';
} | {
    filter?: ((RecommendationAnalyticsFilter) | null);
    page?: (number) | null;
    sort_by?: ((SearchSortBy) | null);
    sort_order?: ((SortOrder) | null);
    type: 'recommendation_queries';
};

export type type4 = 'low_confidence_recommendations';

export type RecommendationAnalyticsFilter = {
    date_range?: ((DateRange) | null);
    recommendation_type?: ((RecommendationType) | null);
};

export type RecommendationAnalyticsResponse = RecommendationsEventResponse;

export type RecommendationCTRMetrics = {
    avg_position_of_click: number;
    percent_recommendations_with_clicks: number;
    percent_recommendations_without_clicks: number;
    recommendations_with_clicks: number;
};

export type RecommendationEvent = {
    created_at: string;
    dataset_id: string;
    id: string;
    negative_ids: Array<(string)>;
    negative_tracking_ids: Array<(string)>;
    positive_ids: Array<(string)>;
    positive_tracking_ids: Array<(string)>;
    recommendation_type: string;
    request_params: unknown;
    results: Array<unknown>;
    top_score: number;
    user_id: string;
};

/**
 * Strategy to use for recommendations, either "average_vector" or "best_score". The default is "average_vector". The "average_vector" strategy will construct a single average vector from the positive and negative samples then use it to perform a pseudo-search. The "best_score" strategy is more advanced and navigates the HNSW with a heuristic of picking edges where the point is closer to the positive samples than it is the negatives.
 */
export type RecommendationStrategy = 'average_vector' | 'best_score';

export type RecommendationType = 'Chunk' | 'Group';

export type RecommendationsEventResponse = {
    queries: Array<RecommendationEvent>;
};

export type RecommendationsWithClicksCTRResponse = {
    clicked_chunks: Array<ChunkMetadata>;
    created_at: string;
    negative_ids?: Array<(string)> | null;
    negative_tracking_ids?: Array<(string)> | null;
    positions: Array<(number)>;
    positive_ids?: Array<(string)> | null;
    positive_tracking_ids?: Array<(string)> | null;
};

export type RecommendationsWithoutClicksCTRResponse = {
    created_at: string;
    negative_ids?: Array<(string)> | null;
    negative_tracking_ids?: Array<(string)> | null;
    positive_ids?: Array<(string)> | null;
    positive_tracking_ids?: Array<(string)> | null;
};

export type RegenerateMessageReqPayload = {
    /**
     * If concat user messages query is set to true, all of the user messages in the topic will be concatenated together and used as the search query. If not specified, this defaults to false. Default is false.
     */
    concat_user_messages_query?: (boolean) | null;
    filters?: ((ChunkFilter) | null);
    highlight_options?: ((HighlightOptions) | null);
    llm_options?: ((LLMOptions) | null);
    /**
     * Page size is the number of chunks to fetch during RAG. If 0, then no search will be performed. If specified, this will override the N retrievals to include in the dataset configuration. Default is None.
     */
    page_size?: (number) | null;
    /**
     * Set score_threshold to a float to filter out chunks with a score below the threshold. This threshold applies before weight and bias modifications. If not specified, this defaults to 0.0.
     */
    score_threshold?: (number) | null;
    /**
     * Query is the search query. This can be any string. The search_query will be used to create a dense embedding vector and/or sparse vector which will be used to find the result set. If not specified, will default to the last user message or HyDE if HyDE is enabled in the dataset configuration. Default is None.
     */
    search_query?: (string) | null;
    search_type?: ((SearchMethod) | null);
    /**
     * The id of the topic to regenerate the last message for.
     */
    topic_id: string;
    /**
     * The user_id is the id of the user who is making the request. This is used to track user interactions with the RAG results.
     */
    user_id?: (string) | null;
};

export type RemoveChunkFromGroupReqPayload = {
    /**
     * Id of the chunk to remove from the group.
     */
    chunk_id: string;
};

export type ReturnQueuedChunk = SingleQueuedChunkResponse | BatchQueuedChunkResponse;

export type RoleProxy = 'system' | 'user' | 'assistant';

export type ScoreChunk = {
    chunk: NewChunkMetadataTypes;
    highlights?: Array<(string)> | null;
    score: number;
};

export type ScoreChunkDTO = {
    highlights?: Array<(string)> | null;
    metadata: Array<ChunkMetadataTypes>;
    score: number;
};

/**
 * Scoring options provides ways to modify the sparse or dense vector created for the query in order to change how potential matches are scored. If not specified, this defaults to no modifications.
 */
export type ScoringOptions = {
    fulltext_boost?: ((FullTextBoost) | null);
    semantic_boost?: ((SemanticBoost) | null);
};

export type ScrollChunksReqPayload = {
    filters?: ((ChunkFilter) | null);
    /**
     * Offset chunk id is the id of the chunk to start the page from. If not specified, this defaults to the first chunk in the dataset sorted by id ascending.
     */
    offset_chunk_id?: (string) | null;
    /**
     * Page size is the number of chunks to fetch. This can be used to fetch more than 10 chunks at a time.
     */
    page_size?: (number) | null;
    sort_by?: ((SortByField) | null);
};

export type ScrollChunksResponseBody = {
    chunks: Array<ChunkMetadata>;
};

export type SearchAnalytics = {
    filter?: ((SearchAnalyticsFilter) | null);
    granularity?: ((Granularity) | null);
    type: 'latency_graph';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    granularity?: ((Granularity) | null);
    type: 'search_usage_graph';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    type: 'search_metrics';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    page?: (number) | null;
    type: 'head_queries';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    page?: (number) | null;
    threshold?: (number) | null;
    type: 'low_confidence_queries';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    page?: (number) | null;
    type: 'no_result_queries';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    page?: (number) | null;
    sort_by?: ((SearchSortBy) | null);
    sort_order?: ((SortOrder) | null);
    type: 'search_queries';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    type: 'count_queries';
} | {
    search_id: string;
    type: 'query_details';
} | {
    filter?: ((SearchAnalyticsFilter) | null);
    type: 'popular_filters';
};

export type type5 = 'latency_graph';

export type SearchAnalyticsFilter = {
    date_range?: ((DateRange) | null);
    search_method?: ((SearchMethod) | null);
    search_type?: ((SearchType) | null);
};

export type SearchAnalyticsResponse = LatencyGraphResponse | SearchUsageGraphResponse | DatasetAnalytics | HeadQueryResponse | SearchQueryResponse | QueryCountResponse | SearchQueryEvent | PopularFiltersResponse;

export type SearchCTRMetrics = {
    avg_position_of_click: number;
    percent_searches_with_clicks: number;
    percent_searches_without_clicks: number;
    searches_with_clicks: number;
};

export type SearchChunkQueryResponseBody = {
    corrected_query?: (string) | null;
    score_chunks: Array<ScoreChunkDTO>;
    total_chunk_pages: number;
};

export type SearchChunksReqPayload = {
    /**
     * Set content_only to true to only returning the chunk_html of the chunks. This is useful for when you want to reduce amount of data over the wire for latency improvement (typically 10-50ms). Default is false.
     */
    content_only?: (boolean) | null;
    filters?: ((ChunkFilter) | null);
    /**
     * Get total page count for the query accounting for the applied filters. Defaults to false, but can be set to true when the latency penalty is acceptable (typically 50-200ms).
     */
    get_total_pages?: (boolean) | null;
    highlight_options?: ((HighlightOptions) | null);
    /**
     * Page of chunks to fetch. Page is 1-indexed.
     */
    page?: (number) | null;
    /**
     * Page size is the number of chunks to fetch. This can be used to fetch more than 10 chunks at a time.
     */
    page_size?: (number) | null;
    query: QueryTypes;
    /**
     * If true, stop words (specified in server/src/stop-words.txt in the git repo) will be removed. Queries that are entirely stop words will be preserved.
     */
    remove_stop_words?: (boolean) | null;
    /**
     * Set score_threshold to a float to filter out chunks with a score below the threshold for cosine distance metric. For Manhattan Distance, Euclidean Distance, and Dot Product, it will filter out scores above the threshold distance. This threshold applies before weight and bias modifications. If not specified, this defaults to no threshold. A threshold of 0 will default to no threshold.
     */
    score_threshold?: (number) | null;
    scoring_options?: ((ScoringOptions) | null);
    search_type: SearchMethod;
    /**
     * Set slim_chunks to true to avoid returning the content and chunk_html of the chunks. This is useful for when you want to reduce amount of data over the wire for latency improvement (typically 10-50ms). Default is false.
     */
    slim_chunks?: (boolean) | null;
    sort_options?: ((SortOptions) | null);
    typo_options?: ((TypoOptions) | null);
    /**
     * If true, quoted and - prefixed words will be parsed from the queries and used as required and negated words respectively. Default is false.
     */
    use_quote_negated_terms?: (boolean) | null;
    /**
     * User ID is the id of the user who is making the request. This is used to track user interactions with the search results.
     */
    user_id?: (string) | null;
};

export type SearchClusterResponse = {
    clusters: Array<SearchClusterTopics>;
};

export type SearchClusterTopics = {
    avg_score: number;
    created_at: string;
    dataset_id: string;
    density: number;
    id: string;
    topic: string;
};

export type SearchGroupResponseTypes = SearchWithinGroupResponseBody | SearchWithinGroupResults;

export type SearchLatencyGraph = {
    average_latency: number;
    time_stamp: string;
};

export type SearchMethod = 'fulltext' | 'semantic' | 'hybrid' | 'bm25';

export type SearchOverGroupsReqPayload = {
    filters?: ((ChunkFilter) | null);
    /**
     * Get total page count for the query accounting for the applied filters. Defaults to false, but can be set to true when the latency penalty is acceptable (typically 50-200ms).
     */
    get_total_pages?: (boolean) | null;
    /**
     * Group_size is the number of chunks to fetch for each group. The default is 3. If a group has less than group_size chunks, all chunks will be returned. If this is set to a large number, we recommend setting slim_chunks to true to avoid returning the content and chunk_html of the chunks so as to lower the amount of time required for content download and serialization.
     */
    group_size?: (number) | null;
    highlight_options?: ((HighlightOptions) | null);
    /**
     * Page of group results to fetch. Page is 1-indexed.
     */
    page?: (number) | null;
    /**
     * Page size is the number of group results to fetch. The default is 10.
     */
    page_size?: (number) | null;
    query: QueryTypes;
    /**
     * If true, stop words (specified in server/src/stop-words.txt in the git repo) will be removed. Queries that are entirely stop words will be
     * preserved.
     */
    remove_stop_words?: (boolean) | null;
    /**
     * Set score_threshold to a float to filter out chunks with a score below the threshold. This threshold applies before weight and bias modifications. If not specified, this defaults to 0.0.
     */
    score_threshold?: (number) | null;
    search_type: SearchMethod;
    /**
     * Set slim_chunks to true to avoid returning the content and chunk_html of the chunks. This is useful for when you want to reduce amount of data over the wire for latency improvement (typicall 10-50ms). Default is false.
     */
    slim_chunks?: (boolean) | null;
    typo_options?: ((TypoOptions) | null);
    /**
     * If true, quoted and - prefixed words will be parsed from the queries and used as required and negated words respectively. Default is false.
     */
    use_quote_negated_terms?: (boolean) | null;
    /**
     * The user_id is the id of the user who is making the request. This is used to track user interactions with the search results.
     */
    user_id?: (string) | null;
};

export type SearchOverGroupsResponseBody = {
    corrected_query?: (string) | null;
    id: string;
    results: Array<SearchOverGroupsResults>;
    total_pages: number;
};

export type SearchOverGroupsResponseTypes = SearchOverGroupsResponseBody | DeprecatedSearchOverGroupsResponseBody;

export type SearchOverGroupsResults = {
    chunks: Array<ScoreChunk>;
    file_id?: (string) | null;
    group: ChunkGroup;
};

export type SearchQueriesWithClicksCTRResponse = {
    clicked_chunks: Array<ChunkMetadata>;
    created_at: string;
    positions: Array<(number)>;
    query: string;
};

export type SearchQueriesWithoutClicksCTRResponse = {
    created_at: string;
    query: string;
};

export type SearchQueryEvent = {
    created_at: string;
    dataset_id: string;
    id: string;
    latency: number;
    query: string;
    query_rating: string;
    request_params: unknown;
    results: Array<unknown>;
    search_type: string;
    top_score: number;
    user_id: string;
};

export type SearchQueryResponse = {
    queries: Array<SearchQueryEvent>;
};

export type SearchResponseBody = {
    chunks: Array<ScoreChunk>;
    corrected_query?: (string) | null;
    id: string;
    total_pages: number;
};

export type SearchResponseTypes = SearchResponseBody | SearchChunkQueryResponseBody;

export type SearchResultType = ScoreChunkDTO | GroupScoreChunk;

export type SearchSortBy = 'created_at' | 'latency' | 'top_score';

export type SearchType = 'search' | 'autocomplete' | 'search_over_groups' | 'search_within_groups';

export type SearchTypeCount = {
    search_count: number;
    search_method: string;
    search_type: string;
};

export type SearchUsageGraphResponse = {
    usage_points: Array<UsageGraphPoint>;
};

export type SearchWithinGroupReqPayload = {
    /**
     * Set content_only to true to only returning the chunk_html of the chunks. This is useful for when you want to reduce amount of data over the wire for latency improvement (typically 10-50ms). Default is false.
     */
    content_only?: (boolean) | null;
    filters?: ((ChunkFilter) | null);
    /**
     * Get total page count for the query accounting for the applied filters. Defaults to false, but can be set to true when the latency penalty is acceptable (typically 50-200ms).
     */
    get_total_pages?: (boolean) | null;
    /**
     * Group specifies the group to search within. Results will only consist of chunks which are bookmarks within the specified group.
     */
    group_id?: (string) | null;
    /**
     * Group_tracking_id specifies the group to search within by tracking id. Results will only consist of chunks which are bookmarks within the specified group. If both group_id and group_tracking_id are provided, group_id will be used.
     */
    group_tracking_id?: (string) | null;
    highlight_options?: ((HighlightOptions) | null);
    /**
     * The page of chunks to fetch. Page is 1-indexed.
     */
    page?: (number) | null;
    /**
     * The page size is the number of chunks to fetch. This can be used to fetch more than 10 chunks at a time.
     */
    page_size?: (number) | null;
    query: QueryTypes;
    /**
     * If true, stop words (specified in server/src/stop-words.txt in the git repo) will be removed. Queries that are entirely stop words will be preserved.
     */
    remove_stop_words?: (boolean) | null;
    /**
     * Set score_threshold to a float to filter out chunks with a score below the threshold. This threshold applies before weight and bias modifications. If not specified, this defaults to 0.0.
     */
    score_threshold?: (number) | null;
    search_type: SearchMethod;
    /**
     * Set slim_chunks to true to avoid returning the content and chunk_html of the chunks. This is useful for when you want to reduce amount of data over the wire for latency improvement (typicall 10-50ms). Default is false.
     */
    slim_chunks?: (boolean) | null;
    sort_options?: ((SortOptions) | null);
    typo_options?: ((TypoOptions) | null);
    /**
     * If true, quoted and - prefixed words will be parsed from the queries and used as required and negated words respectively. Default is false.
     */
    use_quote_negated_terms?: (boolean) | null;
    /**
     * The user_id is the id of the user who is making the request. This is used to track user interactions with the search results.
     */
    user_id?: (string) | null;
};

export type SearchWithinGroupResponseBody = {
    chunks: Array<ScoreChunk>;
    corrected_query?: (string) | null;
    id: string;
    total_pages: number;
};

export type SearchWithinGroupResults = {
    bookmarks: Array<ScoreChunkDTO>;
    corrected_query?: (string) | null;
    group: ChunkGroupAndFileId;
    total_pages: number;
};

/**
 * Distance phrase is useful for moving the embedding vector of the chunk in the direction of the distance phrase. I.e. you can push a chunk with a chunk_html of "iphone" 25% closer to the term "flagship" by using the distance phrase "flagship" and a distance factor of 0.25. Conceptually it's drawing a line (euclidean/L2 distance) between the vector for the innerText of the chunk_html and distance_phrase then moving the vector of the chunk_html distance_factor*L2Distance closer to or away from the distance_phrase point along the line between the two points.
 */
export type SemanticBoost = {
    /**
     * Arbitrary float (positive or negative) specifying the multiplicate factor to apply before summing the phrase vector with the chunk_html embedding vector
     */
    distance_factor: number;
    /**
     * Terms to embed in order to create the vector which is weighted summed with the chunk_html embedding vector
     */
    phrase: string;
};

export type SetUserApiKeyRequest = {
    /**
     * The dataset ids which the api key will have access to. If not provided or empty, the api key will have access to all datasets the auth'ed user has access to. If both dataset_ids and organization_ids are provided, the api key will have access to the intersection of the datasets and organizations.
     */
    dataset_ids?: Array<(string)> | null;
    /**
     * The name which will be assigned to the new api key.
     */
    name: string;
    /**
     * The organization ids which the api key will have access to. If not provided or empty, the api key will have access to all organizations the auth'ed user has access to.
     */
    organization_ids?: Array<(string)> | null;
    /**
     * The role which will be assigned to the new api key. Either 0 (read), 1 (read and write at the level of the currently auth'ed user). The auth'ed user must have a role greater than or equal to the role being assigned which means they must be an admin (1) or owner (2) of the organization to assign write permissions with a role of 1.
     */
    role: number;
    /**
     * The routes which the api key will have access to. If not provided or empty, the api key will have access to all routes the auth'ed user has access to. Specify the routes as a list of strings. For example, ["GET /api/dataset", "POST /api/dataset"].
     */
    scopes?: Array<(string)> | null;
};

export type SetUserApiKeyResponse = {
    /**
     * The api key which was created. This is the value which should be used in the Authorization header.
     */
    api_key: string;
};

export type SingleQueuedChunkResponse = {
    chunk_metadata: ChunkMetadata;
    /**
     * The current position the last access item is in the queue
     */
    pos_in_queue: number;
};

export type SlimChunkMetadata = {
    created_at: string;
    dataset_id: string;
    id: string;
    image_urls?: Array<((string) | null)> | null;
    link?: (string) | null;
    location?: ((GeoInfo) | null);
    metadata?: unknown;
    num_value?: (number) | null;
    tag_set?: (string) | null;
    time_stamp?: (string) | null;
    tracking_id?: (string) | null;
    updated_at: string;
    weight: number;
};

export type SlimChunkMetadataWithArrayTagSet = {
    created_at: string;
    dataset_id: string;
    id: string;
    image_urls?: Array<((string) | null)> | null;
    link?: (string) | null;
    location?: ((GeoInfo) | null);
    metadata?: unknown;
    num_value?: (number) | null;
    tag_set?: Array<(string)> | null;
    time_stamp?: (string) | null;
    tracking_id?: (string) | null;
    updated_at: string;
    weight: number;
};

export type SlimChunkMetadataWithScore = {
    created_at: string;
    id: string;
    link?: (string) | null;
    metadata?: unknown;
    score: number;
    tag_set?: (string) | null;
    time_stamp?: (string) | null;
    tracking_id?: (string) | null;
    updated_at: string;
    weight: number;
};

export type SlimUser = {
    email: string;
    id: string;
    name?: (string) | null;
    orgs: Array<Organization>;
    user_orgs: Array<UserOrganization>;
};

export type SortByField = {
    direction?: ((SortOrder) | null);
    /**
     * Field to sort by. This has to be a numeric field with a Qdrant `Range` index on it. i.e. num_value and timestamp
     */
    field: string;
    /**
     * How many results to pull in before the sort
     */
    prefetch_amount?: (number) | null;
};

export type SortBySearchType = {
    /**
     * How many results to pull in before the rerabj
     */
    prefetch_amount?: (number) | null;
    /**
     * Query to use for prefetching defaults to the search query
     */
    rerank_query?: (string) | null;
    rerank_type: ReRankOptions;
};

/**
 * Sort Options lets you specify different methods to rerank the chunks in the result set. If not specified, this defaults to the score of the chunks.
 */
export type SortOptions = {
    location_bias?: ((GeoInfoWithBias) | null);
    sort_by?: ((QdrantSortBy) | null);
    /**
     * Tag weights is a JSON object which can be used to boost the ranking of chunks with certain tags. This is useful for when you want to be able to bias towards chunks with a certain tag on the fly. The keys are the tag names and the values are the weights.
     */
    tag_weights?: {
        [key: string]: (number);
    } | null;
    /**
     * Set use_weights to true to use the weights of the chunks in the result set in order to sort them. If not specified, this defaults to true.
     */
    use_weights?: (boolean) | null;
};

export type SortOrder = 'desc' | 'asc';

export type StripeInvoice = {
    created_at: string;
    hosted_invoice_url: string;
    id: string;
    org_id: string;
    status: string;
    stripe_id?: (string) | null;
    total: number;
};

export type StripePlan = {
    amount: number;
    chunk_count: number;
    created_at: string;
    dataset_count: number;
    file_storage: number;
    id: string;
    message_count: number;
    name: string;
    stripe_id: string;
    updated_at: string;
    user_count: number;
};

export type SuggestType = 'question' | 'keyword' | 'semantic';

export type SuggestedQueriesReqPayload = {
    /**
     * Context is the context of the query. This can be any string under 15 words and 200 characters. The context will be used to generate the suggested queries. Defaults to None.
     */
    context?: (string) | null;
    filters?: ((ChunkFilter) | null);
    /**
     * The query to base the generated suggested queries off of using RAG. A hybrid search for 10 chunks from your dataset using this query will be performed and the context of the chunks will be used to generate the suggested queries.
     */
    query?: (string) | null;
    search_type?: ((SearchMethod) | null);
    suggestion_type?: ((SuggestType) | null);
};

export type SuggestedQueriesResponse = {
    queries: Array<(string)>;
};

export type TagsWithCount = {
    count: number;
    tag: string;
};

export type TopDatasetsRequestTypes = 'search' | 'rag' | 'recommendation';

export type TopDatasetsResponse = {
    dataset_id: string;
    dataset_tracking_id?: (string) | null;
    total_queries: number;
};

export type Topic = {
    created_at: string;
    dataset_id: string;
    deleted: boolean;
    id: string;
    name: string;
    owner_id: string;
    updated_at: string;
};

/**
 * Typo Options lets you specify different methods to correct typos in the query. If not specified, typos will not be corrected.
 */
export type TypoOptions = {
    /**
     * Set correct_typos to true to correct typos in the query. If not specified, this defaults to false.
     */
    correct_typos?: (boolean) | null;
    /**
     * Words that should not be corrected. If not specified, this defaults to an empty list.
     */
    disable_on_word?: Array<(string)> | null;
    one_typo_word_range?: ((TypoRange) | null);
    two_typo_word_range?: ((TypoRange) | null);
};

/**
 * The TypoRange struct is used to specify the range of which the query will be corrected if it has a typo.
 */
export type TypoRange = {
    /**
     * The maximum number of characters that the query will be corrected if it has a typo. If not specified, this defaults to 8.
     */
    max?: (number) | null;
    /**
     * The minimum number of characters that the query will be corrected if it has a typo. If not specified, this defaults to 5.
     */
    min: number;
};

export type UpdateAllOrgDatasetConfigsReqPayload = {
    /**
     * The new configuration for all datasets in the organization. Only the specified keys in the configuration object will be changed per dataset such that you can preserve dataset unique values.
     */
    dataset_config: unknown;
    /**
     * The id of the organization to update the dataset configurations for.
     */
    organization_id: string;
};

export type UpdateChunkByTrackingIdData = {
    /**
     * HTML content of the chunk you want to update. This can also be plaintext. The innerText of the HTML will be used to create the embedding vector. The point of using HTML is for convienience, as some users have applications where users submit HTML content. If no chunk_html is provided, the existing chunk_html will be used.
     */
    chunk_html?: (string) | null;
    /**
     * Convert HTML to raw text before processing to avoid adding noise to the vector embeddings. By default this is true. If you are using HTML content that you want to be included in the vector embeddings, set this to false.
     */
    convert_html_to_text?: (boolean) | null;
    /**
     * Group ids are the ids of the groups that the chunk should be placed into. This is useful for when you want to update a chunk and add it to a group or multiple groups in one request.
     */
    group_ids?: Array<(string)> | null;
    /**
     * Group tracking_ids are the tracking_ids of the groups that the chunk should be placed into. This is useful for when you want to update a chunk and add it to a group or multiple groups in one request.
     */
    group_tracking_ids?: Array<(string)> | null;
    /**
     * Link of the chunk you want to update. This can also be any string. Frequently, this is a link to the source of the chunk. The link value will not affect the embedding creation. If no link is provided, the existing link will be used.
     */
    link?: (string) | null;
    /**
     * The metadata is a JSON object which can be used to filter chunks. This is useful for when you want to filter chunks by arbitrary metadata. Unlike with tag filtering, there is a performance hit for filtering on metadata. If no metadata is provided, the existing metadata will be used.
     */
    metadata?: unknown;
    /**
     * Time_stamp should be an ISO 8601 combined date and time without timezone. It is used for time window filtering and recency-biasing search results. If no time_stamp is provided, the existing time_stamp will be used.
     */
    time_stamp?: (string) | null;
    /**
     * Tracking_id of the chunk you want to update. This is required to match an existing chunk.
     */
    tracking_id: string;
    /**
     * Weight is a float which can be used to bias search results. This is useful for when you want to bias search results for a chunk. The magnitude only matters relative to other chunks in the chunk's dataset dataset. If no weight is provided, the existing weight will be used.
     */
    weight?: (number) | null;
};

export type UpdateChunkGroupReqPayload = {
    /**
     * Description to assign to the chunk_group. Convenience field for you to avoid having to remember what the group is for. If not provided, the description will not be updated.
     */
    description?: (string) | null;
    /**
     * Id of the chunk_group to update.
     */
    group_id?: (string) | null;
    /**
     * Optional metadata to assign to the chunk_group. This is a JSON object that can store any additional information you want to associate with the chunks inside of the chunk_group.
     */
    metadata?: unknown;
    /**
     * Name to assign to the chunk_group. Does not need to be unique. If not provided, the name will not be updated.
     */
    name?: (string) | null;
    /**
     * Optional tags to assign to the chunk_group. This is a list of strings that can be used to categorize the chunks inside the chunk_group.
     */
    tag_set?: Array<(string)> | null;
    /**
     * Tracking Id of the chunk_group to update.
     */
    tracking_id?: (string) | null;
    /**
     * Flag to update the chunks in the group. If true, each chunk in the group will be updated
     * by appending the group's tags to the chunk's tags. Default is false.
     */
    update_chunks?: (boolean) | null;
};

export type UpdateChunkReqPayload = {
    /**
     * HTML content of the chunk you want to update. This can also be plaintext. The innerText of the HTML will be used to create the embedding vector. The point of using HTML is for convienience, as some users have applications where users submit HTML content. If no chunk_html is provided, the existing chunk_html will be used.
     */
    chunk_html?: (string) | null;
    /**
     * Id of the chunk you want to update. You can provide either the chunk_id or the tracking_id. If both are provided, the chunk_id will be used.
     */
    chunk_id?: (string) | null;
    /**
     * Convert HTML to raw text before processing to avoid adding noise to the vector embeddings. By default this is true. If you are using HTML content that you want to be included in the vector embeddings, set this to false.
     */
    convert_html_to_text?: (boolean) | null;
    fulltext_boost?: ((FullTextBoost) | null);
    /**
     * Group ids are the ids of the groups that the chunk should be placed into. This is useful for when you want to update a chunk and add it to a group or multiple groups in one request.
     */
    group_ids?: Array<(string)> | null;
    /**
     * Group tracking_ids are the tracking_ids of the groups that the chunk should be placed into. This is useful for when you want to update a chunk and add it to a group or multiple groups in one request.
     */
    group_tracking_ids?: Array<(string)> | null;
    /**
     * Image urls are a list of urls to images that are associated with the chunk. This is useful for when you want to associate images with a chunk. If no image_urls are provided, the existing image_urls will be used.
     */
    image_urls?: Array<(string)> | null;
    /**
     * Link of the chunk you want to update. This can also be any string. Frequently, this is a link to the source of the chunk. The link value will not affect the embedding creation. If no link is provided, the existing link will be used.
     */
    link?: (string) | null;
    location?: ((GeoInfo) | null);
    /**
     * The metadata is a JSON object which can be used to filter chunks. This is useful for when you want to filter chunks by arbitrary metadata. Unlike with tag filtering, there is a performance hit for filtering on metadata. If no metadata is provided, the existing metadata will be used.
     */
    metadata?: unknown;
    /**
     * Num value is an arbitrary numerical value that can be used to filter chunks. This is useful for when you want to filter chunks by numerical value. If no num_value is provided, the existing num_value will be used.
     */
    num_value?: (number) | null;
    semantic_boost?: ((SemanticBoost) | null);
    /**
     * Tag set is a list of tags. This can be used to filter chunks by tag. Unlike with metadata filtering, HNSW indices will exist for each tag such that there is not a performance hit for filtering on them. If no tag_set is provided, the existing tag_set will be used.
     */
    tag_set?: Array<(string)> | null;
    /**
     * Time_stamp should be an ISO 8601 combined date and time without timezone. It is used for time window filtering and recency-biasing search results. If no time_stamp is provided, the existing time_stamp will be used.
     */
    time_stamp?: (string) | null;
    /**
     * Tracking_id of the chunk you want to update. This is required to match an existing chunk.
     */
    tracking_id?: (string) | null;
    /**
     * Weight is a float which can be used to bias search results. This is useful for when you want to bias search results for a chunk. The magnitude only matters relative to other chunks in the chunk's dataset dataset. If no weight is provided, the existing weight will be used.
     */
    weight?: (number) | null;
};

export type UpdateDatasetRequest = {
    /**
     * The id of the dataset you want to update.
     */
    dataset_id?: (string) | null;
    /**
     * The new name of the dataset. Must be unique within the organization. If not provided, the name will not be updated.
     */
    dataset_name?: (string) | null;
    /**
     * Optional new tracking ID for the dataset. Can be used to track the dataset in external systems. Must be unique within the organization. If not provided, the tracking ID will not be updated. Strongly recommended to not use a valid uuid value as that will not work with the TR-Dataset header.
     */
    new_tracking_id?: (string) | null;
    server_configuration?: ((DatasetConfigurationDTO) | null);
    /**
     * The tracking ID of the dataset you want to update.
     */
    tracking_id?: (string) | null;
};

export type UpdateGroupByTrackingIDReqPayload = {
    /**
     * Description to assign to the chunk_group. Convenience field for you to avoid having to remember what the group is for. If not provided, the description will not be updated.
     */
    description?: (string) | null;
    /**
     * Optional metadata to assign to the chunk_group. This is a JSON object that can store any additional information you want to associate with the chunks inside of the chunk_group.
     */
    metadata?: unknown;
    /**
     * Name to assign to the chunk_group. Does not need to be unique. If not provided, the name will not be updated.
     */
    name?: (string) | null;
    /**
     * Optional tags to assign to the chunk_group. This is a list of strings that can be used to categorize the chunks inside the chunk_group.
     */
    tag_set?: Array<(string)> | null;
    /**
     * Tracking Id of the chunk_group to update.
     */
    tracking_id: string;
};

export type UpdateOrganizationReqPayload = {
    /**
     * The new name of the organization. If not provided, the name will not be updated.
     */
    name?: (string) | null;
    /**
     * The id of the organization to update.
     */
    organization_id: string;
};

export type UpdateTopicReqPayload = {
    /**
     * The new name of the topic. A name is not generated from this field, it is used as-is.
     */
    name: string;
    /**
     * The id of the topic to target.
     */
    topic_id: string;
};

export type UpdateUserOrgRoleData = {
    /**
     * The id of the organization to update the user for.
     */
    organization_id: string;
    /**
     * Either 0 (user), 1 (admin), or 2 (owner). If not provided, the current role will be used. The auth'ed user must have a role greater than or equal to the role being assigned.
     */
    role: number;
    /**
     * The id of the user to update, if not provided, the auth'ed user will be updated. If provided, the role of the auth'ed user or api key must be an admin (1) or owner (2) of the organization.
     */
    user_id?: (string) | null;
};

export type UploadFileReqPayload = {
    /**
     * Base64 encoded file. This is the standard base64url encoding.
     */
    base64_file: string;
    /**
     * Create chunks is a boolean which determines whether or not to create chunks from the file. If false, you can manually chunk the file and send the chunks to the create_chunk endpoint with the file_id to associate chunks with the file. Meant mostly for advanced users.
     */
    create_chunks?: (boolean) | null;
    /**
     * Description is an optional convience field so you do not have to remember what the file contains or is about. It will be included on the group resulting from the file which will hold its chunk.
     */
    description?: (string) | null;
    /**
     * Name of the file being uploaded, including the extension.
     */
    file_name: string;
    /**
     * Group tracking id is an optional field which allows you to specify the tracking id of the group that is created from the file. Chunks created will be created with the tracking id of `group_tracking_id|<index of chunk>`
     */
    group_tracking_id?: (string) | null;
    /**
     * Link to the file. This can also be any string. This can be used to filter when searching for the file's resulting chunks. The link value will not affect embedding creation.
     */
    link?: (string) | null;
    /**
     * Metadata is a JSON object which can be used to filter chunks. This is useful for when you want to filter chunks by arbitrary metadata. Unlike with tag filtering, there is a performance hit for filtering on metadata. Will be passed down to the file's chunks.
     */
    metadata?: unknown;
    /**
     * Rebalance chunks is an optional field which allows you to specify whether or not to rebalance the chunks created from the file. If not specified, the default true is used. If true, Trieve will evenly distribute remainder splits across chunks such that 66 splits with a `target_splits_per_chunk` of 20 will result in 3 chunks with 22 splits each.
     */
    rebalance_chunks?: (boolean) | null;
    /**
     * Split delimiters is an optional field which allows you to specify the delimiters to use when splitting the file before chunking the text. If not specified, the default [.!?\n] are used to split into sentences. However, you may want to use spaces or other delimiters.
     */
    split_delimiters?: Array<(string)> | null;
    /**
     * Tag set is a comma separated list of tags which will be passed down to the chunks made from the file. Tags are used to filter chunks when searching. HNSW indices are created for each tag such that there is no performance loss when filtering on them.
     */
    tag_set?: Array<(string)> | null;
    /**
     * Target splits per chunk. This is an optional field which allows you to specify the number of splits you want per chunk. If not specified, the default 20 is used. However, you may want to use a different number.
     */
    target_splits_per_chunk?: (number) | null;
    /**
     * Time stamp should be an ISO 8601 combined date and time without timezone. Time_stamp is used for time window filtering and recency-biasing search results. Will be passed down to the file's chunks.
     */
    time_stamp?: (string) | null;
};

export type UploadFileResult = {
    file_metadata: File;
};

export type UsageGraphPoint = {
    requests: number;
    time_stamp: string;
};

export type UserOrganization = {
    created_at: string;
    id: string;
    organization_id: string;
    role: number;
    updated_at: string;
    user_id: string;
};

export type WorkerEvent = {
    created_at: string;
    dataset_id: string;
    event_data: string;
    event_type: string;
    id: string;
};

export type GetCtrAnalyticsData = {
    /**
     * JSON request payload to filter the graph
     */
    requestBody: CTRAnalytics;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetCtrAnalyticsResponse = (CTRAnalyticsResponse);

export type SendCtrDataData = {
    /**
     * JSON request payload to send CTR data
     */
    requestBody: CTRDataRequestBody;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type SendCtrDataResponse = (void);

export type SendEventDataData = {
    /**
     * JSON request payload to send event data
     */
    requestBody: EventTypes;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type SendEventDataResponse = (void);

export type GetRagAnalyticsData = {
    /**
     * JSON request payload to filter the graph
     */
    requestBody: RAGAnalytics;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetRagAnalyticsResponse = (RAGAnalyticsResponse);

export type GetRecommendationAnalyticsData = {
    /**
     * JSON request payload to filter the graph
     */
    requestBody: RecommendationAnalytics;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetRecommendationAnalyticsResponse = (RecommendationAnalyticsResponse);

export type GetSearchAnalyticsData = {
    /**
     * JSON request payload to filter the graph
     */
    requestBody: SearchAnalytics;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetSearchAnalyticsResponse = (SearchAnalyticsResponse);

export type SetQueryRatingData = {
    /**
     * JSON request payload to rate a query
     */
    requestBody: RateQueryRequest;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type SetQueryRatingResponse = (void);

export type GetClusterAnalyticsData = {
    /**
     * JSON request payload to filter the graph
     */
    requestBody: ClusterAnalytics;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetClusterAnalyticsResponse = (ClusterAnalyticsResponse);

export type GetTopDatasetsData = {
    /**
     * JSON request payload to filter the top datasets
     */
    requestBody: GetTopDatasetsRequestBody;
};

export type GetTopDatasetsResponse = (Array<TopDatasetsResponse>);

export type LoginData = {
    /**
     * Code sent via email as a result of successful call to send_invitation
     */
    invCode?: (string) | null;
    /**
     * ID of organization to authenticate into
     */
    organizationId?: (string) | null;
    /**
     * URL to redirect to after successful login
     */
    redirectUri?: (string) | null;
};

export type LogoutResponse = (void);

export type CallbackResponse = (SlimUser);

export type GetMeResponse = (SlimUser);

export type CreateChunkData = {
    /**
     * JSON request payload to create a new chunk (chunk)
     */
    requestBody: CreateChunkReqPayloadEnum;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type CreateChunkResponse = (ReturnQueuedChunk);

export type UpdateChunkData = {
    /**
     * JSON request payload to update a chunk (chunk)
     */
    requestBody: UpdateChunkReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type UpdateChunkResponse = (void);

export type AutocompleteData = {
    /**
     * JSON request payload to semantically search for chunks (chunks)
     */
    requestBody: AutocompleteReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type AutocompleteResponse = (SearchResponseTypes);

export type CountChunksData = {
    /**
     * JSON request payload to count chunks for a search query
     */
    requestBody: CountChunksReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type CountChunksResponse = (CountChunkQueryResponseBody);

export type GenerateOffChunksData = {
    /**
     * JSON request payload to perform RAG on some chunks (chunks)
     */
    requestBody: GenerateOffChunksReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GenerateOffChunksResponse = (string);

export type GetRecommendedChunksData = {
    /**
     * JSON request payload to get recommendations of chunks similar to the chunks in the request
     */
    requestBody: RecommendChunksRequest;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type GetRecommendedChunksResponse = (RecommendResponseTypes);

export type SearchChunksData = {
    /**
     * JSON request payload to semantically search for chunks (chunks)
     */
    requestBody: SearchChunksReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type SearchChunksResponse = (SearchResponseTypes);

export type GetSuggestedQueriesData = {
    /**
     * JSON request payload to get alternative suggested queries
     */
    requestBody: SuggestedQueriesReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetSuggestedQueriesResponse = (SuggestedQueriesResponse);

export type UpdateChunkByTrackingIdData2 = {
    /**
     * JSON request payload to update a chunk by tracking_id (chunks)
     */
    requestBody: UpdateChunkByTrackingIdData;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type UpdateChunkByTrackingIdResponse = (void);

export type GetChunkByTrackingIdData = {
    /**
     * tracking_id of the chunk you want to fetch
     */
    trackingId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type GetChunkByTrackingIdResponse = (ChunkReturnTypes);

export type DeleteChunkByTrackingIdData = {
    /**
     * tracking_id of the chunk you want to delete
     */
    trackingId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type DeleteChunkByTrackingIdResponse = (void);

export type GetChunkByIdData = {
    /**
     * Id of the chunk you want to fetch.
     */
    chunkId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type GetChunkByIdResponse = (ChunkReturnTypes);

export type DeleteChunkData = {
    /**
     * Id of the chunk you want to fetch.
     */
    chunkId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type DeleteChunkResponse = (void);

export type CreateChunkGroupData = {
    /**
     * JSON request payload to cretea a chunk_group(s)
     */
    requestBody: CreateChunkGroupReqPayloadEnum;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type CreateChunkGroupResponse = (CreateChunkGroupResponseEnum);

export type UpdateChunkGroupData = {
    /**
     * JSON request payload to update a chunkGroup
     */
    requestBody: UpdateChunkGroupReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type UpdateChunkGroupResponse = (void);

export type AddChunkToGroupData = {
    /**
     * Id of the group to add the chunk to as a bookmark
     */
    groupId: string;
    /**
     * JSON request payload to add a chunk to a group (bookmark it)
     */
    requestBody: AddChunkToGroupReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type AddChunkToGroupResponse = (void);

export type RemoveChunkFromGroupData = {
    /**
     * Id of the chunk you want to remove from the group
     */
    chunkId?: (string) | null;
    /**
     * Id of the group you want to remove the chunk from.
     */
    groupId: string;
    /**
     * JSON request payload to remove a chunk from a group
     */
    requestBody?: ((RemoveChunkFromGroupReqPayload) | null);
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type RemoveChunkFromGroupResponse = (void);

export type GetGroupsForChunksData = {
    /**
     * JSON request payload to get the groups that a chunk is in
     */
    requestBody: GetGroupsForChunksReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetGroupsForChunksResponse = (Array<GroupsForChunk>);

export type SearchOverGroupsData = {
    /**
     * JSON request payload to semantically search over groups
     */
    requestBody: SearchOverGroupsReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type SearchOverGroupsResponse = (SearchOverGroupsResponseTypes);

export type GetRecommendedGroupsData = {
    /**
     * JSON request payload to get recommendations of chunks similar to the chunks in the request
     */
    requestBody: RecommendGroupsReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type GetRecommendedGroupsResponse = (RecommendGroupsResponse);

export type SearchWithinGroupData = {
    /**
     * JSON request payload to semantically search a group
     */
    requestBody: SearchWithinGroupReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type SearchWithinGroupResponse = (SearchGroupResponseTypes);

export type GetChunksInGroupByTrackingIdData = {
    /**
     * The id of the group to get the chunks from
     */
    groupTrackingId: string;
    /**
     * The page of chunks to get from the group
     */
    page: number;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The version of the API to use for the request
     */
    xApiVersion?: ((APIVersion) | null);
};

export type GetChunksInGroupByTrackingIdResponse = (GetChunksInGroupResponse);

export type GetGroupByTrackingIdData = {
    /**
     * The tracking id of the group to fetch.
     */
    trackingId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetGroupByTrackingIdResponse = (ChunkGroupAndFileId);

export type AddChunkToGroupByTrackingIdData = {
    /**
     * JSON request payload to add a chunk to a group via tracking_id
     */
    requestBody: AddChunkToGroupReqPayload;
    /**
     * Tracking id of the group to add the chunk to as a bookmark
     */
    trackingId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type AddChunkToGroupByTrackingIdResponse = (void);

export type UpdateGroupByTrackingIdData = {
    /**
     * JSON request payload to update a chunkGroup
     */
    requestBody: UpdateGroupByTrackingIDReqPayload;
    /**
     * Tracking id of the chunk_group to update
     */
    trackingId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type UpdateGroupByTrackingIdResponse = (void);

export type DeleteGroupByTrackingIdData = {
    /**
     * Delete the chunks within the group
     */
    deleteChunks: boolean;
    /**
     * Tracking id of the chunk_group to delete
     */
    trackingId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type DeleteGroupByTrackingIdResponse = (void);

export type GetChunkGroupData = {
    /**
     * Id of the group you want to fetch.
     */
    groupId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetChunkGroupResponse = (ChunkGroupAndFileId);

export type DeleteChunkGroupData = {
    /**
     * Delete the chunks within the group
     */
    deleteChunks: boolean;
    /**
     * Id of the group you want to fetch.
     */
    groupId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type DeleteChunkGroupResponse = (void);

export type GetChunksInGroupData = {
    /**
     * Id of the group you want to fetch.
     */
    groupId: string;
    /**
     * The page of chunks to get from the group
     */
    page: (number) | null;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The version of the API to use for the request
     */
    xApiVersion?: ((APIVersion) | null);
};

export type GetChunksInGroupResponse2 = (GetChunksInGroupResponse);

export type GetChunksByIdsData = {
    /**
     * JSON request payload to get the chunks in the request
     */
    requestBody: GetChunksData;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type GetChunksByIdsResponse = (Array<ChunkReturnTypes>);

export type ScrollDatasetChunksData = {
    /**
     * JSON request payload to scroll through chunks (chunks)
     */
    requestBody: ScrollChunksReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type ScrollDatasetChunksResponse = (ScrollChunksResponseBody);

export type GetChunksByTrackingIdsData = {
    /**
     * JSON request payload to get the chunks in the request
     */
    requestBody: GetTrackingChunksData;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
    /**
     * The API version to use for this request. Defaults to V2 for orgs created after July 12, 2024 and V1 otherwise.
     */
    xApiVersion?: ((APIVersion) | null);
};

export type GetChunksByTrackingIdsResponse = (Array<ChunkReturnTypes>);

export type CreateDatasetData = {
    /**
     * JSON request payload to create a new dataset
     */
    requestBody: CreateDatasetRequest;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type CreateDatasetResponse = (Dataset);

export type UpdateDatasetData = {
    /**
     * JSON request payload to update a dataset
     */
    requestBody: UpdateDatasetRequest;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type UpdateDatasetResponse = (Dataset);

export type ClearDatasetData = {
    /**
     * The id of the dataset you want to clear.
     */
    datasetId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type ClearDatasetResponse = (void);

export type GetDatasetFilesHandlerData = {
    /**
     * The id of the dataset to fetch files for.
     */
    datasetId: string;
    /**
     * The page number of files you wish to fetch. Each page contains at most 10 files.
     */
    page: number;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetDatasetFilesHandlerResponse = (Array<File>);

export type GetAllTagsData = {
    /**
     * JSON request payload to get items with the tag in the request
     */
    requestBody: GetAllTagsReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetAllTagsResponse2 = (GetAllTagsResponse);

export type GetGroupsForDatasetData = {
    /**
     * The id of the dataset to fetch groups for.
     */
    datasetId: string;
    /**
     * The page of groups to fetch. Page is 1-indexed.
     */
    page: number;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetGroupsForDatasetResponse = (GroupData);

export type GetDatasetsFromOrganizationData = {
    /**
     * The number of records to return
     */
    limit?: (number) | null;
    /**
     * The number of records to skip
     */
    offset?: (number) | null;
    /**
     * id of the organization you want to retrieve datasets for
     */
    organizationId: string;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type GetDatasetsFromOrganizationResponse = (Array<DatasetAndUsage>);

export type DeleteDatasetByTrackingIdData = {
    /**
     * The tracking id of the dataset you want to delete.
     */
    trackingId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type DeleteDatasetByTrackingIdResponse = (void);

export type GetUsageByDatasetIdData = {
    /**
     * The id of the dataset you want to retrieve usage for.
     */
    datasetId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetUsageByDatasetIdResponse = (DatasetUsageCount);

export type GetDatasetData = {
    /**
     * The id of the dataset you want to retrieve.
     */
    datasetId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetDatasetResponse = (Dataset);

export type DeleteDatasetData = {
    /**
     * The id of the dataset you want to delete.
     */
    datasetId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type DeleteDatasetResponse = (void);

export type GetEventsData2 = {
    /**
     * JSON request payload to get events for a dataset
     */
    requestBody: GetEventsData;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetEventsResponse = (EventReturn);

export type UploadFileHandlerData = {
    /**
     * JSON request payload to upload a file
     */
    requestBody: UploadFileReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type UploadFileHandlerResponse = (UploadFileResult);

export type GetFileHandlerData = {
    /**
     * The id of the file to fetch
     */
    fileId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetFileHandlerResponse = (FileDTO);

export type DeleteFileHandlerData = {
    /**
     * The id of the file to delete
     */
    fileId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type DeleteFileHandlerResponse = (void);

export type HealthCheckResponse = (unknown);

export type PostInvitationData = {
    /**
     * JSON request payload to send an invitation
     */
    requestBody: InvitationData;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type PostInvitationResponse = (void);

export type CreateMessageData = {
    /**
     * JSON request payload to create a message completion
     */
    requestBody: CreateMessageReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type CreateMessageResponse = (string);

export type EditMessageData = {
    /**
     * JSON request payload to edit a message and get a new stream
     */
    requestBody: EditMessageReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type EditMessageResponse = (unknown);

export type RegenerateMessageData = {
    /**
     * JSON request payload to delete an agent message then regenerate it in a strem
     */
    requestBody: RegenerateMessageReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type RegenerateMessageResponse = (string);

export type RegenerateMessagePatchData = {
    /**
     * JSON request payload to delete an agent message then regenerate it in a strem
     */
    requestBody: RegenerateMessageReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type RegenerateMessagePatchResponse = (string);

export type GetAllTopicMessagesData = {
    /**
     * The ID of the topic to get messages for.
     */
    messagesTopicId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetAllTopicMessagesResponse = (Array<Message>);

export type CreateOrganizationData = {
    /**
     * The organization data that you want to create
     */
    requestBody: CreateOrganizationReqPayload;
};

export type CreateOrganizationResponse = (Organization);

export type UpdateOrganizationData = {
    /**
     * The organization data that you want to update
     */
    requestBody: UpdateOrganizationReqPayload;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type UpdateOrganizationResponse = (Organization);

export type UpdateAllOrgDatasetConfigsData = {
    /**
     * The organization data that you want to create
     */
    requestBody: UpdateAllOrgDatasetConfigsReqPayload;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type UpdateAllOrgDatasetConfigsResponse = (void);

export type GetOrganizationUsageData = {
    /**
     * The id of the organization you want to fetch the usage of.
     */
    organizationId: string;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type GetOrganizationUsageResponse = (OrganizationUsageCount);

export type GetOrganizationUsersData = {
    /**
     * The id of the organization you want to fetch the users of.
     */
    organizationId: string;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type GetOrganizationUsersResponse = (Array<SlimUser>);

export type GetOrganizationData = {
    /**
     * The id of the organization you want to fetch.
     */
    organizationId: string;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type GetOrganizationResponse = (Organization);

export type DeleteOrganizationData = {
    /**
     * The id of the organization you want to fetch.
     */
    organizationId: string;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type DeleteOrganizationResponse = (void);

export type CreateSetupCheckoutSessionData = {
    /**
     * The id of the organization to create setup checkout session for.
     */
    organizationId: string;
};

export type CreateSetupCheckoutSessionResponse = (CreateSetupCheckoutSessionResPayload);

export type GetAllInvoicesData = {
    /**
     * The id of the organization to get invoices for.
     */
    organizationId: string;
};

export type GetAllInvoicesResponse = (Array<StripeInvoice>);

export type DirectToPaymentLinkData = {
    /**
     * id of the organization you want to subscribe to the plan
     */
    organizationId: string;
    /**
     * id of the plan you want to subscribe to
     */
    planId: string;
};

export type GetAllPlansResponse = (Array<StripePlan>);

export type CancelSubscriptionData = {
    /**
     * id of the subscription you want to cancel
     */
    subscriptionId: string;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type CancelSubscriptionResponse = (unknown);

export type UpdateSubscriptionPlanData = {
    /**
     * id of the plan you want to subscribe to
     */
    planId: string;
    /**
     * id of the subscription you want to update
     */
    subscriptionId: string;
    /**
     * The organization id to use for the request
     */
    trOrganization: string;
};

export type UpdateSubscriptionPlanResponse = (unknown);

export type CreateTopicData = {
    /**
     * JSON request payload to create chat topic
     */
    requestBody: CreateTopicReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type CreateTopicResponse = (Topic);

export type UpdateTopicData = {
    /**
     * JSON request payload to update a chat topic
     */
    requestBody: UpdateTopicReqPayload;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type UpdateTopicResponse = (void);

export type GetAllTopicsForOwnerIdData = {
    /**
     * The owner_id to get topics of; A common approach is to use a browser fingerprint or your user's id
     */
    ownerId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type GetAllTopicsForOwnerIdResponse = (Array<Topic>);

export type DeleteTopicData2 = {
    /**
     * The id of the topic you want to delete.
     */
    topicId: string;
    /**
     * The dataset id or tracking_id to use for the request. We assume you intend to use an id if the value is a valid uuid.
     */
    trDataset: string;
};

export type DeleteTopicResponse = (void);

export type UpdateUserData = {
    /**
     * JSON request payload to update user information for the auth'ed user
     */
    requestBody: UpdateUserOrgRoleData;
};

export type UpdateUserResponse = (void);

export type SetUserApiKeyData = {
    /**
     * JSON request payload to create a new user api key
     */
    requestBody: SetUserApiKeyRequest;
};

export type SetUserApiKeyResponse2 = (SetUserApiKeyResponse);

export type DeleteUserApiKeyData = {
    /**
     * The id of the api key to delete
     */
    apiKeyId: string;
};

export type DeleteUserApiKeyResponse = (void);

export type GetMetricsResponse = (string);

export type $OpenApiTs = {
    '/api/analytics/ctr': {
        post: {
            req: GetCtrAnalyticsData;
            res: {
                /**
                 * The CTR analytics for the dataset
                 */
                200: CTRAnalyticsResponse;
                /**
                 * Service error relating to getting CTR analytics
                 */
                400: ErrorResponseBody;
            };
        };
        put: {
            req: SendCtrDataData;
            res: {
                /**
                 * The CTR data was successfully sent
                 */
                204: void;
                /**
                 * Service error relating to sending CTR data
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/analytics/events': {
        put: {
            req: SendEventDataData;
            res: {
                /**
                 * The event data was successfully sent
                 */
                204: void;
                /**
                 * Service error relating to sending event data
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/analytics/rag': {
        post: {
            req: GetRagAnalyticsData;
            res: {
                /**
                 * The RAG analytics for the dataset
                 */
                200: RAGAnalyticsResponse;
                /**
                 * Service error relating to getting RAG analytics
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/analytics/recommendations': {
        post: {
            req: GetRecommendationAnalyticsData;
            res: {
                /**
                 * The recommendation analytics for the dataset
                 */
                200: RecommendationAnalyticsResponse;
                /**
                 * Service error relating to getting recommendation analytics
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/analytics/search': {
        post: {
            req: GetSearchAnalyticsData;
            res: {
                /**
                 * The search analytics for the dataset
                 */
                200: SearchAnalyticsResponse;
                /**
                 * Service error relating to getting search analytics
                 */
                400: ErrorResponseBody;
            };
        };
        put: {
            req: SetQueryRatingData;
            res: {
                /**
                 * The query was successfully rated
                 */
                204: void;
                /**
                 * Service error relating to rating a query
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/analytics/search/cluster': {
        post: {
            req: GetClusterAnalyticsData;
            res: {
                /**
                 * The cluster analytics for the dataset
                 */
                200: ClusterAnalyticsResponse;
                /**
                 * Service error relating to getting cluster analytics
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/analytics/top': {
        post: {
            req: GetTopDatasetsData;
            res: {
                /**
                 * The top datasets for the request
                 */
                200: Array<TopDatasetsResponse>;
                /**
                 * Service error relating to getting top datasets
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/auth': {
        get: {
            req: LoginData;
            res: {
                /**
                 * Response that redirects to OAuth provider through a Location header to be handled by browser.
                 */
                303: unknown;
                /**
                 * OAuth error likely with OIDC provider.
                 */
                400: ErrorResponseBody;
            };
        };
        delete: {
            res: {
                /**
                 * Confirmation that your current auth token has been invalidated. This does not invalidate your API key.
                 */
                204: void;
            };
        };
    };
    '/api/auth/callback': {
        get: {
            res: {
                /**
                 * Response that returns with set-cookie header
                 */
                200: SlimUser;
                /**
                 * Email or password empty or incorrect
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/auth/me': {
        get: {
            res: {
                /**
                 * The user corresponding to your current auth credentials
                 */
                200: SlimUser;
                /**
                 * Error message indicitating you are not currently signed in
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk': {
        post: {
            req: CreateChunkData;
            res: {
                /**
                 * JSON response payload containing the created chunk
                 */
                200: ReturnQueuedChunk;
                /**
                 * Error typically due to deserialization issues
                 */
                400: ErrorResponseBody;
                /**
                 * Error when more than 120 chunks are provided in bulk
                 */
                413: ErrorResponseBody;
                /**
                 * Error when upgrade is needed to process more chunks
                 */
                426: ErrorResponseBody;
            };
        };
        put: {
            req: UpdateChunkData;
            res: {
                /**
                 * No content Ok response indicating the chunk was updated as requested
                 */
                204: void;
                /**
                 * Service error relating to to updating chunk, likely due to conflicting tracking_id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk/autocomplete': {
        post: {
            req: AutocompleteData;
            res: {
                /**
                 * Chunks with embedding vectors which are similar to those in the request body
                 */
                200: SearchResponseTypes;
                /**
                 * Service error relating to searching
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk/count': {
        post: {
            req: CountChunksData;
            res: {
                /**
                 * Number of chunks satisfying the query
                 */
                200: CountChunkQueryResponseBody;
                /**
                 * Failed to count chunks
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/chunk/generate': {
        post: {
            req: GenerateOffChunksData;
            res: {
                /**
                 * This will be a JSON response of a string containing the LLM's generated inference. Response if not streaming.
                 */
                200: string;
                /**
                 * Service error relating to to updating chunk, likely due to conflicting tracking_id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk/recommend': {
        post: {
            req: GetRecommendedChunksData;
            res: {
                /**
                 * Chunks with embedding vectors which are similar to positives and dissimilar to negatives
                 */
                200: RecommendResponseTypes;
                /**
                 * Service error relating to to getting similar chunks
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk/search': {
        post: {
            req: SearchChunksData;
            res: {
                /**
                 * Chunks with embedding vectors which are similar to those in the request body
                 */
                200: SearchResponseTypes;
                /**
                 * Service error relating to searching
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk/suggestions': {
        post: {
            req: GetSuggestedQueriesData;
            res: {
                /**
                 * A JSON object containing a list of alternative suggested queries
                 */
                200: SuggestedQueriesResponse;
                /**
                 * Service error relating to to updating chunk, likely due to conflicting tracking_id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk/tracking_id/update': {
        put: {
            req: UpdateChunkByTrackingIdData2;
            res: {
                /**
                 * Confirmation that the chunk has been updated as per your request
                 */
                204: void;
                /**
                 * Service error relating to to updating chunk
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk/tracking_id/{tracking_id}': {
        get: {
            req: GetChunkByTrackingIdData;
            res: {
                /**
                 * chunk with the tracking_id that you were searching for
                 */
                200: ChunkReturnTypes;
                /**
                 * Service error relating to fidning a chunk by tracking_id
                 */
                400: ErrorResponseBody;
                /**
                 * Chunk not found
                 */
                404: ErrorResponseBody;
            };
        };
        delete: {
            req: DeleteChunkByTrackingIdData;
            res: {
                /**
                 * Confirmation that the chunk with the tracking_id specified was deleted
                 */
                204: void;
                /**
                 * Service error relating to finding a chunk by tracking_id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk/{chunk_id}': {
        get: {
            req: GetChunkByIdData;
            res: {
                /**
                 * chunk with the id that you were searching for
                 */
                200: ChunkReturnTypes;
                /**
                 * Service error relating to fidning a chunk by tracking_id
                 */
                400: ErrorResponseBody;
                /**
                 * Chunk not found
                 */
                404: ErrorResponseBody;
            };
        };
        delete: {
            req: DeleteChunkData;
            res: {
                /**
                 * Confirmation that the chunk with the id specified was deleted
                 */
                204: void;
                /**
                 * Service error relating to finding a chunk by tracking_id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group': {
        post: {
            req: CreateChunkGroupData;
            res: {
                /**
                 * Returns the created chunk_group if a single chunk_group was specified or an array of all chunk_groups which were created
                 */
                200: CreateChunkGroupResponseEnum;
                /**
                 * Service error relating to creating the chunk_group(s)
                 */
                400: ErrorResponseBody;
                /**
                 * Service error indicating more 1000 chunk groups are trying to be created at once
                 */
                413: ErrorResponseBody;
            };
        };
        put: {
            req: UpdateChunkGroupData;
            res: {
                /**
                 * Confirmation that the chunkGroup was updated
                 */
                204: void;
                /**
                 * Service error relating to updating the chunkGroup
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group/chunk/{group_id}': {
        post: {
            req: AddChunkToGroupData;
            res: {
                /**
                 * Confirmation that the chunk was added to the group (bookmark'ed).
                 */
                204: void;
                /**
                 * Service error relating to getting the groups that the chunk is in.
                 */
                400: ErrorResponseBody;
            };
        };
        delete: {
            req: RemoveChunkFromGroupData;
            res: {
                /**
                 * Confirmation that the chunk was removed to the group
                 */
                204: void;
                /**
                 * Service error relating to removing the chunk from the group
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group/chunks': {
        post: {
            req: GetGroupsForChunksData;
            res: {
                /**
                 * JSON body representing the groups that the chunk is in
                 */
                200: Array<GroupsForChunk>;
                /**
                 * Service error relating to getting the groups that the chunk is in
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group/group_oriented_search': {
        post: {
            req: SearchOverGroupsData;
            res: {
                /**
                 * Group chunks which are similar to the embedding vector of the search query
                 */
                200: SearchOverGroupsResponseTypes;
                /**
                 * Service error relating to searching over groups
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group/recommend': {
        post: {
            req: GetRecommendedGroupsData;
            res: {
                /**
                 * JSON body representing the groups which are similar to the positive groups and dissimilar to the negative ones
                 */
                200: RecommendGroupsResponse;
                /**
                 * Service error relating to to getting similar chunks
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group/search': {
        post: {
            req: SearchWithinGroupData;
            res: {
                /**
                 * Group chunks which are similar to the embedding vector of the search query
                 */
                200: SearchGroupResponseTypes;
                /**
                 * Service error relating to getting the groups that the chunk is in
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group/tracking_id/{group_tracking_id}/{page}': {
        get: {
            req: GetChunksInGroupByTrackingIdData;
            res: {
                /**
                 * Chunks present within the specified group
                 */
                200: GetChunksInGroupResponse;
                /**
                 * Service error relating to getting the groups that the chunk is in
                 */
                400: ErrorResponseBody;
                /**
                 * Group not found
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group/tracking_id/{tracking_id}': {
        get: {
            req: GetGroupByTrackingIdData;
            res: {
                /**
                 * JSON body representing the group with the given tracking id
                 */
                200: ChunkGroupAndFileId;
                /**
                 * Service error relating to getting the group with the given tracking id
                 */
                400: ErrorResponseBody;
                /**
                 * Group not found
                 */
                404: ErrorResponseBody;
            };
        };
        post: {
            req: AddChunkToGroupByTrackingIdData;
            res: {
                /**
                 * Confirmation that the chunk was added to the group
                 */
                204: void;
                /**
                 * Service error related to adding the chunk group by tracking_id
                 */
                400: ErrorResponseBody;
            };
        };
        put: {
            req: UpdateGroupByTrackingIdData;
            res: {
                /**
                 * Confirmation that the chunkGroup was updated
                 */
                204: void;
                /**
                 * Service error relating to updating the chunkGroup
                 */
                400: ErrorResponseBody;
            };
        };
        delete: {
            req: DeleteGroupByTrackingIdData;
            res: {
                /**
                 * Confirmation that the chunkGroup was deleted
                 */
                204: void;
                /**
                 * Service error relating to deleting the chunkGroup
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group/{group_id}': {
        get: {
            req: GetChunkGroupData;
            res: {
                /**
                 * JSON body representing the group with the given tracking id
                 */
                200: ChunkGroupAndFileId;
                /**
                 * Service error relating to getting the group with the given tracking id
                 */
                400: ErrorResponseBody;
                /**
                 * Group not found
                 */
                404: ErrorResponseBody;
            };
        };
        delete: {
            req: DeleteChunkGroupData;
            res: {
                /**
                 * Confirmation that the chunkGroup was deleted
                 */
                204: void;
                /**
                 * Service error relating to deleting the chunkGroup
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunk_group/{group_id}/{page}': {
        get: {
            req: GetChunksInGroupData;
            res: {
                /**
                 * Chunks present within the specified group
                 */
                200: GetChunksInGroupResponse;
                /**
                 * Service error relating to getting the groups that the chunk is in
                 */
                400: ErrorResponseBody;
                /**
                 * Group not found
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/chunks': {
        post: {
            req: GetChunksByIdsData;
            res: {
                /**
                 * chunks with the id that you were searching for
                 */
                200: Array<ChunkReturnTypes>;
                /**
                 * Service error relating to fidning a chunk by tracking_id
                 */
                400: ErrorResponseBody;
                /**
                 * Any one of the specified chunks not found
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/chunks/scroll': {
        post: {
            req: ScrollDatasetChunksData;
            res: {
                /**
                 * Number of chunks equivalent to page_size starting from offset_chunk_id
                 */
                200: ScrollChunksResponseBody;
                /**
                 * Service error relating to scrolling chunks
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/chunks/tracking': {
        post: {
            req: GetChunksByTrackingIdsData;
            res: {
                /**
                 * Chunks with one the ids which were specified
                 */
                200: Array<ChunkReturnTypes>;
                /**
                 * Service error relating to finding a chunk by tracking_id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/dataset': {
        post: {
            req: CreateDatasetData;
            res: {
                /**
                 * Dataset created successfully
                 */
                200: Dataset;
                /**
                 * Service error relating to creating the dataset
                 */
                400: ErrorResponseBody;
            };
        };
        put: {
            req: UpdateDatasetData;
            res: {
                /**
                 * Dataset updated successfully
                 */
                200: Dataset;
                /**
                 * Service error relating to updating the dataset
                 */
                400: ErrorResponseBody;
                /**
                 * Dataset not found
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/dataset/clear/{dataset_id}': {
        put: {
            req: ClearDatasetData;
            res: {
                /**
                 * Dataset cleared successfully
                 */
                204: void;
                /**
                 * Service error relating to deleting the dataset
                 */
                400: ErrorResponseBody;
                /**
                 * Dataset not found
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/dataset/files/{dataset_id}/{page}': {
        get: {
            req: GetDatasetFilesHandlerData;
            res: {
                /**
                 * JSON body representing the files in the current dataset
                 */
                200: Array<File>;
                /**
                 * Service error relating to getting the files in the current datase
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/dataset/get_all_tags': {
        post: {
            req: GetAllTagsData;
            res: {
                /**
                 * Page of tags requested with all tags and the number of chunks in the dataset with that tag plus the total number of unique tags for the whole datset
                 */
                200: GetAllTagsResponse;
                /**
                 * Service error relating to finding items by tag
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/dataset/groups/{dataset_id}/{page}': {
        get: {
            req: GetGroupsForDatasetData;
            res: {
                /**
                 * JSON body representing the groups created by the given dataset
                 */
                200: GroupData;
                /**
                 * Service error relating to getting the groups created by the given dataset
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/dataset/organization/{organization_id}': {
        get: {
            req: GetDatasetsFromOrganizationData;
            res: {
                /**
                 * Datasets retrieved successfully
                 */
                200: Array<DatasetAndUsage>;
                /**
                 * Service error relating to retrieving the dataset
                 */
                400: ErrorResponseBody;
                /**
                 * Could not find organization
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/dataset/tracking_id/{tracking_id}': {
        delete: {
            req: DeleteDatasetByTrackingIdData;
            res: {
                /**
                 * Dataset deleted successfully
                 */
                204: void;
                /**
                 * Service error relating to deleting the dataset
                 */
                400: ErrorResponseBody;
                /**
                 * Dataset not found
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/dataset/usage/{dataset_id}': {
        get: {
            req: GetUsageByDatasetIdData;
            res: {
                /**
                 * Dataset usage retrieved successfully
                 */
                200: DatasetUsageCount;
                /**
                 * Service error relating to retrieving the dataset usage
                 */
                400: ErrorResponseBody;
                /**
                 * Dataset not found
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/dataset/{dataset_id}': {
        get: {
            req: GetDatasetData;
            res: {
                /**
                 * Dataset retrieved successfully
                 */
                200: Dataset;
                /**
                 * Service error relating to retrieving the dataset
                 */
                400: ErrorResponseBody;
                /**
                 * Dataset not found
                 */
                404: ErrorResponseBody;
            };
        };
        delete: {
            req: DeleteDatasetData;
            res: {
                /**
                 * Dataset deleted successfully
                 */
                204: void;
                /**
                 * Service error relating to deleting the dataset
                 */
                400: ErrorResponseBody;
                /**
                 * Dataset not found
                 */
                404: ErrorResponseBody;
            };
        };
    };
    '/api/events': {
        post: {
            req: GetEventsData2;
            res: {
                /**
                 * Events for the dataset
                 */
                200: EventReturn;
                /**
                 * Service error relating to getting events for the dataset
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/file': {
        post: {
            req: UploadFileHandlerData;
            res: {
                /**
                 * Confirmation that the file is uploading
                 */
                200: UploadFileResult;
                /**
                 * Service error relating to uploading the file
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/file/{file_id}': {
        get: {
            req: GetFileHandlerData;
            res: {
                /**
                 * The signed s3 url corresponding to the file_id requested
                 */
                200: FileDTO;
                /**
                 * Service error relating to finding the file
                 */
                400: ErrorResponseBody;
                /**
                 * File not found
                 */
                404: ErrorResponseBody;
            };
        };
        delete: {
            req: DeleteFileHandlerData;
            res: {
                /**
                 * Confirmation that the file has been deleted
                 */
                204: void;
                /**
                 * Service error relating to finding or deleting the file
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/health': {
        get: {
            res: {
                /**
                 * Confirmation that the service is healthy and can make embedding vectors
                 */
                200: unknown;
                /**
                 * Service error relating to making an embedding or overall service health
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/invitation': {
        post: {
            req: PostInvitationData;
            res: {
                /**
                 * Ok response. Indicates that invitation email was sent correctly.
                 */
                204: void;
                /**
                 * Invalid email or some other error
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/message': {
        post: {
            req: CreateMessageData;
            res: {
                /**
                 * This will be a JSON response of a string containing the LLM's generated inference. Response if not streaming.
                 */
                200: string;
                /**
                 * Service error relating to getting a chat completion
                 */
                400: ErrorResponseBody;
            };
        };
        put: {
            req: EditMessageData;
            res: {
                /**
                 * This will be a HTTP stream, check the chat or search UI for an example how to process this
                 */
                200: unknown;
                /**
                 * Service error relating to getting a chat completion
                 */
                400: ErrorResponseBody;
            };
        };
        delete: {
            req: RegenerateMessageData;
            res: {
                /**
                 * This will be a JSON response of a string containing the LLM's generated inference. Response if not streaming.
                 */
                200: string;
                /**
                 * Service error relating to getting a chat completion
                 */
                400: ErrorResponseBody;
            };
        };
        patch: {
            req: RegenerateMessagePatchData;
            res: {
                /**
                 * This will be a JSON response of a string containing the LLM's generated inference. Response if not streaming.
                 */
                200: string;
                /**
                 * Service error relating to getting a chat completion
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/messages/{messages_topic_id}': {
        get: {
            req: GetAllTopicMessagesData;
            res: {
                /**
                 * All messages relating to the topic with the given ID
                 */
                200: Array<Message>;
                /**
                 * Service error relating to getting the messages
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/organization': {
        post: {
            req: CreateOrganizationData;
            res: {
                /**
                 * Created organization object
                 */
                200: Organization;
                /**
                 * Service error relating to creating the organization
                 */
                400: ErrorResponseBody;
            };
        };
        put: {
            req: UpdateOrganizationData;
            res: {
                /**
                 * Updated organization object
                 */
                200: Organization;
                /**
                 * Service error relating to updating the organization
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/organization/update_dataset_configs': {
        post: {
            req: UpdateAllOrgDatasetConfigsData;
            res: {
                /**
                 * Confirmation that the dataset ServerConfigurations were updated successfully
                 */
                204: void;
                /**
                 * Service error relating to updating the dataset ServerConfigurations
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/organization/usage/{organization_id}': {
        get: {
            req: GetOrganizationUsageData;
            res: {
                /**
                 * The current usage of the specified organization
                 */
                200: OrganizationUsageCount;
                /**
                 * Service error relating to finding the organization's usage by id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/organization/users/{organization_id}': {
        get: {
            req: GetOrganizationUsersData;
            res: {
                /**
                 * Array of users who belong to the specified by organization
                 */
                200: Array<SlimUser>;
                /**
                 * Service error relating to finding the organization's users by id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/organization/{organization_id}': {
        get: {
            req: GetOrganizationData;
            res: {
                /**
                 * Organization with the id that was requested
                 */
                200: Organization;
                /**
                 * Service error relating to finding the organization by id
                 */
                400: ErrorResponseBody;
                /**
                 * Organization not found
                 */
                404: ErrorResponseBody;
            };
        };
        delete: {
            req: DeleteOrganizationData;
            res: {
                /**
                 * Confirmation that the organization was deleted
                 */
                204: void;
                /**
                 * Service error relating to deleting the organization by id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/stripe/checkout/setup/{organization_id}': {
        post: {
            req: CreateSetupCheckoutSessionData;
            res: {
                /**
                 * Checkout session (setup) response
                 */
                200: CreateSetupCheckoutSessionResPayload;
                /**
                 * Service error relating to creating setup checkout session
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/stripe/invoices/{organization_id}': {
        get: {
            req: GetAllInvoicesData;
            res: {
                /**
                 * List of all invoices
                 */
                200: Array<StripeInvoice>;
                /**
                 * Service error relating to getting all invoices
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/stripe/payment_link/{plan_id}/{organization_id}': {
        get: {
            req: DirectToPaymentLinkData;
            res: {
                /**
                 * SeeOther response redirecting user to stripe checkout page
                 */
                303: unknown;
                /**
                 * Service error relating to creating a URL for a stripe checkout page
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/stripe/plans': {
        get: {
            res: {
                /**
                 * List of all plans
                 */
                200: Array<StripePlan>;
                /**
                 * Service error relating to getting all plans
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/stripe/subscription/{subscription_id}': {
        delete: {
            req: CancelSubscriptionData;
            res: {
                /**
                 * Confirmation that the subscription was cancelled
                 */
                200: unknown;
                /**
                 * Service error relating to creating a URL for a stripe checkout page
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/stripe/subscription_plan/{subscription_id}/{plan_id}': {
        patch: {
            req: UpdateSubscriptionPlanData;
            res: {
                /**
                 * Confirmation that the subscription was updated to the new plan
                 */
                200: unknown;
                /**
                 * Service error relating to updating the subscription to the new plan
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/topic': {
        post: {
            req: CreateTopicData;
            res: {
                /**
                 * The JSON response payload containing the created topic
                 */
                200: Topic;
                /**
                 * Topic name empty or a service error
                 */
                400: ErrorResponseBody;
            };
        };
        put: {
            req: UpdateTopicData;
            res: {
                /**
                 * Confirmation that the topic was updated
                 */
                204: void;
                /**
                 * Service error relating to topic update
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/topic/owner/{owner_id}': {
        get: {
            req: GetAllTopicsForOwnerIdData;
            res: {
                /**
                 * All topics belonging to a given owner_id
                 */
                200: Array<Topic>;
                /**
                 * Service error relating to getting topics for the owner_id
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/topic/{topic_id}': {
        delete: {
            req: DeleteTopicData2;
            res: {
                /**
                 * Confirmation that the topic was deleted
                 */
                204: void;
                /**
                 * Service error relating to topic deletion
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/user': {
        put: {
            req: UpdateUserData;
            res: {
                /**
                 * Confirmation that the user's role was updated
                 */
                204: void;
                /**
                 * Service error relating to updating the user
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/user/api_key': {
        post: {
            req: SetUserApiKeyData;
            res: {
                /**
                 * JSON body representing the api_key for the user
                 */
                200: SetUserApiKeyResponse;
                /**
                 * Service error relating to creating api_key for the user
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/api/user/api_key/{api_key_id}': {
        delete: {
            req: DeleteUserApiKeyData;
            res: {
                /**
                 * Confirmation that the api key was deleted
                 */
                204: void;
                /**
                 * Service error relating to creating api_key for the user
                 */
                400: ErrorResponseBody;
            };
        };
    };
    '/metrics': {
        post: {
            res: {
                /**
                 * Prometheus metrics for the server
                 */
                200: string;
                /**
                 * Internal Server Error
                 */
                500: ErrorResponseBody;
            };
        };
    };
};