# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class UploadFileReqPayload(BaseModel):
    """
    UploadFileReqPayload
    """ # noqa: E501
    base64_file: StrictStr = Field(description="Base64 encoded file. This is the standard base64url encoding.")
    create_chunks: Optional[StrictBool] = Field(default=None, description="Create chunks is a boolean which determines whether or not to create chunks from the file. If false, you can manually chunk the file and send the chunks to the create_chunk endpoint with the file_id to associate chunks with the file. Meant mostly for advanced users.")
    description: Optional[StrictStr] = Field(default=None, description="Description is an optional convience field so you do not have to remember what the file contains or is about. It will be included on the group resulting from the file which will hold its chunk.")
    file_name: StrictStr = Field(description="Name of the file being uploaded, including the extension.")
    group_tracking_id: Optional[StrictStr] = Field(default=None, description="Group tracking id is an optional field which allows you to specify the tracking id of the group that is created from the file. Chunks created will be created with the tracking id of `group_tracking_id|<index of chunk>`")
    link: Optional[StrictStr] = Field(default=None, description="Link to the file. This can also be any string. This can be used to filter when searching for the file's resulting chunks. The link value will not affect embedding creation.")
    metadata: Optional[Any] = Field(default=None, description="Metadata is a JSON object which can be used to filter chunks. This is useful for when you want to filter chunks by arbitrary metadata. Unlike with tag filtering, there is a performance hit for filtering on metadata. Will be passed down to the file's chunks.")
    rebalance_chunks: Optional[StrictBool] = Field(default=None, description="Rebalance chunks is an optional field which allows you to specify whether or not to rebalance the chunks created from the file. If not specified, the default true is used. If true, Trieve will evenly distribute remainder splits across chunks such that 66 splits with a `target_splits_per_chunk` of 20 will result in 3 chunks with 22 splits each.")
    split_delimiters: Optional[List[StrictStr]] = Field(default=None, description="Split delimiters is an optional field which allows you to specify the delimiters to use when splitting the file before chunking the text. If not specified, the default [.!?\\n] are used to split into sentences. However, you may want to use spaces or other delimiters.")
    tag_set: Optional[List[StrictStr]] = Field(default=None, description="Tag set is a comma separated list of tags which will be passed down to the chunks made from the file. Tags are used to filter chunks when searching. HNSW indices are created for each tag such that there is no performance loss when filtering on them.")
    target_splits_per_chunk: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Target splits per chunk. This is an optional field which allows you to specify the number of splits you want per chunk. If not specified, the default 20 is used. However, you may want to use a different number.")
    time_stamp: Optional[StrictStr] = Field(default=None, description="Time stamp should be an ISO 8601 combined date and time without timezone. Time_stamp is used for time window filtering and recency-biasing search results. Will be passed down to the file's chunks.")
    __properties: ClassVar[List[str]] = ["base64_file", "create_chunks", "description", "file_name", "group_tracking_id", "link", "metadata", "rebalance_chunks", "split_delimiters", "tag_set", "target_splits_per_chunk", "time_stamp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UploadFileReqPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if create_chunks (nullable) is None
        # and model_fields_set contains the field
        if self.create_chunks is None and "create_chunks" in self.model_fields_set:
            _dict['create_chunks'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if group_tracking_id (nullable) is None
        # and model_fields_set contains the field
        if self.group_tracking_id is None and "group_tracking_id" in self.model_fields_set:
            _dict['group_tracking_id'] = None

        # set to None if link (nullable) is None
        # and model_fields_set contains the field
        if self.link is None and "link" in self.model_fields_set:
            _dict['link'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if rebalance_chunks (nullable) is None
        # and model_fields_set contains the field
        if self.rebalance_chunks is None and "rebalance_chunks" in self.model_fields_set:
            _dict['rebalance_chunks'] = None

        # set to None if split_delimiters (nullable) is None
        # and model_fields_set contains the field
        if self.split_delimiters is None and "split_delimiters" in self.model_fields_set:
            _dict['split_delimiters'] = None

        # set to None if tag_set (nullable) is None
        # and model_fields_set contains the field
        if self.tag_set is None and "tag_set" in self.model_fields_set:
            _dict['tag_set'] = None

        # set to None if target_splits_per_chunk (nullable) is None
        # and model_fields_set contains the field
        if self.target_splits_per_chunk is None and "target_splits_per_chunk" in self.model_fields_set:
            _dict['target_splits_per_chunk'] = None

        # set to None if time_stamp (nullable) is None
        # and model_fields_set contains the field
        if self.time_stamp is None and "time_stamp" in self.model_fields_set:
            _dict['time_stamp'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UploadFileReqPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "base64_file": obj.get("base64_file"),
            "create_chunks": obj.get("create_chunks"),
            "description": obj.get("description"),
            "file_name": obj.get("file_name"),
            "group_tracking_id": obj.get("group_tracking_id"),
            "link": obj.get("link"),
            "metadata": obj.get("metadata"),
            "rebalance_chunks": obj.get("rebalance_chunks"),
            "split_delimiters": obj.get("split_delimiters"),
            "tag_set": obj.get("tag_set"),
            "target_splits_per_chunk": obj.get("target_splits_per_chunk"),
            "time_stamp": obj.get("time_stamp")
        })
        return _obj


