# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trieve_py_client.models.typo_range import TypoRange
from typing import Optional, Set
from typing_extensions import Self

class TypoOptions(BaseModel):
    """
    Typo Options lets you specify different methods to correct typos in the query. If not specified, typos will not be corrected.
    """ # noqa: E501
    correct_typos: Optional[StrictBool] = Field(default=None, description="Set correct_typos to true to correct typos in the query. If not specified, this defaults to false.")
    disable_on_word: Optional[List[StrictStr]] = Field(default=None, description="Words that should not be corrected. If not specified, this defaults to an empty list.")
    one_typo_word_range: Optional[TypoRange] = None
    prioritize_domain_specifc_words: Optional[StrictBool] = Field(default=None, description="Auto-require non-english words present in the dataset to exist in each results chunk_html text. If not specified, this defaults to true.")
    two_typo_word_range: Optional[TypoRange] = None
    __properties: ClassVar[List[str]] = ["correct_typos", "disable_on_word", "one_typo_word_range", "prioritize_domain_specifc_words", "two_typo_word_range"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TypoOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of one_typo_word_range
        if self.one_typo_word_range:
            _dict['one_typo_word_range'] = self.one_typo_word_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of two_typo_word_range
        if self.two_typo_word_range:
            _dict['two_typo_word_range'] = self.two_typo_word_range.to_dict()
        # set to None if correct_typos (nullable) is None
        # and model_fields_set contains the field
        if self.correct_typos is None and "correct_typos" in self.model_fields_set:
            _dict['correct_typos'] = None

        # set to None if disable_on_word (nullable) is None
        # and model_fields_set contains the field
        if self.disable_on_word is None and "disable_on_word" in self.model_fields_set:
            _dict['disable_on_word'] = None

        # set to None if one_typo_word_range (nullable) is None
        # and model_fields_set contains the field
        if self.one_typo_word_range is None and "one_typo_word_range" in self.model_fields_set:
            _dict['one_typo_word_range'] = None

        # set to None if prioritize_domain_specifc_words (nullable) is None
        # and model_fields_set contains the field
        if self.prioritize_domain_specifc_words is None and "prioritize_domain_specifc_words" in self.model_fields_set:
            _dict['prioritize_domain_specifc_words'] = None

        # set to None if two_typo_word_range (nullable) is None
        # and model_fields_set contains the field
        if self.two_typo_word_range is None and "two_typo_word_range" in self.model_fields_set:
            _dict['two_typo_word_range'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TypoOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "correct_typos": obj.get("correct_typos"),
            "disable_on_word": obj.get("disable_on_word"),
            "one_typo_word_range": TypoRange.from_dict(obj["one_typo_word_range"]) if obj.get("one_typo_word_range") is not None else None,
            "prioritize_domain_specifc_words": obj.get("prioritize_domain_specifc_words"),
            "two_typo_word_range": TypoRange.from_dict(obj["two_typo_word_range"]) if obj.get("two_typo_word_range") is not None else None
        })
        return _obj


