# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from trieve_py_client.models.re_rank_options import ReRankOptions
from typing import Optional, Set
from typing_extensions import Self

class SortBySearchType(BaseModel):
    """
    SortBySearchType
    """ # noqa: E501
    prefetch_amount: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="How many results to pull in before the rerabj")
    rerank_query: Optional[StrictStr] = Field(default=None, description="Query to use for prefetching defaults to the search query")
    rerank_type: ReRankOptions
    __properties: ClassVar[List[str]] = ["prefetch_amount", "rerank_query", "rerank_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SortBySearchType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if prefetch_amount (nullable) is None
        # and model_fields_set contains the field
        if self.prefetch_amount is None and "prefetch_amount" in self.model_fields_set:
            _dict['prefetch_amount'] = None

        # set to None if rerank_query (nullable) is None
        # and model_fields_set contains the field
        if self.rerank_query is None and "rerank_query" in self.model_fields_set:
            _dict['rerank_query'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SortBySearchType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "prefetch_amount": obj.get("prefetch_amount"),
            "rerank_query": obj.get("rerank_query"),
            "rerank_type": obj.get("rerank_type")
        })
        return _obj


