# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from trieve_py_client.models.dataset_analytics import DatasetAnalytics
from trieve_py_client.models.head_query_response import HeadQueryResponse
from trieve_py_client.models.latency_graph_response import LatencyGraphResponse
from trieve_py_client.models.popular_filters_response import PopularFiltersResponse
from trieve_py_client.models.query_count_response import QueryCountResponse
from trieve_py_client.models.search_query_event import SearchQueryEvent
from trieve_py_client.models.search_query_response import SearchQueryResponse
from trieve_py_client.models.search_usage_graph_response import SearchUsageGraphResponse
from pydantic import StrictStr, Field
from typing import Union, List, Optional, Dict
from typing_extensions import Literal, Self

SEARCHANALYTICSRESPONSE_ONE_OF_SCHEMAS = ["DatasetAnalytics", "HeadQueryResponse", "LatencyGraphResponse", "PopularFiltersResponse", "QueryCountResponse", "SearchQueryEvent", "SearchQueryResponse", "SearchUsageGraphResponse"]

class SearchAnalyticsResponse(BaseModel):
    """
    SearchAnalyticsResponse
    """
    # data type: LatencyGraphResponse
    oneof_schema_1_validator: Optional[LatencyGraphResponse] = None
    # data type: SearchUsageGraphResponse
    oneof_schema_2_validator: Optional[SearchUsageGraphResponse] = None
    # data type: DatasetAnalytics
    oneof_schema_3_validator: Optional[DatasetAnalytics] = None
    # data type: HeadQueryResponse
    oneof_schema_4_validator: Optional[HeadQueryResponse] = None
    # data type: SearchQueryResponse
    oneof_schema_5_validator: Optional[SearchQueryResponse] = None
    # data type: SearchQueryResponse
    oneof_schema_6_validator: Optional[SearchQueryResponse] = None
    # data type: SearchQueryResponse
    oneof_schema_7_validator: Optional[SearchQueryResponse] = None
    # data type: QueryCountResponse
    oneof_schema_8_validator: Optional[QueryCountResponse] = None
    # data type: SearchQueryEvent
    oneof_schema_9_validator: Optional[SearchQueryEvent] = None
    # data type: PopularFiltersResponse
    oneof_schema_10_validator: Optional[PopularFiltersResponse] = None
    actual_instance: Optional[Union[DatasetAnalytics, HeadQueryResponse, LatencyGraphResponse, PopularFiltersResponse, QueryCountResponse, SearchQueryEvent, SearchQueryResponse, SearchUsageGraphResponse]] = None
    one_of_schemas: List[str] = Field(default=Literal["DatasetAnalytics", "HeadQueryResponse", "LatencyGraphResponse", "PopularFiltersResponse", "QueryCountResponse", "SearchQueryEvent", "SearchQueryResponse", "SearchUsageGraphResponse"])

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = SearchAnalyticsResponse.model_construct()
        error_messages = []
        match = 0
        # validate data type: LatencyGraphResponse
        if not isinstance(v, LatencyGraphResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `LatencyGraphResponse`")
        else:
            match += 1
        # validate data type: SearchUsageGraphResponse
        if not isinstance(v, SearchUsageGraphResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchUsageGraphResponse`")
        else:
            match += 1
        # validate data type: DatasetAnalytics
        if not isinstance(v, DatasetAnalytics):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DatasetAnalytics`")
        else:
            match += 1
        # validate data type: HeadQueryResponse
        if not isinstance(v, HeadQueryResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `HeadQueryResponse`")
        else:
            match += 1
        # validate data type: SearchQueryResponse
        if not isinstance(v, SearchQueryResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchQueryResponse`")
        else:
            match += 1
        # validate data type: SearchQueryResponse
        if not isinstance(v, SearchQueryResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchQueryResponse`")
        else:
            match += 1
        # validate data type: SearchQueryResponse
        if not isinstance(v, SearchQueryResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchQueryResponse`")
        else:
            match += 1
        # validate data type: QueryCountResponse
        if not isinstance(v, QueryCountResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `QueryCountResponse`")
        else:
            match += 1
        # validate data type: SearchQueryEvent
        if not isinstance(v, SearchQueryEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchQueryEvent`")
        else:
            match += 1
        # validate data type: PopularFiltersResponse
        if not isinstance(v, PopularFiltersResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PopularFiltersResponse`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in SearchAnalyticsResponse with oneOf schemas: DatasetAnalytics, HeadQueryResponse, LatencyGraphResponse, PopularFiltersResponse, QueryCountResponse, SearchQueryEvent, SearchQueryResponse, SearchUsageGraphResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in SearchAnalyticsResponse with oneOf schemas: DatasetAnalytics, HeadQueryResponse, LatencyGraphResponse, PopularFiltersResponse, QueryCountResponse, SearchQueryEvent, SearchQueryResponse, SearchUsageGraphResponse. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into LatencyGraphResponse
        try:
            instance.actual_instance = LatencyGraphResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchUsageGraphResponse
        try:
            instance.actual_instance = SearchUsageGraphResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DatasetAnalytics
        try:
            instance.actual_instance = DatasetAnalytics.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into HeadQueryResponse
        try:
            instance.actual_instance = HeadQueryResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchQueryResponse
        try:
            instance.actual_instance = SearchQueryResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchQueryResponse
        try:
            instance.actual_instance = SearchQueryResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchQueryResponse
        try:
            instance.actual_instance = SearchQueryResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into QueryCountResponse
        try:
            instance.actual_instance = QueryCountResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchQueryEvent
        try:
            instance.actual_instance = SearchQueryEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PopularFiltersResponse
        try:
            instance.actual_instance = PopularFiltersResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into SearchAnalyticsResponse with oneOf schemas: DatasetAnalytics, HeadQueryResponse, LatencyGraphResponse, PopularFiltersResponse, QueryCountResponse, SearchQueryEvent, SearchQueryResponse, SearchUsageGraphResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into SearchAnalyticsResponse with oneOf schemas: DatasetAnalytics, HeadQueryResponse, LatencyGraphResponse, PopularFiltersResponse, QueryCountResponse, SearchQueryEvent, SearchQueryResponse, SearchUsageGraphResponse. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], DatasetAnalytics, HeadQueryResponse, LatencyGraphResponse, PopularFiltersResponse, QueryCountResponse, SearchQueryEvent, SearchQueryResponse, SearchUsageGraphResponse]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


