# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from trieve_py_client.models.full_text_boost import FullTextBoost
from trieve_py_client.models.semantic_boost import SemanticBoost
from typing import Optional, Set
from typing_extensions import Self

class ScoringOptions(BaseModel):
    """
    Scoring options provides ways to modify the sparse or dense vector created for the query in order to change how potential matches are scored. If not specified, this defaults to no modifications.
    """ # noqa: E501
    fulltext_boost: Optional[FullTextBoost] = None
    semantic_boost: Optional[SemanticBoost] = None
    __properties: ClassVar[List[str]] = ["fulltext_boost", "semantic_boost"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScoringOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fulltext_boost
        if self.fulltext_boost:
            _dict['fulltext_boost'] = self.fulltext_boost.to_dict()
        # override the default output from pydantic by calling `to_dict()` of semantic_boost
        if self.semantic_boost:
            _dict['semantic_boost'] = self.semantic_boost.to_dict()
        # set to None if fulltext_boost (nullable) is None
        # and model_fields_set contains the field
        if self.fulltext_boost is None and "fulltext_boost" in self.model_fields_set:
            _dict['fulltext_boost'] = None

        # set to None if semantic_boost (nullable) is None
        # and model_fields_set contains the field
        if self.semantic_boost is None and "semantic_boost" in self.model_fields_set:
            _dict['semantic_boost'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScoringOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fulltext_boost": FullTextBoost.from_dict(obj["fulltext_boost"]) if obj.get("fulltext_boost") is not None else None,
            "semantic_boost": SemanticBoost.from_dict(obj["semantic_boost"]) if obj.get("semantic_boost") is not None else None
        })
        return _obj


