# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class LLMOptions(BaseModel):
    """
    LLM options to use for the completion. If not specified, this defaults to the dataset's LLM options.
    """ # noqa: E501
    completion_first: Optional[StrictBool] = Field(default=None, description="Completion first decides whether the stream should contain the stream of the completion response or the chunks first. Default is false. Keep in mind that || is used to separate the chunks from the completion response. If || is in the completion then you may want to split on ||{ instead.")
    frequency_penalty: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Frequency penalty is a number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim. Default is 0.7.")
    max_tokens: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="The maximum number of tokens to generate in the chat completion. Default is None.")
    presence_penalty: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Presence penalty is a number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics. Default is 0.7.")
    stop_tokens: Optional[List[StrictStr]] = Field(default=None, description="Stop tokens are up to 4 sequences where the API will stop generating further tokens. Default is None.")
    stream_response: Optional[StrictBool] = Field(default=None, description="Whether or not to stream the response. If this is set to true or not included, the response will be a stream. If this is set to false, the response will be a normal JSON response. Default is true.")
    system_prompt: Optional[StrictStr] = Field(default=None, description="Optionally, override the system prompt in dataset server settings.")
    temperature: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. Default is 0.5.")
    __properties: ClassVar[List[str]] = ["completion_first", "frequency_penalty", "max_tokens", "presence_penalty", "stop_tokens", "stream_response", "system_prompt", "temperature"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LLMOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if completion_first (nullable) is None
        # and model_fields_set contains the field
        if self.completion_first is None and "completion_first" in self.model_fields_set:
            _dict['completion_first'] = None

        # set to None if frequency_penalty (nullable) is None
        # and model_fields_set contains the field
        if self.frequency_penalty is None and "frequency_penalty" in self.model_fields_set:
            _dict['frequency_penalty'] = None

        # set to None if max_tokens (nullable) is None
        # and model_fields_set contains the field
        if self.max_tokens is None and "max_tokens" in self.model_fields_set:
            _dict['max_tokens'] = None

        # set to None if presence_penalty (nullable) is None
        # and model_fields_set contains the field
        if self.presence_penalty is None and "presence_penalty" in self.model_fields_set:
            _dict['presence_penalty'] = None

        # set to None if stop_tokens (nullable) is None
        # and model_fields_set contains the field
        if self.stop_tokens is None and "stop_tokens" in self.model_fields_set:
            _dict['stop_tokens'] = None

        # set to None if stream_response (nullable) is None
        # and model_fields_set contains the field
        if self.stream_response is None and "stream_response" in self.model_fields_set:
            _dict['stream_response'] = None

        # set to None if system_prompt (nullable) is None
        # and model_fields_set contains the field
        if self.system_prompt is None and "system_prompt" in self.model_fields_set:
            _dict['system_prompt'] = None

        # set to None if temperature (nullable) is None
        # and model_fields_set contains the field
        if self.temperature is None and "temperature" in self.model_fields_set:
            _dict['temperature'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LLMOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "completion_first": obj.get("completion_first"),
            "frequency_penalty": obj.get("frequency_penalty"),
            "max_tokens": obj.get("max_tokens"),
            "presence_penalty": obj.get("presence_penalty"),
            "stop_tokens": obj.get("stop_tokens"),
            "stream_response": obj.get("stream_response"),
            "system_prompt": obj.get("system_prompt"),
            "temperature": obj.get("temperature")
        })
        return _obj


