# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from trieve_py_client.models.highlight_strategy import HighlightStrategy
from typing import Optional, Set
from typing_extensions import Self

class HighlightOptions(BaseModel):
    """
    Highlight Options lets you specify different methods to highlight the chunks in the result set. If not specified, this defaults to the score of the chunks.
    """ # noqa: E501
    highlight_delimiters: Optional[List[StrictStr]] = Field(default=None, description="Set highlight_delimiters to a list of strings to use as delimiters for highlighting. If not specified, this defaults to [\"?\", \",\", \".\", \"!\"]. These are the characters that will be used to split the chunk_html into splits for highlighting. These are the characters that will be used to split the chunk_html into splits for highlighting.")
    highlight_max_length: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Set highlight_max_length to control the maximum number of tokens (typically whitespace separated strings, but sometimes also word stems) which can be present within a single highlight. If not specified, this defaults to 8. This is useful to shorten large splits which may have low scores due to length compared to the query. Set to something very large like 100 to highlight entire splits.")
    highlight_max_num: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Set highlight_max_num to control the maximum number of highlights per chunk. If not specified, this defaults to 3. It may be less than 3 if no snippets score above the highlight_threshold.")
    highlight_results: Optional[StrictBool] = Field(default=None, description="Set highlight_results to false for a slight latency improvement (1-10ms). If not specified, this defaults to true. This will add `<b><mark>` tags to the chunk_html of the chunks to highlight matching splits and return the highlights on each scored chunk in the response.")
    highlight_strategy: Optional[HighlightStrategy] = None
    highlight_threshold: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Set highlight_threshold to a lower or higher value to adjust the sensitivity of the highlights applied to the chunk html. If not specified, this defaults to 0.8. The range is 0.0 to 1.0.")
    highlight_window: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Set highlight_window to a number to control the amount of words that are returned around the matched phrases. If not specified, this defaults to 0. This is useful for when you want to show more context around the matched words. When specified, window/2 whitespace separated words are added before and after each highlight in the response's highlights array. If an extended highlight overlaps with another highlight, the overlapping words are only included once. This parameter can be overriden to respect the highlight_max_length param.")
    __properties: ClassVar[List[str]] = ["highlight_delimiters", "highlight_max_length", "highlight_max_num", "highlight_results", "highlight_strategy", "highlight_threshold", "highlight_window"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HighlightOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if highlight_delimiters (nullable) is None
        # and model_fields_set contains the field
        if self.highlight_delimiters is None and "highlight_delimiters" in self.model_fields_set:
            _dict['highlight_delimiters'] = None

        # set to None if highlight_max_length (nullable) is None
        # and model_fields_set contains the field
        if self.highlight_max_length is None and "highlight_max_length" in self.model_fields_set:
            _dict['highlight_max_length'] = None

        # set to None if highlight_max_num (nullable) is None
        # and model_fields_set contains the field
        if self.highlight_max_num is None and "highlight_max_num" in self.model_fields_set:
            _dict['highlight_max_num'] = None

        # set to None if highlight_results (nullable) is None
        # and model_fields_set contains the field
        if self.highlight_results is None and "highlight_results" in self.model_fields_set:
            _dict['highlight_results'] = None

        # set to None if highlight_strategy (nullable) is None
        # and model_fields_set contains the field
        if self.highlight_strategy is None and "highlight_strategy" in self.model_fields_set:
            _dict['highlight_strategy'] = None

        # set to None if highlight_threshold (nullable) is None
        # and model_fields_set contains the field
        if self.highlight_threshold is None and "highlight_threshold" in self.model_fields_set:
            _dict['highlight_threshold'] = None

        # set to None if highlight_window (nullable) is None
        # and model_fields_set contains the field
        if self.highlight_window is None and "highlight_window" in self.model_fields_set:
            _dict['highlight_window'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HighlightOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "highlight_delimiters": obj.get("highlight_delimiters"),
            "highlight_max_length": obj.get("highlight_max_length"),
            "highlight_max_num": obj.get("highlight_max_num"),
            "highlight_results": obj.get("highlight_results"),
            "highlight_strategy": obj.get("highlight_strategy"),
            "highlight_threshold": obj.get("highlight_threshold"),
            "highlight_window": obj.get("highlight_window")
        })
        return _obj


