# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trieve_py_client.models.score_chunk_dto import ScoreChunkDTO
from typing import Optional, Set
from typing_extensions import Self

class GroupScoreChunk(BaseModel):
    """
    GroupScoreChunk
    """ # noqa: E501
    file_id: Optional[StrictStr] = None
    group_created_at: datetime
    group_dataset_id: StrictStr
    group_description: Optional[StrictStr] = None
    group_id: StrictStr
    group_metadata: Optional[Any] = None
    group_name: Optional[StrictStr] = None
    group_tag_set: Optional[List[Optional[StrictStr]]] = None
    group_tracking_id: Optional[StrictStr] = None
    group_updated_at: datetime
    metadata: List[ScoreChunkDTO]
    __properties: ClassVar[List[str]] = ["file_id", "group_created_at", "group_dataset_id", "group_description", "group_id", "group_metadata", "group_name", "group_tag_set", "group_tracking_id", "group_updated_at", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GroupScoreChunk from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in metadata (list)
        _items = []
        if self.metadata:
            for _item in self.metadata:
                if _item:
                    _items.append(_item.to_dict())
            _dict['metadata'] = _items
        # set to None if file_id (nullable) is None
        # and model_fields_set contains the field
        if self.file_id is None and "file_id" in self.model_fields_set:
            _dict['file_id'] = None

        # set to None if group_description (nullable) is None
        # and model_fields_set contains the field
        if self.group_description is None and "group_description" in self.model_fields_set:
            _dict['group_description'] = None

        # set to None if group_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.group_metadata is None and "group_metadata" in self.model_fields_set:
            _dict['group_metadata'] = None

        # set to None if group_name (nullable) is None
        # and model_fields_set contains the field
        if self.group_name is None and "group_name" in self.model_fields_set:
            _dict['group_name'] = None

        # set to None if group_tag_set (nullable) is None
        # and model_fields_set contains the field
        if self.group_tag_set is None and "group_tag_set" in self.model_fields_set:
            _dict['group_tag_set'] = None

        # set to None if group_tracking_id (nullable) is None
        # and model_fields_set contains the field
        if self.group_tracking_id is None and "group_tracking_id" in self.model_fields_set:
            _dict['group_tracking_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GroupScoreChunk from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "file_id": obj.get("file_id"),
            "group_created_at": obj.get("group_created_at"),
            "group_dataset_id": obj.get("group_dataset_id"),
            "group_description": obj.get("group_description"),
            "group_id": obj.get("group_id"),
            "group_metadata": obj.get("group_metadata"),
            "group_name": obj.get("group_name"),
            "group_tag_set": obj.get("group_tag_set"),
            "group_tracking_id": obj.get("group_tracking_id"),
            "group_updated_at": obj.get("group_updated_at"),
            "metadata": [ScoreChunkDTO.from_dict(_item) for _item in obj["metadata"]] if obj.get("metadata") is not None else None
        })
        return _obj


