# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from trieve_py_client.models.recommendation_ctr_metrics1 import RecommendationCTRMetrics1
from trieve_py_client.models.recommendations_with_clicks import RecommendationsWithClicks
from trieve_py_client.models.recommendations_without_clicks import RecommendationsWithoutClicks
from trieve_py_client.models.search_ctr_metrics1 import SearchCTRMetrics1
from trieve_py_client.models.searches_with_clicks import SearchesWithClicks
from trieve_py_client.models.searches_without_clicks import SearchesWithoutClicks
from pydantic import StrictStr, Field
from typing import Union, List, Optional, Dict
from typing_extensions import Literal, Self

CTRANALYTICS_ONE_OF_SCHEMAS = ["RecommendationCTRMetrics1", "RecommendationsWithClicks", "RecommendationsWithoutClicks", "SearchCTRMetrics1", "SearchesWithClicks", "SearchesWithoutClicks"]

class CTRAnalytics(BaseModel):
    """
    CTRAnalytics
    """
    # data type: SearchCTRMetrics1
    oneof_schema_1_validator: Optional[SearchCTRMetrics1] = None
    # data type: SearchesWithClicks
    oneof_schema_2_validator: Optional[SearchesWithClicks] = None
    # data type: SearchesWithoutClicks
    oneof_schema_3_validator: Optional[SearchesWithoutClicks] = None
    # data type: RecommendationCTRMetrics1
    oneof_schema_4_validator: Optional[RecommendationCTRMetrics1] = None
    # data type: RecommendationsWithClicks
    oneof_schema_5_validator: Optional[RecommendationsWithClicks] = None
    # data type: RecommendationsWithoutClicks
    oneof_schema_6_validator: Optional[RecommendationsWithoutClicks] = None
    actual_instance: Optional[Union[RecommendationCTRMetrics1, RecommendationsWithClicks, RecommendationsWithoutClicks, SearchCTRMetrics1, SearchesWithClicks, SearchesWithoutClicks]] = None
    one_of_schemas: List[str] = Field(default=Literal["RecommendationCTRMetrics1", "RecommendationsWithClicks", "RecommendationsWithoutClicks", "SearchCTRMetrics1", "SearchesWithClicks", "SearchesWithoutClicks"])

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = CTRAnalytics.model_construct()
        error_messages = []
        match = 0
        # validate data type: SearchCTRMetrics1
        if not isinstance(v, SearchCTRMetrics1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchCTRMetrics1`")
        else:
            match += 1
        # validate data type: SearchesWithClicks
        if not isinstance(v, SearchesWithClicks):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchesWithClicks`")
        else:
            match += 1
        # validate data type: SearchesWithoutClicks
        if not isinstance(v, SearchesWithoutClicks):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchesWithoutClicks`")
        else:
            match += 1
        # validate data type: RecommendationCTRMetrics1
        if not isinstance(v, RecommendationCTRMetrics1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RecommendationCTRMetrics1`")
        else:
            match += 1
        # validate data type: RecommendationsWithClicks
        if not isinstance(v, RecommendationsWithClicks):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RecommendationsWithClicks`")
        else:
            match += 1
        # validate data type: RecommendationsWithoutClicks
        if not isinstance(v, RecommendationsWithoutClicks):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RecommendationsWithoutClicks`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in CTRAnalytics with oneOf schemas: RecommendationCTRMetrics1, RecommendationsWithClicks, RecommendationsWithoutClicks, SearchCTRMetrics1, SearchesWithClicks, SearchesWithoutClicks. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in CTRAnalytics with oneOf schemas: RecommendationCTRMetrics1, RecommendationsWithClicks, RecommendationsWithoutClicks, SearchCTRMetrics1, SearchesWithClicks, SearchesWithoutClicks. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into SearchCTRMetrics1
        try:
            instance.actual_instance = SearchCTRMetrics1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchesWithClicks
        try:
            instance.actual_instance = SearchesWithClicks.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchesWithoutClicks
        try:
            instance.actual_instance = SearchesWithoutClicks.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RecommendationCTRMetrics1
        try:
            instance.actual_instance = RecommendationCTRMetrics1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RecommendationsWithClicks
        try:
            instance.actual_instance = RecommendationsWithClicks.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RecommendationsWithoutClicks
        try:
            instance.actual_instance = RecommendationsWithoutClicks.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into CTRAnalytics with oneOf schemas: RecommendationCTRMetrics1, RecommendationsWithClicks, RecommendationsWithoutClicks, SearchCTRMetrics1, SearchesWithClicks, SearchesWithoutClicks. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CTRAnalytics with oneOf schemas: RecommendationCTRMetrics1, RecommendationsWithClicks, RecommendationsWithoutClicks, SearchCTRMetrics1, SearchesWithClicks, SearchesWithoutClicks. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RecommendationCTRMetrics1, RecommendationsWithClicks, RecommendationsWithoutClicks, SearchCTRMetrics1, SearchesWithClicks, SearchesWithoutClicks]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


