# coding: utf-8

"""
    Trieve API

    Trieve OpenAPI Specification. This document describes all of the operations available through the Trieve API.

    The version of the OpenAPI document: 0.11.8
    Contact: developers@trieve.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ContentChunkMetadata(BaseModel):
    """
    ContentChunkMetadata
    """ # noqa: E501
    chunk_html: Optional[StrictStr] = None
    id: StrictStr
    image_urls: Optional[List[Optional[StrictStr]]] = None
    num_value: Optional[Union[StrictFloat, StrictInt]] = None
    time_stamp: Optional[datetime] = None
    tracking_id: Optional[StrictStr] = None
    weight: Union[StrictFloat, StrictInt]
    __properties: ClassVar[List[str]] = ["chunk_html", "id", "image_urls", "num_value", "time_stamp", "tracking_id", "weight"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentChunkMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if chunk_html (nullable) is None
        # and model_fields_set contains the field
        if self.chunk_html is None and "chunk_html" in self.model_fields_set:
            _dict['chunk_html'] = None

        # set to None if image_urls (nullable) is None
        # and model_fields_set contains the field
        if self.image_urls is None and "image_urls" in self.model_fields_set:
            _dict['image_urls'] = None

        # set to None if num_value (nullable) is None
        # and model_fields_set contains the field
        if self.num_value is None and "num_value" in self.model_fields_set:
            _dict['num_value'] = None

        # set to None if time_stamp (nullable) is None
        # and model_fields_set contains the field
        if self.time_stamp is None and "time_stamp" in self.model_fields_set:
            _dict['time_stamp'] = None

        # set to None if tracking_id (nullable) is None
        # and model_fields_set contains the field
        if self.tracking_id is None and "tracking_id" in self.model_fields_set:
            _dict['tracking_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentChunkMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chunk_html": obj.get("chunk_html"),
            "id": obj.get("id"),
            "image_urls": obj.get("image_urls"),
            "num_value": obj.get("num_value"),
            "time_stamp": obj.get("time_stamp"),
            "tracking_id": obj.get("tracking_id"),
            "weight": obj.get("weight")
        })
        return _obj


