# Contributing to SARIF Courier

Thank you for your interest in contributing to SARIF Courier! We welcome contributions of all kinds, including bug reports, feature requests, documentation improvements, and code contributions.

## How to Contribute

1. **Fork the repository** and create your branch from `main`.
2. **Open an issue** to discuss your proposed change before making a PR.
3. **Write clear, concise commit messages**.
4. **Add tests** for new features or bug fixes when possible.
5. **Ensure your code passes at least build run** (`npm run build`).
6. **Open a pull request** with a clear description of your changes.

## Code Style
- Use Prettier and ESLint for formatting and linting.
- Follow the existing code style and conventions.

## Reporting Issues
- Please use the [GitHub Issues](../../issues) to report bugs or request features.
- Include as much detail as possible, including steps to reproduce and relevant logs or screenshots.

## Community
- Be respectful and inclusive.
- See our [Code of Conduct](./CODE_OF_CONDUCT.md).

Thank you for helping make SARIF Courier better!
