# Gemini API using Firebase AI Logic

Build AI-powered mobile and web apps and features with the Gemini and Imagen models using Firebase AI Logic

## Docs

- [Gemini API using Firebase AI Logic](./docs/ai-logic/ai-logic.md): Build AI-powered mobile and web apps and features with the Gemini and Imagen models using Firebase AI Logic
- [Analyze audio files using the Gemini API](./docs/ai-logic/analyze-audio.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Analyze documents (like PDFs) using the Gemini API](./docs/ai-logic/analyze-documents.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Analyze image files using the Gemini API](./docs/ai-logic/analyze-images.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Implement Firebase App Check to protect APIs from unauthorized clients](./docs/ai-logic/app-check.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Build multi-turn conversations (chat) using the Gemini API](./docs/ai-logic/chat.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Audit logging for Firebase AI Logic](./docs/ai-logic/cloud-audit-logging.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Function calling using the Gemini API](./docs/ai-logic/function-calling.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Generate audio using the Gemini API](./docs/ai-logic/generate-audio.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Supported input files and requirements](./docs/ai-logic/input-file-requirements.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Bidirectional streaming using the Gemini Live API](./docs/ai-logic/live-api.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Migrate to the Firebase AI Logic SDKs from the Google AI client SDKs](./docs/ai-logic/migrate-from-google-ai-client-sdks.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Migrate to the Firebase AI Logic SDKs from the GA version of Vertex AI in Firebase SDKs](./docs/ai-logic/migrate-to-latest-sdk.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Use model configuration to control responses](./docs/ai-logic/model-parameters.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Understand prompt design](./docs/ai-logic/prompt-design.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Reference documentation for the Firebase AI Logic SDKs](./docs/ai-logic/ref-docs.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Understand and use safety settings](./docs/ai-logic/safety-settings.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Overview: Firebase AI Logic solutions](./docs/ai-logic/solutions/overview.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Dynamically update your Firebase AI Logic app with Firebase Remote Config](./docs/ai-logic/solutions/remote-config.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Use system instructions to steer the behavior of a model](./docs/ai-logic/system-instructions.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Thinking](./docs/ai-logic/thinking.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Analyze video files using the Gemini API](./docs/ai-logic/analyze-video.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Options to control generation of responses](./docs/ai-logic/control-content-gen.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Count tokens for Gemini models](./docs/ai-logic/count-tokens.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
- [Data governance & Responsible AI](./docs/ai-logic/data-governance.md): Build AI-powered mobile and web apps and features with the Gemini API using Firebase AI Logic
