import { Document, IProcessor } from './types';
import { HtmlProcessor  } from './html_processor';
import { MarkdownProcessor } from './markdown_processor';

export class ContentProcessor implements IProcessor {
  #htmlProcessor: HtmlProcessor;
  #markdownProcessor: MarkdownProcessor;

  constructor() { 
    this.#htmlProcessor = new HtmlProcessor();
    this.#markdownProcessor = new MarkdownProcessor();
  }

  process({ content, baseUrl }: { content: string, baseUrl: string; }): Document {
    const isHtml = content.trim().startsWith('<');
    const processor = isHtml ? this.#htmlProcessor : this.#markdownProcessor;
    return processor.process({ content, baseUrl });
  }

}