# Git Commit Strategy
- Always create a new branch using this convention: `feat/implement-resolver`, `fix/use-correct-header` for a task. Identify the branch name using <task-category>/<task-concise-name> for each task.
- Create a comprehensive git commit message of the work that was done for that task.
- Merge the commit to main.
- Think of the git commit log not just as traditional git commits but as a ledger of your work that serves as an audit trail that can be parsed and understood to catch up on the state of the project or to find the work done on a past task for better context.

# Conventions
- Always use `snake_case.ts` for naming files.
- Always use ESM over CJS.
- Use node virtual modules, ex: `import { resolve } from 'node:path';`.