import classNames from "classnames";

export function VercelLogo({ className }: { className?: string }) {
  return (
    <svg
      className={classNames(className, "dark:fill-white fill-black")}
      fill="none"
      height={22}
      viewBox="0 0 235 203"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path d="M117.082 0L234.164 202.794H0L117.082 0Z" fill="currentColor" />
    </svg>
  );
}

export function TurborepoLogo({ className }: { className?: string }) {
  return (
    <svg
      className={className}
      fill="none"
      height="100"
      viewBox="0 0 100 100"
      width="100"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        className="dark:fill-white fill-black"
        d="M49.5423 17.3221C31.7763 17.3221 17.3223 31.7761 17.3223 49.5421C17.3223 67.3081 31.7763 81.7621 49.5423 81.7621C67.3083 81.7621 81.7623 67.3081 81.7623 49.5421C81.7623 31.7761 67.3083 17.3221 49.5423 17.3221ZM49.5423 66.2161C40.3323 66.2161 32.8683 58.7521 32.8683 49.5421C32.8683 40.3321 40.3323 32.8681 49.5423 32.8681C58.7523 32.8681 66.2163 40.3321 66.2163 49.5421C66.2163 58.7521 58.7523 66.2161 49.5423 66.2161Z"
      />
      <path
        clipRule="evenodd"
        d="M52.2419 12.03V0C78.3899 1.398 99.162 23.046 99.162 49.542C99.162 76.038 78.3899 97.68 52.2419 99.084V87.054C71.7299 85.662 87.1619 69.378 87.1619 49.542C87.1619 29.706 71.7299 13.422 52.2419 12.03ZM21.126 74.1419C15.96 68.1779 12.63 60.5819 12.036 52.2419H0C0.624 63.9119 5.292 74.5019 12.606 82.6559L21.12 74.1419H21.126ZM46.8421 99.084V87.054C38.4961 86.46 30.9001 83.136 24.9361 77.964L16.4221 86.478C24.5821 93.798 35.1721 98.46 46.8361 99.084H46.8421Z"
        fill="url(#paint0_linear_2758_13788)"
        fillRule="evenodd"
      />
      <defs>
        <linearGradient
          gradientUnits="userSpaceOnUse"
          id="paint0_linear_2758_13788"
          x1="54.1863"
          x2="5.4184"
          y1="6.9667"
          y2="55.7346"
        >
          <stop stopColor="#0096FF" />
          <stop offset="1" stopColor="#FF1E56" />
        </linearGradient>
      </defs>
    </svg>
  );
}

export function TurbopackLogo({ className }: { className?: string }) {
  return (
    <svg
      className={className}
      fill="none"
      height="100"
      viewBox="0 0 100 100"
      width="100"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        className="dark:fill-white fill-black"
        clipRule="evenodd"
        d="M38.6868 36.6983C37.5559 36.6983 36.6391 37.6151 36.6391 38.7459V61.5202C36.6391 62.651 37.5559 63.5678 38.6868 63.5678H61.461C62.5919 63.5678 63.5086 62.651 63.5086 61.5202V38.7459C63.5086 37.6151 62.5919 36.6983 61.461 36.6983H38.6868ZM22.259 20.4426C21.2232 20.4426 20.3834 21.2823 20.3834 22.3182V77.9479C20.3834 78.9838 21.2232 79.8235 22.259 79.8235H77.8887C78.9246 79.8235 79.7643 78.9838 79.7643 77.9479V22.3182C79.7643 21.2823 78.9246 20.4426 77.8887 20.4426H22.259Z"
        fillRule="evenodd"
      />
      <path
        d="M0 51.0638V87.234C0 89.6609 0.677167 91.9295 1.85286 93.8614L14.8936 80.8206V51.0638H0Z"
        fill="url(#paint0_linear_2758_13848)"
      />
      <path
        d="M5.94644 98.0278L18.8765 85.0978C18.9666 85.1035 19.0574 85.1064 19.1489 85.1064H47.6402V100H12.766C10.2582 100 7.91931 99.2769 5.94644 98.0278Z"
        fill="url(#paint1_linear_2758_13848)"
      />
      <path
        d="M53.481 100H87.234C94.2845 100 100 94.2845 100 87.234V12.766C100 5.71551 94.2845 0 87.234 0H51.0638V14.8936H80.8511C83.2012 14.8936 85.1064 16.7988 85.1064 19.1489V80.8511C85.1064 83.2012 83.2012 85.1064 80.8511 85.1064H53.481V100Z"
        fill="url(#paint2_linear_2758_13848)"
      />
      <defs>
        <linearGradient
          gradientUnits="userSpaceOnUse"
          id="paint0_linear_2758_13848"
          x1="54.9167"
          x2="5.69936"
          y1="7.03125"
          y2="55.9148"
        >
          <stop stopColor="#0096FF" />
          <stop offset="1" stopColor="#FF1E56" />
        </linearGradient>
        <linearGradient
          gradientUnits="userSpaceOnUse"
          id="paint1_linear_2758_13848"
          x1="54.9167"
          x2="5.69936"
          y1="7.03125"
          y2="55.9148"
        >
          <stop stopColor="#0096FF" />
          <stop offset="1" stopColor="#FF1E56" />
        </linearGradient>
        <linearGradient
          gradientUnits="userSpaceOnUse"
          id="paint2_linear_2758_13848"
          x1="54.9167"
          x2="5.69936"
          y1="7.03125"
          y2="55.9148"
        >
          <stop stopColor="#0096FF" />
          <stop offset="1" stopColor="#FF1E56" />
        </linearGradient>
      </defs>
    </svg>
  );
}

export function NextJSLogo({ className }: { className?: string }) {
  return (
    <svg
      className={className}
      fill="none"
      height="180"
      viewBox="0 0 180 180"
      width="180"
      xmlns="http://www.w3.org/2000/svg"
    >
      <mask
        height="180"
        id="mask0_408_139"
        maskUnits="userSpaceOnUse"
        style={{ maskType: "alpha" }}
        width="180"
        x="0"
        y="0"
      >
        <circle cx="90" cy="90" fill="black" r="90" />
      </mask>
      <g mask="url(#mask0_408_139)">
        <circle
          cx="90"
          cy="90"
          fill="black"
          r="87"
          stroke="white"
          strokeWidth="6"
        />
        <path
          d="M149.508 157.52L69.142 54H54V125.97H66.1136V69.3836L139.999 164.845C143.333 162.614 146.509 160.165 149.508 157.52Z"
          fill="url(#paint0_linear_408_139)"
        />
        <rect
          fill="url(#paint1_linear_408_139)"
          height="72"
          width="12"
          x="115"
          y="54"
        />
      </g>
      <defs>
        <linearGradient
          gradientUnits="userSpaceOnUse"
          id="paint0_linear_408_139"
          x1="109"
          x2="144.5"
          y1="116.5"
          y2="160.5"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          gradientUnits="userSpaceOnUse"
          id="paint1_linear_408_139"
          x1="121"
          x2="120.799"
          y1="54"
          y2="106.875"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
      </defs>
    </svg>
  );
}

export function DesignSystemLogo({ className }: { className?: string }) {
  return (
    <svg
      className={className}
      data-testid="geist-icon"
      fill="none"
      height="24"
      shapeRendering="geometricPrecision"
      stroke="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeWidth="1.5"
      viewBox="0 0 24 24"
      width="24"
    >
      <path
        clipRule="evenodd"
        d="M9.67025 6.612L9.09631 7.63233L10.4037 8.36772L10.9772 7.34818C10.4872 7.1987 10.0429 6.94464 9.67025 6.612ZM13.0228 7.34818L13.5963 8.36772L14.9037 7.63233L14.3297 6.612C13.9571 6.94464 13.5128 7.1987 13.0228 7.34818ZM6.41944 20.75C6.4722 20.5084 6.49999 20.2574 6.49999 20C6.49999 19.7426 6.4722 19.4916 6.41945 19.25H7.49999V20.75H6.41944ZM5.32976 17.388L5.90367 16.3677L4.59631 15.6323L4.02284 16.6518C4.51277 16.8013 4.95708 17.0554 5.32976 17.388ZM17.5805 19.25C17.5278 19.4916 17.5 19.7426 17.5 20C17.5 20.2574 17.5278 20.5084 17.5805 20.75H16.5V19.25H17.5805ZM19.9771 16.6518C19.4872 16.8013 19.0429 17.0554 18.6702 17.388L18.0963 16.3677L19.4037 15.6323L19.9771 16.6518ZM9.50367 9.96772L8.60367 11.5677L7.29631 10.8323L8.19631 9.23233L9.50367 9.96772ZM7.70367 13.1677L6.80367 14.7677L5.49631 14.0323L6.39631 12.4323L7.70367 13.1677ZM15.3963 11.5677L14.4963 9.96772L15.8037 9.23233L16.7037 10.8323L15.3963 11.5677ZM17.1963 14.7677L16.2963 13.1677L17.6037 12.4323L18.5037 14.0323L17.1963 14.7677ZM12.9 20.75H14.7V19.25H12.9V20.75ZM9.29999 20.75H11.1V19.25H9.29999V20.75Z"
        fill="currentColor"
        fillRule="evenodd"
        strokeWidth="0"
      />
      <circle cx="12" cy="4" r="2" stroke="currentColor" strokeWidth="1.5" />
      <circle cx="3" cy="20" r="2" stroke="currentColor" strokeWidth="1.5" />
      <circle cx="21" cy="20" r="2" stroke="currentColor" strokeWidth="1.5" />
    </svg>
  );
}

export function IconType({ className }: { className?: string }) {
  return (
    <svg
      className={className}
      data-testid="geist-icon"
      fill="none"
      height="24"
      shapeRendering="geometricPrecision"
      stroke="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeWidth="1.5"
      viewBox="0 0 24 24"
      width="24"
    >
      <path d="M4 7V4h16v3" />
      <path d="M9 20h6" />
      <path d="M12 4v16" />
    </svg>
  );
}
