// Code generated by capnpc-go. DO NOT EDIT.

package schema

import (
	capnp "capnproto.org/go/capnp/v3"
	text "capnproto.org/go/capnp/v3/encoding/text"
	schemas "capnproto.org/go/capnp/v3/schemas"
	math "math"
	strconv "strconv"
)

// Constants defined in schema.capnp.
const (
	Field_noDiscriminant = uint16(65535)
)

type Node capnp.Struct
type Node_structNode Node
type Node_enum Node
type Node_interface Node
type Node_const Node
type Node_annotation Node
type Node_Which uint16

const (
	Node_Which_file       Node_Which = 0
	Node_Which_structNode Node_Which = 1
	Node_Which_enum       Node_Which = 2
	Node_Which_interface  Node_Which = 3
	Node_Which_const      Node_Which = 4
	Node_Which_annotation Node_Which = 5
)

func (w Node_Which) String() string {
	const s = "filestructNodeenuminterfaceconstannotation"
	switch w {
	case Node_Which_file:
		return s[0:4]
	case Node_Which_structNode:
		return s[4:14]
	case Node_Which_enum:
		return s[14:18]
	case Node_Which_interface:
		return s[18:27]
	case Node_Which_const:
		return s[27:32]
	case Node_Which_annotation:
		return s[32:42]

	}
	return "Node_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Node_TypeID is the unique identifier for the type Node.
const Node_TypeID = 0xe682ab4cf923a417

func NewNode(s *capnp.Segment) (Node, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 40, PointerCount: 6})
	return Node(st), err
}

func NewRootNode(s *capnp.Segment) (Node, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 40, PointerCount: 6})
	return Node(st), err
}

func ReadRootNode(msg *capnp.Message) (Node, error) {
	root, err := msg.Root()
	return Node(root.Struct()), err
}

func (s Node) String() string {
	str, _ := text.Marshal(0xe682ab4cf923a417, capnp.Struct(s))
	return str
}

func (s Node) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Node) DecodeFromPtr(p capnp.Ptr) Node {
	return Node(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Node) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Node) Which() Node_Which {
	return Node_Which(capnp.Struct(s).Uint16(12))
}
func (s Node) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node) Id() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s Node) SetId(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s Node) DisplayName() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Node) HasDisplayName() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Node) DisplayNameBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Node) SetDisplayName(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Node) DisplayNamePrefixLength() uint32 {
	return capnp.Struct(s).Uint32(8)
}

func (s Node) SetDisplayNamePrefixLength(v uint32) {
	capnp.Struct(s).SetUint32(8, v)
}

func (s Node) ScopeId() uint64 {
	return capnp.Struct(s).Uint64(16)
}

func (s Node) SetScopeId(v uint64) {
	capnp.Struct(s).SetUint64(16, v)
}

func (s Node) Parameters() (Node_Parameter_List, error) {
	p, err := capnp.Struct(s).Ptr(5)
	return Node_Parameter_List(p.List()), err
}

func (s Node) HasParameters() bool {
	return capnp.Struct(s).HasPtr(5)
}

func (s Node) SetParameters(v Node_Parameter_List) error {
	return capnp.Struct(s).SetPtr(5, v.ToPtr())
}

// NewParameters sets the parameters field to a newly
// allocated Node_Parameter_List, preferring placement in s's segment.
func (s Node) NewParameters(n int32) (Node_Parameter_List, error) {
	l, err := NewNode_Parameter_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Node_Parameter_List{}, err
	}
	err = capnp.Struct(s).SetPtr(5, l.ToPtr())
	return l, err
}
func (s Node) IsGeneric() bool {
	return capnp.Struct(s).Bit(288)
}

func (s Node) SetIsGeneric(v bool) {
	capnp.Struct(s).SetBit(288, v)
}

func (s Node) NestedNodes() (Node_NestedNode_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Node_NestedNode_List(p.List()), err
}

func (s Node) HasNestedNodes() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Node) SetNestedNodes(v Node_NestedNode_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewNestedNodes sets the nestedNodes field to a newly
// allocated Node_NestedNode_List, preferring placement in s's segment.
func (s Node) NewNestedNodes(n int32) (Node_NestedNode_List, error) {
	l, err := NewNode_NestedNode_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Node_NestedNode_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}
func (s Node) Annotations() (Annotation_List, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return Annotation_List(p.List()), err
}

func (s Node) HasAnnotations() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Node) SetAnnotations(v Annotation_List) error {
	return capnp.Struct(s).SetPtr(2, v.ToPtr())
}

// NewAnnotations sets the annotations field to a newly
// allocated Annotation_List, preferring placement in s's segment.
func (s Node) NewAnnotations(n int32) (Annotation_List, error) {
	l, err := NewAnnotation_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Annotation_List{}, err
	}
	err = capnp.Struct(s).SetPtr(2, l.ToPtr())
	return l, err
}
func (s Node) SetFile() {
	capnp.Struct(s).SetUint16(12, 0)

}

func (s Node) StructNode() Node_structNode { return Node_structNode(s) }

func (s Node) SetStructNode() {
	capnp.Struct(s).SetUint16(12, 1)
}

func (s Node_structNode) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node_structNode) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node_structNode) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node_structNode) DataWordCount() uint16 {
	return capnp.Struct(s).Uint16(14)
}

func (s Node_structNode) SetDataWordCount(v uint16) {
	capnp.Struct(s).SetUint16(14, v)
}

func (s Node_structNode) PointerCount() uint16 {
	return capnp.Struct(s).Uint16(24)
}

func (s Node_structNode) SetPointerCount(v uint16) {
	capnp.Struct(s).SetUint16(24, v)
}

func (s Node_structNode) PreferredListEncoding() ElementSize {
	return ElementSize(capnp.Struct(s).Uint16(26))
}

func (s Node_structNode) SetPreferredListEncoding(v ElementSize) {
	capnp.Struct(s).SetUint16(26, uint16(v))
}

func (s Node_structNode) IsGroup() bool {
	return capnp.Struct(s).Bit(224)
}

func (s Node_structNode) SetIsGroup(v bool) {
	capnp.Struct(s).SetBit(224, v)
}

func (s Node_structNode) DiscriminantCount() uint16 {
	return capnp.Struct(s).Uint16(30)
}

func (s Node_structNode) SetDiscriminantCount(v uint16) {
	capnp.Struct(s).SetUint16(30, v)
}

func (s Node_structNode) DiscriminantOffset() uint32 {
	return capnp.Struct(s).Uint32(32)
}

func (s Node_structNode) SetDiscriminantOffset(v uint32) {
	capnp.Struct(s).SetUint32(32, v)
}

func (s Node_structNode) Fields() (Field_List, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return Field_List(p.List()), err
}

func (s Node_structNode) HasFields() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Node_structNode) SetFields(v Field_List) error {
	return capnp.Struct(s).SetPtr(3, v.ToPtr())
}

// NewFields sets the fields field to a newly
// allocated Field_List, preferring placement in s's segment.
func (s Node_structNode) NewFields(n int32) (Field_List, error) {
	l, err := NewField_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Field_List{}, err
	}
	err = capnp.Struct(s).SetPtr(3, l.ToPtr())
	return l, err
}
func (s Node) Enum() Node_enum { return Node_enum(s) }

func (s Node) SetEnum() {
	capnp.Struct(s).SetUint16(12, 2)
}

func (s Node_enum) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node_enum) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node_enum) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node_enum) Enumerants() (Enumerant_List, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return Enumerant_List(p.List()), err
}

func (s Node_enum) HasEnumerants() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Node_enum) SetEnumerants(v Enumerant_List) error {
	return capnp.Struct(s).SetPtr(3, v.ToPtr())
}

// NewEnumerants sets the enumerants field to a newly
// allocated Enumerant_List, preferring placement in s's segment.
func (s Node_enum) NewEnumerants(n int32) (Enumerant_List, error) {
	l, err := NewEnumerant_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Enumerant_List{}, err
	}
	err = capnp.Struct(s).SetPtr(3, l.ToPtr())
	return l, err
}
func (s Node) Interface() Node_interface { return Node_interface(s) }

func (s Node) SetInterface() {
	capnp.Struct(s).SetUint16(12, 3)
}

func (s Node_interface) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node_interface) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node_interface) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node_interface) Methods() (Method_List, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return Method_List(p.List()), err
}

func (s Node_interface) HasMethods() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Node_interface) SetMethods(v Method_List) error {
	return capnp.Struct(s).SetPtr(3, v.ToPtr())
}

// NewMethods sets the methods field to a newly
// allocated Method_List, preferring placement in s's segment.
func (s Node_interface) NewMethods(n int32) (Method_List, error) {
	l, err := NewMethod_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Method_List{}, err
	}
	err = capnp.Struct(s).SetPtr(3, l.ToPtr())
	return l, err
}
func (s Node_interface) Superclasses() (Superclass_List, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return Superclass_List(p.List()), err
}

func (s Node_interface) HasSuperclasses() bool {
	return capnp.Struct(s).HasPtr(4)
}

func (s Node_interface) SetSuperclasses(v Superclass_List) error {
	return capnp.Struct(s).SetPtr(4, v.ToPtr())
}

// NewSuperclasses sets the superclasses field to a newly
// allocated Superclass_List, preferring placement in s's segment.
func (s Node_interface) NewSuperclasses(n int32) (Superclass_List, error) {
	l, err := NewSuperclass_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Superclass_List{}, err
	}
	err = capnp.Struct(s).SetPtr(4, l.ToPtr())
	return l, err
}
func (s Node) Const() Node_const { return Node_const(s) }

func (s Node) SetConst() {
	capnp.Struct(s).SetUint16(12, 4)
}

func (s Node_const) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node_const) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node_const) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node_const) Type() (Type, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return Type(p.Struct()), err
}

func (s Node_const) HasType() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Node_const) SetType(v Type) error {
	return capnp.Struct(s).SetPtr(3, capnp.Struct(v).ToPtr())
}

// NewType sets the type field to a newly
// allocated Type struct, preferring placement in s's segment.
func (s Node_const) NewType() (Type, error) {
	ss, err := NewType(capnp.Struct(s).Segment())
	if err != nil {
		return Type{}, err
	}
	err = capnp.Struct(s).SetPtr(3, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Node_const) Value() (Value, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return Value(p.Struct()), err
}

func (s Node_const) HasValue() bool {
	return capnp.Struct(s).HasPtr(4)
}

func (s Node_const) SetValue(v Value) error {
	return capnp.Struct(s).SetPtr(4, capnp.Struct(v).ToPtr())
}

// NewValue sets the value field to a newly
// allocated Value struct, preferring placement in s's segment.
func (s Node_const) NewValue() (Value, error) {
	ss, err := NewValue(capnp.Struct(s).Segment())
	if err != nil {
		return Value{}, err
	}
	err = capnp.Struct(s).SetPtr(4, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Node) Annotation() Node_annotation { return Node_annotation(s) }

func (s Node) SetAnnotation() {
	capnp.Struct(s).SetUint16(12, 5)
}

func (s Node_annotation) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node_annotation) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node_annotation) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node_annotation) Type() (Type, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return Type(p.Struct()), err
}

func (s Node_annotation) HasType() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Node_annotation) SetType(v Type) error {
	return capnp.Struct(s).SetPtr(3, capnp.Struct(v).ToPtr())
}

// NewType sets the type field to a newly
// allocated Type struct, preferring placement in s's segment.
func (s Node_annotation) NewType() (Type, error) {
	ss, err := NewType(capnp.Struct(s).Segment())
	if err != nil {
		return Type{}, err
	}
	err = capnp.Struct(s).SetPtr(3, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Node_annotation) TargetsFile() bool {
	return capnp.Struct(s).Bit(112)
}

func (s Node_annotation) SetTargetsFile(v bool) {
	capnp.Struct(s).SetBit(112, v)
}

func (s Node_annotation) TargetsConst() bool {
	return capnp.Struct(s).Bit(113)
}

func (s Node_annotation) SetTargetsConst(v bool) {
	capnp.Struct(s).SetBit(113, v)
}

func (s Node_annotation) TargetsEnum() bool {
	return capnp.Struct(s).Bit(114)
}

func (s Node_annotation) SetTargetsEnum(v bool) {
	capnp.Struct(s).SetBit(114, v)
}

func (s Node_annotation) TargetsEnumerant() bool {
	return capnp.Struct(s).Bit(115)
}

func (s Node_annotation) SetTargetsEnumerant(v bool) {
	capnp.Struct(s).SetBit(115, v)
}

func (s Node_annotation) TargetsStruct() bool {
	return capnp.Struct(s).Bit(116)
}

func (s Node_annotation) SetTargetsStruct(v bool) {
	capnp.Struct(s).SetBit(116, v)
}

func (s Node_annotation) TargetsField() bool {
	return capnp.Struct(s).Bit(117)
}

func (s Node_annotation) SetTargetsField(v bool) {
	capnp.Struct(s).SetBit(117, v)
}

func (s Node_annotation) TargetsUnion() bool {
	return capnp.Struct(s).Bit(118)
}

func (s Node_annotation) SetTargetsUnion(v bool) {
	capnp.Struct(s).SetBit(118, v)
}

func (s Node_annotation) TargetsGroup() bool {
	return capnp.Struct(s).Bit(119)
}

func (s Node_annotation) SetTargetsGroup(v bool) {
	capnp.Struct(s).SetBit(119, v)
}

func (s Node_annotation) TargetsInterface() bool {
	return capnp.Struct(s).Bit(120)
}

func (s Node_annotation) SetTargetsInterface(v bool) {
	capnp.Struct(s).SetBit(120, v)
}

func (s Node_annotation) TargetsMethod() bool {
	return capnp.Struct(s).Bit(121)
}

func (s Node_annotation) SetTargetsMethod(v bool) {
	capnp.Struct(s).SetBit(121, v)
}

func (s Node_annotation) TargetsParam() bool {
	return capnp.Struct(s).Bit(122)
}

func (s Node_annotation) SetTargetsParam(v bool) {
	capnp.Struct(s).SetBit(122, v)
}

func (s Node_annotation) TargetsAnnotation() bool {
	return capnp.Struct(s).Bit(123)
}

func (s Node_annotation) SetTargetsAnnotation(v bool) {
	capnp.Struct(s).SetBit(123, v)
}

// Node_List is a list of Node.
type Node_List = capnp.StructList[Node]

// NewNode creates a new list of Node.
func NewNode_List(s *capnp.Segment, sz int32) (Node_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 40, PointerCount: 6}, sz)
	return capnp.StructList[Node](l), err
}

// Node_Future is a wrapper for a Node promised by a client call.
type Node_Future struct{ *capnp.Future }

func (f Node_Future) Struct() (Node, error) {
	p, err := f.Future.Ptr()
	return Node(p.Struct()), err
}
func (p Node_Future) StructNode() Node_structNode_Future { return Node_structNode_Future{p.Future} }

// Node_structNode_Future is a wrapper for a Node_structNode promised by a client call.
type Node_structNode_Future struct{ *capnp.Future }

func (f Node_structNode_Future) Struct() (Node_structNode, error) {
	p, err := f.Future.Ptr()
	return Node_structNode(p.Struct()), err
}
func (p Node_Future) Enum() Node_enum_Future { return Node_enum_Future{p.Future} }

// Node_enum_Future is a wrapper for a Node_enum promised by a client call.
type Node_enum_Future struct{ *capnp.Future }

func (f Node_enum_Future) Struct() (Node_enum, error) {
	p, err := f.Future.Ptr()
	return Node_enum(p.Struct()), err
}
func (p Node_Future) Interface() Node_interface_Future { return Node_interface_Future{p.Future} }

// Node_interface_Future is a wrapper for a Node_interface promised by a client call.
type Node_interface_Future struct{ *capnp.Future }

func (f Node_interface_Future) Struct() (Node_interface, error) {
	p, err := f.Future.Ptr()
	return Node_interface(p.Struct()), err
}
func (p Node_Future) Const() Node_const_Future { return Node_const_Future{p.Future} }

// Node_const_Future is a wrapper for a Node_const promised by a client call.
type Node_const_Future struct{ *capnp.Future }

func (f Node_const_Future) Struct() (Node_const, error) {
	p, err := f.Future.Ptr()
	return Node_const(p.Struct()), err
}
func (p Node_const_Future) Type() Type_Future {
	return Type_Future{Future: p.Future.Field(3, nil)}
}
func (p Node_const_Future) Value() Value_Future {
	return Value_Future{Future: p.Future.Field(4, nil)}
}
func (p Node_Future) Annotation() Node_annotation_Future { return Node_annotation_Future{p.Future} }

// Node_annotation_Future is a wrapper for a Node_annotation promised by a client call.
type Node_annotation_Future struct{ *capnp.Future }

func (f Node_annotation_Future) Struct() (Node_annotation, error) {
	p, err := f.Future.Ptr()
	return Node_annotation(p.Struct()), err
}
func (p Node_annotation_Future) Type() Type_Future {
	return Type_Future{Future: p.Future.Field(3, nil)}
}

type Node_Parameter capnp.Struct

// Node_Parameter_TypeID is the unique identifier for the type Node_Parameter.
const Node_Parameter_TypeID = 0xb9521bccf10fa3b1

func NewNode_Parameter(s *capnp.Segment) (Node_Parameter, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Node_Parameter(st), err
}

func NewRootNode_Parameter(s *capnp.Segment) (Node_Parameter, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Node_Parameter(st), err
}

func ReadRootNode_Parameter(msg *capnp.Message) (Node_Parameter, error) {
	root, err := msg.Root()
	return Node_Parameter(root.Struct()), err
}

func (s Node_Parameter) String() string {
	str, _ := text.Marshal(0xb9521bccf10fa3b1, capnp.Struct(s))
	return str
}

func (s Node_Parameter) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Node_Parameter) DecodeFromPtr(p capnp.Ptr) Node_Parameter {
	return Node_Parameter(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Node_Parameter) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Node_Parameter) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node_Parameter) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node_Parameter) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node_Parameter) Name() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Node_Parameter) HasName() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Node_Parameter) NameBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Node_Parameter) SetName(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

// Node_Parameter_List is a list of Node_Parameter.
type Node_Parameter_List = capnp.StructList[Node_Parameter]

// NewNode_Parameter creates a new list of Node_Parameter.
func NewNode_Parameter_List(s *capnp.Segment, sz int32) (Node_Parameter_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Node_Parameter](l), err
}

// Node_Parameter_Future is a wrapper for a Node_Parameter promised by a client call.
type Node_Parameter_Future struct{ *capnp.Future }

func (f Node_Parameter_Future) Struct() (Node_Parameter, error) {
	p, err := f.Future.Ptr()
	return Node_Parameter(p.Struct()), err
}

type Node_NestedNode capnp.Struct

// Node_NestedNode_TypeID is the unique identifier for the type Node_NestedNode.
const Node_NestedNode_TypeID = 0xdebf55bbfa0fc242

func NewNode_NestedNode(s *capnp.Segment) (Node_NestedNode, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Node_NestedNode(st), err
}

func NewRootNode_NestedNode(s *capnp.Segment) (Node_NestedNode, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Node_NestedNode(st), err
}

func ReadRootNode_NestedNode(msg *capnp.Message) (Node_NestedNode, error) {
	root, err := msg.Root()
	return Node_NestedNode(root.Struct()), err
}

func (s Node_NestedNode) String() string {
	str, _ := text.Marshal(0xdebf55bbfa0fc242, capnp.Struct(s))
	return str
}

func (s Node_NestedNode) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Node_NestedNode) DecodeFromPtr(p capnp.Ptr) Node_NestedNode {
	return Node_NestedNode(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Node_NestedNode) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Node_NestedNode) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node_NestedNode) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node_NestedNode) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node_NestedNode) Name() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Node_NestedNode) HasName() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Node_NestedNode) NameBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Node_NestedNode) SetName(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Node_NestedNode) Id() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s Node_NestedNode) SetId(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

// Node_NestedNode_List is a list of Node_NestedNode.
type Node_NestedNode_List = capnp.StructList[Node_NestedNode]

// NewNode_NestedNode creates a new list of Node_NestedNode.
func NewNode_NestedNode_List(s *capnp.Segment, sz int32) (Node_NestedNode_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Node_NestedNode](l), err
}

// Node_NestedNode_Future is a wrapper for a Node_NestedNode promised by a client call.
type Node_NestedNode_Future struct{ *capnp.Future }

func (f Node_NestedNode_Future) Struct() (Node_NestedNode, error) {
	p, err := f.Future.Ptr()
	return Node_NestedNode(p.Struct()), err
}

type Node_SourceInfo capnp.Struct

// Node_SourceInfo_TypeID is the unique identifier for the type Node_SourceInfo.
const Node_SourceInfo_TypeID = 0xf38e1de3041357ae

func NewNode_SourceInfo(s *capnp.Segment) (Node_SourceInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Node_SourceInfo(st), err
}

func NewRootNode_SourceInfo(s *capnp.Segment) (Node_SourceInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Node_SourceInfo(st), err
}

func ReadRootNode_SourceInfo(msg *capnp.Message) (Node_SourceInfo, error) {
	root, err := msg.Root()
	return Node_SourceInfo(root.Struct()), err
}

func (s Node_SourceInfo) String() string {
	str, _ := text.Marshal(0xf38e1de3041357ae, capnp.Struct(s))
	return str
}

func (s Node_SourceInfo) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Node_SourceInfo) DecodeFromPtr(p capnp.Ptr) Node_SourceInfo {
	return Node_SourceInfo(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Node_SourceInfo) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Node_SourceInfo) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node_SourceInfo) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node_SourceInfo) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node_SourceInfo) Id() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s Node_SourceInfo) SetId(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s Node_SourceInfo) DocComment() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Node_SourceInfo) HasDocComment() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Node_SourceInfo) DocCommentBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Node_SourceInfo) SetDocComment(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Node_SourceInfo) Members() (Node_SourceInfo_Member_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Node_SourceInfo_Member_List(p.List()), err
}

func (s Node_SourceInfo) HasMembers() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Node_SourceInfo) SetMembers(v Node_SourceInfo_Member_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewMembers sets the members field to a newly
// allocated Node_SourceInfo_Member_List, preferring placement in s's segment.
func (s Node_SourceInfo) NewMembers(n int32) (Node_SourceInfo_Member_List, error) {
	l, err := NewNode_SourceInfo_Member_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Node_SourceInfo_Member_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

// Node_SourceInfo_List is a list of Node_SourceInfo.
type Node_SourceInfo_List = capnp.StructList[Node_SourceInfo]

// NewNode_SourceInfo creates a new list of Node_SourceInfo.
func NewNode_SourceInfo_List(s *capnp.Segment, sz int32) (Node_SourceInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Node_SourceInfo](l), err
}

// Node_SourceInfo_Future is a wrapper for a Node_SourceInfo promised by a client call.
type Node_SourceInfo_Future struct{ *capnp.Future }

func (f Node_SourceInfo_Future) Struct() (Node_SourceInfo, error) {
	p, err := f.Future.Ptr()
	return Node_SourceInfo(p.Struct()), err
}

type Node_SourceInfo_Member capnp.Struct

// Node_SourceInfo_Member_TypeID is the unique identifier for the type Node_SourceInfo_Member.
const Node_SourceInfo_Member_TypeID = 0xc2ba9038898e1fa2

func NewNode_SourceInfo_Member(s *capnp.Segment) (Node_SourceInfo_Member, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Node_SourceInfo_Member(st), err
}

func NewRootNode_SourceInfo_Member(s *capnp.Segment) (Node_SourceInfo_Member, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Node_SourceInfo_Member(st), err
}

func ReadRootNode_SourceInfo_Member(msg *capnp.Message) (Node_SourceInfo_Member, error) {
	root, err := msg.Root()
	return Node_SourceInfo_Member(root.Struct()), err
}

func (s Node_SourceInfo_Member) String() string {
	str, _ := text.Marshal(0xc2ba9038898e1fa2, capnp.Struct(s))
	return str
}

func (s Node_SourceInfo_Member) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Node_SourceInfo_Member) DecodeFromPtr(p capnp.Ptr) Node_SourceInfo_Member {
	return Node_SourceInfo_Member(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Node_SourceInfo_Member) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Node_SourceInfo_Member) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Node_SourceInfo_Member) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Node_SourceInfo_Member) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Node_SourceInfo_Member) DocComment() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Node_SourceInfo_Member) HasDocComment() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Node_SourceInfo_Member) DocCommentBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Node_SourceInfo_Member) SetDocComment(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

// Node_SourceInfo_Member_List is a list of Node_SourceInfo_Member.
type Node_SourceInfo_Member_List = capnp.StructList[Node_SourceInfo_Member]

// NewNode_SourceInfo_Member creates a new list of Node_SourceInfo_Member.
func NewNode_SourceInfo_Member_List(s *capnp.Segment, sz int32) (Node_SourceInfo_Member_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Node_SourceInfo_Member](l), err
}

// Node_SourceInfo_Member_Future is a wrapper for a Node_SourceInfo_Member promised by a client call.
type Node_SourceInfo_Member_Future struct{ *capnp.Future }

func (f Node_SourceInfo_Member_Future) Struct() (Node_SourceInfo_Member, error) {
	p, err := f.Future.Ptr()
	return Node_SourceInfo_Member(p.Struct()), err
}

type Field capnp.Struct
type Field_slot Field
type Field_group Field
type Field_ordinal Field
type Field_Which uint16

const (
	Field_Which_slot  Field_Which = 0
	Field_Which_group Field_Which = 1
)

func (w Field_Which) String() string {
	const s = "slotgroup"
	switch w {
	case Field_Which_slot:
		return s[0:4]
	case Field_Which_group:
		return s[4:9]

	}
	return "Field_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

type Field_ordinal_Which uint16

const (
	Field_ordinal_Which_implicit Field_ordinal_Which = 0
	Field_ordinal_Which_explicit Field_ordinal_Which = 1
)

func (w Field_ordinal_Which) String() string {
	const s = "implicitexplicit"
	switch w {
	case Field_ordinal_Which_implicit:
		return s[0:8]
	case Field_ordinal_Which_explicit:
		return s[8:16]

	}
	return "Field_ordinal_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Field_TypeID is the unique identifier for the type Field.
const Field_TypeID = 0x9aad50a41f4af45f

func NewField(s *capnp.Segment) (Field, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 4})
	return Field(st), err
}

func NewRootField(s *capnp.Segment) (Field, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 4})
	return Field(st), err
}

func ReadRootField(msg *capnp.Message) (Field, error) {
	root, err := msg.Root()
	return Field(root.Struct()), err
}

func (s Field) String() string {
	str, _ := text.Marshal(0x9aad50a41f4af45f, capnp.Struct(s))
	return str
}

func (s Field) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Field) DecodeFromPtr(p capnp.Ptr) Field {
	return Field(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Field) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Field) Which() Field_Which {
	return Field_Which(capnp.Struct(s).Uint16(8))
}
func (s Field) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Field) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Field) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Field) Name() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Field) HasName() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Field) NameBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Field) SetName(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Field) CodeOrder() uint16 {
	return capnp.Struct(s).Uint16(0)
}

func (s Field) SetCodeOrder(v uint16) {
	capnp.Struct(s).SetUint16(0, v)
}

func (s Field) Annotations() (Annotation_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Annotation_List(p.List()), err
}

func (s Field) HasAnnotations() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Field) SetAnnotations(v Annotation_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewAnnotations sets the annotations field to a newly
// allocated Annotation_List, preferring placement in s's segment.
func (s Field) NewAnnotations(n int32) (Annotation_List, error) {
	l, err := NewAnnotation_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Annotation_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}
func (s Field) DiscriminantValue() uint16 {
	return capnp.Struct(s).Uint16(2) ^ 65535
}

func (s Field) SetDiscriminantValue(v uint16) {
	capnp.Struct(s).SetUint16(2, v^65535)
}

func (s Field) Slot() Field_slot { return Field_slot(s) }

func (s Field) SetSlot() {
	capnp.Struct(s).SetUint16(8, 0)
}

func (s Field_slot) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Field_slot) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Field_slot) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Field_slot) Offset() uint32 {
	return capnp.Struct(s).Uint32(4)
}

func (s Field_slot) SetOffset(v uint32) {
	capnp.Struct(s).SetUint32(4, v)
}

func (s Field_slot) Type() (Type, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return Type(p.Struct()), err
}

func (s Field_slot) HasType() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Field_slot) SetType(v Type) error {
	return capnp.Struct(s).SetPtr(2, capnp.Struct(v).ToPtr())
}

// NewType sets the type field to a newly
// allocated Type struct, preferring placement in s's segment.
func (s Field_slot) NewType() (Type, error) {
	ss, err := NewType(capnp.Struct(s).Segment())
	if err != nil {
		return Type{}, err
	}
	err = capnp.Struct(s).SetPtr(2, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Field_slot) DefaultValue() (Value, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return Value(p.Struct()), err
}

func (s Field_slot) HasDefaultValue() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Field_slot) SetDefaultValue(v Value) error {
	return capnp.Struct(s).SetPtr(3, capnp.Struct(v).ToPtr())
}

// NewDefaultValue sets the defaultValue field to a newly
// allocated Value struct, preferring placement in s's segment.
func (s Field_slot) NewDefaultValue() (Value, error) {
	ss, err := NewValue(capnp.Struct(s).Segment())
	if err != nil {
		return Value{}, err
	}
	err = capnp.Struct(s).SetPtr(3, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Field_slot) HadExplicitDefault() bool {
	return capnp.Struct(s).Bit(128)
}

func (s Field_slot) SetHadExplicitDefault(v bool) {
	capnp.Struct(s).SetBit(128, v)
}

func (s Field) Group() Field_group { return Field_group(s) }

func (s Field) SetGroup() {
	capnp.Struct(s).SetUint16(8, 1)
}

func (s Field_group) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Field_group) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Field_group) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Field_group) TypeId() uint64 {
	return capnp.Struct(s).Uint64(16)
}

func (s Field_group) SetTypeId(v uint64) {
	capnp.Struct(s).SetUint64(16, v)
}

func (s Field) Ordinal() Field_ordinal { return Field_ordinal(s) }

func (s Field_ordinal) Which() Field_ordinal_Which {
	return Field_ordinal_Which(capnp.Struct(s).Uint16(10))
}
func (s Field_ordinal) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Field_ordinal) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Field_ordinal) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Field_ordinal) SetImplicit() {
	capnp.Struct(s).SetUint16(10, 0)

}

func (s Field_ordinal) Explicit() uint16 {
	if capnp.Struct(s).Uint16(10) != 1 {
		panic("Which() != explicit")
	}
	return capnp.Struct(s).Uint16(12)
}

func (s Field_ordinal) SetExplicit(v uint16) {
	capnp.Struct(s).SetUint16(10, 1)
	capnp.Struct(s).SetUint16(12, v)
}

// Field_List is a list of Field.
type Field_List = capnp.StructList[Field]

// NewField creates a new list of Field.
func NewField_List(s *capnp.Segment, sz int32) (Field_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 4}, sz)
	return capnp.StructList[Field](l), err
}

// Field_Future is a wrapper for a Field promised by a client call.
type Field_Future struct{ *capnp.Future }

func (f Field_Future) Struct() (Field, error) {
	p, err := f.Future.Ptr()
	return Field(p.Struct()), err
}
func (p Field_Future) Slot() Field_slot_Future { return Field_slot_Future{p.Future} }

// Field_slot_Future is a wrapper for a Field_slot promised by a client call.
type Field_slot_Future struct{ *capnp.Future }

func (f Field_slot_Future) Struct() (Field_slot, error) {
	p, err := f.Future.Ptr()
	return Field_slot(p.Struct()), err
}
func (p Field_slot_Future) Type() Type_Future {
	return Type_Future{Future: p.Future.Field(2, nil)}
}
func (p Field_slot_Future) DefaultValue() Value_Future {
	return Value_Future{Future: p.Future.Field(3, nil)}
}
func (p Field_Future) Group() Field_group_Future { return Field_group_Future{p.Future} }

// Field_group_Future is a wrapper for a Field_group promised by a client call.
type Field_group_Future struct{ *capnp.Future }

func (f Field_group_Future) Struct() (Field_group, error) {
	p, err := f.Future.Ptr()
	return Field_group(p.Struct()), err
}
func (p Field_Future) Ordinal() Field_ordinal_Future { return Field_ordinal_Future{p.Future} }

// Field_ordinal_Future is a wrapper for a Field_ordinal promised by a client call.
type Field_ordinal_Future struct{ *capnp.Future }

func (f Field_ordinal_Future) Struct() (Field_ordinal, error) {
	p, err := f.Future.Ptr()
	return Field_ordinal(p.Struct()), err
}

type Enumerant capnp.Struct

// Enumerant_TypeID is the unique identifier for the type Enumerant.
const Enumerant_TypeID = 0x978a7cebdc549a4d

func NewEnumerant(s *capnp.Segment) (Enumerant, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Enumerant(st), err
}

func NewRootEnumerant(s *capnp.Segment) (Enumerant, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Enumerant(st), err
}

func ReadRootEnumerant(msg *capnp.Message) (Enumerant, error) {
	root, err := msg.Root()
	return Enumerant(root.Struct()), err
}

func (s Enumerant) String() string {
	str, _ := text.Marshal(0x978a7cebdc549a4d, capnp.Struct(s))
	return str
}

func (s Enumerant) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Enumerant) DecodeFromPtr(p capnp.Ptr) Enumerant {
	return Enumerant(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Enumerant) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Enumerant) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Enumerant) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Enumerant) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Enumerant) Name() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Enumerant) HasName() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Enumerant) NameBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Enumerant) SetName(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Enumerant) CodeOrder() uint16 {
	return capnp.Struct(s).Uint16(0)
}

func (s Enumerant) SetCodeOrder(v uint16) {
	capnp.Struct(s).SetUint16(0, v)
}

func (s Enumerant) Annotations() (Annotation_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Annotation_List(p.List()), err
}

func (s Enumerant) HasAnnotations() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Enumerant) SetAnnotations(v Annotation_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewAnnotations sets the annotations field to a newly
// allocated Annotation_List, preferring placement in s's segment.
func (s Enumerant) NewAnnotations(n int32) (Annotation_List, error) {
	l, err := NewAnnotation_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Annotation_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

// Enumerant_List is a list of Enumerant.
type Enumerant_List = capnp.StructList[Enumerant]

// NewEnumerant creates a new list of Enumerant.
func NewEnumerant_List(s *capnp.Segment, sz int32) (Enumerant_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Enumerant](l), err
}

// Enumerant_Future is a wrapper for a Enumerant promised by a client call.
type Enumerant_Future struct{ *capnp.Future }

func (f Enumerant_Future) Struct() (Enumerant, error) {
	p, err := f.Future.Ptr()
	return Enumerant(p.Struct()), err
}

type Superclass capnp.Struct

// Superclass_TypeID is the unique identifier for the type Superclass.
const Superclass_TypeID = 0xa9962a9ed0a4d7f8

func NewSuperclass(s *capnp.Segment) (Superclass, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Superclass(st), err
}

func NewRootSuperclass(s *capnp.Segment) (Superclass, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Superclass(st), err
}

func ReadRootSuperclass(msg *capnp.Message) (Superclass, error) {
	root, err := msg.Root()
	return Superclass(root.Struct()), err
}

func (s Superclass) String() string {
	str, _ := text.Marshal(0xa9962a9ed0a4d7f8, capnp.Struct(s))
	return str
}

func (s Superclass) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Superclass) DecodeFromPtr(p capnp.Ptr) Superclass {
	return Superclass(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Superclass) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Superclass) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Superclass) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Superclass) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Superclass) Id() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s Superclass) SetId(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s Superclass) Brand() (Brand, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Brand(p.Struct()), err
}

func (s Superclass) HasBrand() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Superclass) SetBrand(v Brand) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewBrand sets the brand field to a newly
// allocated Brand struct, preferring placement in s's segment.
func (s Superclass) NewBrand() (Brand, error) {
	ss, err := NewBrand(capnp.Struct(s).Segment())
	if err != nil {
		return Brand{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Superclass_List is a list of Superclass.
type Superclass_List = capnp.StructList[Superclass]

// NewSuperclass creates a new list of Superclass.
func NewSuperclass_List(s *capnp.Segment, sz int32) (Superclass_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Superclass](l), err
}

// Superclass_Future is a wrapper for a Superclass promised by a client call.
type Superclass_Future struct{ *capnp.Future }

func (f Superclass_Future) Struct() (Superclass, error) {
	p, err := f.Future.Ptr()
	return Superclass(p.Struct()), err
}
func (p Superclass_Future) Brand() Brand_Future {
	return Brand_Future{Future: p.Future.Field(0, nil)}
}

type Method capnp.Struct

// Method_TypeID is the unique identifier for the type Method.
const Method_TypeID = 0x9500cce23b334d80

func NewMethod(s *capnp.Segment) (Method, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 5})
	return Method(st), err
}

func NewRootMethod(s *capnp.Segment) (Method, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 5})
	return Method(st), err
}

func ReadRootMethod(msg *capnp.Message) (Method, error) {
	root, err := msg.Root()
	return Method(root.Struct()), err
}

func (s Method) String() string {
	str, _ := text.Marshal(0x9500cce23b334d80, capnp.Struct(s))
	return str
}

func (s Method) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Method) DecodeFromPtr(p capnp.Ptr) Method {
	return Method(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Method) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Method) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Method) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Method) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Method) Name() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Method) HasName() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Method) NameBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Method) SetName(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Method) CodeOrder() uint16 {
	return capnp.Struct(s).Uint16(0)
}

func (s Method) SetCodeOrder(v uint16) {
	capnp.Struct(s).SetUint16(0, v)
}

func (s Method) ImplicitParameters() (Node_Parameter_List, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return Node_Parameter_List(p.List()), err
}

func (s Method) HasImplicitParameters() bool {
	return capnp.Struct(s).HasPtr(4)
}

func (s Method) SetImplicitParameters(v Node_Parameter_List) error {
	return capnp.Struct(s).SetPtr(4, v.ToPtr())
}

// NewImplicitParameters sets the implicitParameters field to a newly
// allocated Node_Parameter_List, preferring placement in s's segment.
func (s Method) NewImplicitParameters(n int32) (Node_Parameter_List, error) {
	l, err := NewNode_Parameter_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Node_Parameter_List{}, err
	}
	err = capnp.Struct(s).SetPtr(4, l.ToPtr())
	return l, err
}
func (s Method) ParamStructType() uint64 {
	return capnp.Struct(s).Uint64(8)
}

func (s Method) SetParamStructType(v uint64) {
	capnp.Struct(s).SetUint64(8, v)
}

func (s Method) ParamBrand() (Brand, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return Brand(p.Struct()), err
}

func (s Method) HasParamBrand() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Method) SetParamBrand(v Brand) error {
	return capnp.Struct(s).SetPtr(2, capnp.Struct(v).ToPtr())
}

// NewParamBrand sets the paramBrand field to a newly
// allocated Brand struct, preferring placement in s's segment.
func (s Method) NewParamBrand() (Brand, error) {
	ss, err := NewBrand(capnp.Struct(s).Segment())
	if err != nil {
		return Brand{}, err
	}
	err = capnp.Struct(s).SetPtr(2, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Method) ResultStructType() uint64 {
	return capnp.Struct(s).Uint64(16)
}

func (s Method) SetResultStructType(v uint64) {
	capnp.Struct(s).SetUint64(16, v)
}

func (s Method) ResultBrand() (Brand, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return Brand(p.Struct()), err
}

func (s Method) HasResultBrand() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Method) SetResultBrand(v Brand) error {
	return capnp.Struct(s).SetPtr(3, capnp.Struct(v).ToPtr())
}

// NewResultBrand sets the resultBrand field to a newly
// allocated Brand struct, preferring placement in s's segment.
func (s Method) NewResultBrand() (Brand, error) {
	ss, err := NewBrand(capnp.Struct(s).Segment())
	if err != nil {
		return Brand{}, err
	}
	err = capnp.Struct(s).SetPtr(3, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Method) Annotations() (Annotation_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Annotation_List(p.List()), err
}

func (s Method) HasAnnotations() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Method) SetAnnotations(v Annotation_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewAnnotations sets the annotations field to a newly
// allocated Annotation_List, preferring placement in s's segment.
func (s Method) NewAnnotations(n int32) (Annotation_List, error) {
	l, err := NewAnnotation_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Annotation_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

// Method_List is a list of Method.
type Method_List = capnp.StructList[Method]

// NewMethod creates a new list of Method.
func NewMethod_List(s *capnp.Segment, sz int32) (Method_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 5}, sz)
	return capnp.StructList[Method](l), err
}

// Method_Future is a wrapper for a Method promised by a client call.
type Method_Future struct{ *capnp.Future }

func (f Method_Future) Struct() (Method, error) {
	p, err := f.Future.Ptr()
	return Method(p.Struct()), err
}
func (p Method_Future) ParamBrand() Brand_Future {
	return Brand_Future{Future: p.Future.Field(2, nil)}
}
func (p Method_Future) ResultBrand() Brand_Future {
	return Brand_Future{Future: p.Future.Field(3, nil)}
}

type Type capnp.Struct
type Type_list Type
type Type_enum Type
type Type_structType Type
type Type_interface Type
type Type_anyPointer Type
type Type_anyPointer_unconstrained Type
type Type_anyPointer_parameter Type
type Type_anyPointer_implicitMethodParameter Type
type Type_Which uint16

const (
	Type_Which_void       Type_Which = 0
	Type_Which_bool       Type_Which = 1
	Type_Which_int8       Type_Which = 2
	Type_Which_int16      Type_Which = 3
	Type_Which_int32      Type_Which = 4
	Type_Which_int64      Type_Which = 5
	Type_Which_uint8      Type_Which = 6
	Type_Which_uint16     Type_Which = 7
	Type_Which_uint32     Type_Which = 8
	Type_Which_uint64     Type_Which = 9
	Type_Which_float32    Type_Which = 10
	Type_Which_float64    Type_Which = 11
	Type_Which_text       Type_Which = 12
	Type_Which_data       Type_Which = 13
	Type_Which_list       Type_Which = 14
	Type_Which_enum       Type_Which = 15
	Type_Which_structType Type_Which = 16
	Type_Which_interface  Type_Which = 17
	Type_Which_anyPointer Type_Which = 18
)

func (w Type_Which) String() string {
	const s = "voidboolint8int16int32int64uint8uint16uint32uint64float32float64textdatalistenumstructTypeinterfaceanyPointer"
	switch w {
	case Type_Which_void:
		return s[0:4]
	case Type_Which_bool:
		return s[4:8]
	case Type_Which_int8:
		return s[8:12]
	case Type_Which_int16:
		return s[12:17]
	case Type_Which_int32:
		return s[17:22]
	case Type_Which_int64:
		return s[22:27]
	case Type_Which_uint8:
		return s[27:32]
	case Type_Which_uint16:
		return s[32:38]
	case Type_Which_uint32:
		return s[38:44]
	case Type_Which_uint64:
		return s[44:50]
	case Type_Which_float32:
		return s[50:57]
	case Type_Which_float64:
		return s[57:64]
	case Type_Which_text:
		return s[64:68]
	case Type_Which_data:
		return s[68:72]
	case Type_Which_list:
		return s[72:76]
	case Type_Which_enum:
		return s[76:80]
	case Type_Which_structType:
		return s[80:90]
	case Type_Which_interface:
		return s[90:99]
	case Type_Which_anyPointer:
		return s[99:109]

	}
	return "Type_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

type Type_anyPointer_Which uint16

const (
	Type_anyPointer_Which_unconstrained           Type_anyPointer_Which = 0
	Type_anyPointer_Which_parameter               Type_anyPointer_Which = 1
	Type_anyPointer_Which_implicitMethodParameter Type_anyPointer_Which = 2
)

func (w Type_anyPointer_Which) String() string {
	const s = "unconstrainedparameterimplicitMethodParameter"
	switch w {
	case Type_anyPointer_Which_unconstrained:
		return s[0:13]
	case Type_anyPointer_Which_parameter:
		return s[13:22]
	case Type_anyPointer_Which_implicitMethodParameter:
		return s[22:45]

	}
	return "Type_anyPointer_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

type Type_anyPointer_unconstrained_Which uint16

const (
	Type_anyPointer_unconstrained_Which_anyKind    Type_anyPointer_unconstrained_Which = 0
	Type_anyPointer_unconstrained_Which_struct     Type_anyPointer_unconstrained_Which = 1
	Type_anyPointer_unconstrained_Which_list       Type_anyPointer_unconstrained_Which = 2
	Type_anyPointer_unconstrained_Which_capability Type_anyPointer_unconstrained_Which = 3
)

func (w Type_anyPointer_unconstrained_Which) String() string {
	const s = "anyKindstructlistcapability"
	switch w {
	case Type_anyPointer_unconstrained_Which_anyKind:
		return s[0:7]
	case Type_anyPointer_unconstrained_Which_struct:
		return s[7:13]
	case Type_anyPointer_unconstrained_Which_list:
		return s[13:17]
	case Type_anyPointer_unconstrained_Which_capability:
		return s[17:27]

	}
	return "Type_anyPointer_unconstrained_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Type_TypeID is the unique identifier for the type Type.
const Type_TypeID = 0xd07378ede1f9cc60

func NewType(s *capnp.Segment) (Type, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 1})
	return Type(st), err
}

func NewRootType(s *capnp.Segment) (Type, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 1})
	return Type(st), err
}

func ReadRootType(msg *capnp.Message) (Type, error) {
	root, err := msg.Root()
	return Type(root.Struct()), err
}

func (s Type) String() string {
	str, _ := text.Marshal(0xd07378ede1f9cc60, capnp.Struct(s))
	return str
}

func (s Type) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Type) DecodeFromPtr(p capnp.Ptr) Type {
	return Type(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Type) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Type) Which() Type_Which {
	return Type_Which(capnp.Struct(s).Uint16(0))
}
func (s Type) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Type) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Type) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Type) SetVoid() {
	capnp.Struct(s).SetUint16(0, 0)

}

func (s Type) SetBool() {
	capnp.Struct(s).SetUint16(0, 1)

}

func (s Type) SetInt8() {
	capnp.Struct(s).SetUint16(0, 2)

}

func (s Type) SetInt16() {
	capnp.Struct(s).SetUint16(0, 3)

}

func (s Type) SetInt32() {
	capnp.Struct(s).SetUint16(0, 4)

}

func (s Type) SetInt64() {
	capnp.Struct(s).SetUint16(0, 5)

}

func (s Type) SetUint8() {
	capnp.Struct(s).SetUint16(0, 6)

}

func (s Type) SetUint16() {
	capnp.Struct(s).SetUint16(0, 7)

}

func (s Type) SetUint32() {
	capnp.Struct(s).SetUint16(0, 8)

}

func (s Type) SetUint64() {
	capnp.Struct(s).SetUint16(0, 9)

}

func (s Type) SetFloat32() {
	capnp.Struct(s).SetUint16(0, 10)

}

func (s Type) SetFloat64() {
	capnp.Struct(s).SetUint16(0, 11)

}

func (s Type) SetText() {
	capnp.Struct(s).SetUint16(0, 12)

}

func (s Type) SetData() {
	capnp.Struct(s).SetUint16(0, 13)

}

func (s Type) List() Type_list { return Type_list(s) }

func (s Type) SetList() {
	capnp.Struct(s).SetUint16(0, 14)
}

func (s Type_list) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Type_list) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Type_list) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Type_list) ElementType() (Type, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Type(p.Struct()), err
}

func (s Type_list) HasElementType() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Type_list) SetElementType(v Type) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewElementType sets the elementType field to a newly
// allocated Type struct, preferring placement in s's segment.
func (s Type_list) NewElementType() (Type, error) {
	ss, err := NewType(capnp.Struct(s).Segment())
	if err != nil {
		return Type{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Type) Enum() Type_enum { return Type_enum(s) }

func (s Type) SetEnum() {
	capnp.Struct(s).SetUint16(0, 15)
}

func (s Type_enum) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Type_enum) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Type_enum) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Type_enum) TypeId() uint64 {
	return capnp.Struct(s).Uint64(8)
}

func (s Type_enum) SetTypeId(v uint64) {
	capnp.Struct(s).SetUint64(8, v)
}

func (s Type_enum) Brand() (Brand, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Brand(p.Struct()), err
}

func (s Type_enum) HasBrand() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Type_enum) SetBrand(v Brand) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewBrand sets the brand field to a newly
// allocated Brand struct, preferring placement in s's segment.
func (s Type_enum) NewBrand() (Brand, error) {
	ss, err := NewBrand(capnp.Struct(s).Segment())
	if err != nil {
		return Brand{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Type) StructType() Type_structType { return Type_structType(s) }

func (s Type) SetStructType() {
	capnp.Struct(s).SetUint16(0, 16)
}

func (s Type_structType) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Type_structType) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Type_structType) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Type_structType) TypeId() uint64 {
	return capnp.Struct(s).Uint64(8)
}

func (s Type_structType) SetTypeId(v uint64) {
	capnp.Struct(s).SetUint64(8, v)
}

func (s Type_structType) Brand() (Brand, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Brand(p.Struct()), err
}

func (s Type_structType) HasBrand() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Type_structType) SetBrand(v Brand) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewBrand sets the brand field to a newly
// allocated Brand struct, preferring placement in s's segment.
func (s Type_structType) NewBrand() (Brand, error) {
	ss, err := NewBrand(capnp.Struct(s).Segment())
	if err != nil {
		return Brand{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Type) Interface() Type_interface { return Type_interface(s) }

func (s Type) SetInterface() {
	capnp.Struct(s).SetUint16(0, 17)
}

func (s Type_interface) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Type_interface) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Type_interface) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Type_interface) TypeId() uint64 {
	return capnp.Struct(s).Uint64(8)
}

func (s Type_interface) SetTypeId(v uint64) {
	capnp.Struct(s).SetUint64(8, v)
}

func (s Type_interface) Brand() (Brand, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Brand(p.Struct()), err
}

func (s Type_interface) HasBrand() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Type_interface) SetBrand(v Brand) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewBrand sets the brand field to a newly
// allocated Brand struct, preferring placement in s's segment.
func (s Type_interface) NewBrand() (Brand, error) {
	ss, err := NewBrand(capnp.Struct(s).Segment())
	if err != nil {
		return Brand{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Type) AnyPointer() Type_anyPointer { return Type_anyPointer(s) }

func (s Type) SetAnyPointer() {
	capnp.Struct(s).SetUint16(0, 18)
}

func (s Type_anyPointer) Which() Type_anyPointer_Which {
	return Type_anyPointer_Which(capnp.Struct(s).Uint16(8))
}
func (s Type_anyPointer) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Type_anyPointer) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Type_anyPointer) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Type_anyPointer) Unconstrained() Type_anyPointer_unconstrained {
	return Type_anyPointer_unconstrained(s)
}

func (s Type_anyPointer) SetUnconstrained() {
	capnp.Struct(s).SetUint16(8, 0)
}

func (s Type_anyPointer_unconstrained) Which() Type_anyPointer_unconstrained_Which {
	return Type_anyPointer_unconstrained_Which(capnp.Struct(s).Uint16(10))
}
func (s Type_anyPointer_unconstrained) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Type_anyPointer_unconstrained) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Type_anyPointer_unconstrained) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Type_anyPointer_unconstrained) SetAnyKind() {
	capnp.Struct(s).SetUint16(10, 0)

}

func (s Type_anyPointer_unconstrained) SetStruct() {
	capnp.Struct(s).SetUint16(10, 1)

}

func (s Type_anyPointer_unconstrained) SetList() {
	capnp.Struct(s).SetUint16(10, 2)

}

func (s Type_anyPointer_unconstrained) SetCapability() {
	capnp.Struct(s).SetUint16(10, 3)

}

func (s Type_anyPointer) Parameter() Type_anyPointer_parameter { return Type_anyPointer_parameter(s) }

func (s Type_anyPointer) SetParameter() {
	capnp.Struct(s).SetUint16(8, 1)
}

func (s Type_anyPointer_parameter) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Type_anyPointer_parameter) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Type_anyPointer_parameter) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Type_anyPointer_parameter) ScopeId() uint64 {
	return capnp.Struct(s).Uint64(16)
}

func (s Type_anyPointer_parameter) SetScopeId(v uint64) {
	capnp.Struct(s).SetUint64(16, v)
}

func (s Type_anyPointer_parameter) ParameterIndex() uint16 {
	return capnp.Struct(s).Uint16(10)
}

func (s Type_anyPointer_parameter) SetParameterIndex(v uint16) {
	capnp.Struct(s).SetUint16(10, v)
}

func (s Type_anyPointer) ImplicitMethodParameter() Type_anyPointer_implicitMethodParameter {
	return Type_anyPointer_implicitMethodParameter(s)
}

func (s Type_anyPointer) SetImplicitMethodParameter() {
	capnp.Struct(s).SetUint16(8, 2)
}

func (s Type_anyPointer_implicitMethodParameter) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Type_anyPointer_implicitMethodParameter) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Type_anyPointer_implicitMethodParameter) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Type_anyPointer_implicitMethodParameter) ParameterIndex() uint16 {
	return capnp.Struct(s).Uint16(10)
}

func (s Type_anyPointer_implicitMethodParameter) SetParameterIndex(v uint16) {
	capnp.Struct(s).SetUint16(10, v)
}

// Type_List is a list of Type.
type Type_List = capnp.StructList[Type]

// NewType creates a new list of Type.
func NewType_List(s *capnp.Segment, sz int32) (Type_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 1}, sz)
	return capnp.StructList[Type](l), err
}

// Type_Future is a wrapper for a Type promised by a client call.
type Type_Future struct{ *capnp.Future }

func (f Type_Future) Struct() (Type, error) {
	p, err := f.Future.Ptr()
	return Type(p.Struct()), err
}
func (p Type_Future) List() Type_list_Future { return Type_list_Future{p.Future} }

// Type_list_Future is a wrapper for a Type_list promised by a client call.
type Type_list_Future struct{ *capnp.Future }

func (f Type_list_Future) Struct() (Type_list, error) {
	p, err := f.Future.Ptr()
	return Type_list(p.Struct()), err
}
func (p Type_list_Future) ElementType() Type_Future {
	return Type_Future{Future: p.Future.Field(0, nil)}
}
func (p Type_Future) Enum() Type_enum_Future { return Type_enum_Future{p.Future} }

// Type_enum_Future is a wrapper for a Type_enum promised by a client call.
type Type_enum_Future struct{ *capnp.Future }

func (f Type_enum_Future) Struct() (Type_enum, error) {
	p, err := f.Future.Ptr()
	return Type_enum(p.Struct()), err
}
func (p Type_enum_Future) Brand() Brand_Future {
	return Brand_Future{Future: p.Future.Field(0, nil)}
}
func (p Type_Future) StructType() Type_structType_Future { return Type_structType_Future{p.Future} }

// Type_structType_Future is a wrapper for a Type_structType promised by a client call.
type Type_structType_Future struct{ *capnp.Future }

func (f Type_structType_Future) Struct() (Type_structType, error) {
	p, err := f.Future.Ptr()
	return Type_structType(p.Struct()), err
}
func (p Type_structType_Future) Brand() Brand_Future {
	return Brand_Future{Future: p.Future.Field(0, nil)}
}
func (p Type_Future) Interface() Type_interface_Future { return Type_interface_Future{p.Future} }

// Type_interface_Future is a wrapper for a Type_interface promised by a client call.
type Type_interface_Future struct{ *capnp.Future }

func (f Type_interface_Future) Struct() (Type_interface, error) {
	p, err := f.Future.Ptr()
	return Type_interface(p.Struct()), err
}
func (p Type_interface_Future) Brand() Brand_Future {
	return Brand_Future{Future: p.Future.Field(0, nil)}
}
func (p Type_Future) AnyPointer() Type_anyPointer_Future { return Type_anyPointer_Future{p.Future} }

// Type_anyPointer_Future is a wrapper for a Type_anyPointer promised by a client call.
type Type_anyPointer_Future struct{ *capnp.Future }

func (f Type_anyPointer_Future) Struct() (Type_anyPointer, error) {
	p, err := f.Future.Ptr()
	return Type_anyPointer(p.Struct()), err
}
func (p Type_anyPointer_Future) Unconstrained() Type_anyPointer_unconstrained_Future {
	return Type_anyPointer_unconstrained_Future{p.Future}
}

// Type_anyPointer_unconstrained_Future is a wrapper for a Type_anyPointer_unconstrained promised by a client call.
type Type_anyPointer_unconstrained_Future struct{ *capnp.Future }

func (f Type_anyPointer_unconstrained_Future) Struct() (Type_anyPointer_unconstrained, error) {
	p, err := f.Future.Ptr()
	return Type_anyPointer_unconstrained(p.Struct()), err
}
func (p Type_anyPointer_Future) Parameter() Type_anyPointer_parameter_Future {
	return Type_anyPointer_parameter_Future{p.Future}
}

// Type_anyPointer_parameter_Future is a wrapper for a Type_anyPointer_parameter promised by a client call.
type Type_anyPointer_parameter_Future struct{ *capnp.Future }

func (f Type_anyPointer_parameter_Future) Struct() (Type_anyPointer_parameter, error) {
	p, err := f.Future.Ptr()
	return Type_anyPointer_parameter(p.Struct()), err
}
func (p Type_anyPointer_Future) ImplicitMethodParameter() Type_anyPointer_implicitMethodParameter_Future {
	return Type_anyPointer_implicitMethodParameter_Future{p.Future}
}

// Type_anyPointer_implicitMethodParameter_Future is a wrapper for a Type_anyPointer_implicitMethodParameter promised by a client call.
type Type_anyPointer_implicitMethodParameter_Future struct{ *capnp.Future }

func (f Type_anyPointer_implicitMethodParameter_Future) Struct() (Type_anyPointer_implicitMethodParameter, error) {
	p, err := f.Future.Ptr()
	return Type_anyPointer_implicitMethodParameter(p.Struct()), err
}

type Brand capnp.Struct

// Brand_TypeID is the unique identifier for the type Brand.
const Brand_TypeID = 0x903455f06065422b

func NewBrand(s *capnp.Segment) (Brand, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Brand(st), err
}

func NewRootBrand(s *capnp.Segment) (Brand, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Brand(st), err
}

func ReadRootBrand(msg *capnp.Message) (Brand, error) {
	root, err := msg.Root()
	return Brand(root.Struct()), err
}

func (s Brand) String() string {
	str, _ := text.Marshal(0x903455f06065422b, capnp.Struct(s))
	return str
}

func (s Brand) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Brand) DecodeFromPtr(p capnp.Ptr) Brand {
	return Brand(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Brand) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Brand) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Brand) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Brand) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Brand) Scopes() (Brand_Scope_List, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Brand_Scope_List(p.List()), err
}

func (s Brand) HasScopes() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Brand) SetScopes(v Brand_Scope_List) error {
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewScopes sets the scopes field to a newly
// allocated Brand_Scope_List, preferring placement in s's segment.
func (s Brand) NewScopes(n int32) (Brand_Scope_List, error) {
	l, err := NewBrand_Scope_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Brand_Scope_List{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}

// Brand_List is a list of Brand.
type Brand_List = capnp.StructList[Brand]

// NewBrand creates a new list of Brand.
func NewBrand_List(s *capnp.Segment, sz int32) (Brand_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Brand](l), err
}

// Brand_Future is a wrapper for a Brand promised by a client call.
type Brand_Future struct{ *capnp.Future }

func (f Brand_Future) Struct() (Brand, error) {
	p, err := f.Future.Ptr()
	return Brand(p.Struct()), err
}

type Brand_Scope capnp.Struct
type Brand_Scope_Which uint16

const (
	Brand_Scope_Which_bind    Brand_Scope_Which = 0
	Brand_Scope_Which_inherit Brand_Scope_Which = 1
)

func (w Brand_Scope_Which) String() string {
	const s = "bindinherit"
	switch w {
	case Brand_Scope_Which_bind:
		return s[0:4]
	case Brand_Scope_Which_inherit:
		return s[4:11]

	}
	return "Brand_Scope_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Brand_Scope_TypeID is the unique identifier for the type Brand_Scope.
const Brand_Scope_TypeID = 0xabd73485a9636bc9

func NewBrand_Scope(s *capnp.Segment) (Brand_Scope, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Brand_Scope(st), err
}

func NewRootBrand_Scope(s *capnp.Segment) (Brand_Scope, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Brand_Scope(st), err
}

func ReadRootBrand_Scope(msg *capnp.Message) (Brand_Scope, error) {
	root, err := msg.Root()
	return Brand_Scope(root.Struct()), err
}

func (s Brand_Scope) String() string {
	str, _ := text.Marshal(0xabd73485a9636bc9, capnp.Struct(s))
	return str
}

func (s Brand_Scope) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Brand_Scope) DecodeFromPtr(p capnp.Ptr) Brand_Scope {
	return Brand_Scope(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Brand_Scope) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Brand_Scope) Which() Brand_Scope_Which {
	return Brand_Scope_Which(capnp.Struct(s).Uint16(8))
}
func (s Brand_Scope) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Brand_Scope) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Brand_Scope) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Brand_Scope) ScopeId() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s Brand_Scope) SetScopeId(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s Brand_Scope) Bind() (Brand_Binding_List, error) {
	if capnp.Struct(s).Uint16(8) != 0 {
		panic("Which() != bind")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Brand_Binding_List(p.List()), err
}

func (s Brand_Scope) HasBind() bool {
	if capnp.Struct(s).Uint16(8) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Brand_Scope) SetBind(v Brand_Binding_List) error {
	capnp.Struct(s).SetUint16(8, 0)
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewBind sets the bind field to a newly
// allocated Brand_Binding_List, preferring placement in s's segment.
func (s Brand_Scope) NewBind(n int32) (Brand_Binding_List, error) {
	capnp.Struct(s).SetUint16(8, 0)
	l, err := NewBrand_Binding_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Brand_Binding_List{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}
func (s Brand_Scope) SetInherit() {
	capnp.Struct(s).SetUint16(8, 1)

}

// Brand_Scope_List is a list of Brand_Scope.
type Brand_Scope_List = capnp.StructList[Brand_Scope]

// NewBrand_Scope creates a new list of Brand_Scope.
func NewBrand_Scope_List(s *capnp.Segment, sz int32) (Brand_Scope_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return capnp.StructList[Brand_Scope](l), err
}

// Brand_Scope_Future is a wrapper for a Brand_Scope promised by a client call.
type Brand_Scope_Future struct{ *capnp.Future }

func (f Brand_Scope_Future) Struct() (Brand_Scope, error) {
	p, err := f.Future.Ptr()
	return Brand_Scope(p.Struct()), err
}

type Brand_Binding capnp.Struct
type Brand_Binding_Which uint16

const (
	Brand_Binding_Which_unbound Brand_Binding_Which = 0
	Brand_Binding_Which_type    Brand_Binding_Which = 1
)

func (w Brand_Binding_Which) String() string {
	const s = "unboundtype"
	switch w {
	case Brand_Binding_Which_unbound:
		return s[0:7]
	case Brand_Binding_Which_type:
		return s[7:11]

	}
	return "Brand_Binding_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Brand_Binding_TypeID is the unique identifier for the type Brand_Binding.
const Brand_Binding_TypeID = 0xc863cd16969ee7fc

func NewBrand_Binding(s *capnp.Segment) (Brand_Binding, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Brand_Binding(st), err
}

func NewRootBrand_Binding(s *capnp.Segment) (Brand_Binding, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Brand_Binding(st), err
}

func ReadRootBrand_Binding(msg *capnp.Message) (Brand_Binding, error) {
	root, err := msg.Root()
	return Brand_Binding(root.Struct()), err
}

func (s Brand_Binding) String() string {
	str, _ := text.Marshal(0xc863cd16969ee7fc, capnp.Struct(s))
	return str
}

func (s Brand_Binding) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Brand_Binding) DecodeFromPtr(p capnp.Ptr) Brand_Binding {
	return Brand_Binding(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Brand_Binding) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Brand_Binding) Which() Brand_Binding_Which {
	return Brand_Binding_Which(capnp.Struct(s).Uint16(0))
}
func (s Brand_Binding) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Brand_Binding) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Brand_Binding) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Brand_Binding) SetUnbound() {
	capnp.Struct(s).SetUint16(0, 0)

}

func (s Brand_Binding) Type() (Type, error) {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != type")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Type(p.Struct()), err
}

func (s Brand_Binding) HasType() bool {
	if capnp.Struct(s).Uint16(0) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Brand_Binding) SetType(v Type) error {
	capnp.Struct(s).SetUint16(0, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewType sets the type field to a newly
// allocated Type struct, preferring placement in s's segment.
func (s Brand_Binding) NewType() (Type, error) {
	capnp.Struct(s).SetUint16(0, 1)
	ss, err := NewType(capnp.Struct(s).Segment())
	if err != nil {
		return Type{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Brand_Binding_List is a list of Brand_Binding.
type Brand_Binding_List = capnp.StructList[Brand_Binding]

// NewBrand_Binding creates a new list of Brand_Binding.
func NewBrand_Binding_List(s *capnp.Segment, sz int32) (Brand_Binding_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Brand_Binding](l), err
}

// Brand_Binding_Future is a wrapper for a Brand_Binding promised by a client call.
type Brand_Binding_Future struct{ *capnp.Future }

func (f Brand_Binding_Future) Struct() (Brand_Binding, error) {
	p, err := f.Future.Ptr()
	return Brand_Binding(p.Struct()), err
}
func (p Brand_Binding_Future) Type() Type_Future {
	return Type_Future{Future: p.Future.Field(0, nil)}
}

type Value capnp.Struct
type Value_Which uint16

const (
	Value_Which_void        Value_Which = 0
	Value_Which_bool        Value_Which = 1
	Value_Which_int8        Value_Which = 2
	Value_Which_int16       Value_Which = 3
	Value_Which_int32       Value_Which = 4
	Value_Which_int64       Value_Which = 5
	Value_Which_uint8       Value_Which = 6
	Value_Which_uint16      Value_Which = 7
	Value_Which_uint32      Value_Which = 8
	Value_Which_uint64      Value_Which = 9
	Value_Which_float32     Value_Which = 10
	Value_Which_float64     Value_Which = 11
	Value_Which_text        Value_Which = 12
	Value_Which_data        Value_Which = 13
	Value_Which_list        Value_Which = 14
	Value_Which_enum        Value_Which = 15
	Value_Which_structValue Value_Which = 16
	Value_Which_interface   Value_Which = 17
	Value_Which_anyPointer  Value_Which = 18
)

func (w Value_Which) String() string {
	const s = "voidboolint8int16int32int64uint8uint16uint32uint64float32float64textdatalistenumstructValueinterfaceanyPointer"
	switch w {
	case Value_Which_void:
		return s[0:4]
	case Value_Which_bool:
		return s[4:8]
	case Value_Which_int8:
		return s[8:12]
	case Value_Which_int16:
		return s[12:17]
	case Value_Which_int32:
		return s[17:22]
	case Value_Which_int64:
		return s[22:27]
	case Value_Which_uint8:
		return s[27:32]
	case Value_Which_uint16:
		return s[32:38]
	case Value_Which_uint32:
		return s[38:44]
	case Value_Which_uint64:
		return s[44:50]
	case Value_Which_float32:
		return s[50:57]
	case Value_Which_float64:
		return s[57:64]
	case Value_Which_text:
		return s[64:68]
	case Value_Which_data:
		return s[68:72]
	case Value_Which_list:
		return s[72:76]
	case Value_Which_enum:
		return s[76:80]
	case Value_Which_structValue:
		return s[80:91]
	case Value_Which_interface:
		return s[91:100]
	case Value_Which_anyPointer:
		return s[100:110]

	}
	return "Value_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Value_TypeID is the unique identifier for the type Value.
const Value_TypeID = 0xce23dcd2d7b00c9b

func NewValue(s *capnp.Segment) (Value, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Value(st), err
}

func NewRootValue(s *capnp.Segment) (Value, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Value(st), err
}

func ReadRootValue(msg *capnp.Message) (Value, error) {
	root, err := msg.Root()
	return Value(root.Struct()), err
}

func (s Value) String() string {
	str, _ := text.Marshal(0xce23dcd2d7b00c9b, capnp.Struct(s))
	return str
}

func (s Value) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Value) DecodeFromPtr(p capnp.Ptr) Value {
	return Value(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Value) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Value) Which() Value_Which {
	return Value_Which(capnp.Struct(s).Uint16(0))
}
func (s Value) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Value) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Value) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Value) SetVoid() {
	capnp.Struct(s).SetUint16(0, 0)

}

func (s Value) Bool() bool {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != bool")
	}
	return capnp.Struct(s).Bit(16)
}

func (s Value) SetBool(v bool) {
	capnp.Struct(s).SetUint16(0, 1)
	capnp.Struct(s).SetBit(16, v)
}

func (s Value) Int8() int8 {
	if capnp.Struct(s).Uint16(0) != 2 {
		panic("Which() != int8")
	}
	return int8(capnp.Struct(s).Uint8(2))
}

func (s Value) SetInt8(v int8) {
	capnp.Struct(s).SetUint16(0, 2)
	capnp.Struct(s).SetUint8(2, uint8(v))
}

func (s Value) Int16() int16 {
	if capnp.Struct(s).Uint16(0) != 3 {
		panic("Which() != int16")
	}
	return int16(capnp.Struct(s).Uint16(2))
}

func (s Value) SetInt16(v int16) {
	capnp.Struct(s).SetUint16(0, 3)
	capnp.Struct(s).SetUint16(2, uint16(v))
}

func (s Value) Int32() int32 {
	if capnp.Struct(s).Uint16(0) != 4 {
		panic("Which() != int32")
	}
	return int32(capnp.Struct(s).Uint32(4))
}

func (s Value) SetInt32(v int32) {
	capnp.Struct(s).SetUint16(0, 4)
	capnp.Struct(s).SetUint32(4, uint32(v))
}

func (s Value) Int64() int64 {
	if capnp.Struct(s).Uint16(0) != 5 {
		panic("Which() != int64")
	}
	return int64(capnp.Struct(s).Uint64(8))
}

func (s Value) SetInt64(v int64) {
	capnp.Struct(s).SetUint16(0, 5)
	capnp.Struct(s).SetUint64(8, uint64(v))
}

func (s Value) Uint8() uint8 {
	if capnp.Struct(s).Uint16(0) != 6 {
		panic("Which() != uint8")
	}
	return capnp.Struct(s).Uint8(2)
}

func (s Value) SetUint8(v uint8) {
	capnp.Struct(s).SetUint16(0, 6)
	capnp.Struct(s).SetUint8(2, v)
}

func (s Value) Uint16() uint16 {
	if capnp.Struct(s).Uint16(0) != 7 {
		panic("Which() != uint16")
	}
	return capnp.Struct(s).Uint16(2)
}

func (s Value) SetUint16(v uint16) {
	capnp.Struct(s).SetUint16(0, 7)
	capnp.Struct(s).SetUint16(2, v)
}

func (s Value) Uint32() uint32 {
	if capnp.Struct(s).Uint16(0) != 8 {
		panic("Which() != uint32")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s Value) SetUint32(v uint32) {
	capnp.Struct(s).SetUint16(0, 8)
	capnp.Struct(s).SetUint32(4, v)
}

func (s Value) Uint64() uint64 {
	if capnp.Struct(s).Uint16(0) != 9 {
		panic("Which() != uint64")
	}
	return capnp.Struct(s).Uint64(8)
}

func (s Value) SetUint64(v uint64) {
	capnp.Struct(s).SetUint16(0, 9)
	capnp.Struct(s).SetUint64(8, v)
}

func (s Value) Float32() float32 {
	if capnp.Struct(s).Uint16(0) != 10 {
		panic("Which() != float32")
	}
	return math.Float32frombits(capnp.Struct(s).Uint32(4))
}

func (s Value) SetFloat32(v float32) {
	capnp.Struct(s).SetUint16(0, 10)
	capnp.Struct(s).SetUint32(4, math.Float32bits(v))
}

func (s Value) Float64() float64 {
	if capnp.Struct(s).Uint16(0) != 11 {
		panic("Which() != float64")
	}
	return math.Float64frombits(capnp.Struct(s).Uint64(8))
}

func (s Value) SetFloat64(v float64) {
	capnp.Struct(s).SetUint16(0, 11)
	capnp.Struct(s).SetUint64(8, math.Float64bits(v))
}

func (s Value) Text() (string, error) {
	if capnp.Struct(s).Uint16(0) != 12 {
		panic("Which() != text")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Value) HasText() bool {
	if capnp.Struct(s).Uint16(0) != 12 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Value) TextBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Value) SetText(v string) error {
	capnp.Struct(s).SetUint16(0, 12)
	return capnp.Struct(s).SetText(0, v)
}

func (s Value) Data() ([]byte, error) {
	if capnp.Struct(s).Uint16(0) != 13 {
		panic("Which() != data")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return []byte(p.Data()), err
}

func (s Value) HasData() bool {
	if capnp.Struct(s).Uint16(0) != 13 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Value) SetData(v []byte) error {
	capnp.Struct(s).SetUint16(0, 13)
	return capnp.Struct(s).SetData(0, v)
}

func (s Value) List() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(0) != 14 {
		panic("Which() != list")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Value) HasList() bool {
	if capnp.Struct(s).Uint16(0) != 14 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Value) SetList(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(0, 14)
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Value) Enum() uint16 {
	if capnp.Struct(s).Uint16(0) != 15 {
		panic("Which() != enum")
	}
	return capnp.Struct(s).Uint16(2)
}

func (s Value) SetEnum(v uint16) {
	capnp.Struct(s).SetUint16(0, 15)
	capnp.Struct(s).SetUint16(2, v)
}

func (s Value) StructValue() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(0) != 16 {
		panic("Which() != structValue")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Value) HasStructValue() bool {
	if capnp.Struct(s).Uint16(0) != 16 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Value) SetStructValue(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(0, 16)
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Value) SetInterface() {
	capnp.Struct(s).SetUint16(0, 17)

}

func (s Value) AnyPointer() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(0) != 18 {
		panic("Which() != anyPointer")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Value) HasAnyPointer() bool {
	if capnp.Struct(s).Uint16(0) != 18 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Value) SetAnyPointer(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(0, 18)
	return capnp.Struct(s).SetPtr(0, v)
}

// Value_List is a list of Value.
type Value_List = capnp.StructList[Value]

// NewValue creates a new list of Value.
func NewValue_List(s *capnp.Segment, sz int32) (Value_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return capnp.StructList[Value](l), err
}

// Value_Future is a wrapper for a Value promised by a client call.
type Value_Future struct{ *capnp.Future }

func (f Value_Future) Struct() (Value, error) {
	p, err := f.Future.Ptr()
	return Value(p.Struct()), err
}
func (p Value_Future) List() *capnp.Future {
	return p.Future.Field(0, nil)
}
func (p Value_Future) StructValue() *capnp.Future {
	return p.Future.Field(0, nil)
}
func (p Value_Future) AnyPointer() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Annotation capnp.Struct

// Annotation_TypeID is the unique identifier for the type Annotation.
const Annotation_TypeID = 0xf1c8950dab257542

func NewAnnotation(s *capnp.Segment) (Annotation, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Annotation(st), err
}

func NewRootAnnotation(s *capnp.Segment) (Annotation, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Annotation(st), err
}

func ReadRootAnnotation(msg *capnp.Message) (Annotation, error) {
	root, err := msg.Root()
	return Annotation(root.Struct()), err
}

func (s Annotation) String() string {
	str, _ := text.Marshal(0xf1c8950dab257542, capnp.Struct(s))
	return str
}

func (s Annotation) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Annotation) DecodeFromPtr(p capnp.Ptr) Annotation {
	return Annotation(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Annotation) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Annotation) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Annotation) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Annotation) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Annotation) Id() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s Annotation) SetId(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s Annotation) Brand() (Brand, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Brand(p.Struct()), err
}

func (s Annotation) HasBrand() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Annotation) SetBrand(v Brand) error {
	return capnp.Struct(s).SetPtr(1, capnp.Struct(v).ToPtr())
}

// NewBrand sets the brand field to a newly
// allocated Brand struct, preferring placement in s's segment.
func (s Annotation) NewBrand() (Brand, error) {
	ss, err := NewBrand(capnp.Struct(s).Segment())
	if err != nil {
		return Brand{}, err
	}
	err = capnp.Struct(s).SetPtr(1, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Annotation) Value() (Value, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Value(p.Struct()), err
}

func (s Annotation) HasValue() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Annotation) SetValue(v Value) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewValue sets the value field to a newly
// allocated Value struct, preferring placement in s's segment.
func (s Annotation) NewValue() (Value, error) {
	ss, err := NewValue(capnp.Struct(s).Segment())
	if err != nil {
		return Value{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Annotation_List is a list of Annotation.
type Annotation_List = capnp.StructList[Annotation]

// NewAnnotation creates a new list of Annotation.
func NewAnnotation_List(s *capnp.Segment, sz int32) (Annotation_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Annotation](l), err
}

// Annotation_Future is a wrapper for a Annotation promised by a client call.
type Annotation_Future struct{ *capnp.Future }

func (f Annotation_Future) Struct() (Annotation, error) {
	p, err := f.Future.Ptr()
	return Annotation(p.Struct()), err
}
func (p Annotation_Future) Brand() Brand_Future {
	return Brand_Future{Future: p.Future.Field(1, nil)}
}
func (p Annotation_Future) Value() Value_Future {
	return Value_Future{Future: p.Future.Field(0, nil)}
}

type ElementSize uint16

// ElementSize_TypeID is the unique identifier for the type ElementSize.
const ElementSize_TypeID = 0xd1958f7dba521926

// Values of ElementSize.
const (
	ElementSize_empty           ElementSize = 0
	ElementSize_bit             ElementSize = 1
	ElementSize_byte            ElementSize = 2
	ElementSize_twoBytes        ElementSize = 3
	ElementSize_fourBytes       ElementSize = 4
	ElementSize_eightBytes      ElementSize = 5
	ElementSize_pointer         ElementSize = 6
	ElementSize_inlineComposite ElementSize = 7
)

// String returns the enum's constant name.
func (c ElementSize) String() string {
	switch c {
	case ElementSize_empty:
		return "empty"
	case ElementSize_bit:
		return "bit"
	case ElementSize_byte:
		return "byte"
	case ElementSize_twoBytes:
		return "twoBytes"
	case ElementSize_fourBytes:
		return "fourBytes"
	case ElementSize_eightBytes:
		return "eightBytes"
	case ElementSize_pointer:
		return "pointer"
	case ElementSize_inlineComposite:
		return "inlineComposite"

	default:
		return ""
	}
}

// ElementSizeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func ElementSizeFromString(c string) ElementSize {
	switch c {
	case "empty":
		return ElementSize_empty
	case "bit":
		return ElementSize_bit
	case "byte":
		return ElementSize_byte
	case "twoBytes":
		return ElementSize_twoBytes
	case "fourBytes":
		return ElementSize_fourBytes
	case "eightBytes":
		return ElementSize_eightBytes
	case "pointer":
		return ElementSize_pointer
	case "inlineComposite":
		return ElementSize_inlineComposite

	default:
		return 0
	}
}

type ElementSize_List = capnp.EnumList[ElementSize]

func NewElementSize_List(s *capnp.Segment, sz int32) (ElementSize_List, error) {
	return capnp.NewEnumList[ElementSize](s, sz)
}

type CapnpVersion capnp.Struct

// CapnpVersion_TypeID is the unique identifier for the type CapnpVersion.
const CapnpVersion_TypeID = 0xd85d305b7d839963

func NewCapnpVersion(s *capnp.Segment) (CapnpVersion, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return CapnpVersion(st), err
}

func NewRootCapnpVersion(s *capnp.Segment) (CapnpVersion, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return CapnpVersion(st), err
}

func ReadRootCapnpVersion(msg *capnp.Message) (CapnpVersion, error) {
	root, err := msg.Root()
	return CapnpVersion(root.Struct()), err
}

func (s CapnpVersion) String() string {
	str, _ := text.Marshal(0xd85d305b7d839963, capnp.Struct(s))
	return str
}

func (s CapnpVersion) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (CapnpVersion) DecodeFromPtr(p capnp.Ptr) CapnpVersion {
	return CapnpVersion(capnp.Struct{}.DecodeFromPtr(p))
}

func (s CapnpVersion) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s CapnpVersion) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s CapnpVersion) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s CapnpVersion) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s CapnpVersion) Major() uint16 {
	return capnp.Struct(s).Uint16(0)
}

func (s CapnpVersion) SetMajor(v uint16) {
	capnp.Struct(s).SetUint16(0, v)
}

func (s CapnpVersion) Minor() uint8 {
	return capnp.Struct(s).Uint8(2)
}

func (s CapnpVersion) SetMinor(v uint8) {
	capnp.Struct(s).SetUint8(2, v)
}

func (s CapnpVersion) Micro() uint8 {
	return capnp.Struct(s).Uint8(3)
}

func (s CapnpVersion) SetMicro(v uint8) {
	capnp.Struct(s).SetUint8(3, v)
}

// CapnpVersion_List is a list of CapnpVersion.
type CapnpVersion_List = capnp.StructList[CapnpVersion]

// NewCapnpVersion creates a new list of CapnpVersion.
func NewCapnpVersion_List(s *capnp.Segment, sz int32) (CapnpVersion_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[CapnpVersion](l), err
}

// CapnpVersion_Future is a wrapper for a CapnpVersion promised by a client call.
type CapnpVersion_Future struct{ *capnp.Future }

func (f CapnpVersion_Future) Struct() (CapnpVersion, error) {
	p, err := f.Future.Ptr()
	return CapnpVersion(p.Struct()), err
}

type CodeGeneratorRequest capnp.Struct

// CodeGeneratorRequest_TypeID is the unique identifier for the type CodeGeneratorRequest.
const CodeGeneratorRequest_TypeID = 0xbfc546f6210ad7ce

func NewCodeGeneratorRequest(s *capnp.Segment) (CodeGeneratorRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return CodeGeneratorRequest(st), err
}

func NewRootCodeGeneratorRequest(s *capnp.Segment) (CodeGeneratorRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return CodeGeneratorRequest(st), err
}

func ReadRootCodeGeneratorRequest(msg *capnp.Message) (CodeGeneratorRequest, error) {
	root, err := msg.Root()
	return CodeGeneratorRequest(root.Struct()), err
}

func (s CodeGeneratorRequest) String() string {
	str, _ := text.Marshal(0xbfc546f6210ad7ce, capnp.Struct(s))
	return str
}

func (s CodeGeneratorRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (CodeGeneratorRequest) DecodeFromPtr(p capnp.Ptr) CodeGeneratorRequest {
	return CodeGeneratorRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s CodeGeneratorRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s CodeGeneratorRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s CodeGeneratorRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s CodeGeneratorRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s CodeGeneratorRequest) CapnpVersion() (CapnpVersion, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return CapnpVersion(p.Struct()), err
}

func (s CodeGeneratorRequest) HasCapnpVersion() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s CodeGeneratorRequest) SetCapnpVersion(v CapnpVersion) error {
	return capnp.Struct(s).SetPtr(2, capnp.Struct(v).ToPtr())
}

// NewCapnpVersion sets the capnpVersion field to a newly
// allocated CapnpVersion struct, preferring placement in s's segment.
func (s CodeGeneratorRequest) NewCapnpVersion() (CapnpVersion, error) {
	ss, err := NewCapnpVersion(capnp.Struct(s).Segment())
	if err != nil {
		return CapnpVersion{}, err
	}
	err = capnp.Struct(s).SetPtr(2, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s CodeGeneratorRequest) Nodes() (Node_List, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Node_List(p.List()), err
}

func (s CodeGeneratorRequest) HasNodes() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s CodeGeneratorRequest) SetNodes(v Node_List) error {
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewNodes sets the nodes field to a newly
// allocated Node_List, preferring placement in s's segment.
func (s CodeGeneratorRequest) NewNodes(n int32) (Node_List, error) {
	l, err := NewNode_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Node_List{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}
func (s CodeGeneratorRequest) SourceInfo() (Node_SourceInfo_List, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return Node_SourceInfo_List(p.List()), err
}

func (s CodeGeneratorRequest) HasSourceInfo() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s CodeGeneratorRequest) SetSourceInfo(v Node_SourceInfo_List) error {
	return capnp.Struct(s).SetPtr(3, v.ToPtr())
}

// NewSourceInfo sets the sourceInfo field to a newly
// allocated Node_SourceInfo_List, preferring placement in s's segment.
func (s CodeGeneratorRequest) NewSourceInfo(n int32) (Node_SourceInfo_List, error) {
	l, err := NewNode_SourceInfo_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Node_SourceInfo_List{}, err
	}
	err = capnp.Struct(s).SetPtr(3, l.ToPtr())
	return l, err
}
func (s CodeGeneratorRequest) RequestedFiles() (CodeGeneratorRequest_RequestedFile_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return CodeGeneratorRequest_RequestedFile_List(p.List()), err
}

func (s CodeGeneratorRequest) HasRequestedFiles() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s CodeGeneratorRequest) SetRequestedFiles(v CodeGeneratorRequest_RequestedFile_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewRequestedFiles sets the requestedFiles field to a newly
// allocated CodeGeneratorRequest_RequestedFile_List, preferring placement in s's segment.
func (s CodeGeneratorRequest) NewRequestedFiles(n int32) (CodeGeneratorRequest_RequestedFile_List, error) {
	l, err := NewCodeGeneratorRequest_RequestedFile_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return CodeGeneratorRequest_RequestedFile_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

// CodeGeneratorRequest_List is a list of CodeGeneratorRequest.
type CodeGeneratorRequest_List = capnp.StructList[CodeGeneratorRequest]

// NewCodeGeneratorRequest creates a new list of CodeGeneratorRequest.
func NewCodeGeneratorRequest_List(s *capnp.Segment, sz int32) (CodeGeneratorRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4}, sz)
	return capnp.StructList[CodeGeneratorRequest](l), err
}

// CodeGeneratorRequest_Future is a wrapper for a CodeGeneratorRequest promised by a client call.
type CodeGeneratorRequest_Future struct{ *capnp.Future }

func (f CodeGeneratorRequest_Future) Struct() (CodeGeneratorRequest, error) {
	p, err := f.Future.Ptr()
	return CodeGeneratorRequest(p.Struct()), err
}
func (p CodeGeneratorRequest_Future) CapnpVersion() CapnpVersion_Future {
	return CapnpVersion_Future{Future: p.Future.Field(2, nil)}
}

type CodeGeneratorRequest_RequestedFile capnp.Struct

// CodeGeneratorRequest_RequestedFile_TypeID is the unique identifier for the type CodeGeneratorRequest_RequestedFile.
const CodeGeneratorRequest_RequestedFile_TypeID = 0xcfea0eb02e810062

func NewCodeGeneratorRequest_RequestedFile(s *capnp.Segment) (CodeGeneratorRequest_RequestedFile, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return CodeGeneratorRequest_RequestedFile(st), err
}

func NewRootCodeGeneratorRequest_RequestedFile(s *capnp.Segment) (CodeGeneratorRequest_RequestedFile, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return CodeGeneratorRequest_RequestedFile(st), err
}

func ReadRootCodeGeneratorRequest_RequestedFile(msg *capnp.Message) (CodeGeneratorRequest_RequestedFile, error) {
	root, err := msg.Root()
	return CodeGeneratorRequest_RequestedFile(root.Struct()), err
}

func (s CodeGeneratorRequest_RequestedFile) String() string {
	str, _ := text.Marshal(0xcfea0eb02e810062, capnp.Struct(s))
	return str
}

func (s CodeGeneratorRequest_RequestedFile) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (CodeGeneratorRequest_RequestedFile) DecodeFromPtr(p capnp.Ptr) CodeGeneratorRequest_RequestedFile {
	return CodeGeneratorRequest_RequestedFile(capnp.Struct{}.DecodeFromPtr(p))
}

func (s CodeGeneratorRequest_RequestedFile) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s CodeGeneratorRequest_RequestedFile) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s CodeGeneratorRequest_RequestedFile) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s CodeGeneratorRequest_RequestedFile) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s CodeGeneratorRequest_RequestedFile) Id() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s CodeGeneratorRequest_RequestedFile) SetId(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s CodeGeneratorRequest_RequestedFile) Filename() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s CodeGeneratorRequest_RequestedFile) HasFilename() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s CodeGeneratorRequest_RequestedFile) FilenameBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s CodeGeneratorRequest_RequestedFile) SetFilename(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s CodeGeneratorRequest_RequestedFile) Imports() (CodeGeneratorRequest_RequestedFile_Import_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return CodeGeneratorRequest_RequestedFile_Import_List(p.List()), err
}

func (s CodeGeneratorRequest_RequestedFile) HasImports() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s CodeGeneratorRequest_RequestedFile) SetImports(v CodeGeneratorRequest_RequestedFile_Import_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewImports sets the imports field to a newly
// allocated CodeGeneratorRequest_RequestedFile_Import_List, preferring placement in s's segment.
func (s CodeGeneratorRequest_RequestedFile) NewImports(n int32) (CodeGeneratorRequest_RequestedFile_Import_List, error) {
	l, err := NewCodeGeneratorRequest_RequestedFile_Import_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return CodeGeneratorRequest_RequestedFile_Import_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

// CodeGeneratorRequest_RequestedFile_List is a list of CodeGeneratorRequest_RequestedFile.
type CodeGeneratorRequest_RequestedFile_List = capnp.StructList[CodeGeneratorRequest_RequestedFile]

// NewCodeGeneratorRequest_RequestedFile creates a new list of CodeGeneratorRequest_RequestedFile.
func NewCodeGeneratorRequest_RequestedFile_List(s *capnp.Segment, sz int32) (CodeGeneratorRequest_RequestedFile_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[CodeGeneratorRequest_RequestedFile](l), err
}

// CodeGeneratorRequest_RequestedFile_Future is a wrapper for a CodeGeneratorRequest_RequestedFile promised by a client call.
type CodeGeneratorRequest_RequestedFile_Future struct{ *capnp.Future }

func (f CodeGeneratorRequest_RequestedFile_Future) Struct() (CodeGeneratorRequest_RequestedFile, error) {
	p, err := f.Future.Ptr()
	return CodeGeneratorRequest_RequestedFile(p.Struct()), err
}

type CodeGeneratorRequest_RequestedFile_Import capnp.Struct

// CodeGeneratorRequest_RequestedFile_Import_TypeID is the unique identifier for the type CodeGeneratorRequest_RequestedFile_Import.
const CodeGeneratorRequest_RequestedFile_Import_TypeID = 0xae504193122357e5

func NewCodeGeneratorRequest_RequestedFile_Import(s *capnp.Segment) (CodeGeneratorRequest_RequestedFile_Import, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return CodeGeneratorRequest_RequestedFile_Import(st), err
}

func NewRootCodeGeneratorRequest_RequestedFile_Import(s *capnp.Segment) (CodeGeneratorRequest_RequestedFile_Import, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return CodeGeneratorRequest_RequestedFile_Import(st), err
}

func ReadRootCodeGeneratorRequest_RequestedFile_Import(msg *capnp.Message) (CodeGeneratorRequest_RequestedFile_Import, error) {
	root, err := msg.Root()
	return CodeGeneratorRequest_RequestedFile_Import(root.Struct()), err
}

func (s CodeGeneratorRequest_RequestedFile_Import) String() string {
	str, _ := text.Marshal(0xae504193122357e5, capnp.Struct(s))
	return str
}

func (s CodeGeneratorRequest_RequestedFile_Import) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (CodeGeneratorRequest_RequestedFile_Import) DecodeFromPtr(p capnp.Ptr) CodeGeneratorRequest_RequestedFile_Import {
	return CodeGeneratorRequest_RequestedFile_Import(capnp.Struct{}.DecodeFromPtr(p))
}

func (s CodeGeneratorRequest_RequestedFile_Import) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s CodeGeneratorRequest_RequestedFile_Import) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s CodeGeneratorRequest_RequestedFile_Import) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s CodeGeneratorRequest_RequestedFile_Import) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s CodeGeneratorRequest_RequestedFile_Import) Id() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s CodeGeneratorRequest_RequestedFile_Import) SetId(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s CodeGeneratorRequest_RequestedFile_Import) Name() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s CodeGeneratorRequest_RequestedFile_Import) HasName() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s CodeGeneratorRequest_RequestedFile_Import) NameBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s CodeGeneratorRequest_RequestedFile_Import) SetName(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

// CodeGeneratorRequest_RequestedFile_Import_List is a list of CodeGeneratorRequest_RequestedFile_Import.
type CodeGeneratorRequest_RequestedFile_Import_List = capnp.StructList[CodeGeneratorRequest_RequestedFile_Import]

// NewCodeGeneratorRequest_RequestedFile_Import creates a new list of CodeGeneratorRequest_RequestedFile_Import.
func NewCodeGeneratorRequest_RequestedFile_Import_List(s *capnp.Segment, sz int32) (CodeGeneratorRequest_RequestedFile_Import_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[CodeGeneratorRequest_RequestedFile_Import](l), err
}

// CodeGeneratorRequest_RequestedFile_Import_Future is a wrapper for a CodeGeneratorRequest_RequestedFile_Import promised by a client call.
type CodeGeneratorRequest_RequestedFile_Import_Future struct{ *capnp.Future }

func (f CodeGeneratorRequest_RequestedFile_Import_Future) Struct() (CodeGeneratorRequest_RequestedFile_Import, error) {
	p, err := f.Future.Ptr()
	return CodeGeneratorRequest_RequestedFile_Import(p.Struct()), err
}

const schema_a93fc509624c72d9 = "x\xda\xacz{\x90\x1c\xd5u\xf79\xb7\xe7\xb1\xaff" +
	"\xb6\xe7\xce\"\x10\xe8\x9b\x15\x92>$\x05\xd6\xd2\xae\x90" +
	"\xc5\x1a\xb2h\xc5\x0aK\x91\xf0\xb6F\x08\xd8\x84\xb2z" +
	"gz\xb5\x8dg\xbaG==\xa0Q\xa0\x16\x88)l" +
	"b@&\xc8`\xd9\xa2l\x02UV\x00[J\xa0\xca" +
	"\x92I\x80-\x08\xa0\x02\x1b\x1c(\xc0\x86\xc4\x10c\x88" +
	"\x12\x05\x14\xf3\x16\xa8S\xe7vOw\xef\xec,\x8f\x0a" +
	"\x7f\xed\xcc9w\xee=\xf7\x9c\xf3;\xaf\xbbK\x8e\xb6" +
	"\x9f\x13[*\x9f\x9a\x02\xa6\xee\x8d'\xdc[\x0fmn" +
	"[p\xe6\xeb\xd7\x81\x9aF\xc9\xdd\xfc\xe4\x07\xaf\x1c\xde" +
	"Vy\x1a\xba0\x89\x00\xbc\x96<\x00\xc8k\xc9\x01@" +
	"w\xd3\xf2\x8b\x8f\xd5\xbe\xfe\x95\x1bA\x9d\x83\x92{d" +
	"\xcd\x9f\xde\xf1\xc6\xc0\x85\x93p\x01&1\x86\xf1\xbe\xdd" +
	"\xc9\x11\x04\xe4{\x92\xaf\x03\xba\x7f2\xa8o~\xeb\x82" +
	"e;@\x91\xd1}\xd1^7\xda\xfa\xe8\xc0\x1e\x88c" +
	"\x12\x80_\xdd\xb2\x8b\x7f\xbb\xe5T\x00\xbe\xbbe\x00\xf0" +
	"\xc1\xab\xd6\xf7}\xe5\xd5'w\xaa2J\x91\xa5qZ" +
	"\xfaT\xcb\x1d\xfc\xb9\x96$@\xdf3-\x8f!\xa0\xbb" +
	"~\xd7\xc6\x97\xfe\xf3\x8a\xebo\x05U\xc6\xe8\xc6\x8cV" +
	"\xbf\xd8v\x80\xbf\xd2F\x9f^n\xfb\x19\xa0\x9b~\xec" +
	"\xd8\x15\xff\xb4n\xdf\xad\xa0\xf0\x98\xfb\xf5\xb7\xd7f\xef" +
	"\x1c\xbew\x17\x00\xf6\xdd\xd0\x9eF\xbe\xbb=\x09\x90\xbb" +
	"\xad]\xc2\xdc\x9d\xed\x0c\x01\xc2%SE\x19\x8a%\x19" +
	"\xc6\xf8\xce\xf6]|w\xfb,\x80\xbe=\xed7\x91," +
	"\xd7\xae\xd5\xde\x9e\xff\xde3\xbb\x1b\xf4\xe1i\xae\xef\xe3" +
	"\x8e~RG\\\xbe\x1c\xd0\xdds\xdd\xc4\xec\xad\xdb\x8e" +
	"\xbb\xbd\xb9\x92u\x99\x94\xac\x8b\x95g\x9c{\xf4\xcb?" +
	"\xd8\xf7#\xb12\xee\xce\xbas\xde\x07\xeb\xee\xbe\xe6\x0f" +
	"\xd0\x95\x10+\x1f\x96\x0f\x02\xf6=*\x8b\xf3\xdf\x7f\xfe" +
	"\xce\xa7o_\xfc\xbd=\x8d\xba\x10J\xbe25\xc9\xaf" +
	"M\x09u\xa7h\xdf'\xbe\x91\xdfs\xed\xb2\xe7\xef\x06" +
	"\x95#\x0b\xcd3\x84\xe2n/\xa7\x0e\xf2\xff\x10\xab_" +
	"K\x91\xe6\xfe\xe5\x9f\xd7\xbd\xb9\xd9\xea\xbf\xa7\xb9\xbc7" +
	"t\x1e\x04\xe4\xdf\xed\xa4}_\xbbp^\xfaoV\x0e" +
	"\xff\x14\xd4%\x88\x1f\x8f^\xdd\xb3\xf7\xb8C\xbf\x12\"" +
	"\xf4\x1d\xee<\x80<\xae\xd0\xae\xa8\xd0\xda\xee[\xe4\xed" +
	"\xf7\xdcu\xfd\xbe\xe6w\xbbD\x99\x04\xe4\x97\x88\x95\xb7" +
	"\xbd\xd3\xb7j\xf9?\xac\xbd\xbf\xf9\xca\xfd\x0a\xe9k\xbf" +
	"BN\xb9\xefoSG\x9e<i\xc3~P\xd2\x18." +
	"\xf4tpXy\x95\x7f \xce\x7fG\xacu^\xdd\xd4" +
	"\x91~\xe2\xcd\x03\xcd\x0d\xd6\x95\xfe;2\xd8\x824-" +
	"\xfdC\xfbu\xd7M>\xb7\xe3\x17\xa4.)t\x8c\x0b" +
	"bId\x18\xe7k\xd2\xbf\x01\xe4\xeb\xd3$\xeb/\x9f" +
	"o\x9b\xfb\xee\xeaG\x1flp\xf5\x18\xa9`_:\x8d" +
	"\xfc\xe1\xf4,r\xe54\xe1\"8t\xaab\x09C\x12" +
	"\xd9\x81\x1f\x02\xe4\xafp\xb2\xc1\x1d\xd9\x1b\xbf\xbdb\xc7" +
	"\x81IP\xe6\xa0\xfb\xd3\x0by\xec\xdf\xe7\xdc\xf8G\xef" +
	"f}gdNA>\x94\xa1\xab\xad\xcc\x90\xbc\x96s" +
	"\xdf7\xce\x8b\xcf{\xa4A\xde\xae\x98\xe7`\x19R\xad" +
	"\x9e!\x09>z\xfd\xf6\xef\x1d\xffT\xfeqZ\x89S" +
	"\x1d\x01\x80\x0fu\xfd\x86\xab]\xb4\xef\xfa.\xba\x9c2" +
	"\xe7\xb7\xe3\xbf}\xea\xa3\x83\xcd\xf7\xdd\xd3E\x8epo" +
	"\x17I\xf0\x83\x8e\xbd\xcf\xff\xfa\xa5y\xbf$od\x11" +
	"\xf0`\x92\xd3\xed\xbbv\xf1\xe7\xba\x04\x90\xbb\xbe\x14\x83" +
	"\xc0S\xd4S0\xa2A\x01\xe3\xbe\x8bg_\x83\xbc4" +
	"\x9b\x94V\x9dM\x9a\x08\xd4\xd4\x80Ko\xeb\xb9'\xdd" +
	"\xcc\x17\x9dD?\\p\x12m\xed\xfe\xff\x137\x1c\xb8" +
	"\xf2\xa6\x9d\xcf\x80\"G\x04\x01\xe4s\xb3\x07\xf9\xe9Y" +
	"\xba\xdc\xa2\xecc\x80n\xfe\xfb\x7fu\xe5\x9f/\xb9\xe4" +
	"\x85\x06\x00\x91\xe5\xf8\xee\xec\xaf\xf9\x1e\xb1\xf6\xae,\xc9" +
	"08\x99\xfa\xf0\x17\x17<\xf8\xafd\xb8i\x8evv" +
	"\xf7!\xbe\xa6\x9b>\x0du\x93\xd6\x02\xb6*c<\"" +
	"p\"\x99\xc0\x04\xffq\xf7\xcd|O\xf7\x97\x01\xfa\x9e" +
	"\xeb\x9e%\x01\xba7\xcd\x9d|\xebW\xb9S\xdfh\xee" +
	"\xedG\xe6\xbd\x0a\xc8\xdf\x99G\x1b\xef`m\xe7<{" +
	"\xe2\xf1\xff\xd5|eu\xfe!\xc0\xbe\xda\xfc\x7fc\x80" +
	"\xee\x83\x1dG\xdf3\x0e\xfe\xf5\xe1\xe6\x10\xbe\xebT\xda" +
	"t\xcf\xa9\xb4\xe9`u\xc1\xdd\xf2\xce\xc7\x8f4\x8d\xa9" +
	"\xf1\x85\x93\\^H\x9fZ\x17\x92\x1e\x02Gl\xd0\x83" +
	"X\xfc\xe3\x85\x87\xf8\xbd\x0b\xc9p\xf7/\xfc\x19\x9c\xef" +
	"V\xf2\xe3zI\xeb\xc9\xa3V6\xcb\xfd\x1bk\xe5\x01" +
	"\xbd\xa7hT\x1c5&\xc5\x002x\x1c\x80\"\x8f\x02" +
	"\xa8\x1d\x12\xaa'0t\xf5\xa2^\xd2Mg#$k" +
	"e\x1d;C\xb1\x01\xb1\x130\xd80V\xdfP\xef\xd1" +
	"\xcc\xda\xb0e\x98\x8en\xf7T\xcd\xbceV\x1c[3" +
	"LI/\xa8\x9dR\xac\xc3u3\x98\x06P\xb4A\x00" +
	"\xf5/$T\xc7\x19\xcax\xcc\xcd\xe0\x89\x00\x8a\xde\x0f" +
	"\xa0n\x96P-2\x94\xd9\xc7n\x06g\x03(\xc6b" +
	"\x00\xb5 \xa1Zf(K\x1f\xb9\x19<\x09@)\x8d" +
	"\x00\xa8E\x09\xd5m\x0c'4\xb3\xf6g\x86Y\x80\xc4" +
	"@\xc5\xb1\xaby\x07\x12)\xba\x17$\xdc\xbcV\xd6F" +
	"\x8d\xa2\x01\x92S\x83D\x83\x06\x06mM2\x0bj\x0b" +
	"F\xe2\xb1\xd2\xda\x1bbR\x89\x0ffsy\xab\xacO" +
	"\x0c\x1af\xc10\xb7x\x9a\x8a!)\x8a\x84m\x91P" +
	"\x9d\xcfp\xa0B\x8b*x\x1c\xe0\xb0\x84\xd8\x19n\x07" +
	"H\xc4\x86s\xd7\xebNr\xdc*\x0c#\xaa\xdd\xc1~" +
	"\xcf\xd05\x9f\x94P}\x81!b\x06\x89\xf6\xdc\x06\x00" +
	"\xf5Y\x09\xd5\xdf1T$\xcc \x03P^\xbe\x06@" +
	"}IB\xf5\x0d\x86J\x9ceP\x02P^\xbb\x1e@" +
	"}CB\xf5m\x86J\x123\x18\x03P\x8e\x90-\xdf" +
	"\x920\xd7\x81\x0c\x95\x18\xcb`\x9c\x1c\x07G\x00r-" +
	"(a.C\xf4\x84\x94\xc1\x04\x00Wp\x14 \xd7I" +
	"\xf4\x93\x89\xceb\x19\x81\xa6\x13q\x17@\xeed\xa2\xaf" +
	"@\x86)S+\xe9\xd8\x01\x0c;\x08\xb3VA\xff\x9a" +
	"]\xd0\x01mL\x02\xc3$\xa0[\xd6l\xad\x94sl" +
	"\xac\xe6\x1d\xf2\x09\xc0V`\xd8\x0a\xe8\xdaz\xa5Zt" +
	"r\x0e\xdauV\xc8\xd3L\xd3r4\xc7\x80\xa4eF" +
	"4\x19\xa0\xc1\xd7\xa4\xd8|\xd0\xd6@2\x0b\xd8\x19\x06" +
	"L\xdf#\xbd\x13\x06mHjM\xf9F\xa9\\4\xf2" +
	"\x86\x83\xc3\xb4\x8f\xee\xe8\x92\x1d9,\xc8^M\xcd6" +
	"dV\x07J\xba\xad\x99\x0eY\xae#\xb0\xdc\x10Y\xee" +
	"\x1c\x09\xd5u\xa1\xe5\xd6\x90\xe5\xbe*\xa1\xba\x914\xe9" +
	"[N%{\x0c{\xfe\xfd\xe9j\xfc\x8c\x0a\xa9\xcb(" +
	"\x09\x19W\x1bz\xb1\xd0cZ\xe7\x1a\x95\xbcm\x94\x0c" +
	"S3\x91\xc4\xa5]\xe5\xa4\xebN\xbb\xd4jC\x97\x8a" +
	"\x055\x86\xd1\xfa\x0c\xb7\xbb\xf5-`@l\xe2\xa8'" +
	"\x07\xf7\xbd\x9f\xee\xbbWB\xf5\x81\xf0\xbe\xfb\xe9\xbe?" +
	"\x97P}$r\xdf\x87\xe9\xbe\x0fI\xa8\xbe\xe4\xbb\xaf" +
	"\x84\xa8\xbcxs\xe8\xber\xccu1\x92-\x95\xd7\x16" +
	"\x03\x93\xe3\xc7\x88\x18\xa4:\xe5\xa9^`\x98\xc0H\x15" +
	"\xa0\xdc?\x08\xec\x0b\xd3`\xc1\xd7\x15\xd2=7i\xc5" +
	"*\xea\xa1\xbaR\x95\xa2\xe5d\xb7\xd8V\xb5<a\xd9" +
	"\x05\xc3\xd4\x8a\x0d*o\x0c{e\xcd\x1e\x10\xaee\xab" +
	"-R\xac\x93e\x90\x03(\x8b(\xe2\xcd\x97P]\xc2" +
	"P\xc1x\x063\x00\xca\xe9\xdb\x01\xd4\xd3$TW0" +
	"\x9c\x101dM!\x00D\xd9\xf7P\x18\xb0\xd7\x98\x05" +
	"}[p\xadfa\\7\xab%q\x1cf0E\xc7" +
	"\xf5\x87\xc7\x91\x8d\xba\xe8\xb4^\x00u\xa1\x84\xea2\x86" +
	"\x03N-zXv\xd4n\x8e\x97\xfaYL\x9cu\xbe" +
	"U\xd0{\xfc\x10\x0b\xe4\x11\x9dI\x11#\x94\xfbm\x00" +
	"\xf5>\x09\xd5\x87\xe8v\x1d\x19l\x01P\xfe\xf1R\x00" +
	"\xf5\x01\x09\xd5\xc7\xc9'\xe4\x0c\xb6\x02(\x8f\xfe=\x80" +
	"\xfa\xb8\x84\xea\xb3\xe4\x13\xbf\xcb`\x1b\xc5\xbe\xc10\xf6" +
	")\xb1T\x06\xdb)\xf8\x91\xa3\xbc \xa1\xfa{\x8as" +
	"-\x19\xec\x00P^\xd9\x05\xa0\xfe^B\xf5-?r" +
	"\xc9\x00\xca\xe1~/\xf8\xe5b\xc8\xd0-h\x8ev\xa1" +
	"e\x17 \xbb\xca\xaa\x9aN\x18\x96<\xfb\xac\x82\xd4T" +
	"\xb2\xad\x8f\xe9\xb6\xadca\x9dQq\x86\xcc|\xd6\xa2" +
	"H\x8f\xa9\xb0p\x01\xc4\x14\xe0\x84Q9\x8f\xdc\x00\x11" +
	"\x18b\xa3\xdf\xd0Y\x18\xee:\x85\xf7\xb5\xb1\xb1\x8a\xa4" +
	";\xd8\x02\x0c[\x00\x07\xc6\x08\xa4\x11\x87\x8c\xf4BS" +
	" \xed)=W-\xebv\xbe\xa8U*@q\xa7%" +
	"\xc0\xe1\xa2\xd9Sm\x8c\x0d6\x96\x8c\xcfk\xdfAZ" +
	"\xd5#2\x1e@C\x90\x1b\x0c\x83\x9c\x8c\x94\xc7E\x98" +
	"\xa3Pp\xae\x84\xeaf\xca\xd8\x94\xc7\x09\xf7\x97\xd0\xda" +
	"\x8b$T\x0b\xd3\xdd:5j\x98\x85\xf0\xeaA\xaa\xf5" +
	"\xae>a\x98\xe3\xbam8\x91T\xcdB\x90\x05\x9e\xe7" +
	";zg\x13G?\xfe\xff\xe8\xe8qq\xdc*\xab\xa0" +
	"\x9f\xa7\x9b\xba\xad9\x96\xbdA\xdfZ\xd5+N\x8f\xff" +
	"W/\xac6\x8az\xcf\xc0\x9aR\xd9\xb2\x9d\xcf`\x92" +
	"\xc5MM25|5\xc1\x99(\x9e\xbc\xbbJ\xfe]" +
	"\x17GcH,\x83J\xc3eSN\xd3:-{\x99" +
	"V\xac\x12=h\x0a\x1a.\x8d\xf5S\xeb\x91$\xe6\x1d" +
	"*\x0a\xc2\x11\xbf \\H\x05\xa1Y\x15\x19\x10$'" +
	"\xe2\xbf\xc1\x14\xa0\xa9\xff\x8a\xcbx\xe96\xe9\xe86)" +
	",RE-\xf6\xab\xa8\x0c\x9bA#\xf1\xa6A\xb6\x9e" +
	"\xc7\xd7\xeb\x0eUR\xb4{J\x84\\\x92<\x9e\xc1\x13" +
	"h\xef\xed\x91R\xf6S\xa3)\x8b\xe4O\x11\xe8%\xad" +
	"H\xca\x175+\x85\xb3EkCE\xcf\xc1cn\xc2" +
	"\x0bhK\x89\xbcDB\xf5,\x16\x96\x17\x00IW\xdf" +
	"V\xff\x0c\xd3\x0e\x93f\xf22t(\x15\xd7\xdb1\x05" +
	"m\xb7\xeeu\x90\x15~Ge4\xa2\xd0\x9d\xd6\xeb\x17" +
	"\xd1\xdb\xfc\xf4J\xc4*]\xda\x91P\xdd\xc1\x90r\x0f" +
	"\xe1\xf1\x06\x0a\xc4\xdf\x91P\xbd\x8d\x02\xb1\xe4U\x8c;" +
	"\xc9\xae\xb7H\xa8\xeee\x985\xadB\xb4|\x0d\xfa\x08" +
	"\xdf\xa0v]\x86\x01!C\xb8\xb2.\xa8\xbf.O\xd7" +
	"\xda\xa4\xdb\x90\xaa\x18\x96\x89\x9daKWw8\xabj" +
	"\xe7\xf55&HcVx\\\xd0\xc44\xf5\x9f\x88\xe9" +
	"Sd{\x0aJ\x1d\xa2n\x08&`\xca\x90\x0d\x8c\xfa" +
	"\x08\x8c\x8c\x81\x94\xa5\x1b\x80Q\x1b\x81\x91Q\x832g" +
	"\x12\x98[\xefL \xab\x19\xa6^\x08\x9d\x03\xed\xc0\x84" +
	"\x89\x88k\x91gA]\xaa\xd0\xa9s\xfem\xc6\xac\x9e" +
	"\xf5z)9:\xcd\xb9G\"\x0eX\xb0\xf2\xab\xacR" +
	"I\x07\xc9tf\x80\xbd\xe7|Tp\x00\x99\xb9\xd3/" +
	"\xe3\xb5\xfe\xb0YR\xd0\xab\xe2\x15}q\xd8+\x09\x9b" +
	"&\xa8U\"C\x8fK\xa8:\xe4\x11Wy\xc9u\xeb" +
	".\xdf#\xaeb8`\x8d\x8dU\xc2L4C\xbcp" +
	"\x0b\xfa\x98V-:\x9b 5C\xe0\x18\xd7\x0aC\xe4" +
	"\xde\x987\x9csi\xb1Tt\x82\xbc\xd8,\xa7\x88\xfe" +
	"I2\xb7\xf8\xe1\xb2\xc3u\xbdx\x19\xa9\x8a\xbc>\xb0" +
	"1bNT\xcdQ\xabJ\xbd\xddL\xc26\xd3\xa1\xa8" +
	"\xd7\x00D4`^\x89\x12\xf4k\x99iI\xa1!\x0e" +
	"n\xd2\x8aRU'I\xd7\x05\x92\xf28[\x0c\xb0\x81" +
	"Q3\xc5<\xfcw\x0aay+1r1\xe2t\x12" +
	"\x87}\xecz\xb0\xe3\xb2\xe0\xb4\x10'C\x1c\xe9#\x17" +
	"\x05\xf6\xb8\xc2z\x01r\x1d\xc49\x818\xb1\xa3\xaeg" +
	"k\xde%8\x9d\xc49\x998\xf1\x0f\x89Cm\xdb\x89" +
	"\x82\x93!N7q\x12\x1f\xd09\xd4\xb8\xcd\x11\x9c\x13" +
	"\x883\x9f8\xc9\xf7\xe97\xd4\xba\xcde\xfd\xd4\xba\x11" +
	"g!qZ\xde#N\x0b\x00_ 8\xdd\xc49\x8d" +
	"8\xad\xef\x12\xa7\x15\x80/\x12\x9c\xf9\xc4YB\x9c\xb6" +
	"w\x88\xd3\x06\xc0Og\x83\x00\xb9\x85\xc4YF\x9c\xf6" +
	"\xb7\x89\xd3\x0e\xc0\x97\x0a\xcei\xc4Y\xc1\x18\xca\x1d\x7f" +
	"tE\xb9\xc6\xcf\x10*XB\x8c\xb3\x88!\xff\x8f+" +
	"J6~\xa6`,#\xc69\xc48\xee\x88+\xd2\x0d" +
	"?[0V\x10\xe3\\:$\xf5\x96\xeb\x95\xb4|\xa5" +
	"\xe0\x9cE\x9c\xaf\xd2O:\xdftEZ\xe4C\xac\x9f" +
	"\x0f\xb1ln\x9cX\x0e\xb1\x94\xffvEr\xe4[\xd9" +
	"\x06\x80\\\x99\x18W\x10#}\xd8\x1b@\xf0\x1a\xa3&" +
	"x\x1b1\xbe\xc9\x18\xa6.\xb3\x0cr\xb1Q\xcb*\xd6" +
	"\xfd8e\x98\xce\x0ad\xc0\x90\x01f\x0d\xd3Y\xba\x1c" +
	"%`(y\xdf\xfaz1\x06\x0cc\xde\xb7\xe5\xcb0" +
	"\x0e\x0c\xe3\x80\xd9\xaa\xf8]\x82z\x16\xc0\x81\xaa\xf7C" +
	"?\x01\x88\xaf}\xbdA%X\xf5~\xea\xfb\xe1\xc4X" +
	"\xd1\xd2\x88\xdd\x06\x0c\xdb\xea\xdf\x97/\xc3v`\xd8N" +
	"p\xd5\xb7\x05\xb1#Eu.\xca\xc0P\x06\x14\xe3\x0e" +
	"L\x03\xc34`\x8a\xb2tp\xa2W4\xa91d\xee" +
	"\x91\x1b\xbe4+\xbdy\xff$\xa81\x86+3(*" +
	"j\x1cu\xbd%\x9b4H\x16\xab\xd4\x92\xfb\xfb\xb8\"" +
	"\xd5\x8eiy@\x1d\x12n=\xfb\x82\xa4\xdb\xc1\x92\xcf" +
	"[6\x81\xe84\x83)\xb5\x82\xfd~\x1d\x15-5g" +
	"7\xe9\xa7\xd76\xeb\xa7)z\xac\xf3\x02c\xa4\xb2r" +
	"\xc7\x8c\xa2N\xb5\x04e^_[\x13\x868%\x92\xe3" +
	"\x02\x19\x9a\xf6\xfa\x1bke\xfc\xe4\x10\x10\x84\xab\xc6\x08" +
	"\xe0M\xae\x9a\x04\x00ox\xd5\x04\xffr\xec\xa8\xdb\x14" +
	"\xfer\xfcC\xb7)\xfa\xe5\xc4\x07nS\xf0\xcb\xc9\xf7" +
	"\xdd\xa6\xd8\x97[\xdes\x9bB_n}\xd7m\x8a|" +
	"\xb9\xed\x1d\xb7)\xf0\xe5\xf6\xb7\xdd/\x10\xf7\x88\xe1\xa3" +
	"\x97\x80?\x93\x09\xf4\x91W\x1a\xbe@P;\xdf$j" +
	"\xf0\x16\xc2e\xd6\xcfe\x96\x05\x81w\x8c\x8cX\xf9\x1c" +
	"F\xa9?}\x98\xa8\xc1\x88\x9f\xb7\xb2\x11`Q\xa4C" +
	"B`\x1c\x12\x1e\xba\xbd\xbf}\xbd\xde\xdf\xe5\xcb \xe1" +
	"a\x19\x12>\x8a\xfd\x0f\xb4\xc2G.$\xea\x98\xad\x7f" +
	"\"\x9a\xc0)$\x04B\xfdQ\xa4\xc0\xe4\xa7cq\xc4" +
	"\xc7\xe2\xc6\x1aH\xd4\x83E!8\x05\x80\x0dYo\xc8" +
	"\x1b\xd4\xe6\x8c\xed~\xe3\xd6-\x00rq/y\xb7\xa2" +
	"\x9e\x02\x80L4k()+\xd7\x02`L9{\x03" +
	"\x00\xc6\x953G\x000\xa1\x9c1HU\xaar\xfa5" +
	"\x00Y\xbdTvj\xc9Q\xc3I\x8d\xd6\x1c\xddu." +
	"\xb7\x06k\x8e^\x01\x00w\xcc\xaa\xda\xf4\x05\xb0\xe2\xea" +
	"\xc6\x96qg\xb0F\xe2T&\xfc\xe6\xda5\xcc\xa2a" +
	"\xea\xab\xacX\xa9lU\x0cG\x9fZ5\xad\xf2\xeb\xc3" +
	"\x8aa\xa1\xd9\xd0_\xf6\x86\xa0\x17E\x8e@}\xaf\xdf" +
	"^\x0e\xfbE\x0e]j}o\x18\x0a\xb2%\xedR+" +
	"\x18\xf8dK\x86i\xd9\xf5\xd0\x9b-\x19y\xdb\xaa\x7f" +
	"k\xd6\x94\x9c/\xc2R\x8a>7\xb4q\x8b\x9b\xb4q" +
	"\xb3#}V\xb4S\x89F\x9ei\x0d\x15\xeaj\x07F" +
	"\x9f\xc5\x94\x0d\xe1\xdb\x85\xa2\x8c\x84\xb5/}\x19\x8e\xd4" +
	"\xa1\x9ep\xe7[ \x15t7\x17\xa9\x9b\xd5\x15u9" +
	"y\x0dg\x03\xe4\x1c\x940w\x15\x06\xa2\xf2+\xc5$" +
	"\xf7\x0a\"\x7fKLr\xfd\x82\xe4Z\x9c\x04\xc8}\x8b" +
	"\xe8\xb7\x10]\xf2\x86\xc7\xfc\xbbH0\xfe\x0e\xd1o\x13" +
	"\x13a\xbf\x18\xd9)\xf6\xb9\x85\xe8{\x89\x9e\xf4'\xc8" +
	"\xf7\x0a\xfa=D\x7f\x1c)\xb4\xb8~0z\x14\x09\xdd" +
	"\x0f\x11\xe3Ib\xb4\x8a\x8a<xC\xe5O`?\x7f" +
	"\x02\x09\xb1m\xa2,\x0f\xde\x15\xf9\x8bH\x08o\xff\x88" +
	"\xa8\xc1\xfb\x0b\x7f\x18\x09\xc7\x1dG\x89\x1a\xbcV\xf2{" +
	"\xb1\x17\x98,\x7fH\xd4\xe0\x05\x86\xef\xc4\x11`J," +
	"\x9e\xc1n\x00~\xb5\x18r_E\x92\xfc\x10\x19.\x8d" +
	"wc\x06\xe7\x02\xf0\xef#U\x04\xb7\x11\xe3N\x9c\x9a" +
	"6\x0aF\xa5\\\xd4j\xe7C2\xda\x87\xd6\xa9L+" +
	"\xe9\xc3\xb6>fl[\xa7\x9b[\x9cq\xa8'\xf1i" +
	"\x83;\xb3n\xb9\xe4\x94\xa6*0\xbb\x9fp>\xdbt" +
	"2E\xc9,x\xd8\xf8\x0c\xa1\xc3\xf3\x18\x00\x11q\xa2" +
	"\xf1#+z\x9e\xf0X\xc92\xc3\xc6\xe7\x13\xc7\xe0F" +
	"E$u\x030?C\x91/\xe0\xe4\x9d\x95\xd4\xf2z" +
	"}h\x91\x8a\x96\xf8\xe7\xf8C\x8b,\x80r65*" +
	"gI\xa8^\xc4p\xa2$\x1a\xad\xf0\xfc\xfa\x7f \xd4" +
	"\x13\xb3?\xff\x82T\xa5\x12\xd5g\xf0\xde>\xf3\xd4\xc1" +
	"\xbbk\xca1,S]\xe6\x89D\xc5\xdf%\xc2M/" +
	"\"\x1f(\x90_cY\xcch\xb9&\xfcz3\xd1\x8b" +
	"\x027[\xc5\x98\x96\x1bx)@n\x9c\xe8\x8e\xc0\x8d" +
	"-\x06\xaa|\xabX_&\xfa\x15\xe2\x85\xa5\"\xe6O" +
	"\xbc\x86\xd7O\xc1_\xdc\xc9\xe0,\x81?\x1b \xf7M" +
	"\xa2\xef\x108\xab\x8aA\x05\xbfA\xec\x1f\xe2/y\x99" +
	"x\x0f\xe3;\x05]\xe0\xefGDo\xb9\\\xbc\x88\xf1" +
	"\xdd\x82\xfeC\xa2\xff\x84\xe8\xad\xdb\xc4\x9b\x18\xbfK\x9c" +
	"\xfb\x13\xa2\xdfG\xf4\xb6Z\x06O\x06\xe0\xfb\xc4\xb9{" +
	"\x89\xfe\x00\xd1\xdb\xb7gp\x0e\x00\xdf/\xf6\xf99\xd1" +
	"\x1f!z\xc7_f\xf0\xff\x01\xc1\xeef\x80\xdc#D" +
	"\x7f\x1ag\x9c*\xb9\x8efo\xd1\x9d\xcajH\x1aE" +
	"=p\x0c\x9f\xba\x0aR\xe4n\x8d\xe4!HRq\xda" +
	"HE\x7f\xae\xe4\xd0\xdeSy9\xc8\x0a\xbfn\xa4\xaf" +
	"\x86\x14\xb5z\x8d\xe4\x0b e\x1a\x96\xd9H>\x0fR" +
	"Sf\xb7>y\x0d\xfa\xf8\xd0\xa7\x1f\xbc\x1e\xb2\xc21" +
	"\x1b\xe9\xc3\x90\"\xd44\x92W\xa2\x0f,\x0b\xcd\x19P" +
	"\"&\x19\x0d(Ao\x8a\xd78\xc6\x9c\xf5\x85\xcc\xeb" +
	"W\xd6E2\x1b\xa7\xb9\xd1\x12\xbbY\xb2E\x9c\x9el" +
	"\xa3\xf3\xe4\x19&\x8a\x9f\xe7\x1d\xc1\xcbi\xa95\xe6\x98" +
	"%\x9a\x82\xf0\x1f,\xb0\x7f`\xbd^\x1a\xf5F=\x9f" +
	"\xd4\x14\x8c|\x8e\xa6\xa0\xd9\xfce\xa2$\x8e\x89\x04\x95" +
	"@\x08/\xa8\xfco\x00\x00\x00\xff\xffn\xcfm\xe2"

func RegisterSchema(reg *schemas.Registry) {
	reg.Register(&schemas.Schema{
		String: schema_a93fc509624c72d9,
		Nodes: []uint64{
			0x87e739250a60ea97,
			0x8e3b5f79fe593656,
			0x903455f06065422b,
			0x9500cce23b334d80,
			0x978a7cebdc549a4d,
			0x97b14cbe7cfec712,
			0x9aad50a41f4af45f,
			0x9dd1f724f4614a85,
			0x9e0e78711a7f87a9,
			0x9ea0b19b37fb4435,
			0xa9962a9ed0a4d7f8,
			0xabd73485a9636bc9,
			0xac3a6f60ef4cc6d3,
			0xae504193122357e5,
			0xb18aa5ac7a0d9420,
			0xb54ab3364333f598,
			0xb9521bccf10fa3b1,
			0xbaefc9120c56e274,
			0xbb90d5c287870be6,
			0xbfc546f6210ad7ce,
			0xc2573fe8a23e49f1,
			0xc2ba9038898e1fa2,
			0xc42305476bb4746f,
			0xc863cd16969ee7fc,
			0xcafccddb68db1d11,
			0xce23dcd2d7b00c9b,
			0xcfea0eb02e810062,
			0xd07378ede1f9cc60,
			0xd1958f7dba521926,
			0xd85d305b7d839963,
			0xdebf55bbfa0fc242,
			0xe682ab4cf923a417,
			0xe82753cff0c2218f,
			0xec1619d4400a0290,
			0xed8bca69f7fb0cbf,
			0xf1c8950dab257542,
			0xf38e1de3041357ae,
		},
		Compressed: true,
	})
}
