// Code generated by capnpc-go. DO NOT EDIT.

package persistent

import (
	capnp "capnproto.org/go/capnp/v3"
	text "capnproto.org/go/capnp/v3/encoding/text"
	fc "capnproto.org/go/capnp/v3/flowcontrol"
	schemas "capnproto.org/go/capnp/v3/schemas"
	server "capnproto.org/go/capnp/v3/server"
	context "context"
)

const PersistentAnnotation = uint64(0xf622595091cafb67)

type Persistent capnp.Client

// Persistent_TypeID is the unique identifier for the type Persistent.
const Persistent_TypeID = 0xc8cb212fcd9f5691

func (c Persistent) Save(ctx context.Context, params func(Persistent_SaveParams) error) (Persistent_SaveResults_Future, capnp.ReleaseFunc) {

	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xc8cb212fcd9f5691,
			MethodID:      0,
			InterfaceName: "persistent.capnp:Persistent",
			MethodName:    "save",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Persistent_SaveParams(s)) }
	}

	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Persistent_SaveResults_Future{Future: ans.Future()}, release

}

func (c Persistent) WaitStreaming() error {
	return capnp.Client(c).WaitStreaming()
}

// String returns a string that identifies this capability for debugging
// purposes.  Its format should not be depended on: in particular, it
// should not be used to compare clients.  Use IsSame to compare clients
// for equality.
func (c Persistent) String() string {
	return "Persistent(" + capnp.Client(c).String() + ")"
}

// AddRef creates a new Client that refers to the same capability as c.
// If c is nil or has resolved to null, then AddRef returns nil.
func (c Persistent) AddRef() Persistent {
	return Persistent(capnp.Client(c).AddRef())
}

// Release releases a capability reference.  If this is the last
// reference to the capability, then the underlying resources associated
// with the capability will be released.
//
// Release will panic if c has already been released, but not if c is
// nil or resolved to null.
func (c Persistent) Release() {
	capnp.Client(c).Release()
}

// Resolve blocks until the capability is fully resolved or the Context
// expires.
func (c Persistent) Resolve(ctx context.Context) error {
	return capnp.Client(c).Resolve(ctx)
}

func (c Persistent) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Client(c).EncodeAsPtr(seg)
}

func (Persistent) DecodeFromPtr(p capnp.Ptr) Persistent {
	return Persistent(capnp.Client{}.DecodeFromPtr(p))
}

// IsValid reports whether c is a valid reference to a capability.
// A reference is invalid if it is nil, has resolved to null, or has
// been released.
func (c Persistent) IsValid() bool {
	return capnp.Client(c).IsValid()
}

// IsSame reports whether c and other refer to a capability created by the
// same call to NewClient.  This can return false negatives if c or other
// are not fully resolved: use Resolve if this is an issue.  If either
// c or other are released, then IsSame panics.
func (c Persistent) IsSame(other Persistent) bool {
	return capnp.Client(c).IsSame(capnp.Client(other))
}

// Update the flowcontrol.FlowLimiter used to manage flow control for
// this client. This affects all future calls, but not calls already
// waiting to send. Passing nil sets the value to flowcontrol.NopLimiter,
// which is also the default.
func (c Persistent) SetFlowLimiter(lim fc.FlowLimiter) {
	capnp.Client(c).SetFlowLimiter(lim)
}

// Get the current flowcontrol.FlowLimiter used to manage flow control
// for this client.
func (c Persistent) GetFlowLimiter() fc.FlowLimiter {
	return capnp.Client(c).GetFlowLimiter()
}

// A Persistent_Server is a Persistent with a local implementation.
type Persistent_Server interface {
	Save(context.Context, Persistent_save) error
}

// Persistent_NewServer creates a new Server from an implementation of Persistent_Server.
func Persistent_NewServer(s Persistent_Server) *server.Server {
	c, _ := s.(server.Shutdowner)
	return server.New(Persistent_Methods(nil, s), s, c)
}

// Persistent_ServerToClient creates a new Client from an implementation of Persistent_Server.
// The caller is responsible for calling Release on the returned Client.
func Persistent_ServerToClient(s Persistent_Server) Persistent {
	return Persistent(capnp.NewClient(Persistent_NewServer(s)))
}

// Persistent_Methods appends Methods to a slice that invoke the methods on s.
// This can be used to create a more complicated Server.
func Persistent_Methods(methods []server.Method, s Persistent_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 1)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xc8cb212fcd9f5691,
			MethodID:      0,
			InterfaceName: "persistent.capnp:Persistent",
			MethodName:    "save",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.Save(ctx, Persistent_save{call})
		},
	})

	return methods
}

// Persistent_save holds the state for a server call to Persistent.save.
// See server.Call for documentation.
type Persistent_save struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Persistent_save) Args() Persistent_SaveParams {
	return Persistent_SaveParams(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Persistent_save) AllocResults() (Persistent_SaveResults, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Persistent_SaveResults(r), err
}

// Persistent_List is a list of Persistent.
type Persistent_List = capnp.CapList[Persistent]

// NewPersistent creates a new list of Persistent.
func NewPersistent_List(s *capnp.Segment, sz int32) (Persistent_List, error) {
	l, err := capnp.NewPointerList(s, sz)
	return capnp.CapList[Persistent](l), err
}

type Persistent_SaveParams capnp.Struct

// Persistent_SaveParams_TypeID is the unique identifier for the type Persistent_SaveParams.
const Persistent_SaveParams_TypeID = 0xf76fba59183073a5

func NewPersistent_SaveParams(s *capnp.Segment) (Persistent_SaveParams, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Persistent_SaveParams(st), err
}

func NewRootPersistent_SaveParams(s *capnp.Segment) (Persistent_SaveParams, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Persistent_SaveParams(st), err
}

func ReadRootPersistent_SaveParams(msg *capnp.Message) (Persistent_SaveParams, error) {
	root, err := msg.Root()
	return Persistent_SaveParams(root.Struct()), err
}

func (s Persistent_SaveParams) String() string {
	str, _ := text.Marshal(0xf76fba59183073a5, capnp.Struct(s))
	return str
}

func (s Persistent_SaveParams) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Persistent_SaveParams) DecodeFromPtr(p capnp.Ptr) Persistent_SaveParams {
	return Persistent_SaveParams(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Persistent_SaveParams) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Persistent_SaveParams) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Persistent_SaveParams) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Persistent_SaveParams) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Persistent_SaveParams) SealFor() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Persistent_SaveParams) HasSealFor() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Persistent_SaveParams) SetSealFor(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}

// Persistent_SaveParams_List is a list of Persistent_SaveParams.
type Persistent_SaveParams_List = capnp.StructList[Persistent_SaveParams]

// NewPersistent_SaveParams creates a new list of Persistent_SaveParams.
func NewPersistent_SaveParams_List(s *capnp.Segment, sz int32) (Persistent_SaveParams_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Persistent_SaveParams](l), err
}

// Persistent_SaveParams_Future is a wrapper for a Persistent_SaveParams promised by a client call.
type Persistent_SaveParams_Future struct{ *capnp.Future }

func (f Persistent_SaveParams_Future) Struct() (Persistent_SaveParams, error) {
	p, err := f.Future.Ptr()
	return Persistent_SaveParams(p.Struct()), err
}
func (p Persistent_SaveParams_Future) SealFor() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Persistent_SaveResults capnp.Struct

// Persistent_SaveResults_TypeID is the unique identifier for the type Persistent_SaveResults.
const Persistent_SaveResults_TypeID = 0xb76848c18c40efbf

func NewPersistent_SaveResults(s *capnp.Segment) (Persistent_SaveResults, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Persistent_SaveResults(st), err
}

func NewRootPersistent_SaveResults(s *capnp.Segment) (Persistent_SaveResults, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Persistent_SaveResults(st), err
}

func ReadRootPersistent_SaveResults(msg *capnp.Message) (Persistent_SaveResults, error) {
	root, err := msg.Root()
	return Persistent_SaveResults(root.Struct()), err
}

func (s Persistent_SaveResults) String() string {
	str, _ := text.Marshal(0xb76848c18c40efbf, capnp.Struct(s))
	return str
}

func (s Persistent_SaveResults) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Persistent_SaveResults) DecodeFromPtr(p capnp.Ptr) Persistent_SaveResults {
	return Persistent_SaveResults(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Persistent_SaveResults) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Persistent_SaveResults) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Persistent_SaveResults) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Persistent_SaveResults) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Persistent_SaveResults) SturdyRef() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Persistent_SaveResults) HasSturdyRef() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Persistent_SaveResults) SetSturdyRef(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}

// Persistent_SaveResults_List is a list of Persistent_SaveResults.
type Persistent_SaveResults_List = capnp.StructList[Persistent_SaveResults]

// NewPersistent_SaveResults creates a new list of Persistent_SaveResults.
func NewPersistent_SaveResults_List(s *capnp.Segment, sz int32) (Persistent_SaveResults_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Persistent_SaveResults](l), err
}

// Persistent_SaveResults_Future is a wrapper for a Persistent_SaveResults promised by a client call.
type Persistent_SaveResults_Future struct{ *capnp.Future }

func (f Persistent_SaveResults_Future) Struct() (Persistent_SaveResults, error) {
	p, err := f.Future.Ptr()
	return Persistent_SaveResults(p.Struct()), err
}
func (p Persistent_SaveResults_Future) SturdyRef() *capnp.Future {
	return p.Future.Field(0, nil)
}

const schema_b8630836983feed7 = "x\xdat\x91\xbfk\x14A\x1c\xc5\xbfof\xd7\xbd\x83" +
	"\x0b\xb9\xb9\x11rE\xe0T\x10A4\xf1\x07X\xa4\xb9" +
	"\xdb\x14j\xa5;w \xc4\xca5\x8e\x1a\xb8\xcc\x1d;" +
	"\xb3\x11+I\xafE:\xad\xac\x02\xea?\xe0\x8fF\xb4" +
	"\x12%\x88\x95X\xd8\xa4\xb3Ql\xb4\x10\x19Y\xf1." +
	"K\xbc\xb4\xdf\xe1\xcd\xfb\xbc\xf7\xea_:\xc1\xc9\xa9\xf7" +
	"\x9c\x98:\x16\xee\xf3/\xbfu\xee\xbe:\x7f\xf3)\x89" +
	"Y\xf8\x8dK\x0f\xb7\xe6\x0f\xbe{C!\xa2:No" +
	"a\x11\xf23\"\"\xf9\x09m*\xbd\x0b\xc1\xfd\xc7\xaf" +
	"\xed\xfbg*\xcb\xcf\x88\xa8\x0e\xf9\x1b\xdb\xb2\xca\x8e\x10" +
	"\xc9\xc3\xec\x9c\xccY$s6\xe3o\xfcz\xbb\x91," +
	"\x1d\xfaA\x1fDx\x00%\x09d\xce\xb6\xe5:\x8b\xe4" +
	":k\xf5\x1e1\x0e\x82\xdf\xb4'\x9aK/\x06?'" +
	"\xb1<`\x0b\x90\x8fY\xc1\xb2\xc9\xdat\xc1\x0fuf" +
	"W\xac\xd3\x81qs\xcb\xe9\xd0\x0c\x17\x92\x7f\x17\xe3\xe6" +
	"z\xe9\x9a\xeej\x9b\xf7\x9d\xa5\x04P\x01\x0f\x88\x02\x10" +
	"\x89\xa9.\x91\xaaq\xa8&\x83\xb7.\xcf\xae\xdd\xeej" +
	"\xc2u4P\xf2$B\x830\xf6`\xbb=\"m\x9c" +
	"\xaa\xa0\x8c\\\xbd\\\xea\xb2z\xd5\x17\x08I\x9a\xa5\xc4" +
	"W\xad\x1f\xf1P\xd4wV\x05<$\x1aK1\x92\x09" +
	"q\x94(\xae!\x9e\x858\x1eM\xdbtM\x0b\xb4T" +
	"\xc0J`(2L:v\x90\x00q\x05\"\xec\x8a\xea" +
	")\xdf\xdbI\xd6\xbax\xcb\xe8lB\x96\xe1N\x96\xbf" +
	"\x1d\x81\xf9\xef\xf7\xe6g\x1aW\x9e\xbf\xa6\xc2 n\x02" +
	"\xb5\xc2\xee\x89\x1fU\x0b\xe3bc\x06.\x9dv+\x03" +
	"C\xc1\xf8W\xbe\xd7\x0a\xed\xa2\x83U\xbbk\x84E\"" +
	"U\xe1P\xfb\x19\xeeX\x9d\xf6\xcf\x0e24\xc2\xff\x17" +
	"\xf8\x13\x00\x00\xff\xff\x80\x98\xd3O"

func RegisterSchema(reg *schemas.Registry) {
	reg.Register(&schemas.Schema{
		String: schema_b8630836983feed7,
		Nodes: []uint64{
			0xb76848c18c40efbf,
			0xc8cb212fcd9f5691,
			0xf622595091cafb67,
			0xf76fba59183073a5,
		},
		Compressed: true,
	})
}
