// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opCancelUpdateStack = "CancelUpdateStack"

// CancelUpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the CancelUpdateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelUpdateStack for more information on using the CancelUpdateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelUpdateStackRequest method.
//    req, resp := client.CancelUpdateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack
func (c *CloudFormation) CancelUpdateStackRequest(input *CancelUpdateStackInput) (req *request.Request, output *CancelUpdateStackOutput) {
	op := &request.Operation{
		Name:       opCancelUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelUpdateStackInput{}
	}

	output = &CancelUpdateStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelUpdateStack API operation for AWS CloudFormation.
//
// Cancels an update on the specified stack. If the call completes successfully,
// the stack rolls back the update and reverts to the previous stack configuration.
//
// You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CancelUpdateStack for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//   A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack
func (c *CloudFormation) CancelUpdateStack(input *CancelUpdateStackInput) (*CancelUpdateStackOutput, error) {
	req, out := c.CancelUpdateStackRequest(input)
	return out, req.Send()
}

// CancelUpdateStackWithContext is the same as CancelUpdateStack with the addition of
// the ability to pass a context and additional request options.
//
// See CancelUpdateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CancelUpdateStackWithContext(ctx aws.Context, input *CancelUpdateStackInput, opts ...request.Option) (*CancelUpdateStackOutput, error) {
	req, out := c.CancelUpdateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opContinueUpdateRollback = "ContinueUpdateRollback"

// ContinueUpdateRollbackRequest generates a "aws/request.Request" representing the
// client's request for the ContinueUpdateRollback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ContinueUpdateRollback for more information on using the ContinueUpdateRollback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ContinueUpdateRollbackRequest method.
//    req, resp := client.ContinueUpdateRollbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback
func (c *CloudFormation) ContinueUpdateRollbackRequest(input *ContinueUpdateRollbackInput) (req *request.Request, output *ContinueUpdateRollbackOutput) {
	op := &request.Operation{
		Name:       opContinueUpdateRollback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ContinueUpdateRollbackInput{}
	}

	output = &ContinueUpdateRollbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ContinueUpdateRollback API operation for AWS CloudFormation.
//
// For a specified stack that is in the UPDATE_ROLLBACK_FAILED state, continues
// rolling it back to the UPDATE_ROLLBACK_COMPLETE state. Depending on the cause
// of the failure, you can manually  fix the error (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
// and continue the rollback. By continuing the rollback, you can return your
// stack to a working state (the UPDATE_ROLLBACK_COMPLETE state), and then try
// to update the stack again.
//
// A stack goes into the UPDATE_ROLLBACK_FAILED state when AWS CloudFormation
// cannot roll back all changes after a failed stack update. For example, you
// might have a stack that is rolling back to an old database instance that
// was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn't
// know the database was deleted, it assumes that the database instance still
// exists and attempts to roll back to it, causing the update rollback to fail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ContinueUpdateRollback for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//   A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback
func (c *CloudFormation) ContinueUpdateRollback(input *ContinueUpdateRollbackInput) (*ContinueUpdateRollbackOutput, error) {
	req, out := c.ContinueUpdateRollbackRequest(input)
	return out, req.Send()
}

// ContinueUpdateRollbackWithContext is the same as ContinueUpdateRollback with the addition of
// the ability to pass a context and additional request options.
//
// See ContinueUpdateRollback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ContinueUpdateRollbackWithContext(ctx aws.Context, input *ContinueUpdateRollbackInput, opts ...request.Option) (*ContinueUpdateRollbackOutput, error) {
	req, out := c.ContinueUpdateRollbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChangeSet = "CreateChangeSet"

// CreateChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChangeSet for more information on using the CreateChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChangeSetRequest method.
//    req, resp := client.CreateChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet
func (c *CloudFormation) CreateChangeSetRequest(input *CreateChangeSetInput) (req *request.Request, output *CreateChangeSetOutput) {
	op := &request.Operation{
		Name:       opCreateChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateChangeSetInput{}
	}

	output = &CreateChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChangeSet API operation for AWS CloudFormation.
//
// Creates a list of changes that will be applied to a stack so that you can
// review the changes before executing them. You can create a change set for
// a stack that doesn't exist or an existing stack. If you create a change set
// for a stack that doesn't exist, the change set shows all of the resources
// that AWS CloudFormation will create. If you create a change set for an existing
// stack, AWS CloudFormation compares the stack's information with the information
// that you submit in the change set and lists the differences. Use change sets
// to understand which resources AWS CloudFormation will create or change, and
// how it will change resources in an existing stack, before you create or update
// a stack.
//
// To create a change set for a stack that doesn't exist, for the ChangeSetType
// parameter, specify CREATE. To create a change set for an existing stack,
// specify UPDATE for the ChangeSetType parameter. After the CreateChangeSet
// call successfully completes, AWS CloudFormation starts creating the change
// set. To check the status of the change set or to review it, use the DescribeChangeSet
// action.
//
// When you are satisfied with the changes the change set will make, execute
// the change set by using the ExecuteChangeSet action. AWS CloudFormation doesn't
// make changes until you execute the change set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateChangeSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   The resource with the name requested already exists.
//
//   * ErrCodeInsufficientCapabilitiesException "InsufficientCapabilitiesException"
//   The template contains resources with capabilities that weren't specified
//   in the Capabilities parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The quota for the resource has already been reached.
//
//   For information on resource and stack limitations, see Limits (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//   in the AWS CloudFormation User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet
func (c *CloudFormation) CreateChangeSet(input *CreateChangeSetInput) (*CreateChangeSetOutput, error) {
	req, out := c.CreateChangeSetRequest(input)
	return out, req.Send()
}

// CreateChangeSetWithContext is the same as CreateChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CreateChangeSetWithContext(ctx aws.Context, input *CreateChangeSetInput, opts ...request.Option) (*CreateChangeSetOutput, error) {
	req, out := c.CreateChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a "aws/request.Request" representing the
// client's request for the CreateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStack for more information on using the CreateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStackRequest method.
//    req, resp := client.CreateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack
func (c *CloudFormation) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	output = &CreateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStack API operation for AWS CloudFormation.
//
// Creates a stack as specified in the template. After the call completes successfully,
// the stack creation starts. You can check the status of the stack via the
// DescribeStacks API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateStack for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The quota for the resource has already been reached.
//
//   For information on resource and stack limitations, see Limits (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//   in the AWS CloudFormation User Guide.
//
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   The resource with the name requested already exists.
//
//   * ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//   A client request token already exists.
//
//   * ErrCodeInsufficientCapabilitiesException "InsufficientCapabilitiesException"
//   The template contains resources with capabilities that weren't specified
//   in the Capabilities parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack
func (c *CloudFormation) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	return out, req.Send()
}

// CreateStackWithContext is the same as CreateStack with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CreateStackWithContext(ctx aws.Context, input *CreateStackInput, opts ...request.Option) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStackInstances = "CreateStackInstances"

// CreateStackInstancesRequest generates a "aws/request.Request" representing the
// client's request for the CreateStackInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStackInstances for more information on using the CreateStackInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStackInstancesRequest method.
//    req, resp := client.CreateStackInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances
func (c *CloudFormation) CreateStackInstancesRequest(input *CreateStackInstancesInput) (req *request.Request, output *CreateStackInstancesOutput) {
	op := &request.Operation{
		Name:       opCreateStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInstancesInput{}
	}

	output = &CreateStackInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStackInstances API operation for AWS CloudFormation.
//
// Creates stack instances for the specified accounts, within the specified
// regions. A stack instance refers to a stack in a specific account and region.
// Accounts and Regions are required parameters—you must specify at least one
// account and one region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateStackInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
//   * ErrCodeOperationInProgressException "OperationInProgressException"
//   Another operation is currently in progress for this stack set. Only one operation
//   can be performed for a stack set at a given time.
//
//   * ErrCodeOperationIdAlreadyExistsException "OperationIdAlreadyExistsException"
//   The specified operation ID already exists.
//
//   * ErrCodeStaleRequestException "StaleRequestException"
//   Another operation has been performed on this stack set since the specified
//   operation was performed.
//
//   * ErrCodeInvalidOperationException "InvalidOperationException"
//   The specified operation isn't valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The quota for the resource has already been reached.
//
//   For information on resource and stack limitations, see Limits (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//   in the AWS CloudFormation User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances
func (c *CloudFormation) CreateStackInstances(input *CreateStackInstancesInput) (*CreateStackInstancesOutput, error) {
	req, out := c.CreateStackInstancesRequest(input)
	return out, req.Send()
}

// CreateStackInstancesWithContext is the same as CreateStackInstances with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStackInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CreateStackInstancesWithContext(ctx aws.Context, input *CreateStackInstancesInput, opts ...request.Option) (*CreateStackInstancesOutput, error) {
	req, out := c.CreateStackInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStackSet = "CreateStackSet"

// CreateStackSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateStackSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStackSet for more information on using the CreateStackSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStackSetRequest method.
//    req, resp := client.CreateStackSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet
func (c *CloudFormation) CreateStackSetRequest(input *CreateStackSetInput) (req *request.Request, output *CreateStackSetOutput) {
	op := &request.Operation{
		Name:       opCreateStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackSetInput{}
	}

	output = &CreateStackSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStackSet API operation for AWS CloudFormation.
//
// Creates a stack set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateStackSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNameAlreadyExistsException "NameAlreadyExistsException"
//   The specified name is already in use.
//
//   * ErrCodeCreatedButModifiedException "CreatedButModifiedException"
//   The specified resource exists, but has been changed.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The quota for the resource has already been reached.
//
//   For information on resource and stack limitations, see Limits (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//   in the AWS CloudFormation User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet
func (c *CloudFormation) CreateStackSet(input *CreateStackSetInput) (*CreateStackSetOutput, error) {
	req, out := c.CreateStackSetRequest(input)
	return out, req.Send()
}

// CreateStackSetWithContext is the same as CreateStackSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStackSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CreateStackSetWithContext(ctx aws.Context, input *CreateStackSetInput, opts ...request.Option) (*CreateStackSetOutput, error) {
	req, out := c.CreateStackSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChangeSet = "DeleteChangeSet"

// DeleteChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChangeSet for more information on using the DeleteChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChangeSetRequest method.
//    req, resp := client.DeleteChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet
func (c *CloudFormation) DeleteChangeSetRequest(input *DeleteChangeSetInput) (req *request.Request, output *DeleteChangeSetOutput) {
	op := &request.Operation{
		Name:       opDeleteChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteChangeSetInput{}
	}

	output = &DeleteChangeSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChangeSet API operation for AWS CloudFormation.
//
// Deletes the specified change set. Deleting change sets ensures that no one
// executes the wrong change set.
//
// If the call successfully completes, AWS CloudFormation successfully deleted
// the change set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteChangeSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidChangeSetStatusException "InvalidChangeSetStatus"
//   The specified change set can't be used to update the stack. For example,
//   the change set status might be CREATE_IN_PROGRESS, or the stack status might
//   be UPDATE_IN_PROGRESS.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet
func (c *CloudFormation) DeleteChangeSet(input *DeleteChangeSetInput) (*DeleteChangeSetOutput, error) {
	req, out := c.DeleteChangeSetRequest(input)
	return out, req.Send()
}

// DeleteChangeSetWithContext is the same as DeleteChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeleteChangeSetWithContext(ctx aws.Context, input *DeleteChangeSetInput, opts ...request.Option) (*DeleteChangeSetOutput, error) {
	req, out := c.DeleteChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStack for more information on using the DeleteStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStackRequest method.
//    req, resp := client.DeleteStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack
func (c *CloudFormation) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	output = &DeleteStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStack API operation for AWS CloudFormation.
//
// Deletes a specified stack. Once the call completes successfully, stack deletion
// starts. Deleted stacks do not show up in the DescribeStacks API if the deletion
// has been completed successfully.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteStack for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//   A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack
func (c *CloudFormation) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	return out, req.Send()
}

// DeleteStackWithContext is the same as DeleteStack with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeleteStackWithContext(ctx aws.Context, input *DeleteStackInput, opts ...request.Option) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStackInstances = "DeleteStackInstances"

// DeleteStackInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStackInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStackInstances for more information on using the DeleteStackInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStackInstancesRequest method.
//    req, resp := client.DeleteStackInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances
func (c *CloudFormation) DeleteStackInstancesRequest(input *DeleteStackInstancesInput) (req *request.Request, output *DeleteStackInstancesOutput) {
	op := &request.Operation{
		Name:       opDeleteStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInstancesInput{}
	}

	output = &DeleteStackInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStackInstances API operation for AWS CloudFormation.
//
// Deletes stack instances for the specified accounts, in the specified regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteStackInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
//   * ErrCodeOperationInProgressException "OperationInProgressException"
//   Another operation is currently in progress for this stack set. Only one operation
//   can be performed for a stack set at a given time.
//
//   * ErrCodeOperationIdAlreadyExistsException "OperationIdAlreadyExistsException"
//   The specified operation ID already exists.
//
//   * ErrCodeStaleRequestException "StaleRequestException"
//   Another operation has been performed on this stack set since the specified
//   operation was performed.
//
//   * ErrCodeInvalidOperationException "InvalidOperationException"
//   The specified operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances
func (c *CloudFormation) DeleteStackInstances(input *DeleteStackInstancesInput) (*DeleteStackInstancesOutput, error) {
	req, out := c.DeleteStackInstancesRequest(input)
	return out, req.Send()
}

// DeleteStackInstancesWithContext is the same as DeleteStackInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStackInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeleteStackInstancesWithContext(ctx aws.Context, input *DeleteStackInstancesInput, opts ...request.Option) (*DeleteStackInstancesOutput, error) {
	req, out := c.DeleteStackInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStackSet = "DeleteStackSet"

// DeleteStackSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStackSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStackSet for more information on using the DeleteStackSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStackSetRequest method.
//    req, resp := client.DeleteStackSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet
func (c *CloudFormation) DeleteStackSetRequest(input *DeleteStackSetInput) (req *request.Request, output *DeleteStackSetOutput) {
	op := &request.Operation{
		Name:       opDeleteStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackSetInput{}
	}

	output = &DeleteStackSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStackSet API operation for AWS CloudFormation.
//
// Deletes a stack set. Before you can delete a stack set, all of its member
// stack instances must be deleted. For more information about how to do this,
// see DeleteStackInstances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteStackSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotEmptyException "StackSetNotEmptyException"
//   You can't yet delete this stack set, because it still contains one or more
//   stack instances. Delete all stack instances from the stack set before deleting
//   the stack set.
//
//   * ErrCodeOperationInProgressException "OperationInProgressException"
//   Another operation is currently in progress for this stack set. Only one operation
//   can be performed for a stack set at a given time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet
func (c *CloudFormation) DeleteStackSet(input *DeleteStackSetInput) (*DeleteStackSetOutput, error) {
	req, out := c.DeleteStackSetRequest(input)
	return out, req.Send()
}

// DeleteStackSetWithContext is the same as DeleteStackSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStackSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeleteStackSetWithContext(ctx aws.Context, input *DeleteStackSetInput, opts ...request.Option) (*DeleteStackSetOutput, error) {
	req, out := c.DeleteStackSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountLimits = "DescribeAccountLimits"

// DescribeAccountLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountLimits for more information on using the DescribeAccountLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountLimitsRequest method.
//    req, resp := client.DescribeAccountLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits
func (c *CloudFormation) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) (req *request.Request, output *DescribeAccountLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	output = &DescribeAccountLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountLimits API operation for AWS CloudFormation.
//
// Retrieves your account's AWS CloudFormation limits, such as the maximum number
// of stacks that you can create in your account. For more information about
// account limits, see AWS CloudFormation Limits (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
// in the AWS CloudFormation User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeAccountLimits for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits
func (c *CloudFormation) DescribeAccountLimits(input *DescribeAccountLimitsInput) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	return out, req.Send()
}

// DescribeAccountLimitsWithContext is the same as DescribeAccountLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeAccountLimitsWithContext(ctx aws.Context, input *DescribeAccountLimitsInput, opts ...request.Option) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChangeSet = "DescribeChangeSet"

// DescribeChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChangeSet for more information on using the DescribeChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChangeSetRequest method.
//    req, resp := client.DescribeChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet
func (c *CloudFormation) DescribeChangeSetRequest(input *DescribeChangeSetInput) (req *request.Request, output *DescribeChangeSetOutput) {
	op := &request.Operation{
		Name:       opDescribeChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeChangeSetInput{}
	}

	output = &DescribeChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChangeSet API operation for AWS CloudFormation.
//
// Returns the inputs for the change set and a list of changes that AWS CloudFormation
// will make if you execute the change set. For more information, see Updating
// Stacks Using Change Sets (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html)
// in the AWS CloudFormation User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeChangeSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeChangeSetNotFoundException "ChangeSetNotFound"
//   The specified change set name or ID doesn't exit. To view valid change sets
//   for a stack, use the ListChangeSets action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet
func (c *CloudFormation) DescribeChangeSet(input *DescribeChangeSetInput) (*DescribeChangeSetOutput, error) {
	req, out := c.DescribeChangeSetRequest(input)
	return out, req.Send()
}

// DescribeChangeSetWithContext is the same as DescribeChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeChangeSetWithContext(ctx aws.Context, input *DescribeChangeSetInput, opts ...request.Option) (*DescribeChangeSetOutput, error) {
	req, out := c.DescribeChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackDriftDetectionStatus = "DescribeStackDriftDetectionStatus"

// DescribeStackDriftDetectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackDriftDetectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackDriftDetectionStatus for more information on using the DescribeStackDriftDetectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackDriftDetectionStatusRequest method.
//    req, resp := client.DescribeStackDriftDetectionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus
func (c *CloudFormation) DescribeStackDriftDetectionStatusRequest(input *DescribeStackDriftDetectionStatusInput) (req *request.Request, output *DescribeStackDriftDetectionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeStackDriftDetectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackDriftDetectionStatusInput{}
	}

	output = &DescribeStackDriftDetectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackDriftDetectionStatus API operation for AWS CloudFormation.
//
// Returns information about a stack drift detection operation. A stack drift
// detection operation detects whether a stack's actual configuration differs,
// or has drifted, from it's expected configuration, as defined in the stack
// template and any values specified as template parameters. A stack is considered
// to have drifted if one or more of its resources have drifted. For more information
// on stack and resource drift, see Detecting Unregulated Configuration Changes
// to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
//
// Use DetectStackDrift to initiate a stack drift detection operation. DetectStackDrift
// returns a StackDriftDetectionId you can use to monitor the progress of the
// operation using DescribeStackDriftDetectionStatus. Once the drift detection
// operation has completed, use DescribeStackResourceDrifts to return drift
// information about the stack and its resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackDriftDetectionStatus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus
func (c *CloudFormation) DescribeStackDriftDetectionStatus(input *DescribeStackDriftDetectionStatusInput) (*DescribeStackDriftDetectionStatusOutput, error) {
	req, out := c.DescribeStackDriftDetectionStatusRequest(input)
	return out, req.Send()
}

// DescribeStackDriftDetectionStatusWithContext is the same as DescribeStackDriftDetectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackDriftDetectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackDriftDetectionStatusWithContext(ctx aws.Context, input *DescribeStackDriftDetectionStatusInput, opts ...request.Option) (*DescribeStackDriftDetectionStatusOutput, error) {
	req, out := c.DescribeStackDriftDetectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackEvents = "DescribeStackEvents"

// DescribeStackEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackEvents for more information on using the DescribeStackEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackEventsRequest method.
//    req, resp := client.DescribeStackEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents
func (c *CloudFormation) DescribeStackEventsRequest(input *DescribeStackEventsInput) (req *request.Request, output *DescribeStackEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeStackEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStackEventsInput{}
	}

	output = &DescribeStackEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackEvents API operation for AWS CloudFormation.
//
// Returns all stack related events for a specified stack in reverse chronological
// order. For more information about a stack's event history, go to Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html)
// in the AWS CloudFormation User Guide.
//
// You can list events for stacks that have failed to create or have been deleted
// by specifying the unique stack identifier (stack ID).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents
func (c *CloudFormation) DescribeStackEvents(input *DescribeStackEventsInput) (*DescribeStackEventsOutput, error) {
	req, out := c.DescribeStackEventsRequest(input)
	return out, req.Send()
}

// DescribeStackEventsWithContext is the same as DescribeStackEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackEventsWithContext(ctx aws.Context, input *DescribeStackEventsInput, opts ...request.Option) (*DescribeStackEventsOutput, error) {
	req, out := c.DescribeStackEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStackEventsPages iterates over the pages of a DescribeStackEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStackEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStackEvents operation.
//    pageNum := 0
//    err := client.DescribeStackEventsPages(params,
//        func(page *DescribeStackEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) DescribeStackEventsPages(input *DescribeStackEventsInput, fn func(*DescribeStackEventsOutput, bool) bool) error {
	return c.DescribeStackEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStackEventsPagesWithContext same as DescribeStackEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackEventsPagesWithContext(ctx aws.Context, input *DescribeStackEventsInput, fn func(*DescribeStackEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStackEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStackEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeStackEventsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeStackInstance = "DescribeStackInstance"

// DescribeStackInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackInstance for more information on using the DescribeStackInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackInstanceRequest method.
//    req, resp := client.DescribeStackInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance
func (c *CloudFormation) DescribeStackInstanceRequest(input *DescribeStackInstanceInput) (req *request.Request, output *DescribeStackInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeStackInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackInstanceInput{}
	}

	output = &DescribeStackInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackInstance API operation for AWS CloudFormation.
//
// Returns the stack instance that's associated with the specified stack set,
// AWS account, and region.
//
// For a list of stack instances that are associated with a specific stack set,
// use ListStackInstances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
//   * ErrCodeStackInstanceNotFoundException "StackInstanceNotFoundException"
//   The specified stack instance doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance
func (c *CloudFormation) DescribeStackInstance(input *DescribeStackInstanceInput) (*DescribeStackInstanceOutput, error) {
	req, out := c.DescribeStackInstanceRequest(input)
	return out, req.Send()
}

// DescribeStackInstanceWithContext is the same as DescribeStackInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackInstanceWithContext(ctx aws.Context, input *DescribeStackInstanceInput, opts ...request.Option) (*DescribeStackInstanceOutput, error) {
	req, out := c.DescribeStackInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackResource = "DescribeStackResource"

// DescribeStackResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackResource for more information on using the DescribeStackResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackResourceRequest method.
//    req, resp := client.DescribeStackResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource
func (c *CloudFormation) DescribeStackResourceRequest(input *DescribeStackResourceInput) (req *request.Request, output *DescribeStackResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourceInput{}
	}

	output = &DescribeStackResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackResource API operation for AWS CloudFormation.
//
// Returns a description of the specified resource in the specified stack.
//
// For deleted stacks, DescribeStackResource returns resource information for
// up to 90 days after the stack has been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource
func (c *CloudFormation) DescribeStackResource(input *DescribeStackResourceInput) (*DescribeStackResourceOutput, error) {
	req, out := c.DescribeStackResourceRequest(input)
	return out, req.Send()
}

// DescribeStackResourceWithContext is the same as DescribeStackResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackResourceWithContext(ctx aws.Context, input *DescribeStackResourceInput, opts ...request.Option) (*DescribeStackResourceOutput, error) {
	req, out := c.DescribeStackResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackResourceDrifts = "DescribeStackResourceDrifts"

// DescribeStackResourceDriftsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackResourceDrifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackResourceDrifts for more information on using the DescribeStackResourceDrifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackResourceDriftsRequest method.
//    req, resp := client.DescribeStackResourceDriftsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts
func (c *CloudFormation) DescribeStackResourceDriftsRequest(input *DescribeStackResourceDriftsInput) (req *request.Request, output *DescribeStackResourceDriftsOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResourceDrifts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStackResourceDriftsInput{}
	}

	output = &DescribeStackResourceDriftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackResourceDrifts API operation for AWS CloudFormation.
//
// Returns drift information for the resources that have been checked for drift
// in the specified stack. This includes actual and expected configuration values
// for resources where AWS CloudFormation detects configuration drift.
//
// For a given stack, there will be one StackResourceDrift for each stack resource
// that has been checked for drift. Resources that have not yet been checked
// for drift are not included. Resources that do not currently support drift
// detection are not checked, and so not included. For a list of resources that
// support drift detection, see Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// Use DetectStackResourceDrift to detect drift on individual resources, or
// DetectStackDrift to detect drift on all supported resources for a given stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackResourceDrifts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts
func (c *CloudFormation) DescribeStackResourceDrifts(input *DescribeStackResourceDriftsInput) (*DescribeStackResourceDriftsOutput, error) {
	req, out := c.DescribeStackResourceDriftsRequest(input)
	return out, req.Send()
}

// DescribeStackResourceDriftsWithContext is the same as DescribeStackResourceDrifts with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackResourceDrifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackResourceDriftsWithContext(ctx aws.Context, input *DescribeStackResourceDriftsInput, opts ...request.Option) (*DescribeStackResourceDriftsOutput, error) {
	req, out := c.DescribeStackResourceDriftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStackResourceDriftsPages iterates over the pages of a DescribeStackResourceDrifts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStackResourceDrifts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStackResourceDrifts operation.
//    pageNum := 0
//    err := client.DescribeStackResourceDriftsPages(params,
//        func(page *DescribeStackResourceDriftsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) DescribeStackResourceDriftsPages(input *DescribeStackResourceDriftsInput, fn func(*DescribeStackResourceDriftsOutput, bool) bool) error {
	return c.DescribeStackResourceDriftsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStackResourceDriftsPagesWithContext same as DescribeStackResourceDriftsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackResourceDriftsPagesWithContext(ctx aws.Context, input *DescribeStackResourceDriftsInput, fn func(*DescribeStackResourceDriftsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStackResourceDriftsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStackResourceDriftsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeStackResourceDriftsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeStackResources = "DescribeStackResources"

// DescribeStackResourcesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackResources for more information on using the DescribeStackResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackResourcesRequest method.
//    req, resp := client.DescribeStackResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources
func (c *CloudFormation) DescribeStackResourcesRequest(input *DescribeStackResourcesInput) (req *request.Request, output *DescribeStackResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourcesInput{}
	}

	output = &DescribeStackResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackResources API operation for AWS CloudFormation.
//
// Returns AWS resource descriptions for running and deleted stacks. If StackName
// is specified, all the associated resources that are part of the stack are
// returned. If PhysicalResourceId is specified, the associated resources of
// the stack that the resource belongs to are returned.
//
// Only the first 100 resources will be returned. If your stack has more resources
// than this, you should use ListStackResources instead.
//
// For deleted stacks, DescribeStackResources returns resource information for
// up to 90 days after the stack has been deleted.
//
// You must specify either StackName or PhysicalResourceId, but not both. In
// addition, you can specify LogicalResourceId to filter the returned result.
// For more information about resources, the LogicalResourceId and PhysicalResourceId,
// go to the AWS CloudFormation User Guide (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
//
// A ValidationError is returned if you specify both StackName and PhysicalResourceId
// in the same request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackResources for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources
func (c *CloudFormation) DescribeStackResources(input *DescribeStackResourcesInput) (*DescribeStackResourcesOutput, error) {
	req, out := c.DescribeStackResourcesRequest(input)
	return out, req.Send()
}

// DescribeStackResourcesWithContext is the same as DescribeStackResources with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackResourcesWithContext(ctx aws.Context, input *DescribeStackResourcesInput, opts ...request.Option) (*DescribeStackResourcesOutput, error) {
	req, out := c.DescribeStackResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackSet = "DescribeStackSet"

// DescribeStackSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackSet for more information on using the DescribeStackSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackSetRequest method.
//    req, resp := client.DescribeStackSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet
func (c *CloudFormation) DescribeStackSetRequest(input *DescribeStackSetInput) (req *request.Request, output *DescribeStackSetOutput) {
	op := &request.Operation{
		Name:       opDescribeStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackSetInput{}
	}

	output = &DescribeStackSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackSet API operation for AWS CloudFormation.
//
// Returns the description of the specified stack set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet
func (c *CloudFormation) DescribeStackSet(input *DescribeStackSetInput) (*DescribeStackSetOutput, error) {
	req, out := c.DescribeStackSetRequest(input)
	return out, req.Send()
}

// DescribeStackSetWithContext is the same as DescribeStackSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackSetWithContext(ctx aws.Context, input *DescribeStackSetInput, opts ...request.Option) (*DescribeStackSetOutput, error) {
	req, out := c.DescribeStackSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackSetOperation = "DescribeStackSetOperation"

// DescribeStackSetOperationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackSetOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackSetOperation for more information on using the DescribeStackSetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackSetOperationRequest method.
//    req, resp := client.DescribeStackSetOperationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation
func (c *CloudFormation) DescribeStackSetOperationRequest(input *DescribeStackSetOperationInput) (req *request.Request, output *DescribeStackSetOperationOutput) {
	op := &request.Operation{
		Name:       opDescribeStackSetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackSetOperationInput{}
	}

	output = &DescribeStackSetOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackSetOperation API operation for AWS CloudFormation.
//
// Returns the description of the specified stack set operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackSetOperation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
//   * ErrCodeOperationNotFoundException "OperationNotFoundException"
//   The specified ID refers to an operation that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation
func (c *CloudFormation) DescribeStackSetOperation(input *DescribeStackSetOperationInput) (*DescribeStackSetOperationOutput, error) {
	req, out := c.DescribeStackSetOperationRequest(input)
	return out, req.Send()
}

// DescribeStackSetOperationWithContext is the same as DescribeStackSetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackSetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackSetOperationWithContext(ctx aws.Context, input *DescribeStackSetOperationInput, opts ...request.Option) (*DescribeStackSetOperationOutput, error) {
	req, out := c.DescribeStackSetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStacks for more information on using the DescribeStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStacksRequest method.
//    req, resp := client.DescribeStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks
func (c *CloudFormation) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	output = &DescribeStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStacks API operation for AWS CloudFormation.
//
// Returns the description for the specified stack; if no stack name was specified,
// then it returns the description for all the stacks created.
//
// If the stack does not exist, an AmazonCloudFormationException is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStacks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks
func (c *CloudFormation) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	return out, req.Send()
}

// DescribeStacksWithContext is the same as DescribeStacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStacksWithContext(ctx aws.Context, input *DescribeStacksInput, opts ...request.Option) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStacksPages iterates over the pages of a DescribeStacks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStacks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStacks operation.
//    pageNum := 0
//    err := client.DescribeStacksPages(params,
//        func(page *DescribeStacksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) DescribeStacksPages(input *DescribeStacksInput, fn func(*DescribeStacksOutput, bool) bool) error {
	return c.DescribeStacksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStacksPagesWithContext same as DescribeStacksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStacksPagesWithContext(ctx aws.Context, input *DescribeStacksInput, fn func(*DescribeStacksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStacksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStacksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeStacksOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDetectStackDrift = "DetectStackDrift"

// DetectStackDriftRequest generates a "aws/request.Request" representing the
// client's request for the DetectStackDrift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectStackDrift for more information on using the DetectStackDrift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectStackDriftRequest method.
//    req, resp := client.DetectStackDriftRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift
func (c *CloudFormation) DetectStackDriftRequest(input *DetectStackDriftInput) (req *request.Request, output *DetectStackDriftOutput) {
	op := &request.Operation{
		Name:       opDetectStackDrift,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectStackDriftInput{}
	}

	output = &DetectStackDriftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectStackDrift API operation for AWS CloudFormation.
//
// Detects whether a stack's actual configuration differs, or has drifted, from
// it's expected configuration, as defined in the stack template and any values
// specified as template parameters. For each resource in the stack that supports
// drift detection, AWS CloudFormation compares the actual configuration of
// the resource with its expected template configuration. Only resource properties
// explicitly defined in the stack template are checked for drift. A stack is
// considered to have drifted if one or more of its resources differ from their
// expected template configurations. For more information, see Detecting Unregulated
// Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
//
// Use DetectStackDrift to detect drift on all supported resources for a given
// stack, or DetectStackResourceDrift to detect drift on individual resources.
//
// For a list of stack resources that currently support drift detection, see
// Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// DetectStackDrift can take up to several minutes, depending on the number
// of resources contained within the stack. Use DescribeStackDriftDetectionStatus
// to monitor the progress of a detect stack drift operation. Once the drift
// detection operation has completed, use DescribeStackResourceDrifts to return
// drift information about the stack and its resources.
//
// When detecting drift on a stack, AWS CloudFormation does not detect drift
// on any nested stacks belonging to that stack. Perform DetectStackDrift directly
// on the nested stack itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DetectStackDrift for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift
func (c *CloudFormation) DetectStackDrift(input *DetectStackDriftInput) (*DetectStackDriftOutput, error) {
	req, out := c.DetectStackDriftRequest(input)
	return out, req.Send()
}

// DetectStackDriftWithContext is the same as DetectStackDrift with the addition of
// the ability to pass a context and additional request options.
//
// See DetectStackDrift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DetectStackDriftWithContext(ctx aws.Context, input *DetectStackDriftInput, opts ...request.Option) (*DetectStackDriftOutput, error) {
	req, out := c.DetectStackDriftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectStackResourceDrift = "DetectStackResourceDrift"

// DetectStackResourceDriftRequest generates a "aws/request.Request" representing the
// client's request for the DetectStackResourceDrift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectStackResourceDrift for more information on using the DetectStackResourceDrift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectStackResourceDriftRequest method.
//    req, resp := client.DetectStackResourceDriftRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift
func (c *CloudFormation) DetectStackResourceDriftRequest(input *DetectStackResourceDriftInput) (req *request.Request, output *DetectStackResourceDriftOutput) {
	op := &request.Operation{
		Name:       opDetectStackResourceDrift,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectStackResourceDriftInput{}
	}

	output = &DetectStackResourceDriftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectStackResourceDrift API operation for AWS CloudFormation.
//
// Returns information about whether a resource's actual configuration differs,
// or has drifted, from it's expected configuration, as defined in the stack
// template and any values specified as template parameters. This information
// includes actual and expected property values for resources in which AWS CloudFormation
// detects drift. Only resource properties explicitly defined in the stack template
// are checked for drift. For more information about stack and resource drift,
// see Detecting Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
//
// Use DetectStackResourceDrift to detect drift on individual resources, or
// DetectStackDrift to detect drift on all resources in a given stack that support
// drift detection.
//
// Resources that do not currently support drift detection cannot be checked.
// For a list of resources that support drift detection, see Resources that
// Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DetectStackResourceDrift for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift
func (c *CloudFormation) DetectStackResourceDrift(input *DetectStackResourceDriftInput) (*DetectStackResourceDriftOutput, error) {
	req, out := c.DetectStackResourceDriftRequest(input)
	return out, req.Send()
}

// DetectStackResourceDriftWithContext is the same as DetectStackResourceDrift with the addition of
// the ability to pass a context and additional request options.
//
// See DetectStackResourceDrift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DetectStackResourceDriftWithContext(ctx aws.Context, input *DetectStackResourceDriftInput, opts ...request.Option) (*DetectStackResourceDriftOutput, error) {
	req, out := c.DetectStackResourceDriftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEstimateTemplateCost = "EstimateTemplateCost"

// EstimateTemplateCostRequest generates a "aws/request.Request" representing the
// client's request for the EstimateTemplateCost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EstimateTemplateCost for more information on using the EstimateTemplateCost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EstimateTemplateCostRequest method.
//    req, resp := client.EstimateTemplateCostRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost
func (c *CloudFormation) EstimateTemplateCostRequest(input *EstimateTemplateCostInput) (req *request.Request, output *EstimateTemplateCostOutput) {
	op := &request.Operation{
		Name:       opEstimateTemplateCost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EstimateTemplateCostInput{}
	}

	output = &EstimateTemplateCostOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EstimateTemplateCost API operation for AWS CloudFormation.
//
// Returns the estimated monthly cost of a template. The return value is an
// AWS Simple Monthly Calculator URL with a query string that describes the
// resources required to run the template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation EstimateTemplateCost for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost
func (c *CloudFormation) EstimateTemplateCost(input *EstimateTemplateCostInput) (*EstimateTemplateCostOutput, error) {
	req, out := c.EstimateTemplateCostRequest(input)
	return out, req.Send()
}

// EstimateTemplateCostWithContext is the same as EstimateTemplateCost with the addition of
// the ability to pass a context and additional request options.
//
// See EstimateTemplateCost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) EstimateTemplateCostWithContext(ctx aws.Context, input *EstimateTemplateCostInput, opts ...request.Option) (*EstimateTemplateCostOutput, error) {
	req, out := c.EstimateTemplateCostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteChangeSet = "ExecuteChangeSet"

// ExecuteChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteChangeSet for more information on using the ExecuteChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExecuteChangeSetRequest method.
//    req, resp := client.ExecuteChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet
func (c *CloudFormation) ExecuteChangeSetRequest(input *ExecuteChangeSetInput) (req *request.Request, output *ExecuteChangeSetOutput) {
	op := &request.Operation{
		Name:       opExecuteChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecuteChangeSetInput{}
	}

	output = &ExecuteChangeSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ExecuteChangeSet API operation for AWS CloudFormation.
//
// Updates a stack using the input information that was provided when the specified
// change set was created. After the call successfully completes, AWS CloudFormation
// starts updating the stack. Use the DescribeStacks action to view the status
// of the update.
//
// When you execute a change set, AWS CloudFormation deletes all other change
// sets associated with the stack because they aren't valid for the updated
// stack.
//
// If a stack policy is associated with the stack, AWS CloudFormation enforces
// the policy during the update. You can't specify a temporary stack policy
// that overrides the current policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ExecuteChangeSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidChangeSetStatusException "InvalidChangeSetStatus"
//   The specified change set can't be used to update the stack. For example,
//   the change set status might be CREATE_IN_PROGRESS, or the stack status might
//   be UPDATE_IN_PROGRESS.
//
//   * ErrCodeChangeSetNotFoundException "ChangeSetNotFound"
//   The specified change set name or ID doesn't exit. To view valid change sets
//   for a stack, use the ListChangeSets action.
//
//   * ErrCodeInsufficientCapabilitiesException "InsufficientCapabilitiesException"
//   The template contains resources with capabilities that weren't specified
//   in the Capabilities parameter.
//
//   * ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//   A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet
func (c *CloudFormation) ExecuteChangeSet(input *ExecuteChangeSetInput) (*ExecuteChangeSetOutput, error) {
	req, out := c.ExecuteChangeSetRequest(input)
	return out, req.Send()
}

// ExecuteChangeSetWithContext is the same as ExecuteChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ExecuteChangeSetWithContext(ctx aws.Context, input *ExecuteChangeSetInput, opts ...request.Option) (*ExecuteChangeSetOutput, error) {
	req, out := c.ExecuteChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStackPolicy = "GetStackPolicy"

// GetStackPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetStackPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStackPolicy for more information on using the GetStackPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStackPolicyRequest method.
//    req, resp := client.GetStackPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy
func (c *CloudFormation) GetStackPolicyRequest(input *GetStackPolicyInput) (req *request.Request, output *GetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opGetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStackPolicyInput{}
	}

	output = &GetStackPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStackPolicy API operation for AWS CloudFormation.
//
// Returns the stack policy for a specified stack. If a stack doesn't have a
// policy, a null value is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetStackPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy
func (c *CloudFormation) GetStackPolicy(input *GetStackPolicyInput) (*GetStackPolicyOutput, error) {
	req, out := c.GetStackPolicyRequest(input)
	return out, req.Send()
}

// GetStackPolicyWithContext is the same as GetStackPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetStackPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) GetStackPolicyWithContext(ctx aws.Context, input *GetStackPolicyInput, opts ...request.Option) (*GetStackPolicyOutput, error) {
	req, out := c.GetStackPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplate for more information on using the GetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTemplateRequest method.
//    req, resp := client.GetTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate
func (c *CloudFormation) GetTemplateRequest(input *GetTemplateInput) (req *request.Request, output *GetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	output = &GetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplate API operation for AWS CloudFormation.
//
// Returns the template body for a specified stack. You can get the template
// for running or deleted stacks.
//
// For deleted stacks, GetTemplate returns the template for up to 90 days after
// the stack has been deleted.
//
// If the template does not exist, a ValidationError is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeChangeSetNotFoundException "ChangeSetNotFound"
//   The specified change set name or ID doesn't exit. To view valid change sets
//   for a stack, use the ListChangeSets action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate
func (c *CloudFormation) GetTemplate(input *GetTemplateInput) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	return out, req.Send()
}

// GetTemplateWithContext is the same as GetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) GetTemplateWithContext(ctx aws.Context, input *GetTemplateInput, opts ...request.Option) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplateSummary = "GetTemplateSummary"

// GetTemplateSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplateSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplateSummary for more information on using the GetTemplateSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTemplateSummaryRequest method.
//    req, resp := client.GetTemplateSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary
func (c *CloudFormation) GetTemplateSummaryRequest(input *GetTemplateSummaryInput) (req *request.Request, output *GetTemplateSummaryOutput) {
	op := &request.Operation{
		Name:       opGetTemplateSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateSummaryInput{}
	}

	output = &GetTemplateSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplateSummary API operation for AWS CloudFormation.
//
// Returns information about a new or existing template. The GetTemplateSummary
// action is useful for viewing parameter information, such as default parameter
// values and parameter types, before you create or update a stack or stack
// set.
//
// You can use the GetTemplateSummary action when you submit a template, or
// you can get template information for a stack set, or a running or deleted
// stack.
//
// For deleted stacks, GetTemplateSummary returns the template information for
// up to 90 days after the stack has been deleted. If the template does not
// exist, a ValidationError is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetTemplateSummary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary
func (c *CloudFormation) GetTemplateSummary(input *GetTemplateSummaryInput) (*GetTemplateSummaryOutput, error) {
	req, out := c.GetTemplateSummaryRequest(input)
	return out, req.Send()
}

// GetTemplateSummaryWithContext is the same as GetTemplateSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplateSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) GetTemplateSummaryWithContext(ctx aws.Context, input *GetTemplateSummaryInput, opts ...request.Option) (*GetTemplateSummaryOutput, error) {
	req, out := c.GetTemplateSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChangeSets = "ListChangeSets"

// ListChangeSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListChangeSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChangeSets for more information on using the ListChangeSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChangeSetsRequest method.
//    req, resp := client.ListChangeSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets
func (c *CloudFormation) ListChangeSetsRequest(input *ListChangeSetsInput) (req *request.Request, output *ListChangeSetsOutput) {
	op := &request.Operation{
		Name:       opListChangeSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListChangeSetsInput{}
	}

	output = &ListChangeSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChangeSets API operation for AWS CloudFormation.
//
// Returns the ID and status of each active change set for a stack. For example,
// AWS CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or
// CREATE_PENDING state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListChangeSets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets
func (c *CloudFormation) ListChangeSets(input *ListChangeSetsInput) (*ListChangeSetsOutput, error) {
	req, out := c.ListChangeSetsRequest(input)
	return out, req.Send()
}

// ListChangeSetsWithContext is the same as ListChangeSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListChangeSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListChangeSetsWithContext(ctx aws.Context, input *ListChangeSetsInput, opts ...request.Option) (*ListChangeSetsOutput, error) {
	req, out := c.ListChangeSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListExports = "ListExports"

// ListExportsRequest generates a "aws/request.Request" representing the
// client's request for the ListExports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExports for more information on using the ListExports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListExportsRequest method.
//    req, resp := client.ListExportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports
func (c *CloudFormation) ListExportsRequest(input *ListExportsInput) (req *request.Request, output *ListExportsOutput) {
	op := &request.Operation{
		Name:       opListExports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExportsInput{}
	}

	output = &ListExportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExports API operation for AWS CloudFormation.
//
// Lists all exported output values in the account and region in which you call
// this action. Use this action to see the exported output values that you can
// import into other stacks. To import values, use the Fn::ImportValue (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
// function.
//
// For more information, see  AWS CloudFormation Export Stack Output Values
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListExports for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports
func (c *CloudFormation) ListExports(input *ListExportsInput) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	return out, req.Send()
}

// ListExportsWithContext is the same as ListExports with the addition of
// the ability to pass a context and additional request options.
//
// See ListExports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListExportsWithContext(ctx aws.Context, input *ListExportsInput, opts ...request.Option) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExportsPages iterates over the pages of a ListExports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExports operation.
//    pageNum := 0
//    err := client.ListExportsPages(params,
//        func(page *ListExportsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) ListExportsPages(input *ListExportsInput, fn func(*ListExportsOutput, bool) bool) error {
	return c.ListExportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExportsPagesWithContext same as ListExportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListExportsPagesWithContext(ctx aws.Context, input *ListExportsInput, fn func(*ListExportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListExportsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListImports = "ListImports"

// ListImportsRequest generates a "aws/request.Request" representing the
// client's request for the ListImports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImports for more information on using the ListImports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListImportsRequest method.
//    req, resp := client.ListImportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports
func (c *CloudFormation) ListImportsRequest(input *ListImportsInput) (req *request.Request, output *ListImportsOutput) {
	op := &request.Operation{
		Name:       opListImports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImportsInput{}
	}

	output = &ListImportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImports API operation for AWS CloudFormation.
//
// Lists all stacks that are importing an exported output value. To modify or
// remove an exported output value, first use this action to see which stacks
// are using it. To see the exported output values in your account, see ListExports.
//
// For more information about importing an exported output value, see the Fn::ImportValue
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
// function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListImports for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports
func (c *CloudFormation) ListImports(input *ListImportsInput) (*ListImportsOutput, error) {
	req, out := c.ListImportsRequest(input)
	return out, req.Send()
}

// ListImportsWithContext is the same as ListImports with the addition of
// the ability to pass a context and additional request options.
//
// See ListImports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListImportsWithContext(ctx aws.Context, input *ListImportsInput, opts ...request.Option) (*ListImportsOutput, error) {
	req, out := c.ListImportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImportsPages iterates over the pages of a ListImports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListImports operation.
//    pageNum := 0
//    err := client.ListImportsPages(params,
//        func(page *ListImportsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) ListImportsPages(input *ListImportsInput, fn func(*ListImportsOutput, bool) bool) error {
	return c.ListImportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImportsPagesWithContext same as ListImportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListImportsPagesWithContext(ctx aws.Context, input *ListImportsInput, fn func(*ListImportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListImportsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListStackInstances = "ListStackInstances"

// ListStackInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListStackInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackInstances for more information on using the ListStackInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStackInstancesRequest method.
//    req, resp := client.ListStackInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances
func (c *CloudFormation) ListStackInstancesRequest(input *ListStackInstancesInput) (req *request.Request, output *ListStackInstancesOutput) {
	op := &request.Operation{
		Name:       opListStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackInstancesInput{}
	}

	output = &ListStackInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackInstances API operation for AWS CloudFormation.
//
// Returns summary information about stack instances that are associated with
// the specified stack set. You can filter for stack instances that are associated
// with a specific AWS account name or region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances
func (c *CloudFormation) ListStackInstances(input *ListStackInstancesInput) (*ListStackInstancesOutput, error) {
	req, out := c.ListStackInstancesRequest(input)
	return out, req.Send()
}

// ListStackInstancesWithContext is the same as ListStackInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackInstancesWithContext(ctx aws.Context, input *ListStackInstancesInput, opts ...request.Option) (*ListStackInstancesOutput, error) {
	req, out := c.ListStackInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStackResources = "ListStackResources"

// ListStackResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListStackResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackResources for more information on using the ListStackResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStackResourcesRequest method.
//    req, resp := client.ListStackResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources
func (c *CloudFormation) ListStackResourcesRequest(input *ListStackResourcesInput) (req *request.Request, output *ListStackResourcesOutput) {
	op := &request.Operation{
		Name:       opListStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackResourcesInput{}
	}

	output = &ListStackResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackResources API operation for AWS CloudFormation.
//
// Returns descriptions of all resources of the specified stack.
//
// For deleted stacks, ListStackResources returns resource information for up
// to 90 days after the stack has been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackResources for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources
func (c *CloudFormation) ListStackResources(input *ListStackResourcesInput) (*ListStackResourcesOutput, error) {
	req, out := c.ListStackResourcesRequest(input)
	return out, req.Send()
}

// ListStackResourcesWithContext is the same as ListStackResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackResourcesWithContext(ctx aws.Context, input *ListStackResourcesInput, opts ...request.Option) (*ListStackResourcesOutput, error) {
	req, out := c.ListStackResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStackResourcesPages iterates over the pages of a ListStackResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStackResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStackResources operation.
//    pageNum := 0
//    err := client.ListStackResourcesPages(params,
//        func(page *ListStackResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) ListStackResourcesPages(input *ListStackResourcesInput, fn func(*ListStackResourcesOutput, bool) bool) error {
	return c.ListStackResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStackResourcesPagesWithContext same as ListStackResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackResourcesPagesWithContext(ctx aws.Context, input *ListStackResourcesInput, fn func(*ListStackResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStackResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStackResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListStackResourcesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListStackSetOperationResults = "ListStackSetOperationResults"

// ListStackSetOperationResultsRequest generates a "aws/request.Request" representing the
// client's request for the ListStackSetOperationResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackSetOperationResults for more information on using the ListStackSetOperationResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStackSetOperationResultsRequest method.
//    req, resp := client.ListStackSetOperationResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults
func (c *CloudFormation) ListStackSetOperationResultsRequest(input *ListStackSetOperationResultsInput) (req *request.Request, output *ListStackSetOperationResultsOutput) {
	op := &request.Operation{
		Name:       opListStackSetOperationResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackSetOperationResultsInput{}
	}

	output = &ListStackSetOperationResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackSetOperationResults API operation for AWS CloudFormation.
//
// Returns summary information about the results of a stack set operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackSetOperationResults for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
//   * ErrCodeOperationNotFoundException "OperationNotFoundException"
//   The specified ID refers to an operation that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults
func (c *CloudFormation) ListStackSetOperationResults(input *ListStackSetOperationResultsInput) (*ListStackSetOperationResultsOutput, error) {
	req, out := c.ListStackSetOperationResultsRequest(input)
	return out, req.Send()
}

// ListStackSetOperationResultsWithContext is the same as ListStackSetOperationResults with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackSetOperationResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetOperationResultsWithContext(ctx aws.Context, input *ListStackSetOperationResultsInput, opts ...request.Option) (*ListStackSetOperationResultsOutput, error) {
	req, out := c.ListStackSetOperationResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStackSetOperations = "ListStackSetOperations"

// ListStackSetOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListStackSetOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackSetOperations for more information on using the ListStackSetOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStackSetOperationsRequest method.
//    req, resp := client.ListStackSetOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations
func (c *CloudFormation) ListStackSetOperationsRequest(input *ListStackSetOperationsInput) (req *request.Request, output *ListStackSetOperationsOutput) {
	op := &request.Operation{
		Name:       opListStackSetOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackSetOperationsInput{}
	}

	output = &ListStackSetOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackSetOperations API operation for AWS CloudFormation.
//
// Returns summary information about operations performed on a stack set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackSetOperations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations
func (c *CloudFormation) ListStackSetOperations(input *ListStackSetOperationsInput) (*ListStackSetOperationsOutput, error) {
	req, out := c.ListStackSetOperationsRequest(input)
	return out, req.Send()
}

// ListStackSetOperationsWithContext is the same as ListStackSetOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackSetOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetOperationsWithContext(ctx aws.Context, input *ListStackSetOperationsInput, opts ...request.Option) (*ListStackSetOperationsOutput, error) {
	req, out := c.ListStackSetOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStackSets = "ListStackSets"

// ListStackSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListStackSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackSets for more information on using the ListStackSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStackSetsRequest method.
//    req, resp := client.ListStackSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets
func (c *CloudFormation) ListStackSetsRequest(input *ListStackSetsInput) (req *request.Request, output *ListStackSetsOutput) {
	op := &request.Operation{
		Name:       opListStackSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackSetsInput{}
	}

	output = &ListStackSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackSets API operation for AWS CloudFormation.
//
// Returns summary information about stack sets that are associated with the
// user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackSets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets
func (c *CloudFormation) ListStackSets(input *ListStackSetsInput) (*ListStackSetsOutput, error) {
	req, out := c.ListStackSetsRequest(input)
	return out, req.Send()
}

// ListStackSetsWithContext is the same as ListStackSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetsWithContext(ctx aws.Context, input *ListStackSetsInput, opts ...request.Option) (*ListStackSetsOutput, error) {
	req, out := c.ListStackSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStacks = "ListStacks"

// ListStacksRequest generates a "aws/request.Request" representing the
// client's request for the ListStacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStacks for more information on using the ListStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStacksRequest method.
//    req, resp := client.ListStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks
func (c *CloudFormation) ListStacksRequest(input *ListStacksInput) (req *request.Request, output *ListStacksOutput) {
	op := &request.Operation{
		Name:       opListStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStacksInput{}
	}

	output = &ListStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStacks API operation for AWS CloudFormation.
//
// Returns the summary information for stacks whose status matches the specified
// StackStatusFilter. Summary information for stacks that have been deleted
// is kept for 90 days after the stack is deleted. If no StackStatusFilter is
// specified, summary information for all stacks is returned (including existing
// stacks and stacks that have been deleted).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStacks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks
func (c *CloudFormation) ListStacks(input *ListStacksInput) (*ListStacksOutput, error) {
	req, out := c.ListStacksRequest(input)
	return out, req.Send()
}

// ListStacksWithContext is the same as ListStacks with the addition of
// the ability to pass a context and additional request options.
//
// See ListStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStacksWithContext(ctx aws.Context, input *ListStacksInput, opts ...request.Option) (*ListStacksOutput, error) {
	req, out := c.ListStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStacksPages iterates over the pages of a ListStacks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStacks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStacks operation.
//    pageNum := 0
//    err := client.ListStacksPages(params,
//        func(page *ListStacksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) ListStacksPages(input *ListStacksInput, fn func(*ListStacksOutput, bool) bool) error {
	return c.ListStacksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStacksPagesWithContext same as ListStacksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStacksPagesWithContext(ctx aws.Context, input *ListStacksInput, fn func(*ListStacksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStacksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStacksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListStacksOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSetStackPolicy = "SetStackPolicy"

// SetStackPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SetStackPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetStackPolicy for more information on using the SetStackPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetStackPolicyRequest method.
//    req, resp := client.SetStackPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy
func (c *CloudFormation) SetStackPolicyRequest(input *SetStackPolicyInput) (req *request.Request, output *SetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opSetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetStackPolicyInput{}
	}

	output = &SetStackPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetStackPolicy API operation for AWS CloudFormation.
//
// Sets a stack policy for a specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation SetStackPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy
func (c *CloudFormation) SetStackPolicy(input *SetStackPolicyInput) (*SetStackPolicyOutput, error) {
	req, out := c.SetStackPolicyRequest(input)
	return out, req.Send()
}

// SetStackPolicyWithContext is the same as SetStackPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See SetStackPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) SetStackPolicyWithContext(ctx aws.Context, input *SetStackPolicyInput, opts ...request.Option) (*SetStackPolicyOutput, error) {
	req, out := c.SetStackPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSignalResource = "SignalResource"

// SignalResourceRequest generates a "aws/request.Request" representing the
// client's request for the SignalResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SignalResource for more information on using the SignalResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SignalResourceRequest method.
//    req, resp := client.SignalResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource
func (c *CloudFormation) SignalResourceRequest(input *SignalResourceInput) (req *request.Request, output *SignalResourceOutput) {
	op := &request.Operation{
		Name:       opSignalResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalResourceInput{}
	}

	output = &SignalResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SignalResource API operation for AWS CloudFormation.
//
// Sends a signal to the specified resource with a success or failure status.
// You can use the SignalResource API in conjunction with a creation policy
// or update policy. AWS CloudFormation doesn't proceed with a stack creation
// or update until resources receive the required number of signals or the timeout
// period is exceeded. The SignalResource API is useful in cases where you want
// to send signals from anywhere other than an Amazon EC2 instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation SignalResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource
func (c *CloudFormation) SignalResource(input *SignalResourceInput) (*SignalResourceOutput, error) {
	req, out := c.SignalResourceRequest(input)
	return out, req.Send()
}

// SignalResourceWithContext is the same as SignalResource with the addition of
// the ability to pass a context and additional request options.
//
// See SignalResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) SignalResourceWithContext(ctx aws.Context, input *SignalResourceInput, opts ...request.Option) (*SignalResourceOutput, error) {
	req, out := c.SignalResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopStackSetOperation = "StopStackSetOperation"

// StopStackSetOperationRequest generates a "aws/request.Request" representing the
// client's request for the StopStackSetOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopStackSetOperation for more information on using the StopStackSetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopStackSetOperationRequest method.
//    req, resp := client.StopStackSetOperationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation
func (c *CloudFormation) StopStackSetOperationRequest(input *StopStackSetOperationInput) (req *request.Request, output *StopStackSetOperationOutput) {
	op := &request.Operation{
		Name:       opStopStackSetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStackSetOperationInput{}
	}

	output = &StopStackSetOperationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopStackSetOperation API operation for AWS CloudFormation.
//
// Stops an in-progress operation on a stack set and its associated stack instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation StopStackSetOperation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
//   * ErrCodeOperationNotFoundException "OperationNotFoundException"
//   The specified ID refers to an operation that doesn't exist.
//
//   * ErrCodeInvalidOperationException "InvalidOperationException"
//   The specified operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation
func (c *CloudFormation) StopStackSetOperation(input *StopStackSetOperationInput) (*StopStackSetOperationOutput, error) {
	req, out := c.StopStackSetOperationRequest(input)
	return out, req.Send()
}

// StopStackSetOperationWithContext is the same as StopStackSetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See StopStackSetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) StopStackSetOperationWithContext(ctx aws.Context, input *StopStackSetOperationInput, opts ...request.Option) (*StopStackSetOperationOutput, error) {
	req, out := c.StopStackSetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStack for more information on using the UpdateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStackRequest method.
//    req, resp := client.UpdateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack
func (c *CloudFormation) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	output = &UpdateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStack API operation for AWS CloudFormation.
//
// Updates a stack as specified in the template. After the call completes successfully,
// the stack update starts. You can check the status of the stack via the DescribeStacks
// action.
//
// To get a copy of the template for an existing stack, you can use the GetTemplate
// action.
//
// For more information about creating an update template, updating a stack,
// and monitoring the progress of the update, see Updating a Stack (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateStack for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientCapabilitiesException "InsufficientCapabilitiesException"
//   The template contains resources with capabilities that weren't specified
//   in the Capabilities parameter.
//
//   * ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//   A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack
func (c *CloudFormation) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	return out, req.Send()
}

// UpdateStackWithContext is the same as UpdateStack with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) UpdateStackWithContext(ctx aws.Context, input *UpdateStackInput, opts ...request.Option) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStackInstances = "UpdateStackInstances"

// UpdateStackInstancesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStackInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStackInstances for more information on using the UpdateStackInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStackInstancesRequest method.
//    req, resp := client.UpdateStackInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances
func (c *CloudFormation) UpdateStackInstancesRequest(input *UpdateStackInstancesInput) (req *request.Request, output *UpdateStackInstancesOutput) {
	op := &request.Operation{
		Name:       opUpdateStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInstancesInput{}
	}

	output = &UpdateStackInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStackInstances API operation for AWS CloudFormation.
//
// Updates the parameter values for stack instances for the specified accounts,
// within the specified regions. A stack instance refers to a stack in a specific
// account and region.
//
// You can only update stack instances in regions and accounts where they already
// exist; to create additional stack instances, use CreateStackInstances (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html).
//
// During stack set updates, any parameters overridden for a stack instance
// are not updated, but retain their overridden value.
//
// You can only update the parameter values that are specified in the stack
// set; to add or delete a parameter itself, use UpdateStackSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
// to update the stack set template. If you add a parameter to a template, before
// you can override the parameter value specified in the stack set you must
// first use UpdateStackSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
// to update all stack instances with the updated template and parameter value
// specified in the stack set. Once a stack instance has been updated with the
// new parameter, you can then override the parameter value using UpdateStackInstances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateStackInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
//   * ErrCodeStackInstanceNotFoundException "StackInstanceNotFoundException"
//   The specified stack instance doesn't exist.
//
//   * ErrCodeOperationInProgressException "OperationInProgressException"
//   Another operation is currently in progress for this stack set. Only one operation
//   can be performed for a stack set at a given time.
//
//   * ErrCodeOperationIdAlreadyExistsException "OperationIdAlreadyExistsException"
//   The specified operation ID already exists.
//
//   * ErrCodeStaleRequestException "StaleRequestException"
//   Another operation has been performed on this stack set since the specified
//   operation was performed.
//
//   * ErrCodeInvalidOperationException "InvalidOperationException"
//   The specified operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances
func (c *CloudFormation) UpdateStackInstances(input *UpdateStackInstancesInput) (*UpdateStackInstancesOutput, error) {
	req, out := c.UpdateStackInstancesRequest(input)
	return out, req.Send()
}

// UpdateStackInstancesWithContext is the same as UpdateStackInstances with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStackInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) UpdateStackInstancesWithContext(ctx aws.Context, input *UpdateStackInstancesInput, opts ...request.Option) (*UpdateStackInstancesOutput, error) {
	req, out := c.UpdateStackInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStackSet = "UpdateStackSet"

// UpdateStackSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStackSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStackSet for more information on using the UpdateStackSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStackSetRequest method.
//    req, resp := client.UpdateStackSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet
func (c *CloudFormation) UpdateStackSetRequest(input *UpdateStackSetInput) (req *request.Request, output *UpdateStackSetOutput) {
	op := &request.Operation{
		Name:       opUpdateStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackSetInput{}
	}

	output = &UpdateStackSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStackSet API operation for AWS CloudFormation.
//
// Updates the stack set, and associated stack instances in the specified accounts
// and regions.
//
// Even if the stack set operation created by updating the stack set fails (completely
// or partially, below or above a specified failure tolerance), the stack set
// is updated with your changes. Subsequent CreateStackInstances calls on the
// specified stack set use the updated stack set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateStackSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//   The specified stack set doesn't exist.
//
//   * ErrCodeOperationInProgressException "OperationInProgressException"
//   Another operation is currently in progress for this stack set. Only one operation
//   can be performed for a stack set at a given time.
//
//   * ErrCodeOperationIdAlreadyExistsException "OperationIdAlreadyExistsException"
//   The specified operation ID already exists.
//
//   * ErrCodeStaleRequestException "StaleRequestException"
//   Another operation has been performed on this stack set since the specified
//   operation was performed.
//
//   * ErrCodeInvalidOperationException "InvalidOperationException"
//   The specified operation isn't valid.
//
//   * ErrCodeStackInstanceNotFoundException "StackInstanceNotFoundException"
//   The specified stack instance doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet
func (c *CloudFormation) UpdateStackSet(input *UpdateStackSetInput) (*UpdateStackSetOutput, error) {
	req, out := c.UpdateStackSetRequest(input)
	return out, req.Send()
}

// UpdateStackSetWithContext is the same as UpdateStackSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStackSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) UpdateStackSetWithContext(ctx aws.Context, input *UpdateStackSetInput, opts ...request.Option) (*UpdateStackSetOutput, error) {
	req, out := c.UpdateStackSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTerminationProtection = "UpdateTerminationProtection"

// UpdateTerminationProtectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTerminationProtection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTerminationProtection for more information on using the UpdateTerminationProtection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTerminationProtectionRequest method.
//    req, resp := client.UpdateTerminationProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection
func (c *CloudFormation) UpdateTerminationProtectionRequest(input *UpdateTerminationProtectionInput) (req *request.Request, output *UpdateTerminationProtectionOutput) {
	op := &request.Operation{
		Name:       opUpdateTerminationProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTerminationProtectionInput{}
	}

	output = &UpdateTerminationProtectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTerminationProtection API operation for AWS CloudFormation.
//
// Updates termination protection for the specified stack. If a user attempts
// to delete a stack with termination protection enabled, the operation fails
// and the stack remains unchanged. For more information, see Protecting a Stack
// From Being Deleted (AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
// in the AWS CloudFormation User Guide.
//
// For nested stacks (AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
// termination protection is set on the root stack and cannot be changed directly
// on the nested stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateTerminationProtection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection
func (c *CloudFormation) UpdateTerminationProtection(input *UpdateTerminationProtectionInput) (*UpdateTerminationProtectionOutput, error) {
	req, out := c.UpdateTerminationProtectionRequest(input)
	return out, req.Send()
}

// UpdateTerminationProtectionWithContext is the same as UpdateTerminationProtection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTerminationProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) UpdateTerminationProtectionWithContext(ctx aws.Context, input *UpdateTerminationProtectionInput, opts ...request.Option) (*UpdateTerminationProtectionOutput, error) {
	req, out := c.UpdateTerminationProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateTemplate = "ValidateTemplate"

// ValidateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the ValidateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateTemplate for more information on using the ValidateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ValidateTemplateRequest method.
//    req, resp := client.ValidateTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate
func (c *CloudFormation) ValidateTemplateRequest(input *ValidateTemplateInput) (req *request.Request, output *ValidateTemplateOutput) {
	op := &request.Operation{
		Name:       opValidateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateTemplateInput{}
	}

	output = &ValidateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateTemplate API operation for AWS CloudFormation.
//
// Validates a specified template. AWS CloudFormation first checks if the template
// is valid JSON. If it isn't, AWS CloudFormation checks if the template is
// valid YAML. If both these checks fail, AWS CloudFormation returns a template
// validation error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ValidateTemplate for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate
func (c *CloudFormation) ValidateTemplate(input *ValidateTemplateInput) (*ValidateTemplateOutput, error) {
	req, out := c.ValidateTemplateRequest(input)
	return out, req.Send()
}

// ValidateTemplateWithContext is the same as ValidateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ValidateTemplateWithContext(ctx aws.Context, input *ValidateTemplateInput, opts ...request.Option) (*ValidateTemplateOutput, error) {
	req, out := c.ValidateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Structure that contains the results of the account gate function which AWS
// CloudFormation invokes, if present, before proceeding with a stack set operation
// in an account and region.
//
// For each account and region, AWS CloudFormation lets you specify a Lamdba
// function that encapsulates any requirements that must be met before CloudFormation
// can proceed with a stack set operation in that account and region. CloudFormation
// invokes the function each time a stack set operation is requested for that
// account and region; if the function returns FAILED, CloudFormation cancels
// the operation in that account and region, and sets the stack set operation
// result status for that account and region to FAILED.
//
// For more information, see Configuring a target account gate (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-account-gating.html).
type AccountGateResult struct {
	_ struct{} `type:"structure"`

	// The status of the account gate function.
	//
	//    * SUCCEEDED: The account gate function has determined that the account
	//    and region passes any requirements for a stack set operation to occur.
	//    AWS CloudFormation proceeds with the stack operation in that account and
	//    region.
	//
	//    * FAILED: The account gate function has determined that the account and
	//    region does not meet the requirements for a stack set operation to occur.
	//    AWS CloudFormation cancels the stack set operation in that account and
	//    region, and sets the stack set operation result status for that account
	//    and region to FAILED.
	//
	//    * SKIPPED: AWS CloudFormation has skipped calling the account gate function
	//    for this account and region, for one of the following reasons:
	//
	// An account gate function has not been specified for the account and region.
	//    AWS CloudFormation proceeds with the stack set operation in this account
	//    and region.
	//
	// The AWSCloudFormationStackSetExecutionRole of the stack set adminstration
	//    account lacks permissions to invoke the function. AWS CloudFormation proceeds
	//    with the stack set operation in this account and region.
	//
	// Either no action is necessary, or no action is possible, on the stack. AWS
	//    CloudFormation skips the stack set operation in this account and region.
	Status *string `type:"string" enum:"AccountGateStatus"`

	// The reason for the account gate status assigned to this account and region
	// for the stack set operation.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s AccountGateResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountGateResult) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AccountGateResult) SetStatus(v string) *AccountGateResult {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *AccountGateResult) SetStatusReason(v string) *AccountGateResult {
	s.StatusReason = &v
	return s
}

// The AccountLimit data type. For more information about account limits, see
// AWS CloudFormation Limits (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
// in the AWS CloudFormation User Guide.
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The name of the account limit.
	Name *string `type:"string"`

	// The value that is associated with the account limit name.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLimit) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AccountLimit) SetName(v string) *AccountLimit {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AccountLimit) SetValue(v int64) *AccountLimit {
	s.Value = &v
	return s
}

// The input for the CancelUpdateStack action.
type CancelUpdateStackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this CancelUpdateStack request. Specify this token
	// if you plan to retry requests so that AWS CloudFormation knows that you're
	// not attempting to cancel an update on a stack with the same name. You might
	// retry CancelUpdateStack requests to ensure that AWS CloudFormation successfully
	// received them.
	ClientRequestToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelUpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelUpdateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelUpdateStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CancelUpdateStackInput) SetClientRequestToken(v string) *CancelUpdateStackInput {
	s.ClientRequestToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CancelUpdateStackInput) SetStackName(v string) *CancelUpdateStackInput {
	s.StackName = &v
	return s
}

type CancelUpdateStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelUpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackOutput) GoString() string {
	return s.String()
}

// The Change structure describes the changes AWS CloudFormation will perform
// if you execute the change set.
type Change struct {
	_ struct{} `type:"structure"`

	// A ResourceChange structure that describes the resource and action that AWS
	// CloudFormation will perform.
	ResourceChange *ResourceChange `type:"structure"`

	// The type of entity that AWS CloudFormation changes. Currently, the only entity
	// type is Resource.
	Type *string `type:"string" enum:"ChangeType"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Change) GoString() string {
	return s.String()
}

// SetResourceChange sets the ResourceChange field's value.
func (s *Change) SetResourceChange(v *ResourceChange) *Change {
	s.ResourceChange = v
	return s
}

// SetType sets the Type field's value.
func (s *Change) SetType(v string) *Change {
	s.Type = &v
	return s
}

// The ChangeSetSummary structure describes a change set, its status, and the
// stack with which it's associated.
type ChangeSetSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The name of the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time `type:"timestamp"`

	// Descriptive information about the change set.
	Description *string `min:"1" type:"string"`

	// If the change set execution status is AVAILABLE, you can execute the change
	// set. If you can’t execute the change set, the status indicates why. For example,
	// a change set might be in an UNAVAILABLE state because AWS CloudFormation
	// is still creating it or in an OBSOLETE state because the stack was already
	// updated.
	ExecutionStatus *string `type:"string" enum:"ExecutionStatus"`

	// The ID of the stack with which the change set is associated.
	StackId *string `type:"string"`

	// The name of the stack with which the change set is associated.
	StackName *string `type:"string"`

	// The state of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE,
	// or FAILED.
	Status *string `type:"string" enum:"ChangeSetStatus"`

	// A description of the change set's status. For example, if your change set
	// is in the FAILED state, AWS CloudFormation shows the error message.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s ChangeSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeSetSummary) GoString() string {
	return s.String()
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *ChangeSetSummary) SetChangeSetId(v string) *ChangeSetSummary {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *ChangeSetSummary) SetChangeSetName(v string) *ChangeSetSummary {
	s.ChangeSetName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ChangeSetSummary) SetCreationTime(v time.Time) *ChangeSetSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ChangeSetSummary) SetDescription(v string) *ChangeSetSummary {
	s.Description = &v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *ChangeSetSummary) SetExecutionStatus(v string) *ChangeSetSummary {
	s.ExecutionStatus = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *ChangeSetSummary) SetStackId(v string) *ChangeSetSummary {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ChangeSetSummary) SetStackName(v string) *ChangeSetSummary {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeSetSummary) SetStatus(v string) *ChangeSetSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ChangeSetSummary) SetStatusReason(v string) *ChangeSetSummary {
	s.StatusReason = &v
	return s
}

// The input for the ContinueUpdateRollback action.
type ContinueUpdateRollbackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this ContinueUpdateRollback request. Specify this
	// token if you plan to retry requests so that AWS CloudFormation knows that
	// you're not attempting to continue the rollback to a stack with the same name.
	// You might retry ContinueUpdateRollback requests to ensure that AWS CloudFormation
	// successfully received them.
	ClientRequestToken *string `min:"1" type:"string"`

	// A list of the logical IDs of the resources that AWS CloudFormation skips
	// during the continue update rollback operation. You can specify only resources
	// that are in the UPDATE_FAILED state because a rollback failed. You can't
	// specify resources that are in the UPDATE_FAILED state for other reasons,
	// for example, because an update was cancelled. To check why a resource update
	// failed, use the DescribeStackResources action, and view the resource status
	// reason.
	//
	// Specify this property to skip rolling back resources that AWS CloudFormation
	// can't successfully roll back. We recommend that you  troubleshoot (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
	// resources before skipping them. AWS CloudFormation sets the status of the
	// specified resources to UPDATE_COMPLETE and continues to roll back the stack.
	// After the rollback is complete, the state of the skipped resources will be
	// inconsistent with the state of the resources in the stack template. Before
	// performing another stack update, you must update the stack or resources to
	// be consistent with each other. If you don't, subsequent stack updates might
	// fail, and the stack will become unrecoverable.
	//
	// Specify the minimum number of resources required to successfully roll back
	// your stack. For example, a failed resource update might cause dependent resources
	// to fail. In this case, it might not be necessary to skip the dependent resources.
	//
	// To skip resources that are part of nested stacks, use the following format:
	// NestedStackName.ResourceLogicalID. If you want to specify the logical ID
	// of a stack resource (Type: AWS::CloudFormation::Stack) in the ResourcesToSkip
	// list, then its corresponding embedded stack must be in one of the following
	// states: DELETE_IN_PROGRESS, DELETE_COMPLETE, or DELETE_FAILED.
	//
	// Don't confuse a child stack's name with its corresponding logical ID defined
	// in the parent stack. For an example of a continue update rollback operation
	// with nested stacks, see Using ResourcesToSkip to recover a nested stacks
	// hierarchy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks).
	ResourcesToSkip []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to roll back the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// always uses this role for all future operations on the stack. As long as
	// users have permission to operate on the stack, AWS CloudFormation uses this
	// role even if the users don't have permission to pass it. Ensure that the
	// role grants least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or the unique ID of the stack that you want to continue rolling
	// back.
	//
	// Don't specify the name of a nested stack (a stack that was created by using
	// the AWS::CloudFormation::Stack resource). Instead, use this operation on
	// the parent stack (the stack that contains the AWS::CloudFormation::Stack
	// resource).
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ContinueUpdateRollbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueUpdateRollbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinueUpdateRollbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContinueUpdateRollbackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *ContinueUpdateRollbackInput) SetClientRequestToken(v string) *ContinueUpdateRollbackInput {
	s.ClientRequestToken = &v
	return s
}

// SetResourcesToSkip sets the ResourcesToSkip field's value.
func (s *ContinueUpdateRollbackInput) SetResourcesToSkip(v []*string) *ContinueUpdateRollbackInput {
	s.ResourcesToSkip = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ContinueUpdateRollbackInput) SetRoleARN(v string) *ContinueUpdateRollbackInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ContinueUpdateRollbackInput) SetStackName(v string) *ContinueUpdateRollbackInput {
	s.StackName = &v
	return s
}

// The output for a ContinueUpdateRollback action.
type ContinueUpdateRollbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ContinueUpdateRollbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueUpdateRollbackOutput) GoString() string {
	return s.String()
}

// The input for the CreateChangeSet action.
type CreateChangeSetInput struct {
	_ struct{} `type:"structure"`

	// In some cases, you must explicity acknowledge that your stack template contains
	// certain capabilities in order for AWS CloudFormation to create the stack.
	//
	//    * CAPABILITY_IAM and CAPABILITY_NAMED_IAM
	//
	// Some stack templates might include resources that can affect permissions
	//    in your AWS account; for example, by creating new AWS Identity and Access
	//    Management (IAM) users. For those stacks, you must explicitly acknowledge
	//    this by specifying one of these capabilities.
	//
	// The following IAM resources require you to specify either the CAPABILITY_IAM
	//    or CAPABILITY_NAMED_IAM capability.
	//
	// If you have IAM resources, you can specify either capability.
	//
	// If you have IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.
	//
	//
	// If you don't specify either of these capabilities, AWS CloudFormation returns
	//    an InsufficientCapabilities error.
	//
	// If your stack template contains these resources, we recommend that you review
	//    all permissions associated with them and edit their permissions if necessary.
	//
	//  AWS::IAM::AccessKey (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
	//
	//  AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
	//
	//  AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
	//
	//  AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
	//
	//  AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
	//
	//  AWS::IAM::User (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
	//
	//  AWS::IAM::UserToGroupAddition (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	//    Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	//
	//    * CAPABILITY_AUTO_EXPAND
	//
	// Some template contain macros. Macros perform custom processing on templates;
	//    this can include simple actions like find-and-replace operations, all
	//    the way to extensive transformations of entire templates. Because of this,
	//    users typically create a change set from the processed template, so that
	//    they can review the changes resulting from the macros before actually
	//    creating the stack. If your stack template contains one or more macros,
	//    and you choose to create a stack directly from the processed template,
	//    without first reviewing the resulting changes in a change set, you must
	//    acknowledge this capability. This includes the AWS::Include (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
	//    and AWS::Serverless (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
	//    transforms, which are macros hosted by AWS CloudFormation.
	//
	// This capacity does not apply to creating change sets, and specifying it when
	//    creating change sets has no effect.
	//
	// Also, change sets do not currently support nested stacks. If you want to
	//    create a stack from a stack template that contains macros and nested stacks,
	//    you must create or update the stack directly from the template using the
	//    CreateStack or UpdateStack action, and specifying this capability.
	//
	// For more information on macros, see Using AWS CloudFormation Macros to Perform
	//    Custom Processing on Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
	Capabilities []*string `type:"list"`

	// The name of the change set. The name must be unique among all change sets
	// that are associated with the specified stack.
	//
	// A change set name can contain only alphanumeric, case sensitive characters
	// and hyphens. It must start with an alphabetic character and cannot exceed
	// 128 characters.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// The type of change set operation. To create a change set for a new stack,
	// specify CREATE. To create a change set for an existing stack, specify UPDATE.
	//
	// If you create a change set for a new stack, AWS Cloudformation creates a
	// stack with a unique stack ID, but no template or resources. The stack will
	// be in the REVIEW_IN_PROGRESS (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995)
	// state until you execute the change set.
	//
	// By default, AWS CloudFormation specifies UPDATE. You can't use the UPDATE
	// type to create a change set for a new stack or the CREATE type to create
	// a change set for an existing stack.
	ChangeSetType *string `type:"string" enum:"ChangeSetType"`

	// A unique identifier for this CreateChangeSet request. Specify this token
	// if you plan to retry requests so that AWS CloudFormation knows that you're
	// not attempting to create another change set with the same name. You might
	// retry CreateChangeSet requests to ensure that AWS CloudFormation successfully
	// received them.
	ClientToken *string `min:"1" type:"string"`

	// A description to help you identify this change set.
	Description *string `min:"1" type:"string"`

	// The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon
	// SNS) topics that AWS CloudFormation associates with the stack. To remove
	// all associated notification topics, specify an empty list.
	NotificationARNs []*string `type:"list"`

	// A list of Parameter structures that specify input parameters for the change
	// set. For more information, see the Parameter data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with if you
	// execute this change set, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	//
	// If the list of resource types doesn't include a resource type that you're
	// updating, the stack update fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for condition keys in IAM policies for AWS CloudFormation. For
	// more information, see Controlling Access with AWS Identity and Access Management
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html)
	// in the AWS CloudFormation User Guide.
	ResourceTypes []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes when executing the change set. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// uses this role for all future operations on the stack. As long as users have
	// permission to operate on the stack, AWS CloudFormation uses this role even
	// if the users don't have permission to pass it. Ensure that the role grants
	// least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The name or the unique ID of the stack for which you are creating a change
	// set. AWS CloudFormation generates the change set by comparing this stack's
	// information with the information that you submit, such as a modified template
	// or different parameter input values.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to resources in the stack. You can specify a maximum of 50 tags.
	Tags []*Tag `type:"list"`

	// A structure that contains the body of the revised template, with a minimum
	// length of 1 byte and a maximum length of 51,200 bytes. AWS CloudFormation
	// generates the change set by comparing this template with the template of
	// the stack that you specified.
	//
	// Conditional: You must specify only TemplateBody or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// The location of the file that contains the revised template. The URL must
	// point to a template (max size: 460,800 bytes) that is located in an S3 bucket.
	// AWS CloudFormation generates the change set by comparing this template with
	// the stack that you specified.
	//
	// Conditional: You must specify only TemplateBody or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`

	// Whether to reuse the template that is associated with the stack to create
	// the change set.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.RollbackConfiguration != nil {
		if err := s.RollbackConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RollbackConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateChangeSetInput) SetCapabilities(v []*string) *CreateChangeSetInput {
	s.Capabilities = v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *CreateChangeSetInput) SetChangeSetName(v string) *CreateChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetChangeSetType sets the ChangeSetType field's value.
func (s *CreateChangeSetInput) SetChangeSetType(v string) *CreateChangeSetInput {
	s.ChangeSetType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateChangeSetInput) SetClientToken(v string) *CreateChangeSetInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateChangeSetInput) SetDescription(v string) *CreateChangeSetInput {
	s.Description = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *CreateChangeSetInput) SetNotificationARNs(v []*string) *CreateChangeSetInput {
	s.NotificationARNs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateChangeSetInput) SetParameters(v []*Parameter) *CreateChangeSetInput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *CreateChangeSetInput) SetResourceTypes(v []*string) *CreateChangeSetInput {
	s.ResourceTypes = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateChangeSetInput) SetRoleARN(v string) *CreateChangeSetInput {
	s.RoleARN = &v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *CreateChangeSetInput) SetRollbackConfiguration(v *RollbackConfiguration) *CreateChangeSetInput {
	s.RollbackConfiguration = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateChangeSetInput) SetStackName(v string) *CreateChangeSetInput {
	s.StackName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChangeSetInput) SetTags(v []*Tag) *CreateChangeSetInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateChangeSetInput) SetTemplateBody(v string) *CreateChangeSetInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *CreateChangeSetInput) SetTemplateURL(v string) *CreateChangeSetInput {
	s.TemplateURL = &v
	return s
}

// SetUsePreviousTemplate sets the UsePreviousTemplate field's value.
func (s *CreateChangeSetInput) SetUsePreviousTemplate(v bool) *CreateChangeSetInput {
	s.UsePreviousTemplate = &v
	return s
}

// The output for the CreateChangeSet action.
type CreateChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the change set.
	Id *string `min:"1" type:"string"`

	// The unique ID of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s CreateChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChangeSetOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateChangeSetOutput) SetId(v string) *CreateChangeSetOutput {
	s.Id = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateChangeSetOutput) SetStackId(v string) *CreateChangeSetOutput {
	s.StackId = &v
	return s
}

// The input for CreateStack action.
type CreateStackInput struct {
	_ struct{} `type:"structure"`

	// In some cases, you must explicity acknowledge that your stack template contains
	// certain capabilities in order for AWS CloudFormation to create the stack.
	//
	//    * CAPABILITY_IAM and CAPABILITY_NAMED_IAM
	//
	// Some stack templates might include resources that can affect permissions
	//    in your AWS account; for example, by creating new AWS Identity and Access
	//    Management (IAM) users. For those stacks, you must explicitly acknowledge
	//    this by specifying one of these capabilities.
	//
	// The following IAM resources require you to specify either the CAPABILITY_IAM
	//    or CAPABILITY_NAMED_IAM capability.
	//
	// If you have IAM resources, you can specify either capability.
	//
	// If you have IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.
	//
	//
	// If you don't specify either of these capabilities, AWS CloudFormation returns
	//    an InsufficientCapabilities error.
	//
	// If your stack template contains these resources, we recommend that you review
	//    all permissions associated with them and edit their permissions if necessary.
	//
	//  AWS::IAM::AccessKey (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
	//
	//  AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
	//
	//  AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
	//
	//  AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
	//
	//  AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
	//
	//  AWS::IAM::User (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
	//
	//  AWS::IAM::UserToGroupAddition (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	//    Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	//
	//    * CAPABILITY_AUTO_EXPAND
	//
	// Some template contain macros. Macros perform custom processing on templates;
	//    this can include simple actions like find-and-replace operations, all
	//    the way to extensive transformations of entire templates. Because of this,
	//    users typically create a change set from the processed template, so that
	//    they can review the changes resulting from the macros before actually
	//    creating the stack. If your stack template contains one or more macros,
	//    and you choose to create a stack directly from the processed template,
	//    without first reviewing the resulting changes in a change set, you must
	//    acknowledge this capability. This includes the AWS::Include (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
	//    and AWS::Serverless (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
	//    transforms, which are macros hosted by AWS CloudFormation.
	//
	// Change sets do not currently support nested stacks. If you want to create
	//    a stack from a stack template that contains macros and nested stacks,
	//    you must create the stack directly from the template using this capability.
	//
	// You should only create stacks directly from a stack template that contains
	//    macros if you know what processing the macro performs.
	//
	// Each macro relies on an underlying Lambda service function for processing
	//    stack templates. Be aware that the Lambda function owner can update the
	//    function operation without AWS CloudFormation being notified.
	//
	// For more information, see Using AWS CloudFormation Macros to Perform Custom
	//    Processing on Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
	Capabilities []*string `type:"list"`

	// A unique identifier for this CreateStack request. Specify this token if you
	// plan to retry requests so that AWS CloudFormation knows that you're not attempting
	// to create a stack with the same name. You might retry CreateStack requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// Set to true to disable rollback of the stack if stack creation failed. You
	// can specify either DisableRollback or OnFailure, but not both.
	//
	// Default: false
	DisableRollback *bool `type:"boolean"`

	// Whether to enable termination protection on the specified stack. If a user
	// attempts to delete a stack with termination protection enabled, the operation
	// fails and the stack remains unchanged. For more information, see Protecting
	// a Stack From Being Deleted (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
	// in the AWS CloudFormation User Guide. Termination protection is disabled
	// on stacks by default.
	//
	// For nested stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
	// termination protection is set on the root stack and cannot be changed directly
	// on the nested stack.
	EnableTerminationProtection *bool `type:"boolean"`

	// The Simple Notification Service (SNS) topic ARNs to publish stack related
	// events. You can find your SNS topic ARNs using the SNS console or your Command
	// Line Interface (CLI).
	NotificationARNs []*string `type:"list"`

	// Determines what action will be taken if stack creation fails. This must be
	// one of: DO_NOTHING, ROLLBACK, or DELETE. You can specify either OnFailure
	// or DisableRollback, but not both.
	//
	// Default: ROLLBACK
	OnFailure *string `type:"string" enum:"OnFailure"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with for this
	// create stack action, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	// Use the following syntax to describe template resource types: AWS::* (for
	// all AWS resource), Custom::* (for all custom resources), Custom::logical_ID
	// (for a specific custom resource), AWS::service_name::* (for all resources
	// of a particular AWS service), and AWS::service_name::resource_logical_ID
	// (for a specific AWS resource).
	//
	// If the list of resource types doesn't include a resource that you're creating,
	// the stack creation fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for AWS CloudFormation-specific condition keys in IAM policies.
	// For more information, see Controlling Access with AWS Identity and Access
	// Management (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
	ResourceTypes []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to create the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// always uses this role for all future operations on the stack. As long as
	// users have permission to operate on the stack, AWS CloudFormation uses this
	// role even if the users don't have permission to pass it. Ensure that the
	// role grants least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The name that is associated with the stack. The name must be unique in the
	// region in which you are creating the stack.
	//
	// A stack name can contain only alphanumeric characters (case sensitive) and
	// hyphens. It must start with an alphabetic character and cannot be longer
	// than 128 characters.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (maximum size: 16 KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to the resources created in the stack. A maximum number of 50
	// tags can be specified.
	Tags []*Tag `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information, go to the Template Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`

	// The amount of time that can pass before the stack status becomes CREATE_FAILED;
	// if DisableRollback is not set or is set to false, the stack will be rolled
	// back.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyURL", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.TimeoutInMinutes != nil && *s.TimeoutInMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutes", 1))
	}
	if s.RollbackConfiguration != nil {
		if err := s.RollbackConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RollbackConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateStackInput) SetCapabilities(v []*string) *CreateStackInput {
	s.Capabilities = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateStackInput) SetClientRequestToken(v string) *CreateStackInput {
	s.ClientRequestToken = &v
	return s
}

// SetDisableRollback sets the DisableRollback field's value.
func (s *CreateStackInput) SetDisableRollback(v bool) *CreateStackInput {
	s.DisableRollback = &v
	return s
}

// SetEnableTerminationProtection sets the EnableTerminationProtection field's value.
func (s *CreateStackInput) SetEnableTerminationProtection(v bool) *CreateStackInput {
	s.EnableTerminationProtection = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *CreateStackInput) SetNotificationARNs(v []*string) *CreateStackInput {
	s.NotificationARNs = v
	return s
}

// SetOnFailure sets the OnFailure field's value.
func (s *CreateStackInput) SetOnFailure(v string) *CreateStackInput {
	s.OnFailure = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateStackInput) SetParameters(v []*Parameter) *CreateStackInput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *CreateStackInput) SetResourceTypes(v []*string) *CreateStackInput {
	s.ResourceTypes = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateStackInput) SetRoleARN(v string) *CreateStackInput {
	s.RoleARN = &v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *CreateStackInput) SetRollbackConfiguration(v *RollbackConfiguration) *CreateStackInput {
	s.RollbackConfiguration = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateStackInput) SetStackName(v string) *CreateStackInput {
	s.StackName = &v
	return s
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *CreateStackInput) SetStackPolicyBody(v string) *CreateStackInput {
	s.StackPolicyBody = &v
	return s
}

// SetStackPolicyURL sets the StackPolicyURL field's value.
func (s *CreateStackInput) SetStackPolicyURL(v string) *CreateStackInput {
	s.StackPolicyURL = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStackInput) SetTags(v []*Tag) *CreateStackInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateStackInput) SetTemplateBody(v string) *CreateStackInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *CreateStackInput) SetTemplateURL(v string) *CreateStackInput {
	s.TemplateURL = &v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *CreateStackInput) SetTimeoutInMinutes(v int64) *CreateStackInput {
	s.TimeoutInMinutes = &v
	return s
}

type CreateStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of one or more AWS accounts that you want to create stack instances
	// in the specified region(s) for.
	//
	// Accounts is a required field
	Accounts []*string `type:"list" required:"true"`

	// The unique identifier for this stack set operation.
	//
	// The operation ID also functions as an idempotency token, to ensure that AWS
	// CloudFormation performs the stack set operation only once, even if you retry
	// the request multiple times. You might retry stack set operation requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	//
	// Repeating this stack set operation with a new operation ID retries all stack
	// instances whose status is OUTDATED.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// A list of stack set parameters whose values you want to override in the selected
	// stack instances.
	//
	// Any overridden parameter values will be applied to all stack instances in
	// the specified accounts and regions. When specifying parameters and their
	// values, be aware of how AWS CloudFormation sets parameter values during stack
	// instance operations:
	//
	//    * To override the current value for a parameter, include the parameter
	//    and specify its value.
	//
	//    * To leave a parameter set to its present value, you can do one of the
	//    following:
	//
	// Do not include the parameter in the list.
	//
	// Include the parameter and specify UsePreviousValue as true. (You cannot specify
	//    both a value and set UsePreviousValue to true.)
	//
	//    * To set all overridden parameter back to the values specified in the
	//    stack set, specify a parameter list but do not include any parameters.
	//
	//    * To leave all parameters set to their present values, do not specify
	//    this property at all.
	//
	// During stack set updates, any parameter values overridden for a stack instance
	// are not updated, but retain their overridden value.
	//
	// You can only override the parameter values that are specified in the stack
	// set; to add or delete a parameter itself, use UpdateStackSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
	// to update the stack set template.
	ParameterOverrides []*Parameter `type:"list"`

	// The names of one or more regions where you want to create stack instances
	// using the specified AWS account(s).
	//
	// Regions is a required field
	Regions []*string `type:"list" required:"true"`

	// The name or unique ID of the stack set that you want to create stack instances
	// from.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackInstancesInput"}
	if s.Accounts == nil {
		invalidParams.Add(request.NewErrParamRequired("Accounts"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.Regions == nil {
		invalidParams.Add(request.NewErrParamRequired("Regions"))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *CreateStackInstancesInput) SetAccounts(v []*string) *CreateStackInstancesInput {
	s.Accounts = v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *CreateStackInstancesInput) SetOperationId(v string) *CreateStackInstancesInput {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *CreateStackInstancesInput) SetOperationPreferences(v *StackSetOperationPreferences) *CreateStackInstancesInput {
	s.OperationPreferences = v
	return s
}

// SetParameterOverrides sets the ParameterOverrides field's value.
func (s *CreateStackInstancesInput) SetParameterOverrides(v []*Parameter) *CreateStackInstancesInput {
	s.ParameterOverrides = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *CreateStackInstancesInput) SetRegions(v []*string) *CreateStackInstancesInput {
	s.Regions = v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *CreateStackInstancesInput) SetStackSetName(v string) *CreateStackInstancesInput {
	s.StackSetName = &v
	return s
}

type CreateStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInstancesOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *CreateStackInstancesOutput) SetOperationId(v string) *CreateStackInstancesOutput {
	s.OperationId = &v
	return s
}

// The output for a CreateStack action.
type CreateStackOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *CreateStackOutput) SetStackId(v string) *CreateStackOutput {
	s.StackId = &v
	return s
}

type CreateStackSetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the IAM role to use to create this stack
	// set.
	//
	// Specify an IAM role only if you are using customized administrator roles
	// to control which users or groups can manage specific stack sets within the
	// same administrator account. For more information, see Prerequisites: Granting
	// Permissions for Stack Set Operations (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// In some cases, you must explicity acknowledge that your stack set template
	// contains certain capabilities in order for AWS CloudFormation to create the
	// stack set and related stack instances.
	//
	//    * CAPABILITY_IAM and CAPABILITY_NAMED_IAM
	//
	// Some stack templates might include resources that can affect permissions
	//    in your AWS account; for example, by creating new AWS Identity and Access
	//    Management (IAM) users. For those stack sets, you must explicitly acknowledge
	//    this by specifying one of these capabilities.
	//
	// The following IAM resources require you to specify either the CAPABILITY_IAM
	//    or CAPABILITY_NAMED_IAM capability.
	//
	// If you have IAM resources, you can specify either capability.
	//
	// If you have IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.
	//
	//
	// If you don't specify either of these capabilities, AWS CloudFormation returns
	//    an InsufficientCapabilities error.
	//
	// If your stack template contains these resources, we recommend that you review
	//    all permissions associated with them and edit their permissions if necessary.
	//
	//  AWS::IAM::AccessKey (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
	//
	//  AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
	//
	//  AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
	//
	//  AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
	//
	//  AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
	//
	//  AWS::IAM::User (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
	//
	//  AWS::IAM::UserToGroupAddition (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	//    Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	//
	//    * CAPABILITY_AUTO_EXPAND
	//
	// Some templates contain macros. If your stack template contains one or more
	//    macros, and you choose to create a stack directly from the processed template,
	//    without first reviewing the resulting changes in a change set, you must
	//    acknowledge this capability. For more information, see Using AWS CloudFormation
	//    Macros to Perform Custom Processing on Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
	//
	// Stack sets do not currently support macros in stack templates. (This includes
	//    the AWS::Include (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
	//    and AWS::Serverless (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
	//    transforms, which are macros hosted by AWS CloudFormation.) Even if you
	//    specify this capability, if you include a macro in your template the stack
	//    set operation will fail.
	Capabilities []*string `type:"list"`

	// A unique identifier for this CreateStackSet request. Specify this token if
	// you plan to retry requests so that AWS CloudFormation knows that you're not
	// attempting to create another stack set with the same name. You might retry
	// CreateStackSet requests to ensure that AWS CloudFormation successfully received
	// them.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description of the stack set. You can use the description to identify the
	// stack set's purpose or other important information.
	Description *string `min:"1" type:"string"`

	// The name of the IAM execution role to use to create the stack set. If you
	// do not specify an execution role, AWS CloudFormation uses the AWSCloudFormationStackSetExecutionRole
	// role for the stack set operation.
	//
	// Specify an IAM role only if you are using customized execution roles to control
	// which stack resources users and groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// The input parameters for the stack set template.
	Parameters []*Parameter `type:"list"`

	// The name to associate with the stack set. The name must be unique in the
	// region where you create your stack set.
	//
	// A stack name can contain only alphanumeric characters (case-sensitive) and
	// hyphens. It must start with an alphabetic character and can't be longer than
	// 128 characters.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`

	// The key-value pairs to associate with this stack set and the stacks created
	// from it. AWS CloudFormation also propagates these tags to supported resources
	// that are created in the stacks. A maximum number of 50 tags can be specified.
	//
	// If you specify tags as part of a CreateStackSet action, AWS CloudFormation
	// checks to see if you have the required IAM permission to tag resources. If
	// you don't, the entire CreateStackSet action fails with an access denied error,
	// and the stack set is not created.
	Tags []*Tag `type:"list"`

	// The structure that contains the template body, with a minimum length of 1
	// byte and a maximum length of 51,200 bytes. For more information, see Template
	// Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// The location of the file that contains the template body. The URL must point
	// to a template (maximum size: 460,800 bytes) that's located in an Amazon S3
	// bucket. For more information, see Template Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackSetInput"}
	if s.AdministrationRoleARN != nil && len(*s.AdministrationRoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AdministrationRoleARN", 20))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ExecutionRoleName != nil && len(*s.ExecutionRoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleName", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdministrationRoleARN sets the AdministrationRoleARN field's value.
func (s *CreateStackSetInput) SetAdministrationRoleARN(v string) *CreateStackSetInput {
	s.AdministrationRoleARN = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateStackSetInput) SetCapabilities(v []*string) *CreateStackSetInput {
	s.Capabilities = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateStackSetInput) SetClientRequestToken(v string) *CreateStackSetInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStackSetInput) SetDescription(v string) *CreateStackSetInput {
	s.Description = &v
	return s
}

// SetExecutionRoleName sets the ExecutionRoleName field's value.
func (s *CreateStackSetInput) SetExecutionRoleName(v string) *CreateStackSetInput {
	s.ExecutionRoleName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateStackSetInput) SetParameters(v []*Parameter) *CreateStackSetInput {
	s.Parameters = v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *CreateStackSetInput) SetStackSetName(v string) *CreateStackSetInput {
	s.StackSetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStackSetInput) SetTags(v []*Tag) *CreateStackSetInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateStackSetInput) SetTemplateBody(v string) *CreateStackSetInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *CreateStackSetInput) SetTemplateURL(v string) *CreateStackSetInput {
	s.TemplateURL = &v
	return s
}

type CreateStackSetOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the stack set that you're creating.
	StackSetId *string `type:"string"`
}

// String returns the string representation
func (s CreateStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackSetOutput) GoString() string {
	return s.String()
}

// SetStackSetId sets the StackSetId field's value.
func (s *CreateStackSetOutput) SetStackSetId(v string) *CreateStackSetOutput {
	s.StackSetId = &v
	return s
}

// The input for the DeleteChangeSet action.
type DeleteChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want to
	// delete.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// If you specified the name of a change set to delete, specify the stack name
	// or ID (ARN) that is associated with it.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DeleteChangeSetInput) SetChangeSetName(v string) *DeleteChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DeleteChangeSetInput) SetStackName(v string) *DeleteChangeSetInput {
	s.StackName = &v
	return s
}

// The output for the DeleteChangeSet action.
type DeleteChangeSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChangeSetOutput) GoString() string {
	return s.String()
}

// The input for DeleteStack action.
type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this DeleteStack request. Specify this token if you
	// plan to retry requests so that AWS CloudFormation knows that you're not attempting
	// to delete a stack with the same name. You might retry DeleteStack requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// For stacks in the DELETE_FAILED state, a list of resource logical IDs that
	// are associated with the resources you want to retain. During deletion, AWS
	// CloudFormation deletes the stack but does not delete the retained resources.
	//
	// Retaining resources is useful when you cannot delete a resource, such as
	// a non-empty S3 bucket, but you want to delete the stack.
	RetainResources []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to delete the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or the unique stack ID that is associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteStackInput) SetClientRequestToken(v string) *DeleteStackInput {
	s.ClientRequestToken = &v
	return s
}

// SetRetainResources sets the RetainResources field's value.
func (s *DeleteStackInput) SetRetainResources(v []*string) *DeleteStackInput {
	s.RetainResources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *DeleteStackInput) SetRoleARN(v string) *DeleteStackInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DeleteStackInput) SetStackName(v string) *DeleteStackInput {
	s.StackName = &v
	return s
}

type DeleteStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the AWS accounts that you want to delete stack instances for.
	//
	// Accounts is a required field
	Accounts []*string `type:"list" required:"true"`

	// The unique identifier for this stack set operation.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	//
	// The operation ID also functions as an idempotency token, to ensure that AWS
	// CloudFormation performs the stack set operation only once, even if you retry
	// the request multiple times. You can retry stack set operation requests to
	// ensure that AWS CloudFormation successfully received them.
	//
	// Repeating this stack set operation with a new operation ID retries all stack
	// instances whose status is OUTDATED.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// The regions where you want to delete stack set instances.
	//
	// Regions is a required field
	Regions []*string `type:"list" required:"true"`

	// Removes the stack instances from the specified stack set, but doesn't delete
	// the stacks. You can't reassociate a retained stack or add an existing, saved
	// stack to a new stack set.
	//
	// For more information, see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
	//
	// RetainStacks is a required field
	RetainStacks *bool `type:"boolean" required:"true"`

	// The name or unique ID of the stack set that you want to delete stack instances
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackInstancesInput"}
	if s.Accounts == nil {
		invalidParams.Add(request.NewErrParamRequired("Accounts"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.Regions == nil {
		invalidParams.Add(request.NewErrParamRequired("Regions"))
	}
	if s.RetainStacks == nil {
		invalidParams.Add(request.NewErrParamRequired("RetainStacks"))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *DeleteStackInstancesInput) SetAccounts(v []*string) *DeleteStackInstancesInput {
	s.Accounts = v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *DeleteStackInstancesInput) SetOperationId(v string) *DeleteStackInstancesInput {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *DeleteStackInstancesInput) SetOperationPreferences(v *StackSetOperationPreferences) *DeleteStackInstancesInput {
	s.OperationPreferences = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *DeleteStackInstancesInput) SetRegions(v []*string) *DeleteStackInstancesInput {
	s.Regions = v
	return s
}

// SetRetainStacks sets the RetainStacks field's value.
func (s *DeleteStackInstancesInput) SetRetainStacks(v bool) *DeleteStackInstancesInput {
	s.RetainStacks = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *DeleteStackInstancesInput) SetStackSetName(v string) *DeleteStackInstancesInput {
	s.StackSetName = &v
	return s
}

type DeleteStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInstancesOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *DeleteStackInstancesOutput) SetOperationId(v string) *DeleteStackInstancesOutput {
	s.OperationId = &v
	return s
}

type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

type DeleteStackSetInput struct {
	_ struct{} `type:"structure"`

	// The name or unique ID of the stack set that you're deleting. You can obtain
	// this value by running ListStackSets.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackSetInput"}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackSetName sets the StackSetName field's value.
func (s *DeleteStackSetInput) SetStackSetName(v string) *DeleteStackSetInput {
	s.StackSetName = &v
	return s
}

type DeleteStackSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackSetOutput) GoString() string {
	return s.String()
}

// The input for the DescribeAccountLimits action.
type DescribeAccountLimitsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of limits that you want to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountLimitsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountLimitsInput) SetNextToken(v string) *DescribeAccountLimitsInput {
	s.NextToken = &v
	return s
}

// The output for the DescribeAccountLimits action.
type DescribeAccountLimitsOutput struct {
	_ struct{} `type:"structure"`

	// An account limit structure that contain a list of AWS CloudFormation account
	// limits and their values.
	AccountLimits []*AccountLimit `type:"list"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of limits. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsOutput) GoString() string {
	return s.String()
}

// SetAccountLimits sets the AccountLimits field's value.
func (s *DescribeAccountLimitsOutput) SetAccountLimits(v []*AccountLimit) *DescribeAccountLimitsOutput {
	s.AccountLimits = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountLimitsOutput) SetNextToken(v string) *DescribeAccountLimitsOutput {
	s.NextToken = &v
	return s
}

// The input for the DescribeChangeSet action.
type DescribeChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want to
	// describe.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// A string (provided by the DescribeChangeSet response output) that identifies
	// the next page of information that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// If you specified the name of a change set, specify the stack name or ID (ARN)
	// of the change set you want to describe.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetInput) SetChangeSetName(v string) *DescribeChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChangeSetInput) SetNextToken(v string) *DescribeChangeSetInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeChangeSetInput) SetStackName(v string) *DescribeChangeSetInput {
	s.StackName = &v
	return s
}

// The output for the DescribeChangeSet action.
type DescribeChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// If you execute the change set, the list of capabilities that were explicitly
	// acknowledged when the change set was created.
	Capabilities []*string `type:"list"`

	// The ARN of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The name of the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// A list of Change structures that describes the resources AWS CloudFormation
	// changes if you execute the change set.
	Changes []*Change `type:"list"`

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time `type:"timestamp"`

	// Information about the change set.
	Description *string `min:"1" type:"string"`

	// If the change set execution status is AVAILABLE, you can execute the change
	// set. If you can’t execute the change set, the status indicates why. For example,
	// a change set might be in an UNAVAILABLE state because AWS CloudFormation
	// is still creating it or in an OBSOLETE state because the stack was already
	// updated.
	ExecutionStatus *string `type:"string" enum:"ExecutionStatus"`

	// If the output exceeds 1 MB, a string that identifies the next page of changes.
	// If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`

	// The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that
	// will be associated with the stack if you execute the change set.
	NotificationARNs []*string `type:"list"`

	// A list of Parameter structures that describes the input parameters and their
	// values used to create the change set. For more information, see the Parameter
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The ARN of the stack that is associated with the change set.
	StackId *string `type:"string"`

	// The name of the stack that is associated with the change set.
	StackName *string `type:"string"`

	// The current status of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE,
	// or FAILED.
	Status *string `type:"string" enum:"ChangeSetStatus"`

	// A description of the change set's status. For example, if your attempt to
	// create a change set failed, AWS CloudFormation shows the error message.
	StatusReason *string `type:"string"`

	// If you execute the change set, the tags that will be associated with the
	// stack.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s DescribeChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChangeSetOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *DescribeChangeSetOutput) SetCapabilities(v []*string) *DescribeChangeSetOutput {
	s.Capabilities = v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *DescribeChangeSetOutput) SetChangeSetId(v string) *DescribeChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetOutput) SetChangeSetName(v string) *DescribeChangeSetOutput {
	s.ChangeSetName = &v
	return s
}

// SetChanges sets the Changes field's value.
func (s *DescribeChangeSetOutput) SetChanges(v []*Change) *DescribeChangeSetOutput {
	s.Changes = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeChangeSetOutput) SetCreationTime(v time.Time) *DescribeChangeSetOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeChangeSetOutput) SetDescription(v string) *DescribeChangeSetOutput {
	s.Description = &v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *DescribeChangeSetOutput) SetExecutionStatus(v string) *DescribeChangeSetOutput {
	s.ExecutionStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChangeSetOutput) SetNextToken(v string) *DescribeChangeSetOutput {
	s.NextToken = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *DescribeChangeSetOutput) SetNotificationARNs(v []*string) *DescribeChangeSetOutput {
	s.NotificationARNs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeChangeSetOutput) SetParameters(v []*Parameter) *DescribeChangeSetOutput {
	s.Parameters = v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *DescribeChangeSetOutput) SetRollbackConfiguration(v *RollbackConfiguration) *DescribeChangeSetOutput {
	s.RollbackConfiguration = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeChangeSetOutput) SetStackId(v string) *DescribeChangeSetOutput {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeChangeSetOutput) SetStackName(v string) *DescribeChangeSetOutput {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeChangeSetOutput) SetStatus(v string) *DescribeChangeSetOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DescribeChangeSetOutput) SetStatusReason(v string) *DescribeChangeSetOutput {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeChangeSetOutput) SetTags(v []*Tag) *DescribeChangeSetOutput {
	s.Tags = v
	return s
}

type DescribeStackDriftDetectionStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the drift detection results of this operation.
	//
	// AWS CloudFormation generates new results, with a new drift detection ID,
	// each time this operation is run. However, the number of drift results AWS
	// CloudFormation retains for any given stack, and for how long, may vary.
	//
	// StackDriftDetectionId is a required field
	StackDriftDetectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackDriftDetectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackDriftDetectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackDriftDetectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackDriftDetectionStatusInput"}
	if s.StackDriftDetectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackDriftDetectionId"))
	}
	if s.StackDriftDetectionId != nil && len(*s.StackDriftDetectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackDriftDetectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackDriftDetectionId sets the StackDriftDetectionId field's value.
func (s *DescribeStackDriftDetectionStatusInput) SetStackDriftDetectionId(v string) *DescribeStackDriftDetectionStatusInput {
	s.StackDriftDetectionId = &v
	return s
}

type DescribeStackDriftDetectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the stack drift detection operation.
	//
	//    * DETECTION_COMPLETE: The stack drift detection operation has successfully
	//    completed for all resources in the stack that support drift detection.
	//    (Resources that do not currently support stack detection remain unchecked.)
	//
	// If you specified logical resource IDs for AWS CloudFormation to use as a
	//    filter for the stack drift detection operation, only the resources with
	//    those logical IDs are checked for drift.
	//
	//    * DETECTION_FAILED: The stack drift detection operation has failed for
	//    at least one resource in the stack. Results will be available for resources
	//    on which AWS CloudFormation successfully completed drift detection.
	//
	//    * DETECTION_IN_PROGRESS: The stack drift detection operation is currently
	//    in progress.
	//
	// DetectionStatus is a required field
	DetectionStatus *string `type:"string" required:"true" enum:"StackDriftDetectionStatus"`

	// The reason the stack drift detection operation has its current status.
	DetectionStatusReason *string `type:"string"`

	// Total number of stack resources that have drifted. This is NULL until the
	// drift detection operation reaches a status of DETECTION_COMPLETE. This value
	// will be 0 for stacks whose drift status is IN_SYNC.
	DriftedStackResourceCount *int64 `type:"integer"`

	// The ID of the drift detection results of this operation.
	//
	// AWS CloudFormation generates new results, with a new drift detection ID,
	// each time this operation is run. However, the number of reports AWS CloudFormation
	// retains for any given stack, and for how long, may vary.
	//
	// StackDriftDetectionId is a required field
	StackDriftDetectionId *string `min:"1" type:"string" required:"true"`

	// Status of the stack's actual configuration compared to its expected configuration.
	//
	//    * DRIFTED: The stack differs from its expected template configuration.
	//    A stack is considered to have drifted if one or more of its resources
	//    have drifted.
	//
	//    * NOT_CHECKED: AWS CloudFormation has not checked if the stack differs
	//    from its expected template configuration.
	//
	//    * IN_SYNC: The stack's actual configuration matches its expected template
	//    configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	StackDriftStatus *string `type:"string" enum:"StackDriftStatus"`

	// The ID of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// Time at which the stack drift detection operation was initiated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s DescribeStackDriftDetectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackDriftDetectionStatusOutput) GoString() string {
	return s.String()
}

// SetDetectionStatus sets the DetectionStatus field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetDetectionStatus(v string) *DescribeStackDriftDetectionStatusOutput {
	s.DetectionStatus = &v
	return s
}

// SetDetectionStatusReason sets the DetectionStatusReason field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetDetectionStatusReason(v string) *DescribeStackDriftDetectionStatusOutput {
	s.DetectionStatusReason = &v
	return s
}

// SetDriftedStackResourceCount sets the DriftedStackResourceCount field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetDriftedStackResourceCount(v int64) *DescribeStackDriftDetectionStatusOutput {
	s.DriftedStackResourceCount = &v
	return s
}

// SetStackDriftDetectionId sets the StackDriftDetectionId field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetStackDriftDetectionId(v string) *DescribeStackDriftDetectionStatusOutput {
	s.StackDriftDetectionId = &v
	return s
}

// SetStackDriftStatus sets the StackDriftStatus field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetStackDriftStatus(v string) *DescribeStackDriftDetectionStatusOutput {
	s.StackDriftStatus = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetStackId(v string) *DescribeStackDriftDetectionStatusOutput {
	s.StackId = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetTimestamp(v time.Time) *DescribeStackDriftDetectionStatusOutput {
	s.Timestamp = &v
	return s
}

// The input for DescribeStackEvents action.
type DescribeStackEventsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of events that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStackEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackEventsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackEventsInput) SetNextToken(v string) *DescribeStackEventsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackEventsInput) SetStackName(v string) *DescribeStackEventsInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStackEvents action.
type DescribeStackEventsOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of events. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackEvents structures.
	StackEvents []*StackEvent `type:"list"`
}

// String returns the string representation
func (s DescribeStackEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackEventsOutput) SetNextToken(v string) *DescribeStackEventsOutput {
	s.NextToken = &v
	return s
}

// SetStackEvents sets the StackEvents field's value.
func (s *DescribeStackEventsOutput) SetStackEvents(v []*StackEvent) *DescribeStackEventsOutput {
	s.StackEvents = v
	return s
}

type DescribeStackInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS account that's associated with this stack instance.
	//
	// StackInstanceAccount is a required field
	StackInstanceAccount *string `type:"string" required:"true"`

	// The name of a region that's associated with this stack instance.
	//
	// StackInstanceRegion is a required field
	StackInstanceRegion *string `type:"string" required:"true"`

	// The name or the unique stack ID of the stack set that you want to get stack
	// instance information for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackInstanceInput"}
	if s.StackInstanceAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("StackInstanceAccount"))
	}
	if s.StackInstanceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("StackInstanceRegion"))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackInstanceAccount sets the StackInstanceAccount field's value.
func (s *DescribeStackInstanceInput) SetStackInstanceAccount(v string) *DescribeStackInstanceInput {
	s.StackInstanceAccount = &v
	return s
}

// SetStackInstanceRegion sets the StackInstanceRegion field's value.
func (s *DescribeStackInstanceInput) SetStackInstanceRegion(v string) *DescribeStackInstanceInput {
	s.StackInstanceRegion = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *DescribeStackInstanceInput) SetStackSetName(v string) *DescribeStackInstanceInput {
	s.StackSetName = &v
	return s
}

type DescribeStackInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The stack instance that matches the specified request parameters.
	StackInstance *StackInstance `type:"structure"`
}

// String returns the string representation
func (s DescribeStackInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackInstanceOutput) GoString() string {
	return s.String()
}

// SetStackInstance sets the StackInstance field's value.
func (s *DescribeStackInstanceOutput) SetStackInstance(v *StackInstance) *DescribeStackInstanceOutput {
	s.StackInstance = v
	return s
}

type DescribeStackResourceDriftsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string that identifies the next page of stack resource drift results.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack for which you want drift information.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The resource drift status values to use as filters for the resource drift
	// results returned.
	//
	//    * DELETED: The resource differs from its expected template configuration
	//    in that the resource has been deleted.
	//
	//    * MODIFIED: One or more resource properties differ from their expected
	//    template values.
	//
	//    * IN_SYNC: The resources's actual configuration matches its expected template
	//    configuration.
	//
	//    * NOT_CHECKED: AWS CloudFormation does not currently return this value.
	StackResourceDriftStatusFilters []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeStackResourceDriftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceDriftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackResourceDriftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackResourceDriftsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.StackResourceDriftStatusFilters != nil && len(s.StackResourceDriftStatusFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackResourceDriftStatusFilters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeStackResourceDriftsInput) SetMaxResults(v int64) *DescribeStackResourceDriftsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackResourceDriftsInput) SetNextToken(v string) *DescribeStackResourceDriftsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackResourceDriftsInput) SetStackName(v string) *DescribeStackResourceDriftsInput {
	s.StackName = &v
	return s
}

// SetStackResourceDriftStatusFilters sets the StackResourceDriftStatusFilters field's value.
func (s *DescribeStackResourceDriftsInput) SetStackResourceDriftStatusFilters(v []*string) *DescribeStackResourceDriftsInput {
	s.StackResourceDriftStatusFilters = v
	return s
}

type DescribeStackResourceDriftsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call DescribeStackResourceDrifts
	// again and assign that token to the request object's NextToken parameter.
	// If the request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// Drift information for the resources that have been checked for drift in the
	// specified stack. This includes actual and expected configuration values for
	// resources where AWS CloudFormation detects drift.
	//
	// For a given stack, there will be one StackResourceDrift for each stack resource
	// that has been checked for drift. Resources that have not yet been checked
	// for drift are not included. Resources that do not currently support drift
	// detection are not checked, and so not included. For a list of resources that
	// support drift detection, see Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//
	// StackResourceDrifts is a required field
	StackResourceDrifts []*StackResourceDrift `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeStackResourceDriftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceDriftsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackResourceDriftsOutput) SetNextToken(v string) *DescribeStackResourceDriftsOutput {
	s.NextToken = &v
	return s
}

// SetStackResourceDrifts sets the StackResourceDrifts field's value.
func (s *DescribeStackResourceDriftsOutput) SetStackResourceDrifts(v []*StackResourceDrift) *DescribeStackResourceDriftsOutput {
	s.StackResourceDrifts = v
	return s
}

// The input for DescribeStackResource action.
type DescribeStackResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackResourceInput"}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DescribeStackResourceInput) SetLogicalResourceId(v string) *DescribeStackResourceInput {
	s.LogicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackResourceInput) SetStackName(v string) *DescribeStackResourceInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStackResource action.
type DescribeStackResourceOutput struct {
	_ struct{} `type:"structure"`

	// A StackResourceDetail structure containing the description of the specified
	// resource in the specified stack.
	StackResourceDetail *StackResourceDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeStackResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceOutput) GoString() string {
	return s.String()
}

// SetStackResourceDetail sets the StackResourceDetail field's value.
func (s *DescribeStackResourceOutput) SetStackResourceDetail(v *StackResourceDetail) *DescribeStackResourceOutput {
	s.StackResourceDetail = v
	return s
}

// The input for DescribeStackResources action.
type DescribeStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	//
	// For example, for an Amazon Elastic Compute Cloud (EC2) instance, PhysicalResourceId
	// corresponds to the InstanceId. You can pass the EC2 InstanceId to DescribeStackResources
	// to find which stack the instance belongs to and what other resources are
	// part of the stack.
	//
	// Required: Conditional. If you do not specify PhysicalResourceId, you must
	// specify StackName.
	//
	// Default: There is no default value.
	PhysicalResourceId *string `type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// Required: Conditional. If you do not specify StackName, you must specify
	// PhysicalResourceId.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesInput) GoString() string {
	return s.String()
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DescribeStackResourcesInput) SetLogicalResourceId(v string) *DescribeStackResourcesInput {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *DescribeStackResourcesInput) SetPhysicalResourceId(v string) *DescribeStackResourcesInput {
	s.PhysicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackResourcesInput) SetStackName(v string) *DescribeStackResourcesInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStackResources action.
type DescribeStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of StackResource structures.
	StackResources []*StackResource `type:"list"`
}

// String returns the string representation
func (s DescribeStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesOutput) GoString() string {
	return s.String()
}

// SetStackResources sets the StackResources field's value.
func (s *DescribeStackResourcesOutput) SetStackResources(v []*StackResource) *DescribeStackResourcesOutput {
	s.StackResources = v
	return s
}

type DescribeStackSetInput struct {
	_ struct{} `type:"structure"`

	// The name or unique ID of the stack set whose description you want.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackSetInput"}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackSetName sets the StackSetName field's value.
func (s *DescribeStackSetInput) SetStackSetName(v string) *DescribeStackSetInput {
	s.StackSetName = &v
	return s
}

type DescribeStackSetOperationInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the stack set operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or the unique stack ID of the stack set for the stack operation.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackSetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackSetOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackSetOperationInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperationId sets the OperationId field's value.
func (s *DescribeStackSetOperationInput) SetOperationId(v string) *DescribeStackSetOperationInput {
	s.OperationId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *DescribeStackSetOperationInput) SetStackSetName(v string) *DescribeStackSetOperationInput {
	s.StackSetName = &v
	return s
}

type DescribeStackSetOperationOutput struct {
	_ struct{} `type:"structure"`

	// The specified stack set operation.
	StackSetOperation *StackSetOperation `type:"structure"`
}

// String returns the string representation
func (s DescribeStackSetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSetOperationOutput) GoString() string {
	return s.String()
}

// SetStackSetOperation sets the StackSetOperation field's value.
func (s *DescribeStackSetOperationOutput) SetStackSetOperation(v *StackSetOperation) *DescribeStackSetOperationOutput {
	s.StackSetOperation = v
	return s
}

type DescribeStackSetOutput struct {
	_ struct{} `type:"structure"`

	// The specified stack set.
	StackSet *StackSet `type:"structure"`
}

// String returns the string representation
func (s DescribeStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSetOutput) GoString() string {
	return s.String()
}

// SetStackSet sets the StackSet field's value.
func (s *DescribeStackSetOutput) SetStackSet(v *StackSet) *DescribeStackSetOutput {
	s.StackSet = v
	return s
}

// The input for DescribeStacks action.
type DescribeStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksInput) SetNextToken(v string) *DescribeStacksInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStacksInput) SetStackName(v string) *DescribeStacksInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStacks action.
type DescribeStacksOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of stack structures.
	Stacks []*Stack `type:"list"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksOutput) SetNextToken(v string) *DescribeStacksOutput {
	s.NextToken = &v
	return s
}

// SetStacks sets the Stacks field's value.
func (s *DescribeStacksOutput) SetStacks(v []*Stack) *DescribeStacksOutput {
	s.Stacks = v
	return s
}

type DetectStackDriftInput struct {
	_ struct{} `type:"structure"`

	// The logical names of any resources you want to use as filters.
	LogicalResourceIds []*string `min:"1" type:"list"`

	// The name of the stack for which you want to detect drift.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectStackDriftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectStackDriftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectStackDriftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectStackDriftInput"}
	if s.LogicalResourceIds != nil && len(s.LogicalResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogicalResourceIds", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceIds sets the LogicalResourceIds field's value.
func (s *DetectStackDriftInput) SetLogicalResourceIds(v []*string) *DetectStackDriftInput {
	s.LogicalResourceIds = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DetectStackDriftInput) SetStackName(v string) *DetectStackDriftInput {
	s.StackName = &v
	return s
}

type DetectStackDriftOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the drift detection results of this operation.
	//
	// AWS CloudFormation generates new results, with a new drift detection ID,
	// each time this operation is run. However, the number of drift results AWS
	// CloudFormation retains for any given stack, and for how long, may vary.
	//
	// StackDriftDetectionId is a required field
	StackDriftDetectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectStackDriftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectStackDriftOutput) GoString() string {
	return s.String()
}

// SetStackDriftDetectionId sets the StackDriftDetectionId field's value.
func (s *DetectStackDriftOutput) SetStackDriftDetectionId(v string) *DetectStackDriftOutput {
	s.StackDriftDetectionId = &v
	return s
}

type DetectStackResourceDriftInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource for which to return drift information.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name of the stack to which the resource belongs.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectStackResourceDriftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectStackResourceDriftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectStackResourceDriftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectStackResourceDriftInput"}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DetectStackResourceDriftInput) SetLogicalResourceId(v string) *DetectStackResourceDriftInput {
	s.LogicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DetectStackResourceDriftInput) SetStackName(v string) *DetectStackResourceDriftInput {
	s.StackName = &v
	return s
}

type DetectStackResourceDriftOutput struct {
	_ struct{} `type:"structure"`

	// Information about whether the resource's actual configuration has drifted
	// from its expected template configuration, including actual and expected property
	// values and any differences detected.
	//
	// StackResourceDrift is a required field
	StackResourceDrift *StackResourceDrift `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetectStackResourceDriftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectStackResourceDriftOutput) GoString() string {
	return s.String()
}

// SetStackResourceDrift sets the StackResourceDrift field's value.
func (s *DetectStackResourceDriftOutput) SetStackResourceDrift(v *StackResourceDrift) *DetectStackResourceDriftOutput {
	s.StackResourceDrift = v
	return s
}

// The input for an EstimateTemplateCost action.
type EstimateTemplateCostInput struct {
	_ struct{} `type:"structure"`

	// A list of Parameter structures that specify input parameters.
	Parameters []*Parameter `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must pass TemplateBody or TemplateURL. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// that is located in an Amazon S3 bucket. For more information, go to Template
	// Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EstimateTemplateCostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EstimateTemplateCostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EstimateTemplateCostInput"}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *EstimateTemplateCostInput) SetParameters(v []*Parameter) *EstimateTemplateCostInput {
	s.Parameters = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *EstimateTemplateCostInput) SetTemplateBody(v string) *EstimateTemplateCostInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *EstimateTemplateCostInput) SetTemplateURL(v string) *EstimateTemplateCostInput {
	s.TemplateURL = &v
	return s
}

// The output for a EstimateTemplateCost action.
type EstimateTemplateCostOutput struct {
	_ struct{} `type:"structure"`

	// An AWS Simple Monthly Calculator URL with a query string that describes the
	// resources required to run the template.
	Url *string `type:"string"`
}

// String returns the string representation
func (s EstimateTemplateCostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostOutput) GoString() string {
	return s.String()
}

// SetUrl sets the Url field's value.
func (s *EstimateTemplateCostOutput) SetUrl(v string) *EstimateTemplateCostOutput {
	s.Url = &v
	return s
}

// The input for the ExecuteChangeSet action.
type ExecuteChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the change set that you want use to update the specified
	// stack.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for this ExecuteChangeSet request. Specify this token
	// if you plan to retry requests so that AWS CloudFormation knows that you're
	// not attempting to execute a change set to update a stack with the same name.
	// You might retry ExecuteChangeSet requests to ensure that AWS CloudFormation
	// successfully received them.
	ClientRequestToken *string `min:"1" type:"string"`

	// If you specified the name of a change set, specify the stack name or ID (ARN)
	// that is associated with the change set you want to execute.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ExecuteChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *ExecuteChangeSetInput) SetChangeSetName(v string) *ExecuteChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *ExecuteChangeSetInput) SetClientRequestToken(v string) *ExecuteChangeSetInput {
	s.ClientRequestToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ExecuteChangeSetInput) SetStackName(v string) *ExecuteChangeSetInput {
	s.StackName = &v
	return s
}

// The output for the ExecuteChangeSet action.
type ExecuteChangeSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExecuteChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteChangeSetOutput) GoString() string {
	return s.String()
}

// The Export structure describes the exported output values for a stack.
type Export struct {
	_ struct{} `type:"structure"`

	// The stack that contains the exported output name and value.
	ExportingStackId *string `type:"string"`

	// The name of exported output value. Use this name and the Fn::ImportValue
	// function to import the associated value into other stacks. The name is defined
	// in the Export field in the associated stack's Outputs section.
	Name *string `type:"string"`

	// The value of the exported output, such as a resource physical ID. This value
	// is defined in the Export field in the associated stack's Outputs section.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Export) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Export) GoString() string {
	return s.String()
}

// SetExportingStackId sets the ExportingStackId field's value.
func (s *Export) SetExportingStackId(v string) *Export {
	s.ExportingStackId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Export) SetName(v string) *Export {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Export) SetValue(v string) *Export {
	s.Value = &v
	return s
}

// The input for the GetStackPolicy action.
type GetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that is associated with the stack whose policy
	// you want to get.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStackPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStackPolicyInput"}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackName sets the StackName field's value.
func (s *GetStackPolicyInput) SetStackName(v string) *GetStackPolicyInput {
	s.StackName = &v
	return s
}

// The output for the GetStackPolicy action.
type GetStackPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Structure containing the stack policy body. (For more information, go to
	//  Prevent Updates to Stack Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide.)
	StackPolicyBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyOutput) GoString() string {
	return s.String()
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *GetStackPolicyOutput) SetStackPolicyBody(v string) *GetStackPolicyOutput {
	s.StackPolicyBody = &v
	return s
}

// The input for a GetTemplate action.
type GetTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation
	// returns the associated template. If you specify a name, you must also specify
	// the StackName.
	ChangeSetName *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`

	// For templates that include transforms, the stage of the template that AWS
	// CloudFormation returns. To get the user-submitted template, specify Original.
	// To get the template after AWS CloudFormation has processed all transforms,
	// specify Processed.
	//
	// If the template doesn't include transforms, Original and Processed return
	// the same template. By default, AWS CloudFormation specifies Original.
	TemplateStage *string `type:"string" enum:"TemplateStage"`
}

// String returns the string representation
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateInput"}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *GetTemplateInput) SetChangeSetName(v string) *GetTemplateInput {
	s.ChangeSetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *GetTemplateInput) SetStackName(v string) *GetTemplateInput {
	s.StackName = &v
	return s
}

// SetTemplateStage sets the TemplateStage field's value.
func (s *GetTemplateInput) SetTemplateStage(v string) *GetTemplateInput {
	s.TemplateStage = &v
	return s
}

// The output for GetTemplate action.
type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The stage of the template that you can retrieve. For stacks, the Original
	// and Processed templates are always available. For change sets, the Original
	// template is always available. After AWS CloudFormation finishes creating
	// the change set, the Processed template becomes available.
	StagesAvailable []*string `type:"list"`

	// Structure containing the template body. (For more information, go to Template
	// Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// AWS CloudFormation returns the same template that was used when the stack
	// was created.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// SetStagesAvailable sets the StagesAvailable field's value.
func (s *GetTemplateOutput) SetStagesAvailable(v []*string) *GetTemplateOutput {
	s.StagesAvailable = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *GetTemplateOutput) SetTemplateBody(v string) *GetTemplateOutput {
	s.TemplateBody = &v
	return s
}

// The input for the GetTemplateSummary action.
type GetTemplateSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name or the stack ID that is associated with the stack, which are not
	// always interchangeable. For running stacks, you can specify either the stack's
	// name or its unique stack ID. For deleted stack, you must specify the unique
	// stack ID.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	StackName *string `min:"1" type:"string"`

	// The name or unique ID of the stack set from which the stack was created.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	StackSetName *string `type:"string"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information about templates, see
	// Template Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information about templates, see Template Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTemplateSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateSummaryInput"}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackName sets the StackName field's value.
func (s *GetTemplateSummaryInput) SetStackName(v string) *GetTemplateSummaryInput {
	s.StackName = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *GetTemplateSummaryInput) SetStackSetName(v string) *GetTemplateSummaryInput {
	s.StackSetName = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *GetTemplateSummaryInput) SetTemplateBody(v string) *GetTemplateSummaryInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *GetTemplateSummaryInput) SetTemplateURL(v string) *GetTemplateSummaryInput {
	s.TemplateURL = &v
	return s
}

// The output for the GetTemplateSummary action.
type GetTemplateSummaryOutput struct {
	_ struct{} `type:"structure"`

	// The capabilities found within the template. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value
	// for this parameter when you use the CreateStack or UpdateStack actions with
	// your template; otherwise, those actions return an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []*string `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// A list of the transforms that are declared in the template.
	DeclaredTransforms []*string `type:"list"`

	// The value that is defined in the Description property of the template.
	Description *string `min:"1" type:"string"`

	// The value that is defined for the Metadata property of the template.
	Metadata *string `type:"string"`

	// A list of parameter declarations that describe various properties for each
	// parameter.
	Parameters []*ParameterDeclaration `type:"list"`

	// A list of all the template resource types that are defined in the template,
	// such as AWS::EC2::Instance, AWS::Dynamo::Table, and Custom::MyCustomInstance.
	ResourceTypes []*string `type:"list"`

	// The AWS template format version, which identifies the capabilities of the
	// template.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetTemplateSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *GetTemplateSummaryOutput) SetCapabilities(v []*string) *GetTemplateSummaryOutput {
	s.Capabilities = v
	return s
}

// SetCapabilitiesReason sets the CapabilitiesReason field's value.
func (s *GetTemplateSummaryOutput) SetCapabilitiesReason(v string) *GetTemplateSummaryOutput {
	s.CapabilitiesReason = &v
	return s
}

// SetDeclaredTransforms sets the DeclaredTransforms field's value.
func (s *GetTemplateSummaryOutput) SetDeclaredTransforms(v []*string) *GetTemplateSummaryOutput {
	s.DeclaredTransforms = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTemplateSummaryOutput) SetDescription(v string) *GetTemplateSummaryOutput {
	s.Description = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetTemplateSummaryOutput) SetMetadata(v string) *GetTemplateSummaryOutput {
	s.Metadata = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetTemplateSummaryOutput) SetParameters(v []*ParameterDeclaration) *GetTemplateSummaryOutput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetTemplateSummaryOutput) SetResourceTypes(v []*string) *GetTemplateSummaryOutput {
	s.ResourceTypes = v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetTemplateSummaryOutput) SetVersion(v string) *GetTemplateSummaryOutput {
	s.Version = &v
	return s
}

// The input for the ListChangeSets action.
type ListChangeSetsInput struct {
	_ struct{} `type:"structure"`

	// A string (provided by the ListChangeSets response output) that identifies
	// the next page of change sets that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the Amazon Resource Name (ARN) of the stack for which you want
	// to list change sets.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListChangeSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangeSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChangeSetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsInput) SetNextToken(v string) *ListChangeSetsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ListChangeSetsInput) SetStackName(v string) *ListChangeSetsInput {
	s.StackName = &v
	return s
}

// The output for the ListChangeSets action.
type ListChangeSetsOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB, a string that identifies the next page of change
	// sets. If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of ChangeSetSummary structures that provides the ID and status of
	// each change set for the specified stack.
	Summaries []*ChangeSetSummary `type:"list"`
}

// String returns the string representation
func (s ListChangeSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsOutput) SetNextToken(v string) *ListChangeSetsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListChangeSetsOutput) SetSummaries(v []*ChangeSetSummary) *ListChangeSetsOutput {
	s.Summaries = v
	return s
}

type ListExportsInput struct {
	_ struct{} `type:"structure"`

	// A string (provided by the ListExports response output) that identifies the
	// next page of exported output values that you asked to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListExportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExportsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsInput) SetNextToken(v string) *ListExportsInput {
	s.NextToken = &v
	return s
}

type ListExportsOutput struct {
	_ struct{} `type:"structure"`

	// The output for the ListExports action.
	Exports []*Export `type:"list"`

	// If the output exceeds 100 exported output values, a string that identifies
	// the next page of exports. If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListExportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExportsOutput) GoString() string {
	return s.String()
}

// SetExports sets the Exports field's value.
func (s *ListExportsOutput) SetExports(v []*Export) *ListExportsOutput {
	s.Exports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsOutput) SetNextToken(v string) *ListExportsOutput {
	s.NextToken = &v
	return s
}

type ListImportsInput struct {
	_ struct{} `type:"structure"`

	// The name of the exported output value. AWS CloudFormation returns the stack
	// names that are importing this value.
	//
	// ExportName is a required field
	ExportName *string `type:"string" required:"true"`

	// A string (provided by the ListImports response output) that identifies the
	// next page of stacks that are importing the specified exported output value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListImportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImportsInput"}
	if s.ExportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportName"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportName sets the ExportName field's value.
func (s *ListImportsInput) SetExportName(v string) *ListImportsInput {
	s.ExportName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportsInput) SetNextToken(v string) *ListImportsInput {
	s.NextToken = &v
	return s
}

type ListImportsOutput struct {
	_ struct{} `type:"structure"`

	// A list of stack names that are importing the specified exported output value.
	Imports []*string `type:"list"`

	// A string that identifies the next page of exports. If there is no additional
	// page, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListImportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImportsOutput) GoString() string {
	return s.String()
}

// SetImports sets the Imports field's value.
func (s *ListImportsOutput) SetImports(v []*string) *ListImportsOutput {
	s.Imports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportsOutput) SetNextToken(v string) *ListImportsOutput {
	s.NextToken = &v
	return s
}

type ListStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous request didn't return all of the remaining results, the response's
	// NextToken parameter value is set to a token. To retrieve the next set of
	// results, call ListStackInstances again and assign that token to the request
	// object's NextToken parameter. If there are no remaining results, the previous
	// response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The name of the AWS account that you want to list stack instances for.
	StackInstanceAccount *string `type:"string"`

	// The name of the region where you want to list stack instances.
	StackInstanceRegion *string `type:"string"`

	// The name or unique ID of the stack set that you want to list stack instances
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackInstancesInput) SetMaxResults(v int64) *ListStackInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackInstancesInput) SetNextToken(v string) *ListStackInstancesInput {
	s.NextToken = &v
	return s
}

// SetStackInstanceAccount sets the StackInstanceAccount field's value.
func (s *ListStackInstancesInput) SetStackInstanceAccount(v string) *ListStackInstancesInput {
	s.StackInstanceAccount = &v
	return s
}

// SetStackInstanceRegion sets the StackInstanceRegion field's value.
func (s *ListStackInstancesInput) SetStackInstanceRegion(v string) *ListStackInstancesInput {
	s.StackInstanceRegion = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *ListStackInstancesInput) SetStackSetName(v string) *ListStackInstancesInput {
	s.StackSetName = &v
	return s
}

type ListStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call ListStackInstances
	// again and assign that token to the request object's NextToken parameter.
	// If the request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackInstanceSummary structures that contain information about
	// the specified stack instances.
	Summaries []*StackInstanceSummary `type:"list"`
}

// String returns the string representation
func (s ListStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackInstancesOutput) SetNextToken(v string) *ListStackInstancesOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackInstancesOutput) SetSummaries(v []*StackInstanceSummary) *ListStackInstancesOutput {
	s.Summaries = v
	return s
}

// The input for the ListStackResource action.
type ListStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stack resources that you want to
	// retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackResourcesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackResourcesInput) SetNextToken(v string) *ListStackResourcesInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ListStackResourcesInput) SetStackName(v string) *ListStackResourcesInput {
	s.StackName = &v
	return s
}

// The output for a ListStackResources action.
type ListStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB, a string that identifies the next page of stack
	// resources. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackResourceSummary structures.
	StackResourceSummaries []*StackResourceSummary `type:"list"`
}

// String returns the string representation
func (s ListStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackResourcesOutput) SetNextToken(v string) *ListStackResourcesOutput {
	s.NextToken = &v
	return s
}

// SetStackResourceSummaries sets the StackResourceSummaries field's value.
func (s *ListStackResourcesOutput) SetStackResourceSummaries(v []*StackResourceSummary) *ListStackResourcesOutput {
	s.StackResourceSummaries = v
	return s
}

type ListStackSetOperationResultsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous request didn't return all of the remaining results, the response
	// object's NextToken parameter value is set to a token. To retrieve the next
	// set of results, call ListStackSetOperationResults again and assign that token
	// to the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The ID of the stack set operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or unique ID of the stack set that you want to get operation results
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackSetOperationResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetOperationResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetOperationResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackSetOperationResultsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackSetOperationResultsInput) SetMaxResults(v int64) *ListStackSetOperationResultsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetOperationResultsInput) SetNextToken(v string) *ListStackSetOperationResultsInput {
	s.NextToken = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *ListStackSetOperationResultsInput) SetOperationId(v string) *ListStackSetOperationResultsInput {
	s.OperationId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *ListStackSetOperationResultsInput) SetStackSetName(v string) *ListStackSetOperationResultsInput {
	s.StackSetName = &v
	return s
}

type ListStackSetOperationResultsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all results, NextToken is set to a token. To
	// retrieve the next set of results, call ListOperationResults again and assign
	// that token to the request object's NextToken parameter. If there are no remaining
	// results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSetOperationResultSummary structures that contain information
	// about the specified operation results, for accounts and regions that are
	// included in the operation.
	Summaries []*StackSetOperationResultSummary `type:"list"`
}

// String returns the string representation
func (s ListStackSetOperationResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetOperationResultsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetOperationResultsOutput) SetNextToken(v string) *ListStackSetOperationResultsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackSetOperationResultsOutput) SetSummaries(v []*StackSetOperationResultSummary) *ListStackSetOperationResultsOutput {
	s.Summaries = v
	return s
}

type ListStackSetOperationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListStackSetOperations again and assign that
	// token to the request object's NextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The name or unique ID of the stack set that you want to get operation summaries
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackSetOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackSetOperationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackSetOperationsInput) SetMaxResults(v int64) *ListStackSetOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetOperationsInput) SetNextToken(v string) *ListStackSetOperationsInput {
	s.NextToken = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *ListStackSetOperationsInput) SetStackSetName(v string) *ListStackSetOperationsInput {
	s.StackSetName = &v
	return s
}

type ListStackSetOperationsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all results, NextToken is set to a token. To
	// retrieve the next set of results, call ListOperationResults again and assign
	// that token to the request object's NextToken parameter. If there are no remaining
	// results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSetOperationSummary structures that contain summary information
	// about operations for the specified stack set.
	Summaries []*StackSetOperationSummary `type:"list"`
}

// String returns the string representation
func (s ListStackSetOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetOperationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetOperationsOutput) SetNextToken(v string) *ListStackSetOperationsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackSetOperationsOutput) SetSummaries(v []*StackSetOperationSummary) *ListStackSetOperationsOutput {
	s.Summaries = v
	return s
}

type ListStackSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListStackSets again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The status of the stack sets that you want to get summary information about.
	Status *string `type:"string" enum:"StackSetStatus"`
}

// String returns the string representation
func (s ListStackSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackSetsInput) SetMaxResults(v int64) *ListStackSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetsInput) SetNextToken(v string) *ListStackSetsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListStackSetsInput) SetStatus(v string) *ListStackSetsInput {
	s.Status = &v
	return s
}

type ListStackSetsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call ListStackInstances
	// again and assign that token to the request object's NextToken parameter.
	// If the request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSetSummary structures that contain information about the user's
	// stack sets.
	Summaries []*StackSetSummary `type:"list"`
}

// String returns the string representation
func (s ListStackSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetsOutput) SetNextToken(v string) *ListStackSetsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackSetsOutput) SetSummaries(v []*StackSetSummary) *ListStackSetsOutput {
	s.Summaries = v
	return s
}

// The input for ListStacks action.
type ListStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// Stack status to use as a filter. Specify one or more stack status codes to
	// list only stacks with the specified status codes. For a complete list of
	// stack status codes, see the StackStatus parameter of the Stack data type.
	StackStatusFilter []*string `type:"list"`
}

// String returns the string representation
func (s ListStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListStacksInput) SetNextToken(v string) *ListStacksInput {
	s.NextToken = &v
	return s
}

// SetStackStatusFilter sets the StackStatusFilter field's value.
func (s *ListStacksInput) SetStackStatusFilter(v []*string) *ListStacksInput {
	s.StackStatusFilter = v
	return s
}

// The output for ListStacks action.
type ListStacksOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSummary structures containing information about the specified
	// stacks.
	StackSummaries []*StackSummary `type:"list"`
}

// String returns the string representation
func (s ListStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStacksOutput) SetNextToken(v string) *ListStacksOutput {
	s.NextToken = &v
	return s
}

// SetStackSummaries sets the StackSummaries field's value.
func (s *ListStacksOutput) SetStackSummaries(v []*StackSummary) *ListStacksOutput {
	s.StackSummaries = v
	return s
}

// The Output data type.
type Output struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the output.
	Description *string `min:"1" type:"string"`

	// The name of the export associated with the output.
	ExportName *string `type:"string"`

	// The key associated with the output.
	OutputKey *string `type:"string"`

	// The value associated with the output.
	OutputValue *string `type:"string"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Output) SetDescription(v string) *Output {
	s.Description = &v
	return s
}

// SetExportName sets the ExportName field's value.
func (s *Output) SetExportName(v string) *Output {
	s.ExportName = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *Output) SetOutputKey(v string) *Output {
	s.OutputKey = &v
	return s
}

// SetOutputValue sets the OutputValue field's value.
func (s *Output) SetOutputValue(v string) *Output {
	s.OutputValue = &v
	return s
}

// The Parameter data type.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The key associated with the parameter. If you don't specify a key and value
	// for a particular parameter, AWS CloudFormation uses the default value that
	// is specified in your template.
	ParameterKey *string `type:"string"`

	// The input value associated with the parameter.
	ParameterValue *string `type:"string"`

	// Read-only. The value that corresponds to a Systems Manager parameter key.
	// This field is returned only for SSM (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types)
	// parameter types in the template.
	ResolvedValue *string `type:"string"`

	// During a stack update, use the existing parameter value that the stack is
	// using for a given parameter key. If you specify true, do not specify a parameter
	// value.
	UsePreviousValue *bool `type:"boolean"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetParameterKey sets the ParameterKey field's value.
func (s *Parameter) SetParameterKey(v string) *Parameter {
	s.ParameterKey = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetResolvedValue sets the ResolvedValue field's value.
func (s *Parameter) SetResolvedValue(v string) *Parameter {
	s.ResolvedValue = &v
	return s
}

// SetUsePreviousValue sets the UsePreviousValue field's value.
func (s *Parameter) SetUsePreviousValue(v bool) *Parameter {
	s.UsePreviousValue = &v
	return s
}

// A set of criteria that AWS CloudFormation uses to validate parameter values.
// Although other constraints might be defined in the stack template, AWS CloudFormation
// returns only the AllowedValues property.
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// A list of values that are permitted for a parameter.
	AllowedValues []*string `type:"list"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterConstraints) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *ParameterConstraints) SetAllowedValues(v []*string) *ParameterConstraints {
	s.AllowedValues = v
	return s
}

// The ParameterDeclaration data type.
type ParameterDeclaration struct {
	_ struct{} `type:"structure"`

	// The default value of the parameter.
	DefaultValue *string `type:"string"`

	// The description that is associate with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag that indicates whether the parameter value is shown as plain text in
	// logs and in the AWS Management Console.
	NoEcho *bool `type:"boolean"`

	// The criteria that AWS CloudFormation uses to validate parameter values.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The name that is associated with the parameter.
	ParameterKey *string `type:"string"`

	// The type of parameter.
	ParameterType *string `type:"string"`
}

// String returns the string representation
func (s ParameterDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterDeclaration) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ParameterDeclaration) SetDefaultValue(v string) *ParameterDeclaration {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ParameterDeclaration) SetDescription(v string) *ParameterDeclaration {
	s.Description = &v
	return s
}

// SetNoEcho sets the NoEcho field's value.
func (s *ParameterDeclaration) SetNoEcho(v bool) *ParameterDeclaration {
	s.NoEcho = &v
	return s
}

// SetParameterConstraints sets the ParameterConstraints field's value.
func (s *ParameterDeclaration) SetParameterConstraints(v *ParameterConstraints) *ParameterDeclaration {
	s.ParameterConstraints = v
	return s
}

// SetParameterKey sets the ParameterKey field's value.
func (s *ParameterDeclaration) SetParameterKey(v string) *ParameterDeclaration {
	s.ParameterKey = &v
	return s
}

// SetParameterType sets the ParameterType field's value.
func (s *ParameterDeclaration) SetParameterType(v string) *ParameterDeclaration {
	s.ParameterType = &v
	return s
}

// Context information that enables AWS CloudFormation to uniquely identify
// a resource. AWS CloudFormation uses context key-value pairs in cases where
// a resource's logical and physical IDs are not enough to uniquely identify
// that resource. Each context key-value pair specifies a resource that contains
// the targeted resource.
type PhysicalResourceIdContextKeyValuePair struct {
	_ struct{} `type:"structure"`

	// The resource context key.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The resource context value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PhysicalResourceIdContextKeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhysicalResourceIdContextKeyValuePair) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *PhysicalResourceIdContextKeyValuePair) SetKey(v string) *PhysicalResourceIdContextKeyValuePair {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PhysicalResourceIdContextKeyValuePair) SetValue(v string) *PhysicalResourceIdContextKeyValuePair {
	s.Value = &v
	return s
}

// Information about a resource property whose actual value differs from its
// expected value, as defined in the stack template and any values specified
// as template parameters. These will be present only for resources whose StackResourceDriftStatus
// is MODIFIED. For more information, see Detecting Unregulated Configuration
// Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
type PropertyDifference struct {
	_ struct{} `type:"structure"`

	// The actual property value of the resource property.
	//
	// ActualValue is a required field
	ActualValue *string `type:"string" required:"true"`

	// The type of property difference.
	//
	//    * ADD: A value has been added to a resource property that is an array
	//    or list data type.
	//
	//    * REMOVE: The property has been removed from the current resource configuration.
	//
	//    * NOT_EQUAL: The current property value differs from its expected value
	//    (as defined in the stack template and any values specified as template
	//    parameters).
	//
	// DifferenceType is a required field
	DifferenceType *string `type:"string" required:"true" enum:"DifferenceType"`

	// The expected property value of the resource property, as defined in the stack
	// template and any values specified as template parameters.
	//
	// ExpectedValue is a required field
	ExpectedValue *string `type:"string" required:"true"`

	// The fully-qualified path to the resource property.
	//
	// PropertyPath is a required field
	PropertyPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PropertyDifference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PropertyDifference) GoString() string {
	return s.String()
}

// SetActualValue sets the ActualValue field's value.
func (s *PropertyDifference) SetActualValue(v string) *PropertyDifference {
	s.ActualValue = &v
	return s
}

// SetDifferenceType sets the DifferenceType field's value.
func (s *PropertyDifference) SetDifferenceType(v string) *PropertyDifference {
	s.DifferenceType = &v
	return s
}

// SetExpectedValue sets the ExpectedValue field's value.
func (s *PropertyDifference) SetExpectedValue(v string) *PropertyDifference {
	s.ExpectedValue = &v
	return s
}

// SetPropertyPath sets the PropertyPath field's value.
func (s *PropertyDifference) SetPropertyPath(v string) *PropertyDifference {
	s.PropertyPath = &v
	return s
}

// The ResourceChange structure describes the resource and the action that AWS
// CloudFormation will perform on it if you execute this change set.
type ResourceChange struct {
	_ struct{} `type:"structure"`

	// The action that AWS CloudFormation takes on the resource, such as Add (adds
	// a new resource), Modify (changes a resource), or Remove (deletes a resource).
	Action *string `type:"string" enum:"ChangeAction"`

	// For the Modify action, a list of ResourceChangeDetail structures that describes
	// the changes that AWS CloudFormation will make to the resource.
	Details []*ResourceChangeDetail `type:"list"`

	// The resource's logical ID, which is defined in the stack's template.
	LogicalResourceId *string `type:"string"`

	// The resource's physical ID (resource name). Resources that you are adding
	// don't have physical IDs because they haven't been created.
	PhysicalResourceId *string `type:"string"`

	// For the Modify action, indicates whether AWS CloudFormation will replace
	// the resource by creating a new one and deleting the old one. This value depends
	// on the value of the RequiresRecreation property in the ResourceTargetDefinition
	// structure. For example, if the RequiresRecreation field is Always and the
	// Evaluation field is Static, Replacement is True. If the RequiresRecreation
	// field is Always and the Evaluation field is Dynamic, Replacement is Conditionally.
	//
	// If you have multiple changes with different RequiresRecreation values, the
	// Replacement value depends on the change with the most impact. A RequiresRecreation
	// value of Always has the most impact, followed by Conditionally, and then
	// Never.
	Replacement *string `type:"string" enum:"Replacement"`

	// The type of AWS CloudFormation resource, such as AWS::S3::Bucket.
	ResourceType *string `min:"1" type:"string"`

	// For the Modify action, indicates which resource attribute is triggering this
	// update, such as a change in the resource attribute's Metadata, Properties,
	// or Tags.
	Scope []*string `type:"list"`
}

// String returns the string representation
func (s ResourceChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceChange) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ResourceChange) SetAction(v string) *ResourceChange {
	s.Action = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ResourceChange) SetDetails(v []*ResourceChangeDetail) *ResourceChange {
	s.Details = v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *ResourceChange) SetLogicalResourceId(v string) *ResourceChange {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *ResourceChange) SetPhysicalResourceId(v string) *ResourceChange {
	s.PhysicalResourceId = &v
	return s
}

// SetReplacement sets the Replacement field's value.
func (s *ResourceChange) SetReplacement(v string) *ResourceChange {
	s.Replacement = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceChange) SetResourceType(v string) *ResourceChange {
	s.ResourceType = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ResourceChange) SetScope(v []*string) *ResourceChange {
	s.Scope = v
	return s
}

// For a resource with Modify as the action, the ResourceChange structure describes
// the changes AWS CloudFormation will make to that resource.
type ResourceChangeDetail struct {
	_ struct{} `type:"structure"`

	// The identity of the entity that triggered this change. This entity is a member
	// of the group that is specified by the ChangeSource field. For example, if
	// you modified the value of the KeyPairName parameter, the CausingEntity is
	// the name of the parameter (KeyPairName).
	//
	// If the ChangeSource value is DirectModification, no value is given for CausingEntity.
	CausingEntity *string `type:"string"`

	// The group to which the CausingEntity value belongs. There are five entity
	// groups:
	//
	//    * ResourceReference entities are Ref intrinsic functions that refer to
	//    resources in the template, such as { "Ref" : "MyEC2InstanceResource" }.
	//
	//    * ParameterReference entities are Ref intrinsic functions that get template
	//    parameter values, such as { "Ref" : "MyPasswordParameter" }.
	//
	//    * ResourceAttribute entities are Fn::GetAtt intrinsic functions that get
	//    resource attribute values, such as { "Fn::GetAtt" : [ "MyEC2InstanceResource",
	//    "PublicDnsName" ] }.
	//
	//    * DirectModification entities are changes that are made directly to the
	//    template.
	//
	//    * Automatic entities are AWS::CloudFormation::Stack resource types, which
	//    are also known as nested stacks. If you made no changes to the AWS::CloudFormation::Stack
	//    resource, AWS CloudFormation sets the ChangeSource to Automatic because
	//    the nested stack's template might have changed. Changes to a nested stack's
	//    template aren't visible to AWS CloudFormation until you run an update
	//    on the parent stack.
	ChangeSource *string `type:"string" enum:"ChangeSource"`

	// Indicates whether AWS CloudFormation can determine the target value, and
	// whether the target value will change before you execute a change set.
	//
	// For Static evaluations, AWS CloudFormation can determine that the target
	// value will change, and its value. For example, if you directly modify the
	// InstanceType property of an EC2 instance, AWS CloudFormation knows that this
	// property value will change, and its value, so this is a Static evaluation.
	//
	// For Dynamic evaluations, cannot determine the target value because it depends
	// on the result of an intrinsic function, such as a Ref or Fn::GetAtt intrinsic
	// function, when the stack is updated. For example, if your template includes
	// a reference to a resource that is conditionally recreated, the value of the
	// reference (the physical ID of the resource) might change, depending on if
	// the resource is recreated. If the resource is recreated, it will have a new
	// physical ID, so all references to that resource will also be updated.
	Evaluation *string `type:"string" enum:"EvaluationType"`

	// A ResourceTargetDefinition structure that describes the field that AWS CloudFormation
	// will change and whether the resource will be recreated.
	Target *ResourceTargetDefinition `type:"structure"`
}

// String returns the string representation
func (s ResourceChangeDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceChangeDetail) GoString() string {
	return s.String()
}

// SetCausingEntity sets the CausingEntity field's value.
func (s *ResourceChangeDetail) SetCausingEntity(v string) *ResourceChangeDetail {
	s.CausingEntity = &v
	return s
}

// SetChangeSource sets the ChangeSource field's value.
func (s *ResourceChangeDetail) SetChangeSource(v string) *ResourceChangeDetail {
	s.ChangeSource = &v
	return s
}

// SetEvaluation sets the Evaluation field's value.
func (s *ResourceChangeDetail) SetEvaluation(v string) *ResourceChangeDetail {
	s.Evaluation = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ResourceChangeDetail) SetTarget(v *ResourceTargetDefinition) *ResourceChangeDetail {
	s.Target = v
	return s
}

// The field that AWS CloudFormation will change, such as the name of a resource's
// property, and whether the resource will be recreated.
type ResourceTargetDefinition struct {
	_ struct{} `type:"structure"`

	// Indicates which resource attribute is triggering this update, such as a change
	// in the resource attribute's Metadata, Properties, or Tags.
	Attribute *string `type:"string" enum:"ResourceAttribute"`

	// If the Attribute value is Properties, the name of the property. For all other
	// attributes, the value is null.
	Name *string `type:"string"`

	// If the Attribute value is Properties, indicates whether a change to this
	// property causes the resource to be recreated. The value can be Never, Always,
	// or Conditionally. To determine the conditions for a Conditionally recreation,
	// see the update behavior for that property (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.
	RequiresRecreation *string `type:"string" enum:"RequiresRecreation"`
}

// String returns the string representation
func (s ResourceTargetDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTargetDefinition) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *ResourceTargetDefinition) SetAttribute(v string) *ResourceTargetDefinition {
	s.Attribute = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceTargetDefinition) SetName(v string) *ResourceTargetDefinition {
	s.Name = &v
	return s
}

// SetRequiresRecreation sets the RequiresRecreation field's value.
func (s *ResourceTargetDefinition) SetRequiresRecreation(v string) *ResourceTargetDefinition {
	s.RequiresRecreation = &v
	return s
}

// Structure containing the rollback triggers for AWS CloudFormation to monitor
// during stack creation and updating operations, and for the specified monitoring
// period afterwards.
//
// Rollback triggers enable you to have AWS CloudFormation monitor the state
// of your application during stack creation and updating, and to roll back
// that operation if the application breaches the threshold of any of the alarms
// you've specified. For more information, see Monitor and Roll Back Stack Operations
// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-rollback-triggers.html).
type RollbackConfiguration struct {
	_ struct{} `type:"structure"`

	// The amount of time, in minutes, during which CloudFormation should monitor
	// all the rollback triggers after the stack creation or update operation deploys
	// all necessary resources.
	//
	// The default is 0 minutes.
	//
	// If you specify a monitoring period but do not specify any rollback triggers,
	// CloudFormation still waits the specified period of time before cleaning up
	// old resources after update operations. You can use this monitoring period
	// to perform any manual stack validation desired, and manually cancel the stack
	// creation or update (using CancelUpdateStack (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html),
	// for example) as necessary.
	//
	// If you specify 0 for this parameter, CloudFormation still monitors the specified
	// rollback triggers during stack creation and update operations. Then, for
	// update operations, it begins disposing of old resources immediately once
	// the operation completes.
	MonitoringTimeInMinutes *int64 `type:"integer"`

	// The triggers to monitor during stack creation or update actions.
	//
	// By default, AWS CloudFormation saves the rollback triggers specified for
	// a stack and applies them to any subsequent update operations for the stack,
	// unless you specify otherwise. If you do specify rollback triggers for this
	// parameter, those triggers replace any list of triggers previously specified
	// for the stack. This means:
	//
	//    * To use the rollback triggers previously specified for this stack, if
	//    any, don't specify this parameter.
	//
	//    * To specify new or updated rollback triggers, you must specify all the
	//    triggers that you want used for this stack, even triggers you've specifed
	//    before (for example, when creating the stack or during a previous stack
	//    update). Any triggers that you don't include in the updated list of triggers
	//    are no longer applied to the stack.
	//
	//    * To remove all currently specified triggers, specify an empty list for
	//    this parameter.
	//
	// If a specified trigger is missing, the entire stack operation fails and is
	// rolled back.
	RollbackTriggers []*RollbackTrigger `type:"list"`
}

// String returns the string representation
func (s RollbackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackConfiguration"}
	if s.RollbackTriggers != nil {
		for i, v := range s.RollbackTriggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RollbackTriggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitoringTimeInMinutes sets the MonitoringTimeInMinutes field's value.
func (s *RollbackConfiguration) SetMonitoringTimeInMinutes(v int64) *RollbackConfiguration {
	s.MonitoringTimeInMinutes = &v
	return s
}

// SetRollbackTriggers sets the RollbackTriggers field's value.
func (s *RollbackConfiguration) SetRollbackTriggers(v []*RollbackTrigger) *RollbackConfiguration {
	s.RollbackTriggers = v
	return s
}

// A rollback trigger AWS CloudFormation monitors during creation and updating
// of stacks. If any of the alarms you specify goes to ALARM state during the
// stack operation or within the specified monitoring period afterwards, CloudFormation
// rolls back the entire stack operation.
type RollbackTrigger struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rollback trigger.
	//
	// If a specified trigger is missing, the entire stack operation fails and is
	// rolled back.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The resource type of the rollback trigger. Currently, AWS::CloudWatch::Alarm
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html)
	// is the only supported resource type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RollbackTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackTrigger) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackTrigger) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackTrigger"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *RollbackTrigger) SetArn(v string) *RollbackTrigger {
	s.Arn = &v
	return s
}

// SetType sets the Type field's value.
func (s *RollbackTrigger) SetType(v string) *RollbackTrigger {
	s.Type = &v
	return s
}

// The input for the SetStackPolicy action.
type SetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that you want to associate a policy with.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (maximum size: 16 KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetStackPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetStackPolicyInput"}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackName sets the StackName field's value.
func (s *SetStackPolicyInput) SetStackName(v string) *SetStackPolicyInput {
	s.StackName = &v
	return s
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *SetStackPolicyInput) SetStackPolicyBody(v string) *SetStackPolicyInput {
	s.StackPolicyBody = &v
	return s
}

// SetStackPolicyURL sets the StackPolicyURL field's value.
func (s *SetStackPolicyInput) SetStackPolicyURL(v string) *SetStackPolicyInput {
	s.StackPolicyURL = &v
	return s
}

type SetStackPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyOutput) GoString() string {
	return s.String()
}

// The input for the SignalResource action.
type SignalResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical ID of the resource that you want to signal. The logical ID is
	// the name of the resource that given in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The stack name or unique stack ID that includes the resource that you want
	// to signal.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The status of the signal, which is either success or failure. A failure signal
	// causes AWS CloudFormation to immediately fail the stack creation or update.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ResourceSignalStatus"`

	// A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
	// groups, specify the instance ID that you are signaling as the unique ID.
	// If you send multiple signals to a single resource (such as signaling a wait
	// condition), each signal requires a different unique ID.
	//
	// UniqueId is a required field
	UniqueId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignalResourceInput"}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.UniqueId == nil {
		invalidParams.Add(request.NewErrParamRequired("UniqueId"))
	}
	if s.UniqueId != nil && len(*s.UniqueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UniqueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *SignalResourceInput) SetLogicalResourceId(v string) *SignalResourceInput {
	s.LogicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *SignalResourceInput) SetStackName(v string) *SignalResourceInput {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SignalResourceInput) SetStatus(v string) *SignalResourceInput {
	s.Status = &v
	return s
}

// SetUniqueId sets the UniqueId field's value.
func (s *SignalResourceInput) SetUniqueId(v string) *SignalResourceInput {
	s.UniqueId = &v
	return s
}

type SignalResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SignalResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceOutput) GoString() string {
	return s.String()
}

// The Stack data type.
type Stack struct {
	_ struct{} `type:"structure"`

	// The capabilities allowed in the stack.
	Capabilities []*string `type:"list"`

	// The unique ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The time at which the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp"`

	// A user-defined description associated with the stack.
	Description *string `min:"1" type:"string"`

	// Boolean to enable or disable rollback on stack creation failures:
	//
	//    * true: disable rollback
	//
	//    * false: enable rollback
	DisableRollback *bool `type:"boolean"`

	// Information on whether a stack's actual configuration differs, or has drifted,
	// from it's expected configuration, as defined in the stack template and any
	// values specified as template parameters. For more information, see Detecting
	// Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackDriftInformation `type:"structure"`

	// Whether termination protection is enabled for the stack.
	//
	// For nested stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
	// termination protection is set on the root stack and cannot be changed directly
	// on the nested stack. For more information, see Protecting a Stack From Being
	// Deleted (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
	// in the AWS CloudFormation User Guide.
	EnableTerminationProtection *bool `type:"boolean"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// SNS topic ARNs to which stack related events are published.
	NotificationARNs []*string `type:"list"`

	// A list of output structures.
	Outputs []*Output `type:"list"`

	// A list of Parameter structures.
	Parameters []*Parameter `type:"list"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the direct parent of this stack. For the first level of nested stacks,
	// the root stack is also the parent stack.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	ParentId *string `type:"string"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that is associated with the stack. During a stack operation, AWS CloudFormation
	// uses this role's credentials to make calls on your behalf.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the the top-level stack to which the nested stack ultimately belongs.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	RootId *string `type:"string"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Current status of the stack.
	//
	// StackStatus is a required field
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// A list of Tags that specify information about the stack.
	Tags []*Tag `type:"list"`

	// The amount of time within which stack creation should complete.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *Stack) SetCapabilities(v []*string) *Stack {
	s.Capabilities = v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *Stack) SetChangeSetId(v string) *Stack {
	s.ChangeSetId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Stack) SetCreationTime(v time.Time) *Stack {
	s.CreationTime = &v
	return s
}

// SetDeletionTime sets the DeletionTime field's value.
func (s *Stack) SetDeletionTime(v time.Time) *Stack {
	s.DeletionTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Stack) SetDescription(v string) *Stack {
	s.Description = &v
	return s
}

// SetDisableRollback sets the DisableRollback field's value.
func (s *Stack) SetDisableRollback(v bool) *Stack {
	s.DisableRollback = &v
	return s
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *Stack) SetDriftInformation(v *StackDriftInformation) *Stack {
	s.DriftInformation = v
	return s
}

// SetEnableTerminationProtection sets the EnableTerminationProtection field's value.
func (s *Stack) SetEnableTerminationProtection(v bool) *Stack {
	s.EnableTerminationProtection = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Stack) SetLastUpdatedTime(v time.Time) *Stack {
	s.LastUpdatedTime = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *Stack) SetNotificationARNs(v []*string) *Stack {
	s.NotificationARNs = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Stack) SetOutputs(v []*Output) *Stack {
	s.Outputs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Stack) SetParameters(v []*Parameter) *Stack {
	s.Parameters = v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *Stack) SetParentId(v string) *Stack {
	s.ParentId = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *Stack) SetRoleARN(v string) *Stack {
	s.RoleARN = &v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *Stack) SetRollbackConfiguration(v *RollbackConfiguration) *Stack {
	s.RollbackConfiguration = v
	return s
}

// SetRootId sets the RootId field's value.
func (s *Stack) SetRootId(v string) *Stack {
	s.RootId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *Stack) SetStackId(v string) *Stack {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *Stack) SetStackName(v string) *Stack {
	s.StackName = &v
	return s
}

// SetStackStatus sets the StackStatus field's value.
func (s *Stack) SetStackStatus(v string) *Stack {
	s.StackStatus = &v
	return s
}

// SetStackStatusReason sets the StackStatusReason field's value.
func (s *Stack) SetStackStatusReason(v string) *Stack {
	s.StackStatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Stack) SetTags(v []*Tag) *Stack {
	s.Tags = v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *Stack) SetTimeoutInMinutes(v int64) *Stack {
	s.TimeoutInMinutes = &v
	return s
}

// Contains information about whether the stack's actual configuration differs,
// or has drifted, from its expected configuration, as defined in the stack
// template and any values specified as template parameters. A stack is considered
// to have drifted if one or more of its resources have drifted.
type StackDriftInformation struct {
	_ struct{} `type:"structure"`

	// Most recent time when a drift detection operation was initiated on the stack,
	// or any of its individual resources that support drift detection.
	LastCheckTimestamp *time.Time `type:"timestamp"`

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	//
	//    * DRIFTED: The stack differs from its expected template configuration.
	//    A stack is considered to have drifted if one or more of its resources
	//    have drifted.
	//
	//    * NOT_CHECKED: AWS CloudFormation has not checked if the stack differs
	//    from its expected template configuration.
	//
	//    * IN_SYNC: The stack's actual configuration matches its expected template
	//    configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	//
	// StackDriftStatus is a required field
	StackDriftStatus *string `type:"string" required:"true" enum:"StackDriftStatus"`
}

// String returns the string representation
func (s StackDriftInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackDriftInformation) GoString() string {
	return s.String()
}

// SetLastCheckTimestamp sets the LastCheckTimestamp field's value.
func (s *StackDriftInformation) SetLastCheckTimestamp(v time.Time) *StackDriftInformation {
	s.LastCheckTimestamp = &v
	return s
}

// SetStackDriftStatus sets the StackDriftStatus field's value.
func (s *StackDriftInformation) SetStackDriftStatus(v string) *StackDriftInformation {
	s.StackDriftStatus = &v
	return s
}

// Contains information about whether the stack's actual configuration differs,
// or has drifted, from its expected configuration, as defined in the stack
// template and any values specified as template parameters. A stack is considered
// to have drifted if one or more of its resources have drifted.
type StackDriftInformationSummary struct {
	_ struct{} `type:"structure"`

	// Most recent time when a drift detection operation was initiated on the stack,
	// or any of its individual resources that support drift detection.
	LastCheckTimestamp *time.Time `type:"timestamp"`

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	//
	//    * DRIFTED: The stack differs from its expected template configuration.
	//    A stack is considered to have drifted if one or more of its resources
	//    have drifted.
	//
	//    * NOT_CHECKED: AWS CloudFormation has not checked if the stack differs
	//    from its expected template configuration.
	//
	//    * IN_SYNC: The stack's actual configuration matches its expected template
	//    configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	//
	// StackDriftStatus is a required field
	StackDriftStatus *string `type:"string" required:"true" enum:"StackDriftStatus"`
}

// String returns the string representation
func (s StackDriftInformationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackDriftInformationSummary) GoString() string {
	return s.String()
}

// SetLastCheckTimestamp sets the LastCheckTimestamp field's value.
func (s *StackDriftInformationSummary) SetLastCheckTimestamp(v time.Time) *StackDriftInformationSummary {
	s.LastCheckTimestamp = &v
	return s
}

// SetStackDriftStatus sets the StackDriftStatus field's value.
func (s *StackDriftInformationSummary) SetStackDriftStatus(v string) *StackDriftInformationSummary {
	s.StackDriftStatus = &v
	return s
}

// The StackEvent data type.
type StackEvent struct {
	_ struct{} `type:"structure"`

	// The token passed to the operation that generated this event.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// The unique ID of this event.
	//
	// EventId is a required field
	EventId *string `type:"string" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier associated with the physical instance of the
	// resource.
	PhysicalResourceId *string `type:"string"`

	// BLOB of the properties used to create the resource.
	ResourceProperties *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `min:"1" type:"string"`

	// The unique ID name of the instance of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// The name associated with a stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s StackEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackEvent) GoString() string {
	return s.String()
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StackEvent) SetClientRequestToken(v string) *StackEvent {
	s.ClientRequestToken = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *StackEvent) SetEventId(v string) *StackEvent {
	s.EventId = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackEvent) SetLogicalResourceId(v string) *StackEvent {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackEvent) SetPhysicalResourceId(v string) *StackEvent {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceProperties sets the ResourceProperties field's value.
func (s *StackEvent) SetResourceProperties(v string) *StackEvent {
	s.ResourceProperties = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackEvent) SetResourceStatus(v string) *StackEvent {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackEvent) SetResourceStatusReason(v string) *StackEvent {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackEvent) SetResourceType(v string) *StackEvent {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackEvent) SetStackId(v string) *StackEvent {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackEvent) SetStackName(v string) *StackEvent {
	s.StackName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StackEvent) SetTimestamp(v time.Time) *StackEvent {
	s.Timestamp = &v
	return s
}

// An AWS CloudFormation stack, in a specific account and region, that's part
// of a stack set operation. A stack instance is a reference to an attempted
// or actual stack in a given account within a given region. A stack instance
// can exist without a stack—for example, if the stack couldn't be created for
// some reason. A stack instance is associated with only one stack set. Each
// stack instance contains the ID of its associated stack set, as well as the
// ID of the actual stack and the stack status.
type StackInstance struct {
	_ struct{} `type:"structure"`

	// The name of the AWS account that the stack instance is associated with.
	Account *string `type:"string"`

	// A list of parameters from the stack set template whose values have been overridden
	// in this stack instance.
	ParameterOverrides []*Parameter `type:"list"`

	// The name of the AWS region that the stack instance is associated with.
	Region *string `type:"string"`

	// The ID of the stack instance.
	StackId *string `type:"string"`

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string `type:"string"`

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	//    * INOPERABLE: A DeleteStackInstances operation has failed and left the
	//    stack in an unstable state. Stacks in this state are excluded from further
	//    UpdateStackSet operations. You might need to perform a DeleteStackInstances
	//    operation, with RetainStacks set to true, to delete the stack instance,
	//    and then delete the stack manually.
	//
	//    * OUTDATED: The stack isn't currently up to date with the stack set because:
	//
	// The associated stack failed during a CreateStackSet or UpdateStackSet operation.
	//
	//
	// The stack was part of a CreateStackSet or UpdateStackSet operation that failed
	//    or was stopped before the stack was created or updated.
	//
	//    * CURRENT: The stack is currently up to date with the stack set.
	Status *string `type:"string" enum:"StackInstanceStatus"`

	// The explanation for the specific status code that is assigned to this stack
	// instance.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s StackInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackInstance) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *StackInstance) SetAccount(v string) *StackInstance {
	s.Account = &v
	return s
}

// SetParameterOverrides sets the ParameterOverrides field's value.
func (s *StackInstance) SetParameterOverrides(v []*Parameter) *StackInstance {
	s.ParameterOverrides = v
	return s
}

// SetRegion sets the Region field's value.
func (s *StackInstance) SetRegion(v string) *StackInstance {
	s.Region = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackInstance) SetStackId(v string) *StackInstance {
	s.StackId = &v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackInstance) SetStackSetId(v string) *StackInstance {
	s.StackSetId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackInstance) SetStatus(v string) *StackInstance {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *StackInstance) SetStatusReason(v string) *StackInstance {
	s.StatusReason = &v
	return s
}

// The structure that contains summary information about a stack instance.
type StackInstanceSummary struct {
	_ struct{} `type:"structure"`

	// The name of the AWS account that the stack instance is associated with.
	Account *string `type:"string"`

	// The name of the AWS region that the stack instance is associated with.
	Region *string `type:"string"`

	// The ID of the stack instance.
	StackId *string `type:"string"`

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string `type:"string"`

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	//    * INOPERABLE: A DeleteStackInstances operation has failed and left the
	//    stack in an unstable state. Stacks in this state are excluded from further
	//    UpdateStackSet operations. You might need to perform a DeleteStackInstances
	//    operation, with RetainStacks set to true, to delete the stack instance,
	//    and then delete the stack manually.
	//
	//    * OUTDATED: The stack isn't currently up to date with the stack set because:
	//
	// The associated stack failed during a CreateStackSet or UpdateStackSet operation.
	//
	//
	// The stack was part of a CreateStackSet or UpdateStackSet operation that failed
	//    or was stopped before the stack was created or updated.
	//
	//    * CURRENT: The stack is currently up to date with the stack set.
	Status *string `type:"string" enum:"StackInstanceStatus"`

	// The explanation for the specific status code assigned to this stack instance.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s StackInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackInstanceSummary) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *StackInstanceSummary) SetAccount(v string) *StackInstanceSummary {
	s.Account = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *StackInstanceSummary) SetRegion(v string) *StackInstanceSummary {
	s.Region = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackInstanceSummary) SetStackId(v string) *StackInstanceSummary {
	s.StackId = &v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackInstanceSummary) SetStackSetId(v string) *StackInstanceSummary {
	s.StackSetId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackInstanceSummary) SetStatus(v string) *StackInstanceSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *StackInstanceSummary) SetStatusReason(v string) *StackInstanceSummary {
	s.StatusReason = &v
	return s
}

// The StackResource data type.
type StackResource struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// Information about whether the resource's actual configuration differs, or
	// has drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformation `type:"structure"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s StackResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResource) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StackResource) SetDescription(v string) *StackResource {
	s.Description = &v
	return s
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *StackResource) SetDriftInformation(v *StackResourceDriftInformation) *StackResource {
	s.DriftInformation = v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResource) SetLogicalResourceId(v string) *StackResource {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResource) SetPhysicalResourceId(v string) *StackResource {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackResource) SetResourceStatus(v string) *StackResource {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackResource) SetResourceStatusReason(v string) *StackResource {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResource) SetResourceType(v string) *StackResource {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackResource) SetStackId(v string) *StackResource {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackResource) SetStackName(v string) *StackResource {
	s.StackName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StackResource) SetTimestamp(v time.Time) *StackResource {
	s.Timestamp = &v
	return s
}

// Contains detailed information about the specified stack resource.
type StackResourceDetail struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// Information about whether the resource's actual configuration differs, or
	// has drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformation `type:"structure"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The content of the Metadata attribute declared for the resource. For more
	// information, see Metadata Attribute (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html)
	// in the AWS CloudFormation User Guide.
	Metadata *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. ((For more information, go to  AWS Resource Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s StackResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceDetail) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StackResourceDetail) SetDescription(v string) *StackResourceDetail {
	s.Description = &v
	return s
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *StackResourceDetail) SetDriftInformation(v *StackResourceDriftInformation) *StackResourceDetail {
	s.DriftInformation = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *StackResourceDetail) SetLastUpdatedTimestamp(v time.Time) *StackResourceDetail {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResourceDetail) SetLogicalResourceId(v string) *StackResourceDetail {
	s.LogicalResourceId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *StackResourceDetail) SetMetadata(v string) *StackResourceDetail {
	s.Metadata = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResourceDetail) SetPhysicalResourceId(v string) *StackResourceDetail {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackResourceDetail) SetResourceStatus(v string) *StackResourceDetail {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackResourceDetail) SetResourceStatusReason(v string) *StackResourceDetail {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResourceDetail) SetResourceType(v string) *StackResourceDetail {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackResourceDetail) SetStackId(v string) *StackResourceDetail {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackResourceDetail) SetStackName(v string) *StackResourceDetail {
	s.StackName = &v
	return s
}

// Contains the drift information for a resource that has been checked for drift.
// This includes actual and expected property values for resources in which
// AWS CloudFormation has detected drift. Only resource properties explicitly
// defined in the stack template are checked for drift. For more information,
// see Detecting Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
//
// Resources that do not currently support drift detection cannot be checked.
// For a list of resources that support drift detection, see Resources that
// Support Drift Detection (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// Use DetectStackResourceDrift to detect drift on individual resources, or
// DetectStackDrift to detect drift on all resources in a given stack that support
// drift detection.
type StackResourceDrift struct {
	_ struct{} `type:"structure"`

	// A JSON structure containing the actual property values of the stack resource.
	//
	// For resources whose StackResourceDriftStatus is DELETED, this structure will
	// not be present.
	ActualProperties *string `type:"string"`

	// A JSON structure containing the expected property values of the stack resource,
	// as defined in the stack template and any values specified as template parameters.
	//
	// For resources whose StackResourceDriftStatus is DELETED, this structure will
	// not be present.
	ExpectedProperties *string `type:"string"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Context information that enables AWS CloudFormation to uniquely identify
	// a resource. AWS CloudFormation uses context key-value pairs in cases where
	// a resource's logical and physical IDs are not enough to uniquely identify
	// that resource. Each context key-value pair specifies a unique resource that
	// contains the targeted resource.
	PhysicalResourceIdContext []*PhysicalResourceIdContextKeyValuePair `type:"list"`

	// A collection of the resource properties whose actual values differ from their
	// expected values. These will be present only for resources whose StackResourceDriftStatus
	// is MODIFIED.
	PropertyDifferences []*PropertyDifference `type:"list"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// The ID of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// Status of the resource's actual configuration compared to its expected configuration
	//
	//    * DELETED: The resource differs from its expected template configuration
	//    because the resource has been deleted.
	//
	//    * MODIFIED: One or more resource properties differ from their expected
	//    values (as defined in the stack template and any values specified as template
	//    parameters).
	//
	//    * IN_SYNC: The resources's actual configuration matches its expected template
	//    configuration.
	//
	//    * NOT_CHECKED: AWS CloudFormation does not currently return this value.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus *string `type:"string" required:"true" enum:"StackResourceDriftStatus"`

	// Time at which AWS CloudFormation performed drift detection on the stack resource.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s StackResourceDrift) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceDrift) GoString() string {
	return s.String()
}

// SetActualProperties sets the ActualProperties field's value.
func (s *StackResourceDrift) SetActualProperties(v string) *StackResourceDrift {
	s.ActualProperties = &v
	return s
}

// SetExpectedProperties sets the ExpectedProperties field's value.
func (s *StackResourceDrift) SetExpectedProperties(v string) *StackResourceDrift {
	s.ExpectedProperties = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResourceDrift) SetLogicalResourceId(v string) *StackResourceDrift {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResourceDrift) SetPhysicalResourceId(v string) *StackResourceDrift {
	s.PhysicalResourceId = &v
	return s
}

// SetPhysicalResourceIdContext sets the PhysicalResourceIdContext field's value.
func (s *StackResourceDrift) SetPhysicalResourceIdContext(v []*PhysicalResourceIdContextKeyValuePair) *StackResourceDrift {
	s.PhysicalResourceIdContext = v
	return s
}

// SetPropertyDifferences sets the PropertyDifferences field's value.
func (s *StackResourceDrift) SetPropertyDifferences(v []*PropertyDifference) *StackResourceDrift {
	s.PropertyDifferences = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResourceDrift) SetResourceType(v string) *StackResourceDrift {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackResourceDrift) SetStackId(v string) *StackResourceDrift {
	s.StackId = &v
	return s
}

// SetStackResourceDriftStatus sets the StackResourceDriftStatus field's value.
func (s *StackResourceDrift) SetStackResourceDriftStatus(v string) *StackResourceDrift {
	s.StackResourceDriftStatus = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StackResourceDrift) SetTimestamp(v time.Time) *StackResourceDrift {
	s.Timestamp = &v
	return s
}

// Contains information about whether the resource's actual configuration differs,
// or has drifted, from its expected configuration.
type StackResourceDriftInformation struct {
	_ struct{} `type:"structure"`

	// When AWS CloudFormation last checked if the resource had drifted from its
	// expected configuration.
	LastCheckTimestamp *time.Time `type:"timestamp"`

	// Status of the resource's actual configuration compared to its expected configuration
	//
	//    * DELETED: The resource differs from its expected configuration in that
	//    it has been deleted.
	//
	//    * MODIFIED: The resource differs from its expected configuration.
	//
	//    * NOT_CHECKED: AWS CloudFormation has not checked if the resource differs
	//    from its expected configuration.
	//
	// Any resources that do not currently support drift detection have a status
	//    of NOT_CHECKED. For more information, see Resources that Support Drift
	//    Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//
	//
	//    * IN_SYNC: The resources's actual configuration matches its expected configuration.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus *string `type:"string" required:"true" enum:"StackResourceDriftStatus"`
}

// String returns the string representation
func (s StackResourceDriftInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceDriftInformation) GoString() string {
	return s.String()
}

// SetLastCheckTimestamp sets the LastCheckTimestamp field's value.
func (s *StackResourceDriftInformation) SetLastCheckTimestamp(v time.Time) *StackResourceDriftInformation {
	s.LastCheckTimestamp = &v
	return s
}

// SetStackResourceDriftStatus sets the StackResourceDriftStatus field's value.
func (s *StackResourceDriftInformation) SetStackResourceDriftStatus(v string) *StackResourceDriftInformation {
	s.StackResourceDriftStatus = &v
	return s
}

// Summarizes information about whether the resource's actual configuration
// differs, or has drifted, from its expected configuration.
type StackResourceDriftInformationSummary struct {
	_ struct{} `type:"structure"`

	// When AWS CloudFormation last checked if the resource had drifted from its
	// expected configuration.
	LastCheckTimestamp *time.Time `type:"timestamp"`

	// Status of the resource's actual configuration compared to its expected configuration
	//
	//    * DELETED: The resource differs from its expected configuration in that
	//    it has been deleted.
	//
	//    * MODIFIED: The resource differs from its expected configuration.
	//
	//    * NOT_CHECKED: AWS CloudFormation has not checked if the resource differs
	//    from its expected configuration.
	//
	// Any resources that do not currently support drift detection have a status
	//    of NOT_CHECKED. For more information, see Resources that Support Drift
	//    Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//    If you performed an ContinueUpdateRollback operation on a stack, any resources
	//    included in ResourcesToSkip will also have a status of NOT_CHECKED. For
	//    more information on skipping resources during rollback operations, see
	//    Continue Rolling Back an Update (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html)
	//    in the AWS CloudFormation User Guide.
	//
	//    * IN_SYNC: The resources's actual configuration matches its expected configuration.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus *string `type:"string" required:"true" enum:"StackResourceDriftStatus"`
}

// String returns the string representation
func (s StackResourceDriftInformationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceDriftInformationSummary) GoString() string {
	return s.String()
}

// SetLastCheckTimestamp sets the LastCheckTimestamp field's value.
func (s *StackResourceDriftInformationSummary) SetLastCheckTimestamp(v time.Time) *StackResourceDriftInformationSummary {
	s.LastCheckTimestamp = &v
	return s
}

// SetStackResourceDriftStatus sets the StackResourceDriftStatus field's value.
func (s *StackResourceDriftInformationSummary) SetStackResourceDriftStatus(v string) *StackResourceDriftInformationSummary {
	s.StackResourceDriftStatus = &v
	return s
}

// Contains high-level information about the specified stack resource.
type StackResourceSummary struct {
	_ struct{} `type:"structure"`

	// Information about whether the resource's actual configuration differs, or
	// has drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformationSummary `type:"structure"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of the resource.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StackResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceSummary) GoString() string {
	return s.String()
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *StackResourceSummary) SetDriftInformation(v *StackResourceDriftInformationSummary) *StackResourceSummary {
	s.DriftInformation = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *StackResourceSummary) SetLastUpdatedTimestamp(v time.Time) *StackResourceSummary {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResourceSummary) SetLogicalResourceId(v string) *StackResourceSummary {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResourceSummary) SetPhysicalResourceId(v string) *StackResourceSummary {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackResourceSummary) SetResourceStatus(v string) *StackResourceSummary {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackResourceSummary) SetResourceStatusReason(v string) *StackResourceSummary {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResourceSummary) SetResourceType(v string) *StackResourceSummary {
	s.ResourceType = &v
	return s
}

// A structure that contains information about a stack set. A stack set enables
// you to provision stacks into AWS accounts and across regions by using a single
// CloudFormation template. In the stack set, you specify the template to use,
// as well as any parameters and capabilities that the template requires.
type StackSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the IAM role used to create or update
	// the stack set.
	//
	// Use customized administrator roles to control which users or groups can manage
	// specific stack sets within the same administrator account. For more information,
	// see Prerequisites: Granting Permissions for Stack Set Operations (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// The capabilities that are allowed in the stack set. Some stack set templates
	// might include resources that can affect permissions in your AWS account—for
	// example, by creating new AWS Identity and Access Management (IAM) users.
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates. (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities)
	Capabilities []*string `type:"list"`

	// A description of the stack set that you specify when the stack set is created
	// or updated.
	Description *string `min:"1" type:"string"`

	// The name of the IAM execution role used to create or update the stack set.
	//
	// Use customized execution roles to control which stack resources users and
	// groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// A list of input parameters for a stack set.
	Parameters []*Parameter `type:"list"`

	// The Amazon Resource Number (ARN) of the stack set.
	StackSetARN *string `type:"string"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The name that's associated with the stack set.
	StackSetName *string `type:"string"`

	// The status of the stack set.
	Status *string `type:"string" enum:"StackSetStatus"`

	// A list of tags that specify information about the stack set. A maximum number
	// of 50 tags can be specified.
	Tags []*Tag `type:"list"`

	// The structure that contains the body of the template that was used to create
	// or update the stack set.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StackSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSet) GoString() string {
	return s.String()
}

// SetAdministrationRoleARN sets the AdministrationRoleARN field's value.
func (s *StackSet) SetAdministrationRoleARN(v string) *StackSet {
	s.AdministrationRoleARN = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *StackSet) SetCapabilities(v []*string) *StackSet {
	s.Capabilities = v
	return s
}

// SetDescription sets the Description field's value.
func (s *StackSet) SetDescription(v string) *StackSet {
	s.Description = &v
	return s
}

// SetExecutionRoleName sets the ExecutionRoleName field's value.
func (s *StackSet) SetExecutionRoleName(v string) *StackSet {
	s.ExecutionRoleName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *StackSet) SetParameters(v []*Parameter) *StackSet {
	s.Parameters = v
	return s
}

// SetStackSetARN sets the StackSetARN field's value.
func (s *StackSet) SetStackSetARN(v string) *StackSet {
	s.StackSetARN = &v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackSet) SetStackSetId(v string) *StackSet {
	s.StackSetId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *StackSet) SetStackSetName(v string) *StackSet {
	s.StackSetName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSet) SetStatus(v string) *StackSet {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StackSet) SetTags(v []*Tag) *StackSet {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *StackSet) SetTemplateBody(v string) *StackSet {
	s.TemplateBody = &v
	return s
}

// The structure that contains information about a stack set operation.
type StackSetOperation struct {
	_ struct{} `type:"structure"`

	// The type of stack set operation: CREATE, UPDATE, or DELETE. Create and delete
	// operations affect only the specified stack set instances that are associated
	// with the specified stack set. Update operations affect both the stack set
	// itself, as well as all associated stack set instances.
	Action *string `type:"string" enum:"StackSetOperationAction"`

	// The Amazon Resource Number (ARN) of the IAM role used to perform this stack
	// set operation.
	//
	// Use customized administrator roles to control which users or groups can manage
	// specific stack sets within the same administrator account. For more information,
	// see Define Permissions for Multiple Administrators (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// The time at which the operation was initiated. Note that the creation times
	// for the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because AWS CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The time at which the stack set operation ended, across all accounts and
	// regions specified. Note that this doesn't necessarily mean that the stack
	// set operation was successful, or even attempted, in each account or region.
	EndTimestamp *time.Time `type:"timestamp"`

	// The name of the IAM execution role used to create or update the stack set.
	//
	// Use customized execution roles to control which stack resources users and
	// groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// The unique ID of a stack set operation.
	OperationId *string `min:"1" type:"string"`

	// The preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// For stack set operations of action type DELETE, specifies whether to remove
	// the stack instances from the specified stack set, but doesn't delete the
	// stacks. You can't reassociate a retained stack, or add an existing, saved
	// stack to a new stack set.
	RetainStacks *bool `type:"boolean"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The status of the operation.
	//
	//    * FAILED: The operation exceeded the specified failure tolerance. The
	//    failure tolerance value that you've set for an operation is applied for
	//    each region during stack create and update operations. If the number of
	//    failed stacks within a region exceeds the failure tolerance, the status
	//    of the operation in the region is set to FAILED. This in turn sets the
	//    status of the operation as a whole to FAILED, and AWS CloudFormation cancels
	//    the operation in any remaining regions.
	//
	//    * RUNNING: The operation is currently being performed.
	//
	//    * STOPPED: The user has cancelled the operation.
	//
	//    * STOPPING: The operation is in the process of stopping, at user request.
	//
	//
	//    * SUCCEEDED: The operation completed creating or updating all the specified
	//    stacks without exceeding the failure tolerance for the operation.
	Status *string `type:"string" enum:"StackSetOperationStatus"`
}

// String returns the string representation
func (s StackSetOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetOperation) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *StackSetOperation) SetAction(v string) *StackSetOperation {
	s.Action = &v
	return s
}

// SetAdministrationRoleARN sets the AdministrationRoleARN field's value.
func (s *StackSetOperation) SetAdministrationRoleARN(v string) *StackSetOperation {
	s.AdministrationRoleARN = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *StackSetOperation) SetCreationTimestamp(v time.Time) *StackSetOperation {
	s.CreationTimestamp = &v
	return s
}

// SetEndTimestamp sets the EndTimestamp field's value.
func (s *StackSetOperation) SetEndTimestamp(v time.Time) *StackSetOperation {
	s.EndTimestamp = &v
	return s
}

// SetExecutionRoleName sets the ExecutionRoleName field's value.
func (s *StackSetOperation) SetExecutionRoleName(v string) *StackSetOperation {
	s.ExecutionRoleName = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *StackSetOperation) SetOperationId(v string) *StackSetOperation {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *StackSetOperation) SetOperationPreferences(v *StackSetOperationPreferences) *StackSetOperation {
	s.OperationPreferences = v
	return s
}

// SetRetainStacks sets the RetainStacks field's value.
func (s *StackSetOperation) SetRetainStacks(v bool) *StackSetOperation {
	s.RetainStacks = &v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackSetOperation) SetStackSetId(v string) *StackSetOperation {
	s.StackSetId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSetOperation) SetStatus(v string) *StackSetOperation {
	s.Status = &v
	return s
}

// The user-specified preferences for how AWS CloudFormation performs a stack
// set operation.
//
// For more information on maximum concurrent accounts and failure tolerance,
// see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
type StackSetOperationPreferences struct {
	_ struct{} `type:"structure"`

	// The number of accounts, per region, for which this operation can fail before
	// AWS CloudFormation stops the operation in that region. If the operation is
	// stopped in a region, AWS CloudFormation doesn't attempt the operation in
	// any subsequent regions.
	//
	// Conditional: You must specify either FailureToleranceCount or FailureTolerancePercentage
	// (but not both).
	FailureToleranceCount *int64 `type:"integer"`

	// The percentage of accounts, per region, for which this stack operation can
	// fail before AWS CloudFormation stops the operation in that region. If the
	// operation is stopped in a region, AWS CloudFormation doesn't attempt the
	// operation in any subsequent regions.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS CloudFormation rounds down to the next whole number.
	//
	// Conditional: You must specify either FailureToleranceCount or FailureTolerancePercentage,
	// but not both.
	FailureTolerancePercentage *int64 `type:"integer"`

	// The maximum number of accounts in which to perform this operation at one
	// time. This is dependent on the value of FailureToleranceCount—MaxConcurrentCount
	// is at most one more than the FailureToleranceCount .
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Conditional: You must specify either MaxConcurrentCount or MaxConcurrentPercentage,
	// but not both.
	MaxConcurrentCount *int64 `min:"1" type:"integer"`

	// The maximum percentage of accounts in which to perform this operation at
	// one time.
	//
	// When calculating the number of accounts based on the specified percentage,
	// AWS CloudFormation rounds down to the next whole number. This is true except
	// in cases where rounding down would result is zero. In this case, CloudFormation
	// sets the number as one instead.
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Conditional: You must specify either MaxConcurrentCount or MaxConcurrentPercentage,
	// but not both.
	MaxConcurrentPercentage *int64 `min:"1" type:"integer"`

	// The order of the regions in where you want to perform the stack operation.
	RegionOrder []*string `type:"list"`
}

// String returns the string representation
func (s StackSetOperationPreferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetOperationPreferences) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StackSetOperationPreferences) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StackSetOperationPreferences"}
	if s.MaxConcurrentCount != nil && *s.MaxConcurrentCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConcurrentCount", 1))
	}
	if s.MaxConcurrentPercentage != nil && *s.MaxConcurrentPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConcurrentPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureToleranceCount sets the FailureToleranceCount field's value.
func (s *StackSetOperationPreferences) SetFailureToleranceCount(v int64) *StackSetOperationPreferences {
	s.FailureToleranceCount = &v
	return s
}

// SetFailureTolerancePercentage sets the FailureTolerancePercentage field's value.
func (s *StackSetOperationPreferences) SetFailureTolerancePercentage(v int64) *StackSetOperationPreferences {
	s.FailureTolerancePercentage = &v
	return s
}

// SetMaxConcurrentCount sets the MaxConcurrentCount field's value.
func (s *StackSetOperationPreferences) SetMaxConcurrentCount(v int64) *StackSetOperationPreferences {
	s.MaxConcurrentCount = &v
	return s
}

// SetMaxConcurrentPercentage sets the MaxConcurrentPercentage field's value.
func (s *StackSetOperationPreferences) SetMaxConcurrentPercentage(v int64) *StackSetOperationPreferences {
	s.MaxConcurrentPercentage = &v
	return s
}

// SetRegionOrder sets the RegionOrder field's value.
func (s *StackSetOperationPreferences) SetRegionOrder(v []*string) *StackSetOperationPreferences {
	s.RegionOrder = v
	return s
}

// The structure that contains information about a specified operation's results
// for a given account in a given region.
type StackSetOperationResultSummary struct {
	_ struct{} `type:"structure"`

	// The name of the AWS account for this operation result.
	Account *string `type:"string"`

	// The results of the account gate function AWS CloudFormation invokes, if present,
	// before proceeding with stack set operations in an account
	AccountGateResult *AccountGateResult `type:"structure"`

	// The name of the AWS region for this operation result.
	Region *string `type:"string"`

	// The result status of the stack set operation for the given account in the
	// given region.
	//
	//    * CANCELLED: The operation in the specified account and region has been
	//    cancelled. This is either because a user has stopped the stack set operation,
	//    or because the failure tolerance of the stack set operation has been exceeded.
	//
	//    * FAILED: The operation in the specified account and region failed.
	//
	// If the stack set operation fails in enough accounts within a region, the
	//    failure tolerance for the stack set operation as a whole might be exceeded.
	//
	//
	//    * RUNNING: The operation in the specified account and region is currently
	//    in progress.
	//
	//    * PENDING: The operation in the specified account and region has yet to
	//    start.
	//
	//    * SUCCEEDED: The operation in the specified account and region completed
	//    successfully.
	Status *string `type:"string" enum:"StackSetOperationResultStatus"`

	// The reason for the assigned result status.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s StackSetOperationResultSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetOperationResultSummary) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *StackSetOperationResultSummary) SetAccount(v string) *StackSetOperationResultSummary {
	s.Account = &v
	return s
}

// SetAccountGateResult sets the AccountGateResult field's value.
func (s *StackSetOperationResultSummary) SetAccountGateResult(v *AccountGateResult) *StackSetOperationResultSummary {
	s.AccountGateResult = v
	return s
}

// SetRegion sets the Region field's value.
func (s *StackSetOperationResultSummary) SetRegion(v string) *StackSetOperationResultSummary {
	s.Region = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSetOperationResultSummary) SetStatus(v string) *StackSetOperationResultSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *StackSetOperationResultSummary) SetStatusReason(v string) *StackSetOperationResultSummary {
	s.StatusReason = &v
	return s
}

// The structures that contain summary information about the specified operation.
type StackSetOperationSummary struct {
	_ struct{} `type:"structure"`

	// The type of operation: CREATE, UPDATE, or DELETE. Create and delete operations
	// affect only the specified stack instances that are associated with the specified
	// stack set. Update operations affect both the stack set itself as well as
	// all associated stack set instances.
	Action *string `type:"string" enum:"StackSetOperationAction"`

	// The time at which the operation was initiated. Note that the creation times
	// for the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because AWS CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The time at which the stack set operation ended, across all accounts and
	// regions specified. Note that this doesn't necessarily mean that the stack
	// set operation was successful, or even attempted, in each account or region.
	EndTimestamp *time.Time `type:"timestamp"`

	// The unique ID of the stack set operation.
	OperationId *string `min:"1" type:"string"`

	// The overall status of the operation.
	//
	//    * FAILED: The operation exceeded the specified failure tolerance. The
	//    failure tolerance value that you've set for an operation is applied for
	//    each region during stack create and update operations. If the number of
	//    failed stacks within a region exceeds the failure tolerance, the status
	//    of the operation in the region is set to FAILED. This in turn sets the
	//    status of the operation as a whole to FAILED, and AWS CloudFormation cancels
	//    the operation in any remaining regions.
	//
	//    * RUNNING: The operation is currently being performed.
	//
	//    * STOPPED: The user has cancelled the operation.
	//
	//    * STOPPING: The operation is in the process of stopping, at user request.
	//
	//
	//    * SUCCEEDED: The operation completed creating or updating all the specified
	//    stacks without exceeding the failure tolerance for the operation.
	Status *string `type:"string" enum:"StackSetOperationStatus"`
}

// String returns the string representation
func (s StackSetOperationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetOperationSummary) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *StackSetOperationSummary) SetAction(v string) *StackSetOperationSummary {
	s.Action = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *StackSetOperationSummary) SetCreationTimestamp(v time.Time) *StackSetOperationSummary {
	s.CreationTimestamp = &v
	return s
}

// SetEndTimestamp sets the EndTimestamp field's value.
func (s *StackSetOperationSummary) SetEndTimestamp(v time.Time) *StackSetOperationSummary {
	s.EndTimestamp = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *StackSetOperationSummary) SetOperationId(v string) *StackSetOperationSummary {
	s.OperationId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSetOperationSummary) SetStatus(v string) *StackSetOperationSummary {
	s.Status = &v
	return s
}

// The structures that contain summary information about the specified stack
// set.
type StackSetSummary struct {
	_ struct{} `type:"structure"`

	// A description of the stack set that you specify when the stack set is created
	// or updated.
	Description *string `min:"1" type:"string"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The name of the stack set.
	StackSetName *string `type:"string"`

	// The status of the stack set.
	Status *string `type:"string" enum:"StackSetStatus"`
}

// String returns the string representation
func (s StackSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSetSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StackSetSummary) SetDescription(v string) *StackSetSummary {
	s.Description = &v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackSetSummary) SetStackSetId(v string) *StackSetSummary {
	s.StackSetId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *StackSetSummary) SetStackSetName(v string) *StackSetSummary {
	s.StackSetName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSetSummary) SetStatus(v string) *StackSetSummary {
	s.Status = &v
	return s
}

// The StackSummary Data Type
type StackSummary struct {
	_ struct{} `type:"structure"`

	// The time the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp"`

	// Summarizes information on whether a stack's actual configuration differs,
	// or has drifted, from it's expected configuration, as defined in the stack
	// template and any values specified as template parameters. For more information,
	// see Detecting Unregulated Configuration Changes to Stacks and Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackDriftInformationSummary `type:"structure"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the direct parent of this stack. For the first level of nested stacks,
	// the root stack is also the parent stack.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	ParentId *string `type:"string"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the the top-level stack to which the nested stack ultimately belongs.
	//
	// For more information, see Working with Nested Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the AWS CloudFormation User Guide.
	RootId *string `type:"string"`

	// Unique stack identifier.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// The current status of the stack.
	//
	// StackStatus is a required field
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/Failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// The template description of the template used to create the stack.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *StackSummary) SetCreationTime(v time.Time) *StackSummary {
	s.CreationTime = &v
	return s
}

// SetDeletionTime sets the DeletionTime field's value.
func (s *StackSummary) SetDeletionTime(v time.Time) *StackSummary {
	s.DeletionTime = &v
	return s
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *StackSummary) SetDriftInformation(v *StackDriftInformationSummary) *StackSummary {
	s.DriftInformation = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *StackSummary) SetLastUpdatedTime(v time.Time) *StackSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *StackSummary) SetParentId(v string) *StackSummary {
	s.ParentId = &v
	return s
}

// SetRootId sets the RootId field's value.
func (s *StackSummary) SetRootId(v string) *StackSummary {
	s.RootId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackSummary) SetStackId(v string) *StackSummary {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackSummary) SetStackName(v string) *StackSummary {
	s.StackName = &v
	return s
}

// SetStackStatus sets the StackStatus field's value.
func (s *StackSummary) SetStackStatus(v string) *StackSummary {
	s.StackStatus = &v
	return s
}

// SetStackStatusReason sets the StackStatusReason field's value.
func (s *StackSummary) SetStackStatusReason(v string) *StackSummary {
	s.StackStatusReason = &v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *StackSummary) SetTemplateDescription(v string) *StackSummary {
	s.TemplateDescription = &v
	return s
}

type StopStackSetOperationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the stack operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or unique ID of the stack set that you want to stop the operation
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopStackSetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStackSetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStackSetOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopStackSetOperationInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperationId sets the OperationId field's value.
func (s *StopStackSetOperationInput) SetOperationId(v string) *StopStackSetOperationInput {
	s.OperationId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *StopStackSetOperationInput) SetStackSetName(v string) *StopStackSetOperationInput {
	s.StackSetName = &v
	return s
}

type StopStackSetOperationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopStackSetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStackSetOperationOutput) GoString() string {
	return s.String()
}

// The Tag type enables you to specify a key-value pair that can be used to
// store information about an AWS CloudFormation stack.
type Tag struct {
	_ struct{} `type:"structure"`

	// Required. A string used to identify this tag. You can specify a maximum of
	// 128 characters for a tag key. Tags owned by Amazon Web Services (AWS) have
	// the reserved prefix: aws:.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Required. A string containing the value for this tag. You can specify a maximum
	// of 256 characters for a tag value.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The TemplateParameter data type.
type TemplateParameter struct {
	_ struct{} `type:"structure"`

	// The default value associated with the parameter.
	DefaultValue *string `type:"string"`

	// User defined description associated with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag indicating whether the parameter should be displayed as plain text in
	// logs and UIs.
	NoEcho *bool `type:"boolean"`

	// The name associated with the parameter.
	ParameterKey *string `type:"string"`
}

// String returns the string representation
func (s TemplateParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateParameter) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *TemplateParameter) SetDefaultValue(v string) *TemplateParameter {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TemplateParameter) SetDescription(v string) *TemplateParameter {
	s.Description = &v
	return s
}

// SetNoEcho sets the NoEcho field's value.
func (s *TemplateParameter) SetNoEcho(v bool) *TemplateParameter {
	s.NoEcho = &v
	return s
}

// SetParameterKey sets the ParameterKey field's value.
func (s *TemplateParameter) SetParameterKey(v string) *TemplateParameter {
	s.ParameterKey = &v
	return s
}

// The input for an UpdateStack action.
type UpdateStackInput struct {
	_ struct{} `type:"structure"`

	// In some cases, you must explicity acknowledge that your stack template contains
	// certain capabilities in order for AWS CloudFormation to update the stack.
	//
	//    * CAPABILITY_IAM and CAPABILITY_NAMED_IAM
	//
	// Some stack templates might include resources that can affect permissions
	//    in your AWS account; for example, by creating new AWS Identity and Access
	//    Management (IAM) users. For those stacks, you must explicitly acknowledge
	//    this by specifying one of these capabilities.
	//
	// The following IAM resources require you to specify either the CAPABILITY_IAM
	//    or CAPABILITY_NAMED_IAM capability.
	//
	// If you have IAM resources, you can specify either capability.
	//
	// If you have IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.
	//
	//
	// If you don't specify either of these capabilities, AWS CloudFormation returns
	//    an InsufficientCapabilities error.
	//
	// If your stack template contains these resources, we recommend that you review
	//    all permissions associated with them and edit their permissions if necessary.
	//
	//  AWS::IAM::AccessKey (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
	//
	//  AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
	//
	//  AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
	//
	//  AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
	//
	//  AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
	//
	//  AWS::IAM::User (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
	//
	//  AWS::IAM::UserToGroupAddition (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	//    Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	//
	//    * CAPABILITY_AUTO_EXPAND
	//
	// Some template contain macros. Macros perform custom processing on templates;
	//    this can include simple actions like find-and-replace operations, all
	//    the way to extensive transformations of entire templates. Because of this,
	//    users typically create a change set from the processed template, so that
	//    they can review the changes resulting from the macros before actually
	//    updating the stack. If your stack template contains one or more macros,
	//    and you choose to update a stack directly from the processed template,
	//    without first reviewing the resulting changes in a change set, you must
	//    acknowledge this capability. This includes the AWS::Include (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
	//    and AWS::Serverless (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
	//    transforms, which are macros hosted by AWS CloudFormation.
	//
	// Change sets do not currently support nested stacks. If you want to update
	//    a stack from a stack template that contains macros and nested stacks,
	//    you must update the stack directly from the template using this capability.
	//
	// You should only update stacks directly from a stack template that contains
	//    macros if you know what processing the macro performs.
	//
	// Each macro relies on an underlying Lambda service function for processing
	//    stack templates. Be aware that the Lambda function owner can update the
	//    function operation without AWS CloudFormation being notified.
	//
	// For more information, see Using AWS CloudFormation Macros to Perform Custom
	//    Processing on Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
	Capabilities []*string `type:"list"`

	// A unique identifier for this UpdateStack request. Specify this token if you
	// plan to retry requests so that AWS CloudFormation knows that you're not attempting
	// to update a stack with the same name. You might retry UpdateStack requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
	// AWS CloudFormation associates with the stack. Specify an empty list to remove
	// all notification topics.
	NotificationARNs []*string `type:"list"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with for this
	// update stack action, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	//
	// If the list of resource types doesn't include a resource that you're updating,
	// the stack update fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for AWS CloudFormation-specific condition keys in IAM policies.
	// For more information, see Controlling Access with AWS Identity and Access
	// Management (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
	ResourceTypes []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to update the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// always uses this role for all future operations on the stack. As long as
	// users have permission to operate on the stack, AWS CloudFormation uses this
	// role even if the users don't have permission to pass it. Ensure that the
	// role grants least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for AWS CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The name or unique stack ID of the stack to update.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing a new stack policy body. You can specify either the
	// StackPolicyBody or the StackPolicyURL parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyBody *string `min:"1" type:"string"`

	// Structure containing the temporary overriding stack policy body. You can
	// specify either the StackPolicyDuringUpdateBody or the StackPolicyDuringUpdateURL
	// parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateBody *string `min:"1" type:"string"`

	// Location of a file containing the temporary overriding stack policy. The
	// URL must point to a policy (max size: 16KB) located in an S3 bucket in the
	// same region as the stack. You can specify either the StackPolicyDuringUpdateBody
	// or the StackPolicyDuringUpdateURL parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateURL *string `min:"1" type:"string"`

	// Location of a file containing the updated stack policy. The URL must point
	// to a policy (max size: 16KB) located in an S3 bucket in the same region as
	// the stack. You can specify either the StackPolicyBody or the StackPolicyURL
	// parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyURL *string `min:"1" type:"string"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to supported resources in the stack. You can specify a maximum
	// number of 50 tags.
	//
	// If you don't specify this parameter, AWS CloudFormation doesn't modify the
	// stack's tags. If you specify an empty value, AWS CloudFormation removes all
	// associated tags.
	Tags []*Tag `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody,
	// TemplateURL, or set the UsePreviousTemplate to true.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// that is located in an Amazon S3 bucket. For more information, go to Template
	// Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody,
	// TemplateURL, or set the UsePreviousTemplate to true.
	TemplateURL *string `min:"1" type:"string"`

	// Reuse the existing template that is associated with the stack that you are
	// updating.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody,
	// TemplateURL, or set the UsePreviousTemplate to true.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyDuringUpdateBody != nil && len(*s.StackPolicyDuringUpdateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyDuringUpdateBody", 1))
	}
	if s.StackPolicyDuringUpdateURL != nil && len(*s.StackPolicyDuringUpdateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyDuringUpdateURL", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyURL", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.RollbackConfiguration != nil {
		if err := s.RollbackConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RollbackConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *UpdateStackInput) SetCapabilities(v []*string) *UpdateStackInput {
	s.Capabilities = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateStackInput) SetClientRequestToken(v string) *UpdateStackInput {
	s.ClientRequestToken = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *UpdateStackInput) SetNotificationARNs(v []*string) *UpdateStackInput {
	s.NotificationARNs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateStackInput) SetParameters(v []*Parameter) *UpdateStackInput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *UpdateStackInput) SetResourceTypes(v []*string) *UpdateStackInput {
	s.ResourceTypes = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *UpdateStackInput) SetRoleARN(v string) *UpdateStackInput {
	s.RoleARN = &v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *UpdateStackInput) SetRollbackConfiguration(v *RollbackConfiguration) *UpdateStackInput {
	s.RollbackConfiguration = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *UpdateStackInput) SetStackName(v string) *UpdateStackInput {
	s.StackName = &v
	return s
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *UpdateStackInput) SetStackPolicyBody(v string) *UpdateStackInput {
	s.StackPolicyBody = &v
	return s
}

// SetStackPolicyDuringUpdateBody sets the StackPolicyDuringUpdateBody field's value.
func (s *UpdateStackInput) SetStackPolicyDuringUpdateBody(v string) *UpdateStackInput {
	s.StackPolicyDuringUpdateBody = &v
	return s
}

// SetStackPolicyDuringUpdateURL sets the StackPolicyDuringUpdateURL field's value.
func (s *UpdateStackInput) SetStackPolicyDuringUpdateURL(v string) *UpdateStackInput {
	s.StackPolicyDuringUpdateURL = &v
	return s
}

// SetStackPolicyURL sets the StackPolicyURL field's value.
func (s *UpdateStackInput) SetStackPolicyURL(v string) *UpdateStackInput {
	s.StackPolicyURL = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateStackInput) SetTags(v []*Tag) *UpdateStackInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *UpdateStackInput) SetTemplateBody(v string) *UpdateStackInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *UpdateStackInput) SetTemplateURL(v string) *UpdateStackInput {
	s.TemplateURL = &v
	return s
}

// SetUsePreviousTemplate sets the UsePreviousTemplate field's value.
func (s *UpdateStackInput) SetUsePreviousTemplate(v bool) *UpdateStackInput {
	s.UsePreviousTemplate = &v
	return s
}

type UpdateStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of one or more AWS accounts for which you want to update parameter
	// values for stack instances. The overridden parameter values will be applied
	// to all stack instances in the specified accounts and regions.
	//
	// Accounts is a required field
	Accounts []*string `type:"list" required:"true"`

	// The unique identifier for this stack set operation.
	//
	// The operation ID also functions as an idempotency token, to ensure that AWS
	// CloudFormation performs the stack set operation only once, even if you retry
	// the request multiple times. You might retry stack set operation requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// A list of input parameters whose values you want to update for the specified
	// stack instances.
	//
	// Any overridden parameter values will be applied to all stack instances in
	// the specified accounts and regions. When specifying parameters and their
	// values, be aware of how AWS CloudFormation sets parameter values during stack
	// instance update operations:
	//
	//    * To override the current value for a parameter, include the parameter
	//    and specify its value.
	//
	//    * To leave a parameter set to its present value, you can do one of the
	//    following:
	//
	// Do not include the parameter in the list.
	//
	// Include the parameter and specify UsePreviousValue as true. (You cannot specify
	//    both a value and set UsePreviousValue to true.)
	//
	//    * To set all overridden parameter back to the values specified in the
	//    stack set, specify a parameter list but do not include any parameters.
	//
	//    * To leave all parameters set to their present values, do not specify
	//    this property at all.
	//
	// During stack set updates, any parameter values overridden for a stack instance
	// are not updated, but retain their overridden value.
	//
	// You can only override the parameter values that are specified in the stack
	// set; to add or delete a parameter itself, use UpdateStackSet to update the
	// stack set template. If you add a parameter to a template, before you can
	// override the parameter value specified in the stack set you must first use
	// UpdateStackSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
	// to update all stack instances with the updated template and parameter value
	// specified in the stack set. Once a stack instance has been updated with the
	// new parameter, you can then override the parameter value using UpdateStackInstances.
	ParameterOverrides []*Parameter `type:"list"`

	// The names of one or more regions in which you want to update parameter values
	// for stack instances. The overridden parameter values will be applied to all
	// stack instances in the specified accounts and regions.
	//
	// Regions is a required field
	Regions []*string `type:"list" required:"true"`

	// The name or unique ID of the stack set associated with the stack instances.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStackInstancesInput"}
	if s.Accounts == nil {
		invalidParams.Add(request.NewErrParamRequired("Accounts"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.Regions == nil {
		invalidParams.Add(request.NewErrParamRequired("Regions"))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *UpdateStackInstancesInput) SetAccounts(v []*string) *UpdateStackInstancesInput {
	s.Accounts = v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *UpdateStackInstancesInput) SetOperationId(v string) *UpdateStackInstancesInput {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *UpdateStackInstancesInput) SetOperationPreferences(v *StackSetOperationPreferences) *UpdateStackInstancesInput {
	s.OperationPreferences = v
	return s
}

// SetParameterOverrides sets the ParameterOverrides field's value.
func (s *UpdateStackInstancesInput) SetParameterOverrides(v []*Parameter) *UpdateStackInstancesInput {
	s.ParameterOverrides = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *UpdateStackInstancesInput) SetRegions(v []*string) *UpdateStackInstancesInput {
	s.Regions = v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *UpdateStackInstancesInput) SetStackSetName(v string) *UpdateStackInstancesInput {
	s.StackSetName = &v
	return s
}

type UpdateStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInstancesOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *UpdateStackInstancesOutput) SetOperationId(v string) *UpdateStackInstancesOutput {
	s.OperationId = &v
	return s
}

// The output for an UpdateStack action.
type UpdateStackOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *UpdateStackOutput) SetStackId(v string) *UpdateStackOutput {
	s.StackId = &v
	return s
}

type UpdateStackSetInput struct {
	_ struct{} `type:"structure"`

	// The accounts in which to update associated stack instances. If you specify
	// accounts, you must also specify the regions in which to update stack set
	// instances.
	//
	// To update all the stack instances associated with this stack set, do not
	// specify the Accounts or Regions properties.
	//
	// If the stack set update includes changes to the template (that is, if the
	// TemplateBody or TemplateURL properties are specified), or the Parameters
	// property, AWS CloudFormation marks all stack instances with a status of OUTDATED
	// prior to updating the stack instances in the specified accounts and regions.
	// If the stack set update does not include changes to the template or parameters,
	// AWS CloudFormation updates the stack instances in the specified accounts
	// and regions, while leaving all other stack instances with their existing
	// stack instance status.
	Accounts []*string `type:"list"`

	// The Amazon Resource Number (ARN) of the IAM role to use to update this stack
	// set.
	//
	// Specify an IAM role only if you are using customized administrator roles
	// to control which users or groups can manage specific stack sets within the
	// same administrator account. For more information, see Granting Permissions
	// for Stack Set Operations (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the AWS CloudFormation User Guide.
	//
	// If you specified a customized administrator role when you created the stack
	// set, you must specify a customized administrator role, even if it is the
	// same customized administrator role used with this stack set previously.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// In some cases, you must explicity acknowledge that your stack template contains
	// certain capabilities in order for AWS CloudFormation to update the stack
	// set and its associated stack instances.
	//
	//    * CAPABILITY_IAM and CAPABILITY_NAMED_IAM
	//
	// Some stack templates might include resources that can affect permissions
	//    in your AWS account; for example, by creating new AWS Identity and Access
	//    Management (IAM) users. For those stacks sets, you must explicitly acknowledge
	//    this by specifying one of these capabilities.
	//
	// The following IAM resources require you to specify either the CAPABILITY_IAM
	//    or CAPABILITY_NAMED_IAM capability.
	//
	// If you have IAM resources, you can specify either capability.
	//
	// If you have IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.
	//
	//
	// If you don't specify either of these capabilities, AWS CloudFormation returns
	//    an InsufficientCapabilities error.
	//
	// If your stack template contains these resources, we recommend that you review
	//    all permissions associated with them and edit their permissions if necessary.
	//
	//  AWS::IAM::AccessKey (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
	//
	//  AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
	//
	//  AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
	//
	//  AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
	//
	//  AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
	//
	//  AWS::IAM::User (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
	//
	//  AWS::IAM::UserToGroupAddition (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	//    Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	//
	//    * CAPABILITY_AUTO_EXPAND
	//
	// Some templates contain macros. If your stack template contains one or more
	//    macros, and you choose to update a stack directly from the processed template,
	//    without first reviewing the resulting changes in a change set, you must
	//    acknowledge this capability. For more information, see Using AWS CloudFormation
	//    Macros to Perform Custom Processing on Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
	//
	// Stack sets do not currently support macros in stack templates. (This includes
	//    the AWS::Include (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
	//    and AWS::Serverless (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
	//    transforms, which are macros hosted by AWS CloudFormation.) Even if you
	//    specify this capability, if you include a macro in your template the stack
	//    set operation will fail.
	Capabilities []*string `type:"list"`

	// A brief description of updates that you are making.
	Description *string `min:"1" type:"string"`

	// The name of the IAM execution role to use to update the stack set. If you
	// do not specify an execution role, AWS CloudFormation uses the AWSCloudFormationStackSetExecutionRole
	// role for the stack set operation.
	//
	// Specify an IAM role only if you are using customized execution roles to control
	// which stack resources users and groups can include in their stack sets.
	//
	// If you specify a customized execution role, AWS CloudFormation uses that
	// role to update the stack. If you do not specify a customized execution role,
	// AWS CloudFormation performs the update using the role previously associated
	// with the stack set, so long as you have permissions to perform operations
	// on the stack set.
	ExecutionRoleName *string `min:"1" type:"string"`

	// The unique ID for this stack set operation.
	//
	// The operation ID also functions as an idempotency token, to ensure that AWS
	// CloudFormation performs the stack set operation only once, even if you retry
	// the request multiple times. You might retry stack set operation requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// If you don't specify an operation ID, AWS CloudFormation generates one automatically.
	//
	// Repeating this stack set operation with a new operation ID retries all stack
	// instances whose status is OUTDATED.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// A list of input parameters for the stack set template.
	Parameters []*Parameter `type:"list"`

	// The regions in which to update associated stack instances. If you specify
	// regions, you must also specify accounts in which to update stack set instances.
	//
	// To update all the stack instances associated with this stack set, do not
	// specify the Accounts or Regions properties.
	//
	// If the stack set update includes changes to the template (that is, if the
	// TemplateBody or TemplateURL properties are specified), or the Parameters
	// property, AWS CloudFormation marks all stack instances with a status of OUTDATED
	// prior to updating the stack instances in the specified accounts and regions.
	// If the stack set update does not include changes to the template or parameters,
	// AWS CloudFormation updates the stack instances in the specified accounts
	// and regions, while leaving all other stack instances with their existing
	// stack instance status.
	Regions []*string `type:"list"`

	// The name or unique ID of the stack set that you want to update.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`

	// The key-value pairs to associate with this stack set and the stacks created
	// from it. AWS CloudFormation also propagates these tags to supported resources
	// that are created in the stacks. You can specify a maximum number of 50 tags.
	//
	// If you specify tags for this parameter, those tags replace any list of tags
	// that are currently associated with this stack set. This means:
	//
	//    * If you don't specify this parameter, AWS CloudFormation doesn't modify
	//    the stack's tags.
	//
	//    * If you specify any tags using this parameter, you must specify all the
	//    tags that you want associated with this stack set, even tags you've specifed
	//    before (for example, when creating the stack set or during a previous
	//    update of the stack set.). Any tags that you don't include in the updated
	//    list of tags are removed from the stack set, and therefore from the stacks
	//    and resources as well.
	//
	//    * If you specify an empty value, AWS CloudFormation removes all currently
	//    associated tags.
	//
	// If you specify new tags as part of an UpdateStackSet action, AWS CloudFormation
	// checks to see if you have the required IAM permission to tag resources. If
	// you omit tags that are currently associated with the stack set from the list
	// of tags you specify, AWS CloudFormation assumes that you want to remove those
	// tags from the stack set, and checks to see if you have permission to untag
	// resources. If you don't have the necessary permission(s), the entire UpdateStackSet
	// action fails with an access denied error, and the stack set is not updated.
	Tags []*Tag `type:"list"`

	// The structure that contains the template body, with a minimum length of 1
	// byte and a maximum length of 51,200 bytes. For more information, see Template
	// Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody
	// or TemplateURL—or set UsePreviousTemplate to true.
	TemplateBody *string `min:"1" type:"string"`

	// The location of the file that contains the template body. The URL must point
	// to a template (maximum size: 460,800 bytes) that is located in an Amazon
	// S3 bucket. For more information, see Template Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody
	// or TemplateURL—or set UsePreviousTemplate to true.
	TemplateURL *string `min:"1" type:"string"`

	// Use the existing template that's associated with the stack set that you're
	// updating.
	//
	// Conditional: You must specify only one of the following parameters: TemplateBody
	// or TemplateURL—or set UsePreviousTemplate to true.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStackSetInput"}
	if s.AdministrationRoleARN != nil && len(*s.AdministrationRoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AdministrationRoleARN", 20))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ExecutionRoleName != nil && len(*s.ExecutionRoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleName", 1))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *UpdateStackSetInput) SetAccounts(v []*string) *UpdateStackSetInput {
	s.Accounts = v
	return s
}

// SetAdministrationRoleARN sets the AdministrationRoleARN field's value.
func (s *UpdateStackSetInput) SetAdministrationRoleARN(v string) *UpdateStackSetInput {
	s.AdministrationRoleARN = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *UpdateStackSetInput) SetCapabilities(v []*string) *UpdateStackSetInput {
	s.Capabilities = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateStackSetInput) SetDescription(v string) *UpdateStackSetInput {
	s.Description = &v
	return s
}

// SetExecutionRoleName sets the ExecutionRoleName field's value.
func (s *UpdateStackSetInput) SetExecutionRoleName(v string) *UpdateStackSetInput {
	s.ExecutionRoleName = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *UpdateStackSetInput) SetOperationId(v string) *UpdateStackSetInput {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *UpdateStackSetInput) SetOperationPreferences(v *StackSetOperationPreferences) *UpdateStackSetInput {
	s.OperationPreferences = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateStackSetInput) SetParameters(v []*Parameter) *UpdateStackSetInput {
	s.Parameters = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *UpdateStackSetInput) SetRegions(v []*string) *UpdateStackSetInput {
	s.Regions = v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *UpdateStackSetInput) SetStackSetName(v string) *UpdateStackSetInput {
	s.StackSetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateStackSetInput) SetTags(v []*Tag) *UpdateStackSetInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *UpdateStackSetInput) SetTemplateBody(v string) *UpdateStackSetInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *UpdateStackSetInput) SetTemplateURL(v string) *UpdateStackSetInput {
	s.TemplateURL = &v
	return s
}

// SetUsePreviousTemplate sets the UsePreviousTemplate field's value.
func (s *UpdateStackSetInput) SetUsePreviousTemplate(v bool) *UpdateStackSetInput {
	s.UsePreviousTemplate = &v
	return s
}

type UpdateStackSetOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackSetOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *UpdateStackSetOutput) SetOperationId(v string) *UpdateStackSetOutput {
	s.OperationId = &v
	return s
}

type UpdateTerminationProtectionInput struct {
	_ struct{} `type:"structure"`

	// Whether to enable termination protection on the specified stack.
	//
	// EnableTerminationProtection is a required field
	EnableTerminationProtection *bool `type:"boolean" required:"true"`

	// The name or unique ID of the stack for which you want to set termination
	// protection.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTerminationProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTerminationProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTerminationProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTerminationProtectionInput"}
	if s.EnableTerminationProtection == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableTerminationProtection"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableTerminationProtection sets the EnableTerminationProtection field's value.
func (s *UpdateTerminationProtectionInput) SetEnableTerminationProtection(v bool) *UpdateTerminationProtectionInput {
	s.EnableTerminationProtection = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *UpdateTerminationProtectionInput) SetStackName(v string) *UpdateTerminationProtectionInput {
	s.StackName = &v
	return s
}

type UpdateTerminationProtectionOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s UpdateTerminationProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTerminationProtectionOutput) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *UpdateTerminationProtectionOutput) SetStackId(v string) *UpdateTerminationProtectionOutput {
	s.StackId = &v
	return s
}

// The input for ValidateTemplate action.
type ValidateTemplateInput struct {
	_ struct{} `type:"structure"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information, go to Template Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ValidateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateTemplateInput"}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *ValidateTemplateInput) SetTemplateBody(v string) *ValidateTemplateInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *ValidateTemplateInput) SetTemplateURL(v string) *ValidateTemplateInput {
	s.TemplateURL = &v
	return s
}

// The output for ValidateTemplate action.
type ValidateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The capabilities found within the template. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value
	// for this parameter when you use the CreateStack or UpdateStack actions with
	// your template; otherwise, those actions return an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []*string `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// A list of the transforms that are declared in the template.
	DeclaredTransforms []*string `type:"list"`

	// The description found within the template.
	Description *string `min:"1" type:"string"`

	// A list of TemplateParameter structures.
	Parameters []*TemplateParameter `type:"list"`
}

// String returns the string representation
func (s ValidateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *ValidateTemplateOutput) SetCapabilities(v []*string) *ValidateTemplateOutput {
	s.Capabilities = v
	return s
}

// SetCapabilitiesReason sets the CapabilitiesReason field's value.
func (s *ValidateTemplateOutput) SetCapabilitiesReason(v string) *ValidateTemplateOutput {
	s.CapabilitiesReason = &v
	return s
}

// SetDeclaredTransforms sets the DeclaredTransforms field's value.
func (s *ValidateTemplateOutput) SetDeclaredTransforms(v []*string) *ValidateTemplateOutput {
	s.DeclaredTransforms = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ValidateTemplateOutput) SetDescription(v string) *ValidateTemplateOutput {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ValidateTemplateOutput) SetParameters(v []*TemplateParameter) *ValidateTemplateOutput {
	s.Parameters = v
	return s
}

const (
	// AccountGateStatusSucceeded is a AccountGateStatus enum value
	AccountGateStatusSucceeded = "SUCCEEDED"

	// AccountGateStatusFailed is a AccountGateStatus enum value
	AccountGateStatusFailed = "FAILED"

	// AccountGateStatusSkipped is a AccountGateStatus enum value
	AccountGateStatusSkipped = "SKIPPED"
)

const (
	// CapabilityCapabilityIam is a Capability enum value
	CapabilityCapabilityIam = "CAPABILITY_IAM"

	// CapabilityCapabilityNamedIam is a Capability enum value
	CapabilityCapabilityNamedIam = "CAPABILITY_NAMED_IAM"

	// CapabilityCapabilityAutoExpand is a Capability enum value
	CapabilityCapabilityAutoExpand = "CAPABILITY_AUTO_EXPAND"
)

const (
	// ChangeActionAdd is a ChangeAction enum value
	ChangeActionAdd = "Add"

	// ChangeActionModify is a ChangeAction enum value
	ChangeActionModify = "Modify"

	// ChangeActionRemove is a ChangeAction enum value
	ChangeActionRemove = "Remove"
)

const (
	// ChangeSetStatusCreatePending is a ChangeSetStatus enum value
	ChangeSetStatusCreatePending = "CREATE_PENDING"

	// ChangeSetStatusCreateInProgress is a ChangeSetStatus enum value
	ChangeSetStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// ChangeSetStatusCreateComplete is a ChangeSetStatus enum value
	ChangeSetStatusCreateComplete = "CREATE_COMPLETE"

	// ChangeSetStatusDeleteComplete is a ChangeSetStatus enum value
	ChangeSetStatusDeleteComplete = "DELETE_COMPLETE"

	// ChangeSetStatusFailed is a ChangeSetStatus enum value
	ChangeSetStatusFailed = "FAILED"
)

const (
	// ChangeSetTypeCreate is a ChangeSetType enum value
	ChangeSetTypeCreate = "CREATE"

	// ChangeSetTypeUpdate is a ChangeSetType enum value
	ChangeSetTypeUpdate = "UPDATE"
)

const (
	// ChangeSourceResourceReference is a ChangeSource enum value
	ChangeSourceResourceReference = "ResourceReference"

	// ChangeSourceParameterReference is a ChangeSource enum value
	ChangeSourceParameterReference = "ParameterReference"

	// ChangeSourceResourceAttribute is a ChangeSource enum value
	ChangeSourceResourceAttribute = "ResourceAttribute"

	// ChangeSourceDirectModification is a ChangeSource enum value
	ChangeSourceDirectModification = "DirectModification"

	// ChangeSourceAutomatic is a ChangeSource enum value
	ChangeSourceAutomatic = "Automatic"
)

const (
	// ChangeTypeResource is a ChangeType enum value
	ChangeTypeResource = "Resource"
)

const (
	// DifferenceTypeAdd is a DifferenceType enum value
	DifferenceTypeAdd = "ADD"

	// DifferenceTypeRemove is a DifferenceType enum value
	DifferenceTypeRemove = "REMOVE"

	// DifferenceTypeNotEqual is a DifferenceType enum value
	DifferenceTypeNotEqual = "NOT_EQUAL"
)

const (
	// EvaluationTypeStatic is a EvaluationType enum value
	EvaluationTypeStatic = "Static"

	// EvaluationTypeDynamic is a EvaluationType enum value
	EvaluationTypeDynamic = "Dynamic"
)

const (
	// ExecutionStatusUnavailable is a ExecutionStatus enum value
	ExecutionStatusUnavailable = "UNAVAILABLE"

	// ExecutionStatusAvailable is a ExecutionStatus enum value
	ExecutionStatusAvailable = "AVAILABLE"

	// ExecutionStatusExecuteInProgress is a ExecutionStatus enum value
	ExecutionStatusExecuteInProgress = "EXECUTE_IN_PROGRESS"

	// ExecutionStatusExecuteComplete is a ExecutionStatus enum value
	ExecutionStatusExecuteComplete = "EXECUTE_COMPLETE"

	// ExecutionStatusExecuteFailed is a ExecutionStatus enum value
	ExecutionStatusExecuteFailed = "EXECUTE_FAILED"

	// ExecutionStatusObsolete is a ExecutionStatus enum value
	ExecutionStatusObsolete = "OBSOLETE"
)

const (
	// OnFailureDoNothing is a OnFailure enum value
	OnFailureDoNothing = "DO_NOTHING"

	// OnFailureRollback is a OnFailure enum value
	OnFailureRollback = "ROLLBACK"

	// OnFailureDelete is a OnFailure enum value
	OnFailureDelete = "DELETE"
)

const (
	// ReplacementTrue is a Replacement enum value
	ReplacementTrue = "True"

	// ReplacementFalse is a Replacement enum value
	ReplacementFalse = "False"

	// ReplacementConditional is a Replacement enum value
	ReplacementConditional = "Conditional"
)

const (
	// RequiresRecreationNever is a RequiresRecreation enum value
	RequiresRecreationNever = "Never"

	// RequiresRecreationConditionally is a RequiresRecreation enum value
	RequiresRecreationConditionally = "Conditionally"

	// RequiresRecreationAlways is a RequiresRecreation enum value
	RequiresRecreationAlways = "Always"
)

const (
	// ResourceAttributeProperties is a ResourceAttribute enum value
	ResourceAttributeProperties = "Properties"

	// ResourceAttributeMetadata is a ResourceAttribute enum value
	ResourceAttributeMetadata = "Metadata"

	// ResourceAttributeCreationPolicy is a ResourceAttribute enum value
	ResourceAttributeCreationPolicy = "CreationPolicy"

	// ResourceAttributeUpdatePolicy is a ResourceAttribute enum value
	ResourceAttributeUpdatePolicy = "UpdatePolicy"

	// ResourceAttributeDeletionPolicy is a ResourceAttribute enum value
	ResourceAttributeDeletionPolicy = "DeletionPolicy"

	// ResourceAttributeTags is a ResourceAttribute enum value
	ResourceAttributeTags = "Tags"
)

const (
	// ResourceSignalStatusSuccess is a ResourceSignalStatus enum value
	ResourceSignalStatusSuccess = "SUCCESS"

	// ResourceSignalStatusFailure is a ResourceSignalStatus enum value
	ResourceSignalStatusFailure = "FAILURE"
)

const (
	// ResourceStatusCreateInProgress is a ResourceStatus enum value
	ResourceStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// ResourceStatusCreateFailed is a ResourceStatus enum value
	ResourceStatusCreateFailed = "CREATE_FAILED"

	// ResourceStatusCreateComplete is a ResourceStatus enum value
	ResourceStatusCreateComplete = "CREATE_COMPLETE"

	// ResourceStatusDeleteInProgress is a ResourceStatus enum value
	ResourceStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// ResourceStatusDeleteFailed is a ResourceStatus enum value
	ResourceStatusDeleteFailed = "DELETE_FAILED"

	// ResourceStatusDeleteComplete is a ResourceStatus enum value
	ResourceStatusDeleteComplete = "DELETE_COMPLETE"

	// ResourceStatusDeleteSkipped is a ResourceStatus enum value
	ResourceStatusDeleteSkipped = "DELETE_SKIPPED"

	// ResourceStatusUpdateInProgress is a ResourceStatus enum value
	ResourceStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// ResourceStatusUpdateFailed is a ResourceStatus enum value
	ResourceStatusUpdateFailed = "UPDATE_FAILED"

	// ResourceStatusUpdateComplete is a ResourceStatus enum value
	ResourceStatusUpdateComplete = "UPDATE_COMPLETE"
)

const (
	// StackDriftDetectionStatusDetectionInProgress is a StackDriftDetectionStatus enum value
	StackDriftDetectionStatusDetectionInProgress = "DETECTION_IN_PROGRESS"

	// StackDriftDetectionStatusDetectionFailed is a StackDriftDetectionStatus enum value
	StackDriftDetectionStatusDetectionFailed = "DETECTION_FAILED"

	// StackDriftDetectionStatusDetectionComplete is a StackDriftDetectionStatus enum value
	StackDriftDetectionStatusDetectionComplete = "DETECTION_COMPLETE"
)

const (
	// StackDriftStatusDrifted is a StackDriftStatus enum value
	StackDriftStatusDrifted = "DRIFTED"

	// StackDriftStatusInSync is a StackDriftStatus enum value
	StackDriftStatusInSync = "IN_SYNC"

	// StackDriftStatusUnknown is a StackDriftStatus enum value
	StackDriftStatusUnknown = "UNKNOWN"

	// StackDriftStatusNotChecked is a StackDriftStatus enum value
	StackDriftStatusNotChecked = "NOT_CHECKED"
)

const (
	// StackInstanceStatusCurrent is a StackInstanceStatus enum value
	StackInstanceStatusCurrent = "CURRENT"

	// StackInstanceStatusOutdated is a StackInstanceStatus enum value
	StackInstanceStatusOutdated = "OUTDATED"

	// StackInstanceStatusInoperable is a StackInstanceStatus enum value
	StackInstanceStatusInoperable = "INOPERABLE"
)

const (
	// StackResourceDriftStatusInSync is a StackResourceDriftStatus enum value
	StackResourceDriftStatusInSync = "IN_SYNC"

	// StackResourceDriftStatusModified is a StackResourceDriftStatus enum value
	StackResourceDriftStatusModified = "MODIFIED"

	// StackResourceDriftStatusDeleted is a StackResourceDriftStatus enum value
	StackResourceDriftStatusDeleted = "DELETED"

	// StackResourceDriftStatusNotChecked is a StackResourceDriftStatus enum value
	StackResourceDriftStatusNotChecked = "NOT_CHECKED"
)

const (
	// StackSetOperationActionCreate is a StackSetOperationAction enum value
	StackSetOperationActionCreate = "CREATE"

	// StackSetOperationActionUpdate is a StackSetOperationAction enum value
	StackSetOperationActionUpdate = "UPDATE"

	// StackSetOperationActionDelete is a StackSetOperationAction enum value
	StackSetOperationActionDelete = "DELETE"
)

const (
	// StackSetOperationResultStatusPending is a StackSetOperationResultStatus enum value
	StackSetOperationResultStatusPending = "PENDING"

	// StackSetOperationResultStatusRunning is a StackSetOperationResultStatus enum value
	StackSetOperationResultStatusRunning = "RUNNING"

	// StackSetOperationResultStatusSucceeded is a StackSetOperationResultStatus enum value
	StackSetOperationResultStatusSucceeded = "SUCCEEDED"

	// StackSetOperationResultStatusFailed is a StackSetOperationResultStatus enum value
	StackSetOperationResultStatusFailed = "FAILED"

	// StackSetOperationResultStatusCancelled is a StackSetOperationResultStatus enum value
	StackSetOperationResultStatusCancelled = "CANCELLED"
)

const (
	// StackSetOperationStatusRunning is a StackSetOperationStatus enum value
	StackSetOperationStatusRunning = "RUNNING"

	// StackSetOperationStatusSucceeded is a StackSetOperationStatus enum value
	StackSetOperationStatusSucceeded = "SUCCEEDED"

	// StackSetOperationStatusFailed is a StackSetOperationStatus enum value
	StackSetOperationStatusFailed = "FAILED"

	// StackSetOperationStatusStopping is a StackSetOperationStatus enum value
	StackSetOperationStatusStopping = "STOPPING"

	// StackSetOperationStatusStopped is a StackSetOperationStatus enum value
	StackSetOperationStatusStopped = "STOPPED"
)

const (
	// StackSetStatusActive is a StackSetStatus enum value
	StackSetStatusActive = "ACTIVE"

	// StackSetStatusDeleted is a StackSetStatus enum value
	StackSetStatusDeleted = "DELETED"
)

const (
	// StackStatusCreateInProgress is a StackStatus enum value
	StackStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// StackStatusCreateFailed is a StackStatus enum value
	StackStatusCreateFailed = "CREATE_FAILED"

	// StackStatusCreateComplete is a StackStatus enum value
	StackStatusCreateComplete = "CREATE_COMPLETE"

	// StackStatusRollbackInProgress is a StackStatus enum value
	StackStatusRollbackInProgress = "ROLLBACK_IN_PROGRESS"

	// StackStatusRollbackFailed is a StackStatus enum value
	StackStatusRollbackFailed = "ROLLBACK_FAILED"

	// StackStatusRollbackComplete is a StackStatus enum value
	StackStatusRollbackComplete = "ROLLBACK_COMPLETE"

	// StackStatusDeleteInProgress is a StackStatus enum value
	StackStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// StackStatusDeleteFailed is a StackStatus enum value
	StackStatusDeleteFailed = "DELETE_FAILED"

	// StackStatusDeleteComplete is a StackStatus enum value
	StackStatusDeleteComplete = "DELETE_COMPLETE"

	// StackStatusUpdateInProgress is a StackStatus enum value
	StackStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// StackStatusUpdateCompleteCleanupInProgress is a StackStatus enum value
	StackStatusUpdateCompleteCleanupInProgress = "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS"

	// StackStatusUpdateComplete is a StackStatus enum value
	StackStatusUpdateComplete = "UPDATE_COMPLETE"

	// StackStatusUpdateRollbackInProgress is a StackStatus enum value
	StackStatusUpdateRollbackInProgress = "UPDATE_ROLLBACK_IN_PROGRESS"

	// StackStatusUpdateRollbackFailed is a StackStatus enum value
	StackStatusUpdateRollbackFailed = "UPDATE_ROLLBACK_FAILED"

	// StackStatusUpdateRollbackCompleteCleanupInProgress is a StackStatus enum value
	StackStatusUpdateRollbackCompleteCleanupInProgress = "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"

	// StackStatusUpdateRollbackComplete is a StackStatus enum value
	StackStatusUpdateRollbackComplete = "UPDATE_ROLLBACK_COMPLETE"

	// StackStatusReviewInProgress is a StackStatus enum value
	StackStatusReviewInProgress = "REVIEW_IN_PROGRESS"
)

const (
	// TemplateStageOriginal is a TemplateStage enum value
	TemplateStageOriginal = "Original"

	// TemplateStageProcessed is a TemplateStage enum value
	TemplateStageProcessed = "Processed"
)
