# CVE-2017-14491

A vulnerability in dnsmasq, used by kube-dns, requires an upgrade to the
kube-dns component. This component is the default DNS component installed in
Kubernetes.  The vulnerability may be externally exploitable. Links below exist
with the full detail of the CVE. This exploit is not a Kubernetes specific vulnerability but exists in dnsmasq.

## Current kops Status

`kops` release 1.7.1 addresses this CVE.  This version of `kops` will upgrade and
create clusters. `kops` 1.8.0.alpha.1 release does not contain the required
changes, but when released 1.8.0.apha.2 will contain the required patches.

## Upgrading Cluster

The kube-dns deployment will be automatically upgraded when `kops update
cluster` is executed. Replace `my-cluster.example.com` with the name of your
cluster.  If you are upgrading a Kubernetes 1.4.x or 1.5.x cluster you may need
to follow the instruction below to create a required configmap for kube-dns.

Upgrade command:

```bash
kops update cluster --yes --name my-cluster.example.com
```

Validate the change was applied to the deployment:

```bash
kubectl get deployment -n kube-system kube-dns \
-o jsonpath='{.spec.template.spec.containers[?(@.name == "dnsmasq")].image}'
```

The upgrade will occur once the channels utility picks up the change within a
few minutes.

## Tested Kubernetes Versions

Kubernetes versions 1.5.8, 1.6.11, 1.7.7, and 1.8.0 have been fully tested with
the new version of `kube-dns` deployment.  Other versions should function, but
upgrading to tested version is recommended. We have had 1.4.x users upgrade
successfully, but we cannot validate full production stability.  Local testing
in a non-production environment is always recommended. We are not able to
quantify the risk of using a non-tested version.

## Fixed kops releases

We are planning to release in 1.8.x kops releases. 1.7.1 release is released with
the needed changes. If you are using the 1.8.x alpha releases, we recommend
applying the hotfixes.

### Fixed kops Version Matrix

| kops Version  | Fixed  | Released | Will Fix | URL |
|---|---|---|---|---|
| 1.7.1  | Y  | Y |  Not Applicable | [here](https://github.com/kubernetes/kops/releases/tag/1.7.1) |
| master | Y  | N |  Not Applicable | [here](https://github.com/kubernetes/kops) |
| 1.8.0  | N  | N | Y |  Not Applicable |
| 1.8.0.alpha.1  | N  | Y | N |  Not Applicable |
| 1.7.0  | N  | Y | N |  Not Applicable |

## kops PR fixes

- Fixed by @mikesplain in [#3511](https://github.com/kubernetes/kops/pull/3511)
- Fixed by @mikesplain in [#3538](https://github.com/kubernetes/kops/pull/3538)

## kops Tracking Issue

- Filed by @chrislovecnm [#3512](https://github.com/kubernetes/kops/issues/3512)

## Hotfix Instructions

The minimal fix is just to update the container for the pods using dnsmasq.  You
are able to apply this fix without downtime.  Hotfix instruction differ between
Kubernetes releases.  The newer version of `kube-dns` includes the
`k8s-dns-dnsmasq-nanny-amd64` container.

### Kubernetes Versions 1.6.x and higher

#### Installation of Hot Fix

Apply the update to the container:

```bash
kubectl set image deployment/kube-dns -n kube-system \
 dnsmasq=k8s.gcr.io/k8s-dns-dnsmasq-nanny-amd64:1.14.5
```

Validate the change was applied to the deployment:

```bash
kubectl get deployment -n kube-system kube-dns \
 -o jsonpath='{.spec.template.spec.containers[?(@.name == "dnsmasq")].image}'
```

#### Validation

To verify that pods were deployed:

```bash
kubectl get pods -n kube-system -o \
 custom-columns=NAME:.metadata.name,IMAGE:.spec.containers[*].image \
 -l k8s-app=kube-dns
```


You should see version 1.14.5 for the k8s-dns-dnsmasq-nanny-amd64 container:

```console
NAME                        IMAGE
kube-dns-1100866048-3lqm0   k8s.gcr.io/k8s-dns-dnsmasq-nanny-amd64:1.14.5,k8s.gcr.io/k8s-dns-kube-dns-amd64:1.14.5,k8s.gcr.io/k8s-dns-sidecar-amd64:1.14.5
kube-dns-1100866048-tjlv2   k8s.gcr.io/k8s-dns-dnsmasq-nanny-amd64:1.14.5,k8s.gcr.io/k8s-dns-kube-dns-amd64:1.14.5,k8s.gcr.io/k8s-dns-sidecar-amd64:1.14.5
```

### Kubernetes Versions 1.4.x - 1.5.x

Check to see if you have the new configmap for kube-dns.  A configmap is
required for the 1.14.5 containers, and kube-dns will _NOT_ start without the
configmap.

#### Installation of Dependencies

```bash
kubectl -n kube-system get configmap kube-dns
```

If the configmap does not exist create an empty configmap.

#### Installation of Hot Fix

```bash
kubectl create configmap -n kube-system kube-dns
```

Upgrade the kube-dns container to the new version.

```bash
kubectl set image deployment/kube-dns -n kube-system \
 dnsmasq=k8s.gcr.io/k8s-dns-dnsmasq-amd64:1.14.5
```

Validate the change was applied to the deployment:

```bash
kubectl get deployment -n kube-system kube-dns \
 -o jsonpath='{.spec.template.spec.containers[?(@.name == "dnsmasq")].image}'
```
To verify that pods were deployed:

```bash
kubectl get pods -n kube-system -o \
 custom-columns=NAME:.metadata.name,IMAGE:.spec.containers[*].image \
  -l k8s-app=kube-dns
```

You should see version 1.14.5 for the dnsmasq pod

```console
NAME                        IMAGE
kube-dns-4146767324-djthf   k8s.gcr.io/kubedns-amd64:1.9,k8s.gcr.io/k8s-dns-dnsmasq-amd64:1.14.5,k8s.gcr.io/dnsmasq-metrics-amd64:1.0,k8s.gcr.io/exechealthz-amd64:1.2
kube-dns-4146767324-kloxi   k8s.gcr.io/kubedns-amd64:1.9,k8s.gcr.io/k8s-dns-dnsmasq-amd64:1.14.5,k8s.gcr.io/dnsmasq-metrics-amd64:1.0,k8s.gcr.io/exechealthz-amd64:1.2
```

## More Information
- [Kubernetes Security Blog Post](https://security.googleblog.com/2017/10/behind-masq-yet-more-dns-and-dhcp.html)
- [CVE](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-14491)
- [NVD](https://nvd.nist.gov/vuln/detail/CVE-2017-14491)


## Thanks

Thanks to all that helped @mikesplain, @chrislovecnm, @snoby, @justinsb, @3h4x,
@aaronlevy
