<!--- AUTOGENERATED FROM selfdrive/car/CARS_template.md, DO NOT EDIT. --->

# Support Information for {{car_docs_with_extras | length}} Known Cars

|{{ExtraCarsColumn | map(attribute='value') | join('|') | replace(hardware_col_name, wide_hardware_col_name)}}|
|---|---|---|{% for _ in range((ExtraCarsColumn | length) - 3) %}{{':---:|'}}{% endfor +%}
{% for car_docs in car_docs_with_extras %}
|{% for column in ExtraCarsColumn %}{{car_docs.get_extra_cars_column(column)}}|{% endfor %}

{% endfor %}

# Types of Support

**opendbc can support many more cars than it currently does.** There are a few reasons your car may not be supported.
If your car doesn't fit into any of the incompatibility criteria here, then there's a good chance it can be supported!
We're adding support for new cars all the time. **We don't have a roadmap for car support**, and in fact, most car
support comes from users like you!

## Upstream

A supported vehicle is one that just works when you install a comma device. All supported cars provide a better
experience than any stock system. Supported vehicles reference the US market unless otherwise specified.

## Under Review

A vehicle under review is one for which software support has been merged into upstream openpilot, but hasn't yet been
tested for drive quality and conformance with [comma safety guidelines](https://github.com/commaai/openpilot/blob/master/docs/SAFETY.md).
This is a normal part of the development and quality assurance process. This vehicle will not work when upstream
openpilot is installed, but custom forks may allow their use.

## Custom

Vehicles in this category are not considered plug-and-play. Software support is included in upstream openpilot, but
these vehicles might not have a harness in the comma store, or the physical install might be at an unusual or cumbersome
location, or they might need unusual configuration after install.

## Dashcam

Dashcam vehicles have software support in upstream openpilot, but will go into "dashcam mode" at startup and will not
engage. This may be due to known issues with driving safety or quality, or it may be a work in progress that isn't yet
ready for safety and quality review.

## Community

Although they're not upstream, the community has openpilot running on other makes and models. See the 'Community
Supported Models' section of each make [on our wiki](https://wiki.comma.ai/).

Some notable works-in-progress:
* Honda
  * 2024 Acura Integra, commaai/openpilot#32056
  * 2023-24 Honda Accord (CAN-FD), commaai/openpilot#32229
  * 2024 Honda CR-V (CAN-FD), commaai/openpilot#32806
  * 2024 Honda CR-V Hybrid (CAN-FD), commaai/openpilot#31527
    * Depends on commaai/opendbc#1100
  * 2021-25 Honda Odyssey, commaai/opendbc#1330
  * 2023-24 Honda Pilot (CAN-FD), commaai/openpilot#30324
  * Camera ACC stability improvements, commaai/openpilot#31022
    * Depends on commaai/panda#1814
    * Depends on commaai/opendbc#998
    * These are being reworked for full-time proxy through openpilot
  * Manual transmission support (Civic, Integra)
    * Depends on commaai/opendbc#1034 (merged)
    * Car port support PR not yet filed

## Incompatible

### CAN Bus Security

Vehicles with CAN security measures, such as AUTOSAR Secure Onboard Communication (SecOC) are not usable with openpilot
unless the owner can recover the message signing key and implement CAN message signing. Examples include certain newer
Toyota, and the GM Global B platform.

### FlexRay

All the cars that openpilot supports use a [CAN bus](https://en.wikipedia.org/wiki/CAN_bus) for communication between all the car's computers, however a
CAN bus isn't the only way that the computers in your car can communicate. Most, if not all, vehicles from the following
manufacturers use [FlexRay](https://en.wikipedia.org/wiki/FlexRay) instead of a CAN bus: **BMW, Mercedes, Audi, Land Rover, and some Volvo**. These cars
may one day be supported, but we have no immediate plans to support FlexRay.
