# -*- coding: utf-8 -*-
# Generated by Django 1.10.4 on 2016-12-28 02:11
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Archive',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=32, unique=True, verbose_name='文章标题')),
                ('abstract', models.TextField(verbose_name='摘要')),
                ('body', models.TextField(verbose_name='文章内容')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('last_modified_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('status', models.CharField(choices=[('0', '发布'), ('1', '草稿')], default='0', max_length=1, verbose_name='文章状态')),
                ('browse', models.IntegerField(default=0, verbose_name='浏览量')),
            ],
            options={
                'verbose_name_plural': '文章(Archive)',
                'verbose_name': '文章(Archive)',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Categories',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32, unique=True, verbose_name='分类名称')),
                ('url', models.CharField(max_length=32, unique=True, verbose_name='分类URL')),
                ('title', models.CharField(max_length=64, verbose_name='标题')),
                ('description', models.CharField(max_length=32, verbose_name='描述')),
                ('keywords', models.CharField(max_length=255, verbose_name='关键词')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('last_modified_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
            ],
            options={
                'verbose_name_plural': '分类(Categories)',
                'verbose_name': '分类(Categories)',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='Links',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32, unique=True, verbose_name='友情链接名字')),
                ('url', models.URLField(unique=True, verbose_name='URL')),
                ('add_time', models.DateTimeField(auto_now_add=True, verbose_name='添加日期')),
            ],
            options={
                'verbose_name_plural': '友情链接(Links)',
                'verbose_name': '友情链接(Links)',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='Settings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64, verbose_name='标题')),
                ('description', models.CharField(max_length=32, verbose_name='描述')),
                ('keywords', models.CharField(max_length=255, verbose_name='关键词')),
            ],
            options={
                'verbose_name_plural': '博客设置(Settings)',
                'verbose_name': '博客设置(Settings)',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32, unique=True, verbose_name='标签名称')),
                ('created_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('last_modified_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
            ],
            options={
                'verbose_name_plural': '标签(Tag)',
                'verbose_name': '标签(Tag)',
                'ordering': ['id'],
            },
        ),
        migrations.AddField(
            model_name='archive',
            name='categories',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='blog.Categories', verbose_name='分类'),
        ),
        migrations.AddField(
            model_name='archive',
            name='tag',
            field=models.ManyToManyField(to='blog.Tag', verbose_name='标签'),
        ),
    ]
