/**
 * Autogenerated by Thrift Compiler (0.9.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.hadoop.thriftfs.jobtracker.api;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jobtracker {

  /**
   * A proxy service onto a Jobtracker, exposing read-only methods for cluster monitoring
   */
  public interface Iface extends org.apache.hadoop.thriftfs.api.HadoopServiceBase.Iface {

    /**
     * Get the name of the tracker exporting this service
     * 
     * @param ctx
     */
    public String getJobTrackerName(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get the current cluster status
     * 
     * @param ctx
     */
    public ThriftClusterStatus getClusterStatus(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get a list of job queues managed by this tracker
     * 
     * @param ctx
     */
    public ThriftJobQueueList getQueues(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Get a job by ID
     * 
     * @param ctx
     * @param jobID
     */
    public ThriftJobInProgress getJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws JobNotFoundException, org.apache.thrift.TException;

    /**
     * Get a list of currently running jobs
     * 
     * @param ctx
     */
    public ThriftJobList getRunningJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get a list of completed jobs
     * 
     * @param ctx
     */
    public ThriftJobList getCompletedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get a retired job
     * 
     * @param ctx
     * @param jobID
     */
    public ThriftJobInProgress getRetiredJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws JobNotFoundException, org.apache.thrift.TException;

    /**
     * Get a list of retired jobs
     * 
     * @param ctx
     * @param state
     */
    public ThriftJobList getRetiredJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobState state) throws org.apache.thrift.TException;

    /**
     * Get a list of failed (due to error, not killed) jobs
     * 
     * @param ctx
     */
    public ThriftJobList getFailedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get a list of killed jobs
     * 
     * @param ctx
     */
    public ThriftJobList getKilledJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get a list of all failed, completed and running jobs (could be expensive!)
     * 
     * @param ctx
     */
    public ThriftJobList getAllJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get the count of jobs by status for a given user
     * 
     * @param ctx
     * @param user
     */
    public ThriftUserJobCounts getUserJobCounts(org.apache.hadoop.thriftfs.api.RequestContext ctx, String user) throws org.apache.thrift.TException;

    /**
     * Get a (possibly incomplete) list of tasks
     * 
     * @param ctx
     * @param jobID
     * @param types
     * @param states
     * @param text
     * @param count
     * @param offset
     */
    public ThriftTaskInProgressList getTaskList(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, Set<ThriftTaskType> types, Set<ThriftTaskQueryState> states, String text, int count, int offset) throws JobNotFoundException, org.apache.thrift.TException;

    /**
     * Get details of a task
     * 
     * @param ctx
     * @param taskID
     */
    public ThriftTaskInProgress getTask(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskID taskID) throws JobNotFoundException, TaskNotFoundException, org.apache.thrift.TException;

    /**
     * Get a list of groups of counters attached to the job with provided id.
     * This returns the total counters
     * 
     * 
     * @param ctx
     * @param jobID
     */
    public ThriftGroupList getJobCounters(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws JobNotFoundException, org.apache.thrift.TException;

    /**
     * Return job counters rolled up by map, reduce, and total
     * 
     * @param ctx
     * @param jobID
     */
    public ThriftJobCounterRollups getJobCounterRollups(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws JobNotFoundException, org.apache.thrift.TException;

    /**
     * Get all active trackers
     * 
     * @param ctx
     */
    public ThriftTaskTrackerStatusList getActiveTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get all blacklisted trackers
     * 
     * @param ctx
     */
    public ThriftTaskTrackerStatusList getBlacklistedTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get all trackers
     * 
     * @param ctx
     */
    public ThriftTaskTrackerStatusList getAllTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get a single task tracker by name
     * 
     * @param ctx
     * @param name
     */
    public ThriftTaskTrackerStatus getTracker(org.apache.hadoop.thriftfs.api.RequestContext ctx, String name) throws TaskTrackerNotFoundException, org.apache.thrift.TException;

    /**
     * Get the current time in ms according to the JT
     * 
     * @param ctx
     */
    public long getCurrentTime(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Get the xml for a job's configuration, serialised from the local filesystem on the JT
     * 
     * @param ctx
     * @param jobID
     */
    public String getJobConfXML(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Kill a job
     * 
     * @param ctx
     * @param jobID
     */
    public void killJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.hadoop.thriftfs.api.IOException, JobNotFoundException, org.apache.thrift.TException;

    /**
     * Kill a task attempt
     * 
     * @param ctx
     * @param attemptID
     */
    public void killTaskAttempt(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskAttemptID attemptID) throws org.apache.hadoop.thriftfs.api.IOException, TaskAttemptNotFoundException, JobNotFoundException, org.apache.thrift.TException;

    /**
     * Set a job's priority
     * 
     * @param ctx
     * @param jobID
     * @param priority
     */
    public void setJobPriority(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, ThriftJobPriority priority) throws org.apache.hadoop.thriftfs.api.IOException, JobNotFoundException, org.apache.thrift.TException;

    /**
     * Get an MR delegation token.
     * 
     * @param ctx
     * @param renewer
     */
    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

  }

  public interface AsyncIface extends org.apache.hadoop.thriftfs.api.HadoopServiceBase .AsyncIface {

    public void getJobTrackerName(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getJobTrackerName_call> resultHandler) throws org.apache.thrift.TException;

    public void getClusterStatus(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getClusterStatus_call> resultHandler) throws org.apache.thrift.TException;

    public void getQueues(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getQueues_call> resultHandler) throws org.apache.thrift.TException;

    public void getJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getJob_call> resultHandler) throws org.apache.thrift.TException;

    public void getRunningJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRunningJobs_call> resultHandler) throws org.apache.thrift.TException;

    public void getCompletedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getCompletedJobs_call> resultHandler) throws org.apache.thrift.TException;

    public void getRetiredJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRetiredJob_call> resultHandler) throws org.apache.thrift.TException;

    public void getRetiredJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobState state, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRetiredJobs_call> resultHandler) throws org.apache.thrift.TException;

    public void getFailedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getFailedJobs_call> resultHandler) throws org.apache.thrift.TException;

    public void getKilledJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getKilledJobs_call> resultHandler) throws org.apache.thrift.TException;

    public void getAllJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getAllJobs_call> resultHandler) throws org.apache.thrift.TException;

    public void getUserJobCounts(org.apache.hadoop.thriftfs.api.RequestContext ctx, String user, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getUserJobCounts_call> resultHandler) throws org.apache.thrift.TException;

    public void getTaskList(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, Set<ThriftTaskType> types, Set<ThriftTaskQueryState> states, String text, int count, int offset, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getTaskList_call> resultHandler) throws org.apache.thrift.TException;

    public void getTask(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskID taskID, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getTask_call> resultHandler) throws org.apache.thrift.TException;

    public void getJobCounters(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getJobCounters_call> resultHandler) throws org.apache.thrift.TException;

    public void getJobCounterRollups(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getJobCounterRollups_call> resultHandler) throws org.apache.thrift.TException;

    public void getActiveTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getActiveTrackers_call> resultHandler) throws org.apache.thrift.TException;

    public void getBlacklistedTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getBlacklistedTrackers_call> resultHandler) throws org.apache.thrift.TException;

    public void getAllTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getAllTrackers_call> resultHandler) throws org.apache.thrift.TException;

    public void getTracker(org.apache.hadoop.thriftfs.api.RequestContext ctx, String name, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getTracker_call> resultHandler) throws org.apache.thrift.TException;

    public void getCurrentTime(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getCurrentTime_call> resultHandler) throws org.apache.thrift.TException;

    public void getJobConfXML(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getJobConfXML_call> resultHandler) throws org.apache.thrift.TException;

    public void killJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.killJob_call> resultHandler) throws org.apache.thrift.TException;

    public void killTaskAttempt(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskAttemptID attemptID, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.killTaskAttempt_call> resultHandler) throws org.apache.thrift.TException;

    public void setJobPriority(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, ThriftJobPriority priority, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.setJobPriority_call> resultHandler) throws org.apache.thrift.TException;

    public void getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getDelegationToken_call> resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.hadoop.thriftfs.api.HadoopServiceBase.Client implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public String getJobTrackerName(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getJobTrackerName(ctx);
      return recv_getJobTrackerName();
    }

    public void send_getJobTrackerName(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getJobTrackerName_args args = new getJobTrackerName_args();
      args.setCtx(ctx);
      sendBase("getJobTrackerName", args);
    }

    public String recv_getJobTrackerName() throws org.apache.thrift.TException
    {
      getJobTrackerName_result result = new getJobTrackerName_result();
      receiveBase(result, "getJobTrackerName");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getJobTrackerName failed: unknown result");
    }

    public ThriftClusterStatus getClusterStatus(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getClusterStatus(ctx);
      return recv_getClusterStatus();
    }

    public void send_getClusterStatus(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getClusterStatus_args args = new getClusterStatus_args();
      args.setCtx(ctx);
      sendBase("getClusterStatus", args);
    }

    public ThriftClusterStatus recv_getClusterStatus() throws org.apache.thrift.TException
    {
      getClusterStatus_result result = new getClusterStatus_result();
      receiveBase(result, "getClusterStatus");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getClusterStatus failed: unknown result");
    }

    public ThriftJobQueueList getQueues(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_getQueues(ctx);
      return recv_getQueues();
    }

    public void send_getQueues(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getQueues_args args = new getQueues_args();
      args.setCtx(ctx);
      sendBase("getQueues", args);
    }

    public ThriftJobQueueList recv_getQueues() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      getQueues_result result = new getQueues_result();
      receiveBase(result, "getQueues");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getQueues failed: unknown result");
    }

    public ThriftJobInProgress getJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws JobNotFoundException, org.apache.thrift.TException
    {
      send_getJob(ctx, jobID);
      return recv_getJob();
    }

    public void send_getJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.thrift.TException
    {
      getJob_args args = new getJob_args();
      args.setCtx(ctx);
      args.setJobID(jobID);
      sendBase("getJob", args);
    }

    public ThriftJobInProgress recv_getJob() throws JobNotFoundException, org.apache.thrift.TException
    {
      getJob_result result = new getJob_result();
      receiveBase(result, "getJob");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getJob failed: unknown result");
    }

    public ThriftJobList getRunningJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getRunningJobs(ctx);
      return recv_getRunningJobs();
    }

    public void send_getRunningJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getRunningJobs_args args = new getRunningJobs_args();
      args.setCtx(ctx);
      sendBase("getRunningJobs", args);
    }

    public ThriftJobList recv_getRunningJobs() throws org.apache.thrift.TException
    {
      getRunningJobs_result result = new getRunningJobs_result();
      receiveBase(result, "getRunningJobs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRunningJobs failed: unknown result");
    }

    public ThriftJobList getCompletedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getCompletedJobs(ctx);
      return recv_getCompletedJobs();
    }

    public void send_getCompletedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getCompletedJobs_args args = new getCompletedJobs_args();
      args.setCtx(ctx);
      sendBase("getCompletedJobs", args);
    }

    public ThriftJobList recv_getCompletedJobs() throws org.apache.thrift.TException
    {
      getCompletedJobs_result result = new getCompletedJobs_result();
      receiveBase(result, "getCompletedJobs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getCompletedJobs failed: unknown result");
    }

    public ThriftJobInProgress getRetiredJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws JobNotFoundException, org.apache.thrift.TException
    {
      send_getRetiredJob(ctx, jobID);
      return recv_getRetiredJob();
    }

    public void send_getRetiredJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.thrift.TException
    {
      getRetiredJob_args args = new getRetiredJob_args();
      args.setCtx(ctx);
      args.setJobID(jobID);
      sendBase("getRetiredJob", args);
    }

    public ThriftJobInProgress recv_getRetiredJob() throws JobNotFoundException, org.apache.thrift.TException
    {
      getRetiredJob_result result = new getRetiredJob_result();
      receiveBase(result, "getRetiredJob");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRetiredJob failed: unknown result");
    }

    public ThriftJobList getRetiredJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobState state) throws org.apache.thrift.TException
    {
      send_getRetiredJobs(ctx, state);
      return recv_getRetiredJobs();
    }

    public void send_getRetiredJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobState state) throws org.apache.thrift.TException
    {
      getRetiredJobs_args args = new getRetiredJobs_args();
      args.setCtx(ctx);
      args.setState(state);
      sendBase("getRetiredJobs", args);
    }

    public ThriftJobList recv_getRetiredJobs() throws org.apache.thrift.TException
    {
      getRetiredJobs_result result = new getRetiredJobs_result();
      receiveBase(result, "getRetiredJobs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRetiredJobs failed: unknown result");
    }

    public ThriftJobList getFailedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getFailedJobs(ctx);
      return recv_getFailedJobs();
    }

    public void send_getFailedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getFailedJobs_args args = new getFailedJobs_args();
      args.setCtx(ctx);
      sendBase("getFailedJobs", args);
    }

    public ThriftJobList recv_getFailedJobs() throws org.apache.thrift.TException
    {
      getFailedJobs_result result = new getFailedJobs_result();
      receiveBase(result, "getFailedJobs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getFailedJobs failed: unknown result");
    }

    public ThriftJobList getKilledJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getKilledJobs(ctx);
      return recv_getKilledJobs();
    }

    public void send_getKilledJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getKilledJobs_args args = new getKilledJobs_args();
      args.setCtx(ctx);
      sendBase("getKilledJobs", args);
    }

    public ThriftJobList recv_getKilledJobs() throws org.apache.thrift.TException
    {
      getKilledJobs_result result = new getKilledJobs_result();
      receiveBase(result, "getKilledJobs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getKilledJobs failed: unknown result");
    }

    public ThriftJobList getAllJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getAllJobs(ctx);
      return recv_getAllJobs();
    }

    public void send_getAllJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getAllJobs_args args = new getAllJobs_args();
      args.setCtx(ctx);
      sendBase("getAllJobs", args);
    }

    public ThriftJobList recv_getAllJobs() throws org.apache.thrift.TException
    {
      getAllJobs_result result = new getAllJobs_result();
      receiveBase(result, "getAllJobs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllJobs failed: unknown result");
    }

    public ThriftUserJobCounts getUserJobCounts(org.apache.hadoop.thriftfs.api.RequestContext ctx, String user) throws org.apache.thrift.TException
    {
      send_getUserJobCounts(ctx, user);
      return recv_getUserJobCounts();
    }

    public void send_getUserJobCounts(org.apache.hadoop.thriftfs.api.RequestContext ctx, String user) throws org.apache.thrift.TException
    {
      getUserJobCounts_args args = new getUserJobCounts_args();
      args.setCtx(ctx);
      args.setUser(user);
      sendBase("getUserJobCounts", args);
    }

    public ThriftUserJobCounts recv_getUserJobCounts() throws org.apache.thrift.TException
    {
      getUserJobCounts_result result = new getUserJobCounts_result();
      receiveBase(result, "getUserJobCounts");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserJobCounts failed: unknown result");
    }

    public ThriftTaskInProgressList getTaskList(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, Set<ThriftTaskType> types, Set<ThriftTaskQueryState> states, String text, int count, int offset) throws JobNotFoundException, org.apache.thrift.TException
    {
      send_getTaskList(ctx, jobID, types, states, text, count, offset);
      return recv_getTaskList();
    }

    public void send_getTaskList(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, Set<ThriftTaskType> types, Set<ThriftTaskQueryState> states, String text, int count, int offset) throws org.apache.thrift.TException
    {
      getTaskList_args args = new getTaskList_args();
      args.setCtx(ctx);
      args.setJobID(jobID);
      args.setTypes(types);
      args.setStates(states);
      args.setText(text);
      args.setCount(count);
      args.setOffset(offset);
      sendBase("getTaskList", args);
    }

    public ThriftTaskInProgressList recv_getTaskList() throws JobNotFoundException, org.apache.thrift.TException
    {
      getTaskList_result result = new getTaskList_result();
      receiveBase(result, "getTaskList");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTaskList failed: unknown result");
    }

    public ThriftTaskInProgress getTask(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskID taskID) throws JobNotFoundException, TaskNotFoundException, org.apache.thrift.TException
    {
      send_getTask(ctx, taskID);
      return recv_getTask();
    }

    public void send_getTask(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskID taskID) throws org.apache.thrift.TException
    {
      getTask_args args = new getTask_args();
      args.setCtx(ctx);
      args.setTaskID(taskID);
      sendBase("getTask", args);
    }

    public ThriftTaskInProgress recv_getTask() throws JobNotFoundException, TaskNotFoundException, org.apache.thrift.TException
    {
      getTask_result result = new getTask_result();
      receiveBase(result, "getTask");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.jnf != null) {
        throw result.jnf;
      }
      if (result.tnf != null) {
        throw result.tnf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTask failed: unknown result");
    }

    public ThriftGroupList getJobCounters(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws JobNotFoundException, org.apache.thrift.TException
    {
      send_getJobCounters(ctx, jobID);
      return recv_getJobCounters();
    }

    public void send_getJobCounters(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.thrift.TException
    {
      getJobCounters_args args = new getJobCounters_args();
      args.setCtx(ctx);
      args.setJobID(jobID);
      sendBase("getJobCounters", args);
    }

    public ThriftGroupList recv_getJobCounters() throws JobNotFoundException, org.apache.thrift.TException
    {
      getJobCounters_result result = new getJobCounters_result();
      receiveBase(result, "getJobCounters");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getJobCounters failed: unknown result");
    }

    public ThriftJobCounterRollups getJobCounterRollups(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws JobNotFoundException, org.apache.thrift.TException
    {
      send_getJobCounterRollups(ctx, jobID);
      return recv_getJobCounterRollups();
    }

    public void send_getJobCounterRollups(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.thrift.TException
    {
      getJobCounterRollups_args args = new getJobCounterRollups_args();
      args.setCtx(ctx);
      args.setJobID(jobID);
      sendBase("getJobCounterRollups", args);
    }

    public ThriftJobCounterRollups recv_getJobCounterRollups() throws JobNotFoundException, org.apache.thrift.TException
    {
      getJobCounterRollups_result result = new getJobCounterRollups_result();
      receiveBase(result, "getJobCounterRollups");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getJobCounterRollups failed: unknown result");
    }

    public ThriftTaskTrackerStatusList getActiveTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getActiveTrackers(ctx);
      return recv_getActiveTrackers();
    }

    public void send_getActiveTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getActiveTrackers_args args = new getActiveTrackers_args();
      args.setCtx(ctx);
      sendBase("getActiveTrackers", args);
    }

    public ThriftTaskTrackerStatusList recv_getActiveTrackers() throws org.apache.thrift.TException
    {
      getActiveTrackers_result result = new getActiveTrackers_result();
      receiveBase(result, "getActiveTrackers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getActiveTrackers failed: unknown result");
    }

    public ThriftTaskTrackerStatusList getBlacklistedTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getBlacklistedTrackers(ctx);
      return recv_getBlacklistedTrackers();
    }

    public void send_getBlacklistedTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getBlacklistedTrackers_args args = new getBlacklistedTrackers_args();
      args.setCtx(ctx);
      sendBase("getBlacklistedTrackers", args);
    }

    public ThriftTaskTrackerStatusList recv_getBlacklistedTrackers() throws org.apache.thrift.TException
    {
      getBlacklistedTrackers_result result = new getBlacklistedTrackers_result();
      receiveBase(result, "getBlacklistedTrackers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getBlacklistedTrackers failed: unknown result");
    }

    public ThriftTaskTrackerStatusList getAllTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getAllTrackers(ctx);
      return recv_getAllTrackers();
    }

    public void send_getAllTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getAllTrackers_args args = new getAllTrackers_args();
      args.setCtx(ctx);
      sendBase("getAllTrackers", args);
    }

    public ThriftTaskTrackerStatusList recv_getAllTrackers() throws org.apache.thrift.TException
    {
      getAllTrackers_result result = new getAllTrackers_result();
      receiveBase(result, "getAllTrackers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllTrackers failed: unknown result");
    }

    public ThriftTaskTrackerStatus getTracker(org.apache.hadoop.thriftfs.api.RequestContext ctx, String name) throws TaskTrackerNotFoundException, org.apache.thrift.TException
    {
      send_getTracker(ctx, name);
      return recv_getTracker();
    }

    public void send_getTracker(org.apache.hadoop.thriftfs.api.RequestContext ctx, String name) throws org.apache.thrift.TException
    {
      getTracker_args args = new getTracker_args();
      args.setCtx(ctx);
      args.setName(name);
      sendBase("getTracker", args);
    }

    public ThriftTaskTrackerStatus recv_getTracker() throws TaskTrackerNotFoundException, org.apache.thrift.TException
    {
      getTracker_result result = new getTracker_result();
      receiveBase(result, "getTracker");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.tne != null) {
        throw result.tne;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTracker failed: unknown result");
    }

    public long getCurrentTime(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_getCurrentTime(ctx);
      return recv_getCurrentTime();
    }

    public void send_getCurrentTime(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      getCurrentTime_args args = new getCurrentTime_args();
      args.setCtx(ctx);
      sendBase("getCurrentTime", args);
    }

    public long recv_getCurrentTime() throws org.apache.thrift.TException
    {
      getCurrentTime_result result = new getCurrentTime_result();
      receiveBase(result, "getCurrentTime");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getCurrentTime failed: unknown result");
    }

    public String getJobConfXML(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_getJobConfXML(ctx, jobID);
      return recv_getJobConfXML();
    }

    public void send_getJobConfXML(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.thrift.TException
    {
      getJobConfXML_args args = new getJobConfXML_args();
      args.setCtx(ctx);
      args.setJobID(jobID);
      sendBase("getJobConfXML", args);
    }

    public String recv_getJobConfXML() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      getJobConfXML_result result = new getJobConfXML_result();
      receiveBase(result, "getJobConfXML");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getJobConfXML failed: unknown result");
    }

    public void killJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.hadoop.thriftfs.api.IOException, JobNotFoundException, org.apache.thrift.TException
    {
      send_killJob(ctx, jobID);
      recv_killJob();
    }

    public void send_killJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID) throws org.apache.thrift.TException
    {
      killJob_args args = new killJob_args();
      args.setCtx(ctx);
      args.setJobID(jobID);
      sendBase("killJob", args);
    }

    public void recv_killJob() throws org.apache.hadoop.thriftfs.api.IOException, JobNotFoundException, org.apache.thrift.TException
    {
      killJob_result result = new killJob_result();
      receiveBase(result, "killJob");
      if (result.err != null) {
        throw result.err;
      }
      if (result.jne != null) {
        throw result.jne;
      }
      return;
    }

    public void killTaskAttempt(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskAttemptID attemptID) throws org.apache.hadoop.thriftfs.api.IOException, TaskAttemptNotFoundException, JobNotFoundException, org.apache.thrift.TException
    {
      send_killTaskAttempt(ctx, attemptID);
      recv_killTaskAttempt();
    }

    public void send_killTaskAttempt(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskAttemptID attemptID) throws org.apache.thrift.TException
    {
      killTaskAttempt_args args = new killTaskAttempt_args();
      args.setCtx(ctx);
      args.setAttemptID(attemptID);
      sendBase("killTaskAttempt", args);
    }

    public void recv_killTaskAttempt() throws org.apache.hadoop.thriftfs.api.IOException, TaskAttemptNotFoundException, JobNotFoundException, org.apache.thrift.TException
    {
      killTaskAttempt_result result = new killTaskAttempt_result();
      receiveBase(result, "killTaskAttempt");
      if (result.err != null) {
        throw result.err;
      }
      if (result.tne != null) {
        throw result.tne;
      }
      if (result.jne != null) {
        throw result.jne;
      }
      return;
    }

    public void setJobPriority(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, ThriftJobPriority priority) throws org.apache.hadoop.thriftfs.api.IOException, JobNotFoundException, org.apache.thrift.TException
    {
      send_setJobPriority(ctx, jobID, priority);
      recv_setJobPriority();
    }

    public void send_setJobPriority(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, ThriftJobPriority priority) throws org.apache.thrift.TException
    {
      setJobPriority_args args = new setJobPriority_args();
      args.setCtx(ctx);
      args.setJobID(jobID);
      args.setPriority(priority);
      sendBase("setJobPriority", args);
    }

    public void recv_setJobPriority() throws org.apache.hadoop.thriftfs.api.IOException, JobNotFoundException, org.apache.thrift.TException
    {
      setJobPriority_result result = new setJobPriority_result();
      receiveBase(result, "setJobPriority");
      if (result.err != null) {
        throw result.err;
      }
      if (result.jne != null) {
        throw result.jne;
      }
      return;
    }

    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_getDelegationToken(ctx, renewer);
      return recv_getDelegationToken();
    }

    public void send_getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer) throws org.apache.thrift.TException
    {
      getDelegationToken_args args = new getDelegationToken_args();
      args.setCtx(ctx);
      args.setRenewer(renewer);
      sendBase("getDelegationToken", args);
    }

    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken recv_getDelegationToken() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      getDelegationToken_result result = new getDelegationToken_result();
      receiveBase(result, "getDelegationToken");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDelegationToken failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.hadoop.thriftfs.api.HadoopServiceBase.AsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void getJobTrackerName(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getJobTrackerName_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getJobTrackerName_call method_call = new getJobTrackerName_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getJobTrackerName_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getJobTrackerName_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getJobTrackerName_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getJobTrackerName", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getJobTrackerName_args args = new getJobTrackerName_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getJobTrackerName();
      }
    }

    public void getClusterStatus(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getClusterStatus_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getClusterStatus_call method_call = new getClusterStatus_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getClusterStatus_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getClusterStatus_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getClusterStatus_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getClusterStatus", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getClusterStatus_args args = new getClusterStatus_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftClusterStatus getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getClusterStatus();
      }
    }

    public void getQueues(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getQueues_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getQueues_call method_call = new getQueues_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getQueues_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getQueues_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getQueues_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getQueues", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getQueues_args args = new getQueues_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobQueueList getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getQueues();
      }
    }

    public void getJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getJob_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getJob_call method_call = new getJob_call(ctx, jobID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getJob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftJobID jobID;
      public getJob_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getJob_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.jobID = jobID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getJob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getJob_args args = new getJob_args();
        args.setCtx(ctx);
        args.setJobID(jobID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobInProgress getResult() throws JobNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getJob();
      }
    }

    public void getRunningJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getRunningJobs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRunningJobs_call method_call = new getRunningJobs_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRunningJobs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getRunningJobs_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getRunningJobs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRunningJobs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRunningJobs_args args = new getRunningJobs_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobList getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRunningJobs();
      }
    }

    public void getCompletedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getCompletedJobs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getCompletedJobs_call method_call = new getCompletedJobs_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getCompletedJobs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getCompletedJobs_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getCompletedJobs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getCompletedJobs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getCompletedJobs_args args = new getCompletedJobs_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobList getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getCompletedJobs();
      }
    }

    public void getRetiredJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getRetiredJob_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRetiredJob_call method_call = new getRetiredJob_call(ctx, jobID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRetiredJob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftJobID jobID;
      public getRetiredJob_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getRetiredJob_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.jobID = jobID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRetiredJob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRetiredJob_args args = new getRetiredJob_args();
        args.setCtx(ctx);
        args.setJobID(jobID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobInProgress getResult() throws JobNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRetiredJob();
      }
    }

    public void getRetiredJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobState state, org.apache.thrift.async.AsyncMethodCallback<getRetiredJobs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRetiredJobs_call method_call = new getRetiredJobs_call(ctx, state, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRetiredJobs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftJobState state;
      public getRetiredJobs_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobState state, org.apache.thrift.async.AsyncMethodCallback<getRetiredJobs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.state = state;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRetiredJobs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRetiredJobs_args args = new getRetiredJobs_args();
        args.setCtx(ctx);
        args.setState(state);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobList getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRetiredJobs();
      }
    }

    public void getFailedJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getFailedJobs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getFailedJobs_call method_call = new getFailedJobs_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getFailedJobs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getFailedJobs_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getFailedJobs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getFailedJobs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getFailedJobs_args args = new getFailedJobs_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobList getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getFailedJobs();
      }
    }

    public void getKilledJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getKilledJobs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getKilledJobs_call method_call = new getKilledJobs_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getKilledJobs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getKilledJobs_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getKilledJobs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getKilledJobs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getKilledJobs_args args = new getKilledJobs_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobList getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getKilledJobs();
      }
    }

    public void getAllJobs(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getAllJobs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllJobs_call method_call = new getAllJobs_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllJobs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getAllJobs_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getAllJobs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllJobs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllJobs_args args = new getAllJobs_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobList getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllJobs();
      }
    }

    public void getUserJobCounts(org.apache.hadoop.thriftfs.api.RequestContext ctx, String user, org.apache.thrift.async.AsyncMethodCallback<getUserJobCounts_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserJobCounts_call method_call = new getUserJobCounts_call(ctx, user, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserJobCounts_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String user;
      public getUserJobCounts_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String user, org.apache.thrift.async.AsyncMethodCallback<getUserJobCounts_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.user = user;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserJobCounts", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserJobCounts_args args = new getUserJobCounts_args();
        args.setCtx(ctx);
        args.setUser(user);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftUserJobCounts getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserJobCounts();
      }
    }

    public void getTaskList(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, Set<ThriftTaskType> types, Set<ThriftTaskQueryState> states, String text, int count, int offset, org.apache.thrift.async.AsyncMethodCallback<getTaskList_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTaskList_call method_call = new getTaskList_call(ctx, jobID, types, states, text, count, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTaskList_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftJobID jobID;
      private Set<ThriftTaskType> types;
      private Set<ThriftTaskQueryState> states;
      private String text;
      private int count;
      private int offset;
      public getTaskList_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, Set<ThriftTaskType> types, Set<ThriftTaskQueryState> states, String text, int count, int offset, org.apache.thrift.async.AsyncMethodCallback<getTaskList_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.jobID = jobID;
        this.types = types;
        this.states = states;
        this.text = text;
        this.count = count;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTaskList", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTaskList_args args = new getTaskList_args();
        args.setCtx(ctx);
        args.setJobID(jobID);
        args.setTypes(types);
        args.setStates(states);
        args.setText(text);
        args.setCount(count);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftTaskInProgressList getResult() throws JobNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTaskList();
      }
    }

    public void getTask(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskID taskID, org.apache.thrift.async.AsyncMethodCallback<getTask_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTask_call method_call = new getTask_call(ctx, taskID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTask_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftTaskID taskID;
      public getTask_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskID taskID, org.apache.thrift.async.AsyncMethodCallback<getTask_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.taskID = taskID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTask", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTask_args args = new getTask_args();
        args.setCtx(ctx);
        args.setTaskID(taskID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftTaskInProgress getResult() throws JobNotFoundException, TaskNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTask();
      }
    }

    public void getJobCounters(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getJobCounters_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getJobCounters_call method_call = new getJobCounters_call(ctx, jobID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getJobCounters_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftJobID jobID;
      public getJobCounters_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getJobCounters_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.jobID = jobID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getJobCounters", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getJobCounters_args args = new getJobCounters_args();
        args.setCtx(ctx);
        args.setJobID(jobID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftGroupList getResult() throws JobNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getJobCounters();
      }
    }

    public void getJobCounterRollups(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getJobCounterRollups_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getJobCounterRollups_call method_call = new getJobCounterRollups_call(ctx, jobID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getJobCounterRollups_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftJobID jobID;
      public getJobCounterRollups_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getJobCounterRollups_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.jobID = jobID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getJobCounterRollups", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getJobCounterRollups_args args = new getJobCounterRollups_args();
        args.setCtx(ctx);
        args.setJobID(jobID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftJobCounterRollups getResult() throws JobNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getJobCounterRollups();
      }
    }

    public void getActiveTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getActiveTrackers_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getActiveTrackers_call method_call = new getActiveTrackers_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getActiveTrackers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getActiveTrackers_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getActiveTrackers_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getActiveTrackers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getActiveTrackers_args args = new getActiveTrackers_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftTaskTrackerStatusList getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getActiveTrackers();
      }
    }

    public void getBlacklistedTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getBlacklistedTrackers_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getBlacklistedTrackers_call method_call = new getBlacklistedTrackers_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getBlacklistedTrackers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getBlacklistedTrackers_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getBlacklistedTrackers_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getBlacklistedTrackers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getBlacklistedTrackers_args args = new getBlacklistedTrackers_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftTaskTrackerStatusList getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getBlacklistedTrackers();
      }
    }

    public void getAllTrackers(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getAllTrackers_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllTrackers_call method_call = new getAllTrackers_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllTrackers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getAllTrackers_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getAllTrackers_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllTrackers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllTrackers_args args = new getAllTrackers_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftTaskTrackerStatusList getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllTrackers();
      }
    }

    public void getTracker(org.apache.hadoop.thriftfs.api.RequestContext ctx, String name, org.apache.thrift.async.AsyncMethodCallback<getTracker_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTracker_call method_call = new getTracker_call(ctx, name, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTracker_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String name;
      public getTracker_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String name, org.apache.thrift.async.AsyncMethodCallback<getTracker_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.name = name;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTracker", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTracker_args args = new getTracker_args();
        args.setCtx(ctx);
        args.setName(name);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ThriftTaskTrackerStatus getResult() throws TaskTrackerNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTracker();
      }
    }

    public void getCurrentTime(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getCurrentTime_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getCurrentTime_call method_call = new getCurrentTime_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getCurrentTime_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public getCurrentTime_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<getCurrentTime_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getCurrentTime", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getCurrentTime_args args = new getCurrentTime_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public long getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getCurrentTime();
      }
    }

    public void getJobConfXML(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getJobConfXML_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getJobConfXML_call method_call = new getJobConfXML_call(ctx, jobID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getJobConfXML_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftJobID jobID;
      public getJobConfXML_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<getJobConfXML_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.jobID = jobID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getJobConfXML", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getJobConfXML_args args = new getJobConfXML_args();
        args.setCtx(ctx);
        args.setJobID(jobID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getJobConfXML();
      }
    }

    public void killJob(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<killJob_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      killJob_call method_call = new killJob_call(ctx, jobID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class killJob_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftJobID jobID;
      public killJob_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, org.apache.thrift.async.AsyncMethodCallback<killJob_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.jobID = jobID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("killJob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        killJob_args args = new killJob_args();
        args.setCtx(ctx);
        args.setJobID(jobID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, JobNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_killJob();
      }
    }

    public void killTaskAttempt(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskAttemptID attemptID, org.apache.thrift.async.AsyncMethodCallback<killTaskAttempt_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      killTaskAttempt_call method_call = new killTaskAttempt_call(ctx, attemptID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class killTaskAttempt_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftTaskAttemptID attemptID;
      public killTaskAttempt_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftTaskAttemptID attemptID, org.apache.thrift.async.AsyncMethodCallback<killTaskAttempt_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.attemptID = attemptID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("killTaskAttempt", org.apache.thrift.protocol.TMessageType.CALL, 0));
        killTaskAttempt_args args = new killTaskAttempt_args();
        args.setCtx(ctx);
        args.setAttemptID(attemptID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, TaskAttemptNotFoundException, JobNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_killTaskAttempt();
      }
    }

    public void setJobPriority(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, ThriftJobPriority priority, org.apache.thrift.async.AsyncMethodCallback<setJobPriority_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setJobPriority_call method_call = new setJobPriority_call(ctx, jobID, priority, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setJobPriority_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private ThriftJobID jobID;
      private ThriftJobPriority priority;
      public setJobPriority_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, ThriftJobID jobID, ThriftJobPriority priority, org.apache.thrift.async.AsyncMethodCallback<setJobPriority_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.jobID = jobID;
        this.priority = priority;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setJobPriority", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setJobPriority_args args = new setJobPriority_args();
        args.setCtx(ctx);
        args.setJobID(jobID);
        args.setPriority(priority);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, JobNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setJobPriority();
      }
    }

    public void getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer, org.apache.thrift.async.AsyncMethodCallback<getDelegationToken_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getDelegationToken_call method_call = new getDelegationToken_call(ctx, renewer, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getDelegationToken_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String renewer;
      public getDelegationToken_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer, org.apache.thrift.async.AsyncMethodCallback<getDelegationToken_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.renewer = renewer;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getDelegationToken", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getDelegationToken_args args = new getDelegationToken_args();
        args.setCtx(ctx);
        args.setRenewer(renewer);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.hadoop.thriftfs.api.ThriftDelegationToken getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getDelegationToken();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.hadoop.thriftfs.api.HadoopServiceBase.Processor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("getJobTrackerName", new getJobTrackerName());
      processMap.put("getClusterStatus", new getClusterStatus());
      processMap.put("getQueues", new getQueues());
      processMap.put("getJob", new getJob());
      processMap.put("getRunningJobs", new getRunningJobs());
      processMap.put("getCompletedJobs", new getCompletedJobs());
      processMap.put("getRetiredJob", new getRetiredJob());
      processMap.put("getRetiredJobs", new getRetiredJobs());
      processMap.put("getFailedJobs", new getFailedJobs());
      processMap.put("getKilledJobs", new getKilledJobs());
      processMap.put("getAllJobs", new getAllJobs());
      processMap.put("getUserJobCounts", new getUserJobCounts());
      processMap.put("getTaskList", new getTaskList());
      processMap.put("getTask", new getTask());
      processMap.put("getJobCounters", new getJobCounters());
      processMap.put("getJobCounterRollups", new getJobCounterRollups());
      processMap.put("getActiveTrackers", new getActiveTrackers());
      processMap.put("getBlacklistedTrackers", new getBlacklistedTrackers());
      processMap.put("getAllTrackers", new getAllTrackers());
      processMap.put("getTracker", new getTracker());
      processMap.put("getCurrentTime", new getCurrentTime());
      processMap.put("getJobConfXML", new getJobConfXML());
      processMap.put("killJob", new killJob());
      processMap.put("killTaskAttempt", new killTaskAttempt());
      processMap.put("setJobPriority", new setJobPriority());
      processMap.put("getDelegationToken", new getDelegationToken());
      return processMap;
    }

    public static class getJobTrackerName<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getJobTrackerName_args> {
      public getJobTrackerName() {
        super("getJobTrackerName");
      }

      public getJobTrackerName_args getEmptyArgsInstance() {
        return new getJobTrackerName_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getJobTrackerName_result getResult(I iface, getJobTrackerName_args args) throws org.apache.thrift.TException {
        getJobTrackerName_result result = new getJobTrackerName_result();
        result.success = iface.getJobTrackerName(args.ctx);
        return result;
      }
    }

    public static class getClusterStatus<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getClusterStatus_args> {
      public getClusterStatus() {
        super("getClusterStatus");
      }

      public getClusterStatus_args getEmptyArgsInstance() {
        return new getClusterStatus_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getClusterStatus_result getResult(I iface, getClusterStatus_args args) throws org.apache.thrift.TException {
        getClusterStatus_result result = new getClusterStatus_result();
        result.success = iface.getClusterStatus(args.ctx);
        return result;
      }
    }

    public static class getQueues<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getQueues_args> {
      public getQueues() {
        super("getQueues");
      }

      public getQueues_args getEmptyArgsInstance() {
        return new getQueues_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getQueues_result getResult(I iface, getQueues_args args) throws org.apache.thrift.TException {
        getQueues_result result = new getQueues_result();
        try {
          result.success = iface.getQueues(args.ctx);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class getJob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getJob_args> {
      public getJob() {
        super("getJob");
      }

      public getJob_args getEmptyArgsInstance() {
        return new getJob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getJob_result getResult(I iface, getJob_args args) throws org.apache.thrift.TException {
        getJob_result result = new getJob_result();
        try {
          result.success = iface.getJob(args.ctx, args.jobID);
        } catch (JobNotFoundException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class getRunningJobs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRunningJobs_args> {
      public getRunningJobs() {
        super("getRunningJobs");
      }

      public getRunningJobs_args getEmptyArgsInstance() {
        return new getRunningJobs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRunningJobs_result getResult(I iface, getRunningJobs_args args) throws org.apache.thrift.TException {
        getRunningJobs_result result = new getRunningJobs_result();
        result.success = iface.getRunningJobs(args.ctx);
        return result;
      }
    }

    public static class getCompletedJobs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getCompletedJobs_args> {
      public getCompletedJobs() {
        super("getCompletedJobs");
      }

      public getCompletedJobs_args getEmptyArgsInstance() {
        return new getCompletedJobs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getCompletedJobs_result getResult(I iface, getCompletedJobs_args args) throws org.apache.thrift.TException {
        getCompletedJobs_result result = new getCompletedJobs_result();
        result.success = iface.getCompletedJobs(args.ctx);
        return result;
      }
    }

    public static class getRetiredJob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRetiredJob_args> {
      public getRetiredJob() {
        super("getRetiredJob");
      }

      public getRetiredJob_args getEmptyArgsInstance() {
        return new getRetiredJob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRetiredJob_result getResult(I iface, getRetiredJob_args args) throws org.apache.thrift.TException {
        getRetiredJob_result result = new getRetiredJob_result();
        try {
          result.success = iface.getRetiredJob(args.ctx, args.jobID);
        } catch (JobNotFoundException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class getRetiredJobs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRetiredJobs_args> {
      public getRetiredJobs() {
        super("getRetiredJobs");
      }

      public getRetiredJobs_args getEmptyArgsInstance() {
        return new getRetiredJobs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRetiredJobs_result getResult(I iface, getRetiredJobs_args args) throws org.apache.thrift.TException {
        getRetiredJobs_result result = new getRetiredJobs_result();
        result.success = iface.getRetiredJobs(args.ctx, args.state);
        return result;
      }
    }

    public static class getFailedJobs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getFailedJobs_args> {
      public getFailedJobs() {
        super("getFailedJobs");
      }

      public getFailedJobs_args getEmptyArgsInstance() {
        return new getFailedJobs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getFailedJobs_result getResult(I iface, getFailedJobs_args args) throws org.apache.thrift.TException {
        getFailedJobs_result result = new getFailedJobs_result();
        result.success = iface.getFailedJobs(args.ctx);
        return result;
      }
    }

    public static class getKilledJobs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getKilledJobs_args> {
      public getKilledJobs() {
        super("getKilledJobs");
      }

      public getKilledJobs_args getEmptyArgsInstance() {
        return new getKilledJobs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getKilledJobs_result getResult(I iface, getKilledJobs_args args) throws org.apache.thrift.TException {
        getKilledJobs_result result = new getKilledJobs_result();
        result.success = iface.getKilledJobs(args.ctx);
        return result;
      }
    }

    public static class getAllJobs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllJobs_args> {
      public getAllJobs() {
        super("getAllJobs");
      }

      public getAllJobs_args getEmptyArgsInstance() {
        return new getAllJobs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllJobs_result getResult(I iface, getAllJobs_args args) throws org.apache.thrift.TException {
        getAllJobs_result result = new getAllJobs_result();
        result.success = iface.getAllJobs(args.ctx);
        return result;
      }
    }

    public static class getUserJobCounts<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserJobCounts_args> {
      public getUserJobCounts() {
        super("getUserJobCounts");
      }

      public getUserJobCounts_args getEmptyArgsInstance() {
        return new getUserJobCounts_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserJobCounts_result getResult(I iface, getUserJobCounts_args args) throws org.apache.thrift.TException {
        getUserJobCounts_result result = new getUserJobCounts_result();
        result.success = iface.getUserJobCounts(args.ctx, args.user);
        return result;
      }
    }

    public static class getTaskList<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTaskList_args> {
      public getTaskList() {
        super("getTaskList");
      }

      public getTaskList_args getEmptyArgsInstance() {
        return new getTaskList_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTaskList_result getResult(I iface, getTaskList_args args) throws org.apache.thrift.TException {
        getTaskList_result result = new getTaskList_result();
        try {
          result.success = iface.getTaskList(args.ctx, args.jobID, args.types, args.states, args.text, args.count, args.offset);
        } catch (JobNotFoundException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class getTask<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTask_args> {
      public getTask() {
        super("getTask");
      }

      public getTask_args getEmptyArgsInstance() {
        return new getTask_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTask_result getResult(I iface, getTask_args args) throws org.apache.thrift.TException {
        getTask_result result = new getTask_result();
        try {
          result.success = iface.getTask(args.ctx, args.taskID);
        } catch (JobNotFoundException jnf) {
          result.jnf = jnf;
        } catch (TaskNotFoundException tnf) {
          result.tnf = tnf;
        }
        return result;
      }
    }

    public static class getJobCounters<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getJobCounters_args> {
      public getJobCounters() {
        super("getJobCounters");
      }

      public getJobCounters_args getEmptyArgsInstance() {
        return new getJobCounters_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getJobCounters_result getResult(I iface, getJobCounters_args args) throws org.apache.thrift.TException {
        getJobCounters_result result = new getJobCounters_result();
        try {
          result.success = iface.getJobCounters(args.ctx, args.jobID);
        } catch (JobNotFoundException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class getJobCounterRollups<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getJobCounterRollups_args> {
      public getJobCounterRollups() {
        super("getJobCounterRollups");
      }

      public getJobCounterRollups_args getEmptyArgsInstance() {
        return new getJobCounterRollups_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getJobCounterRollups_result getResult(I iface, getJobCounterRollups_args args) throws org.apache.thrift.TException {
        getJobCounterRollups_result result = new getJobCounterRollups_result();
        try {
          result.success = iface.getJobCounterRollups(args.ctx, args.jobID);
        } catch (JobNotFoundException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class getActiveTrackers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getActiveTrackers_args> {
      public getActiveTrackers() {
        super("getActiveTrackers");
      }

      public getActiveTrackers_args getEmptyArgsInstance() {
        return new getActiveTrackers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getActiveTrackers_result getResult(I iface, getActiveTrackers_args args) throws org.apache.thrift.TException {
        getActiveTrackers_result result = new getActiveTrackers_result();
        result.success = iface.getActiveTrackers(args.ctx);
        return result;
      }
    }

    public static class getBlacklistedTrackers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getBlacklistedTrackers_args> {
      public getBlacklistedTrackers() {
        super("getBlacklistedTrackers");
      }

      public getBlacklistedTrackers_args getEmptyArgsInstance() {
        return new getBlacklistedTrackers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getBlacklistedTrackers_result getResult(I iface, getBlacklistedTrackers_args args) throws org.apache.thrift.TException {
        getBlacklistedTrackers_result result = new getBlacklistedTrackers_result();
        result.success = iface.getBlacklistedTrackers(args.ctx);
        return result;
      }
    }

    public static class getAllTrackers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllTrackers_args> {
      public getAllTrackers() {
        super("getAllTrackers");
      }

      public getAllTrackers_args getEmptyArgsInstance() {
        return new getAllTrackers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllTrackers_result getResult(I iface, getAllTrackers_args args) throws org.apache.thrift.TException {
        getAllTrackers_result result = new getAllTrackers_result();
        result.success = iface.getAllTrackers(args.ctx);
        return result;
      }
    }

    public static class getTracker<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTracker_args> {
      public getTracker() {
        super("getTracker");
      }

      public getTracker_args getEmptyArgsInstance() {
        return new getTracker_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTracker_result getResult(I iface, getTracker_args args) throws org.apache.thrift.TException {
        getTracker_result result = new getTracker_result();
        try {
          result.success = iface.getTracker(args.ctx, args.name);
        } catch (TaskTrackerNotFoundException tne) {
          result.tne = tne;
        }
        return result;
      }
    }

    public static class getCurrentTime<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getCurrentTime_args> {
      public getCurrentTime() {
        super("getCurrentTime");
      }

      public getCurrentTime_args getEmptyArgsInstance() {
        return new getCurrentTime_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getCurrentTime_result getResult(I iface, getCurrentTime_args args) throws org.apache.thrift.TException {
        getCurrentTime_result result = new getCurrentTime_result();
        result.success = iface.getCurrentTime(args.ctx);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class getJobConfXML<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getJobConfXML_args> {
      public getJobConfXML() {
        super("getJobConfXML");
      }

      public getJobConfXML_args getEmptyArgsInstance() {
        return new getJobConfXML_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getJobConfXML_result getResult(I iface, getJobConfXML_args args) throws org.apache.thrift.TException {
        getJobConfXML_result result = new getJobConfXML_result();
        try {
          result.success = iface.getJobConfXML(args.ctx, args.jobID);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class killJob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, killJob_args> {
      public killJob() {
        super("killJob");
      }

      public killJob_args getEmptyArgsInstance() {
        return new killJob_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public killJob_result getResult(I iface, killJob_args args) throws org.apache.thrift.TException {
        killJob_result result = new killJob_result();
        try {
          iface.killJob(args.ctx, args.jobID);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        } catch (JobNotFoundException jne) {
          result.jne = jne;
        }
        return result;
      }
    }

    public static class killTaskAttempt<I extends Iface> extends org.apache.thrift.ProcessFunction<I, killTaskAttempt_args> {
      public killTaskAttempt() {
        super("killTaskAttempt");
      }

      public killTaskAttempt_args getEmptyArgsInstance() {
        return new killTaskAttempt_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public killTaskAttempt_result getResult(I iface, killTaskAttempt_args args) throws org.apache.thrift.TException {
        killTaskAttempt_result result = new killTaskAttempt_result();
        try {
          iface.killTaskAttempt(args.ctx, args.attemptID);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        } catch (TaskAttemptNotFoundException tne) {
          result.tne = tne;
        } catch (JobNotFoundException jne) {
          result.jne = jne;
        }
        return result;
      }
    }

    public static class setJobPriority<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setJobPriority_args> {
      public setJobPriority() {
        super("setJobPriority");
      }

      public setJobPriority_args getEmptyArgsInstance() {
        return new setJobPriority_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setJobPriority_result getResult(I iface, setJobPriority_args args) throws org.apache.thrift.TException {
        setJobPriority_result result = new setJobPriority_result();
        try {
          iface.setJobPriority(args.ctx, args.jobID, args.priority);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        } catch (JobNotFoundException jne) {
          result.jne = jne;
        }
        return result;
      }
    }

    public static class getDelegationToken<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getDelegationToken_args> {
      public getDelegationToken() {
        super("getDelegationToken");
      }

      public getDelegationToken_args getEmptyArgsInstance() {
        return new getDelegationToken_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getDelegationToken_result getResult(I iface, getDelegationToken_args args) throws org.apache.thrift.TException {
        getDelegationToken_result result = new getDelegationToken_result();
        try {
          result.success = iface.getDelegationToken(args.ctx, args.renewer);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

  }

  public static class getJobTrackerName_args implements org.apache.thrift.TBase<getJobTrackerName_args, getJobTrackerName_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJobTrackerName_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJobTrackerName_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJobTrackerName_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJobTrackerName_args.class, metaDataMap);
    }

    public getJobTrackerName_args() {
    }

    public getJobTrackerName_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJobTrackerName_args(getJobTrackerName_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getJobTrackerName_args deepCopy() {
      return new getJobTrackerName_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getJobTrackerName_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJobTrackerName_args)
        return this.equals((getJobTrackerName_args)that);
      return false;
    }

    public boolean equals(getJobTrackerName_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJobTrackerName_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJobTrackerName_args typedOther = (getJobTrackerName_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJobTrackerName_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJobTrackerName_argsStandardSchemeFactory implements SchemeFactory {
      public getJobTrackerName_argsStandardScheme getScheme() {
        return new getJobTrackerName_argsStandardScheme();
      }
    }

    private static class getJobTrackerName_argsStandardScheme extends StandardScheme<getJobTrackerName_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJobTrackerName_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJobTrackerName_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJobTrackerName_argsTupleSchemeFactory implements SchemeFactory {
      public getJobTrackerName_argsTupleScheme getScheme() {
        return new getJobTrackerName_argsTupleScheme();
      }
    }

    private static class getJobTrackerName_argsTupleScheme extends TupleScheme<getJobTrackerName_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJobTrackerName_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJobTrackerName_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getJobTrackerName_result implements org.apache.thrift.TBase<getJobTrackerName_result, getJobTrackerName_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJobTrackerName_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJobTrackerName_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJobTrackerName_resultTupleSchemeFactory());
    }

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJobTrackerName_result.class, metaDataMap);
    }

    public getJobTrackerName_result() {
    }

    public getJobTrackerName_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJobTrackerName_result(getJobTrackerName_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public getJobTrackerName_result deepCopy() {
      return new getJobTrackerName_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public getJobTrackerName_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJobTrackerName_result)
        return this.equals((getJobTrackerName_result)that);
      return false;
    }

    public boolean equals(getJobTrackerName_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJobTrackerName_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJobTrackerName_result typedOther = (getJobTrackerName_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJobTrackerName_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJobTrackerName_resultStandardSchemeFactory implements SchemeFactory {
      public getJobTrackerName_resultStandardScheme getScheme() {
        return new getJobTrackerName_resultStandardScheme();
      }
    }

    private static class getJobTrackerName_resultStandardScheme extends StandardScheme<getJobTrackerName_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJobTrackerName_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJobTrackerName_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJobTrackerName_resultTupleSchemeFactory implements SchemeFactory {
      public getJobTrackerName_resultTupleScheme getScheme() {
        return new getJobTrackerName_resultTupleScheme();
      }
    }

    private static class getJobTrackerName_resultTupleScheme extends TupleScheme<getJobTrackerName_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJobTrackerName_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJobTrackerName_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getClusterStatus_args implements org.apache.thrift.TBase<getClusterStatus_args, getClusterStatus_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getClusterStatus_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getClusterStatus_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getClusterStatus_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getClusterStatus_args.class, metaDataMap);
    }

    public getClusterStatus_args() {
    }

    public getClusterStatus_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getClusterStatus_args(getClusterStatus_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getClusterStatus_args deepCopy() {
      return new getClusterStatus_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getClusterStatus_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getClusterStatus_args)
        return this.equals((getClusterStatus_args)that);
      return false;
    }

    public boolean equals(getClusterStatus_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getClusterStatus_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getClusterStatus_args typedOther = (getClusterStatus_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getClusterStatus_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getClusterStatus_argsStandardSchemeFactory implements SchemeFactory {
      public getClusterStatus_argsStandardScheme getScheme() {
        return new getClusterStatus_argsStandardScheme();
      }
    }

    private static class getClusterStatus_argsStandardScheme extends StandardScheme<getClusterStatus_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getClusterStatus_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getClusterStatus_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getClusterStatus_argsTupleSchemeFactory implements SchemeFactory {
      public getClusterStatus_argsTupleScheme getScheme() {
        return new getClusterStatus_argsTupleScheme();
      }
    }

    private static class getClusterStatus_argsTupleScheme extends TupleScheme<getClusterStatus_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getClusterStatus_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getClusterStatus_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getClusterStatus_result implements org.apache.thrift.TBase<getClusterStatus_result, getClusterStatus_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getClusterStatus_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getClusterStatus_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getClusterStatus_resultTupleSchemeFactory());
    }

    public ThriftClusterStatus success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftClusterStatus.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getClusterStatus_result.class, metaDataMap);
    }

    public getClusterStatus_result() {
    }

    public getClusterStatus_result(
      ThriftClusterStatus success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getClusterStatus_result(getClusterStatus_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftClusterStatus(other.success);
      }
    }

    public getClusterStatus_result deepCopy() {
      return new getClusterStatus_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftClusterStatus getSuccess() {
      return this.success;
    }

    public getClusterStatus_result setSuccess(ThriftClusterStatus success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftClusterStatus)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getClusterStatus_result)
        return this.equals((getClusterStatus_result)that);
      return false;
    }

    public boolean equals(getClusterStatus_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getClusterStatus_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getClusterStatus_result typedOther = (getClusterStatus_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getClusterStatus_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getClusterStatus_resultStandardSchemeFactory implements SchemeFactory {
      public getClusterStatus_resultStandardScheme getScheme() {
        return new getClusterStatus_resultStandardScheme();
      }
    }

    private static class getClusterStatus_resultStandardScheme extends StandardScheme<getClusterStatus_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getClusterStatus_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftClusterStatus();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getClusterStatus_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getClusterStatus_resultTupleSchemeFactory implements SchemeFactory {
      public getClusterStatus_resultTupleScheme getScheme() {
        return new getClusterStatus_resultTupleScheme();
      }
    }

    private static class getClusterStatus_resultTupleScheme extends TupleScheme<getClusterStatus_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getClusterStatus_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getClusterStatus_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftClusterStatus();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getQueues_args implements org.apache.thrift.TBase<getQueues_args, getQueues_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getQueues_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getQueues_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getQueues_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getQueues_args.class, metaDataMap);
    }

    public getQueues_args() {
    }

    public getQueues_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getQueues_args(getQueues_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getQueues_args deepCopy() {
      return new getQueues_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getQueues_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getQueues_args)
        return this.equals((getQueues_args)that);
      return false;
    }

    public boolean equals(getQueues_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getQueues_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getQueues_args typedOther = (getQueues_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getQueues_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getQueues_argsStandardSchemeFactory implements SchemeFactory {
      public getQueues_argsStandardScheme getScheme() {
        return new getQueues_argsStandardScheme();
      }
    }

    private static class getQueues_argsStandardScheme extends StandardScheme<getQueues_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getQueues_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getQueues_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getQueues_argsTupleSchemeFactory implements SchemeFactory {
      public getQueues_argsTupleScheme getScheme() {
        return new getQueues_argsTupleScheme();
      }
    }

    private static class getQueues_argsTupleScheme extends TupleScheme<getQueues_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getQueues_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getQueues_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getQueues_result implements org.apache.thrift.TBase<getQueues_result, getQueues_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getQueues_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getQueues_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getQueues_resultTupleSchemeFactory());
    }

    public ThriftJobQueueList success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobQueueList.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getQueues_result.class, metaDataMap);
    }

    public getQueues_result() {
    }

    public getQueues_result(
      ThriftJobQueueList success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getQueues_result(getQueues_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobQueueList(other.success);
      }
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public getQueues_result deepCopy() {
      return new getQueues_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public ThriftJobQueueList getSuccess() {
      return this.success;
    }

    public getQueues_result setSuccess(ThriftJobQueueList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public getQueues_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobQueueList)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getQueues_result)
        return this.equals((getQueues_result)that);
      return false;
    }

    public boolean equals(getQueues_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getQueues_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getQueues_result typedOther = (getQueues_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getQueues_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getQueues_resultStandardSchemeFactory implements SchemeFactory {
      public getQueues_resultStandardScheme getScheme() {
        return new getQueues_resultStandardScheme();
      }
    }

    private static class getQueues_resultStandardScheme extends StandardScheme<getQueues_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getQueues_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobQueueList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getQueues_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getQueues_resultTupleSchemeFactory implements SchemeFactory {
      public getQueues_resultTupleScheme getScheme() {
        return new getQueues_resultTupleScheme();
      }
    }

    private static class getQueues_resultTupleScheme extends TupleScheme<getQueues_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getQueues_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getQueues_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ThriftJobQueueList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class getJob_args implements org.apache.thrift.TBase<getJob_args, getJob_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJob_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField JOB_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("jobID", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJob_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftJobID jobID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      JOB_ID((short)1, "jobID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // JOB_ID
            return JOB_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.JOB_ID, new org.apache.thrift.meta_data.FieldMetaData("jobID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobID.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJob_args.class, metaDataMap);
    }

    public getJob_args() {
    }

    public getJob_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftJobID jobID)
    {
      this();
      this.ctx = ctx;
      this.jobID = jobID;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJob_args(getJob_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetJobID()) {
        this.jobID = new ThriftJobID(other.jobID);
      }
    }

    public getJob_args deepCopy() {
      return new getJob_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.jobID = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getJob_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftJobID getJobID() {
      return this.jobID;
    }

    public getJob_args setJobID(ThriftJobID jobID) {
      this.jobID = jobID;
      return this;
    }

    public void unsetJobID() {
      this.jobID = null;
    }

    /** Returns true if field jobID is set (has been assigned a value) and false otherwise */
    public boolean isSetJobID() {
      return this.jobID != null;
    }

    public void setJobIDIsSet(boolean value) {
      if (!value) {
        this.jobID = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case JOB_ID:
        if (value == null) {
          unsetJobID();
        } else {
          setJobID((ThriftJobID)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case JOB_ID:
        return getJobID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case JOB_ID:
        return isSetJobID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJob_args)
        return this.equals((getJob_args)that);
      return false;
    }

    public boolean equals(getJob_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_jobID = true && this.isSetJobID();
      boolean that_present_jobID = true && that.isSetJobID();
      if (this_present_jobID || that_present_jobID) {
        if (!(this_present_jobID && that_present_jobID))
          return false;
        if (!this.jobID.equals(that.jobID))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJob_args typedOther = (getJob_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJobID()).compareTo(typedOther.isSetJobID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJobID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jobID, typedOther.jobID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJob_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jobID:");
      if (this.jobID == null) {
        sb.append("null");
      } else {
        sb.append(this.jobID);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (jobID != null) {
        jobID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJob_argsStandardSchemeFactory implements SchemeFactory {
      public getJob_argsStandardScheme getScheme() {
        return new getJob_argsStandardScheme();
      }
    }

    private static class getJob_argsStandardScheme extends StandardScheme<getJob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // JOB_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jobID = new ThriftJobID();
                struct.jobID.read(iprot);
                struct.setJobIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.jobID != null) {
          oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
          struct.jobID.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJob_argsTupleSchemeFactory implements SchemeFactory {
      public getJob_argsTupleScheme getScheme() {
        return new getJob_argsTupleScheme();
      }
    }

    private static class getJob_argsTupleScheme extends TupleScheme<getJob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetJobID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetJobID()) {
          struct.jobID.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jobID = new ThriftJobID();
          struct.jobID.read(iprot);
          struct.setJobIDIsSet(true);
        }
      }
    }

  }

  public static class getJob_result implements org.apache.thrift.TBase<getJob_result, getJob_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJob_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJob_resultTupleSchemeFactory());
    }

    public ThriftJobInProgress success; // required
    public JobNotFoundException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobInProgress.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJob_result.class, metaDataMap);
    }

    public getJob_result() {
    }

    public getJob_result(
      ThriftJobInProgress success,
      JobNotFoundException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJob_result(getJob_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobInProgress(other.success);
      }
      if (other.isSetErr()) {
        this.err = new JobNotFoundException(other.err);
      }
    }

    public getJob_result deepCopy() {
      return new getJob_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public ThriftJobInProgress getSuccess() {
      return this.success;
    }

    public getJob_result setSuccess(ThriftJobInProgress success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public JobNotFoundException getErr() {
      return this.err;
    }

    public getJob_result setErr(JobNotFoundException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobInProgress)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((JobNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJob_result)
        return this.equals((getJob_result)that);
      return false;
    }

    public boolean equals(getJob_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJob_result typedOther = (getJob_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJob_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJob_resultStandardSchemeFactory implements SchemeFactory {
      public getJob_resultStandardScheme getScheme() {
        return new getJob_resultStandardScheme();
      }
    }

    private static class getJob_resultStandardScheme extends StandardScheme<getJob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobInProgress();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new JobNotFoundException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJob_resultTupleSchemeFactory implements SchemeFactory {
      public getJob_resultTupleScheme getScheme() {
        return new getJob_resultTupleScheme();
      }
    }

    private static class getJob_resultTupleScheme extends TupleScheme<getJob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ThriftJobInProgress();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new JobNotFoundException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class getRunningJobs_args implements org.apache.thrift.TBase<getRunningJobs_args, getRunningJobs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRunningJobs_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRunningJobs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRunningJobs_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRunningJobs_args.class, metaDataMap);
    }

    public getRunningJobs_args() {
    }

    public getRunningJobs_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRunningJobs_args(getRunningJobs_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getRunningJobs_args deepCopy() {
      return new getRunningJobs_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getRunningJobs_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRunningJobs_args)
        return this.equals((getRunningJobs_args)that);
      return false;
    }

    public boolean equals(getRunningJobs_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getRunningJobs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRunningJobs_args typedOther = (getRunningJobs_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRunningJobs_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRunningJobs_argsStandardSchemeFactory implements SchemeFactory {
      public getRunningJobs_argsStandardScheme getScheme() {
        return new getRunningJobs_argsStandardScheme();
      }
    }

    private static class getRunningJobs_argsStandardScheme extends StandardScheme<getRunningJobs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRunningJobs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRunningJobs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRunningJobs_argsTupleSchemeFactory implements SchemeFactory {
      public getRunningJobs_argsTupleScheme getScheme() {
        return new getRunningJobs_argsTupleScheme();
      }
    }

    private static class getRunningJobs_argsTupleScheme extends TupleScheme<getRunningJobs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRunningJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRunningJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getRunningJobs_result implements org.apache.thrift.TBase<getRunningJobs_result, getRunningJobs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRunningJobs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRunningJobs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRunningJobs_resultTupleSchemeFactory());
    }

    public ThriftJobList success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobList.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRunningJobs_result.class, metaDataMap);
    }

    public getRunningJobs_result() {
    }

    public getRunningJobs_result(
      ThriftJobList success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRunningJobs_result(getRunningJobs_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobList(other.success);
      }
    }

    public getRunningJobs_result deepCopy() {
      return new getRunningJobs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftJobList getSuccess() {
      return this.success;
    }

    public getRunningJobs_result setSuccess(ThriftJobList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobList)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRunningJobs_result)
        return this.equals((getRunningJobs_result)that);
      return false;
    }

    public boolean equals(getRunningJobs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getRunningJobs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRunningJobs_result typedOther = (getRunningJobs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRunningJobs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRunningJobs_resultStandardSchemeFactory implements SchemeFactory {
      public getRunningJobs_resultStandardScheme getScheme() {
        return new getRunningJobs_resultStandardScheme();
      }
    }

    private static class getRunningJobs_resultStandardScheme extends StandardScheme<getRunningJobs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRunningJobs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRunningJobs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRunningJobs_resultTupleSchemeFactory implements SchemeFactory {
      public getRunningJobs_resultTupleScheme getScheme() {
        return new getRunningJobs_resultTupleScheme();
      }
    }

    private static class getRunningJobs_resultTupleScheme extends TupleScheme<getRunningJobs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRunningJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRunningJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftJobList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getCompletedJobs_args implements org.apache.thrift.TBase<getCompletedJobs_args, getCompletedJobs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getCompletedJobs_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getCompletedJobs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getCompletedJobs_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getCompletedJobs_args.class, metaDataMap);
    }

    public getCompletedJobs_args() {
    }

    public getCompletedJobs_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getCompletedJobs_args(getCompletedJobs_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getCompletedJobs_args deepCopy() {
      return new getCompletedJobs_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getCompletedJobs_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getCompletedJobs_args)
        return this.equals((getCompletedJobs_args)that);
      return false;
    }

    public boolean equals(getCompletedJobs_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getCompletedJobs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getCompletedJobs_args typedOther = (getCompletedJobs_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getCompletedJobs_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getCompletedJobs_argsStandardSchemeFactory implements SchemeFactory {
      public getCompletedJobs_argsStandardScheme getScheme() {
        return new getCompletedJobs_argsStandardScheme();
      }
    }

    private static class getCompletedJobs_argsStandardScheme extends StandardScheme<getCompletedJobs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getCompletedJobs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getCompletedJobs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getCompletedJobs_argsTupleSchemeFactory implements SchemeFactory {
      public getCompletedJobs_argsTupleScheme getScheme() {
        return new getCompletedJobs_argsTupleScheme();
      }
    }

    private static class getCompletedJobs_argsTupleScheme extends TupleScheme<getCompletedJobs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getCompletedJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getCompletedJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getCompletedJobs_result implements org.apache.thrift.TBase<getCompletedJobs_result, getCompletedJobs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getCompletedJobs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getCompletedJobs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getCompletedJobs_resultTupleSchemeFactory());
    }

    public ThriftJobList success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobList.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getCompletedJobs_result.class, metaDataMap);
    }

    public getCompletedJobs_result() {
    }

    public getCompletedJobs_result(
      ThriftJobList success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getCompletedJobs_result(getCompletedJobs_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobList(other.success);
      }
    }

    public getCompletedJobs_result deepCopy() {
      return new getCompletedJobs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftJobList getSuccess() {
      return this.success;
    }

    public getCompletedJobs_result setSuccess(ThriftJobList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobList)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getCompletedJobs_result)
        return this.equals((getCompletedJobs_result)that);
      return false;
    }

    public boolean equals(getCompletedJobs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getCompletedJobs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getCompletedJobs_result typedOther = (getCompletedJobs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getCompletedJobs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getCompletedJobs_resultStandardSchemeFactory implements SchemeFactory {
      public getCompletedJobs_resultStandardScheme getScheme() {
        return new getCompletedJobs_resultStandardScheme();
      }
    }

    private static class getCompletedJobs_resultStandardScheme extends StandardScheme<getCompletedJobs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getCompletedJobs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getCompletedJobs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getCompletedJobs_resultTupleSchemeFactory implements SchemeFactory {
      public getCompletedJobs_resultTupleScheme getScheme() {
        return new getCompletedJobs_resultTupleScheme();
      }
    }

    private static class getCompletedJobs_resultTupleScheme extends TupleScheme<getCompletedJobs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getCompletedJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getCompletedJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftJobList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getRetiredJob_args implements org.apache.thrift.TBase<getRetiredJob_args, getRetiredJob_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRetiredJob_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField JOB_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("jobID", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRetiredJob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRetiredJob_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftJobID jobID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      JOB_ID((short)1, "jobID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // JOB_ID
            return JOB_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.JOB_ID, new org.apache.thrift.meta_data.FieldMetaData("jobID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobID.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRetiredJob_args.class, metaDataMap);
    }

    public getRetiredJob_args() {
    }

    public getRetiredJob_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftJobID jobID)
    {
      this();
      this.ctx = ctx;
      this.jobID = jobID;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRetiredJob_args(getRetiredJob_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetJobID()) {
        this.jobID = new ThriftJobID(other.jobID);
      }
    }

    public getRetiredJob_args deepCopy() {
      return new getRetiredJob_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.jobID = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getRetiredJob_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftJobID getJobID() {
      return this.jobID;
    }

    public getRetiredJob_args setJobID(ThriftJobID jobID) {
      this.jobID = jobID;
      return this;
    }

    public void unsetJobID() {
      this.jobID = null;
    }

    /** Returns true if field jobID is set (has been assigned a value) and false otherwise */
    public boolean isSetJobID() {
      return this.jobID != null;
    }

    public void setJobIDIsSet(boolean value) {
      if (!value) {
        this.jobID = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case JOB_ID:
        if (value == null) {
          unsetJobID();
        } else {
          setJobID((ThriftJobID)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case JOB_ID:
        return getJobID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case JOB_ID:
        return isSetJobID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRetiredJob_args)
        return this.equals((getRetiredJob_args)that);
      return false;
    }

    public boolean equals(getRetiredJob_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_jobID = true && this.isSetJobID();
      boolean that_present_jobID = true && that.isSetJobID();
      if (this_present_jobID || that_present_jobID) {
        if (!(this_present_jobID && that_present_jobID))
          return false;
        if (!this.jobID.equals(that.jobID))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getRetiredJob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRetiredJob_args typedOther = (getRetiredJob_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJobID()).compareTo(typedOther.isSetJobID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJobID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jobID, typedOther.jobID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRetiredJob_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jobID:");
      if (this.jobID == null) {
        sb.append("null");
      } else {
        sb.append(this.jobID);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (jobID != null) {
        jobID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRetiredJob_argsStandardSchemeFactory implements SchemeFactory {
      public getRetiredJob_argsStandardScheme getScheme() {
        return new getRetiredJob_argsStandardScheme();
      }
    }

    private static class getRetiredJob_argsStandardScheme extends StandardScheme<getRetiredJob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRetiredJob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // JOB_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jobID = new ThriftJobID();
                struct.jobID.read(iprot);
                struct.setJobIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRetiredJob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.jobID != null) {
          oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
          struct.jobID.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRetiredJob_argsTupleSchemeFactory implements SchemeFactory {
      public getRetiredJob_argsTupleScheme getScheme() {
        return new getRetiredJob_argsTupleScheme();
      }
    }

    private static class getRetiredJob_argsTupleScheme extends TupleScheme<getRetiredJob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRetiredJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetJobID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetJobID()) {
          struct.jobID.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRetiredJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jobID = new ThriftJobID();
          struct.jobID.read(iprot);
          struct.setJobIDIsSet(true);
        }
      }
    }

  }

  public static class getRetiredJob_result implements org.apache.thrift.TBase<getRetiredJob_result, getRetiredJob_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRetiredJob_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRetiredJob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRetiredJob_resultTupleSchemeFactory());
    }

    public ThriftJobInProgress success; // required
    public JobNotFoundException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobInProgress.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRetiredJob_result.class, metaDataMap);
    }

    public getRetiredJob_result() {
    }

    public getRetiredJob_result(
      ThriftJobInProgress success,
      JobNotFoundException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRetiredJob_result(getRetiredJob_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobInProgress(other.success);
      }
      if (other.isSetErr()) {
        this.err = new JobNotFoundException(other.err);
      }
    }

    public getRetiredJob_result deepCopy() {
      return new getRetiredJob_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public ThriftJobInProgress getSuccess() {
      return this.success;
    }

    public getRetiredJob_result setSuccess(ThriftJobInProgress success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public JobNotFoundException getErr() {
      return this.err;
    }

    public getRetiredJob_result setErr(JobNotFoundException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobInProgress)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((JobNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRetiredJob_result)
        return this.equals((getRetiredJob_result)that);
      return false;
    }

    public boolean equals(getRetiredJob_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getRetiredJob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRetiredJob_result typedOther = (getRetiredJob_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRetiredJob_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRetiredJob_resultStandardSchemeFactory implements SchemeFactory {
      public getRetiredJob_resultStandardScheme getScheme() {
        return new getRetiredJob_resultStandardScheme();
      }
    }

    private static class getRetiredJob_resultStandardScheme extends StandardScheme<getRetiredJob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRetiredJob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobInProgress();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new JobNotFoundException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRetiredJob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRetiredJob_resultTupleSchemeFactory implements SchemeFactory {
      public getRetiredJob_resultTupleScheme getScheme() {
        return new getRetiredJob_resultTupleScheme();
      }
    }

    private static class getRetiredJob_resultTupleScheme extends TupleScheme<getRetiredJob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRetiredJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRetiredJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ThriftJobInProgress();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new JobNotFoundException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class getRetiredJobs_args implements org.apache.thrift.TBase<getRetiredJobs_args, getRetiredJobs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRetiredJobs_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField STATE_FIELD_DESC = new org.apache.thrift.protocol.TField("state", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRetiredJobs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRetiredJobs_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * 
     * @see ThriftJobState
     */
    public ThriftJobState state; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * 
       * @see ThriftJobState
       */
      STATE((short)1, "state");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // STATE
            return STATE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.STATE, new org.apache.thrift.meta_data.FieldMetaData("state", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ThriftJobState.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRetiredJobs_args.class, metaDataMap);
    }

    public getRetiredJobs_args() {
    }

    public getRetiredJobs_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftJobState state)
    {
      this();
      this.ctx = ctx;
      this.state = state;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRetiredJobs_args(getRetiredJobs_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetState()) {
        this.state = other.state;
      }
    }

    public getRetiredJobs_args deepCopy() {
      return new getRetiredJobs_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.state = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getRetiredJobs_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * 
     * @see ThriftJobState
     */
    public ThriftJobState getState() {
      return this.state;
    }

    /**
     * 
     * @see ThriftJobState
     */
    public getRetiredJobs_args setState(ThriftJobState state) {
      this.state = state;
      return this;
    }

    public void unsetState() {
      this.state = null;
    }

    /** Returns true if field state is set (has been assigned a value) and false otherwise */
    public boolean isSetState() {
      return this.state != null;
    }

    public void setStateIsSet(boolean value) {
      if (!value) {
        this.state = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case STATE:
        if (value == null) {
          unsetState();
        } else {
          setState((ThriftJobState)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case STATE:
        return getState();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case STATE:
        return isSetState();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRetiredJobs_args)
        return this.equals((getRetiredJobs_args)that);
      return false;
    }

    public boolean equals(getRetiredJobs_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_state = true && this.isSetState();
      boolean that_present_state = true && that.isSetState();
      if (this_present_state || that_present_state) {
        if (!(this_present_state && that_present_state))
          return false;
        if (!this.state.equals(that.state))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getRetiredJobs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRetiredJobs_args typedOther = (getRetiredJobs_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetState()).compareTo(typedOther.isSetState());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetState()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.state, typedOther.state);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRetiredJobs_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("state:");
      if (this.state == null) {
        sb.append("null");
      } else {
        sb.append(this.state);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRetiredJobs_argsStandardSchemeFactory implements SchemeFactory {
      public getRetiredJobs_argsStandardScheme getScheme() {
        return new getRetiredJobs_argsStandardScheme();
      }
    }

    private static class getRetiredJobs_argsStandardScheme extends StandardScheme<getRetiredJobs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRetiredJobs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // STATE
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.state = ThriftJobState.findByValue(iprot.readI32());
                struct.setStateIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRetiredJobs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.state != null) {
          oprot.writeFieldBegin(STATE_FIELD_DESC);
          oprot.writeI32(struct.state.getValue());
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRetiredJobs_argsTupleSchemeFactory implements SchemeFactory {
      public getRetiredJobs_argsTupleScheme getScheme() {
        return new getRetiredJobs_argsTupleScheme();
      }
    }

    private static class getRetiredJobs_argsTupleScheme extends TupleScheme<getRetiredJobs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRetiredJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetState()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetState()) {
          oprot.writeI32(struct.state.getValue());
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRetiredJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.state = ThriftJobState.findByValue(iprot.readI32());
          struct.setStateIsSet(true);
        }
      }
    }

  }

  public static class getRetiredJobs_result implements org.apache.thrift.TBase<getRetiredJobs_result, getRetiredJobs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRetiredJobs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRetiredJobs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRetiredJobs_resultTupleSchemeFactory());
    }

    public ThriftJobList success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobList.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRetiredJobs_result.class, metaDataMap);
    }

    public getRetiredJobs_result() {
    }

    public getRetiredJobs_result(
      ThriftJobList success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRetiredJobs_result(getRetiredJobs_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobList(other.success);
      }
    }

    public getRetiredJobs_result deepCopy() {
      return new getRetiredJobs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftJobList getSuccess() {
      return this.success;
    }

    public getRetiredJobs_result setSuccess(ThriftJobList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobList)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRetiredJobs_result)
        return this.equals((getRetiredJobs_result)that);
      return false;
    }

    public boolean equals(getRetiredJobs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getRetiredJobs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRetiredJobs_result typedOther = (getRetiredJobs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRetiredJobs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRetiredJobs_resultStandardSchemeFactory implements SchemeFactory {
      public getRetiredJobs_resultStandardScheme getScheme() {
        return new getRetiredJobs_resultStandardScheme();
      }
    }

    private static class getRetiredJobs_resultStandardScheme extends StandardScheme<getRetiredJobs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRetiredJobs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRetiredJobs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRetiredJobs_resultTupleSchemeFactory implements SchemeFactory {
      public getRetiredJobs_resultTupleScheme getScheme() {
        return new getRetiredJobs_resultTupleScheme();
      }
    }

    private static class getRetiredJobs_resultTupleScheme extends TupleScheme<getRetiredJobs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRetiredJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRetiredJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftJobList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getFailedJobs_args implements org.apache.thrift.TBase<getFailedJobs_args, getFailedJobs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getFailedJobs_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getFailedJobs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getFailedJobs_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getFailedJobs_args.class, metaDataMap);
    }

    public getFailedJobs_args() {
    }

    public getFailedJobs_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getFailedJobs_args(getFailedJobs_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getFailedJobs_args deepCopy() {
      return new getFailedJobs_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getFailedJobs_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getFailedJobs_args)
        return this.equals((getFailedJobs_args)that);
      return false;
    }

    public boolean equals(getFailedJobs_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getFailedJobs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getFailedJobs_args typedOther = (getFailedJobs_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getFailedJobs_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getFailedJobs_argsStandardSchemeFactory implements SchemeFactory {
      public getFailedJobs_argsStandardScheme getScheme() {
        return new getFailedJobs_argsStandardScheme();
      }
    }

    private static class getFailedJobs_argsStandardScheme extends StandardScheme<getFailedJobs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getFailedJobs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getFailedJobs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getFailedJobs_argsTupleSchemeFactory implements SchemeFactory {
      public getFailedJobs_argsTupleScheme getScheme() {
        return new getFailedJobs_argsTupleScheme();
      }
    }

    private static class getFailedJobs_argsTupleScheme extends TupleScheme<getFailedJobs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getFailedJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getFailedJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getFailedJobs_result implements org.apache.thrift.TBase<getFailedJobs_result, getFailedJobs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getFailedJobs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getFailedJobs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getFailedJobs_resultTupleSchemeFactory());
    }

    public ThriftJobList success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobList.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getFailedJobs_result.class, metaDataMap);
    }

    public getFailedJobs_result() {
    }

    public getFailedJobs_result(
      ThriftJobList success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getFailedJobs_result(getFailedJobs_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobList(other.success);
      }
    }

    public getFailedJobs_result deepCopy() {
      return new getFailedJobs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftJobList getSuccess() {
      return this.success;
    }

    public getFailedJobs_result setSuccess(ThriftJobList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobList)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getFailedJobs_result)
        return this.equals((getFailedJobs_result)that);
      return false;
    }

    public boolean equals(getFailedJobs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getFailedJobs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getFailedJobs_result typedOther = (getFailedJobs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getFailedJobs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getFailedJobs_resultStandardSchemeFactory implements SchemeFactory {
      public getFailedJobs_resultStandardScheme getScheme() {
        return new getFailedJobs_resultStandardScheme();
      }
    }

    private static class getFailedJobs_resultStandardScheme extends StandardScheme<getFailedJobs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getFailedJobs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getFailedJobs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getFailedJobs_resultTupleSchemeFactory implements SchemeFactory {
      public getFailedJobs_resultTupleScheme getScheme() {
        return new getFailedJobs_resultTupleScheme();
      }
    }

    private static class getFailedJobs_resultTupleScheme extends TupleScheme<getFailedJobs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getFailedJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getFailedJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftJobList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getKilledJobs_args implements org.apache.thrift.TBase<getKilledJobs_args, getKilledJobs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getKilledJobs_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getKilledJobs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getKilledJobs_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getKilledJobs_args.class, metaDataMap);
    }

    public getKilledJobs_args() {
    }

    public getKilledJobs_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getKilledJobs_args(getKilledJobs_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getKilledJobs_args deepCopy() {
      return new getKilledJobs_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getKilledJobs_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getKilledJobs_args)
        return this.equals((getKilledJobs_args)that);
      return false;
    }

    public boolean equals(getKilledJobs_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getKilledJobs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getKilledJobs_args typedOther = (getKilledJobs_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getKilledJobs_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getKilledJobs_argsStandardSchemeFactory implements SchemeFactory {
      public getKilledJobs_argsStandardScheme getScheme() {
        return new getKilledJobs_argsStandardScheme();
      }
    }

    private static class getKilledJobs_argsStandardScheme extends StandardScheme<getKilledJobs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getKilledJobs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getKilledJobs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getKilledJobs_argsTupleSchemeFactory implements SchemeFactory {
      public getKilledJobs_argsTupleScheme getScheme() {
        return new getKilledJobs_argsTupleScheme();
      }
    }

    private static class getKilledJobs_argsTupleScheme extends TupleScheme<getKilledJobs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getKilledJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getKilledJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getKilledJobs_result implements org.apache.thrift.TBase<getKilledJobs_result, getKilledJobs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getKilledJobs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getKilledJobs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getKilledJobs_resultTupleSchemeFactory());
    }

    public ThriftJobList success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobList.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getKilledJobs_result.class, metaDataMap);
    }

    public getKilledJobs_result() {
    }

    public getKilledJobs_result(
      ThriftJobList success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getKilledJobs_result(getKilledJobs_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobList(other.success);
      }
    }

    public getKilledJobs_result deepCopy() {
      return new getKilledJobs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftJobList getSuccess() {
      return this.success;
    }

    public getKilledJobs_result setSuccess(ThriftJobList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobList)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getKilledJobs_result)
        return this.equals((getKilledJobs_result)that);
      return false;
    }

    public boolean equals(getKilledJobs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getKilledJobs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getKilledJobs_result typedOther = (getKilledJobs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getKilledJobs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getKilledJobs_resultStandardSchemeFactory implements SchemeFactory {
      public getKilledJobs_resultStandardScheme getScheme() {
        return new getKilledJobs_resultStandardScheme();
      }
    }

    private static class getKilledJobs_resultStandardScheme extends StandardScheme<getKilledJobs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getKilledJobs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getKilledJobs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getKilledJobs_resultTupleSchemeFactory implements SchemeFactory {
      public getKilledJobs_resultTupleScheme getScheme() {
        return new getKilledJobs_resultTupleScheme();
      }
    }

    private static class getKilledJobs_resultTupleScheme extends TupleScheme<getKilledJobs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getKilledJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getKilledJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftJobList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getAllJobs_args implements org.apache.thrift.TBase<getAllJobs_args, getAllJobs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getAllJobs_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getAllJobs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getAllJobs_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getAllJobs_args.class, metaDataMap);
    }

    public getAllJobs_args() {
    }

    public getAllJobs_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getAllJobs_args(getAllJobs_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getAllJobs_args deepCopy() {
      return new getAllJobs_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getAllJobs_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getAllJobs_args)
        return this.equals((getAllJobs_args)that);
      return false;
    }

    public boolean equals(getAllJobs_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getAllJobs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getAllJobs_args typedOther = (getAllJobs_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getAllJobs_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getAllJobs_argsStandardSchemeFactory implements SchemeFactory {
      public getAllJobs_argsStandardScheme getScheme() {
        return new getAllJobs_argsStandardScheme();
      }
    }

    private static class getAllJobs_argsStandardScheme extends StandardScheme<getAllJobs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getAllJobs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getAllJobs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getAllJobs_argsTupleSchemeFactory implements SchemeFactory {
      public getAllJobs_argsTupleScheme getScheme() {
        return new getAllJobs_argsTupleScheme();
      }
    }

    private static class getAllJobs_argsTupleScheme extends TupleScheme<getAllJobs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getAllJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getAllJobs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getAllJobs_result implements org.apache.thrift.TBase<getAllJobs_result, getAllJobs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getAllJobs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getAllJobs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getAllJobs_resultTupleSchemeFactory());
    }

    public ThriftJobList success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobList.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getAllJobs_result.class, metaDataMap);
    }

    public getAllJobs_result() {
    }

    public getAllJobs_result(
      ThriftJobList success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getAllJobs_result(getAllJobs_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobList(other.success);
      }
    }

    public getAllJobs_result deepCopy() {
      return new getAllJobs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftJobList getSuccess() {
      return this.success;
    }

    public getAllJobs_result setSuccess(ThriftJobList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobList)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getAllJobs_result)
        return this.equals((getAllJobs_result)that);
      return false;
    }

    public boolean equals(getAllJobs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getAllJobs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getAllJobs_result typedOther = (getAllJobs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getAllJobs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getAllJobs_resultStandardSchemeFactory implements SchemeFactory {
      public getAllJobs_resultStandardScheme getScheme() {
        return new getAllJobs_resultStandardScheme();
      }
    }

    private static class getAllJobs_resultStandardScheme extends StandardScheme<getAllJobs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getAllJobs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getAllJobs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getAllJobs_resultTupleSchemeFactory implements SchemeFactory {
      public getAllJobs_resultTupleScheme getScheme() {
        return new getAllJobs_resultTupleScheme();
      }
    }

    private static class getAllJobs_resultTupleScheme extends TupleScheme<getAllJobs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getAllJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getAllJobs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftJobList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getUserJobCounts_args implements org.apache.thrift.TBase<getUserJobCounts_args, getUserJobCounts_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUserJobCounts_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField USER_FIELD_DESC = new org.apache.thrift.protocol.TField("user", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUserJobCounts_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUserJobCounts_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public String user; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)1, "ctx"),
      USER((short)2, "user");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CTX
            return CTX;
          case 2: // USER
            return USER;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.USER, new org.apache.thrift.meta_data.FieldMetaData("user", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUserJobCounts_args.class, metaDataMap);
    }

    public getUserJobCounts_args() {
    }

    public getUserJobCounts_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String user)
    {
      this();
      this.ctx = ctx;
      this.user = user;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUserJobCounts_args(getUserJobCounts_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetUser()) {
        this.user = other.user;
      }
    }

    public getUserJobCounts_args deepCopy() {
      return new getUserJobCounts_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.user = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getUserJobCounts_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public String getUser() {
      return this.user;
    }

    public getUserJobCounts_args setUser(String user) {
      this.user = user;
      return this;
    }

    public void unsetUser() {
      this.user = null;
    }

    /** Returns true if field user is set (has been assigned a value) and false otherwise */
    public boolean isSetUser() {
      return this.user != null;
    }

    public void setUserIsSet(boolean value) {
      if (!value) {
        this.user = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case USER:
        if (value == null) {
          unsetUser();
        } else {
          setUser((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case USER:
        return getUser();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case USER:
        return isSetUser();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUserJobCounts_args)
        return this.equals((getUserJobCounts_args)that);
      return false;
    }

    public boolean equals(getUserJobCounts_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_user = true && this.isSetUser();
      boolean that_present_user = true && that.isSetUser();
      if (this_present_user || that_present_user) {
        if (!(this_present_user && that_present_user))
          return false;
        if (!this.user.equals(that.user))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getUserJobCounts_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getUserJobCounts_args typedOther = (getUserJobCounts_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUser()).compareTo(typedOther.isSetUser());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUser()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.user, typedOther.user);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUserJobCounts_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("user:");
      if (this.user == null) {
        sb.append("null");
      } else {
        sb.append(this.user);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUserJobCounts_argsStandardSchemeFactory implements SchemeFactory {
      public getUserJobCounts_argsStandardScheme getScheme() {
        return new getUserJobCounts_argsStandardScheme();
      }
    }

    private static class getUserJobCounts_argsStandardScheme extends StandardScheme<getUserJobCounts_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUserJobCounts_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // USER
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.user = iprot.readString();
                struct.setUserIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUserJobCounts_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.user != null) {
          oprot.writeFieldBegin(USER_FIELD_DESC);
          oprot.writeString(struct.user);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUserJobCounts_argsTupleSchemeFactory implements SchemeFactory {
      public getUserJobCounts_argsTupleScheme getScheme() {
        return new getUserJobCounts_argsTupleScheme();
      }
    }

    private static class getUserJobCounts_argsTupleScheme extends TupleScheme<getUserJobCounts_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUserJobCounts_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetUser()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetUser()) {
          oprot.writeString(struct.user);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUserJobCounts_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.user = iprot.readString();
          struct.setUserIsSet(true);
        }
      }
    }

  }

  public static class getUserJobCounts_result implements org.apache.thrift.TBase<getUserJobCounts_result, getUserJobCounts_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUserJobCounts_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUserJobCounts_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUserJobCounts_resultTupleSchemeFactory());
    }

    public ThriftUserJobCounts success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftUserJobCounts.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUserJobCounts_result.class, metaDataMap);
    }

    public getUserJobCounts_result() {
    }

    public getUserJobCounts_result(
      ThriftUserJobCounts success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUserJobCounts_result(getUserJobCounts_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftUserJobCounts(other.success);
      }
    }

    public getUserJobCounts_result deepCopy() {
      return new getUserJobCounts_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftUserJobCounts getSuccess() {
      return this.success;
    }

    public getUserJobCounts_result setSuccess(ThriftUserJobCounts success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftUserJobCounts)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUserJobCounts_result)
        return this.equals((getUserJobCounts_result)that);
      return false;
    }

    public boolean equals(getUserJobCounts_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getUserJobCounts_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getUserJobCounts_result typedOther = (getUserJobCounts_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUserJobCounts_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUserJobCounts_resultStandardSchemeFactory implements SchemeFactory {
      public getUserJobCounts_resultStandardScheme getScheme() {
        return new getUserJobCounts_resultStandardScheme();
      }
    }

    private static class getUserJobCounts_resultStandardScheme extends StandardScheme<getUserJobCounts_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUserJobCounts_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftUserJobCounts();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUserJobCounts_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUserJobCounts_resultTupleSchemeFactory implements SchemeFactory {
      public getUserJobCounts_resultTupleScheme getScheme() {
        return new getUserJobCounts_resultTupleScheme();
      }
    }

    private static class getUserJobCounts_resultTupleScheme extends TupleScheme<getUserJobCounts_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUserJobCounts_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUserJobCounts_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftUserJobCounts();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getTaskList_args implements org.apache.thrift.TBase<getTaskList_args, getTaskList_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTaskList_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField JOB_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("jobID", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TYPES_FIELD_DESC = new org.apache.thrift.protocol.TField("types", org.apache.thrift.protocol.TType.SET, (short)3);
    private static final org.apache.thrift.protocol.TField STATES_FIELD_DESC = new org.apache.thrift.protocol.TField("states", org.apache.thrift.protocol.TType.SET, (short)4);
    private static final org.apache.thrift.protocol.TField TEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("text", org.apache.thrift.protocol.TType.STRING, (short)5);
    private static final org.apache.thrift.protocol.TField COUNT_FIELD_DESC = new org.apache.thrift.protocol.TField("count", org.apache.thrift.protocol.TType.I32, (short)6);
    private static final org.apache.thrift.protocol.TField OFFSET_FIELD_DESC = new org.apache.thrift.protocol.TField("offset", org.apache.thrift.protocol.TType.I32, (short)7);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTaskList_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTaskList_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftJobID jobID; // required
    public Set<ThriftTaskType> types; // required
    public Set<ThriftTaskQueryState> states; // required
    public String text; // required
    public int count; // required
    public int offset; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)1, "ctx"),
      JOB_ID((short)2, "jobID"),
      TYPES((short)3, "types"),
      STATES((short)4, "states"),
      TEXT((short)5, "text"),
      COUNT((short)6, "count"),
      OFFSET((short)7, "offset");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CTX
            return CTX;
          case 2: // JOB_ID
            return JOB_ID;
          case 3: // TYPES
            return TYPES;
          case 4: // STATES
            return STATES;
          case 5: // TEXT
            return TEXT;
          case 6: // COUNT
            return COUNT;
          case 7: // OFFSET
            return OFFSET;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __COUNT_ISSET_ID = 0;
    private static final int __OFFSET_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.JOB_ID, new org.apache.thrift.meta_data.FieldMetaData("jobID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobID.class)));
      tmpMap.put(_Fields.TYPES, new org.apache.thrift.meta_data.FieldMetaData("types", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ThriftTaskType.class))));
      tmpMap.put(_Fields.STATES, new org.apache.thrift.meta_data.FieldMetaData("states", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ThriftTaskQueryState.class))));
      tmpMap.put(_Fields.TEXT, new org.apache.thrift.meta_data.FieldMetaData("text", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.COUNT, new org.apache.thrift.meta_data.FieldMetaData("count", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.OFFSET, new org.apache.thrift.meta_data.FieldMetaData("offset", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTaskList_args.class, metaDataMap);
    }

    public getTaskList_args() {
    }

    public getTaskList_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftJobID jobID,
      Set<ThriftTaskType> types,
      Set<ThriftTaskQueryState> states,
      String text,
      int count,
      int offset)
    {
      this();
      this.ctx = ctx;
      this.jobID = jobID;
      this.types = types;
      this.states = states;
      this.text = text;
      this.count = count;
      setCountIsSet(true);
      this.offset = offset;
      setOffsetIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTaskList_args(getTaskList_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetJobID()) {
        this.jobID = new ThriftJobID(other.jobID);
      }
      if (other.isSetTypes()) {
        Set<ThriftTaskType> __this__types = new HashSet<ThriftTaskType>();
        for (ThriftTaskType other_element : other.types) {
          __this__types.add(other_element);
        }
        this.types = __this__types;
      }
      if (other.isSetStates()) {
        Set<ThriftTaskQueryState> __this__states = new HashSet<ThriftTaskQueryState>();
        for (ThriftTaskQueryState other_element : other.states) {
          __this__states.add(other_element);
        }
        this.states = __this__states;
      }
      if (other.isSetText()) {
        this.text = other.text;
      }
      this.count = other.count;
      this.offset = other.offset;
    }

    public getTaskList_args deepCopy() {
      return new getTaskList_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.jobID = null;
      this.types = null;
      this.states = null;
      this.text = null;
      setCountIsSet(false);
      this.count = 0;
      setOffsetIsSet(false);
      this.offset = 0;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getTaskList_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftJobID getJobID() {
      return this.jobID;
    }

    public getTaskList_args setJobID(ThriftJobID jobID) {
      this.jobID = jobID;
      return this;
    }

    public void unsetJobID() {
      this.jobID = null;
    }

    /** Returns true if field jobID is set (has been assigned a value) and false otherwise */
    public boolean isSetJobID() {
      return this.jobID != null;
    }

    public void setJobIDIsSet(boolean value) {
      if (!value) {
        this.jobID = null;
      }
    }

    public int getTypesSize() {
      return (this.types == null) ? 0 : this.types.size();
    }

    public java.util.Iterator<ThriftTaskType> getTypesIterator() {
      return (this.types == null) ? null : this.types.iterator();
    }

    public void addToTypes(ThriftTaskType elem) {
      if (this.types == null) {
        this.types = new HashSet<ThriftTaskType>();
      }
      this.types.add(elem);
    }

    public Set<ThriftTaskType> getTypes() {
      return this.types;
    }

    public getTaskList_args setTypes(Set<ThriftTaskType> types) {
      this.types = types;
      return this;
    }

    public void unsetTypes() {
      this.types = null;
    }

    /** Returns true if field types is set (has been assigned a value) and false otherwise */
    public boolean isSetTypes() {
      return this.types != null;
    }

    public void setTypesIsSet(boolean value) {
      if (!value) {
        this.types = null;
      }
    }

    public int getStatesSize() {
      return (this.states == null) ? 0 : this.states.size();
    }

    public java.util.Iterator<ThriftTaskQueryState> getStatesIterator() {
      return (this.states == null) ? null : this.states.iterator();
    }

    public void addToStates(ThriftTaskQueryState elem) {
      if (this.states == null) {
        this.states = new HashSet<ThriftTaskQueryState>();
      }
      this.states.add(elem);
    }

    public Set<ThriftTaskQueryState> getStates() {
      return this.states;
    }

    public getTaskList_args setStates(Set<ThriftTaskQueryState> states) {
      this.states = states;
      return this;
    }

    public void unsetStates() {
      this.states = null;
    }

    /** Returns true if field states is set (has been assigned a value) and false otherwise */
    public boolean isSetStates() {
      return this.states != null;
    }

    public void setStatesIsSet(boolean value) {
      if (!value) {
        this.states = null;
      }
    }

    public String getText() {
      return this.text;
    }

    public getTaskList_args setText(String text) {
      this.text = text;
      return this;
    }

    public void unsetText() {
      this.text = null;
    }

    /** Returns true if field text is set (has been assigned a value) and false otherwise */
    public boolean isSetText() {
      return this.text != null;
    }

    public void setTextIsSet(boolean value) {
      if (!value) {
        this.text = null;
      }
    }

    public int getCount() {
      return this.count;
    }

    public getTaskList_args setCount(int count) {
      this.count = count;
      setCountIsSet(true);
      return this;
    }

    public void unsetCount() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __COUNT_ISSET_ID);
    }

    /** Returns true if field count is set (has been assigned a value) and false otherwise */
    public boolean isSetCount() {
      return EncodingUtils.testBit(__isset_bitfield, __COUNT_ISSET_ID);
    }

    public void setCountIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __COUNT_ISSET_ID, value);
    }

    public int getOffset() {
      return this.offset;
    }

    public getTaskList_args setOffset(int offset) {
      this.offset = offset;
      setOffsetIsSet(true);
      return this;
    }

    public void unsetOffset() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    /** Returns true if field offset is set (has been assigned a value) and false otherwise */
    public boolean isSetOffset() {
      return EncodingUtils.testBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    public void setOffsetIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __OFFSET_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case JOB_ID:
        if (value == null) {
          unsetJobID();
        } else {
          setJobID((ThriftJobID)value);
        }
        break;

      case TYPES:
        if (value == null) {
          unsetTypes();
        } else {
          setTypes((Set<ThriftTaskType>)value);
        }
        break;

      case STATES:
        if (value == null) {
          unsetStates();
        } else {
          setStates((Set<ThriftTaskQueryState>)value);
        }
        break;

      case TEXT:
        if (value == null) {
          unsetText();
        } else {
          setText((String)value);
        }
        break;

      case COUNT:
        if (value == null) {
          unsetCount();
        } else {
          setCount((Integer)value);
        }
        break;

      case OFFSET:
        if (value == null) {
          unsetOffset();
        } else {
          setOffset((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case JOB_ID:
        return getJobID();

      case TYPES:
        return getTypes();

      case STATES:
        return getStates();

      case TEXT:
        return getText();

      case COUNT:
        return Integer.valueOf(getCount());

      case OFFSET:
        return Integer.valueOf(getOffset());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case JOB_ID:
        return isSetJobID();
      case TYPES:
        return isSetTypes();
      case STATES:
        return isSetStates();
      case TEXT:
        return isSetText();
      case COUNT:
        return isSetCount();
      case OFFSET:
        return isSetOffset();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTaskList_args)
        return this.equals((getTaskList_args)that);
      return false;
    }

    public boolean equals(getTaskList_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_jobID = true && this.isSetJobID();
      boolean that_present_jobID = true && that.isSetJobID();
      if (this_present_jobID || that_present_jobID) {
        if (!(this_present_jobID && that_present_jobID))
          return false;
        if (!this.jobID.equals(that.jobID))
          return false;
      }

      boolean this_present_types = true && this.isSetTypes();
      boolean that_present_types = true && that.isSetTypes();
      if (this_present_types || that_present_types) {
        if (!(this_present_types && that_present_types))
          return false;
        if (!this.types.equals(that.types))
          return false;
      }

      boolean this_present_states = true && this.isSetStates();
      boolean that_present_states = true && that.isSetStates();
      if (this_present_states || that_present_states) {
        if (!(this_present_states && that_present_states))
          return false;
        if (!this.states.equals(that.states))
          return false;
      }

      boolean this_present_text = true && this.isSetText();
      boolean that_present_text = true && that.isSetText();
      if (this_present_text || that_present_text) {
        if (!(this_present_text && that_present_text))
          return false;
        if (!this.text.equals(that.text))
          return false;
      }

      boolean this_present_count = true;
      boolean that_present_count = true;
      if (this_present_count || that_present_count) {
        if (!(this_present_count && that_present_count))
          return false;
        if (this.count != that.count)
          return false;
      }

      boolean this_present_offset = true;
      boolean that_present_offset = true;
      if (this_present_offset || that_present_offset) {
        if (!(this_present_offset && that_present_offset))
          return false;
        if (this.offset != that.offset)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getTaskList_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTaskList_args typedOther = (getTaskList_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJobID()).compareTo(typedOther.isSetJobID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJobID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jobID, typedOther.jobID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTypes()).compareTo(typedOther.isSetTypes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTypes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.types, typedOther.types);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetStates()).compareTo(typedOther.isSetStates());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStates()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.states, typedOther.states);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetText()).compareTo(typedOther.isSetText());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetText()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.text, typedOther.text);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCount()).compareTo(typedOther.isSetCount());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCount()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.count, typedOther.count);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOffset()).compareTo(typedOther.isSetOffset());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOffset()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.offset, typedOther.offset);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTaskList_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jobID:");
      if (this.jobID == null) {
        sb.append("null");
      } else {
        sb.append(this.jobID);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("types:");
      if (this.types == null) {
        sb.append("null");
      } else {
        sb.append(this.types);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("states:");
      if (this.states == null) {
        sb.append("null");
      } else {
        sb.append(this.states);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("text:");
      if (this.text == null) {
        sb.append("null");
      } else {
        sb.append(this.text);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("count:");
      sb.append(this.count);
      first = false;
      if (!first) sb.append(", ");
      sb.append("offset:");
      sb.append(this.offset);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (jobID != null) {
        jobID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTaskList_argsStandardSchemeFactory implements SchemeFactory {
      public getTaskList_argsStandardScheme getScheme() {
        return new getTaskList_argsStandardScheme();
      }
    }

    private static class getTaskList_argsStandardScheme extends StandardScheme<getTaskList_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTaskList_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // JOB_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jobID = new ThriftJobID();
                struct.jobID.read(iprot);
                struct.setJobIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TYPES
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set118 = iprot.readSetBegin();
                  struct.types = new HashSet<ThriftTaskType>(2*_set118.size);
                  for (int _i119 = 0; _i119 < _set118.size; ++_i119)
                  {
                    ThriftTaskType _elem120; // required
                    _elem120 = ThriftTaskType.findByValue(iprot.readI32());
                    struct.types.add(_elem120);
                  }
                  iprot.readSetEnd();
                }
                struct.setTypesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // STATES
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set121 = iprot.readSetBegin();
                  struct.states = new HashSet<ThriftTaskQueryState>(2*_set121.size);
                  for (int _i122 = 0; _i122 < _set121.size; ++_i122)
                  {
                    ThriftTaskQueryState _elem123; // required
                    _elem123 = ThriftTaskQueryState.findByValue(iprot.readI32());
                    struct.states.add(_elem123);
                  }
                  iprot.readSetEnd();
                }
                struct.setStatesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // TEXT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.text = iprot.readString();
                struct.setTextIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // COUNT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.count = iprot.readI32();
                struct.setCountIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 7: // OFFSET
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.offset = iprot.readI32();
                struct.setOffsetIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTaskList_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.jobID != null) {
          oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
          struct.jobID.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.types != null) {
          oprot.writeFieldBegin(TYPES_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, struct.types.size()));
            for (ThriftTaskType _iter124 : struct.types)
            {
              oprot.writeI32(_iter124.getValue());
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.states != null) {
          oprot.writeFieldBegin(STATES_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, struct.states.size()));
            for (ThriftTaskQueryState _iter125 : struct.states)
            {
              oprot.writeI32(_iter125.getValue());
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.text != null) {
          oprot.writeFieldBegin(TEXT_FIELD_DESC);
          oprot.writeString(struct.text);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(COUNT_FIELD_DESC);
        oprot.writeI32(struct.count);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(OFFSET_FIELD_DESC);
        oprot.writeI32(struct.offset);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTaskList_argsTupleSchemeFactory implements SchemeFactory {
      public getTaskList_argsTupleScheme getScheme() {
        return new getTaskList_argsTupleScheme();
      }
    }

    private static class getTaskList_argsTupleScheme extends TupleScheme<getTaskList_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTaskList_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetJobID()) {
          optionals.set(1);
        }
        if (struct.isSetTypes()) {
          optionals.set(2);
        }
        if (struct.isSetStates()) {
          optionals.set(3);
        }
        if (struct.isSetText()) {
          optionals.set(4);
        }
        if (struct.isSetCount()) {
          optionals.set(5);
        }
        if (struct.isSetOffset()) {
          optionals.set(6);
        }
        oprot.writeBitSet(optionals, 7);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetJobID()) {
          struct.jobID.write(oprot);
        }
        if (struct.isSetTypes()) {
          {
            oprot.writeI32(struct.types.size());
            for (ThriftTaskType _iter126 : struct.types)
            {
              oprot.writeI32(_iter126.getValue());
            }
          }
        }
        if (struct.isSetStates()) {
          {
            oprot.writeI32(struct.states.size());
            for (ThriftTaskQueryState _iter127 : struct.states)
            {
              oprot.writeI32(_iter127.getValue());
            }
          }
        }
        if (struct.isSetText()) {
          oprot.writeString(struct.text);
        }
        if (struct.isSetCount()) {
          oprot.writeI32(struct.count);
        }
        if (struct.isSetOffset()) {
          oprot.writeI32(struct.offset);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTaskList_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(7);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jobID = new ThriftJobID();
          struct.jobID.read(iprot);
          struct.setJobIDIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TSet _set128 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, iprot.readI32());
            struct.types = new HashSet<ThriftTaskType>(2*_set128.size);
            for (int _i129 = 0; _i129 < _set128.size; ++_i129)
            {
              ThriftTaskType _elem130; // required
              _elem130 = ThriftTaskType.findByValue(iprot.readI32());
              struct.types.add(_elem130);
            }
          }
          struct.setTypesIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TSet _set131 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, iprot.readI32());
            struct.states = new HashSet<ThriftTaskQueryState>(2*_set131.size);
            for (int _i132 = 0; _i132 < _set131.size; ++_i132)
            {
              ThriftTaskQueryState _elem133; // required
              _elem133 = ThriftTaskQueryState.findByValue(iprot.readI32());
              struct.states.add(_elem133);
            }
          }
          struct.setStatesIsSet(true);
        }
        if (incoming.get(4)) {
          struct.text = iprot.readString();
          struct.setTextIsSet(true);
        }
        if (incoming.get(5)) {
          struct.count = iprot.readI32();
          struct.setCountIsSet(true);
        }
        if (incoming.get(6)) {
          struct.offset = iprot.readI32();
          struct.setOffsetIsSet(true);
        }
      }
    }

  }

  public static class getTaskList_result implements org.apache.thrift.TBase<getTaskList_result, getTaskList_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTaskList_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTaskList_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTaskList_resultTupleSchemeFactory());
    }

    public ThriftTaskInProgressList success; // required
    public JobNotFoundException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftTaskInProgressList.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTaskList_result.class, metaDataMap);
    }

    public getTaskList_result() {
    }

    public getTaskList_result(
      ThriftTaskInProgressList success,
      JobNotFoundException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTaskList_result(getTaskList_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftTaskInProgressList(other.success);
      }
      if (other.isSetErr()) {
        this.err = new JobNotFoundException(other.err);
      }
    }

    public getTaskList_result deepCopy() {
      return new getTaskList_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public ThriftTaskInProgressList getSuccess() {
      return this.success;
    }

    public getTaskList_result setSuccess(ThriftTaskInProgressList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public JobNotFoundException getErr() {
      return this.err;
    }

    public getTaskList_result setErr(JobNotFoundException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftTaskInProgressList)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((JobNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTaskList_result)
        return this.equals((getTaskList_result)that);
      return false;
    }

    public boolean equals(getTaskList_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getTaskList_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTaskList_result typedOther = (getTaskList_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTaskList_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTaskList_resultStandardSchemeFactory implements SchemeFactory {
      public getTaskList_resultStandardScheme getScheme() {
        return new getTaskList_resultStandardScheme();
      }
    }

    private static class getTaskList_resultStandardScheme extends StandardScheme<getTaskList_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTaskList_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftTaskInProgressList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new JobNotFoundException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTaskList_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTaskList_resultTupleSchemeFactory implements SchemeFactory {
      public getTaskList_resultTupleScheme getScheme() {
        return new getTaskList_resultTupleScheme();
      }
    }

    private static class getTaskList_resultTupleScheme extends TupleScheme<getTaskList_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTaskList_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTaskList_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ThriftTaskInProgressList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new JobNotFoundException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class getTask_args implements org.apache.thrift.TBase<getTask_args, getTask_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTask_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TASK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("taskID", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTask_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTask_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftTaskID taskID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)1, "ctx"),
      TASK_ID((short)2, "taskID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CTX
            return CTX;
          case 2: // TASK_ID
            return TASK_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.TASK_ID, new org.apache.thrift.meta_data.FieldMetaData("taskID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftTaskID.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTask_args.class, metaDataMap);
    }

    public getTask_args() {
    }

    public getTask_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftTaskID taskID)
    {
      this();
      this.ctx = ctx;
      this.taskID = taskID;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTask_args(getTask_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetTaskID()) {
        this.taskID = new ThriftTaskID(other.taskID);
      }
    }

    public getTask_args deepCopy() {
      return new getTask_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.taskID = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getTask_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftTaskID getTaskID() {
      return this.taskID;
    }

    public getTask_args setTaskID(ThriftTaskID taskID) {
      this.taskID = taskID;
      return this;
    }

    public void unsetTaskID() {
      this.taskID = null;
    }

    /** Returns true if field taskID is set (has been assigned a value) and false otherwise */
    public boolean isSetTaskID() {
      return this.taskID != null;
    }

    public void setTaskIDIsSet(boolean value) {
      if (!value) {
        this.taskID = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case TASK_ID:
        if (value == null) {
          unsetTaskID();
        } else {
          setTaskID((ThriftTaskID)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case TASK_ID:
        return getTaskID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case TASK_ID:
        return isSetTaskID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTask_args)
        return this.equals((getTask_args)that);
      return false;
    }

    public boolean equals(getTask_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_taskID = true && this.isSetTaskID();
      boolean that_present_taskID = true && that.isSetTaskID();
      if (this_present_taskID || that_present_taskID) {
        if (!(this_present_taskID && that_present_taskID))
          return false;
        if (!this.taskID.equals(that.taskID))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getTask_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTask_args typedOther = (getTask_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTaskID()).compareTo(typedOther.isSetTaskID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTaskID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.taskID, typedOther.taskID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTask_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("taskID:");
      if (this.taskID == null) {
        sb.append("null");
      } else {
        sb.append(this.taskID);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (taskID != null) {
        taskID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTask_argsStandardSchemeFactory implements SchemeFactory {
      public getTask_argsStandardScheme getScheme() {
        return new getTask_argsStandardScheme();
      }
    }

    private static class getTask_argsStandardScheme extends StandardScheme<getTask_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTask_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TASK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.taskID = new ThriftTaskID();
                struct.taskID.read(iprot);
                struct.setTaskIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTask_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.taskID != null) {
          oprot.writeFieldBegin(TASK_ID_FIELD_DESC);
          struct.taskID.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTask_argsTupleSchemeFactory implements SchemeFactory {
      public getTask_argsTupleScheme getScheme() {
        return new getTask_argsTupleScheme();
      }
    }

    private static class getTask_argsTupleScheme extends TupleScheme<getTask_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTask_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetTaskID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetTaskID()) {
          struct.taskID.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTask_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.taskID = new ThriftTaskID();
          struct.taskID.read(iprot);
          struct.setTaskIDIsSet(true);
        }
      }
    }

  }

  public static class getTask_result implements org.apache.thrift.TBase<getTask_result, getTask_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTask_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField JNF_FIELD_DESC = new org.apache.thrift.protocol.TField("jnf", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TNF_FIELD_DESC = new org.apache.thrift.protocol.TField("tnf", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTask_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTask_resultTupleSchemeFactory());
    }

    public ThriftTaskInProgress success; // required
    public JobNotFoundException jnf; // required
    public TaskNotFoundException tnf; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      JNF((short)1, "jnf"),
      TNF((short)2, "tnf");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // JNF
            return JNF;
          case 2: // TNF
            return TNF;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftTaskInProgress.class)));
      tmpMap.put(_Fields.JNF, new org.apache.thrift.meta_data.FieldMetaData("jnf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TNF, new org.apache.thrift.meta_data.FieldMetaData("tnf", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTask_result.class, metaDataMap);
    }

    public getTask_result() {
    }

    public getTask_result(
      ThriftTaskInProgress success,
      JobNotFoundException jnf,
      TaskNotFoundException tnf)
    {
      this();
      this.success = success;
      this.jnf = jnf;
      this.tnf = tnf;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTask_result(getTask_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftTaskInProgress(other.success);
      }
      if (other.isSetJnf()) {
        this.jnf = new JobNotFoundException(other.jnf);
      }
      if (other.isSetTnf()) {
        this.tnf = new TaskNotFoundException(other.tnf);
      }
    }

    public getTask_result deepCopy() {
      return new getTask_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.jnf = null;
      this.tnf = null;
    }

    public ThriftTaskInProgress getSuccess() {
      return this.success;
    }

    public getTask_result setSuccess(ThriftTaskInProgress success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public JobNotFoundException getJnf() {
      return this.jnf;
    }

    public getTask_result setJnf(JobNotFoundException jnf) {
      this.jnf = jnf;
      return this;
    }

    public void unsetJnf() {
      this.jnf = null;
    }

    /** Returns true if field jnf is set (has been assigned a value) and false otherwise */
    public boolean isSetJnf() {
      return this.jnf != null;
    }

    public void setJnfIsSet(boolean value) {
      if (!value) {
        this.jnf = null;
      }
    }

    public TaskNotFoundException getTnf() {
      return this.tnf;
    }

    public getTask_result setTnf(TaskNotFoundException tnf) {
      this.tnf = tnf;
      return this;
    }

    public void unsetTnf() {
      this.tnf = null;
    }

    /** Returns true if field tnf is set (has been assigned a value) and false otherwise */
    public boolean isSetTnf() {
      return this.tnf != null;
    }

    public void setTnfIsSet(boolean value) {
      if (!value) {
        this.tnf = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftTaskInProgress)value);
        }
        break;

      case JNF:
        if (value == null) {
          unsetJnf();
        } else {
          setJnf((JobNotFoundException)value);
        }
        break;

      case TNF:
        if (value == null) {
          unsetTnf();
        } else {
          setTnf((TaskNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case JNF:
        return getJnf();

      case TNF:
        return getTnf();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case JNF:
        return isSetJnf();
      case TNF:
        return isSetTnf();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTask_result)
        return this.equals((getTask_result)that);
      return false;
    }

    public boolean equals(getTask_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_jnf = true && this.isSetJnf();
      boolean that_present_jnf = true && that.isSetJnf();
      if (this_present_jnf || that_present_jnf) {
        if (!(this_present_jnf && that_present_jnf))
          return false;
        if (!this.jnf.equals(that.jnf))
          return false;
      }

      boolean this_present_tnf = true && this.isSetTnf();
      boolean that_present_tnf = true && that.isSetTnf();
      if (this_present_tnf || that_present_tnf) {
        if (!(this_present_tnf && that_present_tnf))
          return false;
        if (!this.tnf.equals(that.tnf))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getTask_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTask_result typedOther = (getTask_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJnf()).compareTo(typedOther.isSetJnf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJnf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jnf, typedOther.jnf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTnf()).compareTo(typedOther.isSetTnf());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTnf()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tnf, typedOther.tnf);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTask_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jnf:");
      if (this.jnf == null) {
        sb.append("null");
      } else {
        sb.append(this.jnf);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tnf:");
      if (this.tnf == null) {
        sb.append("null");
      } else {
        sb.append(this.tnf);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTask_resultStandardSchemeFactory implements SchemeFactory {
      public getTask_resultStandardScheme getScheme() {
        return new getTask_resultStandardScheme();
      }
    }

    private static class getTask_resultStandardScheme extends StandardScheme<getTask_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTask_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftTaskInProgress();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // JNF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jnf = new JobNotFoundException();
                struct.jnf.read(iprot);
                struct.setJnfIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TNF
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tnf = new TaskNotFoundException();
                struct.tnf.read(iprot);
                struct.setTnfIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTask_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.jnf != null) {
          oprot.writeFieldBegin(JNF_FIELD_DESC);
          struct.jnf.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tnf != null) {
          oprot.writeFieldBegin(TNF_FIELD_DESC);
          struct.tnf.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTask_resultTupleSchemeFactory implements SchemeFactory {
      public getTask_resultTupleScheme getScheme() {
        return new getTask_resultTupleScheme();
      }
    }

    private static class getTask_resultTupleScheme extends TupleScheme<getTask_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTask_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetJnf()) {
          optionals.set(1);
        }
        if (struct.isSetTnf()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetJnf()) {
          struct.jnf.write(oprot);
        }
        if (struct.isSetTnf()) {
          struct.tnf.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTask_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = new ThriftTaskInProgress();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jnf = new JobNotFoundException();
          struct.jnf.read(iprot);
          struct.setJnfIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tnf = new TaskNotFoundException();
          struct.tnf.read(iprot);
          struct.setTnfIsSet(true);
        }
      }
    }

  }

  public static class getJobCounters_args implements org.apache.thrift.TBase<getJobCounters_args, getJobCounters_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJobCounters_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField JOB_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("jobID", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJobCounters_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJobCounters_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftJobID jobID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      JOB_ID((short)1, "jobID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // JOB_ID
            return JOB_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.JOB_ID, new org.apache.thrift.meta_data.FieldMetaData("jobID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobID.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJobCounters_args.class, metaDataMap);
    }

    public getJobCounters_args() {
    }

    public getJobCounters_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftJobID jobID)
    {
      this();
      this.ctx = ctx;
      this.jobID = jobID;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJobCounters_args(getJobCounters_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetJobID()) {
        this.jobID = new ThriftJobID(other.jobID);
      }
    }

    public getJobCounters_args deepCopy() {
      return new getJobCounters_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.jobID = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getJobCounters_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftJobID getJobID() {
      return this.jobID;
    }

    public getJobCounters_args setJobID(ThriftJobID jobID) {
      this.jobID = jobID;
      return this;
    }

    public void unsetJobID() {
      this.jobID = null;
    }

    /** Returns true if field jobID is set (has been assigned a value) and false otherwise */
    public boolean isSetJobID() {
      return this.jobID != null;
    }

    public void setJobIDIsSet(boolean value) {
      if (!value) {
        this.jobID = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case JOB_ID:
        if (value == null) {
          unsetJobID();
        } else {
          setJobID((ThriftJobID)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case JOB_ID:
        return getJobID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case JOB_ID:
        return isSetJobID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJobCounters_args)
        return this.equals((getJobCounters_args)that);
      return false;
    }

    public boolean equals(getJobCounters_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_jobID = true && this.isSetJobID();
      boolean that_present_jobID = true && that.isSetJobID();
      if (this_present_jobID || that_present_jobID) {
        if (!(this_present_jobID && that_present_jobID))
          return false;
        if (!this.jobID.equals(that.jobID))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJobCounters_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJobCounters_args typedOther = (getJobCounters_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJobID()).compareTo(typedOther.isSetJobID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJobID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jobID, typedOther.jobID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJobCounters_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jobID:");
      if (this.jobID == null) {
        sb.append("null");
      } else {
        sb.append(this.jobID);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (jobID != null) {
        jobID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJobCounters_argsStandardSchemeFactory implements SchemeFactory {
      public getJobCounters_argsStandardScheme getScheme() {
        return new getJobCounters_argsStandardScheme();
      }
    }

    private static class getJobCounters_argsStandardScheme extends StandardScheme<getJobCounters_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJobCounters_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // JOB_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jobID = new ThriftJobID();
                struct.jobID.read(iprot);
                struct.setJobIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJobCounters_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.jobID != null) {
          oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
          struct.jobID.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJobCounters_argsTupleSchemeFactory implements SchemeFactory {
      public getJobCounters_argsTupleScheme getScheme() {
        return new getJobCounters_argsTupleScheme();
      }
    }

    private static class getJobCounters_argsTupleScheme extends TupleScheme<getJobCounters_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJobCounters_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetJobID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetJobID()) {
          struct.jobID.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJobCounters_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jobID = new ThriftJobID();
          struct.jobID.read(iprot);
          struct.setJobIDIsSet(true);
        }
      }
    }

  }

  public static class getJobCounters_result implements org.apache.thrift.TBase<getJobCounters_result, getJobCounters_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJobCounters_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJobCounters_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJobCounters_resultTupleSchemeFactory());
    }

    public ThriftGroupList success; // required
    public JobNotFoundException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftGroupList.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJobCounters_result.class, metaDataMap);
    }

    public getJobCounters_result() {
    }

    public getJobCounters_result(
      ThriftGroupList success,
      JobNotFoundException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJobCounters_result(getJobCounters_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftGroupList(other.success);
      }
      if (other.isSetErr()) {
        this.err = new JobNotFoundException(other.err);
      }
    }

    public getJobCounters_result deepCopy() {
      return new getJobCounters_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public ThriftGroupList getSuccess() {
      return this.success;
    }

    public getJobCounters_result setSuccess(ThriftGroupList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public JobNotFoundException getErr() {
      return this.err;
    }

    public getJobCounters_result setErr(JobNotFoundException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftGroupList)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((JobNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJobCounters_result)
        return this.equals((getJobCounters_result)that);
      return false;
    }

    public boolean equals(getJobCounters_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJobCounters_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJobCounters_result typedOther = (getJobCounters_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJobCounters_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJobCounters_resultStandardSchemeFactory implements SchemeFactory {
      public getJobCounters_resultStandardScheme getScheme() {
        return new getJobCounters_resultStandardScheme();
      }
    }

    private static class getJobCounters_resultStandardScheme extends StandardScheme<getJobCounters_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJobCounters_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftGroupList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new JobNotFoundException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJobCounters_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJobCounters_resultTupleSchemeFactory implements SchemeFactory {
      public getJobCounters_resultTupleScheme getScheme() {
        return new getJobCounters_resultTupleScheme();
      }
    }

    private static class getJobCounters_resultTupleScheme extends TupleScheme<getJobCounters_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJobCounters_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJobCounters_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ThriftGroupList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new JobNotFoundException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class getJobCounterRollups_args implements org.apache.thrift.TBase<getJobCounterRollups_args, getJobCounterRollups_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJobCounterRollups_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField JOB_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("jobID", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJobCounterRollups_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJobCounterRollups_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftJobID jobID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      JOB_ID((short)1, "jobID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // JOB_ID
            return JOB_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.JOB_ID, new org.apache.thrift.meta_data.FieldMetaData("jobID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobID.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJobCounterRollups_args.class, metaDataMap);
    }

    public getJobCounterRollups_args() {
    }

    public getJobCounterRollups_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftJobID jobID)
    {
      this();
      this.ctx = ctx;
      this.jobID = jobID;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJobCounterRollups_args(getJobCounterRollups_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetJobID()) {
        this.jobID = new ThriftJobID(other.jobID);
      }
    }

    public getJobCounterRollups_args deepCopy() {
      return new getJobCounterRollups_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.jobID = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getJobCounterRollups_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftJobID getJobID() {
      return this.jobID;
    }

    public getJobCounterRollups_args setJobID(ThriftJobID jobID) {
      this.jobID = jobID;
      return this;
    }

    public void unsetJobID() {
      this.jobID = null;
    }

    /** Returns true if field jobID is set (has been assigned a value) and false otherwise */
    public boolean isSetJobID() {
      return this.jobID != null;
    }

    public void setJobIDIsSet(boolean value) {
      if (!value) {
        this.jobID = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case JOB_ID:
        if (value == null) {
          unsetJobID();
        } else {
          setJobID((ThriftJobID)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case JOB_ID:
        return getJobID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case JOB_ID:
        return isSetJobID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJobCounterRollups_args)
        return this.equals((getJobCounterRollups_args)that);
      return false;
    }

    public boolean equals(getJobCounterRollups_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_jobID = true && this.isSetJobID();
      boolean that_present_jobID = true && that.isSetJobID();
      if (this_present_jobID || that_present_jobID) {
        if (!(this_present_jobID && that_present_jobID))
          return false;
        if (!this.jobID.equals(that.jobID))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJobCounterRollups_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJobCounterRollups_args typedOther = (getJobCounterRollups_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJobID()).compareTo(typedOther.isSetJobID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJobID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jobID, typedOther.jobID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJobCounterRollups_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jobID:");
      if (this.jobID == null) {
        sb.append("null");
      } else {
        sb.append(this.jobID);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (jobID != null) {
        jobID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJobCounterRollups_argsStandardSchemeFactory implements SchemeFactory {
      public getJobCounterRollups_argsStandardScheme getScheme() {
        return new getJobCounterRollups_argsStandardScheme();
      }
    }

    private static class getJobCounterRollups_argsStandardScheme extends StandardScheme<getJobCounterRollups_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJobCounterRollups_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // JOB_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jobID = new ThriftJobID();
                struct.jobID.read(iprot);
                struct.setJobIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJobCounterRollups_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.jobID != null) {
          oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
          struct.jobID.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJobCounterRollups_argsTupleSchemeFactory implements SchemeFactory {
      public getJobCounterRollups_argsTupleScheme getScheme() {
        return new getJobCounterRollups_argsTupleScheme();
      }
    }

    private static class getJobCounterRollups_argsTupleScheme extends TupleScheme<getJobCounterRollups_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJobCounterRollups_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetJobID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetJobID()) {
          struct.jobID.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJobCounterRollups_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jobID = new ThriftJobID();
          struct.jobID.read(iprot);
          struct.setJobIDIsSet(true);
        }
      }
    }

  }

  public static class getJobCounterRollups_result implements org.apache.thrift.TBase<getJobCounterRollups_result, getJobCounterRollups_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJobCounterRollups_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJobCounterRollups_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJobCounterRollups_resultTupleSchemeFactory());
    }

    public ThriftJobCounterRollups success; // required
    public JobNotFoundException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobCounterRollups.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJobCounterRollups_result.class, metaDataMap);
    }

    public getJobCounterRollups_result() {
    }

    public getJobCounterRollups_result(
      ThriftJobCounterRollups success,
      JobNotFoundException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJobCounterRollups_result(getJobCounterRollups_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftJobCounterRollups(other.success);
      }
      if (other.isSetErr()) {
        this.err = new JobNotFoundException(other.err);
      }
    }

    public getJobCounterRollups_result deepCopy() {
      return new getJobCounterRollups_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public ThriftJobCounterRollups getSuccess() {
      return this.success;
    }

    public getJobCounterRollups_result setSuccess(ThriftJobCounterRollups success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public JobNotFoundException getErr() {
      return this.err;
    }

    public getJobCounterRollups_result setErr(JobNotFoundException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftJobCounterRollups)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((JobNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJobCounterRollups_result)
        return this.equals((getJobCounterRollups_result)that);
      return false;
    }

    public boolean equals(getJobCounterRollups_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJobCounterRollups_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJobCounterRollups_result typedOther = (getJobCounterRollups_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJobCounterRollups_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJobCounterRollups_resultStandardSchemeFactory implements SchemeFactory {
      public getJobCounterRollups_resultStandardScheme getScheme() {
        return new getJobCounterRollups_resultStandardScheme();
      }
    }

    private static class getJobCounterRollups_resultStandardScheme extends StandardScheme<getJobCounterRollups_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJobCounterRollups_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftJobCounterRollups();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new JobNotFoundException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJobCounterRollups_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJobCounterRollups_resultTupleSchemeFactory implements SchemeFactory {
      public getJobCounterRollups_resultTupleScheme getScheme() {
        return new getJobCounterRollups_resultTupleScheme();
      }
    }

    private static class getJobCounterRollups_resultTupleScheme extends TupleScheme<getJobCounterRollups_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJobCounterRollups_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJobCounterRollups_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ThriftJobCounterRollups();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new JobNotFoundException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class getActiveTrackers_args implements org.apache.thrift.TBase<getActiveTrackers_args, getActiveTrackers_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getActiveTrackers_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getActiveTrackers_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getActiveTrackers_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getActiveTrackers_args.class, metaDataMap);
    }

    public getActiveTrackers_args() {
    }

    public getActiveTrackers_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getActiveTrackers_args(getActiveTrackers_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getActiveTrackers_args deepCopy() {
      return new getActiveTrackers_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getActiveTrackers_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getActiveTrackers_args)
        return this.equals((getActiveTrackers_args)that);
      return false;
    }

    public boolean equals(getActiveTrackers_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getActiveTrackers_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getActiveTrackers_args typedOther = (getActiveTrackers_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getActiveTrackers_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getActiveTrackers_argsStandardSchemeFactory implements SchemeFactory {
      public getActiveTrackers_argsStandardScheme getScheme() {
        return new getActiveTrackers_argsStandardScheme();
      }
    }

    private static class getActiveTrackers_argsStandardScheme extends StandardScheme<getActiveTrackers_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getActiveTrackers_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getActiveTrackers_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getActiveTrackers_argsTupleSchemeFactory implements SchemeFactory {
      public getActiveTrackers_argsTupleScheme getScheme() {
        return new getActiveTrackers_argsTupleScheme();
      }
    }

    private static class getActiveTrackers_argsTupleScheme extends TupleScheme<getActiveTrackers_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getActiveTrackers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getActiveTrackers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getActiveTrackers_result implements org.apache.thrift.TBase<getActiveTrackers_result, getActiveTrackers_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getActiveTrackers_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getActiveTrackers_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getActiveTrackers_resultTupleSchemeFactory());
    }

    public ThriftTaskTrackerStatusList success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftTaskTrackerStatusList.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getActiveTrackers_result.class, metaDataMap);
    }

    public getActiveTrackers_result() {
    }

    public getActiveTrackers_result(
      ThriftTaskTrackerStatusList success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getActiveTrackers_result(getActiveTrackers_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftTaskTrackerStatusList(other.success);
      }
    }

    public getActiveTrackers_result deepCopy() {
      return new getActiveTrackers_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftTaskTrackerStatusList getSuccess() {
      return this.success;
    }

    public getActiveTrackers_result setSuccess(ThriftTaskTrackerStatusList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftTaskTrackerStatusList)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getActiveTrackers_result)
        return this.equals((getActiveTrackers_result)that);
      return false;
    }

    public boolean equals(getActiveTrackers_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getActiveTrackers_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getActiveTrackers_result typedOther = (getActiveTrackers_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getActiveTrackers_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getActiveTrackers_resultStandardSchemeFactory implements SchemeFactory {
      public getActiveTrackers_resultStandardScheme getScheme() {
        return new getActiveTrackers_resultStandardScheme();
      }
    }

    private static class getActiveTrackers_resultStandardScheme extends StandardScheme<getActiveTrackers_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getActiveTrackers_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftTaskTrackerStatusList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getActiveTrackers_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getActiveTrackers_resultTupleSchemeFactory implements SchemeFactory {
      public getActiveTrackers_resultTupleScheme getScheme() {
        return new getActiveTrackers_resultTupleScheme();
      }
    }

    private static class getActiveTrackers_resultTupleScheme extends TupleScheme<getActiveTrackers_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getActiveTrackers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getActiveTrackers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftTaskTrackerStatusList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getBlacklistedTrackers_args implements org.apache.thrift.TBase<getBlacklistedTrackers_args, getBlacklistedTrackers_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getBlacklistedTrackers_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getBlacklistedTrackers_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getBlacklistedTrackers_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getBlacklistedTrackers_args.class, metaDataMap);
    }

    public getBlacklistedTrackers_args() {
    }

    public getBlacklistedTrackers_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getBlacklistedTrackers_args(getBlacklistedTrackers_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getBlacklistedTrackers_args deepCopy() {
      return new getBlacklistedTrackers_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getBlacklistedTrackers_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getBlacklistedTrackers_args)
        return this.equals((getBlacklistedTrackers_args)that);
      return false;
    }

    public boolean equals(getBlacklistedTrackers_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getBlacklistedTrackers_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getBlacklistedTrackers_args typedOther = (getBlacklistedTrackers_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getBlacklistedTrackers_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getBlacklistedTrackers_argsStandardSchemeFactory implements SchemeFactory {
      public getBlacklistedTrackers_argsStandardScheme getScheme() {
        return new getBlacklistedTrackers_argsStandardScheme();
      }
    }

    private static class getBlacklistedTrackers_argsStandardScheme extends StandardScheme<getBlacklistedTrackers_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getBlacklistedTrackers_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getBlacklistedTrackers_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getBlacklistedTrackers_argsTupleSchemeFactory implements SchemeFactory {
      public getBlacklistedTrackers_argsTupleScheme getScheme() {
        return new getBlacklistedTrackers_argsTupleScheme();
      }
    }

    private static class getBlacklistedTrackers_argsTupleScheme extends TupleScheme<getBlacklistedTrackers_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getBlacklistedTrackers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getBlacklistedTrackers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getBlacklistedTrackers_result implements org.apache.thrift.TBase<getBlacklistedTrackers_result, getBlacklistedTrackers_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getBlacklistedTrackers_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getBlacklistedTrackers_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getBlacklistedTrackers_resultTupleSchemeFactory());
    }

    public ThriftTaskTrackerStatusList success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftTaskTrackerStatusList.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getBlacklistedTrackers_result.class, metaDataMap);
    }

    public getBlacklistedTrackers_result() {
    }

    public getBlacklistedTrackers_result(
      ThriftTaskTrackerStatusList success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getBlacklistedTrackers_result(getBlacklistedTrackers_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftTaskTrackerStatusList(other.success);
      }
    }

    public getBlacklistedTrackers_result deepCopy() {
      return new getBlacklistedTrackers_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftTaskTrackerStatusList getSuccess() {
      return this.success;
    }

    public getBlacklistedTrackers_result setSuccess(ThriftTaskTrackerStatusList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftTaskTrackerStatusList)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getBlacklistedTrackers_result)
        return this.equals((getBlacklistedTrackers_result)that);
      return false;
    }

    public boolean equals(getBlacklistedTrackers_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getBlacklistedTrackers_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getBlacklistedTrackers_result typedOther = (getBlacklistedTrackers_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getBlacklistedTrackers_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getBlacklistedTrackers_resultStandardSchemeFactory implements SchemeFactory {
      public getBlacklistedTrackers_resultStandardScheme getScheme() {
        return new getBlacklistedTrackers_resultStandardScheme();
      }
    }

    private static class getBlacklistedTrackers_resultStandardScheme extends StandardScheme<getBlacklistedTrackers_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getBlacklistedTrackers_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftTaskTrackerStatusList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getBlacklistedTrackers_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getBlacklistedTrackers_resultTupleSchemeFactory implements SchemeFactory {
      public getBlacklistedTrackers_resultTupleScheme getScheme() {
        return new getBlacklistedTrackers_resultTupleScheme();
      }
    }

    private static class getBlacklistedTrackers_resultTupleScheme extends TupleScheme<getBlacklistedTrackers_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getBlacklistedTrackers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getBlacklistedTrackers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftTaskTrackerStatusList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getAllTrackers_args implements org.apache.thrift.TBase<getAllTrackers_args, getAllTrackers_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getAllTrackers_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getAllTrackers_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getAllTrackers_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getAllTrackers_args.class, metaDataMap);
    }

    public getAllTrackers_args() {
    }

    public getAllTrackers_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getAllTrackers_args(getAllTrackers_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getAllTrackers_args deepCopy() {
      return new getAllTrackers_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getAllTrackers_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getAllTrackers_args)
        return this.equals((getAllTrackers_args)that);
      return false;
    }

    public boolean equals(getAllTrackers_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getAllTrackers_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getAllTrackers_args typedOther = (getAllTrackers_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getAllTrackers_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getAllTrackers_argsStandardSchemeFactory implements SchemeFactory {
      public getAllTrackers_argsStandardScheme getScheme() {
        return new getAllTrackers_argsStandardScheme();
      }
    }

    private static class getAllTrackers_argsStandardScheme extends StandardScheme<getAllTrackers_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getAllTrackers_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getAllTrackers_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getAllTrackers_argsTupleSchemeFactory implements SchemeFactory {
      public getAllTrackers_argsTupleScheme getScheme() {
        return new getAllTrackers_argsTupleScheme();
      }
    }

    private static class getAllTrackers_argsTupleScheme extends TupleScheme<getAllTrackers_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getAllTrackers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getAllTrackers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getAllTrackers_result implements org.apache.thrift.TBase<getAllTrackers_result, getAllTrackers_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getAllTrackers_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getAllTrackers_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getAllTrackers_resultTupleSchemeFactory());
    }

    public ThriftTaskTrackerStatusList success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftTaskTrackerStatusList.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getAllTrackers_result.class, metaDataMap);
    }

    public getAllTrackers_result() {
    }

    public getAllTrackers_result(
      ThriftTaskTrackerStatusList success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getAllTrackers_result(getAllTrackers_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftTaskTrackerStatusList(other.success);
      }
    }

    public getAllTrackers_result deepCopy() {
      return new getAllTrackers_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public ThriftTaskTrackerStatusList getSuccess() {
      return this.success;
    }

    public getAllTrackers_result setSuccess(ThriftTaskTrackerStatusList success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftTaskTrackerStatusList)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getAllTrackers_result)
        return this.equals((getAllTrackers_result)that);
      return false;
    }

    public boolean equals(getAllTrackers_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getAllTrackers_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getAllTrackers_result typedOther = (getAllTrackers_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getAllTrackers_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getAllTrackers_resultStandardSchemeFactory implements SchemeFactory {
      public getAllTrackers_resultStandardScheme getScheme() {
        return new getAllTrackers_resultStandardScheme();
      }
    }

    private static class getAllTrackers_resultStandardScheme extends StandardScheme<getAllTrackers_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getAllTrackers_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftTaskTrackerStatusList();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getAllTrackers_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getAllTrackers_resultTupleSchemeFactory implements SchemeFactory {
      public getAllTrackers_resultTupleScheme getScheme() {
        return new getAllTrackers_resultTupleScheme();
      }
    }

    private static class getAllTrackers_resultTupleScheme extends TupleScheme<getAllTrackers_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getAllTrackers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getAllTrackers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new ThriftTaskTrackerStatusList();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getTracker_args implements org.apache.thrift.TBase<getTracker_args, getTracker_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTracker_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTracker_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTracker_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public String name; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      NAME((short)1, "name");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // NAME
            return NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTracker_args.class, metaDataMap);
    }

    public getTracker_args() {
    }

    public getTracker_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String name)
    {
      this();
      this.ctx = ctx;
      this.name = name;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTracker_args(getTracker_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetName()) {
        this.name = other.name;
      }
    }

    public getTracker_args deepCopy() {
      return new getTracker_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.name = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getTracker_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public String getName() {
      return this.name;
    }

    public getTracker_args setName(String name) {
      this.name = name;
      return this;
    }

    public void unsetName() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean isSetName() {
      return this.name != null;
    }

    public void setNameIsSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case NAME:
        if (value == null) {
          unsetName();
        } else {
          setName((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case NAME:
        return getName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case NAME:
        return isSetName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTracker_args)
        return this.equals((getTracker_args)that);
      return false;
    }

    public boolean equals(getTracker_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_name = true && this.isSetName();
      boolean that_present_name = true && that.isSetName();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getTracker_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTracker_args typedOther = (getTracker_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetName()).compareTo(typedOther.isSetName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, typedOther.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTracker_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTracker_argsStandardSchemeFactory implements SchemeFactory {
      public getTracker_argsStandardScheme getScheme() {
        return new getTracker_argsStandardScheme();
      }
    }

    private static class getTracker_argsStandardScheme extends StandardScheme<getTracker_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTracker_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTracker_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTracker_argsTupleSchemeFactory implements SchemeFactory {
      public getTracker_argsTupleScheme getScheme() {
        return new getTracker_argsTupleScheme();
      }
    }

    private static class getTracker_argsTupleScheme extends TupleScheme<getTracker_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTracker_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetName()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetName()) {
          oprot.writeString(struct.name);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTracker_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.name = iprot.readString();
          struct.setNameIsSet(true);
        }
      }
    }

  }

  public static class getTracker_result implements org.apache.thrift.TBase<getTracker_result, getTracker_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTracker_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField TNE_FIELD_DESC = new org.apache.thrift.protocol.TField("tne", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTracker_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTracker_resultTupleSchemeFactory());
    }

    public ThriftTaskTrackerStatus success; // required
    public TaskTrackerNotFoundException tne; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      TNE((short)1, "tne");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // TNE
            return TNE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftTaskTrackerStatus.class)));
      tmpMap.put(_Fields.TNE, new org.apache.thrift.meta_data.FieldMetaData("tne", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTracker_result.class, metaDataMap);
    }

    public getTracker_result() {
    }

    public getTracker_result(
      ThriftTaskTrackerStatus success,
      TaskTrackerNotFoundException tne)
    {
      this();
      this.success = success;
      this.tne = tne;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTracker_result(getTracker_result other) {
      if (other.isSetSuccess()) {
        this.success = new ThriftTaskTrackerStatus(other.success);
      }
      if (other.isSetTne()) {
        this.tne = new TaskTrackerNotFoundException(other.tne);
      }
    }

    public getTracker_result deepCopy() {
      return new getTracker_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.tne = null;
    }

    public ThriftTaskTrackerStatus getSuccess() {
      return this.success;
    }

    public getTracker_result setSuccess(ThriftTaskTrackerStatus success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TaskTrackerNotFoundException getTne() {
      return this.tne;
    }

    public getTracker_result setTne(TaskTrackerNotFoundException tne) {
      this.tne = tne;
      return this;
    }

    public void unsetTne() {
      this.tne = null;
    }

    /** Returns true if field tne is set (has been assigned a value) and false otherwise */
    public boolean isSetTne() {
      return this.tne != null;
    }

    public void setTneIsSet(boolean value) {
      if (!value) {
        this.tne = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ThriftTaskTrackerStatus)value);
        }
        break;

      case TNE:
        if (value == null) {
          unsetTne();
        } else {
          setTne((TaskTrackerNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case TNE:
        return getTne();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case TNE:
        return isSetTne();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTracker_result)
        return this.equals((getTracker_result)that);
      return false;
    }

    public boolean equals(getTracker_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_tne = true && this.isSetTne();
      boolean that_present_tne = true && that.isSetTne();
      if (this_present_tne || that_present_tne) {
        if (!(this_present_tne && that_present_tne))
          return false;
        if (!this.tne.equals(that.tne))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getTracker_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTracker_result typedOther = (getTracker_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTne()).compareTo(typedOther.isSetTne());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTne()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tne, typedOther.tne);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTracker_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tne:");
      if (this.tne == null) {
        sb.append("null");
      } else {
        sb.append(this.tne);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTracker_resultStandardSchemeFactory implements SchemeFactory {
      public getTracker_resultStandardScheme getScheme() {
        return new getTracker_resultStandardScheme();
      }
    }

    private static class getTracker_resultStandardScheme extends StandardScheme<getTracker_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTracker_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ThriftTaskTrackerStatus();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // TNE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tne = new TaskTrackerNotFoundException();
                struct.tne.read(iprot);
                struct.setTneIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTracker_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tne != null) {
          oprot.writeFieldBegin(TNE_FIELD_DESC);
          struct.tne.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTracker_resultTupleSchemeFactory implements SchemeFactory {
      public getTracker_resultTupleScheme getScheme() {
        return new getTracker_resultTupleScheme();
      }
    }

    private static class getTracker_resultTupleScheme extends TupleScheme<getTracker_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTracker_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetTne()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetTne()) {
          struct.tne.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTracker_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ThriftTaskTrackerStatus();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.tne = new TaskTrackerNotFoundException();
          struct.tne.read(iprot);
          struct.setTneIsSet(true);
        }
      }
    }

  }

  public static class getCurrentTime_args implements org.apache.thrift.TBase<getCurrentTime_args, getCurrentTime_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getCurrentTime_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getCurrentTime_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getCurrentTime_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getCurrentTime_args.class, metaDataMap);
    }

    public getCurrentTime_args() {
    }

    public getCurrentTime_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getCurrentTime_args(getCurrentTime_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public getCurrentTime_args deepCopy() {
      return new getCurrentTime_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getCurrentTime_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getCurrentTime_args)
        return this.equals((getCurrentTime_args)that);
      return false;
    }

    public boolean equals(getCurrentTime_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getCurrentTime_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getCurrentTime_args typedOther = (getCurrentTime_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getCurrentTime_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getCurrentTime_argsStandardSchemeFactory implements SchemeFactory {
      public getCurrentTime_argsStandardScheme getScheme() {
        return new getCurrentTime_argsStandardScheme();
      }
    }

    private static class getCurrentTime_argsStandardScheme extends StandardScheme<getCurrentTime_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getCurrentTime_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getCurrentTime_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getCurrentTime_argsTupleSchemeFactory implements SchemeFactory {
      public getCurrentTime_argsTupleScheme getScheme() {
        return new getCurrentTime_argsTupleScheme();
      }
    }

    private static class getCurrentTime_argsTupleScheme extends TupleScheme<getCurrentTime_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getCurrentTime_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getCurrentTime_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class getCurrentTime_result implements org.apache.thrift.TBase<getCurrentTime_result, getCurrentTime_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getCurrentTime_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getCurrentTime_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getCurrentTime_resultTupleSchemeFactory());
    }

    public long success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getCurrentTime_result.class, metaDataMap);
    }

    public getCurrentTime_result() {
    }

    public getCurrentTime_result(
      long success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getCurrentTime_result(getCurrentTime_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    public getCurrentTime_result deepCopy() {
      return new getCurrentTime_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
    }

    public long getSuccess() {
      return this.success;
    }

    public getCurrentTime_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Long.valueOf(getSuccess());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getCurrentTime_result)
        return this.equals((getCurrentTime_result)that);
      return false;
    }

    public boolean equals(getCurrentTime_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getCurrentTime_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getCurrentTime_result typedOther = (getCurrentTime_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getCurrentTime_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getCurrentTime_resultStandardSchemeFactory implements SchemeFactory {
      public getCurrentTime_resultStandardScheme getScheme() {
        return new getCurrentTime_resultStandardScheme();
      }
    }

    private static class getCurrentTime_resultStandardScheme extends StandardScheme<getCurrentTime_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getCurrentTime_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getCurrentTime_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getCurrentTime_resultTupleSchemeFactory implements SchemeFactory {
      public getCurrentTime_resultTupleScheme getScheme() {
        return new getCurrentTime_resultTupleScheme();
      }
    }

    private static class getCurrentTime_resultTupleScheme extends TupleScheme<getCurrentTime_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getCurrentTime_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getCurrentTime_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getJobConfXML_args implements org.apache.thrift.TBase<getJobConfXML_args, getJobConfXML_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJobConfXML_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField JOB_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("jobID", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJobConfXML_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJobConfXML_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftJobID jobID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      JOB_ID((short)1, "jobID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // JOB_ID
            return JOB_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.JOB_ID, new org.apache.thrift.meta_data.FieldMetaData("jobID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobID.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJobConfXML_args.class, metaDataMap);
    }

    public getJobConfXML_args() {
    }

    public getJobConfXML_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftJobID jobID)
    {
      this();
      this.ctx = ctx;
      this.jobID = jobID;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJobConfXML_args(getJobConfXML_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetJobID()) {
        this.jobID = new ThriftJobID(other.jobID);
      }
    }

    public getJobConfXML_args deepCopy() {
      return new getJobConfXML_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.jobID = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getJobConfXML_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftJobID getJobID() {
      return this.jobID;
    }

    public getJobConfXML_args setJobID(ThriftJobID jobID) {
      this.jobID = jobID;
      return this;
    }

    public void unsetJobID() {
      this.jobID = null;
    }

    /** Returns true if field jobID is set (has been assigned a value) and false otherwise */
    public boolean isSetJobID() {
      return this.jobID != null;
    }

    public void setJobIDIsSet(boolean value) {
      if (!value) {
        this.jobID = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case JOB_ID:
        if (value == null) {
          unsetJobID();
        } else {
          setJobID((ThriftJobID)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case JOB_ID:
        return getJobID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case JOB_ID:
        return isSetJobID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJobConfXML_args)
        return this.equals((getJobConfXML_args)that);
      return false;
    }

    public boolean equals(getJobConfXML_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_jobID = true && this.isSetJobID();
      boolean that_present_jobID = true && that.isSetJobID();
      if (this_present_jobID || that_present_jobID) {
        if (!(this_present_jobID && that_present_jobID))
          return false;
        if (!this.jobID.equals(that.jobID))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJobConfXML_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJobConfXML_args typedOther = (getJobConfXML_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJobID()).compareTo(typedOther.isSetJobID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJobID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jobID, typedOther.jobID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJobConfXML_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jobID:");
      if (this.jobID == null) {
        sb.append("null");
      } else {
        sb.append(this.jobID);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (jobID != null) {
        jobID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJobConfXML_argsStandardSchemeFactory implements SchemeFactory {
      public getJobConfXML_argsStandardScheme getScheme() {
        return new getJobConfXML_argsStandardScheme();
      }
    }

    private static class getJobConfXML_argsStandardScheme extends StandardScheme<getJobConfXML_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJobConfXML_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // JOB_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jobID = new ThriftJobID();
                struct.jobID.read(iprot);
                struct.setJobIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJobConfXML_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.jobID != null) {
          oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
          struct.jobID.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJobConfXML_argsTupleSchemeFactory implements SchemeFactory {
      public getJobConfXML_argsTupleScheme getScheme() {
        return new getJobConfXML_argsTupleScheme();
      }
    }

    private static class getJobConfXML_argsTupleScheme extends TupleScheme<getJobConfXML_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJobConfXML_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetJobID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetJobID()) {
          struct.jobID.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJobConfXML_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jobID = new ThriftJobID();
          struct.jobID.read(iprot);
          struct.setJobIDIsSet(true);
        }
      }
    }

  }

  public static class getJobConfXML_result implements org.apache.thrift.TBase<getJobConfXML_result, getJobConfXML_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getJobConfXML_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getJobConfXML_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getJobConfXML_resultTupleSchemeFactory());
    }

    public String success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getJobConfXML_result.class, metaDataMap);
    }

    public getJobConfXML_result() {
    }

    public getJobConfXML_result(
      String success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getJobConfXML_result(getJobConfXML_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public getJobConfXML_result deepCopy() {
      return new getJobConfXML_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public getJobConfXML_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public getJobConfXML_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getJobConfXML_result)
        return this.equals((getJobConfXML_result)that);
      return false;
    }

    public boolean equals(getJobConfXML_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getJobConfXML_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getJobConfXML_result typedOther = (getJobConfXML_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getJobConfXML_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getJobConfXML_resultStandardSchemeFactory implements SchemeFactory {
      public getJobConfXML_resultStandardScheme getScheme() {
        return new getJobConfXML_resultStandardScheme();
      }
    }

    private static class getJobConfXML_resultStandardScheme extends StandardScheme<getJobConfXML_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getJobConfXML_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getJobConfXML_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getJobConfXML_resultTupleSchemeFactory implements SchemeFactory {
      public getJobConfXML_resultTupleScheme getScheme() {
        return new getJobConfXML_resultTupleScheme();
      }
    }

    private static class getJobConfXML_resultTupleScheme extends TupleScheme<getJobConfXML_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getJobConfXML_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getJobConfXML_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class killJob_args implements org.apache.thrift.TBase<killJob_args, killJob_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killJob_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField JOB_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("jobID", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killJob_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killJob_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftJobID jobID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      JOB_ID((short)1, "jobID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // JOB_ID
            return JOB_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.JOB_ID, new org.apache.thrift.meta_data.FieldMetaData("jobID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobID.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killJob_args.class, metaDataMap);
    }

    public killJob_args() {
    }

    public killJob_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftJobID jobID)
    {
      this();
      this.ctx = ctx;
      this.jobID = jobID;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killJob_args(killJob_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetJobID()) {
        this.jobID = new ThriftJobID(other.jobID);
      }
    }

    public killJob_args deepCopy() {
      return new killJob_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.jobID = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public killJob_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftJobID getJobID() {
      return this.jobID;
    }

    public killJob_args setJobID(ThriftJobID jobID) {
      this.jobID = jobID;
      return this;
    }

    public void unsetJobID() {
      this.jobID = null;
    }

    /** Returns true if field jobID is set (has been assigned a value) and false otherwise */
    public boolean isSetJobID() {
      return this.jobID != null;
    }

    public void setJobIDIsSet(boolean value) {
      if (!value) {
        this.jobID = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case JOB_ID:
        if (value == null) {
          unsetJobID();
        } else {
          setJobID((ThriftJobID)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case JOB_ID:
        return getJobID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case JOB_ID:
        return isSetJobID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killJob_args)
        return this.equals((killJob_args)that);
      return false;
    }

    public boolean equals(killJob_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_jobID = true && this.isSetJobID();
      boolean that_present_jobID = true && that.isSetJobID();
      if (this_present_jobID || that_present_jobID) {
        if (!(this_present_jobID && that_present_jobID))
          return false;
        if (!this.jobID.equals(that.jobID))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(killJob_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      killJob_args typedOther = (killJob_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJobID()).compareTo(typedOther.isSetJobID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJobID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jobID, typedOther.jobID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killJob_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jobID:");
      if (this.jobID == null) {
        sb.append("null");
      } else {
        sb.append(this.jobID);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (jobID != null) {
        jobID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killJob_argsStandardSchemeFactory implements SchemeFactory {
      public killJob_argsStandardScheme getScheme() {
        return new killJob_argsStandardScheme();
      }
    }

    private static class killJob_argsStandardScheme extends StandardScheme<killJob_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killJob_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // JOB_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jobID = new ThriftJobID();
                struct.jobID.read(iprot);
                struct.setJobIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killJob_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.jobID != null) {
          oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
          struct.jobID.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killJob_argsTupleSchemeFactory implements SchemeFactory {
      public killJob_argsTupleScheme getScheme() {
        return new killJob_argsTupleScheme();
      }
    }

    private static class killJob_argsTupleScheme extends TupleScheme<killJob_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetJobID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetJobID()) {
          struct.jobID.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killJob_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jobID = new ThriftJobID();
          struct.jobID.read(iprot);
          struct.setJobIDIsSet(true);
        }
      }
    }

  }

  public static class killJob_result implements org.apache.thrift.TBase<killJob_result, killJob_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killJob_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField JNE_FIELD_DESC = new org.apache.thrift.protocol.TField("jne", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killJob_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killJob_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required
    public JobNotFoundException jne; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err"),
      JNE((short)2, "jne");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          case 2: // JNE
            return JNE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.JNE, new org.apache.thrift.meta_data.FieldMetaData("jne", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killJob_result.class, metaDataMap);
    }

    public killJob_result() {
    }

    public killJob_result(
      org.apache.hadoop.thriftfs.api.IOException err,
      JobNotFoundException jne)
    {
      this();
      this.err = err;
      this.jne = jne;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killJob_result(killJob_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
      if (other.isSetJne()) {
        this.jne = new JobNotFoundException(other.jne);
      }
    }

    public killJob_result deepCopy() {
      return new killJob_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
      this.jne = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public killJob_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public JobNotFoundException getJne() {
      return this.jne;
    }

    public killJob_result setJne(JobNotFoundException jne) {
      this.jne = jne;
      return this;
    }

    public void unsetJne() {
      this.jne = null;
    }

    /** Returns true if field jne is set (has been assigned a value) and false otherwise */
    public boolean isSetJne() {
      return this.jne != null;
    }

    public void setJneIsSet(boolean value) {
      if (!value) {
        this.jne = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      case JNE:
        if (value == null) {
          unsetJne();
        } else {
          setJne((JobNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      case JNE:
        return getJne();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      case JNE:
        return isSetJne();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killJob_result)
        return this.equals((killJob_result)that);
      return false;
    }

    public boolean equals(killJob_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      boolean this_present_jne = true && this.isSetJne();
      boolean that_present_jne = true && that.isSetJne();
      if (this_present_jne || that_present_jne) {
        if (!(this_present_jne && that_present_jne))
          return false;
        if (!this.jne.equals(that.jne))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(killJob_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      killJob_result typedOther = (killJob_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJne()).compareTo(typedOther.isSetJne());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJne()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jne, typedOther.jne);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killJob_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jne:");
      if (this.jne == null) {
        sb.append("null");
      } else {
        sb.append(this.jne);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killJob_resultStandardSchemeFactory implements SchemeFactory {
      public killJob_resultStandardScheme getScheme() {
        return new killJob_resultStandardScheme();
      }
    }

    private static class killJob_resultStandardScheme extends StandardScheme<killJob_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killJob_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // JNE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jne = new JobNotFoundException();
                struct.jne.read(iprot);
                struct.setJneIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killJob_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.jne != null) {
          oprot.writeFieldBegin(JNE_FIELD_DESC);
          struct.jne.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killJob_resultTupleSchemeFactory implements SchemeFactory {
      public killJob_resultTupleScheme getScheme() {
        return new killJob_resultTupleScheme();
      }
    }

    private static class killJob_resultTupleScheme extends TupleScheme<killJob_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        if (struct.isSetJne()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
        if (struct.isSetJne()) {
          struct.jne.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killJob_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jne = new JobNotFoundException();
          struct.jne.read(iprot);
          struct.setJneIsSet(true);
        }
      }
    }

  }

  public static class killTaskAttempt_args implements org.apache.thrift.TBase<killTaskAttempt_args, killTaskAttempt_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killTaskAttempt_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField ATTEMPT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("attemptID", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killTaskAttempt_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killTaskAttempt_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftTaskAttemptID attemptID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      ATTEMPT_ID((short)1, "attemptID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // ATTEMPT_ID
            return ATTEMPT_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.ATTEMPT_ID, new org.apache.thrift.meta_data.FieldMetaData("attemptID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftTaskAttemptID.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killTaskAttempt_args.class, metaDataMap);
    }

    public killTaskAttempt_args() {
    }

    public killTaskAttempt_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftTaskAttemptID attemptID)
    {
      this();
      this.ctx = ctx;
      this.attemptID = attemptID;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killTaskAttempt_args(killTaskAttempt_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetAttemptID()) {
        this.attemptID = new ThriftTaskAttemptID(other.attemptID);
      }
    }

    public killTaskAttempt_args deepCopy() {
      return new killTaskAttempt_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.attemptID = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public killTaskAttempt_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftTaskAttemptID getAttemptID() {
      return this.attemptID;
    }

    public killTaskAttempt_args setAttemptID(ThriftTaskAttemptID attemptID) {
      this.attemptID = attemptID;
      return this;
    }

    public void unsetAttemptID() {
      this.attemptID = null;
    }

    /** Returns true if field attemptID is set (has been assigned a value) and false otherwise */
    public boolean isSetAttemptID() {
      return this.attemptID != null;
    }

    public void setAttemptIDIsSet(boolean value) {
      if (!value) {
        this.attemptID = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case ATTEMPT_ID:
        if (value == null) {
          unsetAttemptID();
        } else {
          setAttemptID((ThriftTaskAttemptID)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case ATTEMPT_ID:
        return getAttemptID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case ATTEMPT_ID:
        return isSetAttemptID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killTaskAttempt_args)
        return this.equals((killTaskAttempt_args)that);
      return false;
    }

    public boolean equals(killTaskAttempt_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_attemptID = true && this.isSetAttemptID();
      boolean that_present_attemptID = true && that.isSetAttemptID();
      if (this_present_attemptID || that_present_attemptID) {
        if (!(this_present_attemptID && that_present_attemptID))
          return false;
        if (!this.attemptID.equals(that.attemptID))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(killTaskAttempt_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      killTaskAttempt_args typedOther = (killTaskAttempt_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttemptID()).compareTo(typedOther.isSetAttemptID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttemptID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attemptID, typedOther.attemptID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killTaskAttempt_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("attemptID:");
      if (this.attemptID == null) {
        sb.append("null");
      } else {
        sb.append(this.attemptID);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (attemptID != null) {
        attemptID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killTaskAttempt_argsStandardSchemeFactory implements SchemeFactory {
      public killTaskAttempt_argsStandardScheme getScheme() {
        return new killTaskAttempt_argsStandardScheme();
      }
    }

    private static class killTaskAttempt_argsStandardScheme extends StandardScheme<killTaskAttempt_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killTaskAttempt_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ATTEMPT_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.attemptID = new ThriftTaskAttemptID();
                struct.attemptID.read(iprot);
                struct.setAttemptIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killTaskAttempt_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.attemptID != null) {
          oprot.writeFieldBegin(ATTEMPT_ID_FIELD_DESC);
          struct.attemptID.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killTaskAttempt_argsTupleSchemeFactory implements SchemeFactory {
      public killTaskAttempt_argsTupleScheme getScheme() {
        return new killTaskAttempt_argsTupleScheme();
      }
    }

    private static class killTaskAttempt_argsTupleScheme extends TupleScheme<killTaskAttempt_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killTaskAttempt_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetAttemptID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetAttemptID()) {
          struct.attemptID.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killTaskAttempt_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.attemptID = new ThriftTaskAttemptID();
          struct.attemptID.read(iprot);
          struct.setAttemptIDIsSet(true);
        }
      }
    }

  }

  public static class killTaskAttempt_result implements org.apache.thrift.TBase<killTaskAttempt_result, killTaskAttempt_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("killTaskAttempt_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TNE_FIELD_DESC = new org.apache.thrift.protocol.TField("tne", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField JNE_FIELD_DESC = new org.apache.thrift.protocol.TField("jne", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new killTaskAttempt_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new killTaskAttempt_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required
    public TaskAttemptNotFoundException tne; // required
    public JobNotFoundException jne; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err"),
      TNE((short)2, "tne"),
      JNE((short)3, "jne");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          case 2: // TNE
            return TNE;
          case 3: // JNE
            return JNE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TNE, new org.apache.thrift.meta_data.FieldMetaData("tne", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.JNE, new org.apache.thrift.meta_data.FieldMetaData("jne", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(killTaskAttempt_result.class, metaDataMap);
    }

    public killTaskAttempt_result() {
    }

    public killTaskAttempt_result(
      org.apache.hadoop.thriftfs.api.IOException err,
      TaskAttemptNotFoundException tne,
      JobNotFoundException jne)
    {
      this();
      this.err = err;
      this.tne = tne;
      this.jne = jne;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public killTaskAttempt_result(killTaskAttempt_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
      if (other.isSetTne()) {
        this.tne = new TaskAttemptNotFoundException(other.tne);
      }
      if (other.isSetJne()) {
        this.jne = new JobNotFoundException(other.jne);
      }
    }

    public killTaskAttempt_result deepCopy() {
      return new killTaskAttempt_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
      this.tne = null;
      this.jne = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public killTaskAttempt_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public TaskAttemptNotFoundException getTne() {
      return this.tne;
    }

    public killTaskAttempt_result setTne(TaskAttemptNotFoundException tne) {
      this.tne = tne;
      return this;
    }

    public void unsetTne() {
      this.tne = null;
    }

    /** Returns true if field tne is set (has been assigned a value) and false otherwise */
    public boolean isSetTne() {
      return this.tne != null;
    }

    public void setTneIsSet(boolean value) {
      if (!value) {
        this.tne = null;
      }
    }

    public JobNotFoundException getJne() {
      return this.jne;
    }

    public killTaskAttempt_result setJne(JobNotFoundException jne) {
      this.jne = jne;
      return this;
    }

    public void unsetJne() {
      this.jne = null;
    }

    /** Returns true if field jne is set (has been assigned a value) and false otherwise */
    public boolean isSetJne() {
      return this.jne != null;
    }

    public void setJneIsSet(boolean value) {
      if (!value) {
        this.jne = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      case TNE:
        if (value == null) {
          unsetTne();
        } else {
          setTne((TaskAttemptNotFoundException)value);
        }
        break;

      case JNE:
        if (value == null) {
          unsetJne();
        } else {
          setJne((JobNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      case TNE:
        return getTne();

      case JNE:
        return getJne();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      case TNE:
        return isSetTne();
      case JNE:
        return isSetJne();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof killTaskAttempt_result)
        return this.equals((killTaskAttempt_result)that);
      return false;
    }

    public boolean equals(killTaskAttempt_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      boolean this_present_tne = true && this.isSetTne();
      boolean that_present_tne = true && that.isSetTne();
      if (this_present_tne || that_present_tne) {
        if (!(this_present_tne && that_present_tne))
          return false;
        if (!this.tne.equals(that.tne))
          return false;
      }

      boolean this_present_jne = true && this.isSetJne();
      boolean that_present_jne = true && that.isSetJne();
      if (this_present_jne || that_present_jne) {
        if (!(this_present_jne && that_present_jne))
          return false;
        if (!this.jne.equals(that.jne))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(killTaskAttempt_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      killTaskAttempt_result typedOther = (killTaskAttempt_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTne()).compareTo(typedOther.isSetTne());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTne()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tne, typedOther.tne);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJne()).compareTo(typedOther.isSetJne());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJne()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jne, typedOther.jne);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("killTaskAttempt_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tne:");
      if (this.tne == null) {
        sb.append("null");
      } else {
        sb.append(this.tne);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jne:");
      if (this.jne == null) {
        sb.append("null");
      } else {
        sb.append(this.jne);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class killTaskAttempt_resultStandardSchemeFactory implements SchemeFactory {
      public killTaskAttempt_resultStandardScheme getScheme() {
        return new killTaskAttempt_resultStandardScheme();
      }
    }

    private static class killTaskAttempt_resultStandardScheme extends StandardScheme<killTaskAttempt_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, killTaskAttempt_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TNE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tne = new TaskAttemptNotFoundException();
                struct.tne.read(iprot);
                struct.setTneIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // JNE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jne = new JobNotFoundException();
                struct.jne.read(iprot);
                struct.setJneIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, killTaskAttempt_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tne != null) {
          oprot.writeFieldBegin(TNE_FIELD_DESC);
          struct.tne.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.jne != null) {
          oprot.writeFieldBegin(JNE_FIELD_DESC);
          struct.jne.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class killTaskAttempt_resultTupleSchemeFactory implements SchemeFactory {
      public killTaskAttempt_resultTupleScheme getScheme() {
        return new killTaskAttempt_resultTupleScheme();
      }
    }

    private static class killTaskAttempt_resultTupleScheme extends TupleScheme<killTaskAttempt_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, killTaskAttempt_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        if (struct.isSetTne()) {
          optionals.set(1);
        }
        if (struct.isSetJne()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
        if (struct.isSetTne()) {
          struct.tne.write(oprot);
        }
        if (struct.isSetJne()) {
          struct.jne.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, killTaskAttempt_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
        if (incoming.get(1)) {
          struct.tne = new TaskAttemptNotFoundException();
          struct.tne.read(iprot);
          struct.setTneIsSet(true);
        }
        if (incoming.get(2)) {
          struct.jne = new JobNotFoundException();
          struct.jne.read(iprot);
          struct.setJneIsSet(true);
        }
      }
    }

  }

  public static class setJobPriority_args implements org.apache.thrift.TBase<setJobPriority_args, setJobPriority_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setJobPriority_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField JOB_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("jobID", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField PRIORITY_FIELD_DESC = new org.apache.thrift.protocol.TField("priority", org.apache.thrift.protocol.TType.I32, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setJobPriority_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setJobPriority_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public ThriftJobID jobID; // required
    /**
     * 
     * @see ThriftJobPriority
     */
    public ThriftJobPriority priority; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      JOB_ID((short)1, "jobID"),
      /**
       * 
       * @see ThriftJobPriority
       */
      PRIORITY((short)2, "priority");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // JOB_ID
            return JOB_ID;
          case 2: // PRIORITY
            return PRIORITY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.JOB_ID, new org.apache.thrift.meta_data.FieldMetaData("jobID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ThriftJobID.class)));
      tmpMap.put(_Fields.PRIORITY, new org.apache.thrift.meta_data.FieldMetaData("priority", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ThriftJobPriority.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setJobPriority_args.class, metaDataMap);
    }

    public setJobPriority_args() {
    }

    public setJobPriority_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      ThriftJobID jobID,
      ThriftJobPriority priority)
    {
      this();
      this.ctx = ctx;
      this.jobID = jobID;
      this.priority = priority;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setJobPriority_args(setJobPriority_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetJobID()) {
        this.jobID = new ThriftJobID(other.jobID);
      }
      if (other.isSetPriority()) {
        this.priority = other.priority;
      }
    }

    public setJobPriority_args deepCopy() {
      return new setJobPriority_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.jobID = null;
      this.priority = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public setJobPriority_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public ThriftJobID getJobID() {
      return this.jobID;
    }

    public setJobPriority_args setJobID(ThriftJobID jobID) {
      this.jobID = jobID;
      return this;
    }

    public void unsetJobID() {
      this.jobID = null;
    }

    /** Returns true if field jobID is set (has been assigned a value) and false otherwise */
    public boolean isSetJobID() {
      return this.jobID != null;
    }

    public void setJobIDIsSet(boolean value) {
      if (!value) {
        this.jobID = null;
      }
    }

    /**
     * 
     * @see ThriftJobPriority
     */
    public ThriftJobPriority getPriority() {
      return this.priority;
    }

    /**
     * 
     * @see ThriftJobPriority
     */
    public setJobPriority_args setPriority(ThriftJobPriority priority) {
      this.priority = priority;
      return this;
    }

    public void unsetPriority() {
      this.priority = null;
    }

    /** Returns true if field priority is set (has been assigned a value) and false otherwise */
    public boolean isSetPriority() {
      return this.priority != null;
    }

    public void setPriorityIsSet(boolean value) {
      if (!value) {
        this.priority = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case JOB_ID:
        if (value == null) {
          unsetJobID();
        } else {
          setJobID((ThriftJobID)value);
        }
        break;

      case PRIORITY:
        if (value == null) {
          unsetPriority();
        } else {
          setPriority((ThriftJobPriority)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case JOB_ID:
        return getJobID();

      case PRIORITY:
        return getPriority();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case JOB_ID:
        return isSetJobID();
      case PRIORITY:
        return isSetPriority();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setJobPriority_args)
        return this.equals((setJobPriority_args)that);
      return false;
    }

    public boolean equals(setJobPriority_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_jobID = true && this.isSetJobID();
      boolean that_present_jobID = true && that.isSetJobID();
      if (this_present_jobID || that_present_jobID) {
        if (!(this_present_jobID && that_present_jobID))
          return false;
        if (!this.jobID.equals(that.jobID))
          return false;
      }

      boolean this_present_priority = true && this.isSetPriority();
      boolean that_present_priority = true && that.isSetPriority();
      if (this_present_priority || that_present_priority) {
        if (!(this_present_priority && that_present_priority))
          return false;
        if (!this.priority.equals(that.priority))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(setJobPriority_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      setJobPriority_args typedOther = (setJobPriority_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJobID()).compareTo(typedOther.isSetJobID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJobID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jobID, typedOther.jobID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPriority()).compareTo(typedOther.isSetPriority());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPriority()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.priority, typedOther.priority);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setJobPriority_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jobID:");
      if (this.jobID == null) {
        sb.append("null");
      } else {
        sb.append(this.jobID);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("priority:");
      if (this.priority == null) {
        sb.append("null");
      } else {
        sb.append(this.priority);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
      if (jobID != null) {
        jobID.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setJobPriority_argsStandardSchemeFactory implements SchemeFactory {
      public setJobPriority_argsStandardScheme getScheme() {
        return new setJobPriority_argsStandardScheme();
      }
    }

    private static class setJobPriority_argsStandardScheme extends StandardScheme<setJobPriority_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setJobPriority_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // JOB_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jobID = new ThriftJobID();
                struct.jobID.read(iprot);
                struct.setJobIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRIORITY
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.priority = ThriftJobPriority.findByValue(iprot.readI32());
                struct.setPriorityIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setJobPriority_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.jobID != null) {
          oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
          struct.jobID.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.priority != null) {
          oprot.writeFieldBegin(PRIORITY_FIELD_DESC);
          oprot.writeI32(struct.priority.getValue());
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setJobPriority_argsTupleSchemeFactory implements SchemeFactory {
      public setJobPriority_argsTupleScheme getScheme() {
        return new setJobPriority_argsTupleScheme();
      }
    }

    private static class setJobPriority_argsTupleScheme extends TupleScheme<setJobPriority_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setJobPriority_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetJobID()) {
          optionals.set(1);
        }
        if (struct.isSetPriority()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetJobID()) {
          struct.jobID.write(oprot);
        }
        if (struct.isSetPriority()) {
          oprot.writeI32(struct.priority.getValue());
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setJobPriority_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jobID = new ThriftJobID();
          struct.jobID.read(iprot);
          struct.setJobIDIsSet(true);
        }
        if (incoming.get(2)) {
          struct.priority = ThriftJobPriority.findByValue(iprot.readI32());
          struct.setPriorityIsSet(true);
        }
      }
    }

  }

  public static class setJobPriority_result implements org.apache.thrift.TBase<setJobPriority_result, setJobPriority_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setJobPriority_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField JNE_FIELD_DESC = new org.apache.thrift.protocol.TField("jne", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setJobPriority_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setJobPriority_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required
    public JobNotFoundException jne; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err"),
      JNE((short)2, "jne");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          case 2: // JNE
            return JNE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.JNE, new org.apache.thrift.meta_data.FieldMetaData("jne", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setJobPriority_result.class, metaDataMap);
    }

    public setJobPriority_result() {
    }

    public setJobPriority_result(
      org.apache.hadoop.thriftfs.api.IOException err,
      JobNotFoundException jne)
    {
      this();
      this.err = err;
      this.jne = jne;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setJobPriority_result(setJobPriority_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
      if (other.isSetJne()) {
        this.jne = new JobNotFoundException(other.jne);
      }
    }

    public setJobPriority_result deepCopy() {
      return new setJobPriority_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
      this.jne = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public setJobPriority_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public JobNotFoundException getJne() {
      return this.jne;
    }

    public setJobPriority_result setJne(JobNotFoundException jne) {
      this.jne = jne;
      return this;
    }

    public void unsetJne() {
      this.jne = null;
    }

    /** Returns true if field jne is set (has been assigned a value) and false otherwise */
    public boolean isSetJne() {
      return this.jne != null;
    }

    public void setJneIsSet(boolean value) {
      if (!value) {
        this.jne = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      case JNE:
        if (value == null) {
          unsetJne();
        } else {
          setJne((JobNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      case JNE:
        return getJne();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      case JNE:
        return isSetJne();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setJobPriority_result)
        return this.equals((setJobPriority_result)that);
      return false;
    }

    public boolean equals(setJobPriority_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      boolean this_present_jne = true && this.isSetJne();
      boolean that_present_jne = true && that.isSetJne();
      if (this_present_jne || that_present_jne) {
        if (!(this_present_jne && that_present_jne))
          return false;
        if (!this.jne.equals(that.jne))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(setJobPriority_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      setJobPriority_result typedOther = (setJobPriority_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetJne()).compareTo(typedOther.isSetJne());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetJne()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.jne, typedOther.jne);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setJobPriority_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("jne:");
      if (this.jne == null) {
        sb.append("null");
      } else {
        sb.append(this.jne);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setJobPriority_resultStandardSchemeFactory implements SchemeFactory {
      public setJobPriority_resultStandardScheme getScheme() {
        return new setJobPriority_resultStandardScheme();
      }
    }

    private static class setJobPriority_resultStandardScheme extends StandardScheme<setJobPriority_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setJobPriority_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // JNE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.jne = new JobNotFoundException();
                struct.jne.read(iprot);
                struct.setJneIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setJobPriority_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.jne != null) {
          oprot.writeFieldBegin(JNE_FIELD_DESC);
          struct.jne.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setJobPriority_resultTupleSchemeFactory implements SchemeFactory {
      public setJobPriority_resultTupleScheme getScheme() {
        return new setJobPriority_resultTupleScheme();
      }
    }

    private static class setJobPriority_resultTupleScheme extends TupleScheme<setJobPriority_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setJobPriority_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        if (struct.isSetJne()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
        if (struct.isSetJne()) {
          struct.jne.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setJobPriority_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
        if (incoming.get(1)) {
          struct.jne = new JobNotFoundException();
          struct.jne.read(iprot);
          struct.setJneIsSet(true);
        }
      }
    }

  }

  public static class getDelegationToken_args implements org.apache.thrift.TBase<getDelegationToken_args, getDelegationToken_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDelegationToken_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField RENEWER_FIELD_DESC = new org.apache.thrift.protocol.TField("renewer", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDelegationToken_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDelegationToken_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public String renewer; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      RENEWER((short)1, "renewer");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // RENEWER
            return RENEWER;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.RENEWER, new org.apache.thrift.meta_data.FieldMetaData("renewer", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDelegationToken_args.class, metaDataMap);
    }

    public getDelegationToken_args() {
    }

    public getDelegationToken_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String renewer)
    {
      this();
      this.ctx = ctx;
      this.renewer = renewer;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDelegationToken_args(getDelegationToken_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetRenewer()) {
        this.renewer = other.renewer;
      }
    }

    public getDelegationToken_args deepCopy() {
      return new getDelegationToken_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.renewer = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getDelegationToken_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public String getRenewer() {
      return this.renewer;
    }

    public getDelegationToken_args setRenewer(String renewer) {
      this.renewer = renewer;
      return this;
    }

    public void unsetRenewer() {
      this.renewer = null;
    }

    /** Returns true if field renewer is set (has been assigned a value) and false otherwise */
    public boolean isSetRenewer() {
      return this.renewer != null;
    }

    public void setRenewerIsSet(boolean value) {
      if (!value) {
        this.renewer = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case RENEWER:
        if (value == null) {
          unsetRenewer();
        } else {
          setRenewer((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case RENEWER:
        return getRenewer();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case RENEWER:
        return isSetRenewer();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDelegationToken_args)
        return this.equals((getDelegationToken_args)that);
      return false;
    }

    public boolean equals(getDelegationToken_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_renewer = true && this.isSetRenewer();
      boolean that_present_renewer = true && that.isSetRenewer();
      if (this_present_renewer || that_present_renewer) {
        if (!(this_present_renewer && that_present_renewer))
          return false;
        if (!this.renewer.equals(that.renewer))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getDelegationToken_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getDelegationToken_args typedOther = (getDelegationToken_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRenewer()).compareTo(typedOther.isSetRenewer());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRenewer()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.renewer, typedOther.renewer);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDelegationToken_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("renewer:");
      if (this.renewer == null) {
        sb.append("null");
      } else {
        sb.append(this.renewer);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDelegationToken_argsStandardSchemeFactory implements SchemeFactory {
      public getDelegationToken_argsStandardScheme getScheme() {
        return new getDelegationToken_argsStandardScheme();
      }
    }

    private static class getDelegationToken_argsStandardScheme extends StandardScheme<getDelegationToken_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDelegationToken_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // RENEWER
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.renewer = iprot.readString();
                struct.setRenewerIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDelegationToken_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.renewer != null) {
          oprot.writeFieldBegin(RENEWER_FIELD_DESC);
          oprot.writeString(struct.renewer);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDelegationToken_argsTupleSchemeFactory implements SchemeFactory {
      public getDelegationToken_argsTupleScheme getScheme() {
        return new getDelegationToken_argsTupleScheme();
      }
    }

    private static class getDelegationToken_argsTupleScheme extends TupleScheme<getDelegationToken_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDelegationToken_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetRenewer()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetRenewer()) {
          oprot.writeString(struct.renewer);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDelegationToken_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.renewer = iprot.readString();
          struct.setRenewerIsSet(true);
        }
      }
    }

  }

  public static class getDelegationToken_result implements org.apache.thrift.TBase<getDelegationToken_result, getDelegationToken_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDelegationToken_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDelegationToken_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDelegationToken_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.ThriftDelegationToken.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDelegationToken_result.class, metaDataMap);
    }

    public getDelegationToken_result() {
    }

    public getDelegationToken_result(
      org.apache.hadoop.thriftfs.api.ThriftDelegationToken success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDelegationToken_result(getDelegationToken_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.hadoop.thriftfs.api.ThriftDelegationToken(other.success);
      }
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public getDelegationToken_result deepCopy() {
      return new getDelegationToken_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken getSuccess() {
      return this.success;
    }

    public getDelegationToken_result setSuccess(org.apache.hadoop.thriftfs.api.ThriftDelegationToken success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public getDelegationToken_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.hadoop.thriftfs.api.ThriftDelegationToken)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDelegationToken_result)
        return this.equals((getDelegationToken_result)that);
      return false;
    }

    public boolean equals(getDelegationToken_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getDelegationToken_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getDelegationToken_result typedOther = (getDelegationToken_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDelegationToken_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDelegationToken_resultStandardSchemeFactory implements SchemeFactory {
      public getDelegationToken_resultStandardScheme getScheme() {
        return new getDelegationToken_resultStandardScheme();
      }
    }

    private static class getDelegationToken_resultStandardScheme extends StandardScheme<getDelegationToken_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDelegationToken_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.hadoop.thriftfs.api.ThriftDelegationToken();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDelegationToken_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDelegationToken_resultTupleSchemeFactory implements SchemeFactory {
      public getDelegationToken_resultTupleScheme getScheme() {
        return new getDelegationToken_resultTupleScheme();
      }
    }

    private static class getDelegationToken_resultTupleScheme extends TupleScheme<getDelegationToken_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDelegationToken_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDelegationToken_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new org.apache.hadoop.thriftfs.api.ThriftDelegationToken();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

}
