/**
 * Autogenerated by Thrift Compiler (0.9.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.hadoop.thriftfs.api;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namenode {

  /**
   * Provides an interface to a Hadoop Namenode. It is basically a Thrift
   * translation of org.apache.hadoop.hdfs.protocol.ClientProtocol.
   */
  public interface Iface extends org.apache.hadoop.thriftfs.api.HadoopServiceBase.Iface {

    /**
     * Set permissions of an existing file or directory.
     * 
     * @param ctx
     * @param path Path of the file or directory.
     * 
     * @param perms New permissions for the file or directory.
     */
    public void chmod(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Set owner of a file or directory.
     * 
     * If either parameter 'owner' or 'group' is set to null, that
     * parameter is left unchanged.
     * 
     * Parameters 'owner' and 'group' cannot be both null.
     * 
     * @param ctx
     * @param path Path to the file or directory
     * 
     * @param owner New owner.
     * 
     * @param group New group.
     */
    public void chown(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String owner, String group) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Return a list containing:
     *   (index 0) The total storage capacity of the file system (in bytes).
     *   (index 1) The total used space of the file system (in bytes).
     *   (index 2) The available storage of the file system (in bytes).
     * 
     * @param ctx
     */
    public List<Long> df(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException;

    /**
     * Enter safe mode.
     * 
     * @param ctx
     */
    public void enterSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Get a list of all blocks containing a region of a file
     * 
     * @param ctx
     * @param path Path to the file.
     * 
     * @param offset Offset of the region.
     * 
     * @param length Length of the region
     */
    public List<Block> getBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long offset, long length) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Get the preferred block size for the given file.
     * 
     * The path must exist, or common.IOException is thrown.
     * 
     * @param ctx
     * @param path Path to the file.
     */
    public long getPreferredBlockSize(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Returns whether HDFS is in safe mode or not.
     * 
     * @param ctx
     */
    public boolean isInSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Leave safe mode.
     * 
     * @param ctx
     */
    public void leaveSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Get a listing of the indicated directory.
     * 
     * @param ctx
     * @param path Path to the directory.
     */
    public List<Stat> ls(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Create a directory (or hierarchy of directories).
     * 
     * Returns false if directory did not exist and could not be created,
     * true otherwise.
     * 
     * @param ctx
     * @param path Path to the directory.
     * 
     * @param perms Access permissions of the directory.
     */
    public boolean mkdirhier(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Tells the name node to reread the hosts and exclude files.
     * 
     * @param ctx
     */
    public void refreshNodes(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Rename an item in the file system namespace.
     * 
     * Returns true  if successful, or
     *         false if the old name does not exist or if the new name already
     *               belongs to the namespace.
     * 
     * @param ctx
     * @param path Path to existing file or directory.
     * 
     * @param newPath New path.
     */
    public boolean rename(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String newPath) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Report corrupted blocks.
     * 
     * @param ctx
     * @param blocks List of corrupted blocks.
     */
    public void reportBadBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<Block> blocks) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Get information about a path in HDFS.
     * 
     * Return value will be nul if path does not exist.
     * 
     * @param ctx
     * @param path Path of the file or directory.
     */
    public Stat stat(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Get the summary of a directory's contents.
     * 
     * Note that this has runtime linear in the total number of nodes
     * in the directory tree - this can be expensive for directories
     * near the top of a big HDFS. Use with care.
     * 
     * @param ctx
     * @param Path
     */
    public ContentSummary getContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, String Path) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Get ContentSummary objects for multiple directories simultaneously. The same warnings
     * apply as for getContentSummary(...) above.
     * 
     * @param ctx
     * @param paths
     */
    public List<ContentSummary> multiGetContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<String> paths) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Set the quota for a directory.
     * 
     * Quota parameters may have three types of values:
     * 
     *    (1) 0 or more:      Quota will be set to that value.
     *    (2) QUOTA_DONT_SET: Quota will not be changed,
     *    (3) QUOTA_RESET:    Quota will be reset.
     * 
     * Any other value is a runtime error.
     * 
     * @param ctx
     * @param path Path of the directory.
     * 
     * @param namespaceQuota Limit on the number of names in the directory.
     * 
     * @param diskspaceQuota Limit on disk space occupied by all the files in the
     * directory.
     */
    public void setQuota(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long namespaceQuota, long diskspaceQuota) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Set replication factor for an existing file.
     * 
     * This call just updates the value of the replication factor. The actual
     * block replication is not expected to be performed during this method call.
     * The blocks will be populated or removed in the background as the result of
     * the routine block maintenance procedures.
     * 
     * Returns true if successful, false if file does not exist or is a
     * directory.
     * 
     * @param ctx
     * @param path Path of the file.
     * 
     * @param replication New replication factor.
     */
    public boolean setReplication(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short replication) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Delete a file or directory from the file system.
     * 
     * Any blocks belonging to the deleted files will be garbage-collected.
     * 
     * @param ctx
     * @param path Path of the file or directory.
     * 
     * @param recursive Delete a non-empty directory recursively.
     */
    public boolean unlink(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, boolean recursive) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Sets the modification and access time of a file or directory.
     * 
     * Setting *one single time paramater* to -1 means that time parameter
     * must not be set by this call.
     * 
     * Setting *both time parameters* to -1 means both of them must be set to
     * the current time.
     * 
     * @param ctx
     * @param path Path of the file or directory.
     * 
     * @param atime Access time in milliseconds since 1970-01-01 00:00 UTC
     * 
     * @param mtime Modification time in milliseconds since 1970-01-01 00:00 UTC
     */
    public void utime(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long atime, long mtime) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

    /**
     * Inform the namenode that a datanode process has started.
     * 
     * @param name <host name>:<port number> of the datanode
     * 
     * @param storage the storage id of the datanode
     * 
     * @param thriftPort Thrift port of the datanode
     */
    public void datanodeUp(String name, String storage, int thriftPort) throws org.apache.thrift.TException;

    /**
     * Inform the namenode that a datanode process has stopped.
     * 
     * @param name <host name>:<port number> of the datanode
     * 
     * @param storage the storage id of the datanode
     * 
     * @param thriftPort Thrift port of the datanode
     */
    public void datanodeDown(String name, String storage, int thriftPort) throws org.apache.thrift.TException;

    /**
     * Get an HDFS delegation token.
     * 
     * @param ctx
     * @param renewer
     */
    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException;

  }

  public interface AsyncIface extends org.apache.hadoop.thriftfs.api.HadoopServiceBase .AsyncIface {

    public void chmod(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.chmod_call> resultHandler) throws org.apache.thrift.TException;

    public void chown(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String owner, String group, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.chown_call> resultHandler) throws org.apache.thrift.TException;

    public void df(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.df_call> resultHandler) throws org.apache.thrift.TException;

    public void enterSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.enterSafeMode_call> resultHandler) throws org.apache.thrift.TException;

    public void getBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long offset, long length, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getBlocks_call> resultHandler) throws org.apache.thrift.TException;

    public void getPreferredBlockSize(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getPreferredBlockSize_call> resultHandler) throws org.apache.thrift.TException;

    public void isInSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.isInSafeMode_call> resultHandler) throws org.apache.thrift.TException;

    public void leaveSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.leaveSafeMode_call> resultHandler) throws org.apache.thrift.TException;

    public void ls(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.ls_call> resultHandler) throws org.apache.thrift.TException;

    public void mkdirhier(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.mkdirhier_call> resultHandler) throws org.apache.thrift.TException;

    public void refreshNodes(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.refreshNodes_call> resultHandler) throws org.apache.thrift.TException;

    public void rename(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String newPath, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.rename_call> resultHandler) throws org.apache.thrift.TException;

    public void reportBadBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<Block> blocks, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.reportBadBlocks_call> resultHandler) throws org.apache.thrift.TException;

    public void stat(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.stat_call> resultHandler) throws org.apache.thrift.TException;

    public void getContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, String Path, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getContentSummary_call> resultHandler) throws org.apache.thrift.TException;

    public void multiGetContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<String> paths, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.multiGetContentSummary_call> resultHandler) throws org.apache.thrift.TException;

    public void setQuota(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long namespaceQuota, long diskspaceQuota, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.setQuota_call> resultHandler) throws org.apache.thrift.TException;

    public void setReplication(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short replication, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.setReplication_call> resultHandler) throws org.apache.thrift.TException;

    public void unlink(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.unlink_call> resultHandler) throws org.apache.thrift.TException;

    public void utime(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long atime, long mtime, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.utime_call> resultHandler) throws org.apache.thrift.TException;

    public void datanodeUp(String name, String storage, int thriftPort, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.datanodeUp_call> resultHandler) throws org.apache.thrift.TException;

    public void datanodeDown(String name, String storage, int thriftPort, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.datanodeDown_call> resultHandler) throws org.apache.thrift.TException;

    public void getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getDelegationToken_call> resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.hadoop.thriftfs.api.HadoopServiceBase.Client implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public void chmod(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_chmod(ctx, path, perms);
      recv_chmod();
    }

    public void send_chmod(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms) throws org.apache.thrift.TException
    {
      chmod_args args = new chmod_args();
      args.setCtx(ctx);
      args.setPath(path);
      args.setPerms(perms);
      sendBase("chmod", args);
    }

    public void recv_chmod() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      chmod_result result = new chmod_result();
      receiveBase(result, "chmod");
      if (result.err != null) {
        throw result.err;
      }
      return;
    }

    public void chown(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String owner, String group) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_chown(ctx, path, owner, group);
      recv_chown();
    }

    public void send_chown(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String owner, String group) throws org.apache.thrift.TException
    {
      chown_args args = new chown_args();
      args.setCtx(ctx);
      args.setPath(path);
      args.setOwner(owner);
      args.setGroup(group);
      sendBase("chown", args);
    }

    public void recv_chown() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      chown_result result = new chown_result();
      receiveBase(result, "chown");
      if (result.err != null) {
        throw result.err;
      }
      return;
    }

    public List<Long> df(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      send_df(ctx);
      return recv_df();
    }

    public void send_df(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      df_args args = new df_args();
      args.setCtx(ctx);
      sendBase("df", args);
    }

    public List<Long> recv_df() throws org.apache.thrift.TException
    {
      df_result result = new df_result();
      receiveBase(result, "df");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "df failed: unknown result");
    }

    public void enterSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_enterSafeMode(ctx);
      recv_enterSafeMode();
    }

    public void send_enterSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      enterSafeMode_args args = new enterSafeMode_args();
      args.setCtx(ctx);
      sendBase("enterSafeMode", args);
    }

    public void recv_enterSafeMode() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      enterSafeMode_result result = new enterSafeMode_result();
      receiveBase(result, "enterSafeMode");
      if (result.err != null) {
        throw result.err;
      }
      return;
    }

    public List<Block> getBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long offset, long length) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_getBlocks(ctx, path, offset, length);
      return recv_getBlocks();
    }

    public void send_getBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long offset, long length) throws org.apache.thrift.TException
    {
      getBlocks_args args = new getBlocks_args();
      args.setCtx(ctx);
      args.setPath(path);
      args.setOffset(offset);
      args.setLength(length);
      sendBase("getBlocks", args);
    }

    public List<Block> recv_getBlocks() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      getBlocks_result result = new getBlocks_result();
      receiveBase(result, "getBlocks");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getBlocks failed: unknown result");
    }

    public long getPreferredBlockSize(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_getPreferredBlockSize(ctx, path);
      return recv_getPreferredBlockSize();
    }

    public void send_getPreferredBlockSize(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path) throws org.apache.thrift.TException
    {
      getPreferredBlockSize_args args = new getPreferredBlockSize_args();
      args.setCtx(ctx);
      args.setPath(path);
      sendBase("getPreferredBlockSize", args);
    }

    public long recv_getPreferredBlockSize() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      getPreferredBlockSize_result result = new getPreferredBlockSize_result();
      receiveBase(result, "getPreferredBlockSize");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getPreferredBlockSize failed: unknown result");
    }

    public boolean isInSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_isInSafeMode(ctx);
      return recv_isInSafeMode();
    }

    public void send_isInSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      isInSafeMode_args args = new isInSafeMode_args();
      args.setCtx(ctx);
      sendBase("isInSafeMode", args);
    }

    public boolean recv_isInSafeMode() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      isInSafeMode_result result = new isInSafeMode_result();
      receiveBase(result, "isInSafeMode");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isInSafeMode failed: unknown result");
    }

    public void leaveSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_leaveSafeMode(ctx);
      recv_leaveSafeMode();
    }

    public void send_leaveSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      leaveSafeMode_args args = new leaveSafeMode_args();
      args.setCtx(ctx);
      sendBase("leaveSafeMode", args);
    }

    public void recv_leaveSafeMode() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      leaveSafeMode_result result = new leaveSafeMode_result();
      receiveBase(result, "leaveSafeMode");
      if (result.err != null) {
        throw result.err;
      }
      return;
    }

    public List<Stat> ls(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_ls(ctx, path);
      return recv_ls();
    }

    public void send_ls(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path) throws org.apache.thrift.TException
    {
      ls_args args = new ls_args();
      args.setCtx(ctx);
      args.setPath(path);
      sendBase("ls", args);
    }

    public List<Stat> recv_ls() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      ls_result result = new ls_result();
      receiveBase(result, "ls");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "ls failed: unknown result");
    }

    public boolean mkdirhier(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_mkdirhier(ctx, path, perms);
      return recv_mkdirhier();
    }

    public void send_mkdirhier(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms) throws org.apache.thrift.TException
    {
      mkdirhier_args args = new mkdirhier_args();
      args.setCtx(ctx);
      args.setPath(path);
      args.setPerms(perms);
      sendBase("mkdirhier", args);
    }

    public boolean recv_mkdirhier() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      mkdirhier_result result = new mkdirhier_result();
      receiveBase(result, "mkdirhier");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "mkdirhier failed: unknown result");
    }

    public void refreshNodes(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_refreshNodes(ctx);
      recv_refreshNodes();
    }

    public void send_refreshNodes(org.apache.hadoop.thriftfs.api.RequestContext ctx) throws org.apache.thrift.TException
    {
      refreshNodes_args args = new refreshNodes_args();
      args.setCtx(ctx);
      sendBase("refreshNodes", args);
    }

    public void recv_refreshNodes() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      refreshNodes_result result = new refreshNodes_result();
      receiveBase(result, "refreshNodes");
      if (result.err != null) {
        throw result.err;
      }
      return;
    }

    public boolean rename(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String newPath) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_rename(ctx, path, newPath);
      return recv_rename();
    }

    public void send_rename(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String newPath) throws org.apache.thrift.TException
    {
      rename_args args = new rename_args();
      args.setCtx(ctx);
      args.setPath(path);
      args.setNewPath(newPath);
      sendBase("rename", args);
    }

    public boolean recv_rename() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      rename_result result = new rename_result();
      receiveBase(result, "rename");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "rename failed: unknown result");
    }

    public void reportBadBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<Block> blocks) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_reportBadBlocks(ctx, blocks);
      recv_reportBadBlocks();
    }

    public void send_reportBadBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<Block> blocks) throws org.apache.thrift.TException
    {
      reportBadBlocks_args args = new reportBadBlocks_args();
      args.setCtx(ctx);
      args.setBlocks(blocks);
      sendBase("reportBadBlocks", args);
    }

    public void recv_reportBadBlocks() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      reportBadBlocks_result result = new reportBadBlocks_result();
      receiveBase(result, "reportBadBlocks");
      if (result.err != null) {
        throw result.err;
      }
      return;
    }

    public Stat stat(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_stat(ctx, path);
      return recv_stat();
    }

    public void send_stat(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path) throws org.apache.thrift.TException
    {
      stat_args args = new stat_args();
      args.setCtx(ctx);
      args.setPath(path);
      sendBase("stat", args);
    }

    public Stat recv_stat() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      stat_result result = new stat_result();
      receiveBase(result, "stat");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "stat failed: unknown result");
    }

    public ContentSummary getContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, String Path) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_getContentSummary(ctx, Path);
      return recv_getContentSummary();
    }

    public void send_getContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, String Path) throws org.apache.thrift.TException
    {
      getContentSummary_args args = new getContentSummary_args();
      args.setCtx(ctx);
      args.setPath(Path);
      sendBase("getContentSummary", args);
    }

    public ContentSummary recv_getContentSummary() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      getContentSummary_result result = new getContentSummary_result();
      receiveBase(result, "getContentSummary");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getContentSummary failed: unknown result");
    }

    public List<ContentSummary> multiGetContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<String> paths) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_multiGetContentSummary(ctx, paths);
      return recv_multiGetContentSummary();
    }

    public void send_multiGetContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<String> paths) throws org.apache.thrift.TException
    {
      multiGetContentSummary_args args = new multiGetContentSummary_args();
      args.setCtx(ctx);
      args.setPaths(paths);
      sendBase("multiGetContentSummary", args);
    }

    public List<ContentSummary> recv_multiGetContentSummary() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      multiGetContentSummary_result result = new multiGetContentSummary_result();
      receiveBase(result, "multiGetContentSummary");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "multiGetContentSummary failed: unknown result");
    }

    public void setQuota(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long namespaceQuota, long diskspaceQuota) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_setQuota(ctx, path, namespaceQuota, diskspaceQuota);
      recv_setQuota();
    }

    public void send_setQuota(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long namespaceQuota, long diskspaceQuota) throws org.apache.thrift.TException
    {
      setQuota_args args = new setQuota_args();
      args.setCtx(ctx);
      args.setPath(path);
      args.setNamespaceQuota(namespaceQuota);
      args.setDiskspaceQuota(diskspaceQuota);
      sendBase("setQuota", args);
    }

    public void recv_setQuota() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      setQuota_result result = new setQuota_result();
      receiveBase(result, "setQuota");
      if (result.err != null) {
        throw result.err;
      }
      return;
    }

    public boolean setReplication(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short replication) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_setReplication(ctx, path, replication);
      return recv_setReplication();
    }

    public void send_setReplication(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short replication) throws org.apache.thrift.TException
    {
      setReplication_args args = new setReplication_args();
      args.setCtx(ctx);
      args.setPath(path);
      args.setReplication(replication);
      sendBase("setReplication", args);
    }

    public boolean recv_setReplication() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      setReplication_result result = new setReplication_result();
      receiveBase(result, "setReplication");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "setReplication failed: unknown result");
    }

    public boolean unlink(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, boolean recursive) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_unlink(ctx, path, recursive);
      return recv_unlink();
    }

    public void send_unlink(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, boolean recursive) throws org.apache.thrift.TException
    {
      unlink_args args = new unlink_args();
      args.setCtx(ctx);
      args.setPath(path);
      args.setRecursive(recursive);
      sendBase("unlink", args);
    }

    public boolean recv_unlink() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      unlink_result result = new unlink_result();
      receiveBase(result, "unlink");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "unlink failed: unknown result");
    }

    public void utime(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long atime, long mtime) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_utime(ctx, path, atime, mtime);
      recv_utime();
    }

    public void send_utime(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long atime, long mtime) throws org.apache.thrift.TException
    {
      utime_args args = new utime_args();
      args.setCtx(ctx);
      args.setPath(path);
      args.setAtime(atime);
      args.setMtime(mtime);
      sendBase("utime", args);
    }

    public void recv_utime() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      utime_result result = new utime_result();
      receiveBase(result, "utime");
      if (result.err != null) {
        throw result.err;
      }
      return;
    }

    public void datanodeUp(String name, String storage, int thriftPort) throws org.apache.thrift.TException
    {
      send_datanodeUp(name, storage, thriftPort);
      recv_datanodeUp();
    }

    public void send_datanodeUp(String name, String storage, int thriftPort) throws org.apache.thrift.TException
    {
      datanodeUp_args args = new datanodeUp_args();
      args.setName(name);
      args.setStorage(storage);
      args.setThriftPort(thriftPort);
      sendBase("datanodeUp", args);
    }

    public void recv_datanodeUp() throws org.apache.thrift.TException
    {
      datanodeUp_result result = new datanodeUp_result();
      receiveBase(result, "datanodeUp");
      return;
    }

    public void datanodeDown(String name, String storage, int thriftPort) throws org.apache.thrift.TException
    {
      send_datanodeDown(name, storage, thriftPort);
      recv_datanodeDown();
    }

    public void send_datanodeDown(String name, String storage, int thriftPort) throws org.apache.thrift.TException
    {
      datanodeDown_args args = new datanodeDown_args();
      args.setName(name);
      args.setStorage(storage);
      args.setThriftPort(thriftPort);
      sendBase("datanodeDown", args);
    }

    public void recv_datanodeDown() throws org.apache.thrift.TException
    {
      datanodeDown_result result = new datanodeDown_result();
      receiveBase(result, "datanodeDown");
      return;
    }

    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer) throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      send_getDelegationToken(ctx, renewer);
      return recv_getDelegationToken();
    }

    public void send_getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer) throws org.apache.thrift.TException
    {
      getDelegationToken_args args = new getDelegationToken_args();
      args.setCtx(ctx);
      args.setRenewer(renewer);
      sendBase("getDelegationToken", args);
    }

    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken recv_getDelegationToken() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException
    {
      getDelegationToken_result result = new getDelegationToken_result();
      receiveBase(result, "getDelegationToken");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.err != null) {
        throw result.err;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDelegationToken failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.hadoop.thriftfs.api.HadoopServiceBase.AsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void chmod(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms, org.apache.thrift.async.AsyncMethodCallback<chmod_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      chmod_call method_call = new chmod_call(ctx, path, perms, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class chmod_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      private short perms;
      public chmod_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms, org.apache.thrift.async.AsyncMethodCallback<chmod_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
        this.perms = perms;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("chmod", org.apache.thrift.protocol.TMessageType.CALL, 0));
        chmod_args args = new chmod_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.setPerms(perms);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_chmod();
      }
    }

    public void chown(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String owner, String group, org.apache.thrift.async.AsyncMethodCallback<chown_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      chown_call method_call = new chown_call(ctx, path, owner, group, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class chown_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      private String owner;
      private String group;
      public chown_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String owner, String group, org.apache.thrift.async.AsyncMethodCallback<chown_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
        this.owner = owner;
        this.group = group;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("chown", org.apache.thrift.protocol.TMessageType.CALL, 0));
        chown_args args = new chown_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.setOwner(owner);
        args.setGroup(group);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_chown();
      }
    }

    public void df(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<df_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      df_call method_call = new df_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class df_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public df_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<df_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("df", org.apache.thrift.protocol.TMessageType.CALL, 0));
        df_args args = new df_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<Long> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_df();
      }
    }

    public void enterSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<enterSafeMode_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      enterSafeMode_call method_call = new enterSafeMode_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class enterSafeMode_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public enterSafeMode_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<enterSafeMode_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("enterSafeMode", org.apache.thrift.protocol.TMessageType.CALL, 0));
        enterSafeMode_args args = new enterSafeMode_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_enterSafeMode();
      }
    }

    public void getBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long offset, long length, org.apache.thrift.async.AsyncMethodCallback<getBlocks_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getBlocks_call method_call = new getBlocks_call(ctx, path, offset, length, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getBlocks_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      private long offset;
      private long length;
      public getBlocks_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long offset, long length, org.apache.thrift.async.AsyncMethodCallback<getBlocks_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
        this.offset = offset;
        this.length = length;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getBlocks", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getBlocks_args args = new getBlocks_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.setOffset(offset);
        args.setLength(length);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<Block> getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getBlocks();
      }
    }

    public void getPreferredBlockSize(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, org.apache.thrift.async.AsyncMethodCallback<getPreferredBlockSize_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getPreferredBlockSize_call method_call = new getPreferredBlockSize_call(ctx, path, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getPreferredBlockSize_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      public getPreferredBlockSize_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, org.apache.thrift.async.AsyncMethodCallback<getPreferredBlockSize_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getPreferredBlockSize", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getPreferredBlockSize_args args = new getPreferredBlockSize_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public long getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getPreferredBlockSize();
      }
    }

    public void isInSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<isInSafeMode_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isInSafeMode_call method_call = new isInSafeMode_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isInSafeMode_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public isInSafeMode_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<isInSafeMode_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isInSafeMode", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isInSafeMode_args args = new isInSafeMode_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isInSafeMode();
      }
    }

    public void leaveSafeMode(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<leaveSafeMode_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      leaveSafeMode_call method_call = new leaveSafeMode_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class leaveSafeMode_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public leaveSafeMode_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<leaveSafeMode_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("leaveSafeMode", org.apache.thrift.protocol.TMessageType.CALL, 0));
        leaveSafeMode_args args = new leaveSafeMode_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_leaveSafeMode();
      }
    }

    public void ls(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, org.apache.thrift.async.AsyncMethodCallback<ls_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      ls_call method_call = new ls_call(ctx, path, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class ls_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      public ls_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, org.apache.thrift.async.AsyncMethodCallback<ls_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("ls", org.apache.thrift.protocol.TMessageType.CALL, 0));
        ls_args args = new ls_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<Stat> getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_ls();
      }
    }

    public void mkdirhier(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms, org.apache.thrift.async.AsyncMethodCallback<mkdirhier_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mkdirhier_call method_call = new mkdirhier_call(ctx, path, perms, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mkdirhier_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      private short perms;
      public mkdirhier_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short perms, org.apache.thrift.async.AsyncMethodCallback<mkdirhier_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
        this.perms = perms;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mkdirhier", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mkdirhier_args args = new mkdirhier_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.setPerms(perms);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_mkdirhier();
      }
    }

    public void refreshNodes(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<refreshNodes_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      refreshNodes_call method_call = new refreshNodes_call(ctx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class refreshNodes_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      public refreshNodes_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, org.apache.thrift.async.AsyncMethodCallback<refreshNodes_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("refreshNodes", org.apache.thrift.protocol.TMessageType.CALL, 0));
        refreshNodes_args args = new refreshNodes_args();
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_refreshNodes();
      }
    }

    public void rename(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String newPath, org.apache.thrift.async.AsyncMethodCallback<rename_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      rename_call method_call = new rename_call(ctx, path, newPath, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class rename_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      private String newPath;
      public rename_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, String newPath, org.apache.thrift.async.AsyncMethodCallback<rename_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
        this.newPath = newPath;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("rename", org.apache.thrift.protocol.TMessageType.CALL, 0));
        rename_args args = new rename_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.setNewPath(newPath);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_rename();
      }
    }

    public void reportBadBlocks(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<Block> blocks, org.apache.thrift.async.AsyncMethodCallback<reportBadBlocks_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      reportBadBlocks_call method_call = new reportBadBlocks_call(ctx, blocks, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class reportBadBlocks_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private List<Block> blocks;
      public reportBadBlocks_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<Block> blocks, org.apache.thrift.async.AsyncMethodCallback<reportBadBlocks_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.blocks = blocks;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("reportBadBlocks", org.apache.thrift.protocol.TMessageType.CALL, 0));
        reportBadBlocks_args args = new reportBadBlocks_args();
        args.setCtx(ctx);
        args.setBlocks(blocks);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_reportBadBlocks();
      }
    }

    public void stat(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, org.apache.thrift.async.AsyncMethodCallback<stat_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      stat_call method_call = new stat_call(ctx, path, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class stat_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      public stat_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, org.apache.thrift.async.AsyncMethodCallback<stat_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("stat", org.apache.thrift.protocol.TMessageType.CALL, 0));
        stat_args args = new stat_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Stat getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_stat();
      }
    }

    public void getContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, String Path, org.apache.thrift.async.AsyncMethodCallback<getContentSummary_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getContentSummary_call method_call = new getContentSummary_call(ctx, Path, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getContentSummary_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String Path;
      public getContentSummary_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String Path, org.apache.thrift.async.AsyncMethodCallback<getContentSummary_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.Path = Path;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getContentSummary", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getContentSummary_args args = new getContentSummary_args();
        args.setCtx(ctx);
        args.setPath(Path);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ContentSummary getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getContentSummary();
      }
    }

    public void multiGetContentSummary(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<String> paths, org.apache.thrift.async.AsyncMethodCallback<multiGetContentSummary_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      multiGetContentSummary_call method_call = new multiGetContentSummary_call(ctx, paths, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class multiGetContentSummary_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private List<String> paths;
      public multiGetContentSummary_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, List<String> paths, org.apache.thrift.async.AsyncMethodCallback<multiGetContentSummary_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.paths = paths;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("multiGetContentSummary", org.apache.thrift.protocol.TMessageType.CALL, 0));
        multiGetContentSummary_args args = new multiGetContentSummary_args();
        args.setCtx(ctx);
        args.setPaths(paths);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ContentSummary> getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_multiGetContentSummary();
      }
    }

    public void setQuota(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long namespaceQuota, long diskspaceQuota, org.apache.thrift.async.AsyncMethodCallback<setQuota_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setQuota_call method_call = new setQuota_call(ctx, path, namespaceQuota, diskspaceQuota, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setQuota_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      private long namespaceQuota;
      private long diskspaceQuota;
      public setQuota_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long namespaceQuota, long diskspaceQuota, org.apache.thrift.async.AsyncMethodCallback<setQuota_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
        this.namespaceQuota = namespaceQuota;
        this.diskspaceQuota = diskspaceQuota;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setQuota", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setQuota_args args = new setQuota_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.setNamespaceQuota(namespaceQuota);
        args.setDiskspaceQuota(diskspaceQuota);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setQuota();
      }
    }

    public void setReplication(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short replication, org.apache.thrift.async.AsyncMethodCallback<setReplication_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setReplication_call method_call = new setReplication_call(ctx, path, replication, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setReplication_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      private short replication;
      public setReplication_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, short replication, org.apache.thrift.async.AsyncMethodCallback<setReplication_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
        this.replication = replication;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setReplication", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setReplication_args args = new setReplication_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.setReplication(replication);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_setReplication();
      }
    }

    public void unlink(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback<unlink_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      unlink_call method_call = new unlink_call(ctx, path, recursive, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class unlink_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      private boolean recursive;
      public unlink_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback<unlink_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
        this.recursive = recursive;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("unlink", org.apache.thrift.protocol.TMessageType.CALL, 0));
        unlink_args args = new unlink_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.setRecursive(recursive);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_unlink();
      }
    }

    public void utime(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long atime, long mtime, org.apache.thrift.async.AsyncMethodCallback<utime_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      utime_call method_call = new utime_call(ctx, path, atime, mtime, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class utime_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String path;
      private long atime;
      private long mtime;
      public utime_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String path, long atime, long mtime, org.apache.thrift.async.AsyncMethodCallback<utime_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.path = path;
        this.atime = atime;
        this.mtime = mtime;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("utime", org.apache.thrift.protocol.TMessageType.CALL, 0));
        utime_args args = new utime_args();
        args.setCtx(ctx);
        args.setPath(path);
        args.setAtime(atime);
        args.setMtime(mtime);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_utime();
      }
    }

    public void datanodeUp(String name, String storage, int thriftPort, org.apache.thrift.async.AsyncMethodCallback<datanodeUp_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      datanodeUp_call method_call = new datanodeUp_call(name, storage, thriftPort, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class datanodeUp_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private String storage;
      private int thriftPort;
      public datanodeUp_call(String name, String storage, int thriftPort, org.apache.thrift.async.AsyncMethodCallback<datanodeUp_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.storage = storage;
        this.thriftPort = thriftPort;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("datanodeUp", org.apache.thrift.protocol.TMessageType.CALL, 0));
        datanodeUp_args args = new datanodeUp_args();
        args.setName(name);
        args.setStorage(storage);
        args.setThriftPort(thriftPort);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_datanodeUp();
      }
    }

    public void datanodeDown(String name, String storage, int thriftPort, org.apache.thrift.async.AsyncMethodCallback<datanodeDown_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      datanodeDown_call method_call = new datanodeDown_call(name, storage, thriftPort, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class datanodeDown_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String name;
      private String storage;
      private int thriftPort;
      public datanodeDown_call(String name, String storage, int thriftPort, org.apache.thrift.async.AsyncMethodCallback<datanodeDown_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
        this.storage = storage;
        this.thriftPort = thriftPort;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("datanodeDown", org.apache.thrift.protocol.TMessageType.CALL, 0));
        datanodeDown_args args = new datanodeDown_args();
        args.setName(name);
        args.setStorage(storage);
        args.setThriftPort(thriftPort);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_datanodeDown();
      }
    }

    public void getDelegationToken(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer, org.apache.thrift.async.AsyncMethodCallback<getDelegationToken_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getDelegationToken_call method_call = new getDelegationToken_call(ctx, renewer, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getDelegationToken_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.hadoop.thriftfs.api.RequestContext ctx;
      private String renewer;
      public getDelegationToken_call(org.apache.hadoop.thriftfs.api.RequestContext ctx, String renewer, org.apache.thrift.async.AsyncMethodCallback<getDelegationToken_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ctx = ctx;
        this.renewer = renewer;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getDelegationToken", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getDelegationToken_args args = new getDelegationToken_args();
        args.setCtx(ctx);
        args.setRenewer(renewer);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.hadoop.thriftfs.api.ThriftDelegationToken getResult() throws org.apache.hadoop.thriftfs.api.IOException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getDelegationToken();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.hadoop.thriftfs.api.HadoopServiceBase.Processor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("chmod", new chmod());
      processMap.put("chown", new chown());
      processMap.put("df", new df());
      processMap.put("enterSafeMode", new enterSafeMode());
      processMap.put("getBlocks", new getBlocks());
      processMap.put("getPreferredBlockSize", new getPreferredBlockSize());
      processMap.put("isInSafeMode", new isInSafeMode());
      processMap.put("leaveSafeMode", new leaveSafeMode());
      processMap.put("ls", new ls());
      processMap.put("mkdirhier", new mkdirhier());
      processMap.put("refreshNodes", new refreshNodes());
      processMap.put("rename", new rename());
      processMap.put("reportBadBlocks", new reportBadBlocks());
      processMap.put("stat", new stat());
      processMap.put("getContentSummary", new getContentSummary());
      processMap.put("multiGetContentSummary", new multiGetContentSummary());
      processMap.put("setQuota", new setQuota());
      processMap.put("setReplication", new setReplication());
      processMap.put("unlink", new unlink());
      processMap.put("utime", new utime());
      processMap.put("datanodeUp", new datanodeUp());
      processMap.put("datanodeDown", new datanodeDown());
      processMap.put("getDelegationToken", new getDelegationToken());
      return processMap;
    }

    public static class chmod<I extends Iface> extends org.apache.thrift.ProcessFunction<I, chmod_args> {
      public chmod() {
        super("chmod");
      }

      public chmod_args getEmptyArgsInstance() {
        return new chmod_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public chmod_result getResult(I iface, chmod_args args) throws org.apache.thrift.TException {
        chmod_result result = new chmod_result();
        try {
          iface.chmod(args.ctx, args.path, args.perms);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class chown<I extends Iface> extends org.apache.thrift.ProcessFunction<I, chown_args> {
      public chown() {
        super("chown");
      }

      public chown_args getEmptyArgsInstance() {
        return new chown_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public chown_result getResult(I iface, chown_args args) throws org.apache.thrift.TException {
        chown_result result = new chown_result();
        try {
          iface.chown(args.ctx, args.path, args.owner, args.group);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class df<I extends Iface> extends org.apache.thrift.ProcessFunction<I, df_args> {
      public df() {
        super("df");
      }

      public df_args getEmptyArgsInstance() {
        return new df_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public df_result getResult(I iface, df_args args) throws org.apache.thrift.TException {
        df_result result = new df_result();
        result.success = iface.df(args.ctx);
        return result;
      }
    }

    public static class enterSafeMode<I extends Iface> extends org.apache.thrift.ProcessFunction<I, enterSafeMode_args> {
      public enterSafeMode() {
        super("enterSafeMode");
      }

      public enterSafeMode_args getEmptyArgsInstance() {
        return new enterSafeMode_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public enterSafeMode_result getResult(I iface, enterSafeMode_args args) throws org.apache.thrift.TException {
        enterSafeMode_result result = new enterSafeMode_result();
        try {
          iface.enterSafeMode(args.ctx);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class getBlocks<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getBlocks_args> {
      public getBlocks() {
        super("getBlocks");
      }

      public getBlocks_args getEmptyArgsInstance() {
        return new getBlocks_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getBlocks_result getResult(I iface, getBlocks_args args) throws org.apache.thrift.TException {
        getBlocks_result result = new getBlocks_result();
        try {
          result.success = iface.getBlocks(args.ctx, args.path, args.offset, args.length);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class getPreferredBlockSize<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getPreferredBlockSize_args> {
      public getPreferredBlockSize() {
        super("getPreferredBlockSize");
      }

      public getPreferredBlockSize_args getEmptyArgsInstance() {
        return new getPreferredBlockSize_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getPreferredBlockSize_result getResult(I iface, getPreferredBlockSize_args args) throws org.apache.thrift.TException {
        getPreferredBlockSize_result result = new getPreferredBlockSize_result();
        try {
          result.success = iface.getPreferredBlockSize(args.ctx, args.path);
          result.setSuccessIsSet(true);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class isInSafeMode<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isInSafeMode_args> {
      public isInSafeMode() {
        super("isInSafeMode");
      }

      public isInSafeMode_args getEmptyArgsInstance() {
        return new isInSafeMode_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isInSafeMode_result getResult(I iface, isInSafeMode_args args) throws org.apache.thrift.TException {
        isInSafeMode_result result = new isInSafeMode_result();
        try {
          result.success = iface.isInSafeMode(args.ctx);
          result.setSuccessIsSet(true);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class leaveSafeMode<I extends Iface> extends org.apache.thrift.ProcessFunction<I, leaveSafeMode_args> {
      public leaveSafeMode() {
        super("leaveSafeMode");
      }

      public leaveSafeMode_args getEmptyArgsInstance() {
        return new leaveSafeMode_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public leaveSafeMode_result getResult(I iface, leaveSafeMode_args args) throws org.apache.thrift.TException {
        leaveSafeMode_result result = new leaveSafeMode_result();
        try {
          iface.leaveSafeMode(args.ctx);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class ls<I extends Iface> extends org.apache.thrift.ProcessFunction<I, ls_args> {
      public ls() {
        super("ls");
      }

      public ls_args getEmptyArgsInstance() {
        return new ls_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public ls_result getResult(I iface, ls_args args) throws org.apache.thrift.TException {
        ls_result result = new ls_result();
        try {
          result.success = iface.ls(args.ctx, args.path);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class mkdirhier<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mkdirhier_args> {
      public mkdirhier() {
        super("mkdirhier");
      }

      public mkdirhier_args getEmptyArgsInstance() {
        return new mkdirhier_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public mkdirhier_result getResult(I iface, mkdirhier_args args) throws org.apache.thrift.TException {
        mkdirhier_result result = new mkdirhier_result();
        try {
          result.success = iface.mkdirhier(args.ctx, args.path, args.perms);
          result.setSuccessIsSet(true);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class refreshNodes<I extends Iface> extends org.apache.thrift.ProcessFunction<I, refreshNodes_args> {
      public refreshNodes() {
        super("refreshNodes");
      }

      public refreshNodes_args getEmptyArgsInstance() {
        return new refreshNodes_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public refreshNodes_result getResult(I iface, refreshNodes_args args) throws org.apache.thrift.TException {
        refreshNodes_result result = new refreshNodes_result();
        try {
          iface.refreshNodes(args.ctx);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class rename<I extends Iface> extends org.apache.thrift.ProcessFunction<I, rename_args> {
      public rename() {
        super("rename");
      }

      public rename_args getEmptyArgsInstance() {
        return new rename_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public rename_result getResult(I iface, rename_args args) throws org.apache.thrift.TException {
        rename_result result = new rename_result();
        try {
          result.success = iface.rename(args.ctx, args.path, args.newPath);
          result.setSuccessIsSet(true);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class reportBadBlocks<I extends Iface> extends org.apache.thrift.ProcessFunction<I, reportBadBlocks_args> {
      public reportBadBlocks() {
        super("reportBadBlocks");
      }

      public reportBadBlocks_args getEmptyArgsInstance() {
        return new reportBadBlocks_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public reportBadBlocks_result getResult(I iface, reportBadBlocks_args args) throws org.apache.thrift.TException {
        reportBadBlocks_result result = new reportBadBlocks_result();
        try {
          iface.reportBadBlocks(args.ctx, args.blocks);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class stat<I extends Iface> extends org.apache.thrift.ProcessFunction<I, stat_args> {
      public stat() {
        super("stat");
      }

      public stat_args getEmptyArgsInstance() {
        return new stat_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public stat_result getResult(I iface, stat_args args) throws org.apache.thrift.TException {
        stat_result result = new stat_result();
        try {
          result.success = iface.stat(args.ctx, args.path);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class getContentSummary<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getContentSummary_args> {
      public getContentSummary() {
        super("getContentSummary");
      }

      public getContentSummary_args getEmptyArgsInstance() {
        return new getContentSummary_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getContentSummary_result getResult(I iface, getContentSummary_args args) throws org.apache.thrift.TException {
        getContentSummary_result result = new getContentSummary_result();
        try {
          result.success = iface.getContentSummary(args.ctx, args.Path);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class multiGetContentSummary<I extends Iface> extends org.apache.thrift.ProcessFunction<I, multiGetContentSummary_args> {
      public multiGetContentSummary() {
        super("multiGetContentSummary");
      }

      public multiGetContentSummary_args getEmptyArgsInstance() {
        return new multiGetContentSummary_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public multiGetContentSummary_result getResult(I iface, multiGetContentSummary_args args) throws org.apache.thrift.TException {
        multiGetContentSummary_result result = new multiGetContentSummary_result();
        try {
          result.success = iface.multiGetContentSummary(args.ctx, args.paths);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class setQuota<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setQuota_args> {
      public setQuota() {
        super("setQuota");
      }

      public setQuota_args getEmptyArgsInstance() {
        return new setQuota_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setQuota_result getResult(I iface, setQuota_args args) throws org.apache.thrift.TException {
        setQuota_result result = new setQuota_result();
        try {
          iface.setQuota(args.ctx, args.path, args.namespaceQuota, args.diskspaceQuota);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class setReplication<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setReplication_args> {
      public setReplication() {
        super("setReplication");
      }

      public setReplication_args getEmptyArgsInstance() {
        return new setReplication_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setReplication_result getResult(I iface, setReplication_args args) throws org.apache.thrift.TException {
        setReplication_result result = new setReplication_result();
        try {
          result.success = iface.setReplication(args.ctx, args.path, args.replication);
          result.setSuccessIsSet(true);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class unlink<I extends Iface> extends org.apache.thrift.ProcessFunction<I, unlink_args> {
      public unlink() {
        super("unlink");
      }

      public unlink_args getEmptyArgsInstance() {
        return new unlink_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public unlink_result getResult(I iface, unlink_args args) throws org.apache.thrift.TException {
        unlink_result result = new unlink_result();
        try {
          result.success = iface.unlink(args.ctx, args.path, args.recursive);
          result.setSuccessIsSet(true);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class utime<I extends Iface> extends org.apache.thrift.ProcessFunction<I, utime_args> {
      public utime() {
        super("utime");
      }

      public utime_args getEmptyArgsInstance() {
        return new utime_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public utime_result getResult(I iface, utime_args args) throws org.apache.thrift.TException {
        utime_result result = new utime_result();
        try {
          iface.utime(args.ctx, args.path, args.atime, args.mtime);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

    public static class datanodeUp<I extends Iface> extends org.apache.thrift.ProcessFunction<I, datanodeUp_args> {
      public datanodeUp() {
        super("datanodeUp");
      }

      public datanodeUp_args getEmptyArgsInstance() {
        return new datanodeUp_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public datanodeUp_result getResult(I iface, datanodeUp_args args) throws org.apache.thrift.TException {
        datanodeUp_result result = new datanodeUp_result();
        iface.datanodeUp(args.name, args.storage, args.thriftPort);
        return result;
      }
    }

    public static class datanodeDown<I extends Iface> extends org.apache.thrift.ProcessFunction<I, datanodeDown_args> {
      public datanodeDown() {
        super("datanodeDown");
      }

      public datanodeDown_args getEmptyArgsInstance() {
        return new datanodeDown_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public datanodeDown_result getResult(I iface, datanodeDown_args args) throws org.apache.thrift.TException {
        datanodeDown_result result = new datanodeDown_result();
        iface.datanodeDown(args.name, args.storage, args.thriftPort);
        return result;
      }
    }

    public static class getDelegationToken<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getDelegationToken_args> {
      public getDelegationToken() {
        super("getDelegationToken");
      }

      public getDelegationToken_args getEmptyArgsInstance() {
        return new getDelegationToken_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getDelegationToken_result getResult(I iface, getDelegationToken_args args) throws org.apache.thrift.TException {
        getDelegationToken_result result = new getDelegationToken_result();
        try {
          result.success = iface.getDelegationToken(args.ctx, args.renewer);
        } catch (org.apache.hadoop.thriftfs.api.IOException err) {
          result.err = err;
        }
        return result;
      }
    }

  }

  public static class chmod_args implements org.apache.thrift.TBase<chmod_args, chmod_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("chmod_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField PERMS_FIELD_DESC = new org.apache.thrift.protocol.TField("perms", org.apache.thrift.protocol.TType.I16, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new chmod_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new chmod_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path of the file or directory.
     */
    public String path; // required
    /**
     * New permissions for the file or directory.
     */
    public short perms; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path of the file or directory.
       */
      PATH((short)1, "path"),
      /**
       * New permissions for the file or directory.
       */
      PERMS((short)2, "perms");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          case 2: // PERMS
            return PERMS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __PERMS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PERMS, new org.apache.thrift.meta_data.FieldMetaData("perms", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I16)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(chmod_args.class, metaDataMap);
    }

    public chmod_args() {
    }

    public chmod_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path,
      short perms)
    {
      this();
      this.ctx = ctx;
      this.path = path;
      this.perms = perms;
      setPermsIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public chmod_args(chmod_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
      this.perms = other.perms;
    }

    public chmod_args deepCopy() {
      return new chmod_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
      setPermsIsSet(false);
      this.perms = 0;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public chmod_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path of the file or directory.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path of the file or directory.
     */
    public chmod_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     * New permissions for the file or directory.
     */
    public short getPerms() {
      return this.perms;
    }

    /**
     * New permissions for the file or directory.
     */
    public chmod_args setPerms(short perms) {
      this.perms = perms;
      setPermsIsSet(true);
      return this;
    }

    public void unsetPerms() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __PERMS_ISSET_ID);
    }

    /** Returns true if field perms is set (has been assigned a value) and false otherwise */
    public boolean isSetPerms() {
      return EncodingUtils.testBit(__isset_bitfield, __PERMS_ISSET_ID);
    }

    public void setPermsIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __PERMS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case PERMS:
        if (value == null) {
          unsetPerms();
        } else {
          setPerms((Short)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      case PERMS:
        return Short.valueOf(getPerms());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      case PERMS:
        return isSetPerms();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof chmod_args)
        return this.equals((chmod_args)that);
      return false;
    }

    public boolean equals(chmod_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_perms = true;
      boolean that_present_perms = true;
      if (this_present_perms || that_present_perms) {
        if (!(this_present_perms && that_present_perms))
          return false;
        if (this.perms != that.perms)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(chmod_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      chmod_args typedOther = (chmod_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPerms()).compareTo(typedOther.isSetPerms());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPerms()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.perms, typedOther.perms);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("chmod_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("perms:");
      sb.append(this.perms);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class chmod_argsStandardSchemeFactory implements SchemeFactory {
      public chmod_argsStandardScheme getScheme() {
        return new chmod_argsStandardScheme();
      }
    }

    private static class chmod_argsStandardScheme extends StandardScheme<chmod_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, chmod_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PERMS
              if (schemeField.type == org.apache.thrift.protocol.TType.I16) {
                struct.perms = iprot.readI16();
                struct.setPermsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, chmod_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(PERMS_FIELD_DESC);
        oprot.writeI16(struct.perms);
        oprot.writeFieldEnd();
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class chmod_argsTupleSchemeFactory implements SchemeFactory {
      public chmod_argsTupleScheme getScheme() {
        return new chmod_argsTupleScheme();
      }
    }

    private static class chmod_argsTupleScheme extends TupleScheme<chmod_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, chmod_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetPerms()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetPerms()) {
          oprot.writeI16(struct.perms);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, chmod_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.perms = iprot.readI16();
          struct.setPermsIsSet(true);
        }
      }
    }

  }

  public static class chmod_result implements org.apache.thrift.TBase<chmod_result, chmod_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("chmod_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new chmod_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new chmod_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(chmod_result.class, metaDataMap);
    }

    public chmod_result() {
    }

    public chmod_result(
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public chmod_result(chmod_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public chmod_result deepCopy() {
      return new chmod_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public chmod_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof chmod_result)
        return this.equals((chmod_result)that);
      return false;
    }

    public boolean equals(chmod_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(chmod_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      chmod_result typedOther = (chmod_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("chmod_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class chmod_resultStandardSchemeFactory implements SchemeFactory {
      public chmod_resultStandardScheme getScheme() {
        return new chmod_resultStandardScheme();
      }
    }

    private static class chmod_resultStandardScheme extends StandardScheme<chmod_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, chmod_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, chmod_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class chmod_resultTupleSchemeFactory implements SchemeFactory {
      public chmod_resultTupleScheme getScheme() {
        return new chmod_resultTupleScheme();
      }
    }

    private static class chmod_resultTupleScheme extends TupleScheme<chmod_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, chmod_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, chmod_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class chown_args implements org.apache.thrift.TBase<chown_args, chown_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("chown_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField OWNER_FIELD_DESC = new org.apache.thrift.protocol.TField("owner", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField GROUP_FIELD_DESC = new org.apache.thrift.protocol.TField("group", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new chown_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new chown_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path to the file or directory
     */
    public String path; // required
    /**
     * New owner.
     */
    public String owner; // required
    /**
     * New group.
     */
    public String group; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path to the file or directory
       */
      PATH((short)1, "path"),
      /**
       * New owner.
       */
      OWNER((short)2, "owner"),
      /**
       * New group.
       */
      GROUP((short)3, "group");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          case 2: // OWNER
            return OWNER;
          case 3: // GROUP
            return GROUP;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OWNER, new org.apache.thrift.meta_data.FieldMetaData("owner", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.GROUP, new org.apache.thrift.meta_data.FieldMetaData("group", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(chown_args.class, metaDataMap);
    }

    public chown_args() {
    }

    public chown_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path,
      String owner,
      String group)
    {
      this();
      this.ctx = ctx;
      this.path = path;
      this.owner = owner;
      this.group = group;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public chown_args(chown_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
      if (other.isSetOwner()) {
        this.owner = other.owner;
      }
      if (other.isSetGroup()) {
        this.group = other.group;
      }
    }

    public chown_args deepCopy() {
      return new chown_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
      this.owner = null;
      this.group = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public chown_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path to the file or directory
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path to the file or directory
     */
    public chown_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     * New owner.
     */
    public String getOwner() {
      return this.owner;
    }

    /**
     * New owner.
     */
    public chown_args setOwner(String owner) {
      this.owner = owner;
      return this;
    }

    public void unsetOwner() {
      this.owner = null;
    }

    /** Returns true if field owner is set (has been assigned a value) and false otherwise */
    public boolean isSetOwner() {
      return this.owner != null;
    }

    public void setOwnerIsSet(boolean value) {
      if (!value) {
        this.owner = null;
      }
    }

    /**
     * New group.
     */
    public String getGroup() {
      return this.group;
    }

    /**
     * New group.
     */
    public chown_args setGroup(String group) {
      this.group = group;
      return this;
    }

    public void unsetGroup() {
      this.group = null;
    }

    /** Returns true if field group is set (has been assigned a value) and false otherwise */
    public boolean isSetGroup() {
      return this.group != null;
    }

    public void setGroupIsSet(boolean value) {
      if (!value) {
        this.group = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case OWNER:
        if (value == null) {
          unsetOwner();
        } else {
          setOwner((String)value);
        }
        break;

      case GROUP:
        if (value == null) {
          unsetGroup();
        } else {
          setGroup((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      case OWNER:
        return getOwner();

      case GROUP:
        return getGroup();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      case OWNER:
        return isSetOwner();
      case GROUP:
        return isSetGroup();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof chown_args)
        return this.equals((chown_args)that);
      return false;
    }

    public boolean equals(chown_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_owner = true && this.isSetOwner();
      boolean that_present_owner = true && that.isSetOwner();
      if (this_present_owner || that_present_owner) {
        if (!(this_present_owner && that_present_owner))
          return false;
        if (!this.owner.equals(that.owner))
          return false;
      }

      boolean this_present_group = true && this.isSetGroup();
      boolean that_present_group = true && that.isSetGroup();
      if (this_present_group || that_present_group) {
        if (!(this_present_group && that_present_group))
          return false;
        if (!this.group.equals(that.group))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(chown_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      chown_args typedOther = (chown_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOwner()).compareTo(typedOther.isSetOwner());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOwner()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.owner, typedOther.owner);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetGroup()).compareTo(typedOther.isSetGroup());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGroup()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.group, typedOther.group);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("chown_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("owner:");
      if (this.owner == null) {
        sb.append("null");
      } else {
        sb.append(this.owner);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("group:");
      if (this.group == null) {
        sb.append("null");
      } else {
        sb.append(this.group);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class chown_argsStandardSchemeFactory implements SchemeFactory {
      public chown_argsStandardScheme getScheme() {
        return new chown_argsStandardScheme();
      }
    }

    private static class chown_argsStandardScheme extends StandardScheme<chown_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, chown_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OWNER
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.owner = iprot.readString();
                struct.setOwnerIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // GROUP
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.group = iprot.readString();
                struct.setGroupIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, chown_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        if (struct.owner != null) {
          oprot.writeFieldBegin(OWNER_FIELD_DESC);
          oprot.writeString(struct.owner);
          oprot.writeFieldEnd();
        }
        if (struct.group != null) {
          oprot.writeFieldBegin(GROUP_FIELD_DESC);
          oprot.writeString(struct.group);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class chown_argsTupleSchemeFactory implements SchemeFactory {
      public chown_argsTupleScheme getScheme() {
        return new chown_argsTupleScheme();
      }
    }

    private static class chown_argsTupleScheme extends TupleScheme<chown_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, chown_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetOwner()) {
          optionals.set(2);
        }
        if (struct.isSetGroup()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetOwner()) {
          oprot.writeString(struct.owner);
        }
        if (struct.isSetGroup()) {
          oprot.writeString(struct.group);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, chown_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.owner = iprot.readString();
          struct.setOwnerIsSet(true);
        }
        if (incoming.get(3)) {
          struct.group = iprot.readString();
          struct.setGroupIsSet(true);
        }
      }
    }

  }

  public static class chown_result implements org.apache.thrift.TBase<chown_result, chown_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("chown_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new chown_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new chown_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(chown_result.class, metaDataMap);
    }

    public chown_result() {
    }

    public chown_result(
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public chown_result(chown_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public chown_result deepCopy() {
      return new chown_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public chown_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof chown_result)
        return this.equals((chown_result)that);
      return false;
    }

    public boolean equals(chown_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(chown_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      chown_result typedOther = (chown_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("chown_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class chown_resultStandardSchemeFactory implements SchemeFactory {
      public chown_resultStandardScheme getScheme() {
        return new chown_resultStandardScheme();
      }
    }

    private static class chown_resultStandardScheme extends StandardScheme<chown_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, chown_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, chown_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class chown_resultTupleSchemeFactory implements SchemeFactory {
      public chown_resultTupleScheme getScheme() {
        return new chown_resultTupleScheme();
      }
    }

    private static class chown_resultTupleScheme extends TupleScheme<chown_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, chown_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, chown_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class df_args implements org.apache.thrift.TBase<df_args, df_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("df_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new df_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new df_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(df_args.class, metaDataMap);
    }

    public df_args() {
    }

    public df_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public df_args(df_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public df_args deepCopy() {
      return new df_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public df_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof df_args)
        return this.equals((df_args)that);
      return false;
    }

    public boolean equals(df_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(df_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      df_args typedOther = (df_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("df_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class df_argsStandardSchemeFactory implements SchemeFactory {
      public df_argsStandardScheme getScheme() {
        return new df_argsStandardScheme();
      }
    }

    private static class df_argsStandardScheme extends StandardScheme<df_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, df_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, df_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class df_argsTupleSchemeFactory implements SchemeFactory {
      public df_argsTupleScheme getScheme() {
        return new df_argsTupleScheme();
      }
    }

    private static class df_argsTupleScheme extends TupleScheme<df_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, df_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, df_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class df_result implements org.apache.thrift.TBase<df_result, df_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("df_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new df_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new df_resultTupleSchemeFactory());
    }

    public List<Long> success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(df_result.class, metaDataMap);
    }

    public df_result() {
    }

    public df_result(
      List<Long> success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public df_result(df_result other) {
      if (other.isSetSuccess()) {
        List<Long> __this__success = new ArrayList<Long>();
        for (Long other_element : other.success) {
          __this__success.add(other_element);
        }
        this.success = __this__success;
      }
    }

    public df_result deepCopy() {
      return new df_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<Long> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(long elem) {
      if (this.success == null) {
        this.success = new ArrayList<Long>();
      }
      this.success.add(elem);
    }

    public List<Long> getSuccess() {
      return this.success;
    }

    public df_result setSuccess(List<Long> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<Long>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof df_result)
        return this.equals((df_result)that);
      return false;
    }

    public boolean equals(df_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(df_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      df_result typedOther = (df_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("df_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class df_resultStandardSchemeFactory implements SchemeFactory {
      public df_resultStandardScheme getScheme() {
        return new df_resultStandardScheme();
      }
    }

    private static class df_resultStandardScheme extends StandardScheme<df_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, df_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list8 = iprot.readListBegin();
                  struct.success = new ArrayList<Long>(_list8.size);
                  for (int _i9 = 0; _i9 < _list8.size; ++_i9)
                  {
                    long _elem10; // required
                    _elem10 = iprot.readI64();
                    struct.success.add(_elem10);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, df_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I64, struct.success.size()));
            for (long _iter11 : struct.success)
            {
              oprot.writeI64(_iter11);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class df_resultTupleSchemeFactory implements SchemeFactory {
      public df_resultTupleScheme getScheme() {
        return new df_resultTupleScheme();
      }
    }

    private static class df_resultTupleScheme extends TupleScheme<df_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, df_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (long _iter12 : struct.success)
            {
              oprot.writeI64(_iter12);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, df_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list13 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I64, iprot.readI32());
            struct.success = new ArrayList<Long>(_list13.size);
            for (int _i14 = 0; _i14 < _list13.size; ++_i14)
            {
              long _elem15; // required
              _elem15 = iprot.readI64();
              struct.success.add(_elem15);
            }
          }
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class enterSafeMode_args implements org.apache.thrift.TBase<enterSafeMode_args, enterSafeMode_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("enterSafeMode_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new enterSafeMode_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new enterSafeMode_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(enterSafeMode_args.class, metaDataMap);
    }

    public enterSafeMode_args() {
    }

    public enterSafeMode_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public enterSafeMode_args(enterSafeMode_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public enterSafeMode_args deepCopy() {
      return new enterSafeMode_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public enterSafeMode_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof enterSafeMode_args)
        return this.equals((enterSafeMode_args)that);
      return false;
    }

    public boolean equals(enterSafeMode_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(enterSafeMode_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      enterSafeMode_args typedOther = (enterSafeMode_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("enterSafeMode_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class enterSafeMode_argsStandardSchemeFactory implements SchemeFactory {
      public enterSafeMode_argsStandardScheme getScheme() {
        return new enterSafeMode_argsStandardScheme();
      }
    }

    private static class enterSafeMode_argsStandardScheme extends StandardScheme<enterSafeMode_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, enterSafeMode_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, enterSafeMode_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class enterSafeMode_argsTupleSchemeFactory implements SchemeFactory {
      public enterSafeMode_argsTupleScheme getScheme() {
        return new enterSafeMode_argsTupleScheme();
      }
    }

    private static class enterSafeMode_argsTupleScheme extends TupleScheme<enterSafeMode_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, enterSafeMode_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, enterSafeMode_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class enterSafeMode_result implements org.apache.thrift.TBase<enterSafeMode_result, enterSafeMode_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("enterSafeMode_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new enterSafeMode_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new enterSafeMode_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(enterSafeMode_result.class, metaDataMap);
    }

    public enterSafeMode_result() {
    }

    public enterSafeMode_result(
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public enterSafeMode_result(enterSafeMode_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public enterSafeMode_result deepCopy() {
      return new enterSafeMode_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public enterSafeMode_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof enterSafeMode_result)
        return this.equals((enterSafeMode_result)that);
      return false;
    }

    public boolean equals(enterSafeMode_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(enterSafeMode_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      enterSafeMode_result typedOther = (enterSafeMode_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("enterSafeMode_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class enterSafeMode_resultStandardSchemeFactory implements SchemeFactory {
      public enterSafeMode_resultStandardScheme getScheme() {
        return new enterSafeMode_resultStandardScheme();
      }
    }

    private static class enterSafeMode_resultStandardScheme extends StandardScheme<enterSafeMode_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, enterSafeMode_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, enterSafeMode_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class enterSafeMode_resultTupleSchemeFactory implements SchemeFactory {
      public enterSafeMode_resultTupleScheme getScheme() {
        return new enterSafeMode_resultTupleScheme();
      }
    }

    private static class enterSafeMode_resultTupleScheme extends TupleScheme<enterSafeMode_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, enterSafeMode_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, enterSafeMode_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class getBlocks_args implements org.apache.thrift.TBase<getBlocks_args, getBlocks_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getBlocks_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField OFFSET_FIELD_DESC = new org.apache.thrift.protocol.TField("offset", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField LENGTH_FIELD_DESC = new org.apache.thrift.protocol.TField("length", org.apache.thrift.protocol.TType.I64, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getBlocks_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getBlocks_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path to the file.
     */
    public String path; // required
    /**
     * Offset of the region.
     */
    public long offset; // required
    /**
     * Length of the region
     */
    public long length; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path to the file.
       */
      PATH((short)1, "path"),
      /**
       * Offset of the region.
       */
      OFFSET((short)2, "offset"),
      /**
       * Length of the region
       */
      LENGTH((short)3, "length");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          case 2: // OFFSET
            return OFFSET;
          case 3: // LENGTH
            return LENGTH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __OFFSET_ISSET_ID = 0;
    private static final int __LENGTH_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OFFSET, new org.apache.thrift.meta_data.FieldMetaData("offset", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.LENGTH, new org.apache.thrift.meta_data.FieldMetaData("length", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getBlocks_args.class, metaDataMap);
    }

    public getBlocks_args() {
    }

    public getBlocks_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path,
      long offset,
      long length)
    {
      this();
      this.ctx = ctx;
      this.path = path;
      this.offset = offset;
      setOffsetIsSet(true);
      this.length = length;
      setLengthIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getBlocks_args(getBlocks_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
      this.offset = other.offset;
      this.length = other.length;
    }

    public getBlocks_args deepCopy() {
      return new getBlocks_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
      setOffsetIsSet(false);
      this.offset = 0;
      setLengthIsSet(false);
      this.length = 0;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getBlocks_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path to the file.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path to the file.
     */
    public getBlocks_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     * Offset of the region.
     */
    public long getOffset() {
      return this.offset;
    }

    /**
     * Offset of the region.
     */
    public getBlocks_args setOffset(long offset) {
      this.offset = offset;
      setOffsetIsSet(true);
      return this;
    }

    public void unsetOffset() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    /** Returns true if field offset is set (has been assigned a value) and false otherwise */
    public boolean isSetOffset() {
      return EncodingUtils.testBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    public void setOffsetIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __OFFSET_ISSET_ID, value);
    }

    /**
     * Length of the region
     */
    public long getLength() {
      return this.length;
    }

    /**
     * Length of the region
     */
    public getBlocks_args setLength(long length) {
      this.length = length;
      setLengthIsSet(true);
      return this;
    }

    public void unsetLength() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __LENGTH_ISSET_ID);
    }

    /** Returns true if field length is set (has been assigned a value) and false otherwise */
    public boolean isSetLength() {
      return EncodingUtils.testBit(__isset_bitfield, __LENGTH_ISSET_ID);
    }

    public void setLengthIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __LENGTH_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case OFFSET:
        if (value == null) {
          unsetOffset();
        } else {
          setOffset((Long)value);
        }
        break;

      case LENGTH:
        if (value == null) {
          unsetLength();
        } else {
          setLength((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      case OFFSET:
        return Long.valueOf(getOffset());

      case LENGTH:
        return Long.valueOf(getLength());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      case OFFSET:
        return isSetOffset();
      case LENGTH:
        return isSetLength();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getBlocks_args)
        return this.equals((getBlocks_args)that);
      return false;
    }

    public boolean equals(getBlocks_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_offset = true;
      boolean that_present_offset = true;
      if (this_present_offset || that_present_offset) {
        if (!(this_present_offset && that_present_offset))
          return false;
        if (this.offset != that.offset)
          return false;
      }

      boolean this_present_length = true;
      boolean that_present_length = true;
      if (this_present_length || that_present_length) {
        if (!(this_present_length && that_present_length))
          return false;
        if (this.length != that.length)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getBlocks_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getBlocks_args typedOther = (getBlocks_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOffset()).compareTo(typedOther.isSetOffset());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOffset()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.offset, typedOther.offset);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLength()).compareTo(typedOther.isSetLength());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLength()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.length, typedOther.length);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getBlocks_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("offset:");
      sb.append(this.offset);
      first = false;
      if (!first) sb.append(", ");
      sb.append("length:");
      sb.append(this.length);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getBlocks_argsStandardSchemeFactory implements SchemeFactory {
      public getBlocks_argsStandardScheme getScheme() {
        return new getBlocks_argsStandardScheme();
      }
    }

    private static class getBlocks_argsStandardScheme extends StandardScheme<getBlocks_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getBlocks_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OFFSET
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.offset = iprot.readI64();
                struct.setOffsetIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // LENGTH
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.length = iprot.readI64();
                struct.setLengthIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getBlocks_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(OFFSET_FIELD_DESC);
        oprot.writeI64(struct.offset);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LENGTH_FIELD_DESC);
        oprot.writeI64(struct.length);
        oprot.writeFieldEnd();
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getBlocks_argsTupleSchemeFactory implements SchemeFactory {
      public getBlocks_argsTupleScheme getScheme() {
        return new getBlocks_argsTupleScheme();
      }
    }

    private static class getBlocks_argsTupleScheme extends TupleScheme<getBlocks_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getBlocks_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetOffset()) {
          optionals.set(2);
        }
        if (struct.isSetLength()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetOffset()) {
          oprot.writeI64(struct.offset);
        }
        if (struct.isSetLength()) {
          oprot.writeI64(struct.length);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getBlocks_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.offset = iprot.readI64();
          struct.setOffsetIsSet(true);
        }
        if (incoming.get(3)) {
          struct.length = iprot.readI64();
          struct.setLengthIsSet(true);
        }
      }
    }

  }

  public static class getBlocks_result implements org.apache.thrift.TBase<getBlocks_result, getBlocks_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getBlocks_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getBlocks_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getBlocks_resultTupleSchemeFactory());
    }

    public List<Block> success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Block.class))));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getBlocks_result.class, metaDataMap);
    }

    public getBlocks_result() {
    }

    public getBlocks_result(
      List<Block> success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getBlocks_result(getBlocks_result other) {
      if (other.isSetSuccess()) {
        List<Block> __this__success = new ArrayList<Block>();
        for (Block other_element : other.success) {
          __this__success.add(new Block(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public getBlocks_result deepCopy() {
      return new getBlocks_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<Block> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(Block elem) {
      if (this.success == null) {
        this.success = new ArrayList<Block>();
      }
      this.success.add(elem);
    }

    public List<Block> getSuccess() {
      return this.success;
    }

    public getBlocks_result setSuccess(List<Block> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public getBlocks_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<Block>)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getBlocks_result)
        return this.equals((getBlocks_result)that);
      return false;
    }

    public boolean equals(getBlocks_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getBlocks_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getBlocks_result typedOther = (getBlocks_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getBlocks_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getBlocks_resultStandardSchemeFactory implements SchemeFactory {
      public getBlocks_resultStandardScheme getScheme() {
        return new getBlocks_resultStandardScheme();
      }
    }

    private static class getBlocks_resultStandardScheme extends StandardScheme<getBlocks_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getBlocks_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list16 = iprot.readListBegin();
                  struct.success = new ArrayList<Block>(_list16.size);
                  for (int _i17 = 0; _i17 < _list16.size; ++_i17)
                  {
                    Block _elem18; // required
                    _elem18 = new Block();
                    _elem18.read(iprot);
                    struct.success.add(_elem18);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getBlocks_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (Block _iter19 : struct.success)
            {
              _iter19.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getBlocks_resultTupleSchemeFactory implements SchemeFactory {
      public getBlocks_resultTupleScheme getScheme() {
        return new getBlocks_resultTupleScheme();
      }
    }

    private static class getBlocks_resultTupleScheme extends TupleScheme<getBlocks_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getBlocks_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (Block _iter20 : struct.success)
            {
              _iter20.write(oprot);
            }
          }
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getBlocks_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list21 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<Block>(_list21.size);
            for (int _i22 = 0; _i22 < _list21.size; ++_i22)
            {
              Block _elem23; // required
              _elem23 = new Block();
              _elem23.read(iprot);
              struct.success.add(_elem23);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class getPreferredBlockSize_args implements org.apache.thrift.TBase<getPreferredBlockSize_args, getPreferredBlockSize_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getPreferredBlockSize_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getPreferredBlockSize_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getPreferredBlockSize_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path to the file.
     */
    public String path; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path to the file.
       */
      PATH((short)1, "path");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getPreferredBlockSize_args.class, metaDataMap);
    }

    public getPreferredBlockSize_args() {
    }

    public getPreferredBlockSize_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path)
    {
      this();
      this.ctx = ctx;
      this.path = path;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getPreferredBlockSize_args(getPreferredBlockSize_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
    }

    public getPreferredBlockSize_args deepCopy() {
      return new getPreferredBlockSize_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getPreferredBlockSize_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path to the file.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path to the file.
     */
    public getPreferredBlockSize_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getPreferredBlockSize_args)
        return this.equals((getPreferredBlockSize_args)that);
      return false;
    }

    public boolean equals(getPreferredBlockSize_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getPreferredBlockSize_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getPreferredBlockSize_args typedOther = (getPreferredBlockSize_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getPreferredBlockSize_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getPreferredBlockSize_argsStandardSchemeFactory implements SchemeFactory {
      public getPreferredBlockSize_argsStandardScheme getScheme() {
        return new getPreferredBlockSize_argsStandardScheme();
      }
    }

    private static class getPreferredBlockSize_argsStandardScheme extends StandardScheme<getPreferredBlockSize_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getPreferredBlockSize_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getPreferredBlockSize_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getPreferredBlockSize_argsTupleSchemeFactory implements SchemeFactory {
      public getPreferredBlockSize_argsTupleScheme getScheme() {
        return new getPreferredBlockSize_argsTupleScheme();
      }
    }

    private static class getPreferredBlockSize_argsTupleScheme extends TupleScheme<getPreferredBlockSize_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getPreferredBlockSize_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getPreferredBlockSize_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
      }
    }

  }

  public static class getPreferredBlockSize_result implements org.apache.thrift.TBase<getPreferredBlockSize_result, getPreferredBlockSize_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getPreferredBlockSize_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getPreferredBlockSize_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getPreferredBlockSize_resultTupleSchemeFactory());
    }

    public long success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getPreferredBlockSize_result.class, metaDataMap);
    }

    public getPreferredBlockSize_result() {
    }

    public getPreferredBlockSize_result(
      long success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getPreferredBlockSize_result(getPreferredBlockSize_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public getPreferredBlockSize_result deepCopy() {
      return new getPreferredBlockSize_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.err = null;
    }

    public long getSuccess() {
      return this.success;
    }

    public getPreferredBlockSize_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public getPreferredBlockSize_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Long)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Long.valueOf(getSuccess());

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getPreferredBlockSize_result)
        return this.equals((getPreferredBlockSize_result)that);
      return false;
    }

    public boolean equals(getPreferredBlockSize_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getPreferredBlockSize_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getPreferredBlockSize_result typedOther = (getPreferredBlockSize_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getPreferredBlockSize_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getPreferredBlockSize_resultStandardSchemeFactory implements SchemeFactory {
      public getPreferredBlockSize_resultStandardScheme getScheme() {
        return new getPreferredBlockSize_resultStandardScheme();
      }
    }

    private static class getPreferredBlockSize_resultStandardScheme extends StandardScheme<getPreferredBlockSize_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getPreferredBlockSize_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getPreferredBlockSize_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getPreferredBlockSize_resultTupleSchemeFactory implements SchemeFactory {
      public getPreferredBlockSize_resultTupleScheme getScheme() {
        return new getPreferredBlockSize_resultTupleScheme();
      }
    }

    private static class getPreferredBlockSize_resultTupleScheme extends TupleScheme<getPreferredBlockSize_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getPreferredBlockSize_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getPreferredBlockSize_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class isInSafeMode_args implements org.apache.thrift.TBase<isInSafeMode_args, isInSafeMode_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isInSafeMode_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isInSafeMode_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isInSafeMode_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isInSafeMode_args.class, metaDataMap);
    }

    public isInSafeMode_args() {
    }

    public isInSafeMode_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isInSafeMode_args(isInSafeMode_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public isInSafeMode_args deepCopy() {
      return new isInSafeMode_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public isInSafeMode_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isInSafeMode_args)
        return this.equals((isInSafeMode_args)that);
      return false;
    }

    public boolean equals(isInSafeMode_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(isInSafeMode_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      isInSafeMode_args typedOther = (isInSafeMode_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isInSafeMode_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isInSafeMode_argsStandardSchemeFactory implements SchemeFactory {
      public isInSafeMode_argsStandardScheme getScheme() {
        return new isInSafeMode_argsStandardScheme();
      }
    }

    private static class isInSafeMode_argsStandardScheme extends StandardScheme<isInSafeMode_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isInSafeMode_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isInSafeMode_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isInSafeMode_argsTupleSchemeFactory implements SchemeFactory {
      public isInSafeMode_argsTupleScheme getScheme() {
        return new isInSafeMode_argsTupleScheme();
      }
    }

    private static class isInSafeMode_argsTupleScheme extends TupleScheme<isInSafeMode_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isInSafeMode_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isInSafeMode_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class isInSafeMode_result implements org.apache.thrift.TBase<isInSafeMode_result, isInSafeMode_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isInSafeMode_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isInSafeMode_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isInSafeMode_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isInSafeMode_result.class, metaDataMap);
    }

    public isInSafeMode_result() {
    }

    public isInSafeMode_result(
      boolean success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isInSafeMode_result(isInSafeMode_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public isInSafeMode_result deepCopy() {
      return new isInSafeMode_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.err = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public isInSafeMode_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public isInSafeMode_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isInSafeMode_result)
        return this.equals((isInSafeMode_result)that);
      return false;
    }

    public boolean equals(isInSafeMode_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(isInSafeMode_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      isInSafeMode_result typedOther = (isInSafeMode_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isInSafeMode_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isInSafeMode_resultStandardSchemeFactory implements SchemeFactory {
      public isInSafeMode_resultStandardScheme getScheme() {
        return new isInSafeMode_resultStandardScheme();
      }
    }

    private static class isInSafeMode_resultStandardScheme extends StandardScheme<isInSafeMode_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isInSafeMode_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isInSafeMode_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isInSafeMode_resultTupleSchemeFactory implements SchemeFactory {
      public isInSafeMode_resultTupleScheme getScheme() {
        return new isInSafeMode_resultTupleScheme();
      }
    }

    private static class isInSafeMode_resultTupleScheme extends TupleScheme<isInSafeMode_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isInSafeMode_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isInSafeMode_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class leaveSafeMode_args implements org.apache.thrift.TBase<leaveSafeMode_args, leaveSafeMode_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("leaveSafeMode_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new leaveSafeMode_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new leaveSafeMode_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(leaveSafeMode_args.class, metaDataMap);
    }

    public leaveSafeMode_args() {
    }

    public leaveSafeMode_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public leaveSafeMode_args(leaveSafeMode_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public leaveSafeMode_args deepCopy() {
      return new leaveSafeMode_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public leaveSafeMode_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof leaveSafeMode_args)
        return this.equals((leaveSafeMode_args)that);
      return false;
    }

    public boolean equals(leaveSafeMode_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(leaveSafeMode_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      leaveSafeMode_args typedOther = (leaveSafeMode_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("leaveSafeMode_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class leaveSafeMode_argsStandardSchemeFactory implements SchemeFactory {
      public leaveSafeMode_argsStandardScheme getScheme() {
        return new leaveSafeMode_argsStandardScheme();
      }
    }

    private static class leaveSafeMode_argsStandardScheme extends StandardScheme<leaveSafeMode_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, leaveSafeMode_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, leaveSafeMode_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class leaveSafeMode_argsTupleSchemeFactory implements SchemeFactory {
      public leaveSafeMode_argsTupleScheme getScheme() {
        return new leaveSafeMode_argsTupleScheme();
      }
    }

    private static class leaveSafeMode_argsTupleScheme extends TupleScheme<leaveSafeMode_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, leaveSafeMode_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, leaveSafeMode_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class leaveSafeMode_result implements org.apache.thrift.TBase<leaveSafeMode_result, leaveSafeMode_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("leaveSafeMode_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new leaveSafeMode_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new leaveSafeMode_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(leaveSafeMode_result.class, metaDataMap);
    }

    public leaveSafeMode_result() {
    }

    public leaveSafeMode_result(
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public leaveSafeMode_result(leaveSafeMode_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public leaveSafeMode_result deepCopy() {
      return new leaveSafeMode_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public leaveSafeMode_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof leaveSafeMode_result)
        return this.equals((leaveSafeMode_result)that);
      return false;
    }

    public boolean equals(leaveSafeMode_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(leaveSafeMode_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      leaveSafeMode_result typedOther = (leaveSafeMode_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("leaveSafeMode_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class leaveSafeMode_resultStandardSchemeFactory implements SchemeFactory {
      public leaveSafeMode_resultStandardScheme getScheme() {
        return new leaveSafeMode_resultStandardScheme();
      }
    }

    private static class leaveSafeMode_resultStandardScheme extends StandardScheme<leaveSafeMode_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, leaveSafeMode_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, leaveSafeMode_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class leaveSafeMode_resultTupleSchemeFactory implements SchemeFactory {
      public leaveSafeMode_resultTupleScheme getScheme() {
        return new leaveSafeMode_resultTupleScheme();
      }
    }

    private static class leaveSafeMode_resultTupleScheme extends TupleScheme<leaveSafeMode_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, leaveSafeMode_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, leaveSafeMode_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class ls_args implements org.apache.thrift.TBase<ls_args, ls_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("ls_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new ls_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new ls_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path to the directory.
     */
    public String path; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path to the directory.
       */
      PATH((short)1, "path");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(ls_args.class, metaDataMap);
    }

    public ls_args() {
    }

    public ls_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path)
    {
      this();
      this.ctx = ctx;
      this.path = path;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public ls_args(ls_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
    }

    public ls_args deepCopy() {
      return new ls_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public ls_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path to the directory.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path to the directory.
     */
    public ls_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof ls_args)
        return this.equals((ls_args)that);
      return false;
    }

    public boolean equals(ls_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(ls_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      ls_args typedOther = (ls_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("ls_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class ls_argsStandardSchemeFactory implements SchemeFactory {
      public ls_argsStandardScheme getScheme() {
        return new ls_argsStandardScheme();
      }
    }

    private static class ls_argsStandardScheme extends StandardScheme<ls_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, ls_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, ls_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class ls_argsTupleSchemeFactory implements SchemeFactory {
      public ls_argsTupleScheme getScheme() {
        return new ls_argsTupleScheme();
      }
    }

    private static class ls_argsTupleScheme extends TupleScheme<ls_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, ls_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, ls_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
      }
    }

  }

  public static class ls_result implements org.apache.thrift.TBase<ls_result, ls_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("ls_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new ls_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new ls_resultTupleSchemeFactory());
    }

    public List<Stat> success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Stat.class))));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(ls_result.class, metaDataMap);
    }

    public ls_result() {
    }

    public ls_result(
      List<Stat> success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public ls_result(ls_result other) {
      if (other.isSetSuccess()) {
        List<Stat> __this__success = new ArrayList<Stat>();
        for (Stat other_element : other.success) {
          __this__success.add(new Stat(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public ls_result deepCopy() {
      return new ls_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<Stat> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(Stat elem) {
      if (this.success == null) {
        this.success = new ArrayList<Stat>();
      }
      this.success.add(elem);
    }

    public List<Stat> getSuccess() {
      return this.success;
    }

    public ls_result setSuccess(List<Stat> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public ls_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<Stat>)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof ls_result)
        return this.equals((ls_result)that);
      return false;
    }

    public boolean equals(ls_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(ls_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      ls_result typedOther = (ls_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("ls_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class ls_resultStandardSchemeFactory implements SchemeFactory {
      public ls_resultStandardScheme getScheme() {
        return new ls_resultStandardScheme();
      }
    }

    private static class ls_resultStandardScheme extends StandardScheme<ls_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, ls_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list24 = iprot.readListBegin();
                  struct.success = new ArrayList<Stat>(_list24.size);
                  for (int _i25 = 0; _i25 < _list24.size; ++_i25)
                  {
                    Stat _elem26; // required
                    _elem26 = new Stat();
                    _elem26.read(iprot);
                    struct.success.add(_elem26);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, ls_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (Stat _iter27 : struct.success)
            {
              _iter27.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class ls_resultTupleSchemeFactory implements SchemeFactory {
      public ls_resultTupleScheme getScheme() {
        return new ls_resultTupleScheme();
      }
    }

    private static class ls_resultTupleScheme extends TupleScheme<ls_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, ls_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (Stat _iter28 : struct.success)
            {
              _iter28.write(oprot);
            }
          }
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, ls_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list29 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<Stat>(_list29.size);
            for (int _i30 = 0; _i30 < _list29.size; ++_i30)
            {
              Stat _elem31; // required
              _elem31 = new Stat();
              _elem31.read(iprot);
              struct.success.add(_elem31);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class mkdirhier_args implements org.apache.thrift.TBase<mkdirhier_args, mkdirhier_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("mkdirhier_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField PERMS_FIELD_DESC = new org.apache.thrift.protocol.TField("perms", org.apache.thrift.protocol.TType.I16, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new mkdirhier_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new mkdirhier_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path to the directory.
     */
    public String path; // required
    /**
     * Access permissions of the directory.
     */
    public short perms; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path to the directory.
       */
      PATH((short)1, "path"),
      /**
       * Access permissions of the directory.
       */
      PERMS((short)2, "perms");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          case 2: // PERMS
            return PERMS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __PERMS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PERMS, new org.apache.thrift.meta_data.FieldMetaData("perms", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I16)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(mkdirhier_args.class, metaDataMap);
    }

    public mkdirhier_args() {
    }

    public mkdirhier_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path,
      short perms)
    {
      this();
      this.ctx = ctx;
      this.path = path;
      this.perms = perms;
      setPermsIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public mkdirhier_args(mkdirhier_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
      this.perms = other.perms;
    }

    public mkdirhier_args deepCopy() {
      return new mkdirhier_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
      setPermsIsSet(false);
      this.perms = 0;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public mkdirhier_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path to the directory.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path to the directory.
     */
    public mkdirhier_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     * Access permissions of the directory.
     */
    public short getPerms() {
      return this.perms;
    }

    /**
     * Access permissions of the directory.
     */
    public mkdirhier_args setPerms(short perms) {
      this.perms = perms;
      setPermsIsSet(true);
      return this;
    }

    public void unsetPerms() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __PERMS_ISSET_ID);
    }

    /** Returns true if field perms is set (has been assigned a value) and false otherwise */
    public boolean isSetPerms() {
      return EncodingUtils.testBit(__isset_bitfield, __PERMS_ISSET_ID);
    }

    public void setPermsIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __PERMS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case PERMS:
        if (value == null) {
          unsetPerms();
        } else {
          setPerms((Short)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      case PERMS:
        return Short.valueOf(getPerms());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      case PERMS:
        return isSetPerms();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mkdirhier_args)
        return this.equals((mkdirhier_args)that);
      return false;
    }

    public boolean equals(mkdirhier_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_perms = true;
      boolean that_present_perms = true;
      if (this_present_perms || that_present_perms) {
        if (!(this_present_perms && that_present_perms))
          return false;
        if (this.perms != that.perms)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(mkdirhier_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      mkdirhier_args typedOther = (mkdirhier_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPerms()).compareTo(typedOther.isSetPerms());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPerms()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.perms, typedOther.perms);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("mkdirhier_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("perms:");
      sb.append(this.perms);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class mkdirhier_argsStandardSchemeFactory implements SchemeFactory {
      public mkdirhier_argsStandardScheme getScheme() {
        return new mkdirhier_argsStandardScheme();
      }
    }

    private static class mkdirhier_argsStandardScheme extends StandardScheme<mkdirhier_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, mkdirhier_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PERMS
              if (schemeField.type == org.apache.thrift.protocol.TType.I16) {
                struct.perms = iprot.readI16();
                struct.setPermsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, mkdirhier_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(PERMS_FIELD_DESC);
        oprot.writeI16(struct.perms);
        oprot.writeFieldEnd();
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class mkdirhier_argsTupleSchemeFactory implements SchemeFactory {
      public mkdirhier_argsTupleScheme getScheme() {
        return new mkdirhier_argsTupleScheme();
      }
    }

    private static class mkdirhier_argsTupleScheme extends TupleScheme<mkdirhier_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, mkdirhier_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetPerms()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetPerms()) {
          oprot.writeI16(struct.perms);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, mkdirhier_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.perms = iprot.readI16();
          struct.setPermsIsSet(true);
        }
      }
    }

  }

  public static class mkdirhier_result implements org.apache.thrift.TBase<mkdirhier_result, mkdirhier_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("mkdirhier_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new mkdirhier_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new mkdirhier_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(mkdirhier_result.class, metaDataMap);
    }

    public mkdirhier_result() {
    }

    public mkdirhier_result(
      boolean success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public mkdirhier_result(mkdirhier_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public mkdirhier_result deepCopy() {
      return new mkdirhier_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.err = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public mkdirhier_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public mkdirhier_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mkdirhier_result)
        return this.equals((mkdirhier_result)that);
      return false;
    }

    public boolean equals(mkdirhier_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(mkdirhier_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      mkdirhier_result typedOther = (mkdirhier_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("mkdirhier_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class mkdirhier_resultStandardSchemeFactory implements SchemeFactory {
      public mkdirhier_resultStandardScheme getScheme() {
        return new mkdirhier_resultStandardScheme();
      }
    }

    private static class mkdirhier_resultStandardScheme extends StandardScheme<mkdirhier_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, mkdirhier_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, mkdirhier_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class mkdirhier_resultTupleSchemeFactory implements SchemeFactory {
      public mkdirhier_resultTupleScheme getScheme() {
        return new mkdirhier_resultTupleScheme();
      }
    }

    private static class mkdirhier_resultTupleScheme extends TupleScheme<mkdirhier_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, mkdirhier_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, mkdirhier_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class refreshNodes_args implements org.apache.thrift.TBase<refreshNodes_args, refreshNodes_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("refreshNodes_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new refreshNodes_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new refreshNodes_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(refreshNodes_args.class, metaDataMap);
    }

    public refreshNodes_args() {
    }

    public refreshNodes_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx)
    {
      this();
      this.ctx = ctx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public refreshNodes_args(refreshNodes_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
    }

    public refreshNodes_args deepCopy() {
      return new refreshNodes_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public refreshNodes_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof refreshNodes_args)
        return this.equals((refreshNodes_args)that);
      return false;
    }

    public boolean equals(refreshNodes_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(refreshNodes_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      refreshNodes_args typedOther = (refreshNodes_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("refreshNodes_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class refreshNodes_argsStandardSchemeFactory implements SchemeFactory {
      public refreshNodes_argsStandardScheme getScheme() {
        return new refreshNodes_argsStandardScheme();
      }
    }

    private static class refreshNodes_argsStandardScheme extends StandardScheme<refreshNodes_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, refreshNodes_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, refreshNodes_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class refreshNodes_argsTupleSchemeFactory implements SchemeFactory {
      public refreshNodes_argsTupleScheme getScheme() {
        return new refreshNodes_argsTupleScheme();
      }
    }

    private static class refreshNodes_argsTupleScheme extends TupleScheme<refreshNodes_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, refreshNodes_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, refreshNodes_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
      }
    }

  }

  public static class refreshNodes_result implements org.apache.thrift.TBase<refreshNodes_result, refreshNodes_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("refreshNodes_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new refreshNodes_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new refreshNodes_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(refreshNodes_result.class, metaDataMap);
    }

    public refreshNodes_result() {
    }

    public refreshNodes_result(
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public refreshNodes_result(refreshNodes_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public refreshNodes_result deepCopy() {
      return new refreshNodes_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public refreshNodes_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof refreshNodes_result)
        return this.equals((refreshNodes_result)that);
      return false;
    }

    public boolean equals(refreshNodes_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(refreshNodes_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      refreshNodes_result typedOther = (refreshNodes_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("refreshNodes_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class refreshNodes_resultStandardSchemeFactory implements SchemeFactory {
      public refreshNodes_resultStandardScheme getScheme() {
        return new refreshNodes_resultStandardScheme();
      }
    }

    private static class refreshNodes_resultStandardScheme extends StandardScheme<refreshNodes_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, refreshNodes_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, refreshNodes_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class refreshNodes_resultTupleSchemeFactory implements SchemeFactory {
      public refreshNodes_resultTupleScheme getScheme() {
        return new refreshNodes_resultTupleScheme();
      }
    }

    private static class refreshNodes_resultTupleScheme extends TupleScheme<refreshNodes_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, refreshNodes_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, refreshNodes_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class rename_args implements org.apache.thrift.TBase<rename_args, rename_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("rename_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField NEW_PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("newPath", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new rename_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new rename_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path to existing file or directory.
     */
    public String path; // required
    /**
     * New path.
     */
    public String newPath; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path to existing file or directory.
       */
      PATH((short)1, "path"),
      /**
       * New path.
       */
      NEW_PATH((short)2, "newPath");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          case 2: // NEW_PATH
            return NEW_PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.NEW_PATH, new org.apache.thrift.meta_data.FieldMetaData("newPath", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(rename_args.class, metaDataMap);
    }

    public rename_args() {
    }

    public rename_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path,
      String newPath)
    {
      this();
      this.ctx = ctx;
      this.path = path;
      this.newPath = newPath;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public rename_args(rename_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
      if (other.isSetNewPath()) {
        this.newPath = other.newPath;
      }
    }

    public rename_args deepCopy() {
      return new rename_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
      this.newPath = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public rename_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path to existing file or directory.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path to existing file or directory.
     */
    public rename_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     * New path.
     */
    public String getNewPath() {
      return this.newPath;
    }

    /**
     * New path.
     */
    public rename_args setNewPath(String newPath) {
      this.newPath = newPath;
      return this;
    }

    public void unsetNewPath() {
      this.newPath = null;
    }

    /** Returns true if field newPath is set (has been assigned a value) and false otherwise */
    public boolean isSetNewPath() {
      return this.newPath != null;
    }

    public void setNewPathIsSet(boolean value) {
      if (!value) {
        this.newPath = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case NEW_PATH:
        if (value == null) {
          unsetNewPath();
        } else {
          setNewPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      case NEW_PATH:
        return getNewPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      case NEW_PATH:
        return isSetNewPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rename_args)
        return this.equals((rename_args)that);
      return false;
    }

    public boolean equals(rename_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_newPath = true && this.isSetNewPath();
      boolean that_present_newPath = true && that.isSetNewPath();
      if (this_present_newPath || that_present_newPath) {
        if (!(this_present_newPath && that_present_newPath))
          return false;
        if (!this.newPath.equals(that.newPath))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(rename_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      rename_args typedOther = (rename_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNewPath()).compareTo(typedOther.isSetNewPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNewPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.newPath, typedOther.newPath);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("rename_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("newPath:");
      if (this.newPath == null) {
        sb.append("null");
      } else {
        sb.append(this.newPath);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class rename_argsStandardSchemeFactory implements SchemeFactory {
      public rename_argsStandardScheme getScheme() {
        return new rename_argsStandardScheme();
      }
    }

    private static class rename_argsStandardScheme extends StandardScheme<rename_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, rename_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NEW_PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.newPath = iprot.readString();
                struct.setNewPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, rename_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        if (struct.newPath != null) {
          oprot.writeFieldBegin(NEW_PATH_FIELD_DESC);
          oprot.writeString(struct.newPath);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class rename_argsTupleSchemeFactory implements SchemeFactory {
      public rename_argsTupleScheme getScheme() {
        return new rename_argsTupleScheme();
      }
    }

    private static class rename_argsTupleScheme extends TupleScheme<rename_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, rename_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetNewPath()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetNewPath()) {
          oprot.writeString(struct.newPath);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, rename_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.newPath = iprot.readString();
          struct.setNewPathIsSet(true);
        }
      }
    }

  }

  public static class rename_result implements org.apache.thrift.TBase<rename_result, rename_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("rename_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new rename_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new rename_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(rename_result.class, metaDataMap);
    }

    public rename_result() {
    }

    public rename_result(
      boolean success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public rename_result(rename_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public rename_result deepCopy() {
      return new rename_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.err = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public rename_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public rename_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rename_result)
        return this.equals((rename_result)that);
      return false;
    }

    public boolean equals(rename_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(rename_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      rename_result typedOther = (rename_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("rename_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class rename_resultStandardSchemeFactory implements SchemeFactory {
      public rename_resultStandardScheme getScheme() {
        return new rename_resultStandardScheme();
      }
    }

    private static class rename_resultStandardScheme extends StandardScheme<rename_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, rename_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, rename_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class rename_resultTupleSchemeFactory implements SchemeFactory {
      public rename_resultTupleScheme getScheme() {
        return new rename_resultTupleScheme();
      }
    }

    private static class rename_resultTupleScheme extends TupleScheme<rename_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, rename_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, rename_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class reportBadBlocks_args implements org.apache.thrift.TBase<reportBadBlocks_args, reportBadBlocks_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("reportBadBlocks_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField BLOCKS_FIELD_DESC = new org.apache.thrift.protocol.TField("blocks", org.apache.thrift.protocol.TType.LIST, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new reportBadBlocks_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new reportBadBlocks_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * List of corrupted blocks.
     */
    public List<Block> blocks; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * List of corrupted blocks.
       */
      BLOCKS((short)1, "blocks");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // BLOCKS
            return BLOCKS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.BLOCKS, new org.apache.thrift.meta_data.FieldMetaData("blocks", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Block.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(reportBadBlocks_args.class, metaDataMap);
    }

    public reportBadBlocks_args() {
    }

    public reportBadBlocks_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      List<Block> blocks)
    {
      this();
      this.ctx = ctx;
      this.blocks = blocks;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public reportBadBlocks_args(reportBadBlocks_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetBlocks()) {
        List<Block> __this__blocks = new ArrayList<Block>();
        for (Block other_element : other.blocks) {
          __this__blocks.add(new Block(other_element));
        }
        this.blocks = __this__blocks;
      }
    }

    public reportBadBlocks_args deepCopy() {
      return new reportBadBlocks_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.blocks = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public reportBadBlocks_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public int getBlocksSize() {
      return (this.blocks == null) ? 0 : this.blocks.size();
    }

    public java.util.Iterator<Block> getBlocksIterator() {
      return (this.blocks == null) ? null : this.blocks.iterator();
    }

    public void addToBlocks(Block elem) {
      if (this.blocks == null) {
        this.blocks = new ArrayList<Block>();
      }
      this.blocks.add(elem);
    }

    /**
     * List of corrupted blocks.
     */
    public List<Block> getBlocks() {
      return this.blocks;
    }

    /**
     * List of corrupted blocks.
     */
    public reportBadBlocks_args setBlocks(List<Block> blocks) {
      this.blocks = blocks;
      return this;
    }

    public void unsetBlocks() {
      this.blocks = null;
    }

    /** Returns true if field blocks is set (has been assigned a value) and false otherwise */
    public boolean isSetBlocks() {
      return this.blocks != null;
    }

    public void setBlocksIsSet(boolean value) {
      if (!value) {
        this.blocks = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case BLOCKS:
        if (value == null) {
          unsetBlocks();
        } else {
          setBlocks((List<Block>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case BLOCKS:
        return getBlocks();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case BLOCKS:
        return isSetBlocks();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof reportBadBlocks_args)
        return this.equals((reportBadBlocks_args)that);
      return false;
    }

    public boolean equals(reportBadBlocks_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_blocks = true && this.isSetBlocks();
      boolean that_present_blocks = true && that.isSetBlocks();
      if (this_present_blocks || that_present_blocks) {
        if (!(this_present_blocks && that_present_blocks))
          return false;
        if (!this.blocks.equals(that.blocks))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(reportBadBlocks_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      reportBadBlocks_args typedOther = (reportBadBlocks_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBlocks()).compareTo(typedOther.isSetBlocks());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlocks()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blocks, typedOther.blocks);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("reportBadBlocks_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("blocks:");
      if (this.blocks == null) {
        sb.append("null");
      } else {
        sb.append(this.blocks);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class reportBadBlocks_argsStandardSchemeFactory implements SchemeFactory {
      public reportBadBlocks_argsStandardScheme getScheme() {
        return new reportBadBlocks_argsStandardScheme();
      }
    }

    private static class reportBadBlocks_argsStandardScheme extends StandardScheme<reportBadBlocks_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, reportBadBlocks_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // BLOCKS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list32 = iprot.readListBegin();
                  struct.blocks = new ArrayList<Block>(_list32.size);
                  for (int _i33 = 0; _i33 < _list32.size; ++_i33)
                  {
                    Block _elem34; // required
                    _elem34 = new Block();
                    _elem34.read(iprot);
                    struct.blocks.add(_elem34);
                  }
                  iprot.readListEnd();
                }
                struct.setBlocksIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, reportBadBlocks_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.blocks != null) {
          oprot.writeFieldBegin(BLOCKS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.blocks.size()));
            for (Block _iter35 : struct.blocks)
            {
              _iter35.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class reportBadBlocks_argsTupleSchemeFactory implements SchemeFactory {
      public reportBadBlocks_argsTupleScheme getScheme() {
        return new reportBadBlocks_argsTupleScheme();
      }
    }

    private static class reportBadBlocks_argsTupleScheme extends TupleScheme<reportBadBlocks_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, reportBadBlocks_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetBlocks()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetBlocks()) {
          {
            oprot.writeI32(struct.blocks.size());
            for (Block _iter36 : struct.blocks)
            {
              _iter36.write(oprot);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, reportBadBlocks_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TList _list37 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.blocks = new ArrayList<Block>(_list37.size);
            for (int _i38 = 0; _i38 < _list37.size; ++_i38)
            {
              Block _elem39; // required
              _elem39 = new Block();
              _elem39.read(iprot);
              struct.blocks.add(_elem39);
            }
          }
          struct.setBlocksIsSet(true);
        }
      }
    }

  }

  public static class reportBadBlocks_result implements org.apache.thrift.TBase<reportBadBlocks_result, reportBadBlocks_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("reportBadBlocks_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new reportBadBlocks_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new reportBadBlocks_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(reportBadBlocks_result.class, metaDataMap);
    }

    public reportBadBlocks_result() {
    }

    public reportBadBlocks_result(
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public reportBadBlocks_result(reportBadBlocks_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public reportBadBlocks_result deepCopy() {
      return new reportBadBlocks_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public reportBadBlocks_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof reportBadBlocks_result)
        return this.equals((reportBadBlocks_result)that);
      return false;
    }

    public boolean equals(reportBadBlocks_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(reportBadBlocks_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      reportBadBlocks_result typedOther = (reportBadBlocks_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("reportBadBlocks_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class reportBadBlocks_resultStandardSchemeFactory implements SchemeFactory {
      public reportBadBlocks_resultStandardScheme getScheme() {
        return new reportBadBlocks_resultStandardScheme();
      }
    }

    private static class reportBadBlocks_resultStandardScheme extends StandardScheme<reportBadBlocks_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, reportBadBlocks_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, reportBadBlocks_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class reportBadBlocks_resultTupleSchemeFactory implements SchemeFactory {
      public reportBadBlocks_resultTupleScheme getScheme() {
        return new reportBadBlocks_resultTupleScheme();
      }
    }

    private static class reportBadBlocks_resultTupleScheme extends TupleScheme<reportBadBlocks_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, reportBadBlocks_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, reportBadBlocks_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class stat_args implements org.apache.thrift.TBase<stat_args, stat_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("stat_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new stat_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new stat_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path of the file or directory.
     */
    public String path; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path of the file or directory.
       */
      PATH((short)1, "path");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(stat_args.class, metaDataMap);
    }

    public stat_args() {
    }

    public stat_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path)
    {
      this();
      this.ctx = ctx;
      this.path = path;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public stat_args(stat_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
    }

    public stat_args deepCopy() {
      return new stat_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public stat_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path of the file or directory.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path of the file or directory.
     */
    public stat_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof stat_args)
        return this.equals((stat_args)that);
      return false;
    }

    public boolean equals(stat_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(stat_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      stat_args typedOther = (stat_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("stat_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class stat_argsStandardSchemeFactory implements SchemeFactory {
      public stat_argsStandardScheme getScheme() {
        return new stat_argsStandardScheme();
      }
    }

    private static class stat_argsStandardScheme extends StandardScheme<stat_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, stat_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, stat_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class stat_argsTupleSchemeFactory implements SchemeFactory {
      public stat_argsTupleScheme getScheme() {
        return new stat_argsTupleScheme();
      }
    }

    private static class stat_argsTupleScheme extends TupleScheme<stat_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, stat_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, stat_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
      }
    }

  }

  public static class stat_result implements org.apache.thrift.TBase<stat_result, stat_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("stat_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new stat_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new stat_resultTupleSchemeFactory());
    }

    public Stat success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Stat.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(stat_result.class, metaDataMap);
    }

    public stat_result() {
    }

    public stat_result(
      Stat success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public stat_result(stat_result other) {
      if (other.isSetSuccess()) {
        this.success = new Stat(other.success);
      }
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public stat_result deepCopy() {
      return new stat_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public Stat getSuccess() {
      return this.success;
    }

    public stat_result setSuccess(Stat success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public stat_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Stat)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof stat_result)
        return this.equals((stat_result)that);
      return false;
    }

    public boolean equals(stat_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(stat_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      stat_result typedOther = (stat_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("stat_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class stat_resultStandardSchemeFactory implements SchemeFactory {
      public stat_resultStandardScheme getScheme() {
        return new stat_resultStandardScheme();
      }
    }

    private static class stat_resultStandardScheme extends StandardScheme<stat_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, stat_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Stat();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, stat_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class stat_resultTupleSchemeFactory implements SchemeFactory {
      public stat_resultTupleScheme getScheme() {
        return new stat_resultTupleScheme();
      }
    }

    private static class stat_resultTupleScheme extends TupleScheme<stat_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, stat_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, stat_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new Stat();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class getContentSummary_args implements org.apache.thrift.TBase<getContentSummary_args, getContentSummary_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getContentSummary_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("Path", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getContentSummary_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getContentSummary_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public String Path; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      PATH((short)1, "Path");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("Path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getContentSummary_args.class, metaDataMap);
    }

    public getContentSummary_args() {
    }

    public getContentSummary_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String Path)
    {
      this();
      this.ctx = ctx;
      this.Path = Path;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getContentSummary_args(getContentSummary_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.Path = other.Path;
      }
    }

    public getContentSummary_args deepCopy() {
      return new getContentSummary_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.Path = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getContentSummary_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public String getPath() {
      return this.Path;
    }

    public getContentSummary_args setPath(String Path) {
      this.Path = Path;
      return this;
    }

    public void unsetPath() {
      this.Path = null;
    }

    /** Returns true if field Path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.Path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.Path = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getContentSummary_args)
        return this.equals((getContentSummary_args)that);
      return false;
    }

    public boolean equals(getContentSummary_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_Path = true && this.isSetPath();
      boolean that_present_Path = true && that.isSetPath();
      if (this_present_Path || that_present_Path) {
        if (!(this_present_Path && that_present_Path))
          return false;
        if (!this.Path.equals(that.Path))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getContentSummary_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getContentSummary_args typedOther = (getContentSummary_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.Path, typedOther.Path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getContentSummary_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("Path:");
      if (this.Path == null) {
        sb.append("null");
      } else {
        sb.append(this.Path);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getContentSummary_argsStandardSchemeFactory implements SchemeFactory {
      public getContentSummary_argsStandardScheme getScheme() {
        return new getContentSummary_argsStandardScheme();
      }
    }

    private static class getContentSummary_argsStandardScheme extends StandardScheme<getContentSummary_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getContentSummary_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.Path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getContentSummary_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.Path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.Path);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getContentSummary_argsTupleSchemeFactory implements SchemeFactory {
      public getContentSummary_argsTupleScheme getScheme() {
        return new getContentSummary_argsTupleScheme();
      }
    }

    private static class getContentSummary_argsTupleScheme extends TupleScheme<getContentSummary_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getContentSummary_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.Path);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getContentSummary_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.Path = iprot.readString();
          struct.setPathIsSet(true);
        }
      }
    }

  }

  public static class getContentSummary_result implements org.apache.thrift.TBase<getContentSummary_result, getContentSummary_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getContentSummary_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getContentSummary_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getContentSummary_resultTupleSchemeFactory());
    }

    public ContentSummary success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ContentSummary.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getContentSummary_result.class, metaDataMap);
    }

    public getContentSummary_result() {
    }

    public getContentSummary_result(
      ContentSummary success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getContentSummary_result(getContentSummary_result other) {
      if (other.isSetSuccess()) {
        this.success = new ContentSummary(other.success);
      }
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public getContentSummary_result deepCopy() {
      return new getContentSummary_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public ContentSummary getSuccess() {
      return this.success;
    }

    public getContentSummary_result setSuccess(ContentSummary success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public getContentSummary_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ContentSummary)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getContentSummary_result)
        return this.equals((getContentSummary_result)that);
      return false;
    }

    public boolean equals(getContentSummary_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getContentSummary_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getContentSummary_result typedOther = (getContentSummary_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getContentSummary_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getContentSummary_resultStandardSchemeFactory implements SchemeFactory {
      public getContentSummary_resultStandardScheme getScheme() {
        return new getContentSummary_resultStandardScheme();
      }
    }

    private static class getContentSummary_resultStandardScheme extends StandardScheme<getContentSummary_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getContentSummary_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ContentSummary();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getContentSummary_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getContentSummary_resultTupleSchemeFactory implements SchemeFactory {
      public getContentSummary_resultTupleScheme getScheme() {
        return new getContentSummary_resultTupleScheme();
      }
    }

    private static class getContentSummary_resultTupleScheme extends TupleScheme<getContentSummary_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getContentSummary_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getContentSummary_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ContentSummary();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class multiGetContentSummary_args implements org.apache.thrift.TBase<multiGetContentSummary_args, multiGetContentSummary_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("multiGetContentSummary_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATHS_FIELD_DESC = new org.apache.thrift.protocol.TField("paths", org.apache.thrift.protocol.TType.LIST, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new multiGetContentSummary_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new multiGetContentSummary_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public List<String> paths; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      PATHS((short)1, "paths");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATHS
            return PATHS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATHS, new org.apache.thrift.meta_data.FieldMetaData("paths", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(multiGetContentSummary_args.class, metaDataMap);
    }

    public multiGetContentSummary_args() {
    }

    public multiGetContentSummary_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      List<String> paths)
    {
      this();
      this.ctx = ctx;
      this.paths = paths;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public multiGetContentSummary_args(multiGetContentSummary_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPaths()) {
        List<String> __this__paths = new ArrayList<String>();
        for (String other_element : other.paths) {
          __this__paths.add(other_element);
        }
        this.paths = __this__paths;
      }
    }

    public multiGetContentSummary_args deepCopy() {
      return new multiGetContentSummary_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.paths = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public multiGetContentSummary_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public int getPathsSize() {
      return (this.paths == null) ? 0 : this.paths.size();
    }

    public java.util.Iterator<String> getPathsIterator() {
      return (this.paths == null) ? null : this.paths.iterator();
    }

    public void addToPaths(String elem) {
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      this.paths.add(elem);
    }

    public List<String> getPaths() {
      return this.paths;
    }

    public multiGetContentSummary_args setPaths(List<String> paths) {
      this.paths = paths;
      return this;
    }

    public void unsetPaths() {
      this.paths = null;
    }

    /** Returns true if field paths is set (has been assigned a value) and false otherwise */
    public boolean isSetPaths() {
      return this.paths != null;
    }

    public void setPathsIsSet(boolean value) {
      if (!value) {
        this.paths = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATHS:
        if (value == null) {
          unsetPaths();
        } else {
          setPaths((List<String>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATHS:
        return getPaths();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATHS:
        return isSetPaths();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof multiGetContentSummary_args)
        return this.equals((multiGetContentSummary_args)that);
      return false;
    }

    public boolean equals(multiGetContentSummary_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_paths = true && this.isSetPaths();
      boolean that_present_paths = true && that.isSetPaths();
      if (this_present_paths || that_present_paths) {
        if (!(this_present_paths && that_present_paths))
          return false;
        if (!this.paths.equals(that.paths))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(multiGetContentSummary_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      multiGetContentSummary_args typedOther = (multiGetContentSummary_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPaths()).compareTo(typedOther.isSetPaths());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPaths()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.paths, typedOther.paths);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("multiGetContentSummary_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("paths:");
      if (this.paths == null) {
        sb.append("null");
      } else {
        sb.append(this.paths);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class multiGetContentSummary_argsStandardSchemeFactory implements SchemeFactory {
      public multiGetContentSummary_argsStandardScheme getScheme() {
        return new multiGetContentSummary_argsStandardScheme();
      }
    }

    private static class multiGetContentSummary_argsStandardScheme extends StandardScheme<multiGetContentSummary_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, multiGetContentSummary_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATHS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list40 = iprot.readListBegin();
                  struct.paths = new ArrayList<String>(_list40.size);
                  for (int _i41 = 0; _i41 < _list40.size; ++_i41)
                  {
                    String _elem42; // required
                    _elem42 = iprot.readString();
                    struct.paths.add(_elem42);
                  }
                  iprot.readListEnd();
                }
                struct.setPathsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, multiGetContentSummary_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.paths != null) {
          oprot.writeFieldBegin(PATHS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.paths.size()));
            for (String _iter43 : struct.paths)
            {
              oprot.writeString(_iter43);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class multiGetContentSummary_argsTupleSchemeFactory implements SchemeFactory {
      public multiGetContentSummary_argsTupleScheme getScheme() {
        return new multiGetContentSummary_argsTupleScheme();
      }
    }

    private static class multiGetContentSummary_argsTupleScheme extends TupleScheme<multiGetContentSummary_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, multiGetContentSummary_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPaths()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPaths()) {
          {
            oprot.writeI32(struct.paths.size());
            for (String _iter44 : struct.paths)
            {
              oprot.writeString(_iter44);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, multiGetContentSummary_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TList _list45 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.paths = new ArrayList<String>(_list45.size);
            for (int _i46 = 0; _i46 < _list45.size; ++_i46)
            {
              String _elem47; // required
              _elem47 = iprot.readString();
              struct.paths.add(_elem47);
            }
          }
          struct.setPathsIsSet(true);
        }
      }
    }

  }

  public static class multiGetContentSummary_result implements org.apache.thrift.TBase<multiGetContentSummary_result, multiGetContentSummary_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("multiGetContentSummary_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new multiGetContentSummary_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new multiGetContentSummary_resultTupleSchemeFactory());
    }

    public List<ContentSummary> success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ContentSummary.class))));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(multiGetContentSummary_result.class, metaDataMap);
    }

    public multiGetContentSummary_result() {
    }

    public multiGetContentSummary_result(
      List<ContentSummary> success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public multiGetContentSummary_result(multiGetContentSummary_result other) {
      if (other.isSetSuccess()) {
        List<ContentSummary> __this__success = new ArrayList<ContentSummary>();
        for (ContentSummary other_element : other.success) {
          __this__success.add(new ContentSummary(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public multiGetContentSummary_result deepCopy() {
      return new multiGetContentSummary_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<ContentSummary> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(ContentSummary elem) {
      if (this.success == null) {
        this.success = new ArrayList<ContentSummary>();
      }
      this.success.add(elem);
    }

    public List<ContentSummary> getSuccess() {
      return this.success;
    }

    public multiGetContentSummary_result setSuccess(List<ContentSummary> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public multiGetContentSummary_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<ContentSummary>)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof multiGetContentSummary_result)
        return this.equals((multiGetContentSummary_result)that);
      return false;
    }

    public boolean equals(multiGetContentSummary_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(multiGetContentSummary_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      multiGetContentSummary_result typedOther = (multiGetContentSummary_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("multiGetContentSummary_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class multiGetContentSummary_resultStandardSchemeFactory implements SchemeFactory {
      public multiGetContentSummary_resultStandardScheme getScheme() {
        return new multiGetContentSummary_resultStandardScheme();
      }
    }

    private static class multiGetContentSummary_resultStandardScheme extends StandardScheme<multiGetContentSummary_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, multiGetContentSummary_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list48 = iprot.readListBegin();
                  struct.success = new ArrayList<ContentSummary>(_list48.size);
                  for (int _i49 = 0; _i49 < _list48.size; ++_i49)
                  {
                    ContentSummary _elem50; // required
                    _elem50 = new ContentSummary();
                    _elem50.read(iprot);
                    struct.success.add(_elem50);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, multiGetContentSummary_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (ContentSummary _iter51 : struct.success)
            {
              _iter51.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class multiGetContentSummary_resultTupleSchemeFactory implements SchemeFactory {
      public multiGetContentSummary_resultTupleScheme getScheme() {
        return new multiGetContentSummary_resultTupleScheme();
      }
    }

    private static class multiGetContentSummary_resultTupleScheme extends TupleScheme<multiGetContentSummary_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, multiGetContentSummary_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (ContentSummary _iter52 : struct.success)
            {
              _iter52.write(oprot);
            }
          }
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, multiGetContentSummary_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list53 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<ContentSummary>(_list53.size);
            for (int _i54 = 0; _i54 < _list53.size; ++_i54)
            {
              ContentSummary _elem55; // required
              _elem55 = new ContentSummary();
              _elem55.read(iprot);
              struct.success.add(_elem55);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class setQuota_args implements org.apache.thrift.TBase<setQuota_args, setQuota_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setQuota_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField NAMESPACE_QUOTA_FIELD_DESC = new org.apache.thrift.protocol.TField("namespaceQuota", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField DISKSPACE_QUOTA_FIELD_DESC = new org.apache.thrift.protocol.TField("diskspaceQuota", org.apache.thrift.protocol.TType.I64, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setQuota_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setQuota_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path of the directory.
     */
    public String path; // required
    /**
     * Limit on the number of names in the directory.
     */
    public long namespaceQuota; // required
    /**
     * Limit on disk space occupied by all the files in the
     * directory.
     */
    public long diskspaceQuota; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path of the directory.
       */
      PATH((short)1, "path"),
      /**
       * Limit on the number of names in the directory.
       */
      NAMESPACE_QUOTA((short)2, "namespaceQuota"),
      /**
       * Limit on disk space occupied by all the files in the
       * directory.
       */
      DISKSPACE_QUOTA((short)3, "diskspaceQuota");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          case 2: // NAMESPACE_QUOTA
            return NAMESPACE_QUOTA;
          case 3: // DISKSPACE_QUOTA
            return DISKSPACE_QUOTA;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __NAMESPACEQUOTA_ISSET_ID = 0;
    private static final int __DISKSPACEQUOTA_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.NAMESPACE_QUOTA, new org.apache.thrift.meta_data.FieldMetaData("namespaceQuota", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.DISKSPACE_QUOTA, new org.apache.thrift.meta_data.FieldMetaData("diskspaceQuota", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setQuota_args.class, metaDataMap);
    }

    public setQuota_args() {
    }

    public setQuota_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path,
      long namespaceQuota,
      long diskspaceQuota)
    {
      this();
      this.ctx = ctx;
      this.path = path;
      this.namespaceQuota = namespaceQuota;
      setNamespaceQuotaIsSet(true);
      this.diskspaceQuota = diskspaceQuota;
      setDiskspaceQuotaIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setQuota_args(setQuota_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
      this.namespaceQuota = other.namespaceQuota;
      this.diskspaceQuota = other.diskspaceQuota;
    }

    public setQuota_args deepCopy() {
      return new setQuota_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
      setNamespaceQuotaIsSet(false);
      this.namespaceQuota = 0;
      setDiskspaceQuotaIsSet(false);
      this.diskspaceQuota = 0;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public setQuota_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path of the directory.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path of the directory.
     */
    public setQuota_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     * Limit on the number of names in the directory.
     */
    public long getNamespaceQuota() {
      return this.namespaceQuota;
    }

    /**
     * Limit on the number of names in the directory.
     */
    public setQuota_args setNamespaceQuota(long namespaceQuota) {
      this.namespaceQuota = namespaceQuota;
      setNamespaceQuotaIsSet(true);
      return this;
    }

    public void unsetNamespaceQuota() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __NAMESPACEQUOTA_ISSET_ID);
    }

    /** Returns true if field namespaceQuota is set (has been assigned a value) and false otherwise */
    public boolean isSetNamespaceQuota() {
      return EncodingUtils.testBit(__isset_bitfield, __NAMESPACEQUOTA_ISSET_ID);
    }

    public void setNamespaceQuotaIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __NAMESPACEQUOTA_ISSET_ID, value);
    }

    /**
     * Limit on disk space occupied by all the files in the
     * directory.
     */
    public long getDiskspaceQuota() {
      return this.diskspaceQuota;
    }

    /**
     * Limit on disk space occupied by all the files in the
     * directory.
     */
    public setQuota_args setDiskspaceQuota(long diskspaceQuota) {
      this.diskspaceQuota = diskspaceQuota;
      setDiskspaceQuotaIsSet(true);
      return this;
    }

    public void unsetDiskspaceQuota() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __DISKSPACEQUOTA_ISSET_ID);
    }

    /** Returns true if field diskspaceQuota is set (has been assigned a value) and false otherwise */
    public boolean isSetDiskspaceQuota() {
      return EncodingUtils.testBit(__isset_bitfield, __DISKSPACEQUOTA_ISSET_ID);
    }

    public void setDiskspaceQuotaIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __DISKSPACEQUOTA_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case NAMESPACE_QUOTA:
        if (value == null) {
          unsetNamespaceQuota();
        } else {
          setNamespaceQuota((Long)value);
        }
        break;

      case DISKSPACE_QUOTA:
        if (value == null) {
          unsetDiskspaceQuota();
        } else {
          setDiskspaceQuota((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      case NAMESPACE_QUOTA:
        return Long.valueOf(getNamespaceQuota());

      case DISKSPACE_QUOTA:
        return Long.valueOf(getDiskspaceQuota());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      case NAMESPACE_QUOTA:
        return isSetNamespaceQuota();
      case DISKSPACE_QUOTA:
        return isSetDiskspaceQuota();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setQuota_args)
        return this.equals((setQuota_args)that);
      return false;
    }

    public boolean equals(setQuota_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_namespaceQuota = true;
      boolean that_present_namespaceQuota = true;
      if (this_present_namespaceQuota || that_present_namespaceQuota) {
        if (!(this_present_namespaceQuota && that_present_namespaceQuota))
          return false;
        if (this.namespaceQuota != that.namespaceQuota)
          return false;
      }

      boolean this_present_diskspaceQuota = true;
      boolean that_present_diskspaceQuota = true;
      if (this_present_diskspaceQuota || that_present_diskspaceQuota) {
        if (!(this_present_diskspaceQuota && that_present_diskspaceQuota))
          return false;
        if (this.diskspaceQuota != that.diskspaceQuota)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(setQuota_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      setQuota_args typedOther = (setQuota_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNamespaceQuota()).compareTo(typedOther.isSetNamespaceQuota());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNamespaceQuota()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.namespaceQuota, typedOther.namespaceQuota);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetDiskspaceQuota()).compareTo(typedOther.isSetDiskspaceQuota());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDiskspaceQuota()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.diskspaceQuota, typedOther.diskspaceQuota);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setQuota_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("namespaceQuota:");
      sb.append(this.namespaceQuota);
      first = false;
      if (!first) sb.append(", ");
      sb.append("diskspaceQuota:");
      sb.append(this.diskspaceQuota);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setQuota_argsStandardSchemeFactory implements SchemeFactory {
      public setQuota_argsStandardScheme getScheme() {
        return new setQuota_argsStandardScheme();
      }
    }

    private static class setQuota_argsStandardScheme extends StandardScheme<setQuota_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setQuota_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NAMESPACE_QUOTA
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.namespaceQuota = iprot.readI64();
                struct.setNamespaceQuotaIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // DISKSPACE_QUOTA
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.diskspaceQuota = iprot.readI64();
                struct.setDiskspaceQuotaIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setQuota_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(NAMESPACE_QUOTA_FIELD_DESC);
        oprot.writeI64(struct.namespaceQuota);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(DISKSPACE_QUOTA_FIELD_DESC);
        oprot.writeI64(struct.diskspaceQuota);
        oprot.writeFieldEnd();
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setQuota_argsTupleSchemeFactory implements SchemeFactory {
      public setQuota_argsTupleScheme getScheme() {
        return new setQuota_argsTupleScheme();
      }
    }

    private static class setQuota_argsTupleScheme extends TupleScheme<setQuota_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setQuota_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetNamespaceQuota()) {
          optionals.set(2);
        }
        if (struct.isSetDiskspaceQuota()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetNamespaceQuota()) {
          oprot.writeI64(struct.namespaceQuota);
        }
        if (struct.isSetDiskspaceQuota()) {
          oprot.writeI64(struct.diskspaceQuota);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setQuota_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.namespaceQuota = iprot.readI64();
          struct.setNamespaceQuotaIsSet(true);
        }
        if (incoming.get(3)) {
          struct.diskspaceQuota = iprot.readI64();
          struct.setDiskspaceQuotaIsSet(true);
        }
      }
    }

  }

  public static class setQuota_result implements org.apache.thrift.TBase<setQuota_result, setQuota_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setQuota_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setQuota_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setQuota_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setQuota_result.class, metaDataMap);
    }

    public setQuota_result() {
    }

    public setQuota_result(
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setQuota_result(setQuota_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public setQuota_result deepCopy() {
      return new setQuota_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public setQuota_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setQuota_result)
        return this.equals((setQuota_result)that);
      return false;
    }

    public boolean equals(setQuota_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(setQuota_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      setQuota_result typedOther = (setQuota_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setQuota_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setQuota_resultStandardSchemeFactory implements SchemeFactory {
      public setQuota_resultStandardScheme getScheme() {
        return new setQuota_resultStandardScheme();
      }
    }

    private static class setQuota_resultStandardScheme extends StandardScheme<setQuota_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setQuota_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setQuota_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setQuota_resultTupleSchemeFactory implements SchemeFactory {
      public setQuota_resultTupleScheme getScheme() {
        return new setQuota_resultTupleScheme();
      }
    }

    private static class setQuota_resultTupleScheme extends TupleScheme<setQuota_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setQuota_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setQuota_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class setReplication_args implements org.apache.thrift.TBase<setReplication_args, setReplication_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setReplication_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField REPLICATION_FIELD_DESC = new org.apache.thrift.protocol.TField("replication", org.apache.thrift.protocol.TType.I16, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setReplication_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setReplication_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path of the file.
     */
    public String path; // required
    /**
     * New replication factor.
     */
    public short replication; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path of the file.
       */
      PATH((short)1, "path"),
      /**
       * New replication factor.
       */
      REPLICATION((short)2, "replication");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          case 2: // REPLICATION
            return REPLICATION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __REPLICATION_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.REPLICATION, new org.apache.thrift.meta_data.FieldMetaData("replication", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I16)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setReplication_args.class, metaDataMap);
    }

    public setReplication_args() {
    }

    public setReplication_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path,
      short replication)
    {
      this();
      this.ctx = ctx;
      this.path = path;
      this.replication = replication;
      setReplicationIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setReplication_args(setReplication_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
      this.replication = other.replication;
    }

    public setReplication_args deepCopy() {
      return new setReplication_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
      setReplicationIsSet(false);
      this.replication = 0;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public setReplication_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path of the file.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path of the file.
     */
    public setReplication_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     * New replication factor.
     */
    public short getReplication() {
      return this.replication;
    }

    /**
     * New replication factor.
     */
    public setReplication_args setReplication(short replication) {
      this.replication = replication;
      setReplicationIsSet(true);
      return this;
    }

    public void unsetReplication() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __REPLICATION_ISSET_ID);
    }

    /** Returns true if field replication is set (has been assigned a value) and false otherwise */
    public boolean isSetReplication() {
      return EncodingUtils.testBit(__isset_bitfield, __REPLICATION_ISSET_ID);
    }

    public void setReplicationIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __REPLICATION_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case REPLICATION:
        if (value == null) {
          unsetReplication();
        } else {
          setReplication((Short)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      case REPLICATION:
        return Short.valueOf(getReplication());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      case REPLICATION:
        return isSetReplication();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setReplication_args)
        return this.equals((setReplication_args)that);
      return false;
    }

    public boolean equals(setReplication_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_replication = true;
      boolean that_present_replication = true;
      if (this_present_replication || that_present_replication) {
        if (!(this_present_replication && that_present_replication))
          return false;
        if (this.replication != that.replication)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(setReplication_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      setReplication_args typedOther = (setReplication_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetReplication()).compareTo(typedOther.isSetReplication());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetReplication()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.replication, typedOther.replication);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setReplication_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("replication:");
      sb.append(this.replication);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setReplication_argsStandardSchemeFactory implements SchemeFactory {
      public setReplication_argsStandardScheme getScheme() {
        return new setReplication_argsStandardScheme();
      }
    }

    private static class setReplication_argsStandardScheme extends StandardScheme<setReplication_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setReplication_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // REPLICATION
              if (schemeField.type == org.apache.thrift.protocol.TType.I16) {
                struct.replication = iprot.readI16();
                struct.setReplicationIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setReplication_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(REPLICATION_FIELD_DESC);
        oprot.writeI16(struct.replication);
        oprot.writeFieldEnd();
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setReplication_argsTupleSchemeFactory implements SchemeFactory {
      public setReplication_argsTupleScheme getScheme() {
        return new setReplication_argsTupleScheme();
      }
    }

    private static class setReplication_argsTupleScheme extends TupleScheme<setReplication_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setReplication_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetReplication()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetReplication()) {
          oprot.writeI16(struct.replication);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setReplication_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.replication = iprot.readI16();
          struct.setReplicationIsSet(true);
        }
      }
    }

  }

  public static class setReplication_result implements org.apache.thrift.TBase<setReplication_result, setReplication_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("setReplication_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new setReplication_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new setReplication_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(setReplication_result.class, metaDataMap);
    }

    public setReplication_result() {
    }

    public setReplication_result(
      boolean success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public setReplication_result(setReplication_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public setReplication_result deepCopy() {
      return new setReplication_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.err = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public setReplication_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public setReplication_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setReplication_result)
        return this.equals((setReplication_result)that);
      return false;
    }

    public boolean equals(setReplication_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(setReplication_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      setReplication_result typedOther = (setReplication_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("setReplication_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class setReplication_resultStandardSchemeFactory implements SchemeFactory {
      public setReplication_resultStandardScheme getScheme() {
        return new setReplication_resultStandardScheme();
      }
    }

    private static class setReplication_resultStandardScheme extends StandardScheme<setReplication_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, setReplication_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, setReplication_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class setReplication_resultTupleSchemeFactory implements SchemeFactory {
      public setReplication_resultTupleScheme getScheme() {
        return new setReplication_resultTupleScheme();
      }
    }

    private static class setReplication_resultTupleScheme extends TupleScheme<setReplication_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, setReplication_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, setReplication_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class unlink_args implements org.apache.thrift.TBase<unlink_args, unlink_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("unlink_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField RECURSIVE_FIELD_DESC = new org.apache.thrift.protocol.TField("recursive", org.apache.thrift.protocol.TType.BOOL, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new unlink_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new unlink_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path of the file or directory.
     */
    public String path; // required
    /**
     * Delete a non-empty directory recursively.
     */
    public boolean recursive; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path of the file or directory.
       */
      PATH((short)1, "path"),
      /**
       * Delete a non-empty directory recursively.
       */
      RECURSIVE((short)2, "recursive");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          case 2: // RECURSIVE
            return RECURSIVE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __RECURSIVE_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.RECURSIVE, new org.apache.thrift.meta_data.FieldMetaData("recursive", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(unlink_args.class, metaDataMap);
    }

    public unlink_args() {
    }

    public unlink_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path,
      boolean recursive)
    {
      this();
      this.ctx = ctx;
      this.path = path;
      this.recursive = recursive;
      setRecursiveIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public unlink_args(unlink_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
      this.recursive = other.recursive;
    }

    public unlink_args deepCopy() {
      return new unlink_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
      setRecursiveIsSet(false);
      this.recursive = false;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public unlink_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path of the file or directory.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path of the file or directory.
     */
    public unlink_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     * Delete a non-empty directory recursively.
     */
    public boolean isRecursive() {
      return this.recursive;
    }

    /**
     * Delete a non-empty directory recursively.
     */
    public unlink_args setRecursive(boolean recursive) {
      this.recursive = recursive;
      setRecursiveIsSet(true);
      return this;
    }

    public void unsetRecursive() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __RECURSIVE_ISSET_ID);
    }

    /** Returns true if field recursive is set (has been assigned a value) and false otherwise */
    public boolean isSetRecursive() {
      return EncodingUtils.testBit(__isset_bitfield, __RECURSIVE_ISSET_ID);
    }

    public void setRecursiveIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __RECURSIVE_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case RECURSIVE:
        if (value == null) {
          unsetRecursive();
        } else {
          setRecursive((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      case RECURSIVE:
        return Boolean.valueOf(isRecursive());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      case RECURSIVE:
        return isSetRecursive();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof unlink_args)
        return this.equals((unlink_args)that);
      return false;
    }

    public boolean equals(unlink_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_recursive = true;
      boolean that_present_recursive = true;
      if (this_present_recursive || that_present_recursive) {
        if (!(this_present_recursive && that_present_recursive))
          return false;
        if (this.recursive != that.recursive)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(unlink_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      unlink_args typedOther = (unlink_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRecursive()).compareTo(typedOther.isSetRecursive());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRecursive()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.recursive, typedOther.recursive);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("unlink_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("recursive:");
      sb.append(this.recursive);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class unlink_argsStandardSchemeFactory implements SchemeFactory {
      public unlink_argsStandardScheme getScheme() {
        return new unlink_argsStandardScheme();
      }
    }

    private static class unlink_argsStandardScheme extends StandardScheme<unlink_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, unlink_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // RECURSIVE
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.recursive = iprot.readBool();
                struct.setRecursiveIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, unlink_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(RECURSIVE_FIELD_DESC);
        oprot.writeBool(struct.recursive);
        oprot.writeFieldEnd();
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class unlink_argsTupleSchemeFactory implements SchemeFactory {
      public unlink_argsTupleScheme getScheme() {
        return new unlink_argsTupleScheme();
      }
    }

    private static class unlink_argsTupleScheme extends TupleScheme<unlink_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, unlink_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetRecursive()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetRecursive()) {
          oprot.writeBool(struct.recursive);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, unlink_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.recursive = iprot.readBool();
          struct.setRecursiveIsSet(true);
        }
      }
    }

  }

  public static class unlink_result implements org.apache.thrift.TBase<unlink_result, unlink_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("unlink_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new unlink_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new unlink_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(unlink_result.class, metaDataMap);
    }

    public unlink_result() {
    }

    public unlink_result(
      boolean success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public unlink_result(unlink_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public unlink_result deepCopy() {
      return new unlink_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.err = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public unlink_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public unlink_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof unlink_result)
        return this.equals((unlink_result)that);
      return false;
    }

    public boolean equals(unlink_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(unlink_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      unlink_result typedOther = (unlink_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("unlink_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class unlink_resultStandardSchemeFactory implements SchemeFactory {
      public unlink_resultStandardScheme getScheme() {
        return new unlink_resultStandardScheme();
      }
    }

    private static class unlink_resultStandardScheme extends StandardScheme<unlink_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, unlink_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, unlink_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class unlink_resultTupleSchemeFactory implements SchemeFactory {
      public unlink_resultTupleScheme getScheme() {
        return new unlink_resultTupleScheme();
      }
    }

    private static class unlink_resultTupleScheme extends TupleScheme<unlink_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, unlink_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, unlink_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class utime_args implements org.apache.thrift.TBase<utime_args, utime_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("utime_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ATIME_FIELD_DESC = new org.apache.thrift.protocol.TField("atime", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField MTIME_FIELD_DESC = new org.apache.thrift.protocol.TField("mtime", org.apache.thrift.protocol.TType.I64, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new utime_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new utime_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    /**
     * Path of the file or directory.
     */
    public String path; // required
    /**
     * Access time in milliseconds since 1970-01-01 00:00 UTC
     */
    public long atime; // required
    /**
     * Modification time in milliseconds since 1970-01-01 00:00 UTC
     */
    public long mtime; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      /**
       * Path of the file or directory.
       */
      PATH((short)1, "path"),
      /**
       * Access time in milliseconds since 1970-01-01 00:00 UTC
       */
      ATIME((short)2, "atime"),
      /**
       * Modification time in milliseconds since 1970-01-01 00:00 UTC
       */
      MTIME((short)3, "mtime");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // PATH
            return PATH;
          case 2: // ATIME
            return ATIME;
          case 3: // MTIME
            return MTIME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __ATIME_ISSET_ID = 0;
    private static final int __MTIME_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.ATIME, new org.apache.thrift.meta_data.FieldMetaData("atime", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.MTIME, new org.apache.thrift.meta_data.FieldMetaData("mtime", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(utime_args.class, metaDataMap);
    }

    public utime_args() {
    }

    public utime_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String path,
      long atime,
      long mtime)
    {
      this();
      this.ctx = ctx;
      this.path = path;
      this.atime = atime;
      setAtimeIsSet(true);
      this.mtime = mtime;
      setMtimeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public utime_args(utime_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetPath()) {
        this.path = other.path;
      }
      this.atime = other.atime;
      this.mtime = other.mtime;
    }

    public utime_args deepCopy() {
      return new utime_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.path = null;
      setAtimeIsSet(false);
      this.atime = 0;
      setMtimeIsSet(false);
      this.mtime = 0;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public utime_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    /**
     * Path of the file or directory.
     */
    public String getPath() {
      return this.path;
    }

    /**
     * Path of the file or directory.
     */
    public utime_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     * Access time in milliseconds since 1970-01-01 00:00 UTC
     */
    public long getAtime() {
      return this.atime;
    }

    /**
     * Access time in milliseconds since 1970-01-01 00:00 UTC
     */
    public utime_args setAtime(long atime) {
      this.atime = atime;
      setAtimeIsSet(true);
      return this;
    }

    public void unsetAtime() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __ATIME_ISSET_ID);
    }

    /** Returns true if field atime is set (has been assigned a value) and false otherwise */
    public boolean isSetAtime() {
      return EncodingUtils.testBit(__isset_bitfield, __ATIME_ISSET_ID);
    }

    public void setAtimeIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __ATIME_ISSET_ID, value);
    }

    /**
     * Modification time in milliseconds since 1970-01-01 00:00 UTC
     */
    public long getMtime() {
      return this.mtime;
    }

    /**
     * Modification time in milliseconds since 1970-01-01 00:00 UTC
     */
    public utime_args setMtime(long mtime) {
      this.mtime = mtime;
      setMtimeIsSet(true);
      return this;
    }

    public void unsetMtime() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __MTIME_ISSET_ID);
    }

    /** Returns true if field mtime is set (has been assigned a value) and false otherwise */
    public boolean isSetMtime() {
      return EncodingUtils.testBit(__isset_bitfield, __MTIME_ISSET_ID);
    }

    public void setMtimeIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __MTIME_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case ATIME:
        if (value == null) {
          unsetAtime();
        } else {
          setAtime((Long)value);
        }
        break;

      case MTIME:
        if (value == null) {
          unsetMtime();
        } else {
          setMtime((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case PATH:
        return getPath();

      case ATIME:
        return Long.valueOf(getAtime());

      case MTIME:
        return Long.valueOf(getMtime());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case PATH:
        return isSetPath();
      case ATIME:
        return isSetAtime();
      case MTIME:
        return isSetMtime();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof utime_args)
        return this.equals((utime_args)that);
      return false;
    }

    public boolean equals(utime_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_atime = true;
      boolean that_present_atime = true;
      if (this_present_atime || that_present_atime) {
        if (!(this_present_atime && that_present_atime))
          return false;
        if (this.atime != that.atime)
          return false;
      }

      boolean this_present_mtime = true;
      boolean that_present_mtime = true;
      if (this_present_mtime || that_present_mtime) {
        if (!(this_present_mtime && that_present_mtime))
          return false;
        if (this.mtime != that.mtime)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(utime_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      utime_args typedOther = (utime_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAtime()).compareTo(typedOther.isSetAtime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAtime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.atime, typedOther.atime);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetMtime()).compareTo(typedOther.isSetMtime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMtime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mtime, typedOther.mtime);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("utime_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("atime:");
      sb.append(this.atime);
      first = false;
      if (!first) sb.append(", ");
      sb.append("mtime:");
      sb.append(this.mtime);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class utime_argsStandardSchemeFactory implements SchemeFactory {
      public utime_argsStandardScheme getScheme() {
        return new utime_argsStandardScheme();
      }
    }

    private static class utime_argsStandardScheme extends StandardScheme<utime_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, utime_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ATIME
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.atime = iprot.readI64();
                struct.setAtimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // MTIME
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.mtime = iprot.readI64();
                struct.setMtimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, utime_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(ATIME_FIELD_DESC);
        oprot.writeI64(struct.atime);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(MTIME_FIELD_DESC);
        oprot.writeI64(struct.mtime);
        oprot.writeFieldEnd();
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class utime_argsTupleSchemeFactory implements SchemeFactory {
      public utime_argsTupleScheme getScheme() {
        return new utime_argsTupleScheme();
      }
    }

    private static class utime_argsTupleScheme extends TupleScheme<utime_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, utime_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetAtime()) {
          optionals.set(2);
        }
        if (struct.isSetMtime()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetAtime()) {
          oprot.writeI64(struct.atime);
        }
        if (struct.isSetMtime()) {
          oprot.writeI64(struct.mtime);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, utime_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.atime = iprot.readI64();
          struct.setAtimeIsSet(true);
        }
        if (incoming.get(3)) {
          struct.mtime = iprot.readI64();
          struct.setMtimeIsSet(true);
        }
      }
    }

  }

  public static class utime_result implements org.apache.thrift.TBase<utime_result, utime_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("utime_result");

    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new utime_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new utime_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(utime_result.class, metaDataMap);
    }

    public utime_result() {
    }

    public utime_result(
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public utime_result(utime_result other) {
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public utime_result deepCopy() {
      return new utime_result(this);
    }

    @Override
    public void clear() {
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public utime_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof utime_result)
        return this.equals((utime_result)that);
      return false;
    }

    public boolean equals(utime_result that) {
      if (that == null)
        return false;

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(utime_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      utime_result typedOther = (utime_result)other;

      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("utime_result(");
      boolean first = true;

      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class utime_resultStandardSchemeFactory implements SchemeFactory {
      public utime_resultStandardScheme getScheme() {
        return new utime_resultStandardScheme();
      }
    }

    private static class utime_resultStandardScheme extends StandardScheme<utime_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, utime_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, utime_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class utime_resultTupleSchemeFactory implements SchemeFactory {
      public utime_resultTupleScheme getScheme() {
        return new utime_resultTupleScheme();
      }
    }

    private static class utime_resultTupleScheme extends TupleScheme<utime_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, utime_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetErr()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, utime_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

  public static class datanodeUp_args implements org.apache.thrift.TBase<datanodeUp_args, datanodeUp_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("datanodeUp_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField STORAGE_FIELD_DESC = new org.apache.thrift.protocol.TField("storage", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField THRIFT_PORT_FIELD_DESC = new org.apache.thrift.protocol.TField("thriftPort", org.apache.thrift.protocol.TType.I32, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new datanodeUp_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new datanodeUp_argsTupleSchemeFactory());
    }

    /**
     * <host name>:<port number> of the datanode
     */
    public String name; // required
    /**
     * the storage id of the datanode
     */
    public String storage; // required
    /**
     * Thrift port of the datanode
     */
    public int thriftPort; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * <host name>:<port number> of the datanode
       */
      NAME((short)1, "name"),
      /**
       * the storage id of the datanode
       */
      STORAGE((short)2, "storage"),
      /**
       * Thrift port of the datanode
       */
      THRIFT_PORT((short)3, "thriftPort");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // STORAGE
            return STORAGE;
          case 3: // THRIFT_PORT
            return THRIFT_PORT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __THRIFTPORT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.STORAGE, new org.apache.thrift.meta_data.FieldMetaData("storage", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.THRIFT_PORT, new org.apache.thrift.meta_data.FieldMetaData("thriftPort", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(datanodeUp_args.class, metaDataMap);
    }

    public datanodeUp_args() {
    }

    public datanodeUp_args(
      String name,
      String storage,
      int thriftPort)
    {
      this();
      this.name = name;
      this.storage = storage;
      this.thriftPort = thriftPort;
      setThriftPortIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public datanodeUp_args(datanodeUp_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetName()) {
        this.name = other.name;
      }
      if (other.isSetStorage()) {
        this.storage = other.storage;
      }
      this.thriftPort = other.thriftPort;
    }

    public datanodeUp_args deepCopy() {
      return new datanodeUp_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.storage = null;
      setThriftPortIsSet(false);
      this.thriftPort = 0;
    }

    /**
     * <host name>:<port number> of the datanode
     */
    public String getName() {
      return this.name;
    }

    /**
     * <host name>:<port number> of the datanode
     */
    public datanodeUp_args setName(String name) {
      this.name = name;
      return this;
    }

    public void unsetName() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean isSetName() {
      return this.name != null;
    }

    public void setNameIsSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    /**
     * the storage id of the datanode
     */
    public String getStorage() {
      return this.storage;
    }

    /**
     * the storage id of the datanode
     */
    public datanodeUp_args setStorage(String storage) {
      this.storage = storage;
      return this;
    }

    public void unsetStorage() {
      this.storage = null;
    }

    /** Returns true if field storage is set (has been assigned a value) and false otherwise */
    public boolean isSetStorage() {
      return this.storage != null;
    }

    public void setStorageIsSet(boolean value) {
      if (!value) {
        this.storage = null;
      }
    }

    /**
     * Thrift port of the datanode
     */
    public int getThriftPort() {
      return this.thriftPort;
    }

    /**
     * Thrift port of the datanode
     */
    public datanodeUp_args setThriftPort(int thriftPort) {
      this.thriftPort = thriftPort;
      setThriftPortIsSet(true);
      return this;
    }

    public void unsetThriftPort() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __THRIFTPORT_ISSET_ID);
    }

    /** Returns true if field thriftPort is set (has been assigned a value) and false otherwise */
    public boolean isSetThriftPort() {
      return EncodingUtils.testBit(__isset_bitfield, __THRIFTPORT_ISSET_ID);
    }

    public void setThriftPortIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __THRIFTPORT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unsetName();
        } else {
          setName((String)value);
        }
        break;

      case STORAGE:
        if (value == null) {
          unsetStorage();
        } else {
          setStorage((String)value);
        }
        break;

      case THRIFT_PORT:
        if (value == null) {
          unsetThriftPort();
        } else {
          setThriftPort((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return getName();

      case STORAGE:
        return getStorage();

      case THRIFT_PORT:
        return Integer.valueOf(getThriftPort());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return isSetName();
      case STORAGE:
        return isSetStorage();
      case THRIFT_PORT:
        return isSetThriftPort();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof datanodeUp_args)
        return this.equals((datanodeUp_args)that);
      return false;
    }

    public boolean equals(datanodeUp_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.isSetName();
      boolean that_present_name = true && that.isSetName();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_storage = true && this.isSetStorage();
      boolean that_present_storage = true && that.isSetStorage();
      if (this_present_storage || that_present_storage) {
        if (!(this_present_storage && that_present_storage))
          return false;
        if (!this.storage.equals(that.storage))
          return false;
      }

      boolean this_present_thriftPort = true;
      boolean that_present_thriftPort = true;
      if (this_present_thriftPort || that_present_thriftPort) {
        if (!(this_present_thriftPort && that_present_thriftPort))
          return false;
        if (this.thriftPort != that.thriftPort)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(datanodeUp_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      datanodeUp_args typedOther = (datanodeUp_args)other;

      lastComparison = Boolean.valueOf(isSetName()).compareTo(typedOther.isSetName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, typedOther.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetStorage()).compareTo(typedOther.isSetStorage());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStorage()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.storage, typedOther.storage);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetThriftPort()).compareTo(typedOther.isSetThriftPort());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetThriftPort()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.thriftPort, typedOther.thriftPort);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("datanodeUp_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("storage:");
      if (this.storage == null) {
        sb.append("null");
      } else {
        sb.append(this.storage);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("thriftPort:");
      sb.append(this.thriftPort);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class datanodeUp_argsStandardSchemeFactory implements SchemeFactory {
      public datanodeUp_argsStandardScheme getScheme() {
        return new datanodeUp_argsStandardScheme();
      }
    }

    private static class datanodeUp_argsStandardScheme extends StandardScheme<datanodeUp_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, datanodeUp_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // STORAGE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.storage = iprot.readString();
                struct.setStorageIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // THRIFT_PORT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.thriftPort = iprot.readI32();
                struct.setThriftPortIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, datanodeUp_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.storage != null) {
          oprot.writeFieldBegin(STORAGE_FIELD_DESC);
          oprot.writeString(struct.storage);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(THRIFT_PORT_FIELD_DESC);
        oprot.writeI32(struct.thriftPort);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class datanodeUp_argsTupleSchemeFactory implements SchemeFactory {
      public datanodeUp_argsTupleScheme getScheme() {
        return new datanodeUp_argsTupleScheme();
      }
    }

    private static class datanodeUp_argsTupleScheme extends TupleScheme<datanodeUp_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, datanodeUp_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetName()) {
          optionals.set(0);
        }
        if (struct.isSetStorage()) {
          optionals.set(1);
        }
        if (struct.isSetThriftPort()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetName()) {
          oprot.writeString(struct.name);
        }
        if (struct.isSetStorage()) {
          oprot.writeString(struct.storage);
        }
        if (struct.isSetThriftPort()) {
          oprot.writeI32(struct.thriftPort);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, datanodeUp_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.setNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.storage = iprot.readString();
          struct.setStorageIsSet(true);
        }
        if (incoming.get(2)) {
          struct.thriftPort = iprot.readI32();
          struct.setThriftPortIsSet(true);
        }
      }
    }

  }

  public static class datanodeUp_result implements org.apache.thrift.TBase<datanodeUp_result, datanodeUp_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("datanodeUp_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new datanodeUp_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new datanodeUp_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(datanodeUp_result.class, metaDataMap);
    }

    public datanodeUp_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public datanodeUp_result(datanodeUp_result other) {
    }

    public datanodeUp_result deepCopy() {
      return new datanodeUp_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof datanodeUp_result)
        return this.equals((datanodeUp_result)that);
      return false;
    }

    public boolean equals(datanodeUp_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(datanodeUp_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      datanodeUp_result typedOther = (datanodeUp_result)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("datanodeUp_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class datanodeUp_resultStandardSchemeFactory implements SchemeFactory {
      public datanodeUp_resultStandardScheme getScheme() {
        return new datanodeUp_resultStandardScheme();
      }
    }

    private static class datanodeUp_resultStandardScheme extends StandardScheme<datanodeUp_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, datanodeUp_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, datanodeUp_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class datanodeUp_resultTupleSchemeFactory implements SchemeFactory {
      public datanodeUp_resultTupleScheme getScheme() {
        return new datanodeUp_resultTupleScheme();
      }
    }

    private static class datanodeUp_resultTupleScheme extends TupleScheme<datanodeUp_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, datanodeUp_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, datanodeUp_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class datanodeDown_args implements org.apache.thrift.TBase<datanodeDown_args, datanodeDown_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("datanodeDown_args");

    private static final org.apache.thrift.protocol.TField NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("name", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField STORAGE_FIELD_DESC = new org.apache.thrift.protocol.TField("storage", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField THRIFT_PORT_FIELD_DESC = new org.apache.thrift.protocol.TField("thriftPort", org.apache.thrift.protocol.TType.I32, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new datanodeDown_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new datanodeDown_argsTupleSchemeFactory());
    }

    /**
     * <host name>:<port number> of the datanode
     */
    public String name; // required
    /**
     * the storage id of the datanode
     */
    public String storage; // required
    /**
     * Thrift port of the datanode
     */
    public int thriftPort; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * <host name>:<port number> of the datanode
       */
      NAME((short)1, "name"),
      /**
       * the storage id of the datanode
       */
      STORAGE((short)2, "storage"),
      /**
       * Thrift port of the datanode
       */
      THRIFT_PORT((short)3, "thriftPort");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NAME
            return NAME;
          case 2: // STORAGE
            return STORAGE;
          case 3: // THRIFT_PORT
            return THRIFT_PORT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __THRIFTPORT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NAME, new org.apache.thrift.meta_data.FieldMetaData("name", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.STORAGE, new org.apache.thrift.meta_data.FieldMetaData("storage", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.THRIFT_PORT, new org.apache.thrift.meta_data.FieldMetaData("thriftPort", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(datanodeDown_args.class, metaDataMap);
    }

    public datanodeDown_args() {
    }

    public datanodeDown_args(
      String name,
      String storage,
      int thriftPort)
    {
      this();
      this.name = name;
      this.storage = storage;
      this.thriftPort = thriftPort;
      setThriftPortIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public datanodeDown_args(datanodeDown_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetName()) {
        this.name = other.name;
      }
      if (other.isSetStorage()) {
        this.storage = other.storage;
      }
      this.thriftPort = other.thriftPort;
    }

    public datanodeDown_args deepCopy() {
      return new datanodeDown_args(this);
    }

    @Override
    public void clear() {
      this.name = null;
      this.storage = null;
      setThriftPortIsSet(false);
      this.thriftPort = 0;
    }

    /**
     * <host name>:<port number> of the datanode
     */
    public String getName() {
      return this.name;
    }

    /**
     * <host name>:<port number> of the datanode
     */
    public datanodeDown_args setName(String name) {
      this.name = name;
      return this;
    }

    public void unsetName() {
      this.name = null;
    }

    /** Returns true if field name is set (has been assigned a value) and false otherwise */
    public boolean isSetName() {
      return this.name != null;
    }

    public void setNameIsSet(boolean value) {
      if (!value) {
        this.name = null;
      }
    }

    /**
     * the storage id of the datanode
     */
    public String getStorage() {
      return this.storage;
    }

    /**
     * the storage id of the datanode
     */
    public datanodeDown_args setStorage(String storage) {
      this.storage = storage;
      return this;
    }

    public void unsetStorage() {
      this.storage = null;
    }

    /** Returns true if field storage is set (has been assigned a value) and false otherwise */
    public boolean isSetStorage() {
      return this.storage != null;
    }

    public void setStorageIsSet(boolean value) {
      if (!value) {
        this.storage = null;
      }
    }

    /**
     * Thrift port of the datanode
     */
    public int getThriftPort() {
      return this.thriftPort;
    }

    /**
     * Thrift port of the datanode
     */
    public datanodeDown_args setThriftPort(int thriftPort) {
      this.thriftPort = thriftPort;
      setThriftPortIsSet(true);
      return this;
    }

    public void unsetThriftPort() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __THRIFTPORT_ISSET_ID);
    }

    /** Returns true if field thriftPort is set (has been assigned a value) and false otherwise */
    public boolean isSetThriftPort() {
      return EncodingUtils.testBit(__isset_bitfield, __THRIFTPORT_ISSET_ID);
    }

    public void setThriftPortIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __THRIFTPORT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NAME:
        if (value == null) {
          unsetName();
        } else {
          setName((String)value);
        }
        break;

      case STORAGE:
        if (value == null) {
          unsetStorage();
        } else {
          setStorage((String)value);
        }
        break;

      case THRIFT_PORT:
        if (value == null) {
          unsetThriftPort();
        } else {
          setThriftPort((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NAME:
        return getName();

      case STORAGE:
        return getStorage();

      case THRIFT_PORT:
        return Integer.valueOf(getThriftPort());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NAME:
        return isSetName();
      case STORAGE:
        return isSetStorage();
      case THRIFT_PORT:
        return isSetThriftPort();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof datanodeDown_args)
        return this.equals((datanodeDown_args)that);
      return false;
    }

    public boolean equals(datanodeDown_args that) {
      if (that == null)
        return false;

      boolean this_present_name = true && this.isSetName();
      boolean that_present_name = true && that.isSetName();
      if (this_present_name || that_present_name) {
        if (!(this_present_name && that_present_name))
          return false;
        if (!this.name.equals(that.name))
          return false;
      }

      boolean this_present_storage = true && this.isSetStorage();
      boolean that_present_storage = true && that.isSetStorage();
      if (this_present_storage || that_present_storage) {
        if (!(this_present_storage && that_present_storage))
          return false;
        if (!this.storage.equals(that.storage))
          return false;
      }

      boolean this_present_thriftPort = true;
      boolean that_present_thriftPort = true;
      if (this_present_thriftPort || that_present_thriftPort) {
        if (!(this_present_thriftPort && that_present_thriftPort))
          return false;
        if (this.thriftPort != that.thriftPort)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(datanodeDown_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      datanodeDown_args typedOther = (datanodeDown_args)other;

      lastComparison = Boolean.valueOf(isSetName()).compareTo(typedOther.isSetName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.name, typedOther.name);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetStorage()).compareTo(typedOther.isSetStorage());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStorage()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.storage, typedOther.storage);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetThriftPort()).compareTo(typedOther.isSetThriftPort());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetThriftPort()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.thriftPort, typedOther.thriftPort);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("datanodeDown_args(");
      boolean first = true;

      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("storage:");
      if (this.storage == null) {
        sb.append("null");
      } else {
        sb.append(this.storage);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("thriftPort:");
      sb.append(this.thriftPort);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class datanodeDown_argsStandardSchemeFactory implements SchemeFactory {
      public datanodeDown_argsStandardScheme getScheme() {
        return new datanodeDown_argsStandardScheme();
      }
    }

    private static class datanodeDown_argsStandardScheme extends StandardScheme<datanodeDown_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, datanodeDown_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // STORAGE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.storage = iprot.readString();
                struct.setStorageIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // THRIFT_PORT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.thriftPort = iprot.readI32();
                struct.setThriftPortIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, datanodeDown_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.name != null) {
          oprot.writeFieldBegin(NAME_FIELD_DESC);
          oprot.writeString(struct.name);
          oprot.writeFieldEnd();
        }
        if (struct.storage != null) {
          oprot.writeFieldBegin(STORAGE_FIELD_DESC);
          oprot.writeString(struct.storage);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(THRIFT_PORT_FIELD_DESC);
        oprot.writeI32(struct.thriftPort);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class datanodeDown_argsTupleSchemeFactory implements SchemeFactory {
      public datanodeDown_argsTupleScheme getScheme() {
        return new datanodeDown_argsTupleScheme();
      }
    }

    private static class datanodeDown_argsTupleScheme extends TupleScheme<datanodeDown_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, datanodeDown_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetName()) {
          optionals.set(0);
        }
        if (struct.isSetStorage()) {
          optionals.set(1);
        }
        if (struct.isSetThriftPort()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetName()) {
          oprot.writeString(struct.name);
        }
        if (struct.isSetStorage()) {
          oprot.writeString(struct.storage);
        }
        if (struct.isSetThriftPort()) {
          oprot.writeI32(struct.thriftPort);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, datanodeDown_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.name = iprot.readString();
          struct.setNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.storage = iprot.readString();
          struct.setStorageIsSet(true);
        }
        if (incoming.get(2)) {
          struct.thriftPort = iprot.readI32();
          struct.setThriftPortIsSet(true);
        }
      }
    }

  }

  public static class datanodeDown_result implements org.apache.thrift.TBase<datanodeDown_result, datanodeDown_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("datanodeDown_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new datanodeDown_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new datanodeDown_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(datanodeDown_result.class, metaDataMap);
    }

    public datanodeDown_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public datanodeDown_result(datanodeDown_result other) {
    }

    public datanodeDown_result deepCopy() {
      return new datanodeDown_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof datanodeDown_result)
        return this.equals((datanodeDown_result)that);
      return false;
    }

    public boolean equals(datanodeDown_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(datanodeDown_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      datanodeDown_result typedOther = (datanodeDown_result)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("datanodeDown_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class datanodeDown_resultStandardSchemeFactory implements SchemeFactory {
      public datanodeDown_resultStandardScheme getScheme() {
        return new datanodeDown_resultStandardScheme();
      }
    }

    private static class datanodeDown_resultStandardScheme extends StandardScheme<datanodeDown_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, datanodeDown_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, datanodeDown_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class datanodeDown_resultTupleSchemeFactory implements SchemeFactory {
      public datanodeDown_resultTupleScheme getScheme() {
        return new datanodeDown_resultTupleScheme();
      }
    }

    private static class datanodeDown_resultTupleScheme extends TupleScheme<datanodeDown_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, datanodeDown_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, datanodeDown_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getDelegationToken_args implements org.apache.thrift.TBase<getDelegationToken_args, getDelegationToken_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDelegationToken_args");

    private static final org.apache.thrift.protocol.TField CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("ctx", org.apache.thrift.protocol.TType.STRUCT, (short)10);
    private static final org.apache.thrift.protocol.TField RENEWER_FIELD_DESC = new org.apache.thrift.protocol.TField("renewer", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDelegationToken_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDelegationToken_argsTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.RequestContext ctx; // required
    public String renewer; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CTX((short)10, "ctx"),
      RENEWER((short)1, "renewer");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 10: // CTX
            return CTX;
          case 1: // RENEWER
            return RENEWER;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CTX, new org.apache.thrift.meta_data.FieldMetaData("ctx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.RequestContext.class)));
      tmpMap.put(_Fields.RENEWER, new org.apache.thrift.meta_data.FieldMetaData("renewer", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDelegationToken_args.class, metaDataMap);
    }

    public getDelegationToken_args() {
    }

    public getDelegationToken_args(
      org.apache.hadoop.thriftfs.api.RequestContext ctx,
      String renewer)
    {
      this();
      this.ctx = ctx;
      this.renewer = renewer;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDelegationToken_args(getDelegationToken_args other) {
      if (other.isSetCtx()) {
        this.ctx = new org.apache.hadoop.thriftfs.api.RequestContext(other.ctx);
      }
      if (other.isSetRenewer()) {
        this.renewer = other.renewer;
      }
    }

    public getDelegationToken_args deepCopy() {
      return new getDelegationToken_args(this);
    }

    @Override
    public void clear() {
      this.ctx = null;
      this.renewer = null;
    }

    public org.apache.hadoop.thriftfs.api.RequestContext getCtx() {
      return this.ctx;
    }

    public getDelegationToken_args setCtx(org.apache.hadoop.thriftfs.api.RequestContext ctx) {
      this.ctx = ctx;
      return this;
    }

    public void unsetCtx() {
      this.ctx = null;
    }

    /** Returns true if field ctx is set (has been assigned a value) and false otherwise */
    public boolean isSetCtx() {
      return this.ctx != null;
    }

    public void setCtxIsSet(boolean value) {
      if (!value) {
        this.ctx = null;
      }
    }

    public String getRenewer() {
      return this.renewer;
    }

    public getDelegationToken_args setRenewer(String renewer) {
      this.renewer = renewer;
      return this;
    }

    public void unsetRenewer() {
      this.renewer = null;
    }

    /** Returns true if field renewer is set (has been assigned a value) and false otherwise */
    public boolean isSetRenewer() {
      return this.renewer != null;
    }

    public void setRenewerIsSet(boolean value) {
      if (!value) {
        this.renewer = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CTX:
        if (value == null) {
          unsetCtx();
        } else {
          setCtx((org.apache.hadoop.thriftfs.api.RequestContext)value);
        }
        break;

      case RENEWER:
        if (value == null) {
          unsetRenewer();
        } else {
          setRenewer((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CTX:
        return getCtx();

      case RENEWER:
        return getRenewer();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CTX:
        return isSetCtx();
      case RENEWER:
        return isSetRenewer();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDelegationToken_args)
        return this.equals((getDelegationToken_args)that);
      return false;
    }

    public boolean equals(getDelegationToken_args that) {
      if (that == null)
        return false;

      boolean this_present_ctx = true && this.isSetCtx();
      boolean that_present_ctx = true && that.isSetCtx();
      if (this_present_ctx || that_present_ctx) {
        if (!(this_present_ctx && that_present_ctx))
          return false;
        if (!this.ctx.equals(that.ctx))
          return false;
      }

      boolean this_present_renewer = true && this.isSetRenewer();
      boolean that_present_renewer = true && that.isSetRenewer();
      if (this_present_renewer || that_present_renewer) {
        if (!(this_present_renewer && that_present_renewer))
          return false;
        if (!this.renewer.equals(that.renewer))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getDelegationToken_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getDelegationToken_args typedOther = (getDelegationToken_args)other;

      lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ctx, typedOther.ctx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRenewer()).compareTo(typedOther.isSetRenewer());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRenewer()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.renewer, typedOther.renewer);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDelegationToken_args(");
      boolean first = true;

      sb.append("ctx:");
      if (this.ctx == null) {
        sb.append("null");
      } else {
        sb.append(this.ctx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("renewer:");
      if (this.renewer == null) {
        sb.append("null");
      } else {
        sb.append(this.renewer);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (ctx != null) {
        ctx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDelegationToken_argsStandardSchemeFactory implements SchemeFactory {
      public getDelegationToken_argsStandardScheme getScheme() {
        return new getDelegationToken_argsStandardScheme();
      }
    }

    private static class getDelegationToken_argsStandardScheme extends StandardScheme<getDelegationToken_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDelegationToken_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 10: // CTX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
                struct.ctx.read(iprot);
                struct.setCtxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // RENEWER
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.renewer = iprot.readString();
                struct.setRenewerIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDelegationToken_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.renewer != null) {
          oprot.writeFieldBegin(RENEWER_FIELD_DESC);
          oprot.writeString(struct.renewer);
          oprot.writeFieldEnd();
        }
        if (struct.ctx != null) {
          oprot.writeFieldBegin(CTX_FIELD_DESC);
          struct.ctx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDelegationToken_argsTupleSchemeFactory implements SchemeFactory {
      public getDelegationToken_argsTupleScheme getScheme() {
        return new getDelegationToken_argsTupleScheme();
      }
    }

    private static class getDelegationToken_argsTupleScheme extends TupleScheme<getDelegationToken_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDelegationToken_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCtx()) {
          optionals.set(0);
        }
        if (struct.isSetRenewer()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetCtx()) {
          struct.ctx.write(oprot);
        }
        if (struct.isSetRenewer()) {
          oprot.writeString(struct.renewer);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDelegationToken_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.ctx = new org.apache.hadoop.thriftfs.api.RequestContext();
          struct.ctx.read(iprot);
          struct.setCtxIsSet(true);
        }
        if (incoming.get(1)) {
          struct.renewer = iprot.readString();
          struct.setRenewerIsSet(true);
        }
      }
    }

  }

  public static class getDelegationToken_result implements org.apache.thrift.TBase<getDelegationToken_result, getDelegationToken_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDelegationToken_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERR_FIELD_DESC = new org.apache.thrift.protocol.TField("err", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDelegationToken_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDelegationToken_resultTupleSchemeFactory());
    }

    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken success; // required
    public org.apache.hadoop.thriftfs.api.IOException err; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERR((short)1, "err");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERR
            return ERR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.hadoop.thriftfs.api.ThriftDelegationToken.class)));
      tmpMap.put(_Fields.ERR, new org.apache.thrift.meta_data.FieldMetaData("err", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDelegationToken_result.class, metaDataMap);
    }

    public getDelegationToken_result() {
    }

    public getDelegationToken_result(
      org.apache.hadoop.thriftfs.api.ThriftDelegationToken success,
      org.apache.hadoop.thriftfs.api.IOException err)
    {
      this();
      this.success = success;
      this.err = err;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDelegationToken_result(getDelegationToken_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.hadoop.thriftfs.api.ThriftDelegationToken(other.success);
      }
      if (other.isSetErr()) {
        this.err = new org.apache.hadoop.thriftfs.api.IOException(other.err);
      }
    }

    public getDelegationToken_result deepCopy() {
      return new getDelegationToken_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.err = null;
    }

    public org.apache.hadoop.thriftfs.api.ThriftDelegationToken getSuccess() {
      return this.success;
    }

    public getDelegationToken_result setSuccess(org.apache.hadoop.thriftfs.api.ThriftDelegationToken success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.hadoop.thriftfs.api.IOException getErr() {
      return this.err;
    }

    public getDelegationToken_result setErr(org.apache.hadoop.thriftfs.api.IOException err) {
      this.err = err;
      return this;
    }

    public void unsetErr() {
      this.err = null;
    }

    /** Returns true if field err is set (has been assigned a value) and false otherwise */
    public boolean isSetErr() {
      return this.err != null;
    }

    public void setErrIsSet(boolean value) {
      if (!value) {
        this.err = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.hadoop.thriftfs.api.ThriftDelegationToken)value);
        }
        break;

      case ERR:
        if (value == null) {
          unsetErr();
        } else {
          setErr((org.apache.hadoop.thriftfs.api.IOException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERR:
        return getErr();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERR:
        return isSetErr();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDelegationToken_result)
        return this.equals((getDelegationToken_result)that);
      return false;
    }

    public boolean equals(getDelegationToken_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_err = true && this.isSetErr();
      boolean that_present_err = true && that.isSetErr();
      if (this_present_err || that_present_err) {
        if (!(this_present_err && that_present_err))
          return false;
        if (!this.err.equals(that.err))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getDelegationToken_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getDelegationToken_result typedOther = (getDelegationToken_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErr()).compareTo(typedOther.isSetErr());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErr()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.err, typedOther.err);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDelegationToken_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("err:");
      if (this.err == null) {
        sb.append("null");
      } else {
        sb.append(this.err);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDelegationToken_resultStandardSchemeFactory implements SchemeFactory {
      public getDelegationToken_resultStandardScheme getScheme() {
        return new getDelegationToken_resultStandardScheme();
      }
    }

    private static class getDelegationToken_resultStandardScheme extends StandardScheme<getDelegationToken_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDelegationToken_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.hadoop.thriftfs.api.ThriftDelegationToken();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // ERR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.err = new org.apache.hadoop.thriftfs.api.IOException();
                struct.err.read(iprot);
                struct.setErrIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDelegationToken_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.err != null) {
          oprot.writeFieldBegin(ERR_FIELD_DESC);
          struct.err.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDelegationToken_resultTupleSchemeFactory implements SchemeFactory {
      public getDelegationToken_resultTupleScheme getScheme() {
        return new getDelegationToken_resultTupleScheme();
      }
    }

    private static class getDelegationToken_resultTupleScheme extends TupleScheme<getDelegationToken_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDelegationToken_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetErr()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetErr()) {
          struct.err.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDelegationToken_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new org.apache.hadoop.thriftfs.api.ThriftDelegationToken();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.err = new org.apache.hadoop.thriftfs.api.IOException();
          struct.err.read(iprot);
          struct.setErrIsSet(true);
        }
      }
    }

  }

}
