## Licensed to Cloudera, Inc. under one
## or more contributor license agreements.  See the NOTICE file
## distributed with this work for additional information
## regarding copyright ownership.  Cloudera, Inc. licenses this file
## to you under the Apache License, Version 2.0 (the
## "License"); you may not use this file except in compliance
## with the License.  You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.

<%!
from django.utils.translation import ugettext as _
from desktop.views import commonheader, commonfooter
%>
${ commonheader(_('Access Forbidden'), "", user) | n,unicode }

  <div class="container-fluid">
    <div class="row-fluid">
      <div class="span12 well">
        <div class="hero-unit">
          <h1>${_('Access Forbidden (403)')}</h1>
          <br>
          <p>${_("Sorry, you don't have permissions to access the page, or your session has expired.")}</p>
          <br>
          <p><a class="btn" onclick="history.back()">${ _('Go Back') }</a></p>
        </div>
      </div>
    </div>
  </div>

${ commonfooter(messages) | n,unicode }
