#
# Autogenerated by Thrift Compiler (0.9.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
import hadoop.api.common.HadoopServiceBase
from ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface(hadoop.api.common.HadoopServiceBase.Iface):
  """
  Provides an interface to a Hadoop Namenode. It is basically a Thrift
  translation of org.apache.hadoop.hdfs.protocol.ClientProtocol.
  """
  def chmod(self, ctx, path, perms):
    """
    Set permissions of an existing file or directory.

    Parameters:
     - ctx
     - path: Path of the file or directory.
     - perms: New permissions for the file or directory.
    """
    pass

  def chown(self, ctx, path, owner, group):
    """
    Set owner of a file or directory.

    If either parameter 'owner' or 'group' is set to null, that
    parameter is left unchanged.

    Parameters 'owner' and 'group' cannot be both null.

    Parameters:
     - ctx
     - path: Path to the file or directory
     - owner: New owner.
     - group: New group.
    """
    pass

  def df(self, ctx):
    """
    Return a list containing:
      (index 0) The total storage capacity of the file system (in bytes).
      (index 1) The total used space of the file system (in bytes).
      (index 2) The available storage of the file system (in bytes).

    Parameters:
     - ctx
    """
    pass

  def enterSafeMode(self, ctx):
    """
    Enter safe mode.

    Parameters:
     - ctx
    """
    pass

  def getBlocks(self, ctx, path, offset, length):
    """
    Get a list of all blocks containing a region of a file

    Parameters:
     - ctx
     - path: Path to the file.
     - offset: Offset of the region.
     - length: Length of the region
    """
    pass

  def getPreferredBlockSize(self, ctx, path):
    """
    Get the preferred block size for the given file.

    The path must exist, or common.IOException is thrown.

    Parameters:
     - ctx
     - path: Path to the file.
    """
    pass

  def isInSafeMode(self, ctx):
    """
    Returns whether HDFS is in safe mode or not.

    Parameters:
     - ctx
    """
    pass

  def leaveSafeMode(self, ctx):
    """
    Leave safe mode.

    Parameters:
     - ctx
    """
    pass

  def ls(self, ctx, path):
    """
    Get a listing of the indicated directory.

    Parameters:
     - ctx
     - path: Path to the directory.
    """
    pass

  def mkdirhier(self, ctx, path, perms):
    """
    Create a directory (or hierarchy of directories).

    Returns false if directory did not exist and could not be created,
    true otherwise.

    Parameters:
     - ctx
     - path: Path to the directory.
     - perms: Access permissions of the directory.
    """
    pass

  def refreshNodes(self, ctx):
    """
    Tells the name node to reread the hosts and exclude files.

    Parameters:
     - ctx
    """
    pass

  def rename(self, ctx, path, newPath):
    """
    Rename an item in the file system namespace.

    Returns true  if successful, or
            false if the old name does not exist or if the new name already
                  belongs to the namespace.

    Parameters:
     - ctx
     - path: Path to existing file or directory.
     - newPath: New path.
    """
    pass

  def reportBadBlocks(self, ctx, blocks):
    """
    Report corrupted blocks.

    Parameters:
     - ctx
     - blocks: List of corrupted blocks.
    """
    pass

  def stat(self, ctx, path):
    """
    Get information about a path in HDFS.

    Return value will be nul if path does not exist.

    Parameters:
     - ctx
     - path: Path of the file or directory.
    """
    pass

  def getContentSummary(self, ctx, Path):
    """
    Get the summary of a directory's contents.

    Note that this has runtime linear in the total number of nodes
    in the directory tree - this can be expensive for directories
    near the top of a big HDFS. Use with care.

    Parameters:
     - ctx
     - Path
    """
    pass

  def multiGetContentSummary(self, ctx, paths):
    """
    Get ContentSummary objects for multiple directories simultaneously. The same warnings
    apply as for getContentSummary(...) above.

    Parameters:
     - ctx
     - paths
    """
    pass

  def setQuota(self, ctx, path, namespaceQuota, diskspaceQuota):
    """
    Set the quota for a directory.

    Quota parameters may have three types of values:

       (1) 0 or more:      Quota will be set to that value.
       (2) QUOTA_DONT_SET: Quota will not be changed,
       (3) QUOTA_RESET:    Quota will be reset.

    Any other value is a runtime error.

    Parameters:
     - ctx
     - path: Path of the directory.
     - namespaceQuota: Limit on the number of names in the directory.
     - diskspaceQuota: Limit on disk space occupied by all the files in the
    directory.
    """
    pass

  def setReplication(self, ctx, path, replication):
    """
    Set replication factor for an existing file.

    This call just updates the value of the replication factor. The actual
    block replication is not expected to be performed during this method call.
    The blocks will be populated or removed in the background as the result of
    the routine block maintenance procedures.

    Returns true if successful, false if file does not exist or is a
    directory.

    Parameters:
     - ctx
     - path: Path of the file.
     - replication: New replication factor.
    """
    pass

  def unlink(self, ctx, path, recursive):
    """
    Delete a file or directory from the file system.

    Any blocks belonging to the deleted files will be garbage-collected.

    Parameters:
     - ctx
     - path: Path of the file or directory.
     - recursive: Delete a non-empty directory recursively.
    """
    pass

  def utime(self, ctx, path, atime, mtime):
    """
    Sets the modification and access time of a file or directory.

    Setting *one single time paramater* to -1 means that time parameter
    must not be set by this call.

    Setting *both time parameters* to -1 means both of them must be set to
    the current time.

    Parameters:
     - ctx
     - path: Path of the file or directory.
     - atime: Access time in milliseconds since 1970-01-01 00:00 UTC
     - mtime: Modification time in milliseconds since 1970-01-01 00:00 UTC
    """
    pass

  def datanodeUp(self, name, storage, thriftPort):
    """
    Inform the namenode that a datanode process has started.

    Parameters:
     - name: <host name>:<port number> of the datanode
     - storage: the storage id of the datanode
     - thriftPort: Thrift port of the datanode
    """
    pass

  def datanodeDown(self, name, storage, thriftPort):
    """
    Inform the namenode that a datanode process has stopped.

    Parameters:
     - name: <host name>:<port number> of the datanode
     - storage: the storage id of the datanode
     - thriftPort: Thrift port of the datanode
    """
    pass

  def getDelegationToken(self, ctx, renewer):
    """
    Get an HDFS delegation token.

    Parameters:
     - ctx
     - renewer
    """
    pass


class Client(hadoop.api.common.HadoopServiceBase.Client, Iface):
  """
  Provides an interface to a Hadoop Namenode. It is basically a Thrift
  translation of org.apache.hadoop.hdfs.protocol.ClientProtocol.
  """
  def __init__(self, iprot, oprot=None):
    hadoop.api.common.HadoopServiceBase.Client.__init__(self, iprot, oprot)

  def chmod(self, ctx, path, perms):
    """
    Set permissions of an existing file or directory.

    Parameters:
     - ctx
     - path: Path of the file or directory.
     - perms: New permissions for the file or directory.
    """
    self.send_chmod(ctx, path, perms)
    self.recv_chmod()

  def send_chmod(self, ctx, path, perms):
    self._oprot.writeMessageBegin('chmod', TMessageType.CALL, self._seqid)
    args = chmod_args()
    args.ctx = ctx
    args.path = path
    args.perms = perms
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_chmod(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = chmod_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    return

  def chown(self, ctx, path, owner, group):
    """
    Set owner of a file or directory.

    If either parameter 'owner' or 'group' is set to null, that
    parameter is left unchanged.

    Parameters 'owner' and 'group' cannot be both null.

    Parameters:
     - ctx
     - path: Path to the file or directory
     - owner: New owner.
     - group: New group.
    """
    self.send_chown(ctx, path, owner, group)
    self.recv_chown()

  def send_chown(self, ctx, path, owner, group):
    self._oprot.writeMessageBegin('chown', TMessageType.CALL, self._seqid)
    args = chown_args()
    args.ctx = ctx
    args.path = path
    args.owner = owner
    args.group = group
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_chown(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = chown_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    return

  def df(self, ctx):
    """
    Return a list containing:
      (index 0) The total storage capacity of the file system (in bytes).
      (index 1) The total used space of the file system (in bytes).
      (index 2) The available storage of the file system (in bytes).

    Parameters:
     - ctx
    """
    self.send_df(ctx)
    return self.recv_df()

  def send_df(self, ctx):
    self._oprot.writeMessageBegin('df', TMessageType.CALL, self._seqid)
    args = df_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_df(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = df_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "df failed: unknown result");

  def enterSafeMode(self, ctx):
    """
    Enter safe mode.

    Parameters:
     - ctx
    """
    self.send_enterSafeMode(ctx)
    self.recv_enterSafeMode()

  def send_enterSafeMode(self, ctx):
    self._oprot.writeMessageBegin('enterSafeMode', TMessageType.CALL, self._seqid)
    args = enterSafeMode_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_enterSafeMode(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = enterSafeMode_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    return

  def getBlocks(self, ctx, path, offset, length):
    """
    Get a list of all blocks containing a region of a file

    Parameters:
     - ctx
     - path: Path to the file.
     - offset: Offset of the region.
     - length: Length of the region
    """
    self.send_getBlocks(ctx, path, offset, length)
    return self.recv_getBlocks()

  def send_getBlocks(self, ctx, path, offset, length):
    self._oprot.writeMessageBegin('getBlocks', TMessageType.CALL, self._seqid)
    args = getBlocks_args()
    args.ctx = ctx
    args.path = path
    args.offset = offset
    args.length = length
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getBlocks(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getBlocks_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getBlocks failed: unknown result");

  def getPreferredBlockSize(self, ctx, path):
    """
    Get the preferred block size for the given file.

    The path must exist, or common.IOException is thrown.

    Parameters:
     - ctx
     - path: Path to the file.
    """
    self.send_getPreferredBlockSize(ctx, path)
    return self.recv_getPreferredBlockSize()

  def send_getPreferredBlockSize(self, ctx, path):
    self._oprot.writeMessageBegin('getPreferredBlockSize', TMessageType.CALL, self._seqid)
    args = getPreferredBlockSize_args()
    args.ctx = ctx
    args.path = path
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getPreferredBlockSize(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getPreferredBlockSize_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getPreferredBlockSize failed: unknown result");

  def isInSafeMode(self, ctx):
    """
    Returns whether HDFS is in safe mode or not.

    Parameters:
     - ctx
    """
    self.send_isInSafeMode(ctx)
    return self.recv_isInSafeMode()

  def send_isInSafeMode(self, ctx):
    self._oprot.writeMessageBegin('isInSafeMode', TMessageType.CALL, self._seqid)
    args = isInSafeMode_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_isInSafeMode(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = isInSafeMode_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "isInSafeMode failed: unknown result");

  def leaveSafeMode(self, ctx):
    """
    Leave safe mode.

    Parameters:
     - ctx
    """
    self.send_leaveSafeMode(ctx)
    self.recv_leaveSafeMode()

  def send_leaveSafeMode(self, ctx):
    self._oprot.writeMessageBegin('leaveSafeMode', TMessageType.CALL, self._seqid)
    args = leaveSafeMode_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_leaveSafeMode(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = leaveSafeMode_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    return

  def ls(self, ctx, path):
    """
    Get a listing of the indicated directory.

    Parameters:
     - ctx
     - path: Path to the directory.
    """
    self.send_ls(ctx, path)
    return self.recv_ls()

  def send_ls(self, ctx, path):
    self._oprot.writeMessageBegin('ls', TMessageType.CALL, self._seqid)
    args = ls_args()
    args.ctx = ctx
    args.path = path
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_ls(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = ls_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "ls failed: unknown result");

  def mkdirhier(self, ctx, path, perms):
    """
    Create a directory (or hierarchy of directories).

    Returns false if directory did not exist and could not be created,
    true otherwise.

    Parameters:
     - ctx
     - path: Path to the directory.
     - perms: Access permissions of the directory.
    """
    self.send_mkdirhier(ctx, path, perms)
    return self.recv_mkdirhier()

  def send_mkdirhier(self, ctx, path, perms):
    self._oprot.writeMessageBegin('mkdirhier', TMessageType.CALL, self._seqid)
    args = mkdirhier_args()
    args.ctx = ctx
    args.path = path
    args.perms = perms
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mkdirhier(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mkdirhier_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "mkdirhier failed: unknown result");

  def refreshNodes(self, ctx):
    """
    Tells the name node to reread the hosts and exclude files.

    Parameters:
     - ctx
    """
    self.send_refreshNodes(ctx)
    self.recv_refreshNodes()

  def send_refreshNodes(self, ctx):
    self._oprot.writeMessageBegin('refreshNodes', TMessageType.CALL, self._seqid)
    args = refreshNodes_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_refreshNodes(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = refreshNodes_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    return

  def rename(self, ctx, path, newPath):
    """
    Rename an item in the file system namespace.

    Returns true  if successful, or
            false if the old name does not exist or if the new name already
                  belongs to the namespace.

    Parameters:
     - ctx
     - path: Path to existing file or directory.
     - newPath: New path.
    """
    self.send_rename(ctx, path, newPath)
    return self.recv_rename()

  def send_rename(self, ctx, path, newPath):
    self._oprot.writeMessageBegin('rename', TMessageType.CALL, self._seqid)
    args = rename_args()
    args.ctx = ctx
    args.path = path
    args.newPath = newPath
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_rename(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = rename_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "rename failed: unknown result");

  def reportBadBlocks(self, ctx, blocks):
    """
    Report corrupted blocks.

    Parameters:
     - ctx
     - blocks: List of corrupted blocks.
    """
    self.send_reportBadBlocks(ctx, blocks)
    self.recv_reportBadBlocks()

  def send_reportBadBlocks(self, ctx, blocks):
    self._oprot.writeMessageBegin('reportBadBlocks', TMessageType.CALL, self._seqid)
    args = reportBadBlocks_args()
    args.ctx = ctx
    args.blocks = blocks
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_reportBadBlocks(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = reportBadBlocks_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    return

  def stat(self, ctx, path):
    """
    Get information about a path in HDFS.

    Return value will be nul if path does not exist.

    Parameters:
     - ctx
     - path: Path of the file or directory.
    """
    self.send_stat(ctx, path)
    return self.recv_stat()

  def send_stat(self, ctx, path):
    self._oprot.writeMessageBegin('stat', TMessageType.CALL, self._seqid)
    args = stat_args()
    args.ctx = ctx
    args.path = path
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_stat(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = stat_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "stat failed: unknown result");

  def getContentSummary(self, ctx, Path):
    """
    Get the summary of a directory's contents.

    Note that this has runtime linear in the total number of nodes
    in the directory tree - this can be expensive for directories
    near the top of a big HDFS. Use with care.

    Parameters:
     - ctx
     - Path
    """
    self.send_getContentSummary(ctx, Path)
    return self.recv_getContentSummary()

  def send_getContentSummary(self, ctx, Path):
    self._oprot.writeMessageBegin('getContentSummary', TMessageType.CALL, self._seqid)
    args = getContentSummary_args()
    args.ctx = ctx
    args.Path = Path
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getContentSummary(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getContentSummary_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getContentSummary failed: unknown result");

  def multiGetContentSummary(self, ctx, paths):
    """
    Get ContentSummary objects for multiple directories simultaneously. The same warnings
    apply as for getContentSummary(...) above.

    Parameters:
     - ctx
     - paths
    """
    self.send_multiGetContentSummary(ctx, paths)
    return self.recv_multiGetContentSummary()

  def send_multiGetContentSummary(self, ctx, paths):
    self._oprot.writeMessageBegin('multiGetContentSummary', TMessageType.CALL, self._seqid)
    args = multiGetContentSummary_args()
    args.ctx = ctx
    args.paths = paths
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_multiGetContentSummary(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = multiGetContentSummary_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "multiGetContentSummary failed: unknown result");

  def setQuota(self, ctx, path, namespaceQuota, diskspaceQuota):
    """
    Set the quota for a directory.

    Quota parameters may have three types of values:

       (1) 0 or more:      Quota will be set to that value.
       (2) QUOTA_DONT_SET: Quota will not be changed,
       (3) QUOTA_RESET:    Quota will be reset.

    Any other value is a runtime error.

    Parameters:
     - ctx
     - path: Path of the directory.
     - namespaceQuota: Limit on the number of names in the directory.
     - diskspaceQuota: Limit on disk space occupied by all the files in the
    directory.
    """
    self.send_setQuota(ctx, path, namespaceQuota, diskspaceQuota)
    self.recv_setQuota()

  def send_setQuota(self, ctx, path, namespaceQuota, diskspaceQuota):
    self._oprot.writeMessageBegin('setQuota', TMessageType.CALL, self._seqid)
    args = setQuota_args()
    args.ctx = ctx
    args.path = path
    args.namespaceQuota = namespaceQuota
    args.diskspaceQuota = diskspaceQuota
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_setQuota(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = setQuota_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    return

  def setReplication(self, ctx, path, replication):
    """
    Set replication factor for an existing file.

    This call just updates the value of the replication factor. The actual
    block replication is not expected to be performed during this method call.
    The blocks will be populated or removed in the background as the result of
    the routine block maintenance procedures.

    Returns true if successful, false if file does not exist or is a
    directory.

    Parameters:
     - ctx
     - path: Path of the file.
     - replication: New replication factor.
    """
    self.send_setReplication(ctx, path, replication)
    return self.recv_setReplication()

  def send_setReplication(self, ctx, path, replication):
    self._oprot.writeMessageBegin('setReplication', TMessageType.CALL, self._seqid)
    args = setReplication_args()
    args.ctx = ctx
    args.path = path
    args.replication = replication
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_setReplication(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = setReplication_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "setReplication failed: unknown result");

  def unlink(self, ctx, path, recursive):
    """
    Delete a file or directory from the file system.

    Any blocks belonging to the deleted files will be garbage-collected.

    Parameters:
     - ctx
     - path: Path of the file or directory.
     - recursive: Delete a non-empty directory recursively.
    """
    self.send_unlink(ctx, path, recursive)
    return self.recv_unlink()

  def send_unlink(self, ctx, path, recursive):
    self._oprot.writeMessageBegin('unlink', TMessageType.CALL, self._seqid)
    args = unlink_args()
    args.ctx = ctx
    args.path = path
    args.recursive = recursive
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_unlink(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = unlink_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "unlink failed: unknown result");

  def utime(self, ctx, path, atime, mtime):
    """
    Sets the modification and access time of a file or directory.

    Setting *one single time paramater* to -1 means that time parameter
    must not be set by this call.

    Setting *both time parameters* to -1 means both of them must be set to
    the current time.

    Parameters:
     - ctx
     - path: Path of the file or directory.
     - atime: Access time in milliseconds since 1970-01-01 00:00 UTC
     - mtime: Modification time in milliseconds since 1970-01-01 00:00 UTC
    """
    self.send_utime(ctx, path, atime, mtime)
    self.recv_utime()

  def send_utime(self, ctx, path, atime, mtime):
    self._oprot.writeMessageBegin('utime', TMessageType.CALL, self._seqid)
    args = utime_args()
    args.ctx = ctx
    args.path = path
    args.atime = atime
    args.mtime = mtime
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_utime(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = utime_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    return

  def datanodeUp(self, name, storage, thriftPort):
    """
    Inform the namenode that a datanode process has started.

    Parameters:
     - name: <host name>:<port number> of the datanode
     - storage: the storage id of the datanode
     - thriftPort: Thrift port of the datanode
    """
    self.send_datanodeUp(name, storage, thriftPort)
    self.recv_datanodeUp()

  def send_datanodeUp(self, name, storage, thriftPort):
    self._oprot.writeMessageBegin('datanodeUp', TMessageType.CALL, self._seqid)
    args = datanodeUp_args()
    args.name = name
    args.storage = storage
    args.thriftPort = thriftPort
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_datanodeUp(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = datanodeUp_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    return

  def datanodeDown(self, name, storage, thriftPort):
    """
    Inform the namenode that a datanode process has stopped.

    Parameters:
     - name: <host name>:<port number> of the datanode
     - storage: the storage id of the datanode
     - thriftPort: Thrift port of the datanode
    """
    self.send_datanodeDown(name, storage, thriftPort)
    self.recv_datanodeDown()

  def send_datanodeDown(self, name, storage, thriftPort):
    self._oprot.writeMessageBegin('datanodeDown', TMessageType.CALL, self._seqid)
    args = datanodeDown_args()
    args.name = name
    args.storage = storage
    args.thriftPort = thriftPort
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_datanodeDown(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = datanodeDown_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    return

  def getDelegationToken(self, ctx, renewer):
    """
    Get an HDFS delegation token.

    Parameters:
     - ctx
     - renewer
    """
    self.send_getDelegationToken(ctx, renewer)
    return self.recv_getDelegationToken()

  def send_getDelegationToken(self, ctx, renewer):
    self._oprot.writeMessageBegin('getDelegationToken', TMessageType.CALL, self._seqid)
    args = getDelegationToken_args()
    args.ctx = ctx
    args.renewer = renewer
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getDelegationToken(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getDelegationToken_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getDelegationToken failed: unknown result");


class Processor(hadoop.api.common.HadoopServiceBase.Processor, Iface, TProcessor):
  def __init__(self, handler):
    hadoop.api.common.HadoopServiceBase.Processor.__init__(self, handler)
    self._processMap["chmod"] = Processor.process_chmod
    self._processMap["chown"] = Processor.process_chown
    self._processMap["df"] = Processor.process_df
    self._processMap["enterSafeMode"] = Processor.process_enterSafeMode
    self._processMap["getBlocks"] = Processor.process_getBlocks
    self._processMap["getPreferredBlockSize"] = Processor.process_getPreferredBlockSize
    self._processMap["isInSafeMode"] = Processor.process_isInSafeMode
    self._processMap["leaveSafeMode"] = Processor.process_leaveSafeMode
    self._processMap["ls"] = Processor.process_ls
    self._processMap["mkdirhier"] = Processor.process_mkdirhier
    self._processMap["refreshNodes"] = Processor.process_refreshNodes
    self._processMap["rename"] = Processor.process_rename
    self._processMap["reportBadBlocks"] = Processor.process_reportBadBlocks
    self._processMap["stat"] = Processor.process_stat
    self._processMap["getContentSummary"] = Processor.process_getContentSummary
    self._processMap["multiGetContentSummary"] = Processor.process_multiGetContentSummary
    self._processMap["setQuota"] = Processor.process_setQuota
    self._processMap["setReplication"] = Processor.process_setReplication
    self._processMap["unlink"] = Processor.process_unlink
    self._processMap["utime"] = Processor.process_utime
    self._processMap["datanodeUp"] = Processor.process_datanodeUp
    self._processMap["datanodeDown"] = Processor.process_datanodeDown
    self._processMap["getDelegationToken"] = Processor.process_getDelegationToken

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_chmod(self, seqid, iprot, oprot):
    args = chmod_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = chmod_result()
    try:
      self._handler.chmod(args.ctx, args.path, args.perms)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("chmod", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_chown(self, seqid, iprot, oprot):
    args = chown_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = chown_result()
    try:
      self._handler.chown(args.ctx, args.path, args.owner, args.group)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("chown", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_df(self, seqid, iprot, oprot):
    args = df_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = df_result()
    result.success = self._handler.df(args.ctx)
    oprot.writeMessageBegin("df", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_enterSafeMode(self, seqid, iprot, oprot):
    args = enterSafeMode_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = enterSafeMode_result()
    try:
      self._handler.enterSafeMode(args.ctx)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("enterSafeMode", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getBlocks(self, seqid, iprot, oprot):
    args = getBlocks_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getBlocks_result()
    try:
      result.success = self._handler.getBlocks(args.ctx, args.path, args.offset, args.length)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("getBlocks", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getPreferredBlockSize(self, seqid, iprot, oprot):
    args = getPreferredBlockSize_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getPreferredBlockSize_result()
    try:
      result.success = self._handler.getPreferredBlockSize(args.ctx, args.path)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("getPreferredBlockSize", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_isInSafeMode(self, seqid, iprot, oprot):
    args = isInSafeMode_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = isInSafeMode_result()
    try:
      result.success = self._handler.isInSafeMode(args.ctx)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("isInSafeMode", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_leaveSafeMode(self, seqid, iprot, oprot):
    args = leaveSafeMode_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = leaveSafeMode_result()
    try:
      self._handler.leaveSafeMode(args.ctx)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("leaveSafeMode", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_ls(self, seqid, iprot, oprot):
    args = ls_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = ls_result()
    try:
      result.success = self._handler.ls(args.ctx, args.path)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("ls", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mkdirhier(self, seqid, iprot, oprot):
    args = mkdirhier_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mkdirhier_result()
    try:
      result.success = self._handler.mkdirhier(args.ctx, args.path, args.perms)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("mkdirhier", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_refreshNodes(self, seqid, iprot, oprot):
    args = refreshNodes_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = refreshNodes_result()
    try:
      self._handler.refreshNodes(args.ctx)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("refreshNodes", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_rename(self, seqid, iprot, oprot):
    args = rename_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = rename_result()
    try:
      result.success = self._handler.rename(args.ctx, args.path, args.newPath)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("rename", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_reportBadBlocks(self, seqid, iprot, oprot):
    args = reportBadBlocks_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = reportBadBlocks_result()
    try:
      self._handler.reportBadBlocks(args.ctx, args.blocks)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("reportBadBlocks", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_stat(self, seqid, iprot, oprot):
    args = stat_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = stat_result()
    try:
      result.success = self._handler.stat(args.ctx, args.path)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("stat", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getContentSummary(self, seqid, iprot, oprot):
    args = getContentSummary_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getContentSummary_result()
    try:
      result.success = self._handler.getContentSummary(args.ctx, args.Path)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("getContentSummary", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_multiGetContentSummary(self, seqid, iprot, oprot):
    args = multiGetContentSummary_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = multiGetContentSummary_result()
    try:
      result.success = self._handler.multiGetContentSummary(args.ctx, args.paths)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("multiGetContentSummary", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_setQuota(self, seqid, iprot, oprot):
    args = setQuota_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = setQuota_result()
    try:
      self._handler.setQuota(args.ctx, args.path, args.namespaceQuota, args.diskspaceQuota)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("setQuota", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_setReplication(self, seqid, iprot, oprot):
    args = setReplication_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = setReplication_result()
    try:
      result.success = self._handler.setReplication(args.ctx, args.path, args.replication)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("setReplication", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_unlink(self, seqid, iprot, oprot):
    args = unlink_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = unlink_result()
    try:
      result.success = self._handler.unlink(args.ctx, args.path, args.recursive)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("unlink", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_utime(self, seqid, iprot, oprot):
    args = utime_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = utime_result()
    try:
      self._handler.utime(args.ctx, args.path, args.atime, args.mtime)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("utime", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_datanodeUp(self, seqid, iprot, oprot):
    args = datanodeUp_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = datanodeUp_result()
    self._handler.datanodeUp(args.name, args.storage, args.thriftPort)
    oprot.writeMessageBegin("datanodeUp", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_datanodeDown(self, seqid, iprot, oprot):
    args = datanodeDown_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = datanodeDown_result()
    self._handler.datanodeDown(args.name, args.storage, args.thriftPort)
    oprot.writeMessageBegin("datanodeDown", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getDelegationToken(self, seqid, iprot, oprot):
    args = getDelegationToken_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getDelegationToken_result()
    try:
      result.success = self._handler.getDelegationToken(args.ctx, args.renewer)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("getDelegationToken", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class chmod_args(object):
  """
  Attributes:
   - ctx
   - path: Path of the file or directory.
   - perms: New permissions for the file or directory.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.I16, 'perms', None, None, ), # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None, perms=None,):
    self.ctx = ctx
    self.path = path
    self.perms = perms

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I16:
          self.perms = iprot.readI16();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('chmod_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.perms is not None:
      oprot.writeFieldBegin('perms', TType.I16, 2)
      oprot.writeI16(self.perms)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class chmod_result(object):
  """
  Attributes:
   - err
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, err=None,):
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('chmod_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class chown_args(object):
  """
  Attributes:
   - ctx
   - path: Path to the file or directory
   - owner: New owner.
   - group: New group.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.STRING, 'owner', None, None, ), # 2
    (3, TType.STRING, 'group', None, None, ), # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None, owner=None, group=None,):
    self.ctx = ctx
    self.path = path
    self.owner = owner
    self.group = group

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.owner = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.group = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('chown_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.owner is not None:
      oprot.writeFieldBegin('owner', TType.STRING, 2)
      oprot.writeString(self.owner)
      oprot.writeFieldEnd()
    if self.group is not None:
      oprot.writeFieldBegin('group', TType.STRING, 3)
      oprot.writeString(self.group)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class chown_result(object):
  """
  Attributes:
   - err
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, err=None,):
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('chown_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class df_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('df_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class df_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.I64,None), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype10, _size7) = iprot.readListBegin()
          for _i11 in xrange(_size7):
            _elem12 = iprot.readI64();
            self.success.append(_elem12)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('df_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.I64, len(self.success))
      for iter13 in self.success:
        oprot.writeI64(iter13)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class enterSafeMode_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enterSafeMode_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class enterSafeMode_result(object):
  """
  Attributes:
   - err
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, err=None,):
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enterSafeMode_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getBlocks_args(object):
  """
  Attributes:
   - ctx
   - path: Path to the file.
   - offset: Offset of the region.
   - length: Length of the region
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.I64, 'offset', None, None, ), # 2
    (3, TType.I64, 'length', None, None, ), # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None, offset=None, length=None,):
    self.ctx = ctx
    self.path = path
    self.offset = offset
    self.length = length

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.offset = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.length = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getBlocks_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.offset is not None:
      oprot.writeFieldBegin('offset', TType.I64, 2)
      oprot.writeI64(self.offset)
      oprot.writeFieldEnd()
    if self.length is not None:
      oprot.writeFieldBegin('length', TType.I64, 3)
      oprot.writeI64(self.length)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getBlocks_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(Block, Block.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype17, _size14) = iprot.readListBegin()
          for _i18 in xrange(_size14):
            _elem19 = Block()
            _elem19.read(iprot)
            self.success.append(_elem19)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getBlocks_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter20 in self.success:
        iter20.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getPreferredBlockSize_args(object):
  """
  Attributes:
   - ctx
   - path: Path to the file.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None,):
    self.ctx = ctx
    self.path = path

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getPreferredBlockSize_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getPreferredBlockSize_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.I64, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I64:
          self.success = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getPreferredBlockSize_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I64, 0)
      oprot.writeI64(self.success)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class isInSafeMode_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('isInSafeMode_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class isInSafeMode_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('isInSafeMode_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class leaveSafeMode_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('leaveSafeMode_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class leaveSafeMode_result(object):
  """
  Attributes:
   - err
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, err=None,):
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('leaveSafeMode_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ls_args(object):
  """
  Attributes:
   - ctx
   - path: Path to the directory.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None,):
    self.ctx = ctx
    self.path = path

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ls_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ls_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(Stat, Stat.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype24, _size21) = iprot.readListBegin()
          for _i25 in xrange(_size21):
            _elem26 = Stat()
            _elem26.read(iprot)
            self.success.append(_elem26)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ls_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter27 in self.success:
        iter27.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mkdirhier_args(object):
  """
  Attributes:
   - ctx
   - path: Path to the directory.
   - perms: Access permissions of the directory.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.I16, 'perms', None, None, ), # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None, perms=None,):
    self.ctx = ctx
    self.path = path
    self.perms = perms

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I16:
          self.perms = iprot.readI16();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mkdirhier_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.perms is not None:
      oprot.writeFieldBegin('perms', TType.I16, 2)
      oprot.writeI16(self.perms)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mkdirhier_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mkdirhier_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class refreshNodes_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('refreshNodes_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class refreshNodes_result(object):
  """
  Attributes:
   - err
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, err=None,):
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('refreshNodes_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class rename_args(object):
  """
  Attributes:
   - ctx
   - path: Path to existing file or directory.
   - newPath: New path.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.STRING, 'newPath', None, None, ), # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None, newPath=None,):
    self.ctx = ctx
    self.path = path
    self.newPath = newPath

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.newPath = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('rename_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.newPath is not None:
      oprot.writeFieldBegin('newPath', TType.STRING, 2)
      oprot.writeString(self.newPath)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class rename_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('rename_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class reportBadBlocks_args(object):
  """
  Attributes:
   - ctx
   - blocks: List of corrupted blocks.
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'blocks', (TType.STRUCT,(Block, Block.thrift_spec)), None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, blocks=None,):
    self.ctx = ctx
    self.blocks = blocks

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.LIST:
          self.blocks = []
          (_etype31, _size28) = iprot.readListBegin()
          for _i32 in xrange(_size28):
            _elem33 = Block()
            _elem33.read(iprot)
            self.blocks.append(_elem33)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('reportBadBlocks_args')
    if self.blocks is not None:
      oprot.writeFieldBegin('blocks', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.blocks))
      for iter34 in self.blocks:
        iter34.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class reportBadBlocks_result(object):
  """
  Attributes:
   - err
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, err=None,):
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('reportBadBlocks_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class stat_args(object):
  """
  Attributes:
   - ctx
   - path: Path of the file or directory.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None,):
    self.ctx = ctx
    self.path = path

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('stat_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class stat_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (Stat, Stat.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = Stat()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('stat_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getContentSummary_args(object):
  """
  Attributes:
   - ctx
   - Path
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'Path', None, None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, Path=None,):
    self.ctx = ctx
    self.Path = Path

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.Path = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getContentSummary_args')
    if self.Path is not None:
      oprot.writeFieldBegin('Path', TType.STRING, 1)
      oprot.writeString(self.Path)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getContentSummary_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ContentSummary, ContentSummary.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ContentSummary()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getContentSummary_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class multiGetContentSummary_args(object):
  """
  Attributes:
   - ctx
   - paths
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'paths', (TType.STRING,None), None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, paths=None,):
    self.ctx = ctx
    self.paths = paths

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.LIST:
          self.paths = []
          (_etype38, _size35) = iprot.readListBegin()
          for _i39 in xrange(_size35):
            _elem40 = iprot.readString();
            self.paths.append(_elem40)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('multiGetContentSummary_args')
    if self.paths is not None:
      oprot.writeFieldBegin('paths', TType.LIST, 1)
      oprot.writeListBegin(TType.STRING, len(self.paths))
      for iter41 in self.paths:
        oprot.writeString(iter41)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class multiGetContentSummary_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(ContentSummary, ContentSummary.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype45, _size42) = iprot.readListBegin()
          for _i46 in xrange(_size42):
            _elem47 = ContentSummary()
            _elem47.read(iprot)
            self.success.append(_elem47)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('multiGetContentSummary_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter48 in self.success:
        iter48.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setQuota_args(object):
  """
  Attributes:
   - ctx
   - path: Path of the directory.
   - namespaceQuota: Limit on the number of names in the directory.
   - diskspaceQuota: Limit on disk space occupied by all the files in the
  directory.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.I64, 'namespaceQuota', None, None, ), # 2
    (3, TType.I64, 'diskspaceQuota', None, None, ), # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None, namespaceQuota=None, diskspaceQuota=None,):
    self.ctx = ctx
    self.path = path
    self.namespaceQuota = namespaceQuota
    self.diskspaceQuota = diskspaceQuota

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.namespaceQuota = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.diskspaceQuota = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setQuota_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.namespaceQuota is not None:
      oprot.writeFieldBegin('namespaceQuota', TType.I64, 2)
      oprot.writeI64(self.namespaceQuota)
      oprot.writeFieldEnd()
    if self.diskspaceQuota is not None:
      oprot.writeFieldBegin('diskspaceQuota', TType.I64, 3)
      oprot.writeI64(self.diskspaceQuota)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setQuota_result(object):
  """
  Attributes:
   - err
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, err=None,):
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setQuota_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setReplication_args(object):
  """
  Attributes:
   - ctx
   - path: Path of the file.
   - replication: New replication factor.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.I16, 'replication', None, None, ), # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None, replication=None,):
    self.ctx = ctx
    self.path = path
    self.replication = replication

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I16:
          self.replication = iprot.readI16();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setReplication_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.replication is not None:
      oprot.writeFieldBegin('replication', TType.I16, 2)
      oprot.writeI16(self.replication)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setReplication_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setReplication_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unlink_args(object):
  """
  Attributes:
   - ctx
   - path: Path of the file or directory.
   - recursive: Delete a non-empty directory recursively.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.BOOL, 'recursive', None, None, ), # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None, recursive=None,):
    self.ctx = ctx
    self.path = path
    self.recursive = recursive

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.BOOL:
          self.recursive = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unlink_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.recursive is not None:
      oprot.writeFieldBegin('recursive', TType.BOOL, 2)
      oprot.writeBool(self.recursive)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unlink_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unlink_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class utime_args(object):
  """
  Attributes:
   - ctx
   - path: Path of the file or directory.
   - atime: Access time in milliseconds since 1970-01-01 00:00 UTC
   - mtime: Modification time in milliseconds since 1970-01-01 00:00 UTC
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.I64, 'atime', None, None, ), # 2
    (3, TType.I64, 'mtime', None, None, ), # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, path=None, atime=None, mtime=None,):
    self.ctx = ctx
    self.path = path
    self.atime = atime
    self.mtime = mtime

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.atime = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.mtime = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('utime_args')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path)
      oprot.writeFieldEnd()
    if self.atime is not None:
      oprot.writeFieldBegin('atime', TType.I64, 2)
      oprot.writeI64(self.atime)
      oprot.writeFieldEnd()
    if self.mtime is not None:
      oprot.writeFieldBegin('mtime', TType.I64, 3)
      oprot.writeI64(self.mtime)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class utime_result(object):
  """
  Attributes:
   - err
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, err=None,):
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('utime_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class datanodeUp_args(object):
  """
  Attributes:
   - name: <host name>:<port number> of the datanode
   - storage: the storage id of the datanode
   - thriftPort: Thrift port of the datanode
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'name', None, None, ), # 1
    (2, TType.STRING, 'storage', None, None, ), # 2
    (3, TType.I32, 'thriftPort', None, None, ), # 3
  )

  def __init__(self, name=None, storage=None, thriftPort=None,):
    self.name = name
    self.storage = storage
    self.thriftPort = thriftPort

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.storage = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.thriftPort = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('datanodeUp_args')
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 1)
      oprot.writeString(self.name)
      oprot.writeFieldEnd()
    if self.storage is not None:
      oprot.writeFieldBegin('storage', TType.STRING, 2)
      oprot.writeString(self.storage)
      oprot.writeFieldEnd()
    if self.thriftPort is not None:
      oprot.writeFieldBegin('thriftPort', TType.I32, 3)
      oprot.writeI32(self.thriftPort)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class datanodeUp_result(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('datanodeUp_result')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class datanodeDown_args(object):
  """
  Attributes:
   - name: <host name>:<port number> of the datanode
   - storage: the storage id of the datanode
   - thriftPort: Thrift port of the datanode
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'name', None, None, ), # 1
    (2, TType.STRING, 'storage', None, None, ), # 2
    (3, TType.I32, 'thriftPort', None, None, ), # 3
  )

  def __init__(self, name=None, storage=None, thriftPort=None,):
    self.name = name
    self.storage = storage
    self.thriftPort = thriftPort

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.storage = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.thriftPort = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('datanodeDown_args')
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 1)
      oprot.writeString(self.name)
      oprot.writeFieldEnd()
    if self.storage is not None:
      oprot.writeFieldBegin('storage', TType.STRING, 2)
      oprot.writeString(self.storage)
      oprot.writeFieldEnd()
    if self.thriftPort is not None:
      oprot.writeFieldBegin('thriftPort', TType.I32, 3)
      oprot.writeI32(self.thriftPort)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class datanodeDown_result(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('datanodeDown_result')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDelegationToken_args(object):
  """
  Attributes:
   - ctx
   - renewer
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'renewer', None, None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, renewer=None,):
    self.ctx = ctx
    self.renewer = renewer

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.renewer = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDelegationToken_args')
    if self.renewer is not None:
      oprot.writeFieldBegin('renewer', TType.STRING, 1)
      oprot.writeString(self.renewer)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDelegationToken_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (hadoop.api.common.ttypes.ThriftDelegationToken, hadoop.api.common.ttypes.ThriftDelegationToken.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = hadoop.api.common.ttypes.ThriftDelegationToken()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDelegationToken_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
