require File.join(Rails.root, 'spec', 'factory')

Factory.add(:project, Project) do |obj|
  obj.name = Faker::Internet.user_name
  obj.path = '/tmp/legit_test/legit'
end

Factory.add(:public_project, Project) do |obj|
  obj.name = Faker::Internet.user_name
  obj.path = '/tmp/legit_test/legit'
  obj.private_flag = false
end

Factory.add(:user, User) do |obj|
  obj.email = Faker::Internet.email
  obj.password = "123456"
  obj.name = Faker::Name.name
  obj.password_confirmation = "123456"
end
