// Code generated by kmipgen; DO NOT EDIT.
package kmip14

import (
	"github.com/gemalto/kmip-go/ttlv"
)

const (
	TagActivationDate                        ttlv.Tag = 0x420001
	TagApplicationData                       ttlv.Tag = 0x420002
	TagApplicationNamespace                  ttlv.Tag = 0x420003
	TagApplicationSpecificInformation        ttlv.Tag = 0x420004
	TagArchiveDate                           ttlv.Tag = 0x420005
	TagAsynchronousCorrelationValue          ttlv.Tag = 0x420006
	TagAsynchronousIndicator                 ttlv.Tag = 0x420007
	TagAttribute                             ttlv.Tag = 0x420008
	TagAttributeIndex                        ttlv.Tag = 0x420009
	TagAttributeName                         ttlv.Tag = 0x42000a
	TagAttributeValue                        ttlv.Tag = 0x42000b
	TagAuthentication                        ttlv.Tag = 0x42000c
	TagBatchCount                            ttlv.Tag = 0x42000d
	TagBatchErrorContinuationOption          ttlv.Tag = 0x42000e
	TagBatchItem                             ttlv.Tag = 0x42000f
	TagBatchOrderOption                      ttlv.Tag = 0x420010
	TagBlockCipherMode                       ttlv.Tag = 0x420011
	TagCancellationResult                    ttlv.Tag = 0x420012
	TagCertificate                           ttlv.Tag = 0x420013
	TagCertificateIdentifier                 ttlv.Tag = 0x420014
	TagCertificateIssuer                     ttlv.Tag = 0x420015
	TagCertificateIssuerAlternativeName      ttlv.Tag = 0x420016
	TagCertificateIssuerDistinguishedName    ttlv.Tag = 0x420017
	TagCertificateRequest                    ttlv.Tag = 0x420018
	TagCertificateRequestType                ttlv.Tag = 0x420019
	TagCertificateSubject                    ttlv.Tag = 0x42001a
	TagCertificateSubjectAlternativeName     ttlv.Tag = 0x42001b
	TagCertificateSubjectDistinguishedName   ttlv.Tag = 0x42001c
	TagCertificateType                       ttlv.Tag = 0x42001d
	TagCertificateValue                      ttlv.Tag = 0x42001e
	TagCommonTemplateAttribute               ttlv.Tag = 0x42001f
	TagCompromiseDate                        ttlv.Tag = 0x420020
	TagCompromiseOccurrenceDate              ttlv.Tag = 0x420021
	TagContactInformation                    ttlv.Tag = 0x420022
	TagCredential                            ttlv.Tag = 0x420023
	TagCredentialType                        ttlv.Tag = 0x420024
	TagCredentialValue                       ttlv.Tag = 0x420025
	TagCriticalityIndicator                  ttlv.Tag = 0x420026
	TagCRTCoefficient                        ttlv.Tag = 0x420027
	TagCryptographicAlgorithm                ttlv.Tag = 0x420028
	TagCryptographicDomainParameters         ttlv.Tag = 0x420029
	TagCryptographicLength                   ttlv.Tag = 0x42002a
	TagCryptographicParameters               ttlv.Tag = 0x42002b
	TagCryptographicUsageMask                ttlv.Tag = 0x42002c
	TagCustomAttribute                       ttlv.Tag = 0x42002d
	TagD                                     ttlv.Tag = 0x42002e
	TagDeactivationDate                      ttlv.Tag = 0x42002f
	TagDerivationData                        ttlv.Tag = 0x420030
	TagDerivationMethod                      ttlv.Tag = 0x420031
	TagDerivationParameters                  ttlv.Tag = 0x420032
	TagDestroyDate                           ttlv.Tag = 0x420033
	TagDigest                                ttlv.Tag = 0x420034
	TagDigestValue                           ttlv.Tag = 0x420035
	TagEncryptionKeyInformation              ttlv.Tag = 0x420036
	TagG                                     ttlv.Tag = 0x420037
	TagHashingAlgorithm                      ttlv.Tag = 0x420038
	TagInitialDate                           ttlv.Tag = 0x420039
	TagInitializationVector                  ttlv.Tag = 0x42003a
	TagIssuer                                ttlv.Tag = 0x42003b
	TagIterationCount                        ttlv.Tag = 0x42003c
	TagIVCounterNonce                        ttlv.Tag = 0x42003d
	TagJ                                     ttlv.Tag = 0x42003e
	TagKey                                   ttlv.Tag = 0x42003f
	TagKeyBlock                              ttlv.Tag = 0x420040
	TagKeyCompressionType                    ttlv.Tag = 0x420041
	TagKeyFormatType                         ttlv.Tag = 0x420042
	TagKeyMaterial                           ttlv.Tag = 0x420043
	TagKeyPartIdentifier                     ttlv.Tag = 0x420044
	TagKeyValue                              ttlv.Tag = 0x420045
	TagKeyWrappingData                       ttlv.Tag = 0x420046
	TagKeyWrappingSpecification              ttlv.Tag = 0x420047
	TagLastChangeDate                        ttlv.Tag = 0x420048
	TagLeaseTime                             ttlv.Tag = 0x420049
	TagLink                                  ttlv.Tag = 0x42004a
	TagLinkType                              ttlv.Tag = 0x42004b
	TagLinkedObjectIdentifier                ttlv.Tag = 0x42004c
	TagMACSignature                          ttlv.Tag = 0x42004d
	TagMACSignatureKeyInformation            ttlv.Tag = 0x42004e
	TagMaximumItems                          ttlv.Tag = 0x42004f
	TagMaximumResponseSize                   ttlv.Tag = 0x420050
	TagMessageExtension                      ttlv.Tag = 0x420051
	TagModulus                               ttlv.Tag = 0x420052
	TagName                                  ttlv.Tag = 0x420053
	TagNameType                              ttlv.Tag = 0x420054
	TagNameValue                             ttlv.Tag = 0x420055
	TagObjectGroup                           ttlv.Tag = 0x420056
	TagObjectType                            ttlv.Tag = 0x420057
	TagOffset                                ttlv.Tag = 0x420058
	TagOpaqueDataType                        ttlv.Tag = 0x420059
	TagOpaqueDataValue                       ttlv.Tag = 0x42005a
	TagOpaqueObject                          ttlv.Tag = 0x42005b
	TagOperation                             ttlv.Tag = 0x42005c
	TagOperationPolicyName                   ttlv.Tag = 0x42005d
	TagP                                     ttlv.Tag = 0x42005e
	TagPaddingMethod                         ttlv.Tag = 0x42005f
	TagPrimeExponentP                        ttlv.Tag = 0x420060
	TagPrimeExponentQ                        ttlv.Tag = 0x420061
	TagPrimeFieldSize                        ttlv.Tag = 0x420062
	TagPrivateExponent                       ttlv.Tag = 0x420063
	TagPrivateKey                            ttlv.Tag = 0x420064
	TagPrivateKeyTemplateAttribute           ttlv.Tag = 0x420065
	TagPrivateKeyUniqueIdentifier            ttlv.Tag = 0x420066
	TagProcessStartDate                      ttlv.Tag = 0x420067
	TagProtectStopDate                       ttlv.Tag = 0x420068
	TagProtocolVersion                       ttlv.Tag = 0x420069
	TagProtocolVersionMajor                  ttlv.Tag = 0x42006a
	TagProtocolVersionMinor                  ttlv.Tag = 0x42006b
	TagPublicExponent                        ttlv.Tag = 0x42006c
	TagPublicKey                             ttlv.Tag = 0x42006d
	TagPublicKeyTemplateAttribute            ttlv.Tag = 0x42006e
	TagPublicKeyUniqueIdentifier             ttlv.Tag = 0x42006f
	TagPutFunction                           ttlv.Tag = 0x420070
	TagQ                                     ttlv.Tag = 0x420071
	TagQString                               ttlv.Tag = 0x420072
	TagQlength                               ttlv.Tag = 0x420073
	TagQueryFunction                         ttlv.Tag = 0x420074
	TagRecommendedCurve                      ttlv.Tag = 0x420075
	TagReplacedUniqueIdentifier              ttlv.Tag = 0x420076
	TagRequestHeader                         ttlv.Tag = 0x420077
	TagRequestMessage                        ttlv.Tag = 0x420078
	TagRequestPayload                        ttlv.Tag = 0x420079
	TagResponseHeader                        ttlv.Tag = 0x42007a
	TagResponseMessage                       ttlv.Tag = 0x42007b
	TagResponsePayload                       ttlv.Tag = 0x42007c
	TagResultMessage                         ttlv.Tag = 0x42007d
	TagResultReason                          ttlv.Tag = 0x42007e
	TagResultStatus                          ttlv.Tag = 0x42007f
	TagRevocationMessage                     ttlv.Tag = 0x420080
	TagRevocationReason                      ttlv.Tag = 0x420081
	TagRevocationReasonCode                  ttlv.Tag = 0x420082
	TagKeyRoleType                           ttlv.Tag = 0x420083
	TagSalt                                  ttlv.Tag = 0x420084
	TagSecretData                            ttlv.Tag = 0x420085
	TagSecretDataType                        ttlv.Tag = 0x420086
	TagSerialNumber                          ttlv.Tag = 0x420087
	TagServerInformation                     ttlv.Tag = 0x420088
	TagSplitKey                              ttlv.Tag = 0x420089
	TagSplitKeyMethod                        ttlv.Tag = 0x42008a
	TagSplitKeyParts                         ttlv.Tag = 0x42008b
	TagSplitKeyThreshold                     ttlv.Tag = 0x42008c
	TagState                                 ttlv.Tag = 0x42008d
	TagStorageStatusMask                     ttlv.Tag = 0x42008e
	TagSymmetricKey                          ttlv.Tag = 0x42008f
	TagTemplate                              ttlv.Tag = 0x420090
	TagTemplateAttribute                     ttlv.Tag = 0x420091
	TagTimeStamp                             ttlv.Tag = 0x420092
	TagUniqueBatchItemID                     ttlv.Tag = 0x420093
	TagUniqueIdentifier                      ttlv.Tag = 0x420094
	TagUsageLimits                           ttlv.Tag = 0x420095
	TagUsageLimitsCount                      ttlv.Tag = 0x420096
	TagUsageLimitsTotal                      ttlv.Tag = 0x420097
	TagUsageLimitsUnit                       ttlv.Tag = 0x420098
	TagUsername                              ttlv.Tag = 0x420099
	TagValidityDate                          ttlv.Tag = 0x42009a
	TagValidityIndicator                     ttlv.Tag = 0x42009b
	TagVendorExtension                       ttlv.Tag = 0x42009c
	TagVendorIdentification                  ttlv.Tag = 0x42009d
	TagWrappingMethod                        ttlv.Tag = 0x42009e
	TagX                                     ttlv.Tag = 0x42009f
	TagY                                     ttlv.Tag = 0x4200a0
	TagPassword                              ttlv.Tag = 0x4200a1
	TagDeviceIdentifier                      ttlv.Tag = 0x4200a2
	TagEncodingOption                        ttlv.Tag = 0x4200a3
	TagExtensionInformation                  ttlv.Tag = 0x4200a4
	TagExtensionName                         ttlv.Tag = 0x4200a5
	TagExtensionTag                          ttlv.Tag = 0x4200a6
	TagExtensionType                         ttlv.Tag = 0x4200a7
	TagFresh                                 ttlv.Tag = 0x4200a8
	TagMachineIdentifier                     ttlv.Tag = 0x4200a9
	TagMediaIdentifier                       ttlv.Tag = 0x4200aa
	TagNetworkIdentifier                     ttlv.Tag = 0x4200ab
	TagObjectGroupMember                     ttlv.Tag = 0x4200ac
	TagCertificateLength                     ttlv.Tag = 0x4200ad
	TagDigitalSignatureAlgorithm             ttlv.Tag = 0x4200ae
	TagCertificateSerialNumber               ttlv.Tag = 0x4200af
	TagDeviceSerialNumber                    ttlv.Tag = 0x4200b0
	TagIssuerAlternativeName                 ttlv.Tag = 0x4200b1
	TagIssuerDistinguishedName               ttlv.Tag = 0x4200b2
	TagSubjectAlternativeName                ttlv.Tag = 0x4200b3
	TagSubjectDistinguishedName              ttlv.Tag = 0x4200b4
	TagX_509CertificateIdentifier            ttlv.Tag = 0x4200b5
	TagX_509CertificateIssuer                ttlv.Tag = 0x4200b6
	TagX_509CertificateSubject               ttlv.Tag = 0x4200b7
	TagKeyValueLocation                      ttlv.Tag = 0x4200b8
	TagKeyValueLocationValue                 ttlv.Tag = 0x4200b9
	TagKeyValueLocationType                  ttlv.Tag = 0x4200ba
	TagKeyValuePresent                       ttlv.Tag = 0x4200bb
	TagOriginalCreationDate                  ttlv.Tag = 0x4200bc
	TagPGPKey                                ttlv.Tag = 0x4200bd
	TagPGPKeyVersion                         ttlv.Tag = 0x4200be
	TagAlternativeName                       ttlv.Tag = 0x4200bf
	TagAlternativeNameValue                  ttlv.Tag = 0x4200c0
	TagAlternativeNameType                   ttlv.Tag = 0x4200c1
	TagData                                  ttlv.Tag = 0x4200c2
	TagSignatureData                         ttlv.Tag = 0x4200c3
	TagDataLength                            ttlv.Tag = 0x4200c4
	TagRandomIV                              ttlv.Tag = 0x4200c5
	TagMACData                               ttlv.Tag = 0x4200c6
	TagAttestationType                       ttlv.Tag = 0x4200c7
	TagNonce                                 ttlv.Tag = 0x4200c8
	TagNonceID                               ttlv.Tag = 0x4200c9
	TagNonceValue                            ttlv.Tag = 0x4200ca
	TagAttestationMeasurement                ttlv.Tag = 0x4200cb
	TagAttestationAssertion                  ttlv.Tag = 0x4200cc
	TagIVLength                              ttlv.Tag = 0x4200cd
	TagTagLength                             ttlv.Tag = 0x4200ce
	TagFixedFieldLength                      ttlv.Tag = 0x4200cf
	TagCounterLength                         ttlv.Tag = 0x4200d0
	TagInitialCounterValue                   ttlv.Tag = 0x4200d1
	TagInvocationFieldLength                 ttlv.Tag = 0x4200d2
	TagAttestationCapableIndicator           ttlv.Tag = 0x4200d3
	TagOffsetItems                           ttlv.Tag = 0x4200d4
	TagLocatedItems                          ttlv.Tag = 0x4200d5
	TagCorrelationValue                      ttlv.Tag = 0x4200d6
	TagInitIndicator                         ttlv.Tag = 0x4200d7
	TagFinalIndicator                        ttlv.Tag = 0x4200d8
	TagRNGParameters                         ttlv.Tag = 0x4200d9
	TagRNGAlgorithm                          ttlv.Tag = 0x4200da
	TagDRBGAlgorithm                         ttlv.Tag = 0x4200db
	TagFIPS186Variation                      ttlv.Tag = 0x4200dc
	TagPredictionResistance                  ttlv.Tag = 0x4200dd
	TagRandomNumberGenerator                 ttlv.Tag = 0x4200de
	TagValidationInformation                 ttlv.Tag = 0x4200df
	TagValidationAuthorityType               ttlv.Tag = 0x4200e0
	TagValidationAuthorityCountry            ttlv.Tag = 0x4200e1
	TagValidationAuthorityURI                ttlv.Tag = 0x4200e2
	TagValidationVersionMajor                ttlv.Tag = 0x4200e3
	TagValidationVersionMinor                ttlv.Tag = 0x4200e4
	TagValidationType                        ttlv.Tag = 0x4200e5
	TagValidationLevel                       ttlv.Tag = 0x4200e6
	TagValidationCertificateIdentifier       ttlv.Tag = 0x4200e7
	TagValidationCertificateURI              ttlv.Tag = 0x4200e8
	TagValidationVendorURI                   ttlv.Tag = 0x4200e9
	TagValidationProfile                     ttlv.Tag = 0x4200ea
	TagProfileInformation                    ttlv.Tag = 0x4200eb
	TagProfileName                           ttlv.Tag = 0x4200ec
	TagServerURI                             ttlv.Tag = 0x4200ed
	TagServerPort                            ttlv.Tag = 0x4200ee
	TagStreamingCapability                   ttlv.Tag = 0x4200ef
	TagAsynchronousCapability                ttlv.Tag = 0x4200f0
	TagAttestationCapability                 ttlv.Tag = 0x4200f1
	TagUnwrapMode                            ttlv.Tag = 0x4200f2
	TagDestroyAction                         ttlv.Tag = 0x4200f3
	TagShreddingAlgorithm                    ttlv.Tag = 0x4200f4
	TagRNGMode                               ttlv.Tag = 0x4200f5
	TagClientRegistrationMethod              ttlv.Tag = 0x4200f6
	TagCapabilityInformation                 ttlv.Tag = 0x4200f7
	TagKeyWrapType                           ttlv.Tag = 0x4200f8
	TagBatchUndoCapability                   ttlv.Tag = 0x4200f9
	TagBatchContinueCapability               ttlv.Tag = 0x4200fa
	TagPKCS_12FriendlyName                   ttlv.Tag = 0x4200fb
	TagDescription                           ttlv.Tag = 0x4200fc
	TagComment                               ttlv.Tag = 0x4200fd
	TagAuthenticatedEncryptionAdditionalData ttlv.Tag = 0x4200fe
	TagAuthenticatedEncryptionTag            ttlv.Tag = 0x4200ff
	TagSaltLength                            ttlv.Tag = 0x420100
	TagMaskGenerator                         ttlv.Tag = 0x420101
	TagMaskGeneratorHashingAlgorithm         ttlv.Tag = 0x420102
	TagPSource                               ttlv.Tag = 0x420103
	TagTrailerField                          ttlv.Tag = 0x420104
	TagClientCorrelationValue                ttlv.Tag = 0x420105
	TagServerCorrelationValue                ttlv.Tag = 0x420106
	TagDigestedData                          ttlv.Tag = 0x420107
	TagCertificateSubjectCN                  ttlv.Tag = 0x420108
	TagCertificateSubjectO                   ttlv.Tag = 0x420109
	TagCertificateSubjectOU                  ttlv.Tag = 0x42010a
	TagCertificateSubjectEmail               ttlv.Tag = 0x42010b
	TagCertificateSubjectC                   ttlv.Tag = 0x42010c
	TagCertificateSubjectST                  ttlv.Tag = 0x42010d
	TagCertificateSubjectL                   ttlv.Tag = 0x42010e
	TagCertificateSubjectUID                 ttlv.Tag = 0x42010f
	TagCertificateSubjectSerialNumber        ttlv.Tag = 0x420110
	TagCertificateSubjectTitle               ttlv.Tag = 0x420111
	TagCertificateSubjectDC                  ttlv.Tag = 0x420112
	TagCertificateSubjectDNQualifier         ttlv.Tag = 0x420113
	TagCertificateIssuerCN                   ttlv.Tag = 0x420114
	TagCertificateIssuerO                    ttlv.Tag = 0x420115
	TagCertificateIssuerOU                   ttlv.Tag = 0x420116
	TagCertificateIssuerEmail                ttlv.Tag = 0x420117
	TagCertificateIssuerC                    ttlv.Tag = 0x420118
	TagCertificateIssuerST                   ttlv.Tag = 0x420119
	TagCertificateIssuerL                    ttlv.Tag = 0x42011a
	TagCertificateIssuerUID                  ttlv.Tag = 0x42011b
	TagCertificateIssuerSerialNumber         ttlv.Tag = 0x42011c
	TagCertificateIssuerTitle                ttlv.Tag = 0x42011d
	TagCertificateIssuerDC                   ttlv.Tag = 0x42011e
	TagCertificateIssuerDNQualifier          ttlv.Tag = 0x42011f
	TagSensitive                             ttlv.Tag = 0x420120
	TagAlwaysSensitive                       ttlv.Tag = 0x420121
	TagExtractable                           ttlv.Tag = 0x420122
	TagNeverExtractable                      ttlv.Tag = 0x420123
	TagReplaceExisting                       ttlv.Tag = 0x420124
)

// Credential Type Enumeration
// 9.1.3.2.1 Table 289
type CredentialType uint32

const (
	CredentialTypeUsernameAndPassword CredentialType = 0x00000001
	CredentialTypeDevice              CredentialType = 0x00000002
	CredentialTypeAttestation         CredentialType = 0x00000003
)

var CredentialTypeEnum = NewCredentialTypeEnum()

func NewCredentialTypeEnum() ttlv.Enum {
	m := map[CredentialType]string{
		CredentialTypeUsernameAndPassword: "Username and Password",
		CredentialTypeDevice:              "Device",
		CredentialTypeAttestation:         "Attestation",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (c CredentialType) MarshalText() (text []byte, err error) {
	return []byte(c.String()), nil
}

func (c CredentialType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(c))
	return nil
}

func (c CredentialType) String() string {
	return ttlv.FormatEnum(uint32(c), &CredentialTypeEnum)
}

// Key Compression Type Enumeration
// 9.1.3.2.2 Table 290
type KeyCompressionType uint32

const (
	KeyCompressionTypeECPublicKeyTypeUncompressed         KeyCompressionType = 0x00000001
	KeyCompressionTypeECPublicKeyTypeX9_62CompressedPrime KeyCompressionType = 0x00000002
	KeyCompressionTypeECPublicKeyTypeX9_62CompressedChar2 KeyCompressionType = 0x00000003
	KeyCompressionTypeECPublicKeyTypeX9_62Hybrid          KeyCompressionType = 0x00000004
)

var KeyCompressionTypeEnum = NewKeyCompressionTypeEnum()

func NewKeyCompressionTypeEnum() ttlv.Enum {
	m := map[KeyCompressionType]string{
		KeyCompressionTypeECPublicKeyTypeUncompressed:         "EC Public Key Type Uncompressed",
		KeyCompressionTypeECPublicKeyTypeX9_62CompressedPrime: "EC Public Key Type X9.62 Compressed Prime",
		KeyCompressionTypeECPublicKeyTypeX9_62CompressedChar2: "EC Public Key Type X9.62 Compressed Char2",
		KeyCompressionTypeECPublicKeyTypeX9_62Hybrid:          "EC Public Key Type X9.62 Hybrid",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (k KeyCompressionType) MarshalText() (text []byte, err error) {
	return []byte(k.String()), nil
}

func (k KeyCompressionType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(k))
	return nil
}

func (k KeyCompressionType) String() string {
	return ttlv.FormatEnum(uint32(k), &KeyCompressionTypeEnum)
}

// Key Format Type Enumeration
// 9.1.3.2.3 Table 291
type KeyFormatType uint32

const (
	KeyFormatTypeRaw                        KeyFormatType = 0x00000001
	KeyFormatTypeOpaque                     KeyFormatType = 0x00000002
	KeyFormatTypePKCS_1                     KeyFormatType = 0x00000003
	KeyFormatTypePKCS_8                     KeyFormatType = 0x00000004
	KeyFormatTypeX_509                      KeyFormatType = 0x00000005
	KeyFormatTypeECPrivateKey               KeyFormatType = 0x00000006
	KeyFormatTypeTransparentSymmetricKey    KeyFormatType = 0x00000007
	KeyFormatTypeTransparentDSAPrivateKey   KeyFormatType = 0x00000008
	KeyFormatTypeTransparentDSAPublicKey    KeyFormatType = 0x00000009
	KeyFormatTypeTransparentRSAPrivateKey   KeyFormatType = 0x0000000a
	KeyFormatTypeTransparentRSAPublicKey    KeyFormatType = 0x0000000b
	KeyFormatTypeTransparentDHPrivateKey    KeyFormatType = 0x0000000c
	KeyFormatTypeTransparentDHPublicKey     KeyFormatType = 0x0000000d
	KeyFormatTypeTransparentECDSAPrivateKey KeyFormatType = 0x0000000e
	KeyFormatTypeTransparentECDSAPublicKey  KeyFormatType = 0x0000000f
	KeyFormatTypeTransparentECDHPrivateKey  KeyFormatType = 0x00000010
	KeyFormatTypeTransparentECDHPublicKey   KeyFormatType = 0x00000011
	KeyFormatTypeTransparentECMQVPrivateKey KeyFormatType = 0x00000012
	KeyFormatTypeTransparentECMQVPublicKey  KeyFormatType = 0x00000013
	KeyFormatTypeTransparentECPrivateKey    KeyFormatType = 0x00000014
	KeyFormatTypeTransparentECPublicKey     KeyFormatType = 0x00000015
	KeyFormatTypePKCS_12                    KeyFormatType = 0x00000016
)

var KeyFormatTypeEnum = NewKeyFormatTypeEnum()

func NewKeyFormatTypeEnum() ttlv.Enum {
	m := map[KeyFormatType]string{
		KeyFormatTypeRaw:                        "Raw",
		KeyFormatTypeOpaque:                     "Opaque",
		KeyFormatTypePKCS_1:                     "PKCS#1",
		KeyFormatTypePKCS_8:                     "PKCS#8",
		KeyFormatTypeX_509:                      "X.509",
		KeyFormatTypeECPrivateKey:               "ECPrivateKey",
		KeyFormatTypeTransparentSymmetricKey:    "Transparent Symmetric Key",
		KeyFormatTypeTransparentDSAPrivateKey:   "Transparent DSA Private Key",
		KeyFormatTypeTransparentDSAPublicKey:    "Transparent DSA Public Key",
		KeyFormatTypeTransparentRSAPrivateKey:   "Transparent RSA Private Key",
		KeyFormatTypeTransparentRSAPublicKey:    "Transparent RSA Public Key",
		KeyFormatTypeTransparentDHPrivateKey:    "Transparent DH Private Key",
		KeyFormatTypeTransparentDHPublicKey:     "Transparent DH Public Key",
		KeyFormatTypeTransparentECDSAPrivateKey: "Transparent ECDSA Private Key",
		KeyFormatTypeTransparentECDSAPublicKey:  "Transparent ECDSA Public Key",
		KeyFormatTypeTransparentECDHPrivateKey:  "Transparent ECDH Private Key",
		KeyFormatTypeTransparentECDHPublicKey:   "Transparent ECDH Public Key",
		KeyFormatTypeTransparentECMQVPrivateKey: "Transparent ECMQV Private Key",
		KeyFormatTypeTransparentECMQVPublicKey:  "Transparent ECMQV Public Key",
		KeyFormatTypeTransparentECPrivateKey:    "Transparent EC Private Key",
		KeyFormatTypeTransparentECPublicKey:     "Transparent EC Public Key",
		KeyFormatTypePKCS_12:                    "PKCS#12",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (k KeyFormatType) MarshalText() (text []byte, err error) {
	return []byte(k.String()), nil
}

func (k KeyFormatType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(k))
	return nil
}

func (k KeyFormatType) String() string {
	return ttlv.FormatEnum(uint32(k), &KeyFormatTypeEnum)
}

// Wrapping Method Enumeration
// 9.1.3.2.4 Table 292
type WrappingMethod uint32

const (
	WrappingMethodEncrypt            WrappingMethod = 0x00000001
	WrappingMethodMACSign            WrappingMethod = 0x00000002
	WrappingMethodEncryptThenMACSign WrappingMethod = 0x00000003
	WrappingMethodMACSignThenEncrypt WrappingMethod = 0x00000004
	WrappingMethodTR_31              WrappingMethod = 0x00000005
)

var WrappingMethodEnum = NewWrappingMethodEnum()

func NewWrappingMethodEnum() ttlv.Enum {
	m := map[WrappingMethod]string{
		WrappingMethodEncrypt:            "Encrypt",
		WrappingMethodMACSign:            "MAC/sign",
		WrappingMethodEncryptThenMACSign: "Encrypt then MAC/sign",
		WrappingMethodMACSignThenEncrypt: "MAC/sign then encrypt",
		WrappingMethodTR_31:              "TR-31",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (w WrappingMethod) MarshalText() (text []byte, err error) {
	return []byte(w.String()), nil
}

func (w WrappingMethod) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(w))
	return nil
}

func (w WrappingMethod) String() string {
	return ttlv.FormatEnum(uint32(w), &WrappingMethodEnum)
}

// Recommended Curve Enumeration
// 9.1.3.2.5 Table 293
type RecommendedCurve uint32

const (
	RecommendedCurveP_192            RecommendedCurve = 0x00000001
	RecommendedCurveK_163            RecommendedCurve = 0x00000002
	RecommendedCurveB_163            RecommendedCurve = 0x00000003
	RecommendedCurveP_224            RecommendedCurve = 0x00000004
	RecommendedCurveK_233            RecommendedCurve = 0x00000005
	RecommendedCurveB_233            RecommendedCurve = 0x00000006
	RecommendedCurveP_256            RecommendedCurve = 0x00000007
	RecommendedCurveK_283            RecommendedCurve = 0x00000008
	RecommendedCurveB_283            RecommendedCurve = 0x00000009
	RecommendedCurveP_384            RecommendedCurve = 0x0000000a
	RecommendedCurveK_409            RecommendedCurve = 0x0000000b
	RecommendedCurveB_409            RecommendedCurve = 0x0000000c
	RecommendedCurveP_521            RecommendedCurve = 0x0000000d
	RecommendedCurveK_571            RecommendedCurve = 0x0000000e
	RecommendedCurveB_571            RecommendedCurve = 0x0000000f
	RecommendedCurveSECP112R1        RecommendedCurve = 0x00000010
	RecommendedCurveSECP112R2        RecommendedCurve = 0x00000011
	RecommendedCurveSECP128R1        RecommendedCurve = 0x00000012
	RecommendedCurveSECP128R2        RecommendedCurve = 0x00000013
	RecommendedCurveSECP160K1        RecommendedCurve = 0x00000014
	RecommendedCurveSECP160R1        RecommendedCurve = 0x00000015
	RecommendedCurveSECP160R2        RecommendedCurve = 0x00000016
	RecommendedCurveSECP192K1        RecommendedCurve = 0x00000017
	RecommendedCurveSECP224K1        RecommendedCurve = 0x00000018
	RecommendedCurveSECP256K1        RecommendedCurve = 0x00000019
	RecommendedCurveSECT113R1        RecommendedCurve = 0x0000001a
	RecommendedCurveSECT113R2        RecommendedCurve = 0x0000001b
	RecommendedCurveSECT131R1        RecommendedCurve = 0x0000001c
	RecommendedCurveSECT131R2        RecommendedCurve = 0x0000001d
	RecommendedCurveSECT163R1        RecommendedCurve = 0x0000001e
	RecommendedCurveSECT193R1        RecommendedCurve = 0x0000001f
	RecommendedCurveSECT193R2        RecommendedCurve = 0x00000020
	RecommendedCurveSECT239K1        RecommendedCurve = 0x00000021
	RecommendedCurveANSIX9P192V2     RecommendedCurve = 0x00000022
	RecommendedCurveANSIX9P192V3     RecommendedCurve = 0x00000023
	RecommendedCurveANSIX9P239V1     RecommendedCurve = 0x00000024
	RecommendedCurveANSIX9P239V2     RecommendedCurve = 0x00000025
	RecommendedCurveANSIX9P239V3     RecommendedCurve = 0x00000026
	RecommendedCurveANSIX9C2PNB163V1 RecommendedCurve = 0x00000027
	RecommendedCurveANSIX9C2PNB163V2 RecommendedCurve = 0x00000028
	RecommendedCurveANSIX9C2PNB163V3 RecommendedCurve = 0x00000029
	RecommendedCurveANSIX9C2PNB176V1 RecommendedCurve = 0x0000002a
	RecommendedCurveANSIX9C2TNB191V1 RecommendedCurve = 0x0000002b
	RecommendedCurveANSIX9C2TNB191V2 RecommendedCurve = 0x0000002c
	RecommendedCurveANSIX9C2TNB191V3 RecommendedCurve = 0x0000002d
	RecommendedCurveANSIX9C2PNB208W1 RecommendedCurve = 0x0000002e
	RecommendedCurveANSIX9C2TNB239V1 RecommendedCurve = 0x0000002f
	RecommendedCurveANSIX9C2TNB239V2 RecommendedCurve = 0x00000030
	RecommendedCurveANSIX9C2TNB239V3 RecommendedCurve = 0x00000031
	RecommendedCurveANSIX9C2PNB272W1 RecommendedCurve = 0x00000032
	RecommendedCurveANSIX9C2PNB304W1 RecommendedCurve = 0x00000033
	RecommendedCurveANSIX9C2TNB359V1 RecommendedCurve = 0x00000034
	RecommendedCurveANSIX9C2PNB368W1 RecommendedCurve = 0x00000035
	RecommendedCurveANSIX9C2TNB431R1 RecommendedCurve = 0x00000036
	RecommendedCurveBRAINPOOLP160R1  RecommendedCurve = 0x00000037
	RecommendedCurveBRAINPOOLP160T1  RecommendedCurve = 0x00000038
	RecommendedCurveBRAINPOOLP192R1  RecommendedCurve = 0x00000039
	RecommendedCurveBRAINPOOLP192T1  RecommendedCurve = 0x0000003a
	RecommendedCurveBRAINPOOLP224R1  RecommendedCurve = 0x0000003b
	RecommendedCurveBRAINPOOLP224T1  RecommendedCurve = 0x0000003c
	RecommendedCurveBRAINPOOLP256R1  RecommendedCurve = 0x0000003d
	RecommendedCurveBRAINPOOLP256T1  RecommendedCurve = 0x0000003e
	RecommendedCurveBRAINPOOLP320R1  RecommendedCurve = 0x0000003f
	RecommendedCurveBRAINPOOLP320T1  RecommendedCurve = 0x00000040
	RecommendedCurveBRAINPOOLP384R1  RecommendedCurve = 0x00000041
	RecommendedCurveBRAINPOOLP384T1  RecommendedCurve = 0x00000042
	RecommendedCurveBRAINPOOLP512R1  RecommendedCurve = 0x00000043
	RecommendedCurveBRAINPOOLP512T1  RecommendedCurve = 0x00000044
)

var RecommendedCurveEnum = NewRecommendedCurveEnum()

func NewRecommendedCurveEnum() ttlv.Enum {
	m := map[RecommendedCurve]string{
		RecommendedCurveP_192:            "P-192",
		RecommendedCurveK_163:            "K-163",
		RecommendedCurveB_163:            "B-163",
		RecommendedCurveP_224:            "P-224",
		RecommendedCurveK_233:            "K-233",
		RecommendedCurveB_233:            "B-233",
		RecommendedCurveP_256:            "P-256",
		RecommendedCurveK_283:            "K-283",
		RecommendedCurveB_283:            "B-283",
		RecommendedCurveP_384:            "P-384",
		RecommendedCurveK_409:            "K-409",
		RecommendedCurveB_409:            "B-409",
		RecommendedCurveP_521:            "P-521",
		RecommendedCurveK_571:            "K-571",
		RecommendedCurveB_571:            "B-571",
		RecommendedCurveSECP112R1:        "SECP112R1",
		RecommendedCurveSECP112R2:        "SECP112R2",
		RecommendedCurveSECP128R1:        "SECP128R1",
		RecommendedCurveSECP128R2:        "SECP128R2",
		RecommendedCurveSECP160K1:        "SECP160K1",
		RecommendedCurveSECP160R1:        "SECP160R1",
		RecommendedCurveSECP160R2:        "SECP160R2",
		RecommendedCurveSECP192K1:        "SECP192K1",
		RecommendedCurveSECP224K1:        "SECP224K1",
		RecommendedCurveSECP256K1:        "SECP256K1",
		RecommendedCurveSECT113R1:        "SECT113R1",
		RecommendedCurveSECT113R2:        "SECT113R2",
		RecommendedCurveSECT131R1:        "SECT131R1",
		RecommendedCurveSECT131R2:        "SECT131R2",
		RecommendedCurveSECT163R1:        "SECT163R1",
		RecommendedCurveSECT193R1:        "SECT193R1",
		RecommendedCurveSECT193R2:        "SECT193R2",
		RecommendedCurveSECT239K1:        "SECT239K1",
		RecommendedCurveANSIX9P192V2:     "ANSIX9P192V2",
		RecommendedCurveANSIX9P192V3:     "ANSIX9P192V3",
		RecommendedCurveANSIX9P239V1:     "ANSIX9P239V1",
		RecommendedCurveANSIX9P239V2:     "ANSIX9P239V2",
		RecommendedCurveANSIX9P239V3:     "ANSIX9P239V3",
		RecommendedCurveANSIX9C2PNB163V1: "ANSIX9C2PNB163V1",
		RecommendedCurveANSIX9C2PNB163V2: "ANSIX9C2PNB163V2",
		RecommendedCurveANSIX9C2PNB163V3: "ANSIX9C2PNB163V3",
		RecommendedCurveANSIX9C2PNB176V1: "ANSIX9C2PNB176V1",
		RecommendedCurveANSIX9C2TNB191V1: "ANSIX9C2TNB191V1",
		RecommendedCurveANSIX9C2TNB191V2: "ANSIX9C2TNB191V2",
		RecommendedCurveANSIX9C2TNB191V3: "ANSIX9C2TNB191V3",
		RecommendedCurveANSIX9C2PNB208W1: "ANSIX9C2PNB208W1",
		RecommendedCurveANSIX9C2TNB239V1: "ANSIX9C2TNB239V1",
		RecommendedCurveANSIX9C2TNB239V2: "ANSIX9C2TNB239V2",
		RecommendedCurveANSIX9C2TNB239V3: "ANSIX9C2TNB239V3",
		RecommendedCurveANSIX9C2PNB272W1: "ANSIX9C2PNB272W1",
		RecommendedCurveANSIX9C2PNB304W1: "ANSIX9C2PNB304W1",
		RecommendedCurveANSIX9C2TNB359V1: "ANSIX9C2TNB359V1",
		RecommendedCurveANSIX9C2PNB368W1: "ANSIX9C2PNB368W1",
		RecommendedCurveANSIX9C2TNB431R1: "ANSIX9C2TNB431R1",
		RecommendedCurveBRAINPOOLP160R1:  "BRAINPOOLP160R1",
		RecommendedCurveBRAINPOOLP160T1:  "BRAINPOOLP160T1",
		RecommendedCurveBRAINPOOLP192R1:  "BRAINPOOLP192R1",
		RecommendedCurveBRAINPOOLP192T1:  "BRAINPOOLP192T1",
		RecommendedCurveBRAINPOOLP224R1:  "BRAINPOOLP224R1",
		RecommendedCurveBRAINPOOLP224T1:  "BRAINPOOLP224T1",
		RecommendedCurveBRAINPOOLP256R1:  "BRAINPOOLP256R1",
		RecommendedCurveBRAINPOOLP256T1:  "BRAINPOOLP256T1",
		RecommendedCurveBRAINPOOLP320R1:  "BRAINPOOLP320R1",
		RecommendedCurveBRAINPOOLP320T1:  "BRAINPOOLP320T1",
		RecommendedCurveBRAINPOOLP384R1:  "BRAINPOOLP384R1",
		RecommendedCurveBRAINPOOLP384T1:  "BRAINPOOLP384T1",
		RecommendedCurveBRAINPOOLP512R1:  "BRAINPOOLP512R1",
		RecommendedCurveBRAINPOOLP512T1:  "BRAINPOOLP512T1",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (r RecommendedCurve) MarshalText() (text []byte, err error) {
	return []byte(r.String()), nil
}

func (r RecommendedCurve) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(r))
	return nil
}

func (r RecommendedCurve) String() string {
	return ttlv.FormatEnum(uint32(r), &RecommendedCurveEnum)
}

// Certificate Type Enumeration
// 9.1.3.2.6 Table 294
type CertificateType uint32

const (
	CertificateTypeX_509 CertificateType = 0x00000001
	CertificateTypePGP   CertificateType = 0x00000002
)

var CertificateTypeEnum = NewCertificateTypeEnum()

func NewCertificateTypeEnum() ttlv.Enum {
	m := map[CertificateType]string{
		CertificateTypeX_509: "X.509",
		CertificateTypePGP:   "PGP",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (c CertificateType) MarshalText() (text []byte, err error) {
	return []byte(c.String()), nil
}

func (c CertificateType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(c))
	return nil
}

func (c CertificateType) String() string {
	return ttlv.FormatEnum(uint32(c), &CertificateTypeEnum)
}

// Digital Signature Algorithm Enumeration
// 9.1.3.2.7 Table 295
type DigitalSignatureAlgorithm uint32

const (
	DigitalSignatureAlgorithmMD2WithRSAEncryption      DigitalSignatureAlgorithm = 0x00000001
	DigitalSignatureAlgorithmMD5WithRSAEncryption      DigitalSignatureAlgorithm = 0x00000002
	DigitalSignatureAlgorithmSHA_1WithRSAEncryption    DigitalSignatureAlgorithm = 0x00000003
	DigitalSignatureAlgorithmSHA_224WithRSAEncryption  DigitalSignatureAlgorithm = 0x00000004
	DigitalSignatureAlgorithmSHA_256WithRSAEncryption  DigitalSignatureAlgorithm = 0x00000005
	DigitalSignatureAlgorithmSHA_384WithRSAEncryption  DigitalSignatureAlgorithm = 0x00000006
	DigitalSignatureAlgorithmSHA_512WithRSAEncryption  DigitalSignatureAlgorithm = 0x00000007
	DigitalSignatureAlgorithmRSASSA_PSS                DigitalSignatureAlgorithm = 0x00000008
	DigitalSignatureAlgorithmDSAWithSHA_1              DigitalSignatureAlgorithm = 0x00000009
	DigitalSignatureAlgorithmDSAWithSHA224             DigitalSignatureAlgorithm = 0x0000000a
	DigitalSignatureAlgorithmDSAWithSHA256             DigitalSignatureAlgorithm = 0x0000000b
	DigitalSignatureAlgorithmECDSAWithSHA_1            DigitalSignatureAlgorithm = 0x0000000c
	DigitalSignatureAlgorithmECDSAWithSHA224           DigitalSignatureAlgorithm = 0x0000000d
	DigitalSignatureAlgorithmECDSAWithSHA256           DigitalSignatureAlgorithm = 0x0000000e
	DigitalSignatureAlgorithmECDSAWithSHA384           DigitalSignatureAlgorithm = 0x0000000f
	DigitalSignatureAlgorithmECDSAWithSHA512           DigitalSignatureAlgorithm = 0x00000010
	DigitalSignatureAlgorithmSHA3_256WithRSAEncryption DigitalSignatureAlgorithm = 0x00000011
	DigitalSignatureAlgorithmSHA3_384WithRSAEncryption DigitalSignatureAlgorithm = 0x00000012
	DigitalSignatureAlgorithmSHA3_512WithRSAEncryption DigitalSignatureAlgorithm = 0x00000013
)

var DigitalSignatureAlgorithmEnum = NewDigitalSignatureAlgorithmEnum()

func NewDigitalSignatureAlgorithmEnum() ttlv.Enum {
	m := map[DigitalSignatureAlgorithm]string{
		DigitalSignatureAlgorithmMD2WithRSAEncryption:      "MD2 with RSA Encryption",
		DigitalSignatureAlgorithmMD5WithRSAEncryption:      "MD5 with RSA Encryption",
		DigitalSignatureAlgorithmSHA_1WithRSAEncryption:    "SHA-1 with RSA Encryption",
		DigitalSignatureAlgorithmSHA_224WithRSAEncryption:  "SHA-224 with RSA Encryption",
		DigitalSignatureAlgorithmSHA_256WithRSAEncryption:  "SHA-256 with RSA Encryption",
		DigitalSignatureAlgorithmSHA_384WithRSAEncryption:  "SHA-384 with RSA Encryption",
		DigitalSignatureAlgorithmSHA_512WithRSAEncryption:  "SHA-512 with RSA Encryption",
		DigitalSignatureAlgorithmRSASSA_PSS:                "RSASSA-PSS",
		DigitalSignatureAlgorithmDSAWithSHA_1:              "DSA with SHA-1",
		DigitalSignatureAlgorithmDSAWithSHA224:             "DSA with SHA224",
		DigitalSignatureAlgorithmDSAWithSHA256:             "DSA with SHA256",
		DigitalSignatureAlgorithmECDSAWithSHA_1:            "ECDSA with SHA-1",
		DigitalSignatureAlgorithmECDSAWithSHA224:           "ECDSA with SHA224",
		DigitalSignatureAlgorithmECDSAWithSHA256:           "ECDSA with SHA256",
		DigitalSignatureAlgorithmECDSAWithSHA384:           "ECDSA with SHA384",
		DigitalSignatureAlgorithmECDSAWithSHA512:           "ECDSA with SHA512",
		DigitalSignatureAlgorithmSHA3_256WithRSAEncryption: "SHA3-256 with RSA Encryption",
		DigitalSignatureAlgorithmSHA3_384WithRSAEncryption: "SHA3-384 with RSA Encryption",
		DigitalSignatureAlgorithmSHA3_512WithRSAEncryption: "SHA3-512 with RSA Encryption",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (d DigitalSignatureAlgorithm) MarshalText() (text []byte, err error) {
	return []byte(d.String()), nil
}

func (d DigitalSignatureAlgorithm) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(d))
	return nil
}

func (d DigitalSignatureAlgorithm) String() string {
	return ttlv.FormatEnum(uint32(d), &DigitalSignatureAlgorithmEnum)
}

// Split Key Method Enumeration
// 9.1.3.2.8 Table 296
type SplitKeyMethod uint32

const (
	SplitKeyMethodXOR                         SplitKeyMethod = 0x00000001
	SplitKeyMethodPolynomialSharingGF2_16     SplitKeyMethod = 0x00000002
	SplitKeyMethodPolynomialSharingPrimeField SplitKeyMethod = 0x00000003
	SplitKeyMethodPolynomialSharingGF2_8      SplitKeyMethod = 0x00000004
)

var SplitKeyMethodEnum = NewSplitKeyMethodEnum()

func NewSplitKeyMethodEnum() ttlv.Enum {
	m := map[SplitKeyMethod]string{
		SplitKeyMethodXOR:                         "XOR",
		SplitKeyMethodPolynomialSharingGF2_16:     "Polynomial Sharing GF (2^16)",
		SplitKeyMethodPolynomialSharingPrimeField: "Polynomial Sharing Prime Field",
		SplitKeyMethodPolynomialSharingGF2_8:      "Polynomial Sharing GF (2^8)",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (s SplitKeyMethod) MarshalText() (text []byte, err error) {
	return []byte(s.String()), nil
}

func (s SplitKeyMethod) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(s))
	return nil
}

func (s SplitKeyMethod) String() string {
	return ttlv.FormatEnum(uint32(s), &SplitKeyMethodEnum)
}

// Secret Data Type Enumeration
// 9.1.3.2.9 Table 9
type SecretDataType uint32

const (
	SecretDataTypePassword SecretDataType = 0x00000001
	SecretDataTypeSeed     SecretDataType = 0x00000002
)

var SecretDataTypeEnum = NewSecretDataTypeEnum()

func NewSecretDataTypeEnum() ttlv.Enum {
	m := map[SecretDataType]string{
		SecretDataTypePassword: "Password",
		SecretDataTypeSeed:     "Seed",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (s SecretDataType) MarshalText() (text []byte, err error) {
	return []byte(s.String()), nil
}

func (s SecretDataType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(s))
	return nil
}

func (s SecretDataType) String() string {
	return ttlv.FormatEnum(uint32(s), &SecretDataTypeEnum)
}

// Opaque Data Type Enumeration
// 9.1.3.2.10 Table 298
type OpaqueDataType uint32

const ()

var OpaqueDataTypeEnum = NewOpaqueDataTypeEnum()

func NewOpaqueDataTypeEnum() ttlv.Enum {
	m := map[OpaqueDataType]string{}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (o OpaqueDataType) MarshalText() (text []byte, err error) {
	return []byte(o.String()), nil
}

func (o OpaqueDataType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(o))
	return nil
}

func (o OpaqueDataType) String() string {
	return ttlv.FormatEnum(uint32(o), &OpaqueDataTypeEnum)
}

// Name Type Enumeration
// 9.1.3.2.11 Table 299
type NameType uint32

const (
	NameTypeUninterpretedTextString NameType = 0x00000001
	NameTypeURI                     NameType = 0x00000002
)

var NameTypeEnum = NewNameTypeEnum()

func NewNameTypeEnum() ttlv.Enum {
	m := map[NameType]string{
		NameTypeUninterpretedTextString: "Uninterpreted Text String",
		NameTypeURI:                     "URI",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (n NameType) MarshalText() (text []byte, err error) {
	return []byte(n.String()), nil
}

func (n NameType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(n))
	return nil
}

func (n NameType) String() string {
	return ttlv.FormatEnum(uint32(n), &NameTypeEnum)
}

// Object Type Enumeration
// 9.1.3.2.12 Table 300
type ObjectType uint32

const (
	ObjectTypeCertificate  ObjectType = 0x00000001
	ObjectTypeSymmetricKey ObjectType = 0x00000002
	ObjectTypePublicKey    ObjectType = 0x00000003
	ObjectTypePrivateKey   ObjectType = 0x00000004
	ObjectTypeSplitKey     ObjectType = 0x00000005
	ObjectTypeTemplate     ObjectType = 0x00000006
	ObjectTypeSecretData   ObjectType = 0x00000007
	ObjectTypeOpaqueObject ObjectType = 0x00000008
	ObjectTypePGPKey       ObjectType = 0x00000009
)

var ObjectTypeEnum = NewObjectTypeEnum()

func NewObjectTypeEnum() ttlv.Enum {
	m := map[ObjectType]string{
		ObjectTypeCertificate:  "Certificate",
		ObjectTypeSymmetricKey: "Symmetric Key",
		ObjectTypePublicKey:    "Public Key",
		ObjectTypePrivateKey:   "Private Key",
		ObjectTypeSplitKey:     "Split Key",
		ObjectTypeTemplate:     "Template",
		ObjectTypeSecretData:   "Secret Data",
		ObjectTypeOpaqueObject: "Opaque Object",
		ObjectTypePGPKey:       "PGP Key",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (o ObjectType) MarshalText() (text []byte, err error) {
	return []byte(o.String()), nil
}

func (o ObjectType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(o))
	return nil
}

func (o ObjectType) String() string {
	return ttlv.FormatEnum(uint32(o), &ObjectTypeEnum)
}

// Cryptographic Algorithm Enumeration
// 9.1.3.2.13 Table 301
type CryptographicAlgorithm uint32

const (
	CryptographicAlgorithmDES              CryptographicAlgorithm = 0x00000001
	CryptographicAlgorithmDES3             CryptographicAlgorithm = 0x00000002
	CryptographicAlgorithmAES              CryptographicAlgorithm = 0x00000003
	CryptographicAlgorithmRSA              CryptographicAlgorithm = 0x00000004
	CryptographicAlgorithmDSA              CryptographicAlgorithm = 0x00000005
	CryptographicAlgorithmECDSA            CryptographicAlgorithm = 0x00000006
	CryptographicAlgorithmHMAC_SHA1        CryptographicAlgorithm = 0x00000007
	CryptographicAlgorithmHMAC_SHA224      CryptographicAlgorithm = 0x00000008
	CryptographicAlgorithmHMAC_SHA256      CryptographicAlgorithm = 0x00000009
	CryptographicAlgorithmHMAC_SHA384      CryptographicAlgorithm = 0x0000000a
	CryptographicAlgorithmHMAC_SHA512      CryptographicAlgorithm = 0x0000000b
	CryptographicAlgorithmHMAC_MD5         CryptographicAlgorithm = 0x0000000c
	CryptographicAlgorithmDH               CryptographicAlgorithm = 0x0000000d
	CryptographicAlgorithmECDH             CryptographicAlgorithm = 0x0000000e
	CryptographicAlgorithmECMQV            CryptographicAlgorithm = 0x0000000f
	CryptographicAlgorithmBlowfish         CryptographicAlgorithm = 0x00000010
	CryptographicAlgorithmCamellia         CryptographicAlgorithm = 0x00000011
	CryptographicAlgorithmCAST5            CryptographicAlgorithm = 0x00000012
	CryptographicAlgorithmIDEA             CryptographicAlgorithm = 0x00000013
	CryptographicAlgorithmMARS             CryptographicAlgorithm = 0x00000014
	CryptographicAlgorithmRC2              CryptographicAlgorithm = 0x00000015
	CryptographicAlgorithmRC4              CryptographicAlgorithm = 0x00000016
	CryptographicAlgorithmRC5              CryptographicAlgorithm = 0x00000017
	CryptographicAlgorithmSKIPJACK         CryptographicAlgorithm = 0x00000018
	CryptographicAlgorithmTwofish          CryptographicAlgorithm = 0x00000019
	CryptographicAlgorithmEC               CryptographicAlgorithm = 0x0000001a
	CryptographicAlgorithmOneTimePad       CryptographicAlgorithm = 0x0000001b
	CryptographicAlgorithmChaCha20         CryptographicAlgorithm = 0x0000001c
	CryptographicAlgorithmPoly1305         CryptographicAlgorithm = 0x0000001d
	CryptographicAlgorithmChaCha20Poly1305 CryptographicAlgorithm = 0x0000001e
	CryptographicAlgorithmSHA3_224         CryptographicAlgorithm = 0x0000001f
	CryptographicAlgorithmSHA3_256         CryptographicAlgorithm = 0x00000020
	CryptographicAlgorithmSHA3_384         CryptographicAlgorithm = 0x00000021
	CryptographicAlgorithmSHA3_512         CryptographicAlgorithm = 0x00000022
	CryptographicAlgorithmHMAC_SHA3_224    CryptographicAlgorithm = 0x00000023
	CryptographicAlgorithmHMAC_SHA3_256    CryptographicAlgorithm = 0x00000024
	CryptographicAlgorithmHMAC_SHA3_384    CryptographicAlgorithm = 0x00000025
	CryptographicAlgorithmHMAC_SHA3_512    CryptographicAlgorithm = 0x00000026
	CryptographicAlgorithmSHAKE_128        CryptographicAlgorithm = 0x00000027
	CryptographicAlgorithmSHAKE_256        CryptographicAlgorithm = 0x00000028
)

var CryptographicAlgorithmEnum = NewCryptographicAlgorithmEnum()

func NewCryptographicAlgorithmEnum() ttlv.Enum {
	m := map[CryptographicAlgorithm]string{
		CryptographicAlgorithmDES:              "DES",
		CryptographicAlgorithmDES3:             "3DES",
		CryptographicAlgorithmAES:              "AES",
		CryptographicAlgorithmRSA:              "RSA",
		CryptographicAlgorithmDSA:              "DSA",
		CryptographicAlgorithmECDSA:            "ECDSA",
		CryptographicAlgorithmHMAC_SHA1:        "HMAC-SHA1",
		CryptographicAlgorithmHMAC_SHA224:      "HMAC-SHA224",
		CryptographicAlgorithmHMAC_SHA256:      "HMAC-SHA256",
		CryptographicAlgorithmHMAC_SHA384:      "HMAC-SHA384",
		CryptographicAlgorithmHMAC_SHA512:      "HMAC-SHA512",
		CryptographicAlgorithmHMAC_MD5:         "HMAC-MD5",
		CryptographicAlgorithmDH:               "DH",
		CryptographicAlgorithmECDH:             "ECDH",
		CryptographicAlgorithmECMQV:            "ECMQV",
		CryptographicAlgorithmBlowfish:         "Blowfish",
		CryptographicAlgorithmCamellia:         "Camellia",
		CryptographicAlgorithmCAST5:            "CAST5",
		CryptographicAlgorithmIDEA:             "IDEA",
		CryptographicAlgorithmMARS:             "MARS",
		CryptographicAlgorithmRC2:              "RC2",
		CryptographicAlgorithmRC4:              "RC4",
		CryptographicAlgorithmRC5:              "RC5",
		CryptographicAlgorithmSKIPJACK:         "SKIPJACK",
		CryptographicAlgorithmTwofish:          "Twofish",
		CryptographicAlgorithmEC:               "EC",
		CryptographicAlgorithmOneTimePad:       "One Time Pad",
		CryptographicAlgorithmChaCha20:         "ChaCha20",
		CryptographicAlgorithmPoly1305:         "Poly1305",
		CryptographicAlgorithmChaCha20Poly1305: "ChaCha20Poly1305",
		CryptographicAlgorithmSHA3_224:         "SHA3-224",
		CryptographicAlgorithmSHA3_256:         "SHA3-256",
		CryptographicAlgorithmSHA3_384:         "SHA3-384",
		CryptographicAlgorithmSHA3_512:         "SHA3-512",
		CryptographicAlgorithmHMAC_SHA3_224:    "HMAC-SHA3-224",
		CryptographicAlgorithmHMAC_SHA3_256:    "HMAC-SHA3-256",
		CryptographicAlgorithmHMAC_SHA3_384:    "HMAC-SHA3-384",
		CryptographicAlgorithmHMAC_SHA3_512:    "HMAC-SHA3-512",
		CryptographicAlgorithmSHAKE_128:        "SHAKE-128",
		CryptographicAlgorithmSHAKE_256:        "SHAKE-256",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (c CryptographicAlgorithm) MarshalText() (text []byte, err error) {
	return []byte(c.String()), nil
}

func (c CryptographicAlgorithm) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(c))
	return nil
}

func (c CryptographicAlgorithm) String() string {
	return ttlv.FormatEnum(uint32(c), &CryptographicAlgorithmEnum)
}

// Block Cipher Mode Enumeration
// 9.1.3.2.14 Table 302
type BlockCipherMode uint32

const (
	BlockCipherModeCBC               BlockCipherMode = 0x00000001
	BlockCipherModeECB               BlockCipherMode = 0x00000002
	BlockCipherModePCBC              BlockCipherMode = 0x00000003
	BlockCipherModeCFB               BlockCipherMode = 0x00000004
	BlockCipherModeOFB               BlockCipherMode = 0x00000005
	BlockCipherModeCTR               BlockCipherMode = 0x00000006
	BlockCipherModeCMAC              BlockCipherMode = 0x00000007
	BlockCipherModeCCM               BlockCipherMode = 0x00000008
	BlockCipherModeGCM               BlockCipherMode = 0x00000009
	BlockCipherModeCBC_MAC           BlockCipherMode = 0x0000000a
	BlockCipherModeXTS               BlockCipherMode = 0x0000000b
	BlockCipherModeAESKeyWrapPadding BlockCipherMode = 0x0000000c
	BlockCipherModeNISTKeyWrap       BlockCipherMode = 0x0000000d
	BlockCipherModeX9_102AESKW       BlockCipherMode = 0x0000000e
	BlockCipherModeX9_102TDKW        BlockCipherMode = 0x0000000f
	BlockCipherModeX9_102AKW1        BlockCipherMode = 0x00000010
	BlockCipherModeX9_102AKW2        BlockCipherMode = 0x00000011
	BlockCipherModeAEAD              BlockCipherMode = 0x00000012
)

var BlockCipherModeEnum = NewBlockCipherModeEnum()

func NewBlockCipherModeEnum() ttlv.Enum {
	m := map[BlockCipherMode]string{
		BlockCipherModeCBC:               "CBC",
		BlockCipherModeECB:               "ECB",
		BlockCipherModePCBC:              "PCBC",
		BlockCipherModeCFB:               "CFB",
		BlockCipherModeOFB:               "OFB",
		BlockCipherModeCTR:               "CTR",
		BlockCipherModeCMAC:              "CMAC",
		BlockCipherModeCCM:               "CCM",
		BlockCipherModeGCM:               "GCM",
		BlockCipherModeCBC_MAC:           "CBC-MAC",
		BlockCipherModeXTS:               "XTS",
		BlockCipherModeAESKeyWrapPadding: "AESKeyWrapPadding",
		BlockCipherModeNISTKeyWrap:       "NISTKeyWrap",
		BlockCipherModeX9_102AESKW:       "X9.102 AESKW",
		BlockCipherModeX9_102TDKW:        "X9.102 TDKW",
		BlockCipherModeX9_102AKW1:        "X9.102 AKW1",
		BlockCipherModeX9_102AKW2:        "X9.102 AKW2",
		BlockCipherModeAEAD:              "AEAD",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (b BlockCipherMode) MarshalText() (text []byte, err error) {
	return []byte(b.String()), nil
}

func (b BlockCipherMode) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(b))
	return nil
}

func (b BlockCipherMode) String() string {
	return ttlv.FormatEnum(uint32(b), &BlockCipherModeEnum)
}

// Padding Method Enumeration
// 9.1.3.2.15 Table 303
type PaddingMethod uint32

const (
	PaddingMethodNone      PaddingMethod = 0x00000001
	PaddingMethodOAEP      PaddingMethod = 0x00000002
	PaddingMethodPKCS5     PaddingMethod = 0x00000003
	PaddingMethodSSL3      PaddingMethod = 0x00000004
	PaddingMethodZeros     PaddingMethod = 0x00000005
	PaddingMethodANSIX9_23 PaddingMethod = 0x00000006
	PaddingMethodISO10126  PaddingMethod = 0x00000007
	PaddingMethodPKCS1V1_5 PaddingMethod = 0x00000008
	PaddingMethodX9_31     PaddingMethod = 0x00000009
	PaddingMethodPSS       PaddingMethod = 0x0000000a
)

var PaddingMethodEnum = NewPaddingMethodEnum()

func NewPaddingMethodEnum() ttlv.Enum {
	m := map[PaddingMethod]string{
		PaddingMethodNone:      "None",
		PaddingMethodOAEP:      "OAEP",
		PaddingMethodPKCS5:     "PKCS5",
		PaddingMethodSSL3:      "SSL3",
		PaddingMethodZeros:     "Zeros",
		PaddingMethodANSIX9_23: "ANSI X9.23",
		PaddingMethodISO10126:  "ISO 10126",
		PaddingMethodPKCS1V1_5: "PKCS1 v1.5",
		PaddingMethodX9_31:     "X9.31",
		PaddingMethodPSS:       "PSS",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (p PaddingMethod) MarshalText() (text []byte, err error) {
	return []byte(p.String()), nil
}

func (p PaddingMethod) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(p))
	return nil
}

func (p PaddingMethod) String() string {
	return ttlv.FormatEnum(uint32(p), &PaddingMethodEnum)
}

// Hashing Algorithm Enumeration
// 9.1.3.2.16 Table 304
type HashingAlgorithm uint32

const (
	HashingAlgorithmMD2         HashingAlgorithm = 0x00000001
	HashingAlgorithmMD4         HashingAlgorithm = 0x00000002
	HashingAlgorithmMD5         HashingAlgorithm = 0x00000003
	HashingAlgorithmSHA_1       HashingAlgorithm = 0x00000004
	HashingAlgorithmSHA_224     HashingAlgorithm = 0x00000005
	HashingAlgorithmSHA_256     HashingAlgorithm = 0x00000006
	HashingAlgorithmSHA_384     HashingAlgorithm = 0x00000007
	HashingAlgorithmSHA_512     HashingAlgorithm = 0x00000008
	HashingAlgorithmRIPEMD_160  HashingAlgorithm = 0x00000009
	HashingAlgorithmTiger       HashingAlgorithm = 0x0000000a
	HashingAlgorithmWhirlpool   HashingAlgorithm = 0x0000000b
	HashingAlgorithmSHA_512_224 HashingAlgorithm = 0x0000000c
	HashingAlgorithmSHA_512_256 HashingAlgorithm = 0x0000000d
	HashingAlgorithmSHA_3_224   HashingAlgorithm = 0x0000000e
	HashingAlgorithmSHA_3_256   HashingAlgorithm = 0x0000000f
	HashingAlgorithmSHA_3_384   HashingAlgorithm = 0x00000010
	HashingAlgorithmSHA_3_512   HashingAlgorithm = 0x00000011
)

var HashingAlgorithmEnum = NewHashingAlgorithmEnum()

func NewHashingAlgorithmEnum() ttlv.Enum {
	m := map[HashingAlgorithm]string{
		HashingAlgorithmMD2:         "MD2",
		HashingAlgorithmMD4:         "MD4",
		HashingAlgorithmMD5:         "MD5",
		HashingAlgorithmSHA_1:       "SHA-1",
		HashingAlgorithmSHA_224:     "SHA-224",
		HashingAlgorithmSHA_256:     "SHA-256",
		HashingAlgorithmSHA_384:     "SHA-384",
		HashingAlgorithmSHA_512:     "SHA-512",
		HashingAlgorithmRIPEMD_160:  "RIPEMD-160",
		HashingAlgorithmTiger:       "Tiger",
		HashingAlgorithmWhirlpool:   "Whirlpool",
		HashingAlgorithmSHA_512_224: "SHA-512/224",
		HashingAlgorithmSHA_512_256: "SHA-512/256",
		HashingAlgorithmSHA_3_224:   "SHA-3-224",
		HashingAlgorithmSHA_3_256:   "SHA-3-256",
		HashingAlgorithmSHA_3_384:   "SHA-3-384",
		HashingAlgorithmSHA_3_512:   "SHA-3-512",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (h HashingAlgorithm) MarshalText() (text []byte, err error) {
	return []byte(h.String()), nil
}

func (h HashingAlgorithm) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(h))
	return nil
}

func (h HashingAlgorithm) String() string {
	return ttlv.FormatEnum(uint32(h), &HashingAlgorithmEnum)
}

// Key Role Type Enumeration
// 9.1.3.2.17 Table 305
type KeyRoleType uint32

const (
	KeyRoleTypeBDK      KeyRoleType = 0x00000001
	KeyRoleTypeCVK      KeyRoleType = 0x00000002
	KeyRoleTypeDEK      KeyRoleType = 0x00000003
	KeyRoleTypeMKAC     KeyRoleType = 0x00000004
	KeyRoleTypeMKSMC    KeyRoleType = 0x00000005
	KeyRoleTypeMKSMI    KeyRoleType = 0x00000006
	KeyRoleTypeMKDAC    KeyRoleType = 0x00000007
	KeyRoleTypeMKDN     KeyRoleType = 0x00000008
	KeyRoleTypeMKCP     KeyRoleType = 0x00000009
	KeyRoleTypeMKOTH    KeyRoleType = 0x0000000a
	KeyRoleTypeKEK      KeyRoleType = 0x0000000b
	KeyRoleTypeMAC16609 KeyRoleType = 0x0000000c
	KeyRoleTypeMAC97971 KeyRoleType = 0x0000000d
	KeyRoleTypeMAC97972 KeyRoleType = 0x0000000e
	KeyRoleTypeMAC97973 KeyRoleType = 0x0000000f
	KeyRoleTypeMAC97974 KeyRoleType = 0x00000010
	KeyRoleTypeMAC97975 KeyRoleType = 0x00000011
	KeyRoleTypeZPK      KeyRoleType = 0x00000012
	KeyRoleTypePVKIBM   KeyRoleType = 0x00000013
	KeyRoleTypePVKPVV   KeyRoleType = 0x00000014
	KeyRoleTypePVKOTH   KeyRoleType = 0x00000015
	KeyRoleTypeDUKPT    KeyRoleType = 0x00000016
	KeyRoleTypeIV       KeyRoleType = 0x00000017
	KeyRoleTypeTRKBK    KeyRoleType = 0x00000018
)

var KeyRoleTypeEnum = NewKeyRoleTypeEnum()

func NewKeyRoleTypeEnum() ttlv.Enum {
	m := map[KeyRoleType]string{
		KeyRoleTypeBDK:      "BDK",
		KeyRoleTypeCVK:      "CVK",
		KeyRoleTypeDEK:      "DEK",
		KeyRoleTypeMKAC:     "MKAC",
		KeyRoleTypeMKSMC:    "MKSMC",
		KeyRoleTypeMKSMI:    "MKSMI",
		KeyRoleTypeMKDAC:    "MKDAC",
		KeyRoleTypeMKDN:     "MKDN",
		KeyRoleTypeMKCP:     "MKCP",
		KeyRoleTypeMKOTH:    "MKOTH",
		KeyRoleTypeKEK:      "KEK",
		KeyRoleTypeMAC16609: "MAC16609",
		KeyRoleTypeMAC97971: "MAC97971",
		KeyRoleTypeMAC97972: "MAC97972",
		KeyRoleTypeMAC97973: "MAC97973",
		KeyRoleTypeMAC97974: "MAC97974",
		KeyRoleTypeMAC97975: "MAC97975",
		KeyRoleTypeZPK:      "ZPK",
		KeyRoleTypePVKIBM:   "PVKIBM",
		KeyRoleTypePVKPVV:   "PVKPVV",
		KeyRoleTypePVKOTH:   "PVKOTH",
		KeyRoleTypeDUKPT:    "DUKPT",
		KeyRoleTypeIV:       "IV",
		KeyRoleTypeTRKBK:    "TRKBK",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (k KeyRoleType) MarshalText() (text []byte, err error) {
	return []byte(k.String()), nil
}

func (k KeyRoleType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(k))
	return nil
}

func (k KeyRoleType) String() string {
	return ttlv.FormatEnum(uint32(k), &KeyRoleTypeEnum)
}

// State Enumeration
// 9.1.3.2.18 Table 306
type State uint32

const (
	StatePreActive            State = 0x00000001
	StateActive               State = 0x00000002
	StateDeactivated          State = 0x00000003
	StateCompromised          State = 0x00000004
	StateDestroyed            State = 0x00000005
	StateDestroyedCompromised State = 0x00000006
)

var StateEnum = NewStateEnum()

func NewStateEnum() ttlv.Enum {
	m := map[State]string{
		StatePreActive:            "Pre-Active",
		StateActive:               "Active",
		StateDeactivated:          "Deactivated",
		StateCompromised:          "Compromised",
		StateDestroyed:            "Destroyed",
		StateDestroyedCompromised: "Destroyed Compromised",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (s State) MarshalText() (text []byte, err error) {
	return []byte(s.String()), nil
}

func (s State) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(s))
	return nil
}

func (s State) String() string {
	return ttlv.FormatEnum(uint32(s), &StateEnum)
}

// Revocation Reason Code Enumeration
// 9.1.3.2.19 Table 307
type RevocationReasonCode uint32

const (
	RevocationReasonCodeUnspecified          RevocationReasonCode = 0x00000001
	RevocationReasonCodeKeyCompromise        RevocationReasonCode = 0x00000002
	RevocationReasonCodeCACompromise         RevocationReasonCode = 0x00000003
	RevocationReasonCodeAffiliationChanged   RevocationReasonCode = 0x00000004
	RevocationReasonCodeSuperseded           RevocationReasonCode = 0x00000005
	RevocationReasonCodeCessationOfOperation RevocationReasonCode = 0x00000006
	RevocationReasonCodePrivilegeWithdrawn   RevocationReasonCode = 0x00000007
)

var RevocationReasonCodeEnum = NewRevocationReasonCodeEnum()

func NewRevocationReasonCodeEnum() ttlv.Enum {
	m := map[RevocationReasonCode]string{
		RevocationReasonCodeUnspecified:          "Unspecified",
		RevocationReasonCodeKeyCompromise:        "Key Compromise",
		RevocationReasonCodeCACompromise:         "CA Compromise",
		RevocationReasonCodeAffiliationChanged:   "Affiliation Changed",
		RevocationReasonCodeSuperseded:           "Superseded",
		RevocationReasonCodeCessationOfOperation: "Cessation of Operation",
		RevocationReasonCodePrivilegeWithdrawn:   "Privilege Withdrawn",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (r RevocationReasonCode) MarshalText() (text []byte, err error) {
	return []byte(r.String()), nil
}

func (r RevocationReasonCode) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(r))
	return nil
}

func (r RevocationReasonCode) String() string {
	return ttlv.FormatEnum(uint32(r), &RevocationReasonCodeEnum)
}

// Link Type Enumeration
// 9.1.3.2.20 Table 308
type LinkType uint32

const (
	LinkTypeCertificateLink          LinkType = 0x00000101
	LinkTypePublicKeyLink            LinkType = 0x00000102
	LinkTypePrivateKeyLink           LinkType = 0x00000103
	LinkTypeDerivationBaseObjectLink LinkType = 0x00000104
	LinkTypeDerivedKeyLink           LinkType = 0x00000105
	LinkTypeReplacementObjectLink    LinkType = 0x00000106
	LinkTypeReplacedObjectLink       LinkType = 0x00000107
	LinkTypeParentLink               LinkType = 0x00000108
	LinkTypeChildLink                LinkType = 0x00000109
	LinkTypePreviousLink             LinkType = 0x0000010a
	LinkTypeNextLink                 LinkType = 0x0000010b
	LinkTypePKCS_12CertificateLink   LinkType = 0x0000010c
	LinkTypePKCS_12PasswordLink      LinkType = 0x0000010d
)

var LinkTypeEnum = NewLinkTypeEnum()

func NewLinkTypeEnum() ttlv.Enum {
	m := map[LinkType]string{
		LinkTypeCertificateLink:          "Certificate Link",
		LinkTypePublicKeyLink:            "Public Key Link",
		LinkTypePrivateKeyLink:           "Private Key Link",
		LinkTypeDerivationBaseObjectLink: "Derivation Base Object Link",
		LinkTypeDerivedKeyLink:           "Derived Key Link",
		LinkTypeReplacementObjectLink:    "Replacement Object Link",
		LinkTypeReplacedObjectLink:       "Replaced Object Link",
		LinkTypeParentLink:               "Parent Link",
		LinkTypeChildLink:                "Child Link",
		LinkTypePreviousLink:             "Previous Link",
		LinkTypeNextLink:                 "Next Link",
		LinkTypePKCS_12CertificateLink:   "PKCS#12 Certificate Link",
		LinkTypePKCS_12PasswordLink:      "PKCS#12 Password Link",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (l LinkType) MarshalText() (text []byte, err error) {
	return []byte(l.String()), nil
}

func (l LinkType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(l))
	return nil
}

func (l LinkType) String() string {
	return ttlv.FormatEnum(uint32(l), &LinkTypeEnum)
}

// Derivation Method Enumeration
// 9.1.3.2.21 Table 309
type DerivationMethod uint32

const (
	DerivationMethodPBKDF2          DerivationMethod = 0x00000001
	DerivationMethodHASH            DerivationMethod = 0x00000002
	DerivationMethodHMAC            DerivationMethod = 0x00000003
	DerivationMethodENCRYPT         DerivationMethod = 0x00000004
	DerivationMethodNIST800_108_C   DerivationMethod = 0x00000005
	DerivationMethodNIST800_108_F   DerivationMethod = 0x00000006
	DerivationMethodNIST800_108_DPI DerivationMethod = 0x00000007
	DerivationMethodAsymmetricKey   DerivationMethod = 0x00000008
)

var DerivationMethodEnum = NewDerivationMethodEnum()

func NewDerivationMethodEnum() ttlv.Enum {
	m := map[DerivationMethod]string{
		DerivationMethodPBKDF2:          "PBKDF2",
		DerivationMethodHASH:            "HASH",
		DerivationMethodHMAC:            "HMAC",
		DerivationMethodENCRYPT:         "ENCRYPT",
		DerivationMethodNIST800_108_C:   "NIST800 - 108 - C",
		DerivationMethodNIST800_108_F:   "NIST800 - 108 - F",
		DerivationMethodNIST800_108_DPI: "NIST800 - 108 - DPI",
		DerivationMethodAsymmetricKey:   "Asymmetric Key",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (d DerivationMethod) MarshalText() (text []byte, err error) {
	return []byte(d.String()), nil
}

func (d DerivationMethod) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(d))
	return nil
}

func (d DerivationMethod) String() string {
	return ttlv.FormatEnum(uint32(d), &DerivationMethodEnum)
}

// Certificate Request Type Enumeration
// 9.1.3.2.22 Table 310
type CertificateRequestType uint32

const (
	CertificateRequestTypeCRMF    CertificateRequestType = 0x00000001
	CertificateRequestTypePKCS_10 CertificateRequestType = 0x00000002
	CertificateRequestTypePEM     CertificateRequestType = 0x00000003
	CertificateRequestTypePGP     CertificateRequestType = 0x00000004
)

var CertificateRequestTypeEnum = NewCertificateRequestTypeEnum()

func NewCertificateRequestTypeEnum() ttlv.Enum {
	m := map[CertificateRequestType]string{
		CertificateRequestTypeCRMF:    "CRMF",
		CertificateRequestTypePKCS_10: "PKCS#10",
		CertificateRequestTypePEM:     "PEM",
		CertificateRequestTypePGP:     "PGP",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (c CertificateRequestType) MarshalText() (text []byte, err error) {
	return []byte(c.String()), nil
}

func (c CertificateRequestType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(c))
	return nil
}

func (c CertificateRequestType) String() string {
	return ttlv.FormatEnum(uint32(c), &CertificateRequestTypeEnum)
}

// Validity Indicator Enumeration
// 9.1.3.2.23 Table 311
type ValidityIndicator uint32

const (
	ValidityIndicatorValid   ValidityIndicator = 0x00000001
	ValidityIndicatorInvalid ValidityIndicator = 0x00000002
	ValidityIndicatorUnknown ValidityIndicator = 0x00000003
)

var ValidityIndicatorEnum = NewValidityIndicatorEnum()

func NewValidityIndicatorEnum() ttlv.Enum {
	m := map[ValidityIndicator]string{
		ValidityIndicatorValid:   "Valid",
		ValidityIndicatorInvalid: "Invalid",
		ValidityIndicatorUnknown: "Unknown",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (v ValidityIndicator) MarshalText() (text []byte, err error) {
	return []byte(v.String()), nil
}

func (v ValidityIndicator) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(v))
	return nil
}

func (v ValidityIndicator) String() string {
	return ttlv.FormatEnum(uint32(v), &ValidityIndicatorEnum)
}

// Query Function Enumeration
// 9.1.3.2.24 Table 312
type QueryFunction uint32

const (
	QueryFunctionQueryOperations                QueryFunction = 0x00000001
	QueryFunctionQueryObjects                   QueryFunction = 0x00000002
	QueryFunctionQueryServerInformation         QueryFunction = 0x00000003
	QueryFunctionQueryApplicationNamespaces     QueryFunction = 0x00000004
	QueryFunctionQueryExtensionList             QueryFunction = 0x00000005
	QueryFunctionQueryExtensionMap              QueryFunction = 0x00000006
	QueryFunctionQueryAttestationTypes          QueryFunction = 0x00000007
	QueryFunctionQueryRNGs                      QueryFunction = 0x00000008
	QueryFunctionQueryValidations               QueryFunction = 0x00000009
	QueryFunctionQueryProfiles                  QueryFunction = 0x0000000a
	QueryFunctionQueryCapabilities              QueryFunction = 0x0000000b
	QueryFunctionQueryClientRegistrationMethods QueryFunction = 0x0000000c
)

var QueryFunctionEnum = NewQueryFunctionEnum()

func NewQueryFunctionEnum() ttlv.Enum {
	m := map[QueryFunction]string{
		QueryFunctionQueryOperations:                "Query Operations",
		QueryFunctionQueryObjects:                   "Query Objects",
		QueryFunctionQueryServerInformation:         "Query Server Information",
		QueryFunctionQueryApplicationNamespaces:     "Query Application Namespaces",
		QueryFunctionQueryExtensionList:             "Query Extension List",
		QueryFunctionQueryExtensionMap:              "Query Extension Map",
		QueryFunctionQueryAttestationTypes:          "Query Attestation Types",
		QueryFunctionQueryRNGs:                      "Query RNGs",
		QueryFunctionQueryValidations:               "Query Validations",
		QueryFunctionQueryProfiles:                  "Query Profiles",
		QueryFunctionQueryCapabilities:              "Query Capabilities",
		QueryFunctionQueryClientRegistrationMethods: "Query Client Registration Methods",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (q QueryFunction) MarshalText() (text []byte, err error) {
	return []byte(q.String()), nil
}

func (q QueryFunction) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(q))
	return nil
}

func (q QueryFunction) String() string {
	return ttlv.FormatEnum(uint32(q), &QueryFunctionEnum)
}

// Cancellation Result Enumeration
// 9.1.3.2.25 Table 313
type CancellationResult uint32

const (
	CancellationResultCanceled       CancellationResult = 0x00000001
	CancellationResultUnableToCancel CancellationResult = 0x00000002
	CancellationResultCompleted      CancellationResult = 0x00000003
	CancellationResultFailed         CancellationResult = 0x00000004
	CancellationResultUnavailable    CancellationResult = 0x00000005
)

var CancellationResultEnum = NewCancellationResultEnum()

func NewCancellationResultEnum() ttlv.Enum {
	m := map[CancellationResult]string{
		CancellationResultCanceled:       "Canceled",
		CancellationResultUnableToCancel: "Unable to Cancel",
		CancellationResultCompleted:      "Completed",
		CancellationResultFailed:         "Failed",
		CancellationResultUnavailable:    "Unavailable",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (c CancellationResult) MarshalText() (text []byte, err error) {
	return []byte(c.String()), nil
}

func (c CancellationResult) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(c))
	return nil
}

func (c CancellationResult) String() string {
	return ttlv.FormatEnum(uint32(c), &CancellationResultEnum)
}

// Put Function Enumeration
// 9.1.3.2.26 Table 314
type PutFunction uint32

const (
	PutFunctionNew     PutFunction = 0x00000001
	PutFunctionReplace PutFunction = 0x00000002
)

var PutFunctionEnum = NewPutFunctionEnum()

func NewPutFunctionEnum() ttlv.Enum {
	m := map[PutFunction]string{
		PutFunctionNew:     "New",
		PutFunctionReplace: "Replace",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (p PutFunction) MarshalText() (text []byte, err error) {
	return []byte(p.String()), nil
}

func (p PutFunction) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(p))
	return nil
}

func (p PutFunction) String() string {
	return ttlv.FormatEnum(uint32(p), &PutFunctionEnum)
}

// Operation Enumeration
// 9.1.3.2.27 Table 315
type Operation uint32

const (
	OperationCreate             Operation = 0x00000001
	OperationCreateKeyPair      Operation = 0x00000002
	OperationRegister           Operation = 0x00000003
	OperationReKey              Operation = 0x00000004
	OperationDeriveKey          Operation = 0x00000005
	OperationCertify            Operation = 0x00000006
	OperationReCertify          Operation = 0x00000007
	OperationLocate             Operation = 0x00000008
	OperationCheck              Operation = 0x00000009
	OperationGet                Operation = 0x0000000a
	OperationGetAttributes      Operation = 0x0000000b
	OperationGetAttributeList   Operation = 0x0000000c
	OperationAddAttribute       Operation = 0x0000000d
	OperationModifyAttribute    Operation = 0x0000000e
	OperationDeleteAttribute    Operation = 0x0000000f
	OperationObtainLease        Operation = 0x00000010
	OperationGetUsageAllocation Operation = 0x00000011
	OperationActivate           Operation = 0x00000012
	OperationRevoke             Operation = 0x00000013
	OperationDestroy            Operation = 0x00000014
	OperationArchive            Operation = 0x00000015
	OperationRecover            Operation = 0x00000016
	OperationValidate           Operation = 0x00000017
	OperationQuery              Operation = 0x00000018
	OperationCancel             Operation = 0x00000019
	OperationPoll               Operation = 0x0000001a
	OperationNotify             Operation = 0x0000001b
	OperationPut                Operation = 0x0000001c
	OperationReKeyKeyPair       Operation = 0x0000001d
	OperationDiscoverVersions   Operation = 0x0000001e
	OperationEncrypt            Operation = 0x0000001f
	OperationDecrypt            Operation = 0x00000020
	OperationSign               Operation = 0x00000021
	OperationSignatureVerify    Operation = 0x00000022
	OperationMAC                Operation = 0x00000023
	OperationMACVerify          Operation = 0x00000024
	OperationRNGRetrieve        Operation = 0x00000025
	OperationRNGSeed            Operation = 0x00000026
	OperationHash               Operation = 0x00000027
	OperationCreateSplitKey     Operation = 0x00000028
	OperationJoinSplitKey       Operation = 0x00000029
	OperationImport             Operation = 0x0000002a
	OperationExport             Operation = 0x0000002b
)

var OperationEnum = NewOperationEnum()

func NewOperationEnum() ttlv.Enum {
	m := map[Operation]string{
		OperationCreate:             "Create",
		OperationCreateKeyPair:      "Create Key Pair",
		OperationRegister:           "Register",
		OperationReKey:              "Re-key",
		OperationDeriveKey:          "Derive Key",
		OperationCertify:            "Certify",
		OperationReCertify:          "Re-certify",
		OperationLocate:             "Locate",
		OperationCheck:              "Check",
		OperationGet:                "Get",
		OperationGetAttributes:      "Get Attributes",
		OperationGetAttributeList:   "Get Attribute List",
		OperationAddAttribute:       "Add Attribute",
		OperationModifyAttribute:    "Modify Attribute",
		OperationDeleteAttribute:    "Delete Attribute",
		OperationObtainLease:        "Obtain Lease",
		OperationGetUsageAllocation: "Get Usage Allocation",
		OperationActivate:           "Activate",
		OperationRevoke:             "Revoke",
		OperationDestroy:            "Destroy",
		OperationArchive:            "Archive",
		OperationRecover:            "Recover",
		OperationValidate:           "Validate",
		OperationQuery:              "Query",
		OperationCancel:             "Cancel",
		OperationPoll:               "Poll",
		OperationNotify:             "Notify",
		OperationPut:                "Put",
		OperationReKeyKeyPair:       "Re-key Key Pair",
		OperationDiscoverVersions:   "Discover Versions",
		OperationEncrypt:            "Encrypt",
		OperationDecrypt:            "Decrypt",
		OperationSign:               "Sign",
		OperationSignatureVerify:    "Signature Verify",
		OperationMAC:                "MAC",
		OperationMACVerify:          "MAC Verify",
		OperationRNGRetrieve:        "RNG Retrieve",
		OperationRNGSeed:            "RNG Seed",
		OperationHash:               "Hash",
		OperationCreateSplitKey:     "Create Split Key",
		OperationJoinSplitKey:       "Join Split Key",
		OperationImport:             "Import",
		OperationExport:             "Export",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (o Operation) MarshalText() (text []byte, err error) {
	return []byte(o.String()), nil
}

func (o Operation) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(o))
	return nil
}

func (o Operation) String() string {
	return ttlv.FormatEnum(uint32(o), &OperationEnum)
}

// Result Status Enumeration
// 9.1.3.2.28 Table 316
type ResultStatus uint32

const (
	ResultStatusSuccess          ResultStatus = 0x00000000
	ResultStatusOperationFailed  ResultStatus = 0x00000001
	ResultStatusOperationPending ResultStatus = 0x00000002
	ResultStatusOperationUndone  ResultStatus = 0x00000003
)

var ResultStatusEnum = NewResultStatusEnum()

func NewResultStatusEnum() ttlv.Enum {
	m := map[ResultStatus]string{
		ResultStatusSuccess:          "Success",
		ResultStatusOperationFailed:  "Operation Failed",
		ResultStatusOperationPending: "Operation Pending",
		ResultStatusOperationUndone:  "Operation Undone",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (r ResultStatus) MarshalText() (text []byte, err error) {
	return []byte(r.String()), nil
}

func (r ResultStatus) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(r))
	return nil
}

func (r ResultStatus) String() string {
	return ttlv.FormatEnum(uint32(r), &ResultStatusEnum)
}

// Result Reason Enumeration
// 9.1.3.2.29 Table 317
type ResultReason uint32

const (
	ResultReasonItemNotFound                     ResultReason = 0x00000001
	ResultReasonResponseTooLarge                 ResultReason = 0x00000002
	ResultReasonAuthenticationNotSuccessful      ResultReason = 0x00000003
	ResultReasonInvalidMessage                   ResultReason = 0x00000004
	ResultReasonOperationNotSupported            ResultReason = 0x00000005
	ResultReasonMissingData                      ResultReason = 0x00000006
	ResultReasonInvalidField                     ResultReason = 0x00000007
	ResultReasonFeatureNotSupported              ResultReason = 0x00000008
	ResultReasonOperationCanceledByRequester     ResultReason = 0x00000009
	ResultReasonCryptographicFailure             ResultReason = 0x0000000a
	ResultReasonIllegalOperation                 ResultReason = 0x0000000b
	ResultReasonPermissionDenied                 ResultReason = 0x0000000c
	ResultReasonObjectArchived                   ResultReason = 0x0000000d
	ResultReasonIndexOutOfBounds                 ResultReason = 0x0000000e
	ResultReasonApplicationNamespaceNotSupported ResultReason = 0x0000000f
	ResultReasonKeyFormatTypeNotSupported        ResultReason = 0x00000010
	ResultReasonKeyCompressionTypeNotSupported   ResultReason = 0x00000011
	ResultReasonEncodingOptionError              ResultReason = 0x00000012
	ResultReasonKeyValueNotPresent               ResultReason = 0x00000013
	ResultReasonAttestationRequired              ResultReason = 0x00000014
	ResultReasonAttestationFailed                ResultReason = 0x00000015
	ResultReasonSensitive                        ResultReason = 0x00000016
	ResultReasonNotExtractable                   ResultReason = 0x00000017
	ResultReasonObjectAlreadyExists              ResultReason = 0x00000018
	ResultReasonGeneralFailure                   ResultReason = 0x00000100
)

var ResultReasonEnum = NewResultReasonEnum()

func NewResultReasonEnum() ttlv.Enum {
	m := map[ResultReason]string{
		ResultReasonItemNotFound:                     "Item Not Found",
		ResultReasonResponseTooLarge:                 "Response Too Large",
		ResultReasonAuthenticationNotSuccessful:      "Authentication Not Successful",
		ResultReasonInvalidMessage:                   "Invalid Message",
		ResultReasonOperationNotSupported:            "Operation Not Supported",
		ResultReasonMissingData:                      "Missing Data",
		ResultReasonInvalidField:                     "Invalid Field",
		ResultReasonFeatureNotSupported:              "Feature Not Supported",
		ResultReasonOperationCanceledByRequester:     "Operation Canceled By Requester",
		ResultReasonCryptographicFailure:             "Cryptographic Failure",
		ResultReasonIllegalOperation:                 "Illegal Operation",
		ResultReasonPermissionDenied:                 "Permission Denied",
		ResultReasonObjectArchived:                   "Object archived",
		ResultReasonIndexOutOfBounds:                 "Index Out of Bounds",
		ResultReasonApplicationNamespaceNotSupported: "Application Namespace Not Supported",
		ResultReasonKeyFormatTypeNotSupported:        "Key Format Type Not Supported",
		ResultReasonKeyCompressionTypeNotSupported:   "Key Compression Type Not Supported",
		ResultReasonEncodingOptionError:              "Encoding Option Error",
		ResultReasonKeyValueNotPresent:               "Key Value Not Present",
		ResultReasonAttestationRequired:              "Attestation Required",
		ResultReasonAttestationFailed:                "Attestation Failed",
		ResultReasonSensitive:                        "Sensitive",
		ResultReasonNotExtractable:                   "Not Extractable",
		ResultReasonObjectAlreadyExists:              "Object Already Exists",
		ResultReasonGeneralFailure:                   "General Failure",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (r ResultReason) MarshalText() (text []byte, err error) {
	return []byte(r.String()), nil
}

func (r ResultReason) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(r))
	return nil
}

func (r ResultReason) String() string {
	return ttlv.FormatEnum(uint32(r), &ResultReasonEnum)
}

// Batch Error Continuation Option Enumeration
// 9.1.3.2.30 Table 318
type BatchErrorContinuationOption uint32

const (
	BatchErrorContinuationOptionContinue BatchErrorContinuationOption = 0x00000001
	BatchErrorContinuationOptionStop     BatchErrorContinuationOption = 0x00000002
	BatchErrorContinuationOptionUndo     BatchErrorContinuationOption = 0x00000003
)

var BatchErrorContinuationOptionEnum = NewBatchErrorContinuationOptionEnum()

func NewBatchErrorContinuationOptionEnum() ttlv.Enum {
	m := map[BatchErrorContinuationOption]string{
		BatchErrorContinuationOptionContinue: "Continue",
		BatchErrorContinuationOptionStop:     "Stop",
		BatchErrorContinuationOptionUndo:     "Undo",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (b BatchErrorContinuationOption) MarshalText() (text []byte, err error) {
	return []byte(b.String()), nil
}

func (b BatchErrorContinuationOption) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(b))
	return nil
}

func (b BatchErrorContinuationOption) String() string {
	return ttlv.FormatEnum(uint32(b), &BatchErrorContinuationOptionEnum)
}

// Usage Limits Unit Enumeration
// 9.1.3.2.31 Table 319
type UsageLimitsUnit uint32

const (
	UsageLimitsUnitByte   UsageLimitsUnit = 0x00000001
	UsageLimitsUnitObject UsageLimitsUnit = 0x00000002
)

var UsageLimitsUnitEnum = NewUsageLimitsUnitEnum()

func NewUsageLimitsUnitEnum() ttlv.Enum {
	m := map[UsageLimitsUnit]string{
		UsageLimitsUnitByte:   "Byte",
		UsageLimitsUnitObject: "Object",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (u UsageLimitsUnit) MarshalText() (text []byte, err error) {
	return []byte(u.String()), nil
}

func (u UsageLimitsUnit) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(u))
	return nil
}

func (u UsageLimitsUnit) String() string {
	return ttlv.FormatEnum(uint32(u), &UsageLimitsUnitEnum)
}

// Encoding Option Enumeration
// 9.1.3.2.32 Table 320
type EncodingOption uint32

const (
	EncodingOptionNoEncoding   EncodingOption = 0x00000001
	EncodingOptionTTLVEncoding EncodingOption = 0x00000002
)

var EncodingOptionEnum = NewEncodingOptionEnum()

func NewEncodingOptionEnum() ttlv.Enum {
	m := map[EncodingOption]string{
		EncodingOptionNoEncoding:   "No Encoding",
		EncodingOptionTTLVEncoding: "TTLV Encoding",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (e EncodingOption) MarshalText() (text []byte, err error) {
	return []byte(e.String()), nil
}

func (e EncodingOption) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(e))
	return nil
}

func (e EncodingOption) String() string {
	return ttlv.FormatEnum(uint32(e), &EncodingOptionEnum)
}

// Object Group Member Enumeration
// 9.1.3.2.33 Table 321
type ObjectGroupMember uint32

const (
	ObjectGroupMemberGroupMemberFresh   ObjectGroupMember = 0x00000001
	ObjectGroupMemberGroupMemberDefault ObjectGroupMember = 0x00000002
)

var ObjectGroupMemberEnum = NewObjectGroupMemberEnum()

func NewObjectGroupMemberEnum() ttlv.Enum {
	m := map[ObjectGroupMember]string{
		ObjectGroupMemberGroupMemberFresh:   "Group Member Fresh",
		ObjectGroupMemberGroupMemberDefault: "Group Member Default",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (o ObjectGroupMember) MarshalText() (text []byte, err error) {
	return []byte(o.String()), nil
}

func (o ObjectGroupMember) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(o))
	return nil
}

func (o ObjectGroupMember) String() string {
	return ttlv.FormatEnum(uint32(o), &ObjectGroupMemberEnum)
}

// Alternative Name Type Enumeration
// 9.1.3.2.34 Table 322
type AlternativeNameType uint32

const (
	AlternativeNameTypeUninterpretedTextString AlternativeNameType = 0x00000001
	AlternativeNameTypeURI                     AlternativeNameType = 0x00000002
	AlternativeNameTypeObjectSerialNumber      AlternativeNameType = 0x00000003
	AlternativeNameTypeEmailAddress            AlternativeNameType = 0x00000004
	AlternativeNameTypeDNSName                 AlternativeNameType = 0x00000005
	AlternativeNameTypeX_500DistinguishedName  AlternativeNameType = 0x00000006
	AlternativeNameTypeIPAddress               AlternativeNameType = 0x00000007
)

var AlternativeNameTypeEnum = NewAlternativeNameTypeEnum()

func NewAlternativeNameTypeEnum() ttlv.Enum {
	m := map[AlternativeNameType]string{
		AlternativeNameTypeUninterpretedTextString: "Uninterpreted Text String",
		AlternativeNameTypeURI:                     "URI",
		AlternativeNameTypeObjectSerialNumber:      "Object Serial Number",
		AlternativeNameTypeEmailAddress:            "Email Address",
		AlternativeNameTypeDNSName:                 "DNS Name",
		AlternativeNameTypeX_500DistinguishedName:  "X.500 Distinguished Name",
		AlternativeNameTypeIPAddress:               "IP Address",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (a AlternativeNameType) MarshalText() (text []byte, err error) {
	return []byte(a.String()), nil
}

func (a AlternativeNameType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(a))
	return nil
}

func (a AlternativeNameType) String() string {
	return ttlv.FormatEnum(uint32(a), &AlternativeNameTypeEnum)
}

// Key Value Location Type Enumeration
// 9.1.3.2.35 Table 323
type KeyValueLocationType uint32

const (
	KeyValueLocationTypeUninterpretedTextString KeyValueLocationType = 0x00000001
	KeyValueLocationTypeURI                     KeyValueLocationType = 0x00000002
)

var KeyValueLocationTypeEnum = NewKeyValueLocationTypeEnum()

func NewKeyValueLocationTypeEnum() ttlv.Enum {
	m := map[KeyValueLocationType]string{
		KeyValueLocationTypeUninterpretedTextString: "Uninterpreted Text String",
		KeyValueLocationTypeURI:                     "URI",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (k KeyValueLocationType) MarshalText() (text []byte, err error) {
	return []byte(k.String()), nil
}

func (k KeyValueLocationType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(k))
	return nil
}

func (k KeyValueLocationType) String() string {
	return ttlv.FormatEnum(uint32(k), &KeyValueLocationTypeEnum)
}

// Attestation Type Enumeration
// 9.1.3.2.36 Table 324
type AttestationType uint32

const (
	AttestationTypeTPMQuote           AttestationType = 0x00000001
	AttestationTypeTCGIntegrityReport AttestationType = 0x00000002
	AttestationTypeSAMLAssertion      AttestationType = 0x00000003
)

var AttestationTypeEnum = NewAttestationTypeEnum()

func NewAttestationTypeEnum() ttlv.Enum {
	m := map[AttestationType]string{
		AttestationTypeTPMQuote:           "TPM Quote",
		AttestationTypeTCGIntegrityReport: "TCG Integrity Report",
		AttestationTypeSAMLAssertion:      "SAML Assertion",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (a AttestationType) MarshalText() (text []byte, err error) {
	return []byte(a.String()), nil
}

func (a AttestationType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(a))
	return nil
}

func (a AttestationType) String() string {
	return ttlv.FormatEnum(uint32(a), &AttestationTypeEnum)
}

// RNG Algorithm Enumeration
// 9.1.3.2.37 Table
type RNGAlgorithm uint32

const (
	RNGAlgorithmUnspecified RNGAlgorithm = 0x00000001
	RNGAlgorithmFIPS186_2   RNGAlgorithm = 0x00000002
	RNGAlgorithmDRBG        RNGAlgorithm = 0x00000003
	RNGAlgorithmNRBG        RNGAlgorithm = 0x00000004
	RNGAlgorithmANSIX9_31   RNGAlgorithm = 0x00000005
	RNGAlgorithmANSIX9_62   RNGAlgorithm = 0x00000006
)

var RNGAlgorithmEnum = NewRNGAlgorithmEnum()

func NewRNGAlgorithmEnum() ttlv.Enum {
	m := map[RNGAlgorithm]string{
		RNGAlgorithmUnspecified: "Unspecified",
		RNGAlgorithmFIPS186_2:   "FIPS 186-2",
		RNGAlgorithmDRBG:        "DRBG",
		RNGAlgorithmNRBG:        "NRBG",
		RNGAlgorithmANSIX9_31:   "ANSI X9.31",
		RNGAlgorithmANSIX9_62:   "ANSI X9.62",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (r RNGAlgorithm) MarshalText() (text []byte, err error) {
	return []byte(r.String()), nil
}

func (r RNGAlgorithm) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(r))
	return nil
}

func (r RNGAlgorithm) String() string {
	return ttlv.FormatEnum(uint32(r), &RNGAlgorithmEnum)
}

// DRBG Algorithm Enumeration
// 9.1.3.2.38
type DRBGAlgorithm uint32

const (
	DRBGAlgorithmUnspecified DRBGAlgorithm = 0x00000001
	DRBGAlgorithmDual_EC     DRBGAlgorithm = 0x00000002
	DRBGAlgorithmHash        DRBGAlgorithm = 0x00000003
	DRBGAlgorithmHMAC        DRBGAlgorithm = 0x00000004
	DRBGAlgorithmCTR         DRBGAlgorithm = 0x00000005
)

var DRBGAlgorithmEnum = NewDRBGAlgorithmEnum()

func NewDRBGAlgorithmEnum() ttlv.Enum {
	m := map[DRBGAlgorithm]string{
		DRBGAlgorithmUnspecified: "Unspecified",
		DRBGAlgorithmDual_EC:     "Dual - EC",
		DRBGAlgorithmHash:        "Hash",
		DRBGAlgorithmHMAC:        "HMAC",
		DRBGAlgorithmCTR:         "CTR",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (d DRBGAlgorithm) MarshalText() (text []byte, err error) {
	return []byte(d.String()), nil
}

func (d DRBGAlgorithm) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(d))
	return nil
}

func (d DRBGAlgorithm) String() string {
	return ttlv.FormatEnum(uint32(d), &DRBGAlgorithmEnum)
}

// FIPS186 Variation Enumeration
// 9.1.3.2.39
type FIPS186Variation uint32

const (
	FIPS186VariationUnspecified     FIPS186Variation = 0x00000001
	FIPS186VariationGPXOriginal     FIPS186Variation = 0x00000002
	FIPS186VariationGPXChangeNotice FIPS186Variation = 0x00000003
	FIPS186VariationXOriginal       FIPS186Variation = 0x00000004
	FIPS186VariationXChangeNotice   FIPS186Variation = 0x00000005
	FIPS186VariationKOriginal       FIPS186Variation = 0x00000006
	FIPS186VariationKChangeNotice   FIPS186Variation = 0x00000007
)

var FIPS186VariationEnum = NewFIPS186VariationEnum()

func NewFIPS186VariationEnum() ttlv.Enum {
	m := map[FIPS186Variation]string{
		FIPS186VariationUnspecified:     "Unspecified",
		FIPS186VariationGPXOriginal:     "GP x-Original",
		FIPS186VariationGPXChangeNotice: "GP x-Change Notice",
		FIPS186VariationXOriginal:       "x-Original",
		FIPS186VariationXChangeNotice:   "x-Change Notice",
		FIPS186VariationKOriginal:       "k-Original",
		FIPS186VariationKChangeNotice:   "k-Change Notice",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (f FIPS186Variation) MarshalText() (text []byte, err error) {
	return []byte(f.String()), nil
}

func (f FIPS186Variation) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(f))
	return nil
}

func (f FIPS186Variation) String() string {
	return ttlv.FormatEnum(uint32(f), &FIPS186VariationEnum)
}

// Validation Authority Type Enumeration
// 9.1.3.2.40
type ValidationAuthorityType uint32

const (
	ValidationAuthorityTypeUnspecified    ValidationAuthorityType = 0x00000001
	ValidationAuthorityTypeNISTCMVP       ValidationAuthorityType = 0x00000002
	ValidationAuthorityTypeCommonCriteria ValidationAuthorityType = 0x00000003
)

var ValidationAuthorityTypeEnum = NewValidationAuthorityTypeEnum()

func NewValidationAuthorityTypeEnum() ttlv.Enum {
	m := map[ValidationAuthorityType]string{
		ValidationAuthorityTypeUnspecified:    "Unspecified",
		ValidationAuthorityTypeNISTCMVP:       "NIST CMVP",
		ValidationAuthorityTypeCommonCriteria: "Common Criteria",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (v ValidationAuthorityType) MarshalText() (text []byte, err error) {
	return []byte(v.String()), nil
}

func (v ValidationAuthorityType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(v))
	return nil
}

func (v ValidationAuthorityType) String() string {
	return ttlv.FormatEnum(uint32(v), &ValidationAuthorityTypeEnum)
}

// Validation Type Enumeration
// 9.1.3.2.41
type ValidationType uint32

const (
	ValidationTypeUnspecified ValidationType = 0x00000001
	ValidationTypeHardware    ValidationType = 0x00000002
	ValidationTypeSoftware    ValidationType = 0x00000003
	ValidationTypeFirmware    ValidationType = 0x00000004
	ValidationTypeHybrid      ValidationType = 0x00000005
)

var ValidationTypeEnum = NewValidationTypeEnum()

func NewValidationTypeEnum() ttlv.Enum {
	m := map[ValidationType]string{
		ValidationTypeUnspecified: "Unspecified",
		ValidationTypeHardware:    "Hardware",
		ValidationTypeSoftware:    "Software",
		ValidationTypeFirmware:    "Firmware",
		ValidationTypeHybrid:      "Hybrid",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (v ValidationType) MarshalText() (text []byte, err error) {
	return []byte(v.String()), nil
}

func (v ValidationType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(v))
	return nil
}

func (v ValidationType) String() string {
	return ttlv.FormatEnum(uint32(v), &ValidationTypeEnum)
}

// Profile Name Enumeration
// 9.1.3.2.42
type ProfileName uint32

const (
	ProfileNameBaselineServerBasicKMIPV1_2                       ProfileName = 0x00000001
	ProfileNameBaselineServerTLSV1_2KMIPV1_2                     ProfileName = 0x00000002
	ProfileNameBaselineClientBasicKMIPV1_2                       ProfileName = 0x00000003
	ProfileNameBaselineClientTLSV1_2KMIPV1_2                     ProfileName = 0x00000004
	ProfileNameCompleteServerBasicKMIPV1_2                       ProfileName = 0x00000005
	ProfileNameCompleteServerTLSV1_2KMIPV1_2                     ProfileName = 0x00000006
	ProfileNameTapeLibraryClientKMIPV1_0                         ProfileName = 0x00000007
	ProfileNameTapeLibraryClientKMIPV1_1                         ProfileName = 0x00000008
	ProfileNameTapeLibraryClientKMIPV1_2                         ProfileName = 0x00000009
	ProfileNameTapeLibraryServerKMIPV1_0                         ProfileName = 0x0000000a
	ProfileNameTapeLibraryServerKMIPV1_1                         ProfileName = 0x0000000b
	ProfileNameTapeLibraryServerKMIPV1_2                         ProfileName = 0x0000000c
	ProfileNameSymmetricKeyLifecycleClientKMIPV1_0               ProfileName = 0x0000000d
	ProfileNameSymmetricKeyLifecycleClientKMIPV1_1               ProfileName = 0x0000000e
	ProfileNameSymmetricKeyLifecycleClientKMIPV1_2               ProfileName = 0x0000000f
	ProfileNameSymmetricKeyLifecycleServerKMIPV1_0               ProfileName = 0x00000010
	ProfileNameSymmetricKeyLifecycleServerKMIPV1_1               ProfileName = 0x00000011
	ProfileNameSymmetricKeyLifecycleServerKMIPV1_2               ProfileName = 0x00000012
	ProfileNameAsymmetricKeyLifecycleClientKMIPV1_0              ProfileName = 0x00000013
	ProfileNameAsymmetricKeyLifecycleClientKMIPV1_1              ProfileName = 0x00000014
	ProfileNameAsymmetricKeyLifecycleClientKMIPV1_2              ProfileName = 0x00000015
	ProfileNameAsymmetricKeyLifecycleServerKMIPV1_0              ProfileName = 0x00000016
	ProfileNameAsymmetricKeyLifecycleServerKMIPV1_1              ProfileName = 0x00000017
	ProfileNameAsymmetricKeyLifecycleServerKMIPV1_2              ProfileName = 0x00000018
	ProfileNameBasicCryptographicClientKMIPV1_2                  ProfileName = 0x00000019
	ProfileNameBasicCryptographicServerKMIPV1_2                  ProfileName = 0x0000001a
	ProfileNameAdvancedCryptographicClientKMIPV1_2               ProfileName = 0x0000001b
	ProfileNameAdvancedCryptographicServerKMIPV1_2               ProfileName = 0x0000001c
	ProfileNameRNGCryptographicClientKMIPV1_2                    ProfileName = 0x0000001d
	ProfileNameRNGCryptographicServerKMIPV1_2                    ProfileName = 0x0000001e
	ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_0            ProfileName = 0x0000001f
	ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_0     ProfileName = 0x00000020
	ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_0         ProfileName = 0x00000021
	ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_1            ProfileName = 0x00000022
	ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_1     ProfileName = 0x00000023
	ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_1         ProfileName = 0x00000024
	ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_2            ProfileName = 0x00000025
	ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_2     ProfileName = 0x00000026
	ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_2         ProfileName = 0x00000027
	ProfileNameSymmetricKeyFoundryServerKMIPV1_0                 ProfileName = 0x00000028
	ProfileNameSymmetricKeyFoundryServerKMIPV1_1                 ProfileName = 0x00000029
	ProfileNameSymmetricKeyFoundryServerKMIPV1_2                 ProfileName = 0x0000002a
	ProfileNameOpaqueManagedObjectStoreClientKMIPV1_0            ProfileName = 0x0000002b
	ProfileNameOpaqueManagedObjectStoreClientKMIPV1_1            ProfileName = 0x0000002c
	ProfileNameOpaqueManagedObjectStoreClientKMIPV1_2            ProfileName = 0x0000002d
	ProfileNameOpaqueManagedObjectStoreServerKMIPV1_0            ProfileName = 0x0000002e
	ProfileNameOpaqueManagedObjectStoreServerKMIPV1_1            ProfileName = 0x0000002f
	ProfileNameOpaqueManagedObjectStoreServerKMIPV1_2            ProfileName = 0x00000030
	ProfileNameSuiteBMinLOS_128ClientKMIPV1_0                    ProfileName = 0x00000031
	ProfileNameSuiteBMinLOS_128ClientKMIPV1_1                    ProfileName = 0x00000032
	ProfileNameSuiteBMinLOS_128ClientKMIPV1_2                    ProfileName = 0x00000033
	ProfileNameSuiteBMinLOS_128ServerKMIPV1_0                    ProfileName = 0x00000034
	ProfileNameSuiteBMinLOS_128ServerKMIPV1_1                    ProfileName = 0x00000035
	ProfileNameSuiteBMinLOS_128ServerKMIPV1_2                    ProfileName = 0x00000036
	ProfileNameSuiteBMinLOS_192ClientKMIPV1_0                    ProfileName = 0x00000037
	ProfileNameSuiteBMinLOS_192ClientKMIPV1_1                    ProfileName = 0x00000038
	ProfileNameSuiteBMinLOS_192ClientKMIPV1_2                    ProfileName = 0x00000039
	ProfileNameSuiteBMinLOS_192ServerKMIPV1_0                    ProfileName = 0x0000003a
	ProfileNameSuiteBMinLOS_192ServerKMIPV1_1                    ProfileName = 0x0000003b
	ProfileNameSuiteBMinLOS_192ServerKMIPV1_2                    ProfileName = 0x0000003c
	ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_0 ProfileName = 0x0000003d
	ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_1 ProfileName = 0x0000003e
	ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_2 ProfileName = 0x0000003f
	ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_0 ProfileName = 0x00000040
	ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_1 ProfileName = 0x00000041
	ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_2 ProfileName = 0x00000042
	ProfileNameHTTPSClientKMIPV1_0                               ProfileName = 0x00000043
	ProfileNameHTTPSClientKMIPV1_1                               ProfileName = 0x00000044
	ProfileNameHTTPSClientKMIPV1_2                               ProfileName = 0x00000045
	ProfileNameHTTPSServerKMIPV1_0                               ProfileName = 0x00000046
	ProfileNameHTTPSServerKMIPV1_1                               ProfileName = 0x00000047
	ProfileNameHTTPSServerKMIPV1_2                               ProfileName = 0x00000048
	ProfileNameJSONClientKMIPV1_0                                ProfileName = 0x00000049
	ProfileNameJSONClientKMIPV1_1                                ProfileName = 0x0000004a
	ProfileNameJSONClientKMIPV1_2                                ProfileName = 0x0000004b
	ProfileNameJSONServerKMIPV1_0                                ProfileName = 0x0000004c
	ProfileNameJSONServerKMIPV1_1                                ProfileName = 0x0000004d
	ProfileNameJSONServerKMIPV1_2                                ProfileName = 0x0000004e
	ProfileNameXMLClientKMIPV1_0                                 ProfileName = 0x0000004f
	ProfileNameXMLClientKMIPV1_1                                 ProfileName = 0x00000050
	ProfileNameXMLClientKMIPV1_2                                 ProfileName = 0x00000051
	ProfileNameXMLServerKMIPV1_0                                 ProfileName = 0x00000052
	ProfileNameXMLServerKMIPV1_1                                 ProfileName = 0x00000053
	ProfileNameXMLServerKMIPV1_2                                 ProfileName = 0x00000054
	ProfileNameBaselineServerBasicKMIPV1_3                       ProfileName = 0x00000055
	ProfileNameBaselineServerTLSV1_2KMIPV1_3                     ProfileName = 0x00000056
	ProfileNameBaselineClientBasicKMIPV1_3                       ProfileName = 0x00000057
	ProfileNameBaselineClientTLSV1_2KMIPV1_3                     ProfileName = 0x00000058
	ProfileNameCompleteServerBasicKMIPV1_3                       ProfileName = 0x00000059
	ProfileNameCompleteServerTLSV1_2KMIPV1_3                     ProfileName = 0x0000005a
	ProfileNameTapeLibraryClientKMIPV1_3                         ProfileName = 0x0000005b
	ProfileNameTapeLibraryServerKMIPV1_3                         ProfileName = 0x0000005c
	ProfileNameSymmetricKeyLifecycleClientKMIPV1_3               ProfileName = 0x0000005d
	ProfileNameSymmetricKeyLifecycleServerKMIPV1_3               ProfileName = 0x0000005e
	ProfileNameAsymmetricKeyLifecycleClientKMIPV1_3              ProfileName = 0x0000005f
	ProfileNameAsymmetricKeyLifecycleServerKMIPV1_3              ProfileName = 0x00000060
	ProfileNameBasicCryptographicClientKMIPV1_3                  ProfileName = 0x00000061
	ProfileNameBasicCryptographicServerKMIPV1_3                  ProfileName = 0x00000062
	ProfileNameAdvancedCryptographicClientKMIPV1_3               ProfileName = 0x00000063
	ProfileNameAdvancedCryptographicServerKMIPV1_3               ProfileName = 0x00000064
	ProfileNameRNGCryptographicClientKMIPV1_3                    ProfileName = 0x00000065
	ProfileNameRNGCryptographicServerKMIPV1_3                    ProfileName = 0x00000066
	ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_3            ProfileName = 0x00000067
	ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_3     ProfileName = 0x00000068
	ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_3         ProfileName = 0x00000069
	ProfileNameSymmetricKeyFoundryServerKMIPV1_3                 ProfileName = 0x0000006a
	ProfileNameOpaqueManagedObjectStoreClientKMIPV1_3            ProfileName = 0x0000006b
	ProfileNameOpaqueManagedObjectStoreServerKMIPV1_3            ProfileName = 0x0000006c
	ProfileNameSuiteBMinLOS_128ClientKMIPV1_3                    ProfileName = 0x0000006d
	ProfileNameSuiteBMinLOS_128ServerKMIPV1_3                    ProfileName = 0x0000006e
	ProfileNameSuiteBMinLOS_192ClientKMIPV1_3                    ProfileName = 0x0000006f
	ProfileNameSuiteBMinLOS_192ServerKMIPV1_3                    ProfileName = 0x00000070
	ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_3 ProfileName = 0x00000071
	ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_3 ProfileName = 0x00000072
	ProfileNameHTTPSClientKMIPV1_3                               ProfileName = 0x00000073
	ProfileNameHTTPSServerKMIPV1_3                               ProfileName = 0x00000074
	ProfileNameJSONClientKMIPV1_3                                ProfileName = 0x00000075
	ProfileNameJSONServerKMIPV1_3                                ProfileName = 0x00000076
	ProfileNameXMLClientKMIPV1_3                                 ProfileName = 0x00000077
	ProfileNameXMLServerKMIPV1_3                                 ProfileName = 0x00000078
	ProfileNameBaselineServerBasicKMIPV1_4                       ProfileName = 0x00000079
	ProfileNameBaselineServerTLSV1_2KMIPV1_4                     ProfileName = 0x0000007a
	ProfileNameBaselineClientBasicKMIPV1_4                       ProfileName = 0x0000007b
	ProfileNameBaselineClientTLSV1_2KMIPV1_4                     ProfileName = 0x0000007c
	ProfileNameCompleteServerBasicKMIPV1_4                       ProfileName = 0x0000007d
	ProfileNameCompleteServerTLSV1_2KMIPV1_4                     ProfileName = 0x0000007e
	ProfileNameTapeLibraryClientKMIPV1_4                         ProfileName = 0x0000007f
	ProfileNameTapeLibraryServerKMIPV1_4                         ProfileName = 0x00000080
	ProfileNameSymmetricKeyLifecycleClientKMIPV1_4               ProfileName = 0x00000081
	ProfileNameSymmetricKeyLifecycleServerKMIPV1_4               ProfileName = 0x00000082
	ProfileNameAsymmetricKeyLifecycleClientKMIPV1_4              ProfileName = 0x00000083
	ProfileNameAsymmetricKeyLifecycleServerKMIPV1_4              ProfileName = 0x00000084
	ProfileNameBasicCryptographicClientKMIPV1_4                  ProfileName = 0x00000085
	ProfileNameBasicCryptographicServerKMIPV1_4                  ProfileName = 0x00000086
	ProfileNameAdvancedCryptographicClientKMIPV1_4               ProfileName = 0x00000087
	ProfileNameAdvancedCryptographicServerKMIPV1_4               ProfileName = 0x00000088
	ProfileNameRNGCryptographicClientKMIPV1_4                    ProfileName = 0x00000089
	ProfileNameRNGCryptographicServerKMIPV1_4                    ProfileName = 0x0000008a
	ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_4            ProfileName = 0x0000008b
	ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_4     ProfileName = 0x0000008c
	ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_4         ProfileName = 0x0000008d
	ProfileNameSymmetricKeyFoundryServerKMIPV1_4                 ProfileName = 0x0000008e
	ProfileNameOpaqueManagedObjectStoreClientKMIPV1_4            ProfileName = 0x0000008f
	ProfileNameOpaqueManagedObjectStoreServerKMIPV1_4            ProfileName = 0x00000090
	ProfileNameSuiteBMinLOS_128ClientKMIPV1_4                    ProfileName = 0x00000091
	ProfileNameSuiteBMinLOS_128ServerKMIPV1_4                    ProfileName = 0x00000092
	ProfileNameSuiteBMinLOS_192ClientKMIPV1_4                    ProfileName = 0x00000093
	ProfileNameSuiteBMinLOS_192ServerKMIPV1_4                    ProfileName = 0x00000094
	ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_4 ProfileName = 0x00000095
	ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_4 ProfileName = 0x00000096
	ProfileNameHTTPSClientKMIPV1_4                               ProfileName = 0x00000097
	ProfileNameHTTPSServerKMIPV1_4                               ProfileName = 0x00000098
	ProfileNameJSONClientKMIPV1_4                                ProfileName = 0x00000099
	ProfileNameJSONServerKMIPV1_4                                ProfileName = 0x0000009a
	ProfileNameXMLClientKMIPV1_4                                 ProfileName = 0x0000009b
	ProfileNameXMLServerKMIPV1_4                                 ProfileName = 0x0000009c
)

var ProfileNameEnum = NewProfileNameEnum()

func NewProfileNameEnum() ttlv.Enum {
	m := map[ProfileName]string{
		ProfileNameBaselineServerBasicKMIPV1_2:                       "Baseline Server Basic KMIP v1.2",
		ProfileNameBaselineServerTLSV1_2KMIPV1_2:                     "Baseline Server TLS v1.2 KMIP v1.2",
		ProfileNameBaselineClientBasicKMIPV1_2:                       "Baseline Client Basic KMIP v1.2",
		ProfileNameBaselineClientTLSV1_2KMIPV1_2:                     "Baseline Client TLS v1.2 KMIP v1.2",
		ProfileNameCompleteServerBasicKMIPV1_2:                       "Complete Server Basic KMIP v1.2",
		ProfileNameCompleteServerTLSV1_2KMIPV1_2:                     "Complete Server TLS v1.2 KMIP v1.2",
		ProfileNameTapeLibraryClientKMIPV1_0:                         "Tape Library Client KMIP v1.0",
		ProfileNameTapeLibraryClientKMIPV1_1:                         "Tape Library Client KMIP v1.1",
		ProfileNameTapeLibraryClientKMIPV1_2:                         "Tape Library Client KMIP v1.2",
		ProfileNameTapeLibraryServerKMIPV1_0:                         "Tape Library Server KMIP v1.0",
		ProfileNameTapeLibraryServerKMIPV1_1:                         "Tape Library Server KMIP v1.1",
		ProfileNameTapeLibraryServerKMIPV1_2:                         "Tape Library Server KMIP v1.2",
		ProfileNameSymmetricKeyLifecycleClientKMIPV1_0:               "Symmetric Key Lifecycle Client KMIP v1.0",
		ProfileNameSymmetricKeyLifecycleClientKMIPV1_1:               "Symmetric Key Lifecycle Client KMIP v1.1",
		ProfileNameSymmetricKeyLifecycleClientKMIPV1_2:               "Symmetric Key Lifecycle Client KMIP v1.2",
		ProfileNameSymmetricKeyLifecycleServerKMIPV1_0:               "Symmetric Key Lifecycle Server KMIP v1.0",
		ProfileNameSymmetricKeyLifecycleServerKMIPV1_1:               "Symmetric Key Lifecycle Server KMIP v1.1",
		ProfileNameSymmetricKeyLifecycleServerKMIPV1_2:               "Symmetric Key Lifecycle Server KMIP v1.2",
		ProfileNameAsymmetricKeyLifecycleClientKMIPV1_0:              "Asymmetric Key Lifecycle Client KMIP v1.0",
		ProfileNameAsymmetricKeyLifecycleClientKMIPV1_1:              "Asymmetric Key Lifecycle Client KMIP v1.1",
		ProfileNameAsymmetricKeyLifecycleClientKMIPV1_2:              "Asymmetric Key Lifecycle Client KMIP v1.2",
		ProfileNameAsymmetricKeyLifecycleServerKMIPV1_0:              "Asymmetric Key Lifecycle Server KMIP v1.0",
		ProfileNameAsymmetricKeyLifecycleServerKMIPV1_1:              "Asymmetric Key Lifecycle Server KMIP v1.1",
		ProfileNameAsymmetricKeyLifecycleServerKMIPV1_2:              "Asymmetric Key Lifecycle Server KMIP v1.2",
		ProfileNameBasicCryptographicClientKMIPV1_2:                  "Basic Cryptographic Client KMIP v1.2",
		ProfileNameBasicCryptographicServerKMIPV1_2:                  "Basic Cryptographic Server KMIP v1.2",
		ProfileNameAdvancedCryptographicClientKMIPV1_2:               "Advanced Cryptographic Client KMIP v1.2",
		ProfileNameAdvancedCryptographicServerKMIPV1_2:               "Advanced Cryptographic Server KMIP v1.2",
		ProfileNameRNGCryptographicClientKMIPV1_2:                    "RNG Cryptographic Client KMIP v1.2",
		ProfileNameRNGCryptographicServerKMIPV1_2:                    "RNG Cryptographic Server KMIP v1.2",
		ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_0:            "Basic Symmetric Key Foundry Client KMIP v1.0",
		ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_0:     "Intermediate Symmetric Key Foundry Client KMIP v1.0",
		ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_0:         "Advanced Symmetric Key Foundry Client KMIP v1.0",
		ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_1:            "Basic Symmetric Key Foundry Client KMIP v1.1",
		ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_1:     "Intermediate Symmetric Key Foundry Client KMIP v1.1",
		ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_1:         "Advanced Symmetric Key Foundry Client KMIP v1.1",
		ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_2:            "Basic Symmetric Key Foundry Client KMIP v1.2",
		ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_2:     "Intermediate Symmetric Key Foundry Client KMIP v1.2",
		ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_2:         "Advanced Symmetric Key Foundry Client KMIP v1.2",
		ProfileNameSymmetricKeyFoundryServerKMIPV1_0:                 "Symmetric Key Foundry Server KMIP v1.0",
		ProfileNameSymmetricKeyFoundryServerKMIPV1_1:                 "Symmetric Key Foundry Server KMIP v1.1",
		ProfileNameSymmetricKeyFoundryServerKMIPV1_2:                 "Symmetric Key Foundry Server KMIP v1.2",
		ProfileNameOpaqueManagedObjectStoreClientKMIPV1_0:            "Opaque Managed Object Store Client KMIP v1.0",
		ProfileNameOpaqueManagedObjectStoreClientKMIPV1_1:            "Opaque Managed Object Store Client KMIP v1.1",
		ProfileNameOpaqueManagedObjectStoreClientKMIPV1_2:            "Opaque Managed Object Store Client KMIP v1.2",
		ProfileNameOpaqueManagedObjectStoreServerKMIPV1_0:            "Opaque Managed Object Store Server KMIP v1.0",
		ProfileNameOpaqueManagedObjectStoreServerKMIPV1_1:            "Opaque Managed Object Store Server KMIP v1.1",
		ProfileNameOpaqueManagedObjectStoreServerKMIPV1_2:            "Opaque Managed Object Store Server KMIP v1.2",
		ProfileNameSuiteBMinLOS_128ClientKMIPV1_0:                    "Suite B minLOS_128 Client KMIP v1.0",
		ProfileNameSuiteBMinLOS_128ClientKMIPV1_1:                    "Suite B minLOS_128 Client KMIP v1.1",
		ProfileNameSuiteBMinLOS_128ClientKMIPV1_2:                    "Suite B minLOS_128 Client KMIP v1.2",
		ProfileNameSuiteBMinLOS_128ServerKMIPV1_0:                    "Suite B minLOS_128 Server KMIP v1.0",
		ProfileNameSuiteBMinLOS_128ServerKMIPV1_1:                    "Suite B minLOS_128 Server KMIP v1.1",
		ProfileNameSuiteBMinLOS_128ServerKMIPV1_2:                    "Suite B minLOS_128 Server KMIP v1.2",
		ProfileNameSuiteBMinLOS_192ClientKMIPV1_0:                    "Suite B minLOS_192 Client KMIP v1.0",
		ProfileNameSuiteBMinLOS_192ClientKMIPV1_1:                    "Suite B minLOS_192 Client KMIP v1.1",
		ProfileNameSuiteBMinLOS_192ClientKMIPV1_2:                    "Suite B minLOS_192 Client KMIP v1.2",
		ProfileNameSuiteBMinLOS_192ServerKMIPV1_0:                    "Suite B minLOS_192 Server KMIP v1.0",
		ProfileNameSuiteBMinLOS_192ServerKMIPV1_1:                    "Suite B minLOS_192 Server KMIP v1.1",
		ProfileNameSuiteBMinLOS_192ServerKMIPV1_2:                    "Suite B minLOS_192 Server KMIP v1.2",
		ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_0: "Storage Array with Self Encrypting Drive Client KMIP v1.0",
		ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_1: "Storage Array with Self Encrypting Drive Client KMIP v1.1",
		ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_2: "Storage Array with Self Encrypting Drive Client KMIP v1.2",
		ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_0: "Storage Array with Self Encrypting Drive Server KMIP v1.0",
		ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_1: "Storage Array with Self Encrypting Drive Server KMIP v1.1",
		ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_2: "Storage Array with Self Encrypting Drive Server KMIP v1.2",
		ProfileNameHTTPSClientKMIPV1_0:                               "HTTPS Client KMIP v1.0",
		ProfileNameHTTPSClientKMIPV1_1:                               "HTTPS Client KMIP v1.1",
		ProfileNameHTTPSClientKMIPV1_2:                               "HTTPS Client KMIP v1.2",
		ProfileNameHTTPSServerKMIPV1_0:                               "HTTPS Server KMIP v1.0",
		ProfileNameHTTPSServerKMIPV1_1:                               "HTTPS Server KMIP v1.1",
		ProfileNameHTTPSServerKMIPV1_2:                               "HTTPS Server KMIP v1.2",
		ProfileNameJSONClientKMIPV1_0:                                "JSON Client KMIP v1.0",
		ProfileNameJSONClientKMIPV1_1:                                "JSON Client KMIP v1.1",
		ProfileNameJSONClientKMIPV1_2:                                "JSON Client KMIP v1.2",
		ProfileNameJSONServerKMIPV1_0:                                "JSON Server KMIP v1.0",
		ProfileNameJSONServerKMIPV1_1:                                "JSON Server KMIP v1.1",
		ProfileNameJSONServerKMIPV1_2:                                "JSON Server KMIP v1.2",
		ProfileNameXMLClientKMIPV1_0:                                 "XML Client KMIP v1.0",
		ProfileNameXMLClientKMIPV1_1:                                 "XML Client KMIP v1.1",
		ProfileNameXMLClientKMIPV1_2:                                 "XML Client KMIP v1.2",
		ProfileNameXMLServerKMIPV1_0:                                 "XML Server KMIP v1.0",
		ProfileNameXMLServerKMIPV1_1:                                 "XML Server KMIP v1.1",
		ProfileNameXMLServerKMIPV1_2:                                 "XML Server KMIP v1.2",
		ProfileNameBaselineServerBasicKMIPV1_3:                       "Baseline Server Basic KMIP v1.3",
		ProfileNameBaselineServerTLSV1_2KMIPV1_3:                     "Baseline Server TLS v1.2 KMIP v1.3",
		ProfileNameBaselineClientBasicKMIPV1_3:                       "Baseline Client Basic KMIP v1.3",
		ProfileNameBaselineClientTLSV1_2KMIPV1_3:                     "Baseline Client TLS v1.2 KMIP v1.3",
		ProfileNameCompleteServerBasicKMIPV1_3:                       "Complete Server Basic KMIP v1.3",
		ProfileNameCompleteServerTLSV1_2KMIPV1_3:                     "Complete Server TLS v1.2 KMIP v1.3",
		ProfileNameTapeLibraryClientKMIPV1_3:                         "Tape Library Client KMIP v1.3",
		ProfileNameTapeLibraryServerKMIPV1_3:                         "Tape Library Server KMIP v1.3",
		ProfileNameSymmetricKeyLifecycleClientKMIPV1_3:               "Symmetric Key Lifecycle Client KMIP v1.3",
		ProfileNameSymmetricKeyLifecycleServerKMIPV1_3:               "Symmetric Key Lifecycle Server KMIP v1.3",
		ProfileNameAsymmetricKeyLifecycleClientKMIPV1_3:              "Asymmetric Key Lifecycle Client KMIP v1.3",
		ProfileNameAsymmetricKeyLifecycleServerKMIPV1_3:              "Asymmetric Key Lifecycle Server KMIP v1.3",
		ProfileNameBasicCryptographicClientKMIPV1_3:                  "Basic Cryptographic Client KMIP v1.3",
		ProfileNameBasicCryptographicServerKMIPV1_3:                  "Basic Cryptographic Server KMIP v1.3",
		ProfileNameAdvancedCryptographicClientKMIPV1_3:               "Advanced Cryptographic Client KMIP v1.3",
		ProfileNameAdvancedCryptographicServerKMIPV1_3:               "Advanced Cryptographic Server KMIP v1.3",
		ProfileNameRNGCryptographicClientKMIPV1_3:                    "RNG Cryptographic Client KMIP v1.3",
		ProfileNameRNGCryptographicServerKMIPV1_3:                    "RNG Cryptographic Server KMIP v1.3",
		ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_3:            "Basic Symmetric Key Foundry Client KMIP v1.3",
		ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_3:     "Intermediate Symmetric Key Foundry Client KMIP v1.3",
		ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_3:         "Advanced Symmetric Key Foundry Client KMIP v1.3",
		ProfileNameSymmetricKeyFoundryServerKMIPV1_3:                 "Symmetric Key Foundry Server KMIP v1.3",
		ProfileNameOpaqueManagedObjectStoreClientKMIPV1_3:            "Opaque Managed Object Store Client KMIP v1.3",
		ProfileNameOpaqueManagedObjectStoreServerKMIPV1_3:            "Opaque Managed Object Store Server KMIP v1.3",
		ProfileNameSuiteBMinLOS_128ClientKMIPV1_3:                    "Suite B minLOS_128 Client KMIP v1.3",
		ProfileNameSuiteBMinLOS_128ServerKMIPV1_3:                    "Suite B minLOS_128 Server KMIP v1.3",
		ProfileNameSuiteBMinLOS_192ClientKMIPV1_3:                    "Suite B minLOS_192 Client KMIP v1.3",
		ProfileNameSuiteBMinLOS_192ServerKMIPV1_3:                    "Suite B minLOS_192 Server KMIP v1.3",
		ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_3: "Storage Array with Self Encrypting Drive Client KMIP v1.3",
		ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_3: "Storage Array with Self Encrypting Drive Server KMIP v1.3",
		ProfileNameHTTPSClientKMIPV1_3:                               "HTTPS Client KMIP v1.3",
		ProfileNameHTTPSServerKMIPV1_3:                               "HTTPS Server KMIP v1.3",
		ProfileNameJSONClientKMIPV1_3:                                "JSON Client KMIP v1.3",
		ProfileNameJSONServerKMIPV1_3:                                "JSON Server KMIP v1.3",
		ProfileNameXMLClientKMIPV1_3:                                 "XML Client KMIP v1.3",
		ProfileNameXMLServerKMIPV1_3:                                 "XML Server KMIP v1.3",
		ProfileNameBaselineServerBasicKMIPV1_4:                       "Baseline Server Basic KMIP v1.4",
		ProfileNameBaselineServerTLSV1_2KMIPV1_4:                     "Baseline Server TLS v1.2 KMIP v1.4",
		ProfileNameBaselineClientBasicKMIPV1_4:                       "Baseline Client Basic KMIP v1.4",
		ProfileNameBaselineClientTLSV1_2KMIPV1_4:                     "Baseline Client TLS v1.2 KMIP v1.4",
		ProfileNameCompleteServerBasicKMIPV1_4:                       "Complete Server Basic KMIP v1.4",
		ProfileNameCompleteServerTLSV1_2KMIPV1_4:                     "Complete Server TLS v1.2 KMIP v1.4",
		ProfileNameTapeLibraryClientKMIPV1_4:                         "Tape Library Client KMIP v1.4",
		ProfileNameTapeLibraryServerKMIPV1_4:                         "Tape Library Server KMIP v1.4",
		ProfileNameSymmetricKeyLifecycleClientKMIPV1_4:               "Symmetric Key Lifecycle Client KMIP v1.4",
		ProfileNameSymmetricKeyLifecycleServerKMIPV1_4:               "Symmetric Key Lifecycle Server KMIP v1.4",
		ProfileNameAsymmetricKeyLifecycleClientKMIPV1_4:              "Asymmetric Key Lifecycle Client KMIP v1.4",
		ProfileNameAsymmetricKeyLifecycleServerKMIPV1_4:              "Asymmetric Key Lifecycle Server KMIP v1.4",
		ProfileNameBasicCryptographicClientKMIPV1_4:                  "Basic Cryptographic Client KMIP v1.4",
		ProfileNameBasicCryptographicServerKMIPV1_4:                  "Basic Cryptographic Server KMIP v1.4",
		ProfileNameAdvancedCryptographicClientKMIPV1_4:               "Advanced Cryptographic Client KMIP v1.4",
		ProfileNameAdvancedCryptographicServerKMIPV1_4:               "Advanced Cryptographic Server KMIP v1.4",
		ProfileNameRNGCryptographicClientKMIPV1_4:                    "RNG Cryptographic Client KMIP v1.4",
		ProfileNameRNGCryptographicServerKMIPV1_4:                    "RNG Cryptographic Server KMIP v1.4",
		ProfileNameBasicSymmetricKeyFoundryClientKMIPV1_4:            "Basic Symmetric Key Foundry Client KMIP v1.4",
		ProfileNameIntermediateSymmetricKeyFoundryClientKMIPV1_4:     "Intermediate Symmetric Key Foundry Client KMIP v1.4",
		ProfileNameAdvancedSymmetricKeyFoundryClientKMIPV1_4:         "Advanced Symmetric Key Foundry Client KMIP v1.4",
		ProfileNameSymmetricKeyFoundryServerKMIPV1_4:                 "Symmetric Key Foundry Server KMIP v1.4",
		ProfileNameOpaqueManagedObjectStoreClientKMIPV1_4:            "Opaque Managed Object Store Client KMIP v1.4",
		ProfileNameOpaqueManagedObjectStoreServerKMIPV1_4:            "Opaque Managed Object Store Server KMIP v1.4",
		ProfileNameSuiteBMinLOS_128ClientKMIPV1_4:                    "Suite B minLOS_128 Client KMIP v1.4",
		ProfileNameSuiteBMinLOS_128ServerKMIPV1_4:                    "Suite B minLOS_128 Server KMIP v1.4",
		ProfileNameSuiteBMinLOS_192ClientKMIPV1_4:                    "Suite B minLOS_192 Client KMIP v1.4",
		ProfileNameSuiteBMinLOS_192ServerKMIPV1_4:                    "Suite B minLOS_192 Server KMIP v1.4",
		ProfileNameStorageArrayWithSelfEncryptingDriveClientKMIPV1_4: "Storage Array with Self Encrypting Drive Client KMIP v1.4",
		ProfileNameStorageArrayWithSelfEncryptingDriveServerKMIPV1_4: "Storage Array with Self Encrypting Drive Server KMIP v1.4",
		ProfileNameHTTPSClientKMIPV1_4:                               "HTTPS Client KMIP v1.4",
		ProfileNameHTTPSServerKMIPV1_4:                               "HTTPS Server KMIP v1.4",
		ProfileNameJSONClientKMIPV1_4:                                "JSON Client KMIP v1.4",
		ProfileNameJSONServerKMIPV1_4:                                "JSON Server KMIP v1.4",
		ProfileNameXMLClientKMIPV1_4:                                 "XML Client KMIP v1.4",
		ProfileNameXMLServerKMIPV1_4:                                 "XML Server KMIP v1.4",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (p ProfileName) MarshalText() (text []byte, err error) {
	return []byte(p.String()), nil
}

func (p ProfileName) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(p))
	return nil
}

func (p ProfileName) String() string {
	return ttlv.FormatEnum(uint32(p), &ProfileNameEnum)
}

// Unwrap Mode Enumeration
// 9.1.3.2.43
type UnwrapMode uint32

const (
	UnwrapModeUnspecified  UnwrapMode = 0x00000001
	UnwrapModeProcessed    UnwrapMode = 0x00000002
	UnwrapModeNotProcessed UnwrapMode = 0x00000003
)

var UnwrapModeEnum = NewUnwrapModeEnum()

func NewUnwrapModeEnum() ttlv.Enum {
	m := map[UnwrapMode]string{
		UnwrapModeUnspecified:  "Unspecified",
		UnwrapModeProcessed:    "Processed",
		UnwrapModeNotProcessed: "Not Processed",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (u UnwrapMode) MarshalText() (text []byte, err error) {
	return []byte(u.String()), nil
}

func (u UnwrapMode) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(u))
	return nil
}

func (u UnwrapMode) String() string {
	return ttlv.FormatEnum(uint32(u), &UnwrapModeEnum)
}

// Destroy Action Enumeration
// 9.1.3.2.44
type DestroyAction uint32

const (
	DestroyActionUnspecified         DestroyAction = 0x00000001
	DestroyActionKeyMaterialDeleted  DestroyAction = 0x00000002
	DestroyActionKeyMaterialShredded DestroyAction = 0x00000003
	DestroyActionMetaDataDeleted     DestroyAction = 0x00000004
	DestroyActionMetaDataShredded    DestroyAction = 0x00000005
	DestroyActionDeleted             DestroyAction = 0x00000006
	DestroyActionShredded            DestroyAction = 0x00000007
)

var DestroyActionEnum = NewDestroyActionEnum()

func NewDestroyActionEnum() ttlv.Enum {
	m := map[DestroyAction]string{
		DestroyActionUnspecified:         "Unspecified",
		DestroyActionKeyMaterialDeleted:  "Key Material Deleted",
		DestroyActionKeyMaterialShredded: "Key Material Shredded",
		DestroyActionMetaDataDeleted:     "Meta Data Deleted",
		DestroyActionMetaDataShredded:    "Meta Data Shredded",
		DestroyActionDeleted:             "Deleted",
		DestroyActionShredded:            "Shredded",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (d DestroyAction) MarshalText() (text []byte, err error) {
	return []byte(d.String()), nil
}

func (d DestroyAction) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(d))
	return nil
}

func (d DestroyAction) String() string {
	return ttlv.FormatEnum(uint32(d), &DestroyActionEnum)
}

// Shredding Algorithm Enumeration
// 9.1.3.2.45
type ShreddingAlgorithm uint32

const (
	ShreddingAlgorithmUnspecified   ShreddingAlgorithm = 0x00000001
	ShreddingAlgorithmCryptographic ShreddingAlgorithm = 0x00000002
	ShreddingAlgorithmUnsupported   ShreddingAlgorithm = 0x00000003
)

var ShreddingAlgorithmEnum = NewShreddingAlgorithmEnum()

func NewShreddingAlgorithmEnum() ttlv.Enum {
	m := map[ShreddingAlgorithm]string{
		ShreddingAlgorithmUnspecified:   "Unspecified",
		ShreddingAlgorithmCryptographic: "Cryptographic",
		ShreddingAlgorithmUnsupported:   "Unsupported",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (s ShreddingAlgorithm) MarshalText() (text []byte, err error) {
	return []byte(s.String()), nil
}

func (s ShreddingAlgorithm) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(s))
	return nil
}

func (s ShreddingAlgorithm) String() string {
	return ttlv.FormatEnum(uint32(s), &ShreddingAlgorithmEnum)
}

// RNG Mode Enumeration
// 9.1.3.2.46
type RNGMode uint32

const (
	RNGModeUnspecified            RNGMode = 0x00000001
	RNGModeSharedInstantiation    RNGMode = 0x00000002
	RNGModeNonSharedInstantiation RNGMode = 0x00000003
)

var RNGModeEnum = NewRNGModeEnum()

func NewRNGModeEnum() ttlv.Enum {
	m := map[RNGMode]string{
		RNGModeUnspecified:            "Unspecified",
		RNGModeSharedInstantiation:    "Shared Instantiation",
		RNGModeNonSharedInstantiation: "Non-Shared Instantiation",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (r RNGMode) MarshalText() (text []byte, err error) {
	return []byte(r.String()), nil
}

func (r RNGMode) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(r))
	return nil
}

func (r RNGMode) String() string {
	return ttlv.FormatEnum(uint32(r), &RNGModeEnum)
}

// Client Registration Method Enumeration
// 9.1.3.2.47
type ClientRegistrationMethod uint32

const (
	ClientRegistrationMethodUnspecified        ClientRegistrationMethod = 0x00000001
	ClientRegistrationMethodServerPreGenerated ClientRegistrationMethod = 0x00000002
	ClientRegistrationMethodServerOnDemand     ClientRegistrationMethod = 0x00000003
	ClientRegistrationMethodClientGenerated    ClientRegistrationMethod = 0x00000004
	ClientRegistrationMethodClientRegistered   ClientRegistrationMethod = 0x00000005
)

var ClientRegistrationMethodEnum = NewClientRegistrationMethodEnum()

func NewClientRegistrationMethodEnum() ttlv.Enum {
	m := map[ClientRegistrationMethod]string{
		ClientRegistrationMethodUnspecified:        "Unspecified",
		ClientRegistrationMethodServerPreGenerated: "Server Pre-Generated",
		ClientRegistrationMethodServerOnDemand:     "Server On-Demand",
		ClientRegistrationMethodClientGenerated:    "Client Generated",
		ClientRegistrationMethodClientRegistered:   "Client Registered",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (c ClientRegistrationMethod) MarshalText() (text []byte, err error) {
	return []byte(c.String()), nil
}

func (c ClientRegistrationMethod) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(c))
	return nil
}

func (c ClientRegistrationMethod) String() string {
	return ttlv.FormatEnum(uint32(c), &ClientRegistrationMethodEnum)
}

// Key Wrap Type Enumeration
// 9.1.3.2.48
type KeyWrapType uint32

const (
	KeyWrapTypeNotWrapped   KeyWrapType = 0x00000001
	KeyWrapTypeAsRegistered KeyWrapType = 0x00000002
)

var KeyWrapTypeEnum = NewKeyWrapTypeEnum()

func NewKeyWrapTypeEnum() ttlv.Enum {
	m := map[KeyWrapType]string{
		KeyWrapTypeNotWrapped:   "Not Wrapped",
		KeyWrapTypeAsRegistered: "As Registered",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (k KeyWrapType) MarshalText() (text []byte, err error) {
	return []byte(k.String()), nil
}

func (k KeyWrapType) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(k))
	return nil
}

func (k KeyWrapType) String() string {
	return ttlv.FormatEnum(uint32(k), &KeyWrapTypeEnum)
}

// Mask Generator Enumeration
// 9.1.3.2.49
type MaskGenerator uint32

const (
	MaskGeneratorMGF1 MaskGenerator = 0x00000001
)

var MaskGeneratorEnum = NewMaskGeneratorEnum()

func NewMaskGeneratorEnum() ttlv.Enum {
	m := map[MaskGenerator]string{
		MaskGeneratorMGF1: "MGF1",
	}

	e := ttlv.NewEnum()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (m MaskGenerator) MarshalText() (text []byte, err error) {
	return []byte(m.String()), nil
}

func (m MaskGenerator) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeEnumeration(tag, uint32(m))
	return nil
}

func (m MaskGenerator) String() string {
	return ttlv.FormatEnum(uint32(m), &MaskGeneratorEnum)
}

// Cryptographic Usage Mask Bit Mask
// 9.1.3.3.1
type CryptographicUsageMask uint32

const (
	CryptographicUsageMaskSign               CryptographicUsageMask = 0x00000001
	CryptographicUsageMaskVerify             CryptographicUsageMask = 0x00000002
	CryptographicUsageMaskEncrypt            CryptographicUsageMask = 0x00000004
	CryptographicUsageMaskDecrypt            CryptographicUsageMask = 0x00000008
	CryptographicUsageMaskWrapKey            CryptographicUsageMask = 0x00000010
	CryptographicUsageMaskUnwrapKey          CryptographicUsageMask = 0x00000020
	CryptographicUsageMaskExport             CryptographicUsageMask = 0x00000040
	CryptographicUsageMaskMACGenerate        CryptographicUsageMask = 0x00000080
	CryptographicUsageMaskMACVerify          CryptographicUsageMask = 0x00000100
	CryptographicUsageMaskDeriveKey          CryptographicUsageMask = 0x00000200
	CryptographicUsageMaskContentCommitment  CryptographicUsageMask = 0x00000400
	CryptographicUsageMaskKeyAgreement       CryptographicUsageMask = 0x00000800
	CryptographicUsageMaskCertificateSign    CryptographicUsageMask = 0x00001000
	CryptographicUsageMaskCRLSign            CryptographicUsageMask = 0x00002000
	CryptographicUsageMaskGenerateCryptogram CryptographicUsageMask = 0x00004000
	CryptographicUsageMaskValidateCryptogram CryptographicUsageMask = 0x00008000
	CryptographicUsageMaskTranslateEncrypt   CryptographicUsageMask = 0x00010000
	CryptographicUsageMaskTranslateDecrypt   CryptographicUsageMask = 0x00020000
	CryptographicUsageMaskTranslateWrap      CryptographicUsageMask = 0x00040000
	CryptographicUsageMaskTranslateUnwrap    CryptographicUsageMask = 0x00080000
)

var CryptographicUsageMaskEnum = NewCryptographicUsageMaskEnum()

func NewCryptographicUsageMaskEnum() ttlv.Enum {
	m := map[CryptographicUsageMask]string{
		CryptographicUsageMaskSign:               "Sign",
		CryptographicUsageMaskVerify:             "Verify",
		CryptographicUsageMaskEncrypt:            "Encrypt",
		CryptographicUsageMaskDecrypt:            "Decrypt",
		CryptographicUsageMaskWrapKey:            "Wrap Key",
		CryptographicUsageMaskUnwrapKey:          "Unwrap Key",
		CryptographicUsageMaskExport:             "Export",
		CryptographicUsageMaskMACGenerate:        "MAC Generate",
		CryptographicUsageMaskMACVerify:          "MAC Verify",
		CryptographicUsageMaskDeriveKey:          "Derive Key",
		CryptographicUsageMaskContentCommitment:  "Content Commitment",
		CryptographicUsageMaskKeyAgreement:       "Key Agreement",
		CryptographicUsageMaskCertificateSign:    "Certificate Sign",
		CryptographicUsageMaskCRLSign:            "CRL Sign",
		CryptographicUsageMaskGenerateCryptogram: "Generate Cryptogram",
		CryptographicUsageMaskValidateCryptogram: "Validate Cryptogram",
		CryptographicUsageMaskTranslateEncrypt:   "Translate Encrypt",
		CryptographicUsageMaskTranslateDecrypt:   "Translate Decrypt",
		CryptographicUsageMaskTranslateWrap:      "Translate Wrap",
		CryptographicUsageMaskTranslateUnwrap:    "Translate Unwrap",
	}

	e := ttlv.NewBitmask()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (c CryptographicUsageMask) MarshalText() (text []byte, err error) {
	return []byte(c.String()), nil
}

func (c CryptographicUsageMask) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeInteger(tag, int32(c))
	return nil
}

func (c CryptographicUsageMask) String() string {
	return ttlv.FormatInt(int32(c), &CryptographicUsageMaskEnum)
}

// Storage Status Mask Bit Mask
// 9.1.3.3.2
type StorageStatusMask uint32

const (
	StorageStatusMaskOnLineStorage   StorageStatusMask = 0x00000001
	StorageStatusMaskArchivalStorage StorageStatusMask = 0x00000002
)

var StorageStatusMaskEnum = NewStorageStatusMaskEnum()

func NewStorageStatusMaskEnum() ttlv.Enum {
	m := map[StorageStatusMask]string{
		StorageStatusMaskOnLineStorage:   "On-line storage",
		StorageStatusMaskArchivalStorage: "Archival storage",
	}

	e := ttlv.NewBitmask()
	for v, name := range m {
		e.RegisterValue(uint32(v), name)
	}

	return e
}

func (s StorageStatusMask) MarshalText() (text []byte, err error) {
	return []byte(s.String()), nil
}

func (s StorageStatusMask) MarshalTTLV(enc *ttlv.Encoder, tag ttlv.Tag) error {
	enc.EncodeInteger(tag, int32(s))
	return nil
}

func (s StorageStatusMask) String() string {
	return ttlv.FormatInt(int32(s), &StorageStatusMaskEnum)
}

func RegisterGeneratedDefinitions(r *ttlv.Registry) {

	tags := map[ttlv.Tag]string{
		TagActivationDate:                        "Activation Date",
		TagApplicationData:                       "Application Data",
		TagApplicationNamespace:                  "Application Namespace",
		TagApplicationSpecificInformation:        "Application Specific Information",
		TagArchiveDate:                           "Archive Date",
		TagAsynchronousCorrelationValue:          "Asynchronous Correlation Value",
		TagAsynchronousIndicator:                 "Asynchronous Indicator",
		TagAttribute:                             "Attribute",
		TagAttributeIndex:                        "Attribute Index",
		TagAttributeName:                         "Attribute Name",
		TagAttributeValue:                        "Attribute Value",
		TagAuthentication:                        "Authentication",
		TagBatchCount:                            "Batch Count",
		TagBatchErrorContinuationOption:          "Batch Error Continuation Option",
		TagBatchItem:                             "Batch Item",
		TagBatchOrderOption:                      "Batch Order Option",
		TagBlockCipherMode:                       "Block Cipher Mode",
		TagCancellationResult:                    "Cancellation Result",
		TagCertificate:                           "Certificate",
		TagCertificateIdentifier:                 "Certificate Identifier",
		TagCertificateIssuer:                     "Certificate Issuer",
		TagCertificateIssuerAlternativeName:      "Certificate Issuer Alternative Name",
		TagCertificateIssuerDistinguishedName:    "Certificate Issuer Distinguished Name",
		TagCertificateRequest:                    "Certificate Request",
		TagCertificateRequestType:                "Certificate Request Type",
		TagCertificateSubject:                    "Certificate Subject",
		TagCertificateSubjectAlternativeName:     "Certificate Subject Alternative Name",
		TagCertificateSubjectDistinguishedName:   "Certificate Subject Distinguished Name",
		TagCertificateType:                       "Certificate Type",
		TagCertificateValue:                      "Certificate Value",
		TagCommonTemplateAttribute:               "Common Template-Attribute",
		TagCompromiseDate:                        "Compromise  Date",
		TagCompromiseOccurrenceDate:              "Compromise Occurrence Date",
		TagContactInformation:                    "Contact Information",
		TagCredential:                            "Credential",
		TagCredentialType:                        "Credential Type",
		TagCredentialValue:                       "Credential Value",
		TagCriticalityIndicator:                  "Criticality Indicator",
		TagCRTCoefficient:                        "CRT Coefficient",
		TagCryptographicAlgorithm:                "Cryptographic Algorithm",
		TagCryptographicDomainParameters:         "Cryptographic Domain Parameters",
		TagCryptographicLength:                   "Cryptographic Length",
		TagCryptographicParameters:               "Cryptographic Parameters",
		TagCryptographicUsageMask:                "Cryptographic Usage Mask",
		TagCustomAttribute:                       "Custom Attribute",
		TagD:                                     "D",
		TagDeactivationDate:                      "Deactivation Date",
		TagDerivationData:                        "Derivation Data",
		TagDerivationMethod:                      "Derivation Method",
		TagDerivationParameters:                  "Derivation Parameters",
		TagDestroyDate:                           "Destroy Date",
		TagDigest:                                "Digest",
		TagDigestValue:                           "Digest Value",
		TagEncryptionKeyInformation:              "Encryption Key Information",
		TagG:                                     "G",
		TagHashingAlgorithm:                      "Hashing Algorithm",
		TagInitialDate:                           "Initial Date",
		TagInitializationVector:                  "Initialization Vector",
		TagIssuer:                                "Issuer",
		TagIterationCount:                        "Iteration Count",
		TagIVCounterNonce:                        "IV/Counter/Nonce",
		TagJ:                                     "J",
		TagKey:                                   "Key",
		TagKeyBlock:                              "Key Block",
		TagKeyCompressionType:                    "Key Compression Type",
		TagKeyFormatType:                         "Key Format Type",
		TagKeyMaterial:                           "Key Material",
		TagKeyPartIdentifier:                     "Key Part Identifier",
		TagKeyValue:                              "Key Value",
		TagKeyWrappingData:                       "Key Wrapping Data",
		TagKeyWrappingSpecification:              "Key Wrapping Specification",
		TagLastChangeDate:                        "Last Change Date",
		TagLeaseTime:                             "Lease Time",
		TagLink:                                  "Link",
		TagLinkType:                              "Link Type",
		TagLinkedObjectIdentifier:                "Linked Object Identifier",
		TagMACSignature:                          "MAC/Signature",
		TagMACSignatureKeyInformation:            "MAC/Signature Key Information",
		TagMaximumItems:                          "Maximum Items",
		TagMaximumResponseSize:                   "Maximum Response Size",
		TagMessageExtension:                      "Message Extension",
		TagModulus:                               "Modulus",
		TagName:                                  "Name",
		TagNameType:                              "Name Type",
		TagNameValue:                             "Name Value",
		TagObjectGroup:                           "Object Group",
		TagObjectType:                            "Object Type",
		TagOffset:                                "Offset",
		TagOpaqueDataType:                        "Opaque Data Type",
		TagOpaqueDataValue:                       "Opaque Data Value",
		TagOpaqueObject:                          "Opaque Object",
		TagOperation:                             "Operation",
		TagOperationPolicyName:                   "Operation Policy Name",
		TagP:                                     "P",
		TagPaddingMethod:                         "Padding Method",
		TagPrimeExponentP:                        "Prime Exponent P",
		TagPrimeExponentQ:                        "Prime Exponent Q",
		TagPrimeFieldSize:                        "Prime Field Size",
		TagPrivateExponent:                       "Private Exponent",
		TagPrivateKey:                            "Private Key",
		TagPrivateKeyTemplateAttribute:           "Private Key Template-Attribute",
		TagPrivateKeyUniqueIdentifier:            "Private Key Unique Identifier",
		TagProcessStartDate:                      "Process Start Date",
		TagProtectStopDate:                       "Protect Stop Date",
		TagProtocolVersion:                       "Protocol Version",
		TagProtocolVersionMajor:                  "Protocol Version Major",
		TagProtocolVersionMinor:                  "Protocol Version Minor",
		TagPublicExponent:                        "Public Exponent",
		TagPublicKey:                             "Public Key",
		TagPublicKeyTemplateAttribute:            "Public Key Template-Attribute",
		TagPublicKeyUniqueIdentifier:             "Public Key Unique Identifier",
		TagPutFunction:                           "Put Function",
		TagQ:                                     "Q",
		TagQString:                               "Q String",
		TagQlength:                               "Qlength",
		TagQueryFunction:                         "Query Function",
		TagRecommendedCurve:                      "Recommended Curve",
		TagReplacedUniqueIdentifier:              "Replaced Unique Identifier",
		TagRequestHeader:                         "Request Header",
		TagRequestMessage:                        "Request Message",
		TagRequestPayload:                        "Request Payload",
		TagResponseHeader:                        "Response Header",
		TagResponseMessage:                       "Response Message",
		TagResponsePayload:                       "Response Payload",
		TagResultMessage:                         "Result Message",
		TagResultReason:                          "Result Reason",
		TagResultStatus:                          "Result Status",
		TagRevocationMessage:                     "Revocation Message",
		TagRevocationReason:                      "Revocation Reason",
		TagRevocationReasonCode:                  "Revocation Reason Code",
		TagKeyRoleType:                           "Key Role Type",
		TagSalt:                                  "Salt",
		TagSecretData:                            "Secret Data",
		TagSecretDataType:                        "Secret Data Type",
		TagSerialNumber:                          "Serial Number",
		TagServerInformation:                     "Server Information",
		TagSplitKey:                              "Split Key",
		TagSplitKeyMethod:                        "Split Key Method",
		TagSplitKeyParts:                         "Split Key Parts",
		TagSplitKeyThreshold:                     "Split Key Threshold",
		TagState:                                 "State",
		TagStorageStatusMask:                     "Storage Status Mask",
		TagSymmetricKey:                          "Symmetric Key",
		TagTemplate:                              "Template",
		TagTemplateAttribute:                     "Template-Attribute",
		TagTimeStamp:                             "Time Stamp",
		TagUniqueBatchItemID:                     "Unique Batch Item ID",
		TagUniqueIdentifier:                      "Unique Identifier",
		TagUsageLimits:                           "Usage Limits",
		TagUsageLimitsCount:                      "Usage Limits Count",
		TagUsageLimitsTotal:                      "Usage Limits Total",
		TagUsageLimitsUnit:                       "Usage Limits Unit",
		TagUsername:                              "Username",
		TagValidityDate:                          "Validity Date",
		TagValidityIndicator:                     "Validity Indicator",
		TagVendorExtension:                       "Vendor Extension",
		TagVendorIdentification:                  "Vendor Identification",
		TagWrappingMethod:                        "Wrapping Method",
		TagX:                                     "X",
		TagY:                                     "Y",
		TagPassword:                              "Password",
		TagDeviceIdentifier:                      "Device Identifier",
		TagEncodingOption:                        "Encoding Option",
		TagExtensionInformation:                  "Extension Information",
		TagExtensionName:                         "Extension Name",
		TagExtensionTag:                          "Extension Tag",
		TagExtensionType:                         "Extension Type",
		TagFresh:                                 "Fresh",
		TagMachineIdentifier:                     "Machine Identifier",
		TagMediaIdentifier:                       "Media Identifier",
		TagNetworkIdentifier:                     "Network Identifier",
		TagObjectGroupMember:                     "Object Group Member",
		TagCertificateLength:                     "Certificate Length",
		TagDigitalSignatureAlgorithm:             "Digital Signature Algorithm",
		TagCertificateSerialNumber:               "Certificate Serial Number",
		TagDeviceSerialNumber:                    "Device Serial Number",
		TagIssuerAlternativeName:                 "Issuer Alternative Name",
		TagIssuerDistinguishedName:               "Issuer Distinguished Name",
		TagSubjectAlternativeName:                "Subject Alternative Name",
		TagSubjectDistinguishedName:              "Subject Distinguished Name",
		TagX_509CertificateIdentifier:            "X.509 Certificate Identifier",
		TagX_509CertificateIssuer:                "X.509 Certificate Issuer",
		TagX_509CertificateSubject:               "X.509 Certificate Subject",
		TagKeyValueLocation:                      "Key Value Location",
		TagKeyValueLocationValue:                 "Key Value Location Value",
		TagKeyValueLocationType:                  "Key Value Location Type",
		TagKeyValuePresent:                       "Key Value Present",
		TagOriginalCreationDate:                  "Original Creation Date",
		TagPGPKey:                                "PGP Key",
		TagPGPKeyVersion:                         "PGP Key Version",
		TagAlternativeName:                       "Alternative Name",
		TagAlternativeNameValue:                  "Alternative Name Value",
		TagAlternativeNameType:                   "Alternative Name Type",
		TagData:                                  "Data",
		TagSignatureData:                         "Signature Data",
		TagDataLength:                            "Data Length",
		TagRandomIV:                              "Random IV",
		TagMACData:                               "MAC Data",
		TagAttestationType:                       "Attestation Type",
		TagNonce:                                 "Nonce",
		TagNonceID:                               "Nonce ID",
		TagNonceValue:                            "Nonce Value",
		TagAttestationMeasurement:                "Attestation Measurement",
		TagAttestationAssertion:                  "Attestation Assertion",
		TagIVLength:                              "IV Length",
		TagTagLength:                             "Tag Length",
		TagFixedFieldLength:                      "Fixed Field Length",
		TagCounterLength:                         "Counter Length",
		TagInitialCounterValue:                   "Initial Counter Value",
		TagInvocationFieldLength:                 "Invocation Field Length",
		TagAttestationCapableIndicator:           "Attestation Capable Indicator",
		TagOffsetItems:                           "Offset Items",
		TagLocatedItems:                          "Located Items",
		TagCorrelationValue:                      "Correlation Value",
		TagInitIndicator:                         "Init Indicator",
		TagFinalIndicator:                        "Final Indicator",
		TagRNGParameters:                         "RNG Parameters",
		TagRNGAlgorithm:                          "RNG Algorithm",
		TagDRBGAlgorithm:                         "DRBG Algorithm",
		TagFIPS186Variation:                      "FIPS186 Variation",
		TagPredictionResistance:                  "Prediction Resistance",
		TagRandomNumberGenerator:                 "Random Number Generator",
		TagValidationInformation:                 "Validation Information",
		TagValidationAuthorityType:               "Validation Authority Type",
		TagValidationAuthorityCountry:            "Validation Authority Country",
		TagValidationAuthorityURI:                "Validation Authority URI",
		TagValidationVersionMajor:                "Validation Version Major",
		TagValidationVersionMinor:                "Validation Version Minor",
		TagValidationType:                        "Validation Type",
		TagValidationLevel:                       "Validation Level",
		TagValidationCertificateIdentifier:       "Validation Certificate Identifier",
		TagValidationCertificateURI:              "Validation Certificate URI",
		TagValidationVendorURI:                   "Validation Vendor URI",
		TagValidationProfile:                     "Validation Profile",
		TagProfileInformation:                    "Profile Information",
		TagProfileName:                           "Profile Name",
		TagServerURI:                             "Server URI",
		TagServerPort:                            "Server Port",
		TagStreamingCapability:                   "Streaming Capability",
		TagAsynchronousCapability:                "Asynchronous Capability",
		TagAttestationCapability:                 "Attestation Capability",
		TagUnwrapMode:                            "Unwrap Mode",
		TagDestroyAction:                         "Destroy Action",
		TagShreddingAlgorithm:                    "Shredding Algorithm",
		TagRNGMode:                               "RNG Mode",
		TagClientRegistrationMethod:              "Client Registration Method",
		TagCapabilityInformation:                 "Capability Information",
		TagKeyWrapType:                           "Key Wrap Type",
		TagBatchUndoCapability:                   "Batch Undo Capability",
		TagBatchContinueCapability:               "Batch Continue Capability",
		TagPKCS_12FriendlyName:                   "PKCS#12 Friendly Name",
		TagDescription:                           "Description",
		TagComment:                               "Comment",
		TagAuthenticatedEncryptionAdditionalData: "Authenticated Encryption Additional Data",
		TagAuthenticatedEncryptionTag:            "Authenticated Encryption Tag",
		TagSaltLength:                            "Salt Length",
		TagMaskGenerator:                         "Mask Generator",
		TagMaskGeneratorHashingAlgorithm:         "Mask Generator Hashing Algorithm",
		TagPSource:                               "P Source",
		TagTrailerField:                          "Trailer Field",
		TagClientCorrelationValue:                "Client Correlation Value",
		TagServerCorrelationValue:                "Server Correlation Value",
		TagDigestedData:                          "Digested Data",
		TagCertificateSubjectCN:                  "Certificate Subject CN",
		TagCertificateSubjectO:                   "Certificate Subject O",
		TagCertificateSubjectOU:                  "Certificate Subject OU",
		TagCertificateSubjectEmail:               "Certificate Subject Email",
		TagCertificateSubjectC:                   "Certificate Subject C",
		TagCertificateSubjectST:                  "Certificate Subject ST",
		TagCertificateSubjectL:                   "Certificate Subject L",
		TagCertificateSubjectUID:                 "Certificate Subject UID",
		TagCertificateSubjectSerialNumber:        "Certificate Subject Serial Number",
		TagCertificateSubjectTitle:               "Certificate Subject Title",
		TagCertificateSubjectDC:                  "Certificate Subject DC",
		TagCertificateSubjectDNQualifier:         "Certificate Subject DN Qualifier",
		TagCertificateIssuerCN:                   "Certificate Issuer CN",
		TagCertificateIssuerO:                    "Certificate Issuer O",
		TagCertificateIssuerOU:                   "Certificate Issuer OU",
		TagCertificateIssuerEmail:                "Certificate Issuer Email",
		TagCertificateIssuerC:                    "Certificate Issuer C",
		TagCertificateIssuerST:                   "Certificate Issuer ST",
		TagCertificateIssuerL:                    "Certificate Issuer L",
		TagCertificateIssuerUID:                  "Certificate Issuer UID",
		TagCertificateIssuerSerialNumber:         "Certificate Issuer Serial Number",
		TagCertificateIssuerTitle:                "Certificate Issuer Title",
		TagCertificateIssuerDC:                   "Certificate Issuer DC",
		TagCertificateIssuerDNQualifier:          "Certificate Issuer DN Qualifier",
		TagSensitive:                             "Sensitive",
		TagAlwaysSensitive:                       "Always Sensitive",
		TagExtractable:                           "Extractable",
		TagNeverExtractable:                      "Never Extractable",
		TagReplaceExisting:                       "Replace Existing",
	}

	for v, name := range tags {
		r.RegisterTag(v, name)
	}

	enums := map[string]ttlv.Enum{
		"CredentialType":                CredentialTypeEnum,
		"KeyCompressionType":            KeyCompressionTypeEnum,
		"KeyFormatType":                 KeyFormatTypeEnum,
		"WrappingMethod":                WrappingMethodEnum,
		"RecommendedCurve":              RecommendedCurveEnum,
		"CertificateType":               CertificateTypeEnum,
		"DigitalSignatureAlgorithm":     DigitalSignatureAlgorithmEnum,
		"SplitKeyMethod":                SplitKeyMethodEnum,
		"SecretDataType":                SecretDataTypeEnum,
		"OpaqueDataType":                OpaqueDataTypeEnum,
		"NameType":                      NameTypeEnum,
		"ObjectType":                    ObjectTypeEnum,
		"CryptographicAlgorithm":        CryptographicAlgorithmEnum,
		"BlockCipherMode":               BlockCipherModeEnum,
		"PaddingMethod":                 PaddingMethodEnum,
		"HashingAlgorithm":              HashingAlgorithmEnum,
		"MaskGeneratorHashingAlgorithm": HashingAlgorithmEnum,
		"KeyRoleType":                   KeyRoleTypeEnum,
		"State":                         StateEnum,
		"RevocationReasonCode":          RevocationReasonCodeEnum,
		"LinkType":                      LinkTypeEnum,
		"DerivationMethod":              DerivationMethodEnum,
		"CertificateRequestType":        CertificateRequestTypeEnum,
		"ValidityIndicator":             ValidityIndicatorEnum,
		"QueryFunction":                 QueryFunctionEnum,
		"CancellationResult":            CancellationResultEnum,
		"PutFunction":                   PutFunctionEnum,
		"Operation":                     OperationEnum,
		"ResultStatus":                  ResultStatusEnum,
		"ResultReason":                  ResultReasonEnum,
		"BatchErrorContinuationOption":  BatchErrorContinuationOptionEnum,
		"UsageLimitsUnit":               UsageLimitsUnitEnum,
		"EncodingOption":                EncodingOptionEnum,
		"ObjectGroupMember":             ObjectGroupMemberEnum,
		"AlternativeNameType":           AlternativeNameTypeEnum,
		"KeyValueLocationType":          KeyValueLocationTypeEnum,
		"AttestationType":               AttestationTypeEnum,
		"RNGAlgorithm":                  RNGAlgorithmEnum,
		"DRBGAlgorithm":                 DRBGAlgorithmEnum,
		"FIPS186Variation":              FIPS186VariationEnum,
		"ValidationAuthorityType":       ValidationAuthorityTypeEnum,
		"ValidationType":                ValidationTypeEnum,
		"ProfileName":                   ProfileNameEnum,
		"UnwrapMode":                    UnwrapModeEnum,
		"DestroyAction":                 DestroyActionEnum,
		"ShreddingAlgorithm":            ShreddingAlgorithmEnum,
		"RNGMode":                       RNGModeEnum,
		"ClientRegistrationMethod":      ClientRegistrationMethodEnum,
		"KeyWrapType":                   KeyWrapTypeEnum,
		"MaskGenerator":                 MaskGeneratorEnum,

		"CryptographicUsageMask": CryptographicUsageMaskEnum,
		"StorageStatusMask":      StorageStatusMaskEnum,
	}

	for tagName, enum := range enums {
		tag, err := ttlv.DefaultRegistry.ParseTag(tagName)
		if err != nil {
			panic(err)
		}
		e := enum
		r.RegisterEnum(tag, &e)
	}
}
