/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * An [ImportJob][google.cloud.kms.v1.ImportJob] can be used to create [CryptoKeys][google.cloud.kms.v1.CryptoKey] and
 * [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] using pre-existing key material,
 * generated outside of Cloud KMS.
 * When an [ImportJob][google.cloud.kms.v1.ImportJob] is created, Cloud KMS will generate a "wrapping key",
 * which is a public/private key pair. You use the wrapping key to encrypt (also
 * known as wrap) the pre-existing key material to protect it during the import
 * process. The nature of the wrapping key depends on the choice of
 * [import_method][google.cloud.kms.v1.ImportJob.import_method]. When the wrapping key generation
 * is complete, the [state][google.cloud.kms.v1.ImportJob.state] will be set to
 * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE] and the [public_key][google.cloud.kms.v1.ImportJob.public_key]
 * can be fetched. The fetched public key can then be used to wrap your
 * pre-existing key material.
 * Once the key material is wrapped, it can be imported into a new
 * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in an existing [CryptoKey][google.cloud.kms.v1.CryptoKey] by calling
 * [ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
 * Multiple [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] can be imported with a single
 * [ImportJob][google.cloud.kms.v1.ImportJob]. Cloud KMS uses the private key portion of the wrapping key to
 * unwrap the key material. Only Cloud KMS has access to the private key.
 * An [ImportJob][google.cloud.kms.v1.ImportJob] expires 3 days after it is created. Once expired, Cloud KMS
 * will no longer be able to import or unwrap any key material that was wrapped
 * with the [ImportJob][google.cloud.kms.v1.ImportJob]'s public key.
 * For more information, see
 * [Importing a key](https://cloud.google.com/kms/docs/importing-a-key).
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.ImportJob}
 */
public final class ImportJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.ImportJob)
    ImportJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportJob.newBuilder() to construct.
  private ImportJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportJob() {
    name_ = "";
    importMethod_ = 0;
    protectionLevel_ = 0;
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportJob();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImportJob(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              importMethod_ = rawValue;
              break;
            }
          case 26:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (generateTime_ != null) {
                subBuilder = generateTime_.toBuilder();
              }
              generateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(generateTime_);
                generateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (expireTime_ != null) {
                subBuilder = expireTime_.toBuilder();
              }
              expireTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(expireTime_);
                expireTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 58:
            {
              com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.Builder subBuilder = null;
              if (publicKey_ != null) {
                subBuilder = publicKey_.toBuilder();
              }
              publicKey_ =
                  input.readMessage(
                      com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(publicKey_);
                publicKey_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.cloud.kms.v1.KeyOperationAttestation.Builder subBuilder = null;
              if (attestation_ != null) {
                subBuilder = attestation_.toBuilder();
              }
              attestation_ =
                  input.readMessage(
                      com.google.cloud.kms.v1.KeyOperationAttestation.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(attestation_);
                attestation_ = subBuilder.buildPartial();
              }

              break;
            }
          case 72:
            {
              int rawValue = input.readEnum();

              protectionLevel_ = rawValue;
              break;
            }
          case 82:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (expireEventTime_ != null) {
                subBuilder = expireEventTime_.toBuilder();
              }
              expireEventTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(expireEventTime_);
                expireEventTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_ImportJob_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_ImportJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.ImportJob.class,
            com.google.cloud.kms.v1.ImportJob.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] describes the key wrapping method chosen for this
   * [ImportJob][google.cloud.kms.v1.ImportJob].
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.ImportJob.ImportMethod}
   */
  public enum ImportMethod implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>IMPORT_METHOD_UNSPECIFIED = 0;</code>
     */
    IMPORT_METHOD_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
     * scheme defined in the PKCS #11 standard. In summary, this involves
     * wrapping the raw key with an ephemeral AES key, and wrapping the
     * ephemeral AES key with a 3072 bit RSA key. For more details, see
     * [RSA AES key wrap
     * mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
     * </pre>
     *
     * <code>RSA_OAEP_3072_SHA1_AES_256 = 1;</code>
     */
    RSA_OAEP_3072_SHA1_AES_256(1),
    /**
     *
     *
     * <pre>
     * This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
     * scheme defined in the PKCS #11 standard. In summary, this involves
     * wrapping the raw key with an ephemeral AES key, and wrapping the
     * ephemeral AES key with a 4096 bit RSA key. For more details, see
     * [RSA AES key wrap
     * mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
     * </pre>
     *
     * <code>RSA_OAEP_4096_SHA1_AES_256 = 2;</code>
     */
    RSA_OAEP_4096_SHA1_AES_256(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>IMPORT_METHOD_UNSPECIFIED = 0;</code>
     */
    public static final int IMPORT_METHOD_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
     * scheme defined in the PKCS #11 standard. In summary, this involves
     * wrapping the raw key with an ephemeral AES key, and wrapping the
     * ephemeral AES key with a 3072 bit RSA key. For more details, see
     * [RSA AES key wrap
     * mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
     * </pre>
     *
     * <code>RSA_OAEP_3072_SHA1_AES_256 = 1;</code>
     */
    public static final int RSA_OAEP_3072_SHA1_AES_256_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
     * scheme defined in the PKCS #11 standard. In summary, this involves
     * wrapping the raw key with an ephemeral AES key, and wrapping the
     * ephemeral AES key with a 4096 bit RSA key. For more details, see
     * [RSA AES key wrap
     * mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
     * </pre>
     *
     * <code>RSA_OAEP_4096_SHA1_AES_256 = 2;</code>
     */
    public static final int RSA_OAEP_4096_SHA1_AES_256_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImportMethod valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ImportMethod forNumber(int value) {
      switch (value) {
        case 0:
          return IMPORT_METHOD_UNSPECIFIED;
        case 1:
          return RSA_OAEP_3072_SHA1_AES_256;
        case 2:
          return RSA_OAEP_4096_SHA1_AES_256;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ImportMethod> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ImportMethod> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ImportMethod>() {
          public ImportMethod findValueByNumber(int number) {
            return ImportMethod.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.ImportJob.getDescriptor().getEnumTypes().get(0);
    }

    private static final ImportMethod[] VALUES = values();

    public static ImportMethod valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ImportMethod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.ImportJob.ImportMethod)
  }

  /**
   *
   *
   * <pre>
   * The state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if it can be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.ImportJob.ImportJobState}
   */
  public enum ImportJobState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_UNSPECIFIED = 0;</code>
     */
    IMPORT_JOB_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The wrapping key for this job is still being generated. It may not be
     * used. Cloud KMS will automatically mark this job as
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE] as soon as the wrapping key is generated.
     * </pre>
     *
     * <code>PENDING_GENERATION = 1;</code>
     */
    PENDING_GENERATION(1),
    /**
     *
     *
     * <pre>
     * This job may be used in
     * [CreateCryptoKey][google.cloud.kms.v1.KeyManagementService.CreateCryptoKey] and
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * requests.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * This job can no longer be used and may not leave this state once entered.
     * </pre>
     *
     * <code>EXPIRED = 3;</code>
     */
    EXPIRED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>IMPORT_JOB_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int IMPORT_JOB_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The wrapping key for this job is still being generated. It may not be
     * used. Cloud KMS will automatically mark this job as
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE] as soon as the wrapping key is generated.
     * </pre>
     *
     * <code>PENDING_GENERATION = 1;</code>
     */
    public static final int PENDING_GENERATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This job may be used in
     * [CreateCryptoKey][google.cloud.kms.v1.KeyManagementService.CreateCryptoKey] and
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * requests.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This job can no longer be used and may not leave this state once entered.
     * </pre>
     *
     * <code>EXPIRED = 3;</code>
     */
    public static final int EXPIRED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImportJobState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ImportJobState forNumber(int value) {
      switch (value) {
        case 0:
          return IMPORT_JOB_STATE_UNSPECIFIED;
        case 1:
          return PENDING_GENERATION;
        case 2:
          return ACTIVE;
        case 3:
          return EXPIRED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ImportJobState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ImportJobState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ImportJobState>() {
          public ImportJobState findValueByNumber(int number) {
            return ImportJobState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.ImportJob.getDescriptor().getEnumTypes().get(1);
    }

    private static final ImportJobState[] VALUES = values();

    public static ImportJobState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ImportJobState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.ImportJob.ImportJobState)
  }

  public interface WrappingPublicKeyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.ImportJob.WrappingPublicKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The public key, encoded in PEM format. For more information, see the [RFC
     * 7468](https://tools.ietf.org/html/rfc7468) sections for [General
     * Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
     * [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13).
     * </pre>
     *
     * <code>string pem = 1;</code>
     *
     * @return The pem.
     */
    java.lang.String getPem();
    /**
     *
     *
     * <pre>
     * The public key, encoded in PEM format. For more information, see the [RFC
     * 7468](https://tools.ietf.org/html/rfc7468) sections for [General
     * Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
     * [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13).
     * </pre>
     *
     * <code>string pem = 1;</code>
     *
     * @return The bytes for pem.
     */
    com.google.protobuf.ByteString getPemBytes();
  }
  /**
   *
   *
   * <pre>
   * The public key component of the wrapping key. For details of the type of
   * key this public key corresponds to, see the [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.ImportJob.WrappingPublicKey}
   */
  public static final class WrappingPublicKey extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.ImportJob.WrappingPublicKey)
      WrappingPublicKeyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WrappingPublicKey.newBuilder() to construct.
    private WrappingPublicKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WrappingPublicKey() {
      pem_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WrappingPublicKey();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private WrappingPublicKey(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                pem_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_ImportJob_WrappingPublicKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_ImportJob_WrappingPublicKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.class,
              com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.Builder.class);
    }

    public static final int PEM_FIELD_NUMBER = 1;
    private volatile java.lang.Object pem_;
    /**
     *
     *
     * <pre>
     * The public key, encoded in PEM format. For more information, see the [RFC
     * 7468](https://tools.ietf.org/html/rfc7468) sections for [General
     * Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
     * [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13).
     * </pre>
     *
     * <code>string pem = 1;</code>
     *
     * @return The pem.
     */
    @java.lang.Override
    public java.lang.String getPem() {
      java.lang.Object ref = pem_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pem_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The public key, encoded in PEM format. For more information, see the [RFC
     * 7468](https://tools.ietf.org/html/rfc7468) sections for [General
     * Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
     * [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13).
     * </pre>
     *
     * <code>string pem = 1;</code>
     *
     * @return The bytes for pem.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPemBytes() {
      java.lang.Object ref = pem_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pem_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getPemBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pem_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getPemBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pem_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.kms.v1.ImportJob.WrappingPublicKey)) {
        return super.equals(obj);
      }
      com.google.cloud.kms.v1.ImportJob.WrappingPublicKey other =
          (com.google.cloud.kms.v1.ImportJob.WrappingPublicKey) obj;

      if (!getPem().equals(other.getPem())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PEM_FIELD_NUMBER;
      hash = (53 * hash) + getPem().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.kms.v1.ImportJob.WrappingPublicKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The public key component of the wrapping key. For details of the type of
     * key this public key corresponds to, see the [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod].
     * </pre>
     *
     * Protobuf type {@code google.cloud.kms.v1.ImportJob.WrappingPublicKey}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.ImportJob.WrappingPublicKey)
        com.google.cloud.kms.v1.ImportJob.WrappingPublicKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.kms.v1.KmsResourcesProto
            .internal_static_google_cloud_kms_v1_ImportJob_WrappingPublicKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.kms.v1.KmsResourcesProto
            .internal_static_google_cloud_kms_v1_ImportJob_WrappingPublicKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.class,
                com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.Builder.class);
      }

      // Construct using com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        pem_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.kms.v1.KmsResourcesProto
            .internal_static_google_cloud_kms_v1_ImportJob_WrappingPublicKey_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.kms.v1.ImportJob.WrappingPublicKey getDefaultInstanceForType() {
        return com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.kms.v1.ImportJob.WrappingPublicKey build() {
        com.google.cloud.kms.v1.ImportJob.WrappingPublicKey result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.kms.v1.ImportJob.WrappingPublicKey buildPartial() {
        com.google.cloud.kms.v1.ImportJob.WrappingPublicKey result =
            new com.google.cloud.kms.v1.ImportJob.WrappingPublicKey(this);
        result.pem_ = pem_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.kms.v1.ImportJob.WrappingPublicKey) {
          return mergeFrom((com.google.cloud.kms.v1.ImportJob.WrappingPublicKey) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.kms.v1.ImportJob.WrappingPublicKey other) {
        if (other == com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.getDefaultInstance())
          return this;
        if (!other.getPem().isEmpty()) {
          pem_ = other.pem_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.kms.v1.ImportJob.WrappingPublicKey parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.kms.v1.ImportJob.WrappingPublicKey) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object pem_ = "";
      /**
       *
       *
       * <pre>
       * The public key, encoded in PEM format. For more information, see the [RFC
       * 7468](https://tools.ietf.org/html/rfc7468) sections for [General
       * Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
       * [Textual Encoding of Subject Public Key Info]
       * (https://tools.ietf.org/html/rfc7468#section-13).
       * </pre>
       *
       * <code>string pem = 1;</code>
       *
       * @return The pem.
       */
      public java.lang.String getPem() {
        java.lang.Object ref = pem_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pem_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The public key, encoded in PEM format. For more information, see the [RFC
       * 7468](https://tools.ietf.org/html/rfc7468) sections for [General
       * Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
       * [Textual Encoding of Subject Public Key Info]
       * (https://tools.ietf.org/html/rfc7468#section-13).
       * </pre>
       *
       * <code>string pem = 1;</code>
       *
       * @return The bytes for pem.
       */
      public com.google.protobuf.ByteString getPemBytes() {
        java.lang.Object ref = pem_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pem_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The public key, encoded in PEM format. For more information, see the [RFC
       * 7468](https://tools.ietf.org/html/rfc7468) sections for [General
       * Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
       * [Textual Encoding of Subject Public Key Info]
       * (https://tools.ietf.org/html/rfc7468#section-13).
       * </pre>
       *
       * <code>string pem = 1;</code>
       *
       * @param value The pem to set.
       * @return This builder for chaining.
       */
      public Builder setPem(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        pem_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The public key, encoded in PEM format. For more information, see the [RFC
       * 7468](https://tools.ietf.org/html/rfc7468) sections for [General
       * Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
       * [Textual Encoding of Subject Public Key Info]
       * (https://tools.ietf.org/html/rfc7468#section-13).
       * </pre>
       *
       * <code>string pem = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPem() {

        pem_ = getDefaultInstance().getPem();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The public key, encoded in PEM format. For more information, see the [RFC
       * 7468](https://tools.ietf.org/html/rfc7468) sections for [General
       * Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
       * [Textual Encoding of Subject Public Key Info]
       * (https://tools.ietf.org/html/rfc7468#section-13).
       * </pre>
       *
       * <code>string pem = 1;</code>
       *
       * @param value The bytes for pem to set.
       * @return This builder for chaining.
       */
      public Builder setPemBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        pem_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.ImportJob.WrappingPublicKey)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.ImportJob.WrappingPublicKey)
    private static final com.google.cloud.kms.v1.ImportJob.WrappingPublicKey DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.kms.v1.ImportJob.WrappingPublicKey();
    }

    public static com.google.cloud.kms.v1.ImportJob.WrappingPublicKey getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WrappingPublicKey> PARSER =
        new com.google.protobuf.AbstractParser<WrappingPublicKey>() {
          @java.lang.Override
          public WrappingPublicKey parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new WrappingPublicKey(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<WrappingPublicKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WrappingPublicKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.ImportJob.WrappingPublicKey getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this [ImportJob][google.cloud.kms.v1.ImportJob] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;importJobs/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this [ImportJob][google.cloud.kms.v1.ImportJob] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;importJobs/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMPORT_METHOD_FIELD_NUMBER = 2;
  private int importMethod_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. The wrapping method to be used for incoming key material.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ImportJob.ImportMethod import_method = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for importMethod.
   */
  @java.lang.Override
  public int getImportMethodValue() {
    return importMethod_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The wrapping method to be used for incoming key material.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ImportJob.ImportMethod import_method = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The importMethod.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ImportJob.ImportMethod getImportMethod() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.ImportJob.ImportMethod result =
        com.google.cloud.kms.v1.ImportJob.ImportMethod.valueOf(importMethod_);
    return result == null ? com.google.cloud.kms.v1.ImportJob.ImportMethod.UNRECOGNIZED : result;
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 9;
  private int protectionLevel_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. The protection level of the [ImportJob][google.cloud.kms.v1.ImportJob]. This must match the
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level] of the
   * [version_template][google.cloud.kms.v1.CryptoKey.version_template] on the [CryptoKey][google.cloud.kms.v1.CryptoKey] you
   * attempt to import into.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ProtectionLevel protection_level = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The protection level of the [ImportJob][google.cloud.kms.v1.ImportJob]. This must match the
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level] of the
   * [version_template][google.cloud.kms.v1.CryptoKey.version_template] on the [CryptoKey][google.cloud.kms.v1.CryptoKey] you
   * attempt to import into.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ProtectionLevel protection_level = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int GENERATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp generateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the generateTime field is set.
   */
  @java.lang.Override
  public boolean hasGenerateTime() {
    return generateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The generateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getGenerateTime() {
    return generateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : generateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getGenerateTimeOrBuilder() {
    return getGenerateTime();
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
   * expiration and can no longer be used to import key material.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
   * expiration and can no longer be used to import key material.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
   * expiration and can no longer be used to import key material.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return getExpireTime();
  }

  public static final int EXPIRE_EVENT_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp expireEventTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
   * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireEventTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireEventTime() {
    return expireEventTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
   * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireEventTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireEventTime() {
    return expireEventTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : expireEventTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
   * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireEventTimeOrBuilder() {
    return getExpireEventTime();
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if it can
   * be used.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if it can
   * be used.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ImportJob.ImportJobState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.ImportJob.ImportJobState result =
        com.google.cloud.kms.v1.ImportJob.ImportJobState.valueOf(state_);
    return result == null ? com.google.cloud.kms.v1.ImportJob.ImportJobState.UNRECOGNIZED : result;
  }

  public static final int PUBLIC_KEY_FIELD_NUMBER = 7;
  private com.google.cloud.kms.v1.ImportJob.WrappingPublicKey publicKey_;
  /**
   *
   *
   * <pre>
   * Output only. The public key with which to wrap key material prior to
   * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
   * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the publicKey field is set.
   */
  @java.lang.Override
  public boolean hasPublicKey() {
    return publicKey_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The public key with which to wrap key material prior to
   * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
   * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The publicKey.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ImportJob.WrappingPublicKey getPublicKey() {
    return publicKey_ == null
        ? com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.getDefaultInstance()
        : publicKey_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The public key with which to wrap key material prior to
   * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
   * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ImportJob.WrappingPublicKeyOrBuilder getPublicKeyOrBuilder() {
    return getPublicKey();
  }

  public static final int ATTESTATION_FIELD_NUMBER = 8;
  private com.google.cloud.kms.v1.KeyOperationAttestation attestation_;
  /**
   *
   *
   * <pre>
   * Output only. Statement that was generated and signed by the key creator
   * (for example, an HSM) at key creation time. Use this statement to verify
   * attributes of the key as stored on the HSM, independently of Google.
   * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
   * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the attestation field is set.
   */
  @java.lang.Override
  public boolean hasAttestation() {
    return attestation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statement that was generated and signed by the key creator
   * (for example, an HSM) at key creation time. Use this statement to verify
   * attributes of the key as stored on the HSM, independently of Google.
   * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
   * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The attestation.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.KeyOperationAttestation getAttestation() {
    return attestation_ == null
        ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
        : attestation_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statement that was generated and signed by the key creator
   * (for example, an HSM) at key creation time. Use this statement to verify
   * attributes of the key as stored on the HSM, independently of Google.
   * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
   * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder getAttestationOrBuilder() {
    return getAttestation();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (importMethod_
        != com.google.cloud.kms.v1.ImportJob.ImportMethod.IMPORT_METHOD_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, importMethod_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (generateTime_ != null) {
      output.writeMessage(4, getGenerateTime());
    }
    if (expireTime_ != null) {
      output.writeMessage(5, getExpireTime());
    }
    if (state_
        != com.google.cloud.kms.v1.ImportJob.ImportJobState.IMPORT_JOB_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, state_);
    }
    if (publicKey_ != null) {
      output.writeMessage(7, getPublicKey());
    }
    if (attestation_ != null) {
      output.writeMessage(8, getAttestation());
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, protectionLevel_);
    }
    if (expireEventTime_ != null) {
      output.writeMessage(10, getExpireEventTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (importMethod_
        != com.google.cloud.kms.v1.ImportJob.ImportMethod.IMPORT_METHOD_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, importMethod_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (generateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getGenerateTime());
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getExpireTime());
    }
    if (state_
        != com.google.cloud.kms.v1.ImportJob.ImportJobState.IMPORT_JOB_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (publicKey_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPublicKey());
    }
    if (attestation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getAttestation());
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, protectionLevel_);
    }
    if (expireEventTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getExpireEventTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.ImportJob)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.ImportJob other = (com.google.cloud.kms.v1.ImportJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (importMethod_ != other.importMethod_) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasGenerateTime() != other.hasGenerateTime()) return false;
    if (hasGenerateTime()) {
      if (!getGenerateTime().equals(other.getGenerateTime())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (hasExpireEventTime() != other.hasExpireEventTime()) return false;
    if (hasExpireEventTime()) {
      if (!getExpireEventTime().equals(other.getExpireEventTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasPublicKey() != other.hasPublicKey()) return false;
    if (hasPublicKey()) {
      if (!getPublicKey().equals(other.getPublicKey())) return false;
    }
    if (hasAttestation() != other.hasAttestation()) return false;
    if (hasAttestation()) {
      if (!getAttestation().equals(other.getAttestation())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + IMPORT_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + importMethod_;
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasGenerateTime()) {
      hash = (37 * hash) + GENERATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getGenerateTime().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    if (hasExpireEventTime()) {
      hash = (37 * hash) + EXPIRE_EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireEventTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasPublicKey()) {
      hash = (37 * hash) + PUBLIC_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getPublicKey().hashCode();
    }
    if (hasAttestation()) {
      hash = (37 * hash) + ATTESTATION_FIELD_NUMBER;
      hash = (53 * hash) + getAttestation().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportJob parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.ImportJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.ImportJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.ImportJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An [ImportJob][google.cloud.kms.v1.ImportJob] can be used to create [CryptoKeys][google.cloud.kms.v1.CryptoKey] and
   * [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] using pre-existing key material,
   * generated outside of Cloud KMS.
   * When an [ImportJob][google.cloud.kms.v1.ImportJob] is created, Cloud KMS will generate a "wrapping key",
   * which is a public/private key pair. You use the wrapping key to encrypt (also
   * known as wrap) the pre-existing key material to protect it during the import
   * process. The nature of the wrapping key depends on the choice of
   * [import_method][google.cloud.kms.v1.ImportJob.import_method]. When the wrapping key generation
   * is complete, the [state][google.cloud.kms.v1.ImportJob.state] will be set to
   * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE] and the [public_key][google.cloud.kms.v1.ImportJob.public_key]
   * can be fetched. The fetched public key can then be used to wrap your
   * pre-existing key material.
   * Once the key material is wrapped, it can be imported into a new
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in an existing [CryptoKey][google.cloud.kms.v1.CryptoKey] by calling
   * [ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
   * Multiple [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] can be imported with a single
   * [ImportJob][google.cloud.kms.v1.ImportJob]. Cloud KMS uses the private key portion of the wrapping key to
   * unwrap the key material. Only Cloud KMS has access to the private key.
   * An [ImportJob][google.cloud.kms.v1.ImportJob] expires 3 days after it is created. Once expired, Cloud KMS
   * will no longer be able to import or unwrap any key material that was wrapped
   * with the [ImportJob][google.cloud.kms.v1.ImportJob]'s public key.
   * For more information, see
   * [Importing a key](https://cloud.google.com/kms/docs/importing-a-key).
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.ImportJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.ImportJob)
      com.google.cloud.kms.v1.ImportJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_ImportJob_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_ImportJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.ImportJob.class,
              com.google.cloud.kms.v1.ImportJob.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.ImportJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      importMethod_ = 0;

      protectionLevel_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (generateTimeBuilder_ == null) {
        generateTime_ = null;
      } else {
        generateTime_ = null;
        generateTimeBuilder_ = null;
      }
      if (expireTimeBuilder_ == null) {
        expireTime_ = null;
      } else {
        expireTime_ = null;
        expireTimeBuilder_ = null;
      }
      if (expireEventTimeBuilder_ == null) {
        expireEventTime_ = null;
      } else {
        expireEventTime_ = null;
        expireEventTimeBuilder_ = null;
      }
      state_ = 0;

      if (publicKeyBuilder_ == null) {
        publicKey_ = null;
      } else {
        publicKey_ = null;
        publicKeyBuilder_ = null;
      }
      if (attestationBuilder_ == null) {
        attestation_ = null;
      } else {
        attestation_ = null;
        attestationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_ImportJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.ImportJob getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.ImportJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.ImportJob build() {
      com.google.cloud.kms.v1.ImportJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.ImportJob buildPartial() {
      com.google.cloud.kms.v1.ImportJob result = new com.google.cloud.kms.v1.ImportJob(this);
      result.name_ = name_;
      result.importMethod_ = importMethod_;
      result.protectionLevel_ = protectionLevel_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (generateTimeBuilder_ == null) {
        result.generateTime_ = generateTime_;
      } else {
        result.generateTime_ = generateTimeBuilder_.build();
      }
      if (expireTimeBuilder_ == null) {
        result.expireTime_ = expireTime_;
      } else {
        result.expireTime_ = expireTimeBuilder_.build();
      }
      if (expireEventTimeBuilder_ == null) {
        result.expireEventTime_ = expireEventTime_;
      } else {
        result.expireEventTime_ = expireEventTimeBuilder_.build();
      }
      result.state_ = state_;
      if (publicKeyBuilder_ == null) {
        result.publicKey_ = publicKey_;
      } else {
        result.publicKey_ = publicKeyBuilder_.build();
      }
      if (attestationBuilder_ == null) {
        result.attestation_ = attestation_;
      } else {
        result.attestation_ = attestationBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.ImportJob) {
        return mergeFrom((com.google.cloud.kms.v1.ImportJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.ImportJob other) {
      if (other == com.google.cloud.kms.v1.ImportJob.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.importMethod_ != 0) {
        setImportMethodValue(other.getImportMethodValue());
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasGenerateTime()) {
        mergeGenerateTime(other.getGenerateTime());
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.hasExpireEventTime()) {
        mergeExpireEventTime(other.getExpireEventTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasPublicKey()) {
        mergePublicKey(other.getPublicKey());
      }
      if (other.hasAttestation()) {
        mergeAttestation(other.getAttestation());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.ImportJob parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.ImportJob) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [ImportJob][google.cloud.kms.v1.ImportJob] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;importJobs/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [ImportJob][google.cloud.kms.v1.ImportJob] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;importJobs/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [ImportJob][google.cloud.kms.v1.ImportJob] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;importJobs/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [ImportJob][google.cloud.kms.v1.ImportJob] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;importJobs/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [ImportJob][google.cloud.kms.v1.ImportJob] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;importJobs/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private int importMethod_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Immutable. The wrapping method to be used for incoming key material.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportMethod import_method = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for importMethod.
     */
    @java.lang.Override
    public int getImportMethodValue() {
      return importMethod_;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The wrapping method to be used for incoming key material.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportMethod import_method = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for importMethod to set.
     * @return This builder for chaining.
     */
    public Builder setImportMethodValue(int value) {

      importMethod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The wrapping method to be used for incoming key material.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportMethod import_method = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The importMethod.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ImportJob.ImportMethod getImportMethod() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.ImportJob.ImportMethod result =
          com.google.cloud.kms.v1.ImportJob.ImportMethod.valueOf(importMethod_);
      return result == null ? com.google.cloud.kms.v1.ImportJob.ImportMethod.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The wrapping method to be used for incoming key material.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportMethod import_method = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The importMethod to set.
     * @return This builder for chaining.
     */
    public Builder setImportMethod(com.google.cloud.kms.v1.ImportJob.ImportMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }

      importMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The wrapping method to be used for incoming key material.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportMethod import_method = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportMethod() {

      importMethod_ = 0;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Immutable. The protection level of the [ImportJob][google.cloud.kms.v1.ImportJob]. This must match the
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level] of the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] on the [CryptoKey][google.cloud.kms.v1.CryptoKey] you
     * attempt to import into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The protection level of the [ImportJob][google.cloud.kms.v1.ImportJob]. This must match the
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level] of the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] on the [CryptoKey][google.cloud.kms.v1.CryptoKey] you
     * attempt to import into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {

      protectionLevel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The protection level of the [ImportJob][google.cloud.kms.v1.ImportJob]. This must match the
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level] of the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] on the [CryptoKey][google.cloud.kms.v1.CryptoKey] you
     * attempt to import into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The protection level of the [ImportJob][google.cloud.kms.v1.ImportJob]. This must match the
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level] of the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] on the [CryptoKey][google.cloud.kms.v1.CryptoKey] you
     * attempt to import into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The protection level of the [ImportJob][google.cloud.kms.v1.ImportJob]. This must match the
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level] of the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] on the [CryptoKey][google.cloud.kms.v1.CryptoKey] you
     * attempt to import into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {

      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp generateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        generateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the generateTime field is set.
     */
    public boolean hasGenerateTime() {
      return generateTimeBuilder_ != null || generateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The generateTime.
     */
    public com.google.protobuf.Timestamp getGenerateTime() {
      if (generateTimeBuilder_ == null) {
        return generateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : generateTime_;
      } else {
        return generateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGenerateTime(com.google.protobuf.Timestamp value) {
      if (generateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        generateTime_ = value;
        onChanged();
      } else {
        generateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGenerateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (generateTimeBuilder_ == null) {
        generateTime_ = builderForValue.build();
        onChanged();
      } else {
        generateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeGenerateTime(com.google.protobuf.Timestamp value) {
      if (generateTimeBuilder_ == null) {
        if (generateTime_ != null) {
          generateTime_ =
              com.google.protobuf.Timestamp.newBuilder(generateTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          generateTime_ = value;
        }
        onChanged();
      } else {
        generateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGenerateTime() {
      if (generateTimeBuilder_ == null) {
        generateTime_ = null;
        onChanged();
      } else {
        generateTime_ = null;
        generateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getGenerateTimeBuilder() {

      onChanged();
      return getGenerateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getGenerateTimeOrBuilder() {
      if (generateTimeBuilder_ != null) {
        return generateTimeBuilder_.getMessageOrBuilder();
      } else {
        return generateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : generateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key material was generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getGenerateTimeFieldBuilder() {
      if (generateTimeBuilder_ == null) {
        generateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getGenerateTime(), getParentForChildren(), isClean());
        generateTime_ = null;
      }
      return generateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
     * expiration and can no longer be used to import key material.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return expireTimeBuilder_ != null || expireTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
     * expiration and can no longer be used to import key material.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
     * expiration and can no longer be used to import key material.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
     * expiration and can no longer be used to import key material.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
     * expiration and can no longer be used to import key material.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expireTime_ != null) {
          expireTime_ =
              com.google.protobuf.Timestamp.newBuilder(expireTime_).mergeFrom(value).buildPartial();
        } else {
          expireTime_ = value;
        }
        onChanged();
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
     * expiration and can no longer be used to import key material.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        expireTime_ = null;
        onChanged();
      } else {
        expireTime_ = null;
        expireTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
     * expiration and can no longer be used to import key material.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {

      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
     * expiration and can no longer be used to import key material.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for
     * expiration and can no longer be used to import key material.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireEventTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireEventTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
     * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireEventTime field is set.
     */
    public boolean hasExpireEventTime() {
      return expireEventTimeBuilder_ != null || expireEventTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
     * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireEventTime.
     */
    public com.google.protobuf.Timestamp getExpireEventTime() {
      if (expireEventTimeBuilder_ == null) {
        return expireEventTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireEventTime_;
      } else {
        return expireEventTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
     * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireEventTime(com.google.protobuf.Timestamp value) {
      if (expireEventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireEventTime_ = value;
        onChanged();
      } else {
        expireEventTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
     * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireEventTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireEventTimeBuilder_ == null) {
        expireEventTime_ = builderForValue.build();
        onChanged();
      } else {
        expireEventTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
     * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireEventTime(com.google.protobuf.Timestamp value) {
      if (expireEventTimeBuilder_ == null) {
        if (expireEventTime_ != null) {
          expireEventTime_ =
              com.google.protobuf.Timestamp.newBuilder(expireEventTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expireEventTime_ = value;
        }
        onChanged();
      } else {
        expireEventTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
     * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireEventTime() {
      if (expireEventTimeBuilder_ == null) {
        expireEventTime_ = null;
        onChanged();
      } else {
        expireEventTime_ = null;
        expireEventTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
     * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireEventTimeBuilder() {

      onChanged();
      return getExpireEventTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
     * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireEventTimeOrBuilder() {
      if (expireEventTimeBuilder_ != null) {
        return expireEventTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireEventTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireEventTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob] expired. Only present if
     * [state][google.cloud.kms.v1.ImportJob.state] is [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_event_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireEventTimeFieldBuilder() {
      if (expireEventTimeBuilder_ == null) {
        expireEventTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireEventTime(), getParentForChildren(), isClean());
        expireEventTime_ = null;
      }
      return expireEventTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if it can
     * be used.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if it can
     * be used.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if it can
     * be used.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ImportJob.ImportJobState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.ImportJob.ImportJobState result =
          com.google.cloud.kms.v1.ImportJob.ImportJobState.valueOf(state_);
      return result == null
          ? com.google.cloud.kms.v1.ImportJob.ImportJobState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if it can
     * be used.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.kms.v1.ImportJob.ImportJobState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if it can
     * be used.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.ImportJobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.ImportJob.WrappingPublicKey publicKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.ImportJob.WrappingPublicKey,
            com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.Builder,
            com.google.cloud.kms.v1.ImportJob.WrappingPublicKeyOrBuilder>
        publicKeyBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The public key with which to wrap key material prior to
     * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the publicKey field is set.
     */
    public boolean hasPublicKey() {
      return publicKeyBuilder_ != null || publicKey_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The public key with which to wrap key material prior to
     * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The publicKey.
     */
    public com.google.cloud.kms.v1.ImportJob.WrappingPublicKey getPublicKey() {
      if (publicKeyBuilder_ == null) {
        return publicKey_ == null
            ? com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.getDefaultInstance()
            : publicKey_;
      } else {
        return publicKeyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The public key with which to wrap key material prior to
     * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPublicKey(com.google.cloud.kms.v1.ImportJob.WrappingPublicKey value) {
      if (publicKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        publicKey_ = value;
        onChanged();
      } else {
        publicKeyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The public key with which to wrap key material prior to
     * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPublicKey(
        com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.Builder builderForValue) {
      if (publicKeyBuilder_ == null) {
        publicKey_ = builderForValue.build();
        onChanged();
      } else {
        publicKeyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The public key with which to wrap key material prior to
     * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePublicKey(com.google.cloud.kms.v1.ImportJob.WrappingPublicKey value) {
      if (publicKeyBuilder_ == null) {
        if (publicKey_ != null) {
          publicKey_ =
              com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.newBuilder(publicKey_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          publicKey_ = value;
        }
        onChanged();
      } else {
        publicKeyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The public key with which to wrap key material prior to
     * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPublicKey() {
      if (publicKeyBuilder_ == null) {
        publicKey_ = null;
        onChanged();
      } else {
        publicKey_ = null;
        publicKeyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The public key with which to wrap key material prior to
     * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.Builder getPublicKeyBuilder() {

      onChanged();
      return getPublicKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The public key with which to wrap key material prior to
     * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.ImportJob.WrappingPublicKeyOrBuilder getPublicKeyOrBuilder() {
      if (publicKeyBuilder_ != null) {
        return publicKeyBuilder_.getMessageOrBuilder();
      } else {
        return publicKey_ == null
            ? com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.getDefaultInstance()
            : publicKey_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The public key with which to wrap key material prior to
     * import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
     * [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ImportJob.WrappingPublicKey public_key = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.ImportJob.WrappingPublicKey,
            com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.Builder,
            com.google.cloud.kms.v1.ImportJob.WrappingPublicKeyOrBuilder>
        getPublicKeyFieldBuilder() {
      if (publicKeyBuilder_ == null) {
        publicKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.ImportJob.WrappingPublicKey,
                com.google.cloud.kms.v1.ImportJob.WrappingPublicKey.Builder,
                com.google.cloud.kms.v1.ImportJob.WrappingPublicKeyOrBuilder>(
                getPublicKey(), getParentForChildren(), isClean());
        publicKey_ = null;
      }
      return publicKeyBuilder_;
    }

    private com.google.cloud.kms.v1.KeyOperationAttestation attestation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.KeyOperationAttestation,
            com.google.cloud.kms.v1.KeyOperationAttestation.Builder,
            com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder>
        attestationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the key creator
     * (for example, an HSM) at key creation time. Use this statement to verify
     * attributes of the key as stored on the HSM, independently of Google.
     * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
     * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the attestation field is set.
     */
    public boolean hasAttestation() {
      return attestationBuilder_ != null || attestation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the key creator
     * (for example, an HSM) at key creation time. Use this statement to verify
     * attributes of the key as stored on the HSM, independently of Google.
     * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
     * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The attestation.
     */
    public com.google.cloud.kms.v1.KeyOperationAttestation getAttestation() {
      if (attestationBuilder_ == null) {
        return attestation_ == null
            ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
            : attestation_;
      } else {
        return attestationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the key creator
     * (for example, an HSM) at key creation time. Use this statement to verify
     * attributes of the key as stored on the HSM, independently of Google.
     * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
     * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttestation(com.google.cloud.kms.v1.KeyOperationAttestation value) {
      if (attestationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attestation_ = value;
        onChanged();
      } else {
        attestationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the key creator
     * (for example, an HSM) at key creation time. Use this statement to verify
     * attributes of the key as stored on the HSM, independently of Google.
     * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
     * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttestation(
        com.google.cloud.kms.v1.KeyOperationAttestation.Builder builderForValue) {
      if (attestationBuilder_ == null) {
        attestation_ = builderForValue.build();
        onChanged();
      } else {
        attestationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the key creator
     * (for example, an HSM) at key creation time. Use this statement to verify
     * attributes of the key as stored on the HSM, independently of Google.
     * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
     * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAttestation(com.google.cloud.kms.v1.KeyOperationAttestation value) {
      if (attestationBuilder_ == null) {
        if (attestation_ != null) {
          attestation_ =
              com.google.cloud.kms.v1.KeyOperationAttestation.newBuilder(attestation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          attestation_ = value;
        }
        onChanged();
      } else {
        attestationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the key creator
     * (for example, an HSM) at key creation time. Use this statement to verify
     * attributes of the key as stored on the HSM, independently of Google.
     * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
     * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAttestation() {
      if (attestationBuilder_ == null) {
        attestation_ = null;
        onChanged();
      } else {
        attestation_ = null;
        attestationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the key creator
     * (for example, an HSM) at key creation time. Use this statement to verify
     * attributes of the key as stored on the HSM, independently of Google.
     * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
     * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.KeyOperationAttestation.Builder getAttestationBuilder() {

      onChanged();
      return getAttestationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the key creator
     * (for example, an HSM) at key creation time. Use this statement to verify
     * attributes of the key as stored on the HSM, independently of Google.
     * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
     * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder getAttestationOrBuilder() {
      if (attestationBuilder_ != null) {
        return attestationBuilder_.getMessageOrBuilder();
      } else {
        return attestation_ == null
            ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
            : attestation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the key creator
     * (for example, an HSM) at key creation time. Use this statement to verify
     * attributes of the key as stored on the HSM, independently of Google.
     * Only present if the chosen [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a protection
     * level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.KeyOperationAttestation,
            com.google.cloud.kms.v1.KeyOperationAttestation.Builder,
            com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder>
        getAttestationFieldBuilder() {
      if (attestationBuilder_ == null) {
        attestationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.KeyOperationAttestation,
                com.google.cloud.kms.v1.KeyOperationAttestation.Builder,
                com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder>(
                getAttestation(), getParentForChildren(), isClean());
        attestation_ = null;
      }
      return attestationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.ImportJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.ImportJob)
  private static final com.google.cloud.kms.v1.ImportJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.ImportJob();
  }

  public static com.google.cloud.kms.v1.ImportJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportJob> PARSER =
      new com.google.protobuf.AbstractParser<ImportJob>() {
        @java.lang.Override
        public ImportJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImportJob(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImportJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.ImportJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
