/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents an individual cryptographic key, and the
 * associated key material.
 * An [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] version can be
 * used for cryptographic operations.
 * For security reasons, the raw cryptographic key material represented by a
 * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] can never be viewed or exported. It can only be used to
 * encrypt, decrypt, or sign data when an authorized user or application invokes
 * Cloud KMS.
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.CryptoKeyVersion}
 */
public final class CryptoKeyVersion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.CryptoKeyVersion)
    CryptoKeyVersionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CryptoKeyVersion.newBuilder() to construct.
  private CryptoKeyVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CryptoKeyVersion() {
    name_ = "";
    state_ = 0;
    protectionLevel_ = 0;
    algorithm_ = 0;
    importJob_ = "";
    importFailureReason_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CryptoKeyVersion();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CryptoKeyVersion(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 34:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (destroyTime_ != null) {
                subBuilder = destroyTime_.toBuilder();
              }
              destroyTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(destroyTime_);
                destroyTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (destroyEventTime_ != null) {
                subBuilder = destroyEventTime_.toBuilder();
              }
              destroyEventTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(destroyEventTime_);
                destroyEventTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              protectionLevel_ = rawValue;
              break;
            }
          case 66:
            {
              com.google.cloud.kms.v1.KeyOperationAttestation.Builder subBuilder = null;
              if (attestation_ != null) {
                subBuilder = attestation_.toBuilder();
              }
              attestation_ =
                  input.readMessage(
                      com.google.cloud.kms.v1.KeyOperationAttestation.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(attestation_);
                attestation_ = subBuilder.buildPartial();
              }

              break;
            }
          case 80:
            {
              int rawValue = input.readEnum();

              algorithm_ = rawValue;
              break;
            }
          case 90:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (generateTime_ != null) {
                subBuilder = generateTime_.toBuilder();
              }
              generateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(generateTime_);
                generateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 114:
            {
              java.lang.String s = input.readStringRequireUtf8();

              importJob_ = s;
              break;
            }
          case 122:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (importTime_ != null) {
                subBuilder = importTime_.toBuilder();
              }
              importTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(importTime_);
                importTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 130:
            {
              java.lang.String s = input.readStringRequireUtf8();

              importFailureReason_ = s;
              break;
            }
          case 138:
            {
              com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder subBuilder = null;
              if (externalProtectionLevelOptions_ != null) {
                subBuilder = externalProtectionLevelOptions_.toBuilder();
              }
              externalProtectionLevelOptions_ =
                  input.readMessage(
                      com.google.cloud.kms.v1.ExternalProtectionLevelOptions.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(externalProtectionLevelOptions_);
                externalProtectionLevelOptions_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_CryptoKeyVersion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_CryptoKeyVersion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.CryptoKeyVersion.class,
            com.google.cloud.kms.v1.CryptoKeyVersion.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The algorithm of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], indicating what
   * parameters must be used for each cryptographic operation.
   * The
   * [GOOGLE_SYMMETRIC_ENCRYPTION][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.GOOGLE_SYMMETRIC_ENCRYPTION]
   * algorithm is usable with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
   * Algorithms beginning with "RSA_SIGN_" are usable with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
   * The fields in the name after "RSA_SIGN_" correspond to the following
   * parameters: padding algorithm, modulus bit length, and digest algorithm.
   * For PSS, the salt length used is equal to the length of digest
   * algorithm. For example,
   * [RSA_SIGN_PSS_2048_SHA256][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256]
   * will use PSS with a salt length of 256 bits or 32 bytes.
   * Algorithms beginning with "RSA_DECRYPT_" are usable with
   * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
   * The fields in the name after "RSA_DECRYPT_" correspond to the following
   * parameters: padding algorithm, modulus bit length, and digest algorithm.
   * Algorithms beginning with "EC_SIGN_" are usable with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
   * The fields in the name after "EC_SIGN_" correspond to the following
   * parameters: elliptic curve, digest algorithm.
   * For more information, see [Key purposes and algorithms]
   * (https://cloud.google.com/kms/docs/algorithms).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm}
   */
  public enum CryptoKeyVersionAlgorithm implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = 0;</code>
     */
    CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Creates symmetric encryption keys.
     * </pre>
     *
     * <code>GOOGLE_SYMMETRIC_ENCRYPTION = 1;</code>
     */
    GOOGLE_SYMMETRIC_ENCRYPTION(1),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_2048_SHA256 = 2;</code>
     */
    RSA_SIGN_PSS_2048_SHA256(2),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_3072_SHA256 = 3;</code>
     */
    RSA_SIGN_PSS_3072_SHA256(3),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_4096_SHA256 = 4;</code>
     */
    RSA_SIGN_PSS_4096_SHA256(4),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_4096_SHA512 = 15;</code>
     */
    RSA_SIGN_PSS_4096_SHA512(15),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_2048_SHA256 = 5;</code>
     */
    RSA_SIGN_PKCS1_2048_SHA256(5),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_3072_SHA256 = 6;</code>
     */
    RSA_SIGN_PKCS1_3072_SHA256(6),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA256 = 7;</code>
     */
    RSA_SIGN_PKCS1_4096_SHA256(7),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA512 = 16;</code>
     */
    RSA_SIGN_PKCS1_4096_SHA512(16),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_2048_SHA256 = 8;</code>
     */
    RSA_DECRYPT_OAEP_2048_SHA256(8),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_3072_SHA256 = 9;</code>
     */
    RSA_DECRYPT_OAEP_3072_SHA256(9),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA256 = 10;</code>
     */
    RSA_DECRYPT_OAEP_4096_SHA256(10),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA512 = 17;</code>
     */
    RSA_DECRYPT_OAEP_4096_SHA512(17),
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     * </pre>
     *
     * <code>EC_SIGN_P256_SHA256 = 12;</code>
     */
    EC_SIGN_P256_SHA256(12),
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     * </pre>
     *
     * <code>EC_SIGN_P384_SHA384 = 13;</code>
     */
    EC_SIGN_P384_SHA384(13),
    /**
     *
     *
     * <pre>
     * Algorithm representing symmetric encryption by an external key manager.
     * </pre>
     *
     * <code>EXTERNAL_SYMMETRIC_ENCRYPTION = 18;</code>
     */
    EXTERNAL_SYMMETRIC_ENCRYPTION(18),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = 0;</code>
     */
    public static final int CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Creates symmetric encryption keys.
     * </pre>
     *
     * <code>GOOGLE_SYMMETRIC_ENCRYPTION = 1;</code>
     */
    public static final int GOOGLE_SYMMETRIC_ENCRYPTION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_2048_SHA256 = 2;</code>
     */
    public static final int RSA_SIGN_PSS_2048_SHA256_VALUE = 2;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_3072_SHA256 = 3;</code>
     */
    public static final int RSA_SIGN_PSS_3072_SHA256_VALUE = 3;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_4096_SHA256 = 4;</code>
     */
    public static final int RSA_SIGN_PSS_4096_SHA256_VALUE = 4;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_4096_SHA512 = 15;</code>
     */
    public static final int RSA_SIGN_PSS_4096_SHA512_VALUE = 15;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_2048_SHA256 = 5;</code>
     */
    public static final int RSA_SIGN_PKCS1_2048_SHA256_VALUE = 5;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_3072_SHA256 = 6;</code>
     */
    public static final int RSA_SIGN_PKCS1_3072_SHA256_VALUE = 6;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA256 = 7;</code>
     */
    public static final int RSA_SIGN_PKCS1_4096_SHA256_VALUE = 7;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA512 = 16;</code>
     */
    public static final int RSA_SIGN_PKCS1_4096_SHA512_VALUE = 16;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_2048_SHA256 = 8;</code>
     */
    public static final int RSA_DECRYPT_OAEP_2048_SHA256_VALUE = 8;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_3072_SHA256 = 9;</code>
     */
    public static final int RSA_DECRYPT_OAEP_3072_SHA256_VALUE = 9;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA256 = 10;</code>
     */
    public static final int RSA_DECRYPT_OAEP_4096_SHA256_VALUE = 10;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA512 = 17;</code>
     */
    public static final int RSA_DECRYPT_OAEP_4096_SHA512_VALUE = 17;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     * </pre>
     *
     * <code>EC_SIGN_P256_SHA256 = 12;</code>
     */
    public static final int EC_SIGN_P256_SHA256_VALUE = 12;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     * </pre>
     *
     * <code>EC_SIGN_P384_SHA384 = 13;</code>
     */
    public static final int EC_SIGN_P384_SHA384_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Algorithm representing symmetric encryption by an external key manager.
     * </pre>
     *
     * <code>EXTERNAL_SYMMETRIC_ENCRYPTION = 18;</code>
     */
    public static final int EXTERNAL_SYMMETRIC_ENCRYPTION_VALUE = 18;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CryptoKeyVersionAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CryptoKeyVersionAlgorithm forNumber(int value) {
      switch (value) {
        case 0:
          return CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED;
        case 1:
          return GOOGLE_SYMMETRIC_ENCRYPTION;
        case 2:
          return RSA_SIGN_PSS_2048_SHA256;
        case 3:
          return RSA_SIGN_PSS_3072_SHA256;
        case 4:
          return RSA_SIGN_PSS_4096_SHA256;
        case 15:
          return RSA_SIGN_PSS_4096_SHA512;
        case 5:
          return RSA_SIGN_PKCS1_2048_SHA256;
        case 6:
          return RSA_SIGN_PKCS1_3072_SHA256;
        case 7:
          return RSA_SIGN_PKCS1_4096_SHA256;
        case 16:
          return RSA_SIGN_PKCS1_4096_SHA512;
        case 8:
          return RSA_DECRYPT_OAEP_2048_SHA256;
        case 9:
          return RSA_DECRYPT_OAEP_3072_SHA256;
        case 10:
          return RSA_DECRYPT_OAEP_4096_SHA256;
        case 17:
          return RSA_DECRYPT_OAEP_4096_SHA512;
        case 12:
          return EC_SIGN_P256_SHA256;
        case 13:
          return EC_SIGN_P384_SHA384;
        case 18:
          return EXTERNAL_SYMMETRIC_ENCRYPTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionAlgorithm>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionAlgorithm>() {
              public CryptoKeyVersionAlgorithm findValueByNumber(int number) {
                return CryptoKeyVersionAlgorithm.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDescriptor().getEnumTypes().get(0);
    }

    private static final CryptoKeyVersionAlgorithm[] VALUES = values();

    public static CryptoKeyVersionAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CryptoKeyVersionAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm)
  }

  /**
   *
   *
   * <pre>
   * The state of a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], indicating if it can be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState}
   */
  public enum CryptoKeyVersionState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_STATE_UNSPECIFIED = 0;</code>
     */
    CRYPTO_KEY_VERSION_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This version is still being generated. It may not be used, enabled,
     * disabled, or destroyed yet. Cloud KMS will automatically mark this
     * version [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] as soon as the version is ready.
     * </pre>
     *
     * <code>PENDING_GENERATION = 5;</code>
     */
    PENDING_GENERATION(5),
    /**
     *
     *
     * <pre>
     * This version may be used for cryptographic operations.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * This version may not be used, but the key material is still available,
     * and the version can be placed back into the [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     *
     *
     * <pre>
     * This version is destroyed, and the key material is no longer stored.
     * A version may not leave this state once entered.
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    DESTROYED(3),
    /**
     *
     *
     * <pre>
     * This version is scheduled for destruction, and will be destroyed soon.
     * Call
     * [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
     * to put it back into the [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] state.
     * </pre>
     *
     * <code>DESTROY_SCHEDULED = 4;</code>
     */
    DESTROY_SCHEDULED(4),
    /**
     *
     *
     * <pre>
     * This version is still being imported. It may not be used, enabled,
     * disabled, or destroyed yet. Cloud KMS will automatically mark this
     * version [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] as soon as the version is ready.
     * </pre>
     *
     * <code>PENDING_IMPORT = 6;</code>
     */
    PENDING_IMPORT(6),
    /**
     *
     *
     * <pre>
     * This version was not imported successfully. It may not be used, enabled,
     * disabled, or destroyed. The submitted key material has been discarded.
     * Additional details can be found in
     * [CryptoKeyVersion.import_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.import_failure_reason].
     * </pre>
     *
     * <code>IMPORT_FAILED = 7;</code>
     */
    IMPORT_FAILED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int CRYPTO_KEY_VERSION_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This version is still being generated. It may not be used, enabled,
     * disabled, or destroyed yet. Cloud KMS will automatically mark this
     * version [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] as soon as the version is ready.
     * </pre>
     *
     * <code>PENDING_GENERATION = 5;</code>
     */
    public static final int PENDING_GENERATION_VALUE = 5;
    /**
     *
     *
     * <pre>
     * This version may be used for cryptographic operations.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This version may not be used, but the key material is still available,
     * and the version can be placed back into the [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This version is destroyed, and the key material is no longer stored.
     * A version may not leave this state once entered.
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    public static final int DESTROYED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * This version is scheduled for destruction, and will be destroyed soon.
     * Call
     * [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
     * to put it back into the [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] state.
     * </pre>
     *
     * <code>DESTROY_SCHEDULED = 4;</code>
     */
    public static final int DESTROY_SCHEDULED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * This version is still being imported. It may not be used, enabled,
     * disabled, or destroyed yet. Cloud KMS will automatically mark this
     * version [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] as soon as the version is ready.
     * </pre>
     *
     * <code>PENDING_IMPORT = 6;</code>
     */
    public static final int PENDING_IMPORT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * This version was not imported successfully. It may not be used, enabled,
     * disabled, or destroyed. The submitted key material has been discarded.
     * Additional details can be found in
     * [CryptoKeyVersion.import_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.import_failure_reason].
     * </pre>
     *
     * <code>IMPORT_FAILED = 7;</code>
     */
    public static final int IMPORT_FAILED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CryptoKeyVersionState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CryptoKeyVersionState forNumber(int value) {
      switch (value) {
        case 0:
          return CRYPTO_KEY_VERSION_STATE_UNSPECIFIED;
        case 5:
          return PENDING_GENERATION;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        case 3:
          return DESTROYED;
        case 4:
          return DESTROY_SCHEDULED;
        case 6:
          return PENDING_IMPORT;
        case 7:
          return IMPORT_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionState>() {
              public CryptoKeyVersionState findValueByNumber(int number) {
                return CryptoKeyVersionState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDescriptor().getEnumTypes().get(1);
    }

    private static final CryptoKeyVersionState[] VALUES = values();

    public static CryptoKeyVersionState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CryptoKeyVersionState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState)
  }

  /**
   *
   *
   * <pre>
   * A view for [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]s. Controls the level of detail returned
   * for [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] in
   * [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions] and
   * [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionView}
   */
  public enum CryptoKeyVersionView implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default view for each [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Does not include
     * the [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation] field.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED = 0;</code>
     */
    CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Provides all fields in each [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], including the
     * [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation].
     * </pre>
     *
     * <code>FULL = 1;</code>
     */
    FULL(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default view for each [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Does not include
     * the [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation] field.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED = 0;</code>
     */
    public static final int CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Provides all fields in each [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], including the
     * [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation].
     * </pre>
     *
     * <code>FULL = 1;</code>
     */
    public static final int FULL_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CryptoKeyVersionView valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CryptoKeyVersionView forNumber(int value) {
      switch (value) {
        case 0:
          return CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED;
        case 1:
          return FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionView>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionView>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionView>() {
              public CryptoKeyVersionView findValueByNumber(int number) {
                return CryptoKeyVersionView.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDescriptor().getEnumTypes().get(2);
    }

    private static final CryptoKeyVersionView[] VALUES = values();

    public static CryptoKeyVersionView valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CryptoKeyVersionView(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionView)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_;
  /**
   *
   *
   * <pre>
   * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
   *
   * @return The state.
   */
  public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState result =
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.valueOf(state_);
    return result == null
        ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.UNRECOGNIZED
        : result;
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 7;
  private int protectionLevel_;
  /**
   *
   *
   * <pre>
   * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] describing how crypto operations are
   * performed with this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] describing how crypto operations are
   * performed with this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The protectionLevel.
   */
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  public static final int ALGORITHM_FIELD_NUMBER = 10;
  private int algorithm_;
  /**
   *
   *
   * <pre>
   * Output only. The [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] that this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] supports.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for algorithm.
   */
  public int getAlgorithmValue() {
    return algorithm_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] that this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] supports.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The algorithm.
   */
  public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm result =
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.valueOf(algorithm_);
    return result == null
        ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED
        : result;
  }

  public static final int ATTESTATION_FIELD_NUMBER = 8;
  private com.google.cloud.kms.v1.KeyOperationAttestation attestation_;
  /**
   *
   *
   * <pre>
   * Output only. Statement that was generated and signed by the HSM at key
   * creation time. Use this statement to verify attributes of the key as stored
   * on the HSM, independently of Google. Only provided for key versions with
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the attestation field is set.
   */
  public boolean hasAttestation() {
    return attestation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statement that was generated and signed by the HSM at key
   * creation time. Use this statement to verify attributes of the key as stored
   * on the HSM, independently of Google. Only provided for key versions with
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The attestation.
   */
  public com.google.cloud.kms.v1.KeyOperationAttestation getAttestation() {
    return attestation_ == null
        ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
        : attestation_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statement that was generated and signed by the HSM at key
   * creation time. Use this statement to verify attributes of the key as stored
   * on the HSM, independently of Google. Only provided for key versions with
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder getAttestationOrBuilder() {
    return getAttestation();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int GENERATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp generateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
   * generated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the generateTime field is set.
   */
  public boolean hasGenerateTime() {
    return generateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
   * generated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The generateTime.
   */
  public com.google.protobuf.Timestamp getGenerateTime() {
    return generateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : generateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
   * generated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.protobuf.TimestampOrBuilder getGenerateTimeOrBuilder() {
    return getGenerateTime();
  }

  public static final int DESTROY_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp destroyTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
   * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the destroyTime field is set.
   */
  public boolean hasDestroyTime() {
    return destroyTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
   * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The destroyTime.
   */
  public com.google.protobuf.Timestamp getDestroyTime() {
    return destroyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
   * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
    return getDestroyTime();
  }

  public static final int DESTROY_EVENT_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp destroyEventTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time this CryptoKeyVersion's key material was
   * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the destroyEventTime field is set.
   */
  public boolean hasDestroyEventTime() {
    return destroyEventTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this CryptoKeyVersion's key material was
   * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The destroyEventTime.
   */
  public com.google.protobuf.Timestamp getDestroyEventTime() {
    return destroyEventTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : destroyEventTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this CryptoKeyVersion's key material was
   * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.protobuf.TimestampOrBuilder getDestroyEventTimeOrBuilder() {
    return getDestroyEventTime();
  }

  public static final int IMPORT_JOB_FIELD_NUMBER = 14;
  private volatile java.lang.Object importJob_;
  /**
   *
   *
   * <pre>
   * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob] used to import this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if the underlying key material was
   * imported.
   * </pre>
   *
   * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The importJob.
   */
  public java.lang.String getImportJob() {
    java.lang.Object ref = importJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      importJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob] used to import this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if the underlying key material was
   * imported.
   * </pre>
   *
   * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for importJob.
   */
  public com.google.protobuf.ByteString getImportJobBytes() {
    java.lang.Object ref = importJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      importJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMPORT_TIME_FIELD_NUMBER = 15;
  private com.google.protobuf.Timestamp importTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
   * was imported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the importTime field is set.
   */
  public boolean hasImportTime() {
    return importTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
   * was imported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The importTime.
   */
  public com.google.protobuf.Timestamp getImportTime() {
    return importTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : importTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
   * was imported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.protobuf.TimestampOrBuilder getImportTimeOrBuilder() {
    return getImportTime();
  }

  public static final int IMPORT_FAILURE_REASON_FIELD_NUMBER = 16;
  private volatile java.lang.Object importFailureReason_;
  /**
   *
   *
   * <pre>
   * Output only. The root cause of an import failure. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
   * </pre>
   *
   * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The importFailureReason.
   */
  public java.lang.String getImportFailureReason() {
    java.lang.Object ref = importFailureReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      importFailureReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The root cause of an import failure. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
   * </pre>
   *
   * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for importFailureReason.
   */
  public com.google.protobuf.ByteString getImportFailureReasonBytes() {
    java.lang.Object ref = importFailureReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      importFailureReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_PROTECTION_LEVEL_OPTIONS_FIELD_NUMBER = 17;
  private com.google.cloud.kms.v1.ExternalProtectionLevelOptions externalProtectionLevelOptions_;
  /**
   *
   *
   * <pre>
   * ExternalProtectionLevelOptions stores a group of additional fields for
   * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
   * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
   * </code>
   *
   * @return Whether the externalProtectionLevelOptions field is set.
   */
  public boolean hasExternalProtectionLevelOptions() {
    return externalProtectionLevelOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * ExternalProtectionLevelOptions stores a group of additional fields for
   * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
   * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
   * </code>
   *
   * @return The externalProtectionLevelOptions.
   */
  public com.google.cloud.kms.v1.ExternalProtectionLevelOptions
      getExternalProtectionLevelOptions() {
    return externalProtectionLevelOptions_ == null
        ? com.google.cloud.kms.v1.ExternalProtectionLevelOptions.getDefaultInstance()
        : externalProtectionLevelOptions_;
  }
  /**
   *
   *
   * <pre>
   * ExternalProtectionLevelOptions stores a group of additional fields for
   * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
   * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
   * </code>
   */
  public com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder
      getExternalProtectionLevelOptionsOrBuilder() {
    return getExternalProtectionLevelOptions();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState
            .CRYPTO_KEY_VERSION_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, state_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (destroyTime_ != null) {
      output.writeMessage(5, getDestroyTime());
    }
    if (destroyEventTime_ != null) {
      output.writeMessage(6, getDestroyEventTime());
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, protectionLevel_);
    }
    if (attestation_ != null) {
      output.writeMessage(8, getAttestation());
    }
    if (algorithm_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
            .CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, algorithm_);
    }
    if (generateTime_ != null) {
      output.writeMessage(11, getGenerateTime());
    }
    if (!getImportJobBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, importJob_);
    }
    if (importTime_ != null) {
      output.writeMessage(15, getImportTime());
    }
    if (!getImportFailureReasonBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, importFailureReason_);
    }
    if (externalProtectionLevelOptions_ != null) {
      output.writeMessage(17, getExternalProtectionLevelOptions());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState
            .CRYPTO_KEY_VERSION_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (destroyTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDestroyTime());
    }
    if (destroyEventTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDestroyEventTime());
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, protectionLevel_);
    }
    if (attestation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getAttestation());
    }
    if (algorithm_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
            .CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, algorithm_);
    }
    if (generateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getGenerateTime());
    }
    if (!getImportJobBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, importJob_);
    }
    if (importTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getImportTime());
    }
    if (!getImportFailureReasonBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, importFailureReason_);
    }
    if (externalProtectionLevelOptions_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, getExternalProtectionLevelOptions());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.CryptoKeyVersion)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.CryptoKeyVersion other = (com.google.cloud.kms.v1.CryptoKeyVersion) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (algorithm_ != other.algorithm_) return false;
    if (hasAttestation() != other.hasAttestation()) return false;
    if (hasAttestation()) {
      if (!getAttestation().equals(other.getAttestation())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasGenerateTime() != other.hasGenerateTime()) return false;
    if (hasGenerateTime()) {
      if (!getGenerateTime().equals(other.getGenerateTime())) return false;
    }
    if (hasDestroyTime() != other.hasDestroyTime()) return false;
    if (hasDestroyTime()) {
      if (!getDestroyTime().equals(other.getDestroyTime())) return false;
    }
    if (hasDestroyEventTime() != other.hasDestroyEventTime()) return false;
    if (hasDestroyEventTime()) {
      if (!getDestroyEventTime().equals(other.getDestroyEventTime())) return false;
    }
    if (!getImportJob().equals(other.getImportJob())) return false;
    if (hasImportTime() != other.hasImportTime()) return false;
    if (hasImportTime()) {
      if (!getImportTime().equals(other.getImportTime())) return false;
    }
    if (!getImportFailureReason().equals(other.getImportFailureReason())) return false;
    if (hasExternalProtectionLevelOptions() != other.hasExternalProtectionLevelOptions())
      return false;
    if (hasExternalProtectionLevelOptions()) {
      if (!getExternalProtectionLevelOptions().equals(other.getExternalProtectionLevelOptions()))
        return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + algorithm_;
    if (hasAttestation()) {
      hash = (37 * hash) + ATTESTATION_FIELD_NUMBER;
      hash = (53 * hash) + getAttestation().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasGenerateTime()) {
      hash = (37 * hash) + GENERATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getGenerateTime().hashCode();
    }
    if (hasDestroyTime()) {
      hash = (37 * hash) + DESTROY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyTime().hashCode();
    }
    if (hasDestroyEventTime()) {
      hash = (37 * hash) + DESTROY_EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyEventTime().hashCode();
    }
    hash = (37 * hash) + IMPORT_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getImportJob().hashCode();
    if (hasImportTime()) {
      hash = (37 * hash) + IMPORT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getImportTime().hashCode();
    }
    hash = (37 * hash) + IMPORT_FAILURE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getImportFailureReason().hashCode();
    if (hasExternalProtectionLevelOptions()) {
      hash = (37 * hash) + EXTERNAL_PROTECTION_LEVEL_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExternalProtectionLevelOptions().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.CryptoKeyVersion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents an individual cryptographic key, and the
   * associated key material.
   * An [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] version can be
   * used for cryptographic operations.
   * For security reasons, the raw cryptographic key material represented by a
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] can never be viewed or exported. It can only be used to
   * encrypt, decrypt, or sign data when an authorized user or application invokes
   * Cloud KMS.
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.CryptoKeyVersion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.CryptoKeyVersion)
      com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKeyVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKeyVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.CryptoKeyVersion.class,
              com.google.cloud.kms.v1.CryptoKeyVersion.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.CryptoKeyVersion.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      state_ = 0;

      protectionLevel_ = 0;

      algorithm_ = 0;

      if (attestationBuilder_ == null) {
        attestation_ = null;
      } else {
        attestation_ = null;
        attestationBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (generateTimeBuilder_ == null) {
        generateTime_ = null;
      } else {
        generateTime_ = null;
        generateTimeBuilder_ = null;
      }
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = null;
      } else {
        destroyTime_ = null;
        destroyTimeBuilder_ = null;
      }
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTime_ = null;
      } else {
        destroyEventTime_ = null;
        destroyEventTimeBuilder_ = null;
      }
      importJob_ = "";

      if (importTimeBuilder_ == null) {
        importTime_ = null;
      } else {
        importTime_ = null;
        importTimeBuilder_ = null;
      }
      importFailureReason_ = "";

      if (externalProtectionLevelOptionsBuilder_ == null) {
        externalProtectionLevelOptions_ = null;
      } else {
        externalProtectionLevelOptions_ = null;
        externalProtectionLevelOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKeyVersion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion build() {
      com.google.cloud.kms.v1.CryptoKeyVersion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion buildPartial() {
      com.google.cloud.kms.v1.CryptoKeyVersion result =
          new com.google.cloud.kms.v1.CryptoKeyVersion(this);
      result.name_ = name_;
      result.state_ = state_;
      result.protectionLevel_ = protectionLevel_;
      result.algorithm_ = algorithm_;
      if (attestationBuilder_ == null) {
        result.attestation_ = attestation_;
      } else {
        result.attestation_ = attestationBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (generateTimeBuilder_ == null) {
        result.generateTime_ = generateTime_;
      } else {
        result.generateTime_ = generateTimeBuilder_.build();
      }
      if (destroyTimeBuilder_ == null) {
        result.destroyTime_ = destroyTime_;
      } else {
        result.destroyTime_ = destroyTimeBuilder_.build();
      }
      if (destroyEventTimeBuilder_ == null) {
        result.destroyEventTime_ = destroyEventTime_;
      } else {
        result.destroyEventTime_ = destroyEventTimeBuilder_.build();
      }
      result.importJob_ = importJob_;
      if (importTimeBuilder_ == null) {
        result.importTime_ = importTime_;
      } else {
        result.importTime_ = importTimeBuilder_.build();
      }
      result.importFailureReason_ = importFailureReason_;
      if (externalProtectionLevelOptionsBuilder_ == null) {
        result.externalProtectionLevelOptions_ = externalProtectionLevelOptions_;
      } else {
        result.externalProtectionLevelOptions_ = externalProtectionLevelOptionsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.CryptoKeyVersion) {
        return mergeFrom((com.google.cloud.kms.v1.CryptoKeyVersion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.CryptoKeyVersion other) {
      if (other == com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      if (other.algorithm_ != 0) {
        setAlgorithmValue(other.getAlgorithmValue());
      }
      if (other.hasAttestation()) {
        mergeAttestation(other.getAttestation());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasGenerateTime()) {
        mergeGenerateTime(other.getGenerateTime());
      }
      if (other.hasDestroyTime()) {
        mergeDestroyTime(other.getDestroyTime());
      }
      if (other.hasDestroyEventTime()) {
        mergeDestroyEventTime(other.getDestroyEventTime());
      }
      if (!other.getImportJob().isEmpty()) {
        importJob_ = other.importJob_;
        onChanged();
      }
      if (other.hasImportTime()) {
        mergeImportTime(other.getImportTime());
      }
      if (!other.getImportFailureReason().isEmpty()) {
        importFailureReason_ = other.importFailureReason_;
        onChanged();
      }
      if (other.hasExternalProtectionLevelOptions()) {
        mergeExternalProtectionLevelOptions(other.getExternalProtectionLevelOptions());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.CryptoKeyVersion parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.CryptoKeyVersion) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @return The state.
     */
    public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState result =
          com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.valueOf(state_);
      return result == null
          ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] describing how crypto operations are
     * performed with this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] describing how crypto operations are
     * performed with this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {
      protectionLevel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] describing how crypto operations are
     * performed with this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The protectionLevel.
     */
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] describing how crypto operations are
     * performed with this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] describing how crypto operations are
     * performed with this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {

      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    private int algorithm_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] that this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for algorithm.
     */
    public int getAlgorithmValue() {
      return algorithm_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] that this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithmValue(int value) {
      algorithm_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] that this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The algorithm.
     */
    public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm result =
          com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.valueOf(algorithm_);
      return result == null
          ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] that this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithm(
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }

      algorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] that this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlgorithm() {

      algorithm_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.KeyOperationAttestation attestation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.KeyOperationAttestation,
            com.google.cloud.kms.v1.KeyOperationAttestation.Builder,
            com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder>
        attestationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the attestation field is set.
     */
    public boolean hasAttestation() {
      return attestationBuilder_ != null || attestation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The attestation.
     */
    public com.google.cloud.kms.v1.KeyOperationAttestation getAttestation() {
      if (attestationBuilder_ == null) {
        return attestation_ == null
            ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
            : attestation_;
      } else {
        return attestationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttestation(com.google.cloud.kms.v1.KeyOperationAttestation value) {
      if (attestationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attestation_ = value;
        onChanged();
      } else {
        attestationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttestation(
        com.google.cloud.kms.v1.KeyOperationAttestation.Builder builderForValue) {
      if (attestationBuilder_ == null) {
        attestation_ = builderForValue.build();
        onChanged();
      } else {
        attestationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAttestation(com.google.cloud.kms.v1.KeyOperationAttestation value) {
      if (attestationBuilder_ == null) {
        if (attestation_ != null) {
          attestation_ =
              com.google.cloud.kms.v1.KeyOperationAttestation.newBuilder(attestation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          attestation_ = value;
        }
        onChanged();
      } else {
        attestationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAttestation() {
      if (attestationBuilder_ == null) {
        attestation_ = null;
        onChanged();
      } else {
        attestation_ = null;
        attestationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.KeyOperationAttestation.Builder getAttestationBuilder() {

      onChanged();
      return getAttestationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder getAttestationOrBuilder() {
      if (attestationBuilder_ != null) {
        return attestationBuilder_.getMessageOrBuilder();
      } else {
        return attestation_ == null
            ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
            : attestation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level] [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.KeyOperationAttestation,
            com.google.cloud.kms.v1.KeyOperationAttestation.Builder,
            com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder>
        getAttestationFieldBuilder() {
      if (attestationBuilder_ == null) {
        attestationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.KeyOperationAttestation,
                com.google.cloud.kms.v1.KeyOperationAttestation.Builder,
                com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder>(
                getAttestation(), getParentForChildren(), isClean());
        attestation_ = null;
      }
      return attestationBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp generateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        generateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the generateTime field is set.
     */
    public boolean hasGenerateTime() {
      return generateTimeBuilder_ != null || generateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The generateTime.
     */
    public com.google.protobuf.Timestamp getGenerateTime() {
      if (generateTimeBuilder_ == null) {
        return generateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : generateTime_;
      } else {
        return generateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGenerateTime(com.google.protobuf.Timestamp value) {
      if (generateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        generateTime_ = value;
        onChanged();
      } else {
        generateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGenerateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (generateTimeBuilder_ == null) {
        generateTime_ = builderForValue.build();
        onChanged();
      } else {
        generateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeGenerateTime(com.google.protobuf.Timestamp value) {
      if (generateTimeBuilder_ == null) {
        if (generateTime_ != null) {
          generateTime_ =
              com.google.protobuf.Timestamp.newBuilder(generateTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          generateTime_ = value;
        }
        onChanged();
      } else {
        generateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGenerateTime() {
      if (generateTimeBuilder_ == null) {
        generateTime_ = null;
        onChanged();
      } else {
        generateTime_ = null;
        generateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getGenerateTimeBuilder() {

      onChanged();
      return getGenerateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getGenerateTimeOrBuilder() {
      if (generateTimeBuilder_ != null) {
        return generateTimeBuilder_.getMessageOrBuilder();
      } else {
        return generateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : generateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getGenerateTimeFieldBuilder() {
      if (generateTimeBuilder_ == null) {
        generateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getGenerateTime(), getParentForChildren(), isClean());
        generateTime_ = null;
      }
      return generateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp destroyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        destroyTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the destroyTime field is set.
     */
    public boolean hasDestroyTime() {
      return destroyTimeBuilder_ != null || destroyTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The destroyTime.
     */
    public com.google.protobuf.Timestamp getDestroyTime() {
      if (destroyTimeBuilder_ == null) {
        return destroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyTime_;
      } else {
        return destroyTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyTime_ = value;
        onChanged();
      } else {
        destroyTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = builderForValue.build();
        onChanged();
      } else {
        destroyTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (destroyTime_ != null) {
          destroyTime_ =
              com.google.protobuf.Timestamp.newBuilder(destroyTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destroyTime_ = value;
        }
        onChanged();
      } else {
        destroyTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDestroyTime() {
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = null;
        onChanged();
      } else {
        destroyTime_ = null;
        destroyTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDestroyTimeBuilder() {

      onChanged();
      return getDestroyTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
      if (destroyTimeBuilder_ != null) {
        return destroyTimeBuilder_.getMessageOrBuilder();
      } else {
        return destroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDestroyTimeFieldBuilder() {
      if (destroyTimeBuilder_ == null) {
        destroyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDestroyTime(), getParentForChildren(), isClean());
        destroyTime_ = null;
      }
      return destroyTimeBuilder_;
    }

    private com.google.protobuf.Timestamp destroyEventTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        destroyEventTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the destroyEventTime field is set.
     */
    public boolean hasDestroyEventTime() {
      return destroyEventTimeBuilder_ != null || destroyEventTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The destroyEventTime.
     */
    public com.google.protobuf.Timestamp getDestroyEventTime() {
      if (destroyEventTimeBuilder_ == null) {
        return destroyEventTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyEventTime_;
      } else {
        return destroyEventTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyEventTime(com.google.protobuf.Timestamp value) {
      if (destroyEventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyEventTime_ = value;
        onChanged();
      } else {
        destroyEventTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyEventTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTime_ = builderForValue.build();
        onChanged();
      } else {
        destroyEventTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDestroyEventTime(com.google.protobuf.Timestamp value) {
      if (destroyEventTimeBuilder_ == null) {
        if (destroyEventTime_ != null) {
          destroyEventTime_ =
              com.google.protobuf.Timestamp.newBuilder(destroyEventTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destroyEventTime_ = value;
        }
        onChanged();
      } else {
        destroyEventTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDestroyEventTime() {
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTime_ = null;
        onChanged();
      } else {
        destroyEventTime_ = null;
        destroyEventTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDestroyEventTimeBuilder() {

      onChanged();
      return getDestroyEventTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDestroyEventTimeOrBuilder() {
      if (destroyEventTimeBuilder_ != null) {
        return destroyEventTimeBuilder_.getMessageOrBuilder();
      } else {
        return destroyEventTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyEventTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDestroyEventTimeFieldBuilder() {
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDestroyEventTime(), getParentForChildren(), isClean());
        destroyEventTime_ = null;
      }
      return destroyEventTimeBuilder_;
    }

    private java.lang.Object importJob_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob] used to import this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if the underlying key material was
     * imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The importJob.
     */
    public java.lang.String getImportJob() {
      java.lang.Object ref = importJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        importJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob] used to import this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if the underlying key material was
     * imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for importJob.
     */
    public com.google.protobuf.ByteString getImportJobBytes() {
      java.lang.Object ref = importJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        importJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob] used to import this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if the underlying key material was
     * imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The importJob to set.
     * @return This builder for chaining.
     */
    public Builder setImportJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      importJob_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob] used to import this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if the underlying key material was
     * imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportJob() {

      importJob_ = getDefaultInstance().getImportJob();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob] used to import this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if the underlying key material was
     * imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for importJob to set.
     * @return This builder for chaining.
     */
    public Builder setImportJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      importJob_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp importTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        importTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
     * was imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the importTime field is set.
     */
    public boolean hasImportTime() {
      return importTimeBuilder_ != null || importTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
     * was imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The importTime.
     */
    public com.google.protobuf.Timestamp getImportTime() {
      if (importTimeBuilder_ == null) {
        return importTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : importTime_;
      } else {
        return importTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
     * was imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setImportTime(com.google.protobuf.Timestamp value) {
      if (importTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importTime_ = value;
        onChanged();
      } else {
        importTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
     * was imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setImportTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (importTimeBuilder_ == null) {
        importTime_ = builderForValue.build();
        onChanged();
      } else {
        importTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
     * was imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeImportTime(com.google.protobuf.Timestamp value) {
      if (importTimeBuilder_ == null) {
        if (importTime_ != null) {
          importTime_ =
              com.google.protobuf.Timestamp.newBuilder(importTime_).mergeFrom(value).buildPartial();
        } else {
          importTime_ = value;
        }
        onChanged();
      } else {
        importTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
     * was imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearImportTime() {
      if (importTimeBuilder_ == null) {
        importTime_ = null;
        onChanged();
      } else {
        importTime_ = null;
        importTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
     * was imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getImportTimeBuilder() {

      onChanged();
      return getImportTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
     * was imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getImportTimeOrBuilder() {
      if (importTimeBuilder_ != null) {
        return importTimeBuilder_.getMessageOrBuilder();
      } else {
        return importTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : importTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material
     * was imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getImportTimeFieldBuilder() {
      if (importTimeBuilder_ == null) {
        importTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getImportTime(), getParentForChildren(), isClean());
        importTime_ = null;
      }
      return importTimeBuilder_;
    }

    private java.lang.Object importFailureReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The root cause of an import failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The importFailureReason.
     */
    public java.lang.String getImportFailureReason() {
      java.lang.Object ref = importFailureReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        importFailureReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of an import failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for importFailureReason.
     */
    public com.google.protobuf.ByteString getImportFailureReasonBytes() {
      java.lang.Object ref = importFailureReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        importFailureReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of an import failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The importFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setImportFailureReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      importFailureReason_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of an import failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportFailureReason() {

      importFailureReason_ = getDefaultInstance().getImportFailureReason();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of an import failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for importFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setImportFailureReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      importFailureReason_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.ExternalProtectionLevelOptions externalProtectionLevelOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.ExternalProtectionLevelOptions,
            com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder,
            com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder>
        externalProtectionLevelOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     *
     * @return Whether the externalProtectionLevelOptions field is set.
     */
    public boolean hasExternalProtectionLevelOptions() {
      return externalProtectionLevelOptionsBuilder_ != null
          || externalProtectionLevelOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     *
     * @return The externalProtectionLevelOptions.
     */
    public com.google.cloud.kms.v1.ExternalProtectionLevelOptions
        getExternalProtectionLevelOptions() {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        return externalProtectionLevelOptions_ == null
            ? com.google.cloud.kms.v1.ExternalProtectionLevelOptions.getDefaultInstance()
            : externalProtectionLevelOptions_;
      } else {
        return externalProtectionLevelOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public Builder setExternalProtectionLevelOptions(
        com.google.cloud.kms.v1.ExternalProtectionLevelOptions value) {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        externalProtectionLevelOptions_ = value;
        onChanged();
      } else {
        externalProtectionLevelOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public Builder setExternalProtectionLevelOptions(
        com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder builderForValue) {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        externalProtectionLevelOptions_ = builderForValue.build();
        onChanged();
      } else {
        externalProtectionLevelOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public Builder mergeExternalProtectionLevelOptions(
        com.google.cloud.kms.v1.ExternalProtectionLevelOptions value) {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        if (externalProtectionLevelOptions_ != null) {
          externalProtectionLevelOptions_ =
              com.google.cloud.kms.v1.ExternalProtectionLevelOptions.newBuilder(
                      externalProtectionLevelOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          externalProtectionLevelOptions_ = value;
        }
        onChanged();
      } else {
        externalProtectionLevelOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public Builder clearExternalProtectionLevelOptions() {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        externalProtectionLevelOptions_ = null;
        onChanged();
      } else {
        externalProtectionLevelOptions_ = null;
        externalProtectionLevelOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder
        getExternalProtectionLevelOptionsBuilder() {

      onChanged();
      return getExternalProtectionLevelOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder
        getExternalProtectionLevelOptionsOrBuilder() {
      if (externalProtectionLevelOptionsBuilder_ != null) {
        return externalProtectionLevelOptionsBuilder_.getMessageOrBuilder();
      } else {
        return externalProtectionLevelOptions_ == null
            ? com.google.cloud.kms.v1.ExternalProtectionLevelOptions.getDefaultInstance()
            : externalProtectionLevelOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.ExternalProtectionLevelOptions,
            com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder,
            com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder>
        getExternalProtectionLevelOptionsFieldBuilder() {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        externalProtectionLevelOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.ExternalProtectionLevelOptions,
                com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder,
                com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder>(
                getExternalProtectionLevelOptions(), getParentForChildren(), isClean());
        externalProtectionLevelOptions_ = null;
      }
      return externalProtectionLevelOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.CryptoKeyVersion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.CryptoKeyVersion)
  private static final com.google.cloud.kms.v1.CryptoKeyVersion DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.CryptoKeyVersion();
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CryptoKeyVersion> PARSER =
      new com.google.protobuf.AbstractParser<CryptoKeyVersion>() {
        @java.lang.Override
        public CryptoKeyVersion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CryptoKeyVersion(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CryptoKeyVersion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CryptoKeyVersion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
