# About xUnit.net

[<img align="right" width="100px" src="https://raw.githubusercontent.com/xunit/media/main/dotnet-foundation.svg" />](https://dotnetfoundation.org/projects/project-detail/xunit)

xUnit.net is a free, open source, community-focused unit testing tool for the .NET Framework. Written by the original inventor of NUnit v2, xUnit.net is the latest technology for unit testing C#, F#, VB.NET and other .NET languages. xUnit.net works with Visual Studio, Visual Studio Code, ReSharper, CodeRush, and TestDriven.NET. It is part of the [.NET Foundation](https://www.dotnetfoundation.org/), and operates under their [code of conduct](https://www.dotnetfoundation.org/code-of-conduct). It is licensed under [Apache 2](https://opensource.org/licenses/Apache-2.0) (an OSI approved license).

For project documentation, please visit the [xUnit.net project home](https://xunit.net/).

* _New to xUnit.net? Get started with [.NET Framework](https://xunit.net/docs/getting-started/netfx/visual-studio) and [.NET Core](https://xunit.net/docs/getting-started/netcore/cmdline)._
* _Need some help building the source? See [BUILDING.md](https://github.com/xunit/xunit/tree/v2/BUILDING.md)._
* _Want to contribute to the project? See [CONTRIBUTING.md](https://github.com/xunit/.github/tree/main/CONTRIBUTING.md)._
* _Want to contribute to the assertion library? See the [suggested contribution workflow](https://github.com/xunit/assert.xunit/tree/main/README.md#suggested-contribution-workflow) in the assertion library project, as it is slightly more complex due to code being spread across two GitHub repositories._

[<img src="https://raw.github.com/xunit/media/main/powered-by-ndepend-transparent.png" title="Powered by NDepend" width="142" />](http://www.ndepend.com/)

## Latest Builds

<table>
  <thead>
    <tr>
      <th></th>
      <th>Stable</th>
      <th>Latest prerelease</th>
      <th>Latest CI</th>
      <th>CI status</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>v2 core framework</th>
      <td><a href="https://www.nuget.org/packages/xunit"><img src="https://img.shields.io/nuget/v/xunit.svg?logo=nuget"></a></td>
      <td><a href="https://www.nuget.org/packages/xunit/absoluteLatest"><img src="https://img.shields.io/nuget/vpre/xunit.svg?logo=nuget"></td>
      <td><a href="https://myget.org/feed/xunit/package/nuget/xunit"><img src="https://img.shields.io/myget/xunit/vpre/xunit.svg?label=myget&amp;logo=nuget"></td>
      <td><a href="https://actions-badge.atrox.dev/xunit/xunit/goto?ref=v2"><img src="https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fxunit%2Fxunit%2Fbadge%3Fref%3Dv2&amp;label=build"></td>
    <tr>
    <tr>
      <th>v3 core framework (<a href="https://xunit.net/docs/v3-alpha">alpha docs</a>)</th>
      <td>N/A</td>
      <td>N/A</td>
      <td><a href="https://myget.org/feed/xunit/package/nuget/xunit.v3"><img src="https://img.shields.io/myget/xunit/vpre/xunit.v3.svg?label=myget&amp;logo=nuget"></td>
      <td><a href="https://actions-badge.atrox.dev/xunit/xunit/goto?ref=main"><img src="https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fxunit%2Fxunit%2Fbadge%3Fref%3Dmain&amp;label=build"></td>
    <tr>
    <tr>
      <th>xunit.analyzers</th>
      <td><a href="https://www.nuget.org/packages/xunit.analyzers"><img src="https://img.shields.io/nuget/v/xunit.analyzers.svg?logo=nuget"></a></td>
      <td><a href="https://www.nuget.org/packages/xunit.analyzers/absoluteLatest"><img src="https://img.shields.io/nuget/vpre/xunit.analyzers.svg?logo=nuget"></a></td>
      <td><a href="https://myget.org/feed/xunit/package/nuget/xunit.analyzers"><img src="https://img.shields.io/myget/xunit/vpre/xunit.analyzers.svg?label=myget&amp;logo=nuget"></a></td>
      <td><a href="https://actions-badge.atrox.dev/xunit/xunit.analyzers/goto?ref=main"><img src="https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fxunit%2Fxunit.analyzers%2Fbadge%3Fref%3Dmain&amp;label=build"></a></td>
    </tr>
    <tr>
      <th>xunit.runner.visualstudio</th>
      <td><a href="https://www.nuget.org/packages/xunit.runner.visualstudio"><img src="https://img.shields.io/nuget/v/xunit.runner.visualstudio.svg?logo=nuget"></a></td>
      <td><a href="https://www.nuget.org/packages/xunit.runner.visualstudio/absoluteLatest"><img src="https://img.shields.io/nuget/vpre/xunit.runner.visualstudio.svg?logo=nuget"></a></td>
      <td><a href="https://myget.org/feed/xunit/package/nuget/xunit.runner.visualstudio"><img src="https://img.shields.io/myget/xunit/vpre/xunit.runner.visualstudio.svg?label=myget&amp;logo=nuget"></a></td>
      <td><a href="https://actions-badge.atrox.dev/xunit/xunit.runner.visualstudio/goto?ref=main"><img src="https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fxunit%2Fvisualstudio.xunit%2Fbadge%3Fref%3Dmain&amp;label=build"></a></td>
    </tr>
  </tbody>
</table>

*For complete CI package lists, please visit the [MyGet gallery](https://www.myget.org/gallery/xunit/).*
