---
layout: default
title: API Documentation
---

<div class="row">
<div class="col-sm-3" >
  <div data-spy="affix" data-offset-top="0" data-offset-bottom="0" markdown="1">
 
 * Some TOC
 {:toc}
 
  </div>
</div>

<div class="doc-body col-sm-9" markdown="1">

<p class="title h1">API Documentation</p>

# Sending Data

You can send your OpenTSDB data to Bosun. Bosun will index the data for
its search feature, then relay the data to OpenTSDB. We recommend using
[tsdbrelay](https://godoc.org/bosun.org/cmd/tsdbrelay) instead of directly
sending to Bosun, as tsdbrelay will continue to send data if Bosun is
restarting or down for any reason.

### /api/put

Sending data to Bosun is done by treating your bosun host exactly
like an OpenTSDB host. That is, POST to `/api/put` with formats described at
[http://opentsdb.net/docs/build/html/api_http/put.html](http://opentsdb.net/docs/build/html/api_http/put.html).
This data will be relayed to your OpenTSDB host.

Data sent to this route will be indexed by Bosun for searching and autocomplete
if it is typed correctly (for example, timestamp must be a number). [Full
JSON description.](http://godoc.org/bosun.org/opentsdb#DataPoint)

### /api/index

Only perform search indexing; do not relay to OpenTSDB. Accepts in same
format as `/api/put`.

## Metadata

Metadata (units, gauge/rate/counter, description, etc.) can be POST'd to the `/api/metadata/put` endpoint, with the request body as a JSON list of objects. The objects have the following properties:

* **Metric** (string, optional): metric name
* **Tags** (object, optional): key=value tag pairs
* **Name** (string): metadata key name, for example: `desc`, `rate`, `unit`
* **Value** (string): metadata value

For example, to set the rate and unit of various metrics:

```
[
  {"Metric":"win.disk.spltio","Name":"unit","Value":"per second"},
  {"Metric":"linux.mem.drop_pagecache","Name":"rate","Value":"counter"}
]
```

### rate

To send metric rate information (used to specify if a metric is a gauge, rate, or counter), use `rate` as the Name and `gauge`, `rate`, or `counter` as the Value. Tags should be omitted.

### unit

To send metric unit information (used to specify a metric's units), use `unit` as the Name and the unit value as Value (for example, `bytes`, `per second`). Tags should be omitted.

# Querying Data

Most endpoints support both GET and POST requests. Listed parameters may be
specified as either URL parameters for GETs, or body parameters for POSTs. Any
base64-encoded data should be encoded using the standard (not URL) encoding
(and, thus, must be then URL-encoded).

## Search Endpoints

All Search endpoints return a sorted json array. The search data is populated by
observing data that has been relayed through the instance of bosun.

### /api/host

Returns dashboard-ready data for all hosts.

### /api/metric

Returns the metrics that have been relayed through bosun.

### /api/metric/tagkey

Returns the metrics that have been relayed through bosun and their associated tag keys.

### /api/metric/{tagk}/{tagv}

Returns the metrics that are available for the specified tagk/tagv pair. For
example, you can see what metrics are available for host=server01.

### /api/tagk/{metric}

Get all the available tagks that exist for the specified metric

### /api/tagv/{tagk}

Get all the available tagvs for the specified tagk

### /api/tagv/{tagk}/{metric}

Get all the available tagvs for the specific tagk and metric combination. You
can optionally add a query string of tagk=tagv pairs to filter it even more. For
example: `/api/tagv/iface/os.net.bytes?host=server01&direction=in`

### /api/metadata/get

Get latest values of all metadata. Optional parameters:

* **metric**: filter by metric name. Ex: `/api/metadata/get?metric=os.cpu`.
* **tagk** and **tagv** pairs: filter by tag values; must be correctly paired;
many supported. Ex: `/api/metadata/get?tagk=key1&tagv=val1&tagk=key2&tagv=val2`.

### /api/metadata/metrics

Get unit, type (rate, gauge, counter) and description information for metrics.

## Expression, Rule, and Graph Endpoints

### /api/expr?q={expression}

The expression endpoint takes a URL-encoded bosun expression expression and
returns the results and OpenTSDB queries. The results includes a breakdown of
the computations involved in the expression, the result or value, and the group
(OpenTSDB's tagset) of the expression. The queries are the [OpenTSDB
requests](http://godoc.org/opentsdb#Request)
generated by the query.

### /api/egraph/{expression}.svg?[autods=true][&now=timestamp]

Returns an SVG graph of the base64-encoded expression. `autods` may be set to
enable auto downsampling. `now` can be set to a Unix timestamp in seconds to set
the time of the expression (defaults to now).

### /api/graph

Graphing endpoint. Examine a request for details.

### /api/rule

Test execution for rules. Can execute at various times and intervals, output
templates, and send test emails. Example a request for details.

## Dashboard Endpoints

### /api/action

Used to acknowledge, close, or forget alerts. Examine a request for details.

### /api/alerts?[filter=filter]

Returns a list of alert summaries matching the given filter (defaults to all).

### /api/health

Returns an object of internal health checks. True values are good, falses are
bad.

### /api/run

Runs a rule check. Returns an error if one is already running (either from the
web interface or the normal scheduled check).

### /api/silence/clear

Reads the `id` field of the JSON object passed in the POST body and removes that
silence.

### /api/silence/get

Returns all silences.

### /api/silence/set

Tests or sets a silence. Examine a request for details.

### /api/status?[ak=key][&ak=key]

Returns details about the given alert keys.

### /api/templates

Returns data about alerts, templates, and their relations.

## Configuration Endpoints

### /api/backup

Returns the state file for backup. The state file is guaranteed to be in a
consistent state. This route is implemented by creating an in-memory copy
of the state file, then streaming that to the response, so as to not block
writes to the state file by other parts of bosun.

### /api/config

Returns the current configuration that bosun is loaded with as text.

### /api/config_test

Reads a configuration file from the POST body then checks it for for syntax
errors. Returns an error if invalid.

</div>
</div>
