---
id: studio-interface
title: Studio Interface
---

--------------------

:::note
Selecting a bot brings you to the Conversation Studio.
:::

The Conversation Studio allows you to:
- create a new flow for a new chatbot;
- refine the natural language understanding;
- edit the conversational flow after testing it;
- manage everything related to your conversational design;
- train a NLU model;
- test and debug your chatbot;
- and so much more.

![conversation-studio-intro](/assets/conversation-studio-intro.png)

## Flows

The **Flows** page helps you create a conversational flow with a user-friendly interface.

## Content Management

The **Content Management** page lists all the different content types (such as action button, dropdown, text, etc.) and the content that you added.

:::note
You can modify the content directly in the **Content Management** page instead of the **Flows** page.
:::

## Natural Language Understanding

The **Natural Language Understanding** page allows you to add intents, entities and their slots.

## Q&A

The **Q&A** page allows you to add frequently asked questions and their answers.

## Libraries

The **Libraries** page allows you to import your custom code by using hooks and actions.

## Analytics

The **Analytics** page displays dashboards that contains analytics information gathered in the conversations with users.

## Bot Improvement

The **Bot Improvement** page allows you to manage the negative feedbacks given by the users and use them to improve your chatbot.

## Broadcast

The **Broadcast** page allows you to send information to a large amount of people.

## Code Editor

The **Code Editor** page allows you to create and edit actions, hooks, libraries, configurations, and module configurations without leaving the Botpress Conversation Studio.

## HITL

:::note
This is the older version of HITL Next.
:::

The **HITL** page allows you to integrate human in the loop of the conversation when a human intervention is needed. 

## HITL Next

:::note
This is an improved version of HITL.
:::

The **HITL Next** page allows you to integrate human in the loop of the conversation when a human intervention is needed.

## Misunderstood

The **Misunderstood** page lists what the user wrote that triggered the error-handling flow or when they send the negative comments about the Q&A.

## Testings

The **Testings** page allows you to create conversation scenarios to ensure the bot keep its good behaviour whether the scenario. Those are unit tests.

## Config

The **Config** page displays the available bot configurations split in 3 sections: General, Additional Details, and Avatar & Cover Picture.