# [Botpress](https://botpress.com/?utm_source=github&utm_medium=organic&utm_campaign=botpress_repo&utm_term=readme) — The building blocks for building chatbots

**IMPORTANT**: With the launch of Botpress Cloud, the documentation for Botpress v12 can now be found [here](https://v12.botpress.com/). 

## What is Botpress?

Botpress is the standard developer stack to build, run, and improve conversational AI applications. Powered by natural language understanding, a messaging API, and a fully featured studio, Botpress allows developers and conversation designers around the globe to build remarkable chatbots without compromise.

The fastest & easiest way to get started with Botpress is by signing up for free to **[Botpress Cloud](https://sso.botpress.cloud/registration)**. Alternatively, continue reading for more information about Botpress v12.

<a href='https://botpress.com/?utm_source=github&utm_medium=organic&utm_campaign=botpress_repo&utm_term=readme'><img src='.github/assets/studio.png'></a>

**Out of the box, Botpress v12 includes:**

- Administration panel to orchestrate and monitor your chatbots
- Conversation Studio to design a conversation, manage content, code custom integration
- Easy integration with messaging channels (Messenger, WhatsApp, Slack, Teams, Webchat, Telegram, SMS & more)
- Natural Language Understanding
- Complete list of features and specs [here](https://v12.botpress.com/overview/features)

## Getting Started

There are a few ways to get started with Botpress v12:

- Download the latest binary for your OS [here](https://v12.botpress.com/) and follow the [installation docs](https://v12.botpress.com/overview/quickstart/installation).
- Use the official [Docker image](https://hub.docker.com/r/botpress/server) and follow the [hosting docs](https://v12.botpress.com/going-to-production/deploy/docker-compose)
- Run from sources, follow [build docs](https://v12.botpress.com/going-to-production/deploy/)
- Deploy it in the cloud using these shortlinks:

  <center>
      <hr/>
      <a href="https://marketplace.digitalocean.com/apps/botpress" class="btn btn-default btn-lg">
              <img src=".github/do_button.svg">
      </a>  &nbsp;
      <a href="https://labs.play-with-docker.com?stack=https://raw.githubusercontent.com/botpress/botpress/master/examples/docker-compose/docker-compose.yml" class="btn btn-default btn-lg">
        <img src="https://cdn.jsdelivr.net/gh/play-with-docker/stacks@cff22438/assets/images/button.png">
      </a> &nbsp;
  </center>

## Documentation

- [Main Documentation](https://v12.botpress.com/)
- [SDK Reference](https://botpress.com/reference/)
- [Code Examples](https://github.com/botpress/botpress/tree/master/examples)
- [Video Tutorials](https://www.youtube.com/c/botpress)

## Community

- [v12 Forum](https://github.com/botpress/botpress/discussions) - Get community support and find answers to your questions
- [Issues](https://github.com/botpress/botpress/issues) - Report bugs and file feature requests
- [Blog](https://botpress.com/blog) - How to's, case studies, and announcements
- [Contributing](/.github/CONTRIBUTING.md) - Start contributing to Botpress
- [Partners](/.github/PARTNERS.md) - List of agencies who can help you with Botpress

## License

Botpress is dual-licensed under [AGPLv3](/licenses/LICENSE_AGPL3) and the [Botpress Proprietary License](/licenses/LICENSE_BOTPRESS).

By default, any bot created with Botpress is licensed under AGPLv3, but you may change to the Botpress License from within your bot's web interface in a few clicks.

For more information about how the dual-license works and why it works that way, please see the <a href="https://botpress.com/faq">FAQS</a>.

![](https://api.segment.io/v1/pixel/page?data=eyJ3cml0ZUtleSI6InczR0xQaGFwY1RqTjdZVnJZQVFYU05Wam9yVUFNOXBmIiwidXNlcklkIjoiYW5vbnltb3VzIn0=)
