/**
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { OAuth2Client, JWT, Compute, UserRefreshClient } from 'google-auth-library';
import { GoogleConfigurable, MethodOptions, GlobalOptions, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { GaxiosPromise } from 'gaxios';
export declare namespace language_v1beta1 {
    export interface Options extends GlobalOptions {
        version: 'v1beta1';
    }
    interface StandardParameters {
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Cloud Natural Language API
     *
     * Provides natural language understanding technologies, such as sentiment analysis, entity recognition, entity sentiment analysis, and other text annotations, to developers.
     *
     * @example
     * const {google} = require('googleapis');
     * const language = google.language('v1beta1');
     *
     * @namespace language
     * @type {Function}
     * @version v1beta1
     * @variation v1beta1
     * @param {object=} options Options for Language
     */
    export class Language {
        context: APIRequestContext;
        documents: Resource$Documents;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * The entity analysis request message.
     */
    export interface Schema$AnalyzeEntitiesRequest {
        /**
         * Input document.
         */
        document?: Schema$Document;
        /**
         * The encoding type used by the API to calculate offsets.
         */
        encodingType?: string;
    }
    /**
     * The entity analysis response message.
     */
    export interface Schema$AnalyzeEntitiesResponse {
        /**
         * The recognized entities in the input document.
         */
        entities?: Schema$Entity[];
        /**
         * The language of the text, which will be the same as the language specified in the request or, if not specified, the automatically-detected language. See Document.language field for more details.
         */
        language?: string;
    }
    /**
     * The sentiment analysis request message.
     */
    export interface Schema$AnalyzeSentimentRequest {
        /**
         * Input document.
         */
        document?: Schema$Document;
        /**
         * The encoding type used by the API to calculate sentence offsets for the sentence sentiment.
         */
        encodingType?: string;
    }
    /**
     * The sentiment analysis response message.
     */
    export interface Schema$AnalyzeSentimentResponse {
        /**
         * The overall sentiment of the input document.
         */
        documentSentiment?: Schema$Sentiment;
        /**
         * The language of the text, which will be the same as the language specified in the request or, if not specified, the automatically-detected language. See Document.language field for more details.
         */
        language?: string;
        /**
         * The sentiment for all the sentences in the document.
         */
        sentences?: Schema$Sentence[];
    }
    /**
     * The syntax analysis request message.
     */
    export interface Schema$AnalyzeSyntaxRequest {
        /**
         * Input document.
         */
        document?: Schema$Document;
        /**
         * The encoding type used by the API to calculate offsets.
         */
        encodingType?: string;
    }
    /**
     * The syntax analysis response message.
     */
    export interface Schema$AnalyzeSyntaxResponse {
        /**
         * The language of the text, which will be the same as the language specified in the request or, if not specified, the automatically-detected language. See Document.language field for more details.
         */
        language?: string;
        /**
         * Sentences in the input document.
         */
        sentences?: Schema$Sentence[];
        /**
         * Tokens, along with their syntactic information, in the input document.
         */
        tokens?: Schema$Token[];
    }
    /**
     * The request message for the text annotation API, which can perform multiple analysis types (sentiment, entities, and syntax) in one call.
     */
    export interface Schema$AnnotateTextRequest {
        /**
         * Input document.
         */
        document?: Schema$Document;
        /**
         * The encoding type used by the API to calculate offsets.
         */
        encodingType?: string;
        /**
         * The enabled features.
         */
        features?: Schema$Features;
    }
    /**
     * The text annotations response message.
     */
    export interface Schema$AnnotateTextResponse {
        /**
         * The overall sentiment for the document. Populated if the user enables AnnotateTextRequest.Features.extract_document_sentiment.
         */
        documentSentiment?: Schema$Sentiment;
        /**
         * Entities, along with their semantic information, in the input document. Populated if the user enables AnnotateTextRequest.Features.extract_entities.
         */
        entities?: Schema$Entity[];
        /**
         * The language of the text, which will be the same as the language specified in the request or, if not specified, the automatically-detected language. See Document.language field for more details.
         */
        language?: string;
        /**
         * Sentences in the input document. Populated if the user enables AnnotateTextRequest.Features.extract_syntax.
         */
        sentences?: Schema$Sentence[];
        /**
         * Tokens, along with their syntactic information, in the input document. Populated if the user enables AnnotateTextRequest.Features.extract_syntax.
         */
        tokens?: Schema$Token[];
    }
    /**
     * Represents dependency parse tree information for a token.
     */
    export interface Schema$DependencyEdge {
        /**
         * Represents the head of this token in the dependency tree. This is the index of the token which has an arc going to this token. The index is the position of the token in the array of tokens returned by the API method. If this token is a root token, then the `head_token_index` is its own index.
         */
        headTokenIndex?: number;
        /**
         * The parse label for the token.
         */
        label?: string;
    }
    /**
     * ################################################################ #  Represents the input to API methods.
     */
    export interface Schema$Document {
        /**
         * The content of the input in string format. Cloud audit logging exempt since it is based on user data.
         */
        content?: string;
        /**
         * The Google Cloud Storage URI where the file content is located. This URI must be of the form: gs://bucket_name/object_name. For more details, see https://cloud.google.com/storage/docs/reference-uris. NOTE: Cloud Storage object versioning is not supported.
         */
        gcsContentUri?: string;
        /**
         * The language of the document (if not specified, the language is automatically detected). Both ISO and BCP-47 language codes are accepted.&lt;br&gt; [Language Support](/natural-language/docs/languages) lists currently supported languages for each API method. If the language (either specified by the caller or automatically detected) is not supported by the called API method, an `INVALID_ARGUMENT` error is returned.
         */
        language?: string;
        /**
         * Required. If the type is not set or is `TYPE_UNSPECIFIED`, returns an `INVALID_ARGUMENT` error.
         */
        type?: string;
    }
    /**
     * Represents a phrase in the text that is a known entity, such as a person, an organization, or location. The API associates information, such as salience and mentions, with entities.
     */
    export interface Schema$Entity {
        /**
         * The mentions of this entity in the input document. The API currently supports proper noun mentions.
         */
        mentions?: Schema$EntityMention[];
        /**
         * Metadata associated with the entity.  Currently, Wikipedia URLs and Knowledge Graph MIDs are provided, if available. The associated keys are &quot;wikipedia_url&quot; and &quot;mid&quot;, respectively.
         */
        metadata?: {
            [key: string]: string;
        };
        /**
         * The representative name for the entity.
         */
        name?: string;
        /**
         * The salience score associated with the entity in the [0, 1.0] range.  The salience score for an entity provides information about the importance or centrality of that entity to the entire document text. Scores closer to 0 are less salient, while scores closer to 1.0 are highly salient.
         */
        salience?: number;
        /**
         * The entity type.
         */
        type?: string;
    }
    /**
     * Represents a mention for an entity in the text. Currently, proper noun mentions are supported.
     */
    export interface Schema$EntityMention {
        /**
         * The mention text.
         */
        text?: Schema$TextSpan;
        /**
         * The type of the entity mention.
         */
        type?: string;
    }
    /**
     * All available features for sentiment, syntax, and semantic analysis. Setting each one to true will enable that specific analysis for the input.
     */
    export interface Schema$Features {
        /**
         * Extract document-level sentiment.
         */
        extractDocumentSentiment?: boolean;
        /**
         * Extract entities.
         */
        extractEntities?: boolean;
        /**
         * Extract syntax information.
         */
        extractSyntax?: boolean;
    }
    /**
     * Represents part of speech information for a token.
     */
    export interface Schema$PartOfSpeech {
        /**
         * The grammatical aspect.
         */
        aspect?: string;
        /**
         * The grammatical case.
         */
        case?: string;
        /**
         * The grammatical form.
         */
        form?: string;
        /**
         * The grammatical gender.
         */
        gender?: string;
        /**
         * The grammatical mood.
         */
        mood?: string;
        /**
         * The grammatical number.
         */
        number?: string;
        /**
         * The grammatical person.
         */
        person?: string;
        /**
         * The grammatical properness.
         */
        proper?: string;
        /**
         * The grammatical reciprocity.
         */
        reciprocity?: string;
        /**
         * The part of speech tag.
         */
        tag?: string;
        /**
         * The grammatical tense.
         */
        tense?: string;
        /**
         * The grammatical voice.
         */
        voice?: string;
    }
    /**
     * Represents a sentence in the input document.
     */
    export interface Schema$Sentence {
        /**
         * For calls to AnalyzeSentiment or if AnnotateTextRequest.Features.extract_document_sentiment is set to true, this field will contain the sentiment for the sentence.
         */
        sentiment?: Schema$Sentiment;
        /**
         * The sentence text.
         */
        text?: Schema$TextSpan;
    }
    /**
     * Represents the feeling associated with the entire text or entities in the text.
     */
    export interface Schema$Sentiment {
        /**
         * A non-negative number in the [0, +inf) range, which represents the absolute magnitude of sentiment regardless of score (positive or negative).
         */
        magnitude?: number;
        /**
         * DEPRECATED FIELD - This field is being deprecated in favor of score. Please refer to our documentation at https://cloud.google.com/natural-language/docs for more information.
         */
        polarity?: number;
        /**
         * Sentiment score between -1.0 (negative sentiment) and 1.0 (positive sentiment).
         */
        score?: number;
    }
    /**
     * The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details.  You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
     */
    export interface Schema$Status {
        /**
         * The status code, which should be an enum value of google.rpc.Code.
         */
        code?: number;
        /**
         * A list of messages that carry the error details.  There is a common set of message types for APIs to use.
         */
        details?: Array<{
            [key: string]: any;
        }>;
        /**
         * A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
         */
        message?: string;
    }
    /**
     * Represents an output piece of text.
     */
    export interface Schema$TextSpan {
        /**
         * The API calculates the beginning offset of the content in the original document according to the EncodingType specified in the API request.
         */
        beginOffset?: number;
        /**
         * The content of the output text.
         */
        content?: string;
    }
    /**
     * Represents the smallest syntactic building block of the text.
     */
    export interface Schema$Token {
        /**
         * Dependency tree parse for this token.
         */
        dependencyEdge?: Schema$DependencyEdge;
        /**
         * [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
         */
        lemma?: string;
        /**
         * Parts of speech tag for this token.
         */
        partOfSpeech?: Schema$PartOfSpeech;
        /**
         * The token text.
         */
        text?: Schema$TextSpan;
    }
    export class Resource$Documents {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * language.documents.analyzeEntities
         * @desc Finds named entities (currently proper names and common nouns) in the text along with entity types, salience, mentions for each entity, and other properties.
         * @alias language.documents.analyzeEntities
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {().AnalyzeEntitiesRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        analyzeEntities(params?: Params$Resource$Documents$Analyzeentities, options?: MethodOptions): GaxiosPromise<Schema$AnalyzeEntitiesResponse>;
        analyzeEntities(params: Params$Resource$Documents$Analyzeentities, options: MethodOptions | BodyResponseCallback<Schema$AnalyzeEntitiesResponse>, callback: BodyResponseCallback<Schema$AnalyzeEntitiesResponse>): void;
        analyzeEntities(params: Params$Resource$Documents$Analyzeentities, callback: BodyResponseCallback<Schema$AnalyzeEntitiesResponse>): void;
        analyzeEntities(callback: BodyResponseCallback<Schema$AnalyzeEntitiesResponse>): void;
        /**
         * language.documents.analyzeSentiment
         * @desc Analyzes the sentiment of the provided text.
         * @alias language.documents.analyzeSentiment
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {().AnalyzeSentimentRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        analyzeSentiment(params?: Params$Resource$Documents$Analyzesentiment, options?: MethodOptions): GaxiosPromise<Schema$AnalyzeSentimentResponse>;
        analyzeSentiment(params: Params$Resource$Documents$Analyzesentiment, options: MethodOptions | BodyResponseCallback<Schema$AnalyzeSentimentResponse>, callback: BodyResponseCallback<Schema$AnalyzeSentimentResponse>): void;
        analyzeSentiment(params: Params$Resource$Documents$Analyzesentiment, callback: BodyResponseCallback<Schema$AnalyzeSentimentResponse>): void;
        analyzeSentiment(callback: BodyResponseCallback<Schema$AnalyzeSentimentResponse>): void;
        /**
         * language.documents.analyzeSyntax
         * @desc Analyzes the syntax of the text and provides sentence boundaries and tokenization along with part of speech tags, dependency trees, and other properties.
         * @alias language.documents.analyzeSyntax
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {().AnalyzeSyntaxRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        analyzeSyntax(params?: Params$Resource$Documents$Analyzesyntax, options?: MethodOptions): GaxiosPromise<Schema$AnalyzeSyntaxResponse>;
        analyzeSyntax(params: Params$Resource$Documents$Analyzesyntax, options: MethodOptions | BodyResponseCallback<Schema$AnalyzeSyntaxResponse>, callback: BodyResponseCallback<Schema$AnalyzeSyntaxResponse>): void;
        analyzeSyntax(params: Params$Resource$Documents$Analyzesyntax, callback: BodyResponseCallback<Schema$AnalyzeSyntaxResponse>): void;
        analyzeSyntax(callback: BodyResponseCallback<Schema$AnalyzeSyntaxResponse>): void;
        /**
         * language.documents.annotateText
         * @desc A convenience method that provides all the features that analyzeSentiment, analyzeEntities, and analyzeSyntax provide in one call.
         * @alias language.documents.annotateText
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {().AnnotateTextRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        annotateText(params?: Params$Resource$Documents$Annotatetext, options?: MethodOptions): GaxiosPromise<Schema$AnnotateTextResponse>;
        annotateText(params: Params$Resource$Documents$Annotatetext, options: MethodOptions | BodyResponseCallback<Schema$AnnotateTextResponse>, callback: BodyResponseCallback<Schema$AnnotateTextResponse>): void;
        annotateText(params: Params$Resource$Documents$Annotatetext, callback: BodyResponseCallback<Schema$AnnotateTextResponse>): void;
        annotateText(callback: BodyResponseCallback<Schema$AnnotateTextResponse>): void;
    }
    export interface Params$Resource$Documents$Analyzeentities extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Request body metadata
         */
        requestBody?: Schema$AnalyzeEntitiesRequest;
    }
    export interface Params$Resource$Documents$Analyzesentiment extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Request body metadata
         */
        requestBody?: Schema$AnalyzeSentimentRequest;
    }
    export interface Params$Resource$Documents$Analyzesyntax extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Request body metadata
         */
        requestBody?: Schema$AnalyzeSyntaxRequest;
    }
    export interface Params$Resource$Documents$Annotatetext extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Request body metadata
         */
        requestBody?: Schema$AnnotateTextRequest;
    }
    export {};
}
