/**
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { OAuth2Client, JWT, UserRefreshClient } from 'google-auth-library';
import { GoogleConfigurable, MethodOptions, GlobalOptions, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { GaxiosPromise } from 'gaxios';
export declare namespace compute_v1 {
    export interface Options extends GlobalOptions {
        version: 'v1';
    }
    interface StandardParameters {
        /**
         * Data format for the response.
         */
        alt?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * An opaque string that represents a user for quota purposes. Must not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Deprecated. Please use quotaUser instead.
         */
        userIp?: string;
    }
    /**
     * Compute Engine API
     *
     * Creates and runs virtual machines on Google Cloud Platform.
     *
     * @example
     * const {google} = require('googleapis');
     * const compute = google.compute('v1');
     *
     * @namespace compute
     * @type {Function}
     * @version v1
     * @variation v1
     * @param {object=} options Options for Compute
     */
    export class Compute {
        context: APIRequestContext;
        acceleratorTypes: Resource$Acceleratortypes;
        addresses: Resource$Addresses;
        autoscalers: Resource$Autoscalers;
        backendBuckets: Resource$Backendbuckets;
        backendServices: Resource$Backendservices;
        disks: Resource$Disks;
        diskTypes: Resource$Disktypes;
        externalVpnGateways: Resource$Externalvpngateways;
        firewalls: Resource$Firewalls;
        forwardingRules: Resource$Forwardingrules;
        globalAddresses: Resource$Globaladdresses;
        globalForwardingRules: Resource$Globalforwardingrules;
        globalOperations: Resource$Globaloperations;
        healthChecks: Resource$Healthchecks;
        httpHealthChecks: Resource$Httphealthchecks;
        httpsHealthChecks: Resource$Httpshealthchecks;
        images: Resource$Images;
        instanceGroupManagers: Resource$Instancegroupmanagers;
        instanceGroups: Resource$Instancegroups;
        instances: Resource$Instances;
        instanceTemplates: Resource$Instancetemplates;
        interconnectAttachments: Resource$Interconnectattachments;
        interconnectLocations: Resource$Interconnectlocations;
        interconnects: Resource$Interconnects;
        licenseCodes: Resource$Licensecodes;
        licenses: Resource$Licenses;
        machineTypes: Resource$Machinetypes;
        networkEndpointGroups: Resource$Networkendpointgroups;
        networks: Resource$Networks;
        nodeGroups: Resource$Nodegroups;
        nodeTemplates: Resource$Nodetemplates;
        nodeTypes: Resource$Nodetypes;
        projects: Resource$Projects;
        regionAutoscalers: Resource$Regionautoscalers;
        regionBackendServices: Resource$Regionbackendservices;
        regionCommitments: Resource$Regioncommitments;
        regionDisks: Resource$Regiondisks;
        regionDiskTypes: Resource$Regiondisktypes;
        regionInstanceGroupManagers: Resource$Regioninstancegroupmanagers;
        regionInstanceGroups: Resource$Regioninstancegroups;
        regionOperations: Resource$Regionoperations;
        regions: Resource$Regions;
        reservations: Resource$Reservations;
        resourcePolicies: Resource$Resourcepolicies;
        routers: Resource$Routers;
        routes: Resource$Routes;
        securityPolicies: Resource$Securitypolicies;
        snapshots: Resource$Snapshots;
        sslCertificates: Resource$Sslcertificates;
        sslPolicies: Resource$Sslpolicies;
        subnetworks: Resource$Subnetworks;
        targetHttpProxies: Resource$Targethttpproxies;
        targetHttpsProxies: Resource$Targethttpsproxies;
        targetInstances: Resource$Targetinstances;
        targetPools: Resource$Targetpools;
        targetSslProxies: Resource$Targetsslproxies;
        targetTcpProxies: Resource$Targettcpproxies;
        targetVpnGateways: Resource$Targetvpngateways;
        urlMaps: Resource$Urlmaps;
        vpnGateways: Resource$Vpngateways;
        vpnTunnels: Resource$Vpntunnels;
        zoneOperations: Resource$Zoneoperations;
        zones: Resource$Zones;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * A specification of the type and number of accelerator cards attached to the instance.
     */
    export interface Schema$AcceleratorConfig {
        /**
         * The number of the guest accelerator cards exposed to this instance.
         */
        acceleratorCount?: number;
        /**
         * Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
         */
        acceleratorType?: string;
    }
    /**
     * Represents an Accelerator Type resource.  Google Cloud Platform provides graphics processing units (accelerators) that you can add to VM instances to improve or accelerate performance when working with intensive workloads. For more information, read GPUs on Compute Engine. (== resource_for beta.acceleratorTypes ==) (== resource_for v1.acceleratorTypes ==)
     */
    export interface Schema$AcceleratorType {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] The deprecation status associated with this accelerator type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional textual description of the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] The type of the resource. Always compute#acceleratorType for accelerator types.
         */
        kind?: string;
        /**
         * [Output Only] Maximum accelerator cards allowed per instance.
         */
        maximumCardsPerInstance?: number;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The name of the zone where the accelerator type resides, such as us-central1-a. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string;
    }
    export interface Schema$AcceleratorTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of AcceleratorTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$AcceleratorTypesScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#acceleratorTypeAggregatedList for aggregated lists of accelerator types.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of accelerator types.
     */
    export interface Schema$AcceleratorTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of AcceleratorType resources.
         */
        items?: Schema$AcceleratorType[];
        /**
         * [Output Only] Type of resource. Always compute#acceleratorTypeList for lists of accelerator types.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$AcceleratorTypesScopedList {
        /**
         * [Output Only] A list of accelerator types contained in this scope.
         */
        acceleratorTypes?: Schema$AcceleratorType[];
        /**
         * [Output Only] An informational warning that appears when the accelerator types list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * An access configuration attached to an instance&#39;s network interface. Only one access config per instance is supported.
     */
    export interface Schema$AccessConfig {
        /**
         * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
         */
        kind?: string;
        /**
         * The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.
         */
        name?: string;
        /**
         * An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
         */
        natIP?: string;
        /**
         * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD.  If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier.  If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
         */
        networkTier?: string;
        /**
         * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled.
         */
        publicPtrDomainName?: string;
        /**
         * Specifies whether a public DNS &#39;PTR&#39; record should be created to map the external IP address of the instance to a DNS domain name.
         */
        setPublicPtr?: boolean;
        /**
         * The type of configuration. The default and only option is ONE_TO_ONE_NAT.
         */
        type?: string;
    }
    /**
     * Represents an IP Address resource.  An address resource represents a regional internal IP address. Regional internal IP addresses are RFC 1918 addresses that come from either a primary or secondary IP range of a subnet in a VPC network. Regional external IP addresses can be assigned to GCP VM instances, Cloud VPN gateways, regional external forwarding rules for network load balancers (in either Standard or Premium Tier), and regional external forwarding rules for HTTP(S), SSL Proxy, and TCP Proxy load balancers in Standard Tier. For more information, read IP addresses.  A globalAddresses resource represent a global external IP address. Global external IP addresses are IPv4 or IPv6 addresses. They can only be assigned to global forwarding rules for HTTP(S), SSL Proxy, or TCP Proxy load balancers in Premium Tier. For more information, read Global resources. (== resource_for beta.addresses ==) (== resource_for v1.addresses ==) (== resource_for beta.globalAddresses ==) (== resource_for v1.globalAddresses ==)
     */
    export interface Schema$Address {
        /**
         * The static IP address represented by this resource.
         */
        address?: string;
        /**
         * The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
         */
        addressType?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * The IP version that will be used by this address. Valid options are IPV4 or IPV6. This can only be specified for a global address.
         */
        ipVersion?: string;
        /**
         * [Output Only] Type of the resource. Always compute#address for addresses.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string;
        /**
         * The URL of the network in which to reserve the address. This field can only be used with INTERNAL type with the VPC_PEERING purpose.
         */
        network?: string;
        /**
         * This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Global forwarding rules can only be Premium Tier. Regional forwarding rules can be either Premium or Standard Tier. Standard Tier addresses applied to regional forwarding rules can be used with any external load balancer. Regional forwarding rules in Premium Tier can only be used with a network load balancer.  If this field is not specified, it is assumed to be PREMIUM.
         */
        networkTier?: string;
        /**
         * The prefix length if the resource reprensents an IP range.
         */
        prefixLength?: number;
        /**
         * The purpose of this resource, which can be one of the following values:   - `GCE_ENDPOINT` for addresses that are used by VM instances, alias IP ranges, internal load balancers, and similar resources.  - `DNS_RESOLVER` for a DNS resolver address in a subnetwork  - `VPC_PEERING` for addresses that are reserved for VPC peer networks.  - `NAT_AUTO` for addresses that are external IP addresses automatically reserved for Cloud NAT.
         */
        purpose?: string;
        /**
         * [Output Only] The URL of the region where the regional address resides. This field is not applicable to global addresses. You must specify this field as part of the HTTP request URL.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
         */
        status?: string;
        /**
         * The URL of the subnetwork in which to reserve the address. If an IP address is specified, it must be within the subnetwork&#39;s IP range. This field can only be used with INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.
         */
        subnetwork?: string;
        /**
         * [Output Only] The URLs of the resources that are using this address.
         */
        users?: string[];
    }
    export interface Schema$AddressAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of AddressesScopedList resources.
         */
        items?: {
            [key: string]: Schema$AddressesScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#addressAggregatedList for aggregated lists of addresses.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$AddressesScopedList {
        /**
         * [Output Only] A list of addresses contained in this scope.
         */
        addresses?: Schema$Address[];
        /**
         * [Output Only] Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of addresses.
     */
    export interface Schema$AddressList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Address resources.
         */
        items?: Schema$Address[];
        /**
         * [Output Only] Type of resource. Always compute#addressList for lists of addresses.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * An alias IP range attached to an instance&#39;s network interface.
     */
    export interface Schema$AliasIpRange {
        /**
         * The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
         */
        ipCidrRange?: string;
        /**
         * The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
         */
        subnetworkRangeName?: string;
    }
    export interface Schema$AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk {
        /**
         * Specifies the size of the disk in base-2 GB.
         */
        diskSizeGb?: string;
        /**
         * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
         */
        interface?: string;
    }
    /**
     * Properties of the SKU instances being reserved.
     */
    export interface Schema$AllocationSpecificSKUAllocationReservedInstanceProperties {
        /**
         * Specifies accelerator type and count.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
         */
        localSsds?: Schema$AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk[];
        /**
         * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
         */
        machineType?: string;
        /**
         * Minimum cpu platform the reservation.
         */
        minCpuPlatform?: string;
    }
    /**
     * This reservation type allows to pre allocate specific instance configuration.
     */
    export interface Schema$AllocationSpecificSKUReservation {
        /**
         * Specifies the number of resources that are allocated.
         */
        count?: string;
        /**
         * The instance properties for the reservation.
         */
        instanceProperties?: Schema$AllocationSpecificSKUAllocationReservedInstanceProperties;
        /**
         * [OutputOnly] Indicates how many instances are in use.
         */
        inUseCount?: string;
    }
    /**
     * An instance-attached disk resource.
     */
    export interface Schema$AttachedDisk {
        /**
         * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
         */
        autoDelete?: boolean;
        /**
         * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
         */
        boot?: boolean;
        /**
         * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance.  If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
         */
        deviceName?: string;
        /**
         * Encrypts or decrypts a disk using a customer-supplied encryption key.  If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key.  If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance.  If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.  Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
         */
        index?: number;
        /**
         * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.  This property is mutually exclusive with the source property; you can only define one or the other, but not both.
         */
        initializeParams?: Schema$AttachedDiskInitializeParams;
        /**
         * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. TODO(b/131765817): Update documentation when NVME is supported.
         */
        interface?: string;
        /**
         * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
         */
        kind?: string;
        /**
         * [Output Only] Any valid publicly visible licenses.
         */
        licenses?: string[];
        /**
         * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
         */
        mode?: string;
        /**
         * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or disks.source is required except for local SSD.  If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks.  Note that for InstanceTemplate, specify the disk name, not the URL for the disk.
         */
        source?: string;
        /**
         * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
         */
        type?: string;
    }
    /**
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.  This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     */
    export interface Schema$AttachedDiskInitializeParams {
        /**
         * An optional description. Provide this property when creating the disk.
         */
        description?: string;
        /**
         * Specifies the disk name. If not specified, the default is to use the name of the instance. If the disk with the instance name exists already in the given zone/region, a new name will be automatically generated.
         */
        diskName?: string;
        /**
         * Specifies the size of the disk in base-2 GB. If not specified, the disk will be the same size as the image (usually 10GB). If specified, the size must be equal to or larger than 10GB.
         */
        diskSizeGb?: string;
        /**
         * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard   Other values include pd-ssd and local-ssd. If you define this field, you can provide either the full or partial URL. For example, the following are valid values:   - https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType  - projects/project/zones/zone/diskTypes/diskType  - zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this is the name of the disk type, not URL.
         */
        diskType?: string;
        /**
         * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
         */
        resourcePolicies?: string[];
        /**
         * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or disks.source is required except for local SSD.  To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9   Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD   To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image   You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family   If the source image is deleted later, this field will not be set.
         */
        sourceImage?: string;
        /**
         * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.  Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
         */
        sourceImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or disks.source is required except for local SSD.  To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup   If the source snapshot is deleted later, this field will not be set.
         */
        sourceSnapshot?: string;
        /**
         * The customer-supplied encryption key of the source snapshot.
         */
        sourceSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
    }
    /**
     * Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted.  Example Policy with multiple AuditConfigs:  { &quot;audit_configs&quot;: [ { &quot;service&quot;: &quot;allServices&quot; &quot;audit_log_configs&quot;: [ { &quot;log_type&quot;: &quot;DATA_READ&quot;, &quot;exempted_members&quot;: [ &quot;user:jose@example.com&quot; ] }, { &quot;log_type&quot;: &quot;DATA_WRITE&quot;, }, { &quot;log_type&quot;: &quot;ADMIN_READ&quot;, } ] }, { &quot;service&quot;: &quot;sampleservice.googleapis.com&quot; &quot;audit_log_configs&quot;: [ { &quot;log_type&quot;: &quot;DATA_READ&quot;, }, { &quot;log_type&quot;: &quot;DATA_WRITE&quot;, &quot;exempted_members&quot;: [ &quot;user:aliya@example.com&quot; ] } ] } ] }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
     */
    export interface Schema$AuditConfig {
        /**
         * The configuration for logging of each type of permission.
         */
        auditLogConfigs?: Schema$AuditLogConfig[];
        exemptedMembers?: string[];
        /**
         * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
         */
        service?: string;
    }
    /**
     * Provides the configuration for logging a type of permissions. Example:  { &quot;audit_log_configs&quot;: [ { &quot;log_type&quot;: &quot;DATA_READ&quot;, &quot;exempted_members&quot;: [ &quot;user:jose@example.com&quot; ] }, { &quot;log_type&quot;: &quot;DATA_WRITE&quot;, } ] }  This enables &#39;DATA_READ&#39; and &#39;DATA_WRITE&#39; logging, while exempting jose@example.com from DATA_READ logging.
     */
    export interface Schema$AuditLogConfig {
        /**
         * Specifies the identities that do not cause logging for this type of permission. Follows the same format of [Binding.members][].
         */
        exemptedMembers?: string[];
        /**
         * Specifies whether principals can be exempted for the same LogType in lower-level resource policies. If true, any lower-level exemptions will be ignored.
         */
        ignoreChildExemptions?: boolean;
        /**
         * The log type that this config enables.
         */
        logType?: string;
    }
    /**
     * Authorization-related information used by Cloud Audit Logging.
     */
    export interface Schema$AuthorizationLoggingOptions {
        /**
         * The type of the permission that was checked.
         */
        permissionType?: string;
    }
    /**
     * Represents an Autoscaler resource.    Use autoscalers to automatically add or delete instances from a managed instance group according to your defined autoscaling policy. For more information, read Autoscaling Groups of Instances.  For zonal managed instance groups resource, use the autoscaler resource.  For regional managed instance groups, use the regionAutoscalers resource. (== resource_for beta.autoscalers ==) (== resource_for v1.autoscalers ==) (== resource_for beta.regionAutoscalers ==) (== resource_for v1.regionAutoscalers ==)
     */
    export interface Schema$Autoscaler {
        /**
         * The configuration parameters for the autoscaling algorithm. You can define one or more of the policies for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization.  If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
         */
        autoscalingPolicy?: Schema$AutoscalingPolicy;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The status of the autoscaler configuration.
         */
        status?: string;
        /**
         * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
         */
        statusDetails?: Schema$AutoscalerStatusDetails[];
        /**
         * URL of the managed instance group that this autoscaler will scale.
         */
        target?: string;
        /**
         * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
         */
        zone?: string;
    }
    export interface Schema$AutoscalerAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of AutoscalersScopedList resources.
         */
        items?: {
            [key: string]: Schema$AutoscalersScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#autoscalerAggregatedList for aggregated lists of autoscalers.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of Autoscaler resources.
     */
    export interface Schema$AutoscalerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Autoscaler resources.
         */
        items?: Schema$Autoscaler[];
        /**
         * [Output Only] Type of resource. Always compute#autoscalerList for lists of autoscalers.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$AutoscalersScopedList {
        /**
         * [Output Only] A list of autoscalers contained in this scope.
         */
        autoscalers?: Schema$Autoscaler[];
        /**
         * [Output Only] Informational warning which replaces the list of autoscalers when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$AutoscalerStatusDetails {
        /**
         * The status message.
         */
        message?: string;
        /**
         * The type of error returned.
         */
        type?: string;
    }
    /**
     * Cloud Autoscaler policy.
     */
    export interface Schema$AutoscalingPolicy {
        /**
         * The number of seconds that the autoscaler should wait before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. The default time autoscaler waits is 60 seconds.  Virtual machine initialization times might vary because of numerous factors. We recommend that you test how long an instance may take to initialize. To do this, create an instance and time the startup process.
         */
        coolDownPeriodSec?: number;
        /**
         * Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
         */
        cpuUtilization?: Schema$AutoscalingPolicyCpuUtilization;
        /**
         * Configuration parameters of autoscaling based on a custom metric.
         */
        customMetricUtilizations?: Schema$AutoscalingPolicyCustomMetricUtilization[];
        /**
         * Configuration parameters of autoscaling based on load balancer.
         */
        loadBalancingUtilization?: Schema$AutoscalingPolicyLoadBalancingUtilization;
        /**
         * The maximum number of instances that the autoscaler can scale up to. This is required when creating or updating an autoscaler. The maximum number of replicas should not be lower than minimal number of replicas.
         */
        maxNumReplicas?: number;
        /**
         * The minimum number of replicas that the autoscaler can scale down to. This cannot be less than 0. If not provided, autoscaler will choose a default value depending on maximum number of instances allowed.
         */
        minNumReplicas?: number;
    }
    /**
     * CPU utilization policy.
     */
    export interface Schema$AutoscalingPolicyCpuUtilization {
        /**
         * The target CPU utilization that the autoscaler should maintain. Must be a float value in the range (0, 1]. If not specified, the default is 0.6.  If the CPU level is below the target utilization, the autoscaler scales down the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization.  If the average CPU is above the target utilization, the autoscaler scales up until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
         */
        utilizationTarget?: number;
    }
    /**
     * Custom utilization metric policy.
     */
    export interface Schema$AutoscalingPolicyCustomMetricUtilization {
        /**
         * The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values.  The metric must have a value type of INT64 or DOUBLE.
         */
        metric?: string;
        /**
         * The target value of the metric that autoscaler should maintain. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric.  For example, a good metric to use as a utilization_target is compute.googleapis.com/instance/network/received_bytes_count. The autoscaler will work to keep this value constant for each of the instances.
         */
        utilizationTarget?: number;
        /**
         * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
         */
        utilizationTargetType?: string;
    }
    /**
     * Configuration parameters of autoscaling based on load balancing.
     */
    export interface Schema$AutoscalingPolicyLoadBalancingUtilization {
        /**
         * Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that autoscaler should maintain. Must be a positive float value. If not defined, the default is 0.8.
         */
        utilizationTarget?: number;
    }
    /**
     * Message containing information of one individual backend.
     */
    export interface Schema$Backend {
        /**
         * Specifies the balancing mode for the backend.  When choosing a balancing mode, you need to consider the loadBalancingScheme, and protocol for the backend service, as well as the type of backend (instance group or NEG).    - If the load balancing mode is CONNECTION, then the load is spread based on how many concurrent connections the backend can handle. You can use the CONNECTION balancing mode if the protocol for the backend service is SSL, TCP, or UDP.  If the loadBalancingScheme for the backend service is EXTERNAL (SSL Proxy and TCP Proxy load balancers), you must also specify exactly one of the following parameters: maxConnections, maxConnectionsPerInstance, or maxConnectionsPerEndpoint.  If the loadBalancingScheme for the backend service is INTERNAL (internal TCP/UDP load balancers), you cannot specify any additional parameters.   - If the load balancing mode is RATE, the load is spread based on the rate of HTTP requests per second (RPS). You can use the RATE balancing mode if the protocol for the backend service is HTTP or HTTPS. You must specify exactly one of the following parameters: maxRate, maxRatePerInstance, or maxRatePerEndpoint.   - If the load balancing mode is UTILIZATION, the load is spread based on the CPU utilization of instances in an instance group. You can use the UTILIZATION balancing mode if the loadBalancingScheme of the backend service is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED and the backends are instance groups. There are no restrictions on the backend service protocol.
         */
        balancingMode?: string;
        /**
         * A multiplier applied to the group&#39;s maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION). Default value is 1, which means the group will serve up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available Capacity. Valid range is [0.0,1.0].  This cannot be used for internal load balancing.
         */
        capacityScaler?: number;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type of backend that a backend service supports depends on the backend service&#39;s loadBalancingScheme.    - When the loadBalancingScheme for the backend service is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the backend can be either an instance group or a NEG. The backends on the backend service must be either all instance groups or all NEGs. You cannot mix instance group and NEG backends on the same backend service.    - When the loadBalancingScheme for the backend service is INTERNAL, the backend must be an instance group in the same region as the backend service. NEGs are not supported.    You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
         */
        group?: string;
        /**
         * Defines a maximum target for simultaneous connections for the entire backend (instance group or NEG). If the backend&#39;s balancingMode is UTILIZATION, this is an optional parameter. If the backend&#39;s balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL, you must specify either this parameter, maxConnectionsPerInstance, or maxConnectionsPerEndpoint.  Not available if the backend&#39;s balancingMode is RATE. If the loadBalancingScheme is INTERNAL, then maxConnections is not supported, even though the backend requires a balancing mode of CONNECTION.
         */
        maxConnections?: number;
        /**
         * Defines a maximum target for simultaneous connections for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a maximum number of target maximum simultaneous connections for the NEG. If the backend&#39;s balancingMode is CONNECTION, and the backend is attached to a backend service whose loadBalancingScheme is EXTERNAL, you must specify either this parameter, maxConnections, or maxConnectionsPerInstance.  Not available if the backend&#39;s balancingMode is RATE. Internal TCP/UDP load balancing does not support setting maxConnectionsPerEndpoint even though its backends require a balancing mode of CONNECTION.
         */
        maxConnectionsPerEndpoint?: number;
        /**
         * Defines a maximum target for simultaneous connections for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum number of simultaneous connections for the whole instance group. If the backend&#39;s balancingMode is UTILIZATION, this is an optional parameter. If the backend&#39;s balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL, you must specify either this parameter, maxConnections, or maxConnectionsPerEndpoint.  Not available if the backend&#39;s balancingMode is RATE. Internal TCP/UDP load balancing does not support setting maxConnectionsPerInstance even though its backends require a balancing mode of CONNECTION.
         */
        maxConnectionsPerInstance?: number;
        /**
         * The max requests per second (RPS) of the group. Can be used with either RATE or UTILIZATION balancing modes, but required if RATE mode. For RATE mode, either maxRate or maxRatePerInstance must be set.  This cannot be used for internal load balancing.
         */
        maxRate?: number;
        /**
         * Defines a maximum target for requests per second (RPS) for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a target maximum rate for the NEG.  If the backend&#39;s balancingMode is RATE, you must specify either this parameter, maxRate, or maxRatePerInstance.  Not available if the backend&#39;s balancingMode is CONNECTION.
         */
        maxRatePerEndpoint?: number;
        /**
         * Defines a maximum target for requests per second (RPS) for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum rate for the whole instance group.  If the backend&#39;s balancingMode is UTILIZATION, this is an optional parameter. If the backend&#39;s balancingMode is RATE, you must specify either this parameter, maxRate, or maxRatePerEndpoint.  Not available if the backend&#39;s balancingMode is CONNECTION.
         */
        maxRatePerInstance?: number;
        /**
         * Defines the maximum average CPU utilization of a backend VM in an instance group. The valid range is [0.0, 1.0]. This is an optional parameter if the backend&#39;s balancingMode is UTILIZATION.  This parameter can be used in conjunction with maxRate, maxRatePerInstance, maxConnections, or maxConnectionsPerInstance.
         */
        maxUtilization?: number;
    }
    /**
     * Represents a Cloud Storage Bucket resource.  This Cloud Storage bucket resource is referenced by a URL map of a load balancer. For more information, read Backend Buckets.
     */
    export interface Schema$BackendBucket {
        /**
         * Cloud Storage bucket name.
         */
        bucketName?: string;
        /**
         * Cloud CDN configuration for this BackendBucket.
         */
        cdnPolicy?: Schema$BackendBucketCdnPolicy;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional textual description of the resource; provided by the client when the resource is created.
         */
        description?: string;
        /**
         * If true, enable Cloud CDN for this BackendBucket.
         */
        enableCdn?: boolean;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * Type of the resource.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
    }
    /**
     * Message containing Cloud CDN configuration for a backend bucket.
     */
    export interface Schema$BackendBucketCdnPolicy {
        /**
         * Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a &quot;Cache-Control: public, max-age=[TTL]&quot; header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
         */
        signedUrlCacheMaxAgeSec?: string;
        /**
         * [Output Only] Names of the keys for signing request URLs.
         */
        signedUrlKeyNames?: string[];
    }
    /**
     * Contains a list of BackendBucket resources.
     */
    export interface Schema$BackendBucketList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of BackendBucket resources.
         */
        items?: Schema$BackendBucket[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a Backend Service resource.    Backend services must have an associated health check. Backend services also store information about session affinity. For more information, read Backend Services.  A backendServices resource represents a global backend service. Global backend services are used for HTTP(S), SSL Proxy, TCP Proxy load balancing and Traffic Director.  A regionBackendServices resource represents a regional backend service. Regional backend services are used for internal TCP/UDP load balancing. For more information, read Internal TCP/UDP Load balancing. (== resource_for v1.backendService ==) (== resource_for beta.backendService ==)
     */
    export interface Schema$BackendService {
        /**
         * If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).
         */
        affinityCookieTtlSec?: number;
        /**
         * The list of backends that serve this BackendService.
         */
        backends?: Schema$Backend[];
        /**
         * Cloud CDN configuration for this BackendService.
         */
        cdnPolicy?: Schema$BackendServiceCdnPolicy;
        connectionDraining?: Schema$ConnectionDraining;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * Headers that the HTTP/S load balancer should add to proxied requests.
         */
        customRequestHeaders?: string[];
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
         */
        enableCDN?: boolean;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve a BackendService.
         */
        fingerprint?: string;
        /**
         * The list of URLs to the HttpHealthCheck or HttpsHealthCheck resource for health checking this BackendService. Currently at most one health check can be specified, and a health check is required for Compute Engine backend services. A health check must not be specified for App Engine backend and Cloud Function backend.  For internal load balancing, a URL to a HealthCheck resource must be specified instead.
         */
        healthChecks?: string[];
        iap?: Schema$BackendServiceIAP;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of resource. Always compute#backendService for backend services.
         */
        kind?: string;
        /**
         * Indicates whether the backend service will be used with internal or external load balancing. A backend service created for one type of load balancing cannot be used with the other. Possible values are INTERNAL and EXTERNAL.
         */
        loadBalancingScheme?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.  This cannot be used if the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
         */
        port?: number;
        /**
         * A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.    Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Blaancing).
         */
        portName?: string;
        /**
         * The protocol this BackendService uses to communicate with backends.  Possible values are HTTP, HTTPS, TCP, SSL, or UDP, depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic director for more information.
         */
        protocol?: string;
        /**
         * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string;
        /**
         * [Output Only] The resource URL for the security policy associated with this backend service.
         */
        securityPolicy?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * Type of session affinity to use. The default is NONE. Session affinity is not applicable if the --protocol is UDP.  When the loadBalancingScheme is EXTERNAL, possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. You can use GENERATED_COOKIE if the protocol is HTTP or HTTPS.  When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.  When the loadBalancingScheme is INTERNAL_SELF_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
         */
        sessionAffinity?: string;
        /**
         * The backend service timeout has a different meaning depending on the type of load balancer. For more information read,  Backend service settings The default is 30 seconds.
         */
        timeoutSec?: number;
    }
    /**
     * Contains a list of BackendServicesScopedList.
     */
    export interface Schema$BackendServiceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of BackendServicesScopedList resources.
         */
        items?: {
            [key: string]: Schema$BackendServicesScopedList;
        };
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Message containing Cloud CDN configuration for a backend service.
     */
    export interface Schema$BackendServiceCdnPolicy {
        /**
         * The CacheKeyPolicy for this CdnPolicy.
         */
        cacheKeyPolicy?: Schema$CacheKeyPolicy;
        /**
         * Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a &quot;Cache-Control: public, max-age=[TTL]&quot; header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
         */
        signedUrlCacheMaxAgeSec?: string;
        /**
         * [Output Only] Names of the keys for signing request URLs.
         */
        signedUrlKeyNames?: string[];
    }
    export interface Schema$BackendServiceGroupHealth {
        /**
         * Health state of the backend instances or endpoints in requested instance or network endpoint group, determined based on configured health checks.
         */
        healthStatus?: Schema$HealthStatus[];
        /**
         * [Output Only] Type of resource. Always compute#backendServiceGroupHealth for the health of backend services.
         */
        kind?: string;
    }
    /**
     * Identity-Aware Proxy
     */
    export interface Schema$BackendServiceIAP {
        enabled?: boolean;
        oauth2ClientId?: string;
        oauth2ClientSecret?: string;
        /**
         * [Output Only] SHA256 hash value for the field oauth2_client_secret above.
         */
        oauth2ClientSecretSha256?: string;
    }
    /**
     * Contains a list of BackendService resources.
     */
    export interface Schema$BackendServiceList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of BackendService resources.
         */
        items?: Schema$BackendService[];
        /**
         * [Output Only] Type of resource. Always compute#backendServiceList for lists of backend services.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$BackendServiceReference {
        backendService?: string;
    }
    export interface Schema$BackendServicesScopedList {
        /**
         * A list of BackendServices contained in this scope.
         */
        backendServices?: Schema$BackendService[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Associates `members` with a `role`.
     */
    export interface Schema$Binding {
        /**
         * The condition that is associated with this binding. NOTE: An unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
         */
        condition?: Schema$Expr;
        /**
         * Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values:  * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account.  * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account.  * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` .    * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`.    * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`.
         */
        members?: string[];
        /**
         * Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
         */
        role?: string;
    }
    export interface Schema$CacheInvalidationRule {
        /**
         * If set, this invalidation rule will only apply to requests with a Host header matching host.
         */
        host?: string;
        path?: string;
    }
    /**
     * Message containing what to include in the cache key for a request for Cloud CDN.
     */
    export interface Schema$CacheKeyPolicy {
        /**
         * If true, requests to different hosts will be cached separately.
         */
        includeHost?: boolean;
        /**
         * If true, http and https requests will be cached separately.
         */
        includeProtocol?: boolean;
        /**
         * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
         */
        includeQueryString?: boolean;
        /**
         * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. &#39;&amp;&#39; and &#39;=&#39; will be percent encoded and not treated as delimiters.
         */
        queryStringBlacklist?: string[];
        /**
         * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. &#39;&amp;&#39; and &#39;=&#39; will be percent encoded and not treated as delimiters.
         */
        queryStringWhitelist?: string[];
    }
    /**
     * Represents a regional Commitment resource.  Creating a commitment resource means that you are purchasing a committed use contract with an explicit start and end time. You can create commitments based on vCPUs and memory usage and receive discounted rates. For full details, read Signing Up for Committed Use Discounts. (== resource_for beta.regionCommitments ==) (== resource_for v1.regionCommitments ==)
     */
    export interface Schema$Commitment {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] Commitment end time in RFC3339 text format.
         */
        endTimestamp?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#commitment for commitments.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
         */
        plan?: string;
        /**
         * [Output Only] URL of the region where this commitment may be used.
         */
        region?: string;
        /**
         * List of reservations in this commitment.
         */
        reservations?: Schema$Reservation[];
        /**
         * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
         */
        resources?: Schema$ResourceCommitment[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Commitment start time in RFC3339 text format.
         */
        startTimestamp?: string;
        /**
         * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
         */
        status?: string;
        /**
         * [Output Only] An optional, human-readable explanation of the status.
         */
        statusMessage?: string;
    }
    export interface Schema$CommitmentAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of CommitmentsScopedList resources.
         */
        items?: {
            [key: string]: Schema$CommitmentsScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#commitmentAggregatedList for aggregated lists of commitments.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of Commitment resources.
     */
    export interface Schema$CommitmentList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Commitment resources.
         */
        items?: Schema$Commitment[];
        /**
         * [Output Only] Type of resource. Always compute#commitmentList for lists of commitments.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$CommitmentsScopedList {
        /**
         * [Output Only] A list of commitments contained in this scope.
         */
        commitments?: Schema$Commitment[];
        /**
         * [Output Only] Informational warning which replaces the list of commitments when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A condition to be met.
     */
    export interface Schema$Condition {
        /**
         * Trusted attributes supplied by the IAM system.
         */
        iam?: string;
        /**
         * An operator to apply the subject with.
         */
        op?: string;
        /**
         * Trusted attributes discharged by the service.
         */
        svc?: string;
        /**
         * Trusted attributes supplied by any service that owns resources and uses the IAM system for access control.
         */
        sys?: string;
        /**
         * The objects of the condition.
         */
        values?: string[];
    }
    /**
     * Message containing connection draining configuration.
     */
    export interface Schema$ConnectionDraining {
        /**
         * The amount of time in seconds to allow existing connections to persist while on unhealthy backend VMs. Only applicable if the protocol is not UDP. The valid range is [0, 3600].
         */
        drainingTimeoutSec?: number;
    }
    /**
     * Represents a customer-supplied encryption key
     */
    export interface Schema$CustomerEncryptionKey {
        /**
         * The name of the encryption key that is stored in Google Cloud KMS.
         */
        kmsKeyName?: string;
        /**
         * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
         */
        rawKey?: string;
        /**
         * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
         */
        sha256?: string;
    }
    export interface Schema$CustomerEncryptionKeyProtectedDisk {
        /**
         * Decrypts data associated with the disk with a customer-supplied encryption key.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
         */
        source?: string;
    }
    /**
     * Deprecation status for a public resource.
     */
    export interface Schema$DeprecationStatus {
        /**
         * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
         */
        deleted?: string;
        /**
         * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
         */
        deprecated?: string;
        /**
         * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
         */
        obsolete?: string;
        /**
         * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
         */
        replacement?: string;
        /**
         * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
         */
        state?: string;
    }
    /**
     * Represents a Persistent Disk resource.  Persistent disks are required for running your VM instances. Create both boot and non-boot (data) persistent disks. For more information, read Persistent Disks. For more storage options, read Storage options.  The disks resource represents a zonal persistent disk. For more information, read Zonal persistent disks.  The regionDisks resource represents a regional persistent disk. For more information, read  Regional resources. (== resource_for beta.disks ==) (== resource_for v1.disks ==) (== resource_for v1.regionDisks ==) (== resource_for beta.regionDisks ==)
     */
    export interface Schema$Disk {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * Encrypts the disk using a customer-supplied encryption key.  After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later (e.g. to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine).  Customer-supplied encryption keys do not protect access to metadata of the disk.  If you do not provide an encryption key when creating the disk, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#disk for disks.
         */
        kind?: string;
        /**
         * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve a disk.
         */
        labelFingerprint?: string;
        /**
         * Labels to apply to this disk. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * [Output Only] Last attach timestamp in RFC3339 text format.
         */
        lastAttachTimestamp?: string;
        /**
         * [Output Only] Last detach timestamp in RFC3339 text format.
         */
        lastDetachTimestamp?: string;
        /**
         * Integer license codes indicating which licenses are attached to this disk.
         */
        licenseCodes?: string[];
        /**
         * A list of publicly visible licenses. Reserved for Google&#39;s use.
         */
        licenses?: string[];
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Internal use only.
         */
        options?: string;
        /**
         * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. Currently supported sizes are 4096 and 16384, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller&#39;s project.
         */
        physicalBlockSizeBytes?: string;
        /**
         * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string;
        /**
         * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
         */
        replicaZones?: string[];
        /**
         * Resource policies applied to this disk for automatic snapshot creations.
         */
        resourcePolicies?: string[];
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string;
        /**
         * Size of the persistent disk, specified in GB. You can specify this field when creating a persistent disk using the sourceImage or sourceSnapshot parameter, or specify it alone to create an empty persistent disk.  If you specify this field along with sourceImage or sourceSnapshot, the value of sizeGb must not be less than the size of the sourceImage or the size of the snapshot. Acceptable values are 1 to 65536, inclusive.
         */
        sizeGb?: string;
        /**
         * The source image used to create this disk. If the source image is deleted, this field will not be set.  To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9   Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD   To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image   You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family
         */
        sourceImage?: string;
        /**
         * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
         */
        sourceImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
         */
        sourceImageId?: string;
        /**
         * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:   - https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot  - projects/project/global/snapshots/snapshot  - global/snapshots/snapshot
         */
        sourceSnapshot?: string;
        /**
         * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
         */
        sourceSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
         */
        sourceSnapshotId?: string;
        /**
         * [Output Only] The status of disk creation. CREATING: Disk is provisioning. RESTORING: Source data is being copied into the disk. FAILED: Disk creation failed. READY: Disk is ready for use. DELETING: Disk is deleting.
         */
        status?: string;
        /**
         * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project/zones/zone/diskTypes/pd-standard or pd-ssd
         */
        type?: string;
        /**
         * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
         */
        users?: string[];
        /**
         * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string;
    }
    export interface Schema$DiskAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of DisksScopedList resources.
         */
        items?: {
            [key: string]: Schema$DisksScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#diskAggregatedList for aggregated lists of persistent disks.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
     */
    export interface Schema$DiskInstantiationConfig {
        /**
         * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
         */
        autoDelete?: boolean;
        /**
         * The custom source image to be used to restore this disk when instantiating this instance template.
         */
        customImage?: string;
        /**
         * Specifies the device name of the disk to which the configurations apply to.
         */
        deviceName?: string;
        /**
         * Specifies whether to include the disk and what image to use. Possible values are:   - source-image: to use the same image that was used to create the source instance&#39;s corresponding disk. Applicable to the boot disk and additional read-write disks.  - source-image-family: to use the same image family that was used to create the source instance&#39;s corresponding disk. Applicable to the boot disk and additional read-write disks.  - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks.  - attach-read-only: to attach a read-only disk. Applicable to read-only disks.  - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
         */
        instantiateFrom?: string;
    }
    /**
     * A list of Disk resources.
     */
    export interface Schema$DiskList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Disk resources.
         */
        items?: Schema$Disk[];
        /**
         * [Output Only] Type of resource. Always compute#diskList for lists of disks.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$DiskMoveRequest {
        /**
         * The URL of the destination zone to move the disk. This can be a full or partial URL. For example, the following are all valid URLs to a zone:   - https://www.googleapis.com/compute/v1/projects/project/zones/zone  - projects/project/zones/zone  - zones/zone
         */
        destinationZone?: string;
        /**
         * The URL of the target disk to move. This can be a full or partial URL. For example, the following are all valid URLs to a disk:   - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk  - projects/project/zones/zone/disks/disk  - zones/zone/disks/disk
         */
        targetDisk?: string;
    }
    export interface Schema$DisksAddResourcePoliciesRequest {
        /**
         * Resource policies to be added to this disk.
         */
        resourcePolicies?: string[];
    }
    export interface Schema$DisksRemoveResourcePoliciesRequest {
        /**
         * Resource policies to be removed from this disk.
         */
        resourcePolicies?: string[];
    }
    export interface Schema$DisksResizeRequest {
        /**
         * The new size of the persistent disk, which is specified in GB.
         */
        sizeGb?: string;
    }
    export interface Schema$DisksScopedList {
        /**
         * [Output Only] A list of disks contained in this scope.
         */
        disks?: Schema$Disk[];
        /**
         * [Output Only] Informational warning which replaces the list of disks when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a Disk Type resource.  You can choose from a variety of disk types based on your needs. For more information, read Storage options.  The diskTypes resource represents disk types for a zonal persistent disk. For more information, read Zonal persistent disks.  The regionDiskTypes resource represents disk types for a regional persistent disk. For more information, read Regional persistent disks. (== resource_for beta.diskTypes ==) (== resource_for v1.diskTypes ==) (== resource_for v1.regionDiskTypes ==) (== resource_for beta.regionDiskTypes ==)
     */
    export interface Schema$DiskType {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] Server-defined default disk size in GB.
         */
        defaultDiskSizeGb?: string;
        /**
         * [Output Only] The deprecation status associated with this disk type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional description of this resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#diskType for disk types.
         */
        kind?: string;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string;
        /**
         * [Output Only] URL of the region where the disk type resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] An optional textual description of the valid disk size, such as &quot;10GB-10TB&quot;.
         */
        validDiskSize?: string;
        /**
         * [Output Only] URL of the zone where the disk type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string;
    }
    export interface Schema$DiskTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of DiskTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$DiskTypesScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#diskTypeAggregatedList.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of disk types.
     */
    export interface Schema$DiskTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of DiskType resources.
         */
        items?: Schema$DiskType[];
        /**
         * [Output Only] Type of resource. Always compute#diskTypeList for disk types.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$DiskTypesScopedList {
        /**
         * [Output Only] A list of disk types contained in this scope.
         */
        diskTypes?: Schema$DiskType[];
        /**
         * [Output Only] Informational warning which replaces the list of disk types when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A set of Display Device options
     */
    export interface Schema$DisplayDevice {
        /**
         * Defines whether the instance has Display enabled.
         */
        enableDisplay?: boolean;
    }
    export interface Schema$DistributionPolicy {
        /**
         * Zones where the regional managed instance group will create and manage instances.
         */
        zones?: Schema$DistributionPolicyZoneConfiguration[];
    }
    export interface Schema$DistributionPolicyZoneConfiguration {
        /**
         * The URL of the zone. The zone must exist in the region where the managed instance group is located.
         */
        zone?: string;
    }
    /**
     * Represents an expression text. Example:  title: &quot;User account presence&quot; description: &quot;Determines whether the request has a user account&quot; expression: &quot;size(request.user) &gt; 0&quot;
     */
    export interface Schema$Expr {
        /**
         * An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
         */
        description?: string;
        /**
         * Textual representation of an expression in Common Expression Language syntax.  The application context of the containing message determines which well-known feature set of CEL is supported.
         */
        expression?: string;
        /**
         * An optional string indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
         */
        location?: string;
        /**
         * An optional title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
         */
        title?: string;
    }
    /**
     * External VPN gateway is the on-premises VPN gateway(s) or another cloud provider?s VPN gateway that connects to your Google Cloud VPN gateway. To create a highly available VPN from Google Cloud to your on-premises side or another Cloud provider&#39;s VPN gateway, you must create a external VPN gateway resource in GCP, which provides the information to GCP about your external VPN gateway.
     */
    export interface Schema$ExternalVpnGateway {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * List of interfaces for this external VPN gateway.
         */
        interfaces?: Schema$ExternalVpnGatewayInterface[];
        /**
         * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
         */
        kind?: string;
        /**
         * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
         */
        labelFingerprint?: string;
        /**
         * Labels to apply to this ExternalVpnGateway resource. These can be later modified by the setLabels method. Each label key/value must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Indicates the user-supplied redundancy type of this external VPN gateway.
         */
        redundancyType?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
    }
    /**
     * The interface for the external VPN gateway.
     */
    export interface Schema$ExternalVpnGatewayInterface {
        /**
         * The numeric ID of this interface. The allowed input values for this id for different redundancy types of external VPN gateway: SINGLE_IP_INTERNALLY_REDUNDANT - 0 TWO_IPS_REDUNDANCY - 0, 1 FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
         */
        id?: number;
        /**
         * IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider?s VPN gateway, it cannot be an IP address from Google Compute Engine.
         */
        ipAddress?: string;
    }
    /**
     * Response to the list request, and contains a list of externalVpnGateways.
     */
    export interface Schema$ExternalVpnGatewayList {
        etag?: string;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of ExternalVpnGateway resources.
         */
        items?: Schema$ExternalVpnGateway[];
        /**
         * [Output Only] Type of resource. Always compute#externalVpnGatewayList  for lists of externalVpnGateways.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a Firewall Rule resource.  Firewall rules allow or deny ingress traffic to, and egress traffic from your instances. For more information, read Firewall rules.
     */
    export interface Schema$Firewall {
        /**
         * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
         */
        allowed?: Array<{
            IPProtocol?: string;
            ports?: string[];
        }>;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
         */
        denied?: Array<{
            IPProtocol?: string;
            ports?: string[];
        }>;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string;
        /**
         * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Only IPv4 is supported.
         */
        destinationRanges?: string[];
        /**
         * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `INGRESS` traffic, you cannot specify the destinationRanges field, and for `EGRESS` traffic, you cannot specify the sourceRanges or sourceTags fields.
         */
        direction?: string;
        /**
         * Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
         */
        disabled?: boolean;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
         */
        kind?: string;
        /**
         * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Stackdriver.
         */
        logConfig?: Schema$FirewallLogConfig;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string;
        /**
         * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs:   - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network  - projects/myproject/global/networks/my-network  - global/networks/default
         */
        network?: string;
        /**
         * Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
         */
        priority?: number;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Only IPv4 is supported.
         */
        sourceRanges?: string[];
        /**
         * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance&#39;s external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
         */
        sourceServiceAccounts?: string[];
        /**
         * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance&#39;s external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
         */
        sourceTags?: string[];
        /**
         * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
         */
        targetServiceAccounts?: string[];
        /**
         * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
         */
        targetTags?: string[];
    }
    /**
     * Contains a list of firewalls.
     */
    export interface Schema$FirewallList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Firewall resources.
         */
        items?: Schema$Firewall[];
        /**
         * [Output Only] Type of resource. Always compute#firewallList for lists of firewalls.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * The available logging options for a firewall rule.
     */
    export interface Schema$FirewallLogConfig {
        /**
         * This field denotes whether to enable logging for a particular firewall rule.
         */
        enable?: boolean;
    }
    /**
     * Encapsulates numeric value that can be either absolute or relative.
     */
    export interface Schema$FixedOrPercent {
        /**
         * [Output Only] Absolute value of VM instances calculated based on the specific mode.    - If the value is fixed, then the calculated value is equal to the fixed value.  - If the value is a percent, then the calculated value is percent/100 * targetSize. For example, the calculated value of a 80% of a managed instance group with 150 instances would be (80/100 * 150) = 120 VM instances. If there is a remainder, the number is rounded up.
         */
        calculated?: number;
        /**
         * Specifies a fixed number of VM instances. This must be a positive integer.
         */
        fixed?: number;
        /**
         * Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
         */
        percent?: number;
    }
    /**
     * Represents a Forwarding Rule resource.    A forwardingRules resource represents a regional forwarding rule.  Regional external forwarding rules can reference any of the following resources:   - A target instance  - A Cloud VPN Classic gateway (targetVpnGateway),   - A target pool for a Network Load Balancer  - A global target HTTP(S) proxy for an HTTP(S) load balancer using Standard Tier  - A target SSL proxy for a SSL Proxy load balancer using Standard Tier  - A target TCP proxy for a TCP Proxy load balancer using Standard Tier.    Regional internal forwarding rules can reference the backend service of an internal TCP/UDP load balancer.  For regional internal forwarding rules, the following applies:   - If the loadBalancingScheme for the load balancer is INTERNAL, then the forwarding rule references a regional internal backend service.  - If the loadBalancingScheme for the load balancer is INTERNAL_MANAGED, then the forwarding rule must reference a regional target HTTP(S) proxy.    For more information, read Using Forwarding rules.  A globalForwardingRules resource represents a global forwarding rule.  Global forwarding rules are only used by load balancers that use Premium Tier. (== resource_for beta.forwardingRules ==) (== resource_for v1.forwardingRules ==) (== resource_for beta.globalForwardingRules ==) (== resource_for v1.globalForwardingRules ==) (== resource_for beta.regionForwardingRules ==) (== resource_for v1.regionForwardingRules ==)
     */
    export interface Schema$ForwardingRule {
        /**
         * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. This field cannot be used with port or portRange fields.  When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
         */
        allPorts?: boolean;
        /**
         * This field is only used for INTERNAL load balancing.  For internal load balancing, this field identifies the BackendService resource to receive the matched traffic.
         */
        backendService?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule.  If you don&#39;t specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address:  * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name * Partial URL or by name, as in: * projects/project_id/regions/region/addresses/address-name * regions/region/addresses/address-name * global/addresses/address-name * address-name   The loadBalancingScheme and the forwarding rule&#39;s target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
         */
        IPAddress?: string;
        /**
         * The IP protocol to which this rule applies. Valid options are TCP, UDP, ESP, AH, SCTP or ICMP.  When the load balancing scheme is INTERNAL, only TCP and UDP are valid. When the load balancing scheme is INTERNAL_SELF_MANAGED, only TCPis valid.
         */
        IPProtocol?: string;
        /**
         * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
         */
        ipVersion?: string;
        /**
         * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
         */
        kind?: string;
        /**
         * This signifies what the ForwardingRule will be used for and can only take the following values: INTERNAL, INTERNAL_SELF_MANAGED, EXTERNAL. The value of INTERNAL means that this will be used for Internal Network Load Balancing (TCP, UDP). The value of INTERNAL_SELF_MANAGED means that this will be used for Internal Global HTTP(S) LB. The value of EXTERNAL means that this will be used for External Load Balancing (HTTP(S) LB, External TCP/UDP LB, SSL Proxy)
         */
        loadBalancingScheme?: string;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * This field is not used for external load balancing.  For INTERNAL and INTERNAL_SELF_MANAGED load balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
         */
        network?: string;
        /**
         * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM , STANDARD.  For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.  If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
         */
        networkTier?: string;
        /**
         * This field is deprecated. See the port field.
         */
        portRange?: string;
        /**
         * List of comma-separated ports. The forwarding rule forwards packets with matching destination ports. If the forwarding rule&#39;s loadBalancingScheme is EXTERNAL, and the forwarding rule references a target pool, specifying ports is optional. You can specify an unlimited number of ports, but they must be contiguous. If you omit ports, GCP forwards traffic on any port of the forwarding rule&#39;s protocol.  If the forwarding rule&#39;s loadBalancingScheme is EXTERNAL, and the forwarding rule references a target HTTP proxy, target HTTPS proxy, target TCP proxy, target SSL proxy, or target VPN gateway, you must specify ports using the following constraints:    - TargetHttpProxy: 80, 8080  - TargetHttpsProxy: 443  - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222  - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222  - TargetVpnGateway: 500, 4500    If the forwarding rule&#39;s loadBalancingScheme is INTERNAL, you must specify ports in one of the following ways:  * A list of up to five ports, which can be non-contiguous * Keyword ALL, which causes the forwarding rule to forward traffic on any port of the forwarding rule&#39;s protocol.  The ports field is used along with the target field for TargetHttpProxy, TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway, TargetPool, TargetInstance.  Applicable only when IPProtocol is TCP, UDP, or SCTP. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
         */
        ports?: string[];
        /**
         * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name.  The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.  This field is only used for internal load balancing.
         */
        serviceLabel?: string;
        /**
         * [Output Only] The internal fully qualified service name for this Forwarding Rule.  This field is only used for internal load balancing.
         */
        serviceName?: string;
        /**
         * This field is only used for INTERNAL load balancing.  For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule.  If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
         */
        subnetwork?: string;
        /**
         * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must live in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. For INTERNAL_SELF_MANAGED load balancing, only HTTP and HTTPS targets are valid.
         */
        target?: string;
    }
    export interface Schema$ForwardingRuleAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of ForwardingRulesScopedList resources.
         */
        items?: {
            [key: string]: Schema$ForwardingRulesScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#forwardingRuleAggregatedList for lists of forwarding rules.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of ForwardingRule resources.
     */
    export interface Schema$ForwardingRuleList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of ForwardingRule resources.
         */
        items?: Schema$ForwardingRule[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$ForwardingRuleReference {
        forwardingRule?: string;
    }
    export interface Schema$ForwardingRulesScopedList {
        /**
         * A list of forwarding rules contained in this scope.
         */
        forwardingRules?: Schema$ForwardingRule[];
        /**
         * Informational warning which replaces the list of forwarding rules when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$GlobalSetLabelsRequest {
        /**
         * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash when updating or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a get() request to the resource to get the latest fingerprint.
         */
        labelFingerprint?: string;
        /**
         * A list of labels to apply for this resource. Each label key &amp; value must comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For example, &quot;webserver-frontend&quot;: &quot;images&quot;. A label value can also be empty (e.g. &quot;my-label&quot;: &quot;&quot;).
         */
        labels?: {
            [key: string]: string;
        };
    }
    export interface Schema$GlobalSetPolicyRequest {
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use &#39;policy&#39; to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use &#39;policy&#39; to specify the etag.
         */
        etag?: string;
        /**
         * REQUIRED: The complete policy to be applied to the &#39;resource&#39;. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    /**
     * A guest attributes entry.
     */
    export interface Schema$GuestAttributes {
        /**
         * [Output Only] Type of the resource. Always compute#guestAttributes for guest attributes entry.
         */
        kind?: string;
        /**
         * The path to be queried. This can be the default namespace (&#39;/&#39;) or a nested namespace (&#39;//&#39;) or a specified key (&#39;//&#39;)
         */
        queryPath?: string;
        /**
         * [Output Only] The value of the requested queried path.
         */
        queryValue?: Schema$GuestAttributesValue;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * The key to search for.
         */
        variableKey?: string;
        /**
         * [Output Only] The value found for the requested key.
         */
        variableValue?: string;
    }
    /**
     * A guest attributes namespace/key/value entry.
     */
    export interface Schema$GuestAttributesEntry {
        /**
         * Key for the guest attribute entry.
         */
        key?: string;
        /**
         * Namespace for the guest attribute entry.
         */
        namespace?: string;
        /**
         * Value for the guest attribute entry.
         */
        value?: string;
    }
    /**
     * Array of guest attribute namespace/key/value tuples.
     */
    export interface Schema$GuestAttributesValue {
        items?: Schema$GuestAttributesEntry[];
    }
    /**
     * Guest OS features.
     */
    export interface Schema$GuestOsFeature {
        /**
         * The ID of a supported feature. Read  Enabling guest operating system features to see a list of available options.
         */
        type?: string;
    }
    /**
     * Represents a Health Check resource.  Health checks are used for most GCP load balancers and managed instance group auto-healing. For more information, read Health Check Concepts.  To perform health checks on network load balancers, you must use either httpHealthChecks or httpsHealthChecks.
     */
    export interface Schema$HealthCheck {
        /**
         * How often (in seconds) to send a health check. The default value is 5 seconds.
         */
        checkIntervalSec?: number;
        /**
         * [Output Only] Creation timestamp in 3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
         */
        healthyThreshold?: number;
        http2HealthCheck?: Schema$HTTP2HealthCheck;
        httpHealthCheck?: Schema$HTTPHealthCheck;
        httpsHealthCheck?: Schema$HTTPSHealthCheck;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * Type of the resource.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        sslHealthCheck?: Schema$SSLHealthCheck;
        tcpHealthCheck?: Schema$TCPHealthCheck;
        /**
         * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
         */
        timeoutSec?: number;
        /**
         * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS or HTTP2. If not specified, the default is TCP. Exactly one of the protocol-specific health check field must be specified, which must match type field.
         */
        type?: string;
        /**
         * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
         */
        unhealthyThreshold?: number;
    }
    /**
     * Contains a list of HealthCheck resources.
     */
    export interface Schema$HealthCheckList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of HealthCheck resources.
         */
        items?: Schema$HealthCheck[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A full or valid partial URL to a health check. For example, the following are valid URLs:   - https://www.googleapis.com/compute/beta/projects/project-id/global/httpHealthChecks/health-check  - projects/project-id/global/httpHealthChecks/health-check  - global/httpHealthChecks/health-check
     */
    export interface Schema$HealthCheckReference {
        healthCheck?: string;
    }
    export interface Schema$HealthStatus {
        /**
         * Health state of the instance.
         */
        healthState?: string;
        /**
         * URL of the instance resource.
         */
        instance?: string;
        /**
         * The IP address represented by this resource.
         */
        ipAddress?: string;
        /**
         * The port on the instance.
         */
        port?: number;
    }
    export interface Schema$HealthStatusForNetworkEndpoint {
        /**
         * URL of the backend service associated with the health state of the network endpoint.
         */
        backendService?: Schema$BackendServiceReference;
        /**
         * URL of the forwarding rule associated with the health state of the network endpoint.
         */
        forwardingRule?: Schema$ForwardingRuleReference;
        /**
         * URL of the health check associated with the health state of the network endpoint.
         */
        healthCheck?: Schema$HealthCheckReference;
        /**
         * Health state of the network endpoint determined based on the health checks configured.
         */
        healthState?: string;
    }
    /**
     * UrlMaps A host-matching rule for a URL. If matched, will use the named PathMatcher to select the BackendService.
     */
    export interface Schema$HostRule {
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * The list of host patterns to match. They must be valid hostnames, except * will match any string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in the pattern by either - or ..
         */
        hosts?: string[];
        /**
         * The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL&#39;s host portion.
         */
        pathMatcher?: string;
    }
    export interface Schema$HTTP2HealthCheck {
        /**
         * The value of the host header in the HTTP/2 health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
         */
        host?: string;
        /**
         * The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
         */
        port?: number;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string;
        /**
         * Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.   If not specified, HTTP2 health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string;
        /**
         * The request path of the HTTP/2 health check request. The default value is /.
         */
        requestPath?: string;
        /**
         * The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
         */
        response?: string;
    }
    export interface Schema$HTTPHealthCheck {
        /**
         * The value of the host header in the HTTP health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
         */
        host?: string;
        /**
         * The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
         */
        port?: number;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string;
        /**
         * Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.   If not specified, HTTP health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string;
        /**
         * The request path of the HTTP health check request. The default value is /.
         */
        requestPath?: string;
        /**
         * The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
         */
        response?: string;
    }
    /**
     * Represents a legacy HTTP Health Check resource.  Legacy health checks are required by network load balancers. For more information, read Health Check Concepts.
     */
    export interface Schema$HttpHealthCheck {
        /**
         * How often (in seconds) to send a health check. The default value is 5 seconds.
         */
        checkIntervalSec?: number;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
         */
        healthyThreshold?: number;
        /**
         * The value of the host header in the HTTP health check request. If left empty (default value), the public IP on behalf of which this health check is performed will be used.
         */
        host?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#httpHealthCheck for HTTP health checks.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The TCP port number for the HTTP health check request. The default value is 80.
         */
        port?: number;
        /**
         * The request path of the HTTP health check request. The default value is /. This field does not support query parameters.
         */
        requestPath?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
         */
        timeoutSec?: number;
        /**
         * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
         */
        unhealthyThreshold?: number;
    }
    /**
     * Contains a list of HttpHealthCheck resources.
     */
    export interface Schema$HttpHealthCheckList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of HttpHealthCheck resources.
         */
        items?: Schema$HttpHealthCheck[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$HTTPSHealthCheck {
        /**
         * The value of the host header in the HTTPS health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
         */
        host?: string;
        /**
         * The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
         */
        port?: number;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string;
        /**
         * Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.   If not specified, HTTPS health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string;
        /**
         * The request path of the HTTPS health check request. The default value is /.
         */
        requestPath?: string;
        /**
         * The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
         */
        response?: string;
    }
    /**
     * Represents a legacy HTTPS Health Check resource.  Legacy health checks are required by network load balancers. For more information, read Health Check Concepts.
     */
    export interface Schema$HttpsHealthCheck {
        /**
         * How often (in seconds) to send a health check. The default value is 5 seconds.
         */
        checkIntervalSec?: number;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
         */
        healthyThreshold?: number;
        /**
         * The value of the host header in the HTTPS health check request. If left empty (default value), the public IP on behalf of which this health check is performed will be used.
         */
        host?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * Type of the resource.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The TCP port number for the HTTPS health check request. The default value is 443.
         */
        port?: number;
        /**
         * The request path of the HTTPS health check request. The default value is &quot;/&quot;.
         */
        requestPath?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have a greater value than checkIntervalSec.
         */
        timeoutSec?: number;
        /**
         * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
         */
        unhealthyThreshold?: number;
    }
    /**
     * Contains a list of HttpsHealthCheck resources.
     */
    export interface Schema$HttpsHealthCheckList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of HttpsHealthCheck resources.
         */
        items?: Schema$HttpsHealthCheck[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents an Image resource.  You can use images to create boot disks for your VM instances. For more information, read Images. (== resource_for beta.images ==) (== resource_for v1.images ==)
     */
    export interface Schema$Image {
        /**
         * Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
         */
        archiveSizeBytes?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * The deprecation status associated with this image.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * Size of the image when restored onto a persistent disk (in GB).
         */
        diskSizeGb?: string;
        /**
         * The name of the image family to which this image belongs. You can create disks by specifying an image family instead of a specific image name. The image family always returns its latest image that is not deprecated. The name of the image family must comply with RFC1035.
         */
        family?: string;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * Encrypts the image using a customer-supplied encryption key.  After you encrypt an image with a customer-supplied key, you must provide the same key if you use the image later (e.g. to create a disk from the image).  Customer-supplied encryption keys do not protect access to metadata of the disk.  If you do not provide an encryption key when creating the image, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the image later.
         */
        imageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] Type of the resource. Always compute#image for images.
         */
        kind?: string;
        /**
         * A fingerprint for the labels being applied to this image, which is essentially a hash of the labels used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve an image.
         */
        labelFingerprint?: string;
        /**
         * Labels to apply to this image. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * Integer license codes indicating which licenses are attached to this image.
         */
        licenseCodes?: string[];
        /**
         * Any applicable license URI.
         */
        licenses?: string[];
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The parameters of the raw disk image.
         */
        rawDisk?: {
            containerType?: string;
            sha1Checksum?: string;
            source?: string;
        };
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * URL of the source disk used to create this image. This can be a full or valid partial URL. You must provide either this property or the rawDisk.source property but not both to create an image. For example, the following are valid values:   - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk  - projects/project/zones/zone/disks/disk  - zones/zone/disks/disk
         */
        sourceDisk?: string;
        /**
         * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
         */
        sourceDiskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the disk used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given disk name.
         */
        sourceDiskId?: string;
        /**
         * URL of the source image used to create this image. This can be a full or valid partial URL. You must provide exactly one of:   - this property, or   - the rawDisk.source property, or   - the sourceDisk property   in order to create an image.
         */
        sourceImage?: string;
        /**
         * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
         */
        sourceImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the image used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given image name.
         */
        sourceImageId?: string;
        /**
         * URL of the source snapshot used to create this image. This can be a full or valid partial URL. You must provide exactly one of:   - this property, or   - the sourceImage property, or   - the rawDisk.source property, or   - the sourceDisk property   in order to create an image.
         */
        sourceSnapshot?: string;
        /**
         * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
         */
        sourceSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the snapshot used to create this image. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given snapshot name.
         */
        sourceSnapshotId?: string;
        /**
         * The type of the image used to create this disk. The default and only value is RAW
         */
        sourceType?: string;
        /**
         * [Output Only] The status of the image. An image can be used to create other resources, such as instances, only after the image has been successfully created and the status is set to READY. Possible values are FAILED, PENDING, or READY.
         */
        status?: string;
    }
    /**
     * Contains a list of images.
     */
    export interface Schema$ImageList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Image resources.
         */
        items?: Schema$Image[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents an Instance resource.  An instance is a virtual machine that is hosted on Google Cloud Platform. For more information, read Virtual Machine Instances. (== resource_for beta.instances ==) (== resource_for v1.instances ==)
     */
    export interface Schema$Instance {
        /**
         * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding.
         */
        canIpForward?: boolean;
        /**
         * [Output Only] The CPU platform used by this instance.
         */
        cpuPlatform?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * Whether the resource should be protected against deletion.
         */
        deletionProtection?: boolean;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
         */
        disks?: Schema$AttachedDisk[];
        /**
         * Enables display device for the instance.
         */
        displayDevice?: Schema$DisplayDevice;
        /**
         * A list of the type and count of accelerator cards attached to the instance.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
         */
        hostname?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#instance for instances.
         */
        kind?: string;
        /**
         * A fingerprint for this request, which is essentially a hash of the label&#39;s contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels.  To see the latest fingerprint, make get() request to the instance.
         */
        labelFingerprint?: string;
        /**
         * Labels to apply to this instance. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1   To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY   For example: zones/us-central1-f/machineTypes/custom-4-5120   For a full list of restrictions, read the Specifications for custom machine types.
         */
        machineType?: string;
        /**
         * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
         */
        metadata?: Schema$Metadata;
        /**
         * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: &quot;Intel Haswell&quot; or minCpuPlatform: &quot;Intel Sandy Bridge&quot;.
         */
        minCpuPlatform?: string;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
         */
        networkInterfaces?: Schema$NetworkInterface[];
        /**
         * Specifies the reservations that this instance can consume from.
         */
        reservationAffinity?: Schema$ReservationAffinity;
        /**
         * Sets the scheduling options for this instance.
         */
        scheduling?: Schema$Scheduling;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported.  Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
         */
        serviceAccounts?: Schema$ServiceAccount[];
        shieldedInstanceConfig?: Schema$ShieldedInstanceConfig;
        shieldedInstanceIntegrityPolicy?: Schema$ShieldedInstanceIntegrityPolicy;
        /**
         * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
         */
        startRestricted?: boolean;
        /**
         * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, STOPPED, SUSPENDING, SUSPENDED, and TERMINATED.
         */
        status?: string;
        /**
         * [Output Only] An optional, human-readable explanation of the status.
         */
        statusMessage?: string;
        /**
         * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the &#39;tags.items&#39; field.
         */
        tags?: Schema$Tags;
        /**
         * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string;
    }
    export interface Schema$InstanceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * An object that contains a list of instances scoped by zone.
         */
        items?: {
            [key: string]: Schema$InstancesScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#instanceAggregatedList for aggregated lists of Instance resources.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents an unmanaged Instance Group resource.  Use unmanaged instance groups if you need to apply load balancing to groups of heterogeneous instances or if you need to manage the instances yourself. For more information, read  Instance groups.  For zonal unmanaged Instance Group, use instanceGroups resource.  For regional unmanaged Instance Group, use regionInstanceGroups resource. (== resource_for beta.instanceGroups ==) (== resource_for v1.instanceGroups ==) (== resource_for beta.regionInstanceGroups ==) (== resource_for v1.regionInstanceGroups ==)
     */
    export interface Schema$InstanceGroup {
        /**
         * [Output Only] The creation timestamp for this instance group in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect conflicts when multiple users change the named ports concurrently.
         */
        fingerprint?: string;
        /**
         * [Output Only] A unique identifier for this instance group, generated by the server.
         */
        id?: string;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroup for instance groups.
         */
        kind?: string;
        /**
         * The name of the instance group. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string;
        /**
         * Assigns a name to a port number. For example: {name: &quot;http&quot;, port: 80}  This allows the system to reference ports by the assigned name instead of a port number. Named ports can also contain multiple ports. For example: [{name: &quot;http&quot;, port: 80},{name: &quot;http&quot;, port: 8080}]   Named ports apply to all instances in this instance group.
         */
        namedPorts?: Schema$NamedPort[];
        /**
         * The URL of the network to which all instances in the instance group belong.
         */
        network?: string;
        /**
         * [Output Only] The URL of the region where the instance group is located (for regional resources).
         */
        region?: string;
        /**
         * [Output Only] The URL for this instance group. The server generates this URL.
         */
        selfLink?: string;
        /**
         * [Output Only] The total number of instances in the instance group.
         */
        size?: number;
        /**
         * [Output Only] The URL of the subnetwork to which all instances in the instance group belong.
         */
        subnetwork?: string;
        /**
         * [Output Only] The URL of the zone where the instance group is located (for zonal resources).
         */
        zone?: string;
    }
    export interface Schema$InstanceGroupAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InstanceGroupsScopedList resources.
         */
        items?: {
            [key: string]: Schema$InstanceGroupsScopedList;
        };
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupAggregatedList for aggregated lists of instance groups.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A list of InstanceGroup resources.
     */
    export interface Schema$InstanceGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InstanceGroup resources.
         */
        items?: Schema$InstanceGroup[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupList for instance group lists.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a Managed Instance Group resource.  An instance group is a collection of VM instances that you can manage as a single entity. For more information, read Instance groups.  For zonal Managed Instance Group, use the instanceGroupManagers resource.  For regional Managed Instance Group, use the regionInstanceGroupManagers resource. (== resource_for beta.instanceGroupManagers ==) (== resource_for v1.instanceGroupManagers ==) (== resource_for beta.regionInstanceGroupManagers ==) (== resource_for v1.regionInstanceGroupManagers ==)
     */
    export interface Schema$InstanceGroupManager {
        /**
         * The autohealing policy for this managed instance group. You can specify only one value.
         */
        autoHealingPolicies?: Schema$InstanceGroupManagerAutoHealingPolicy[];
        /**
         * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
         */
        baseInstanceName?: string;
        /**
         * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
         */
        currentActions?: Schema$InstanceGroupManagerActionsSummary;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * Policy specifying intended distribution of instances in regional managed instance group.
         */
        distributionPolicy?: Schema$DistributionPolicy;
        /**
         * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
         */
        fingerprint?: string;
        /**
         * [Output Only] A unique identifier for this resource type. The server generates this identifier.
         */
        id?: string;
        /**
         * [Output Only] The URL of the Instance Group resource.
         */
        instanceGroup?: string;
        /**
         * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group.
         */
        instanceTemplate?: string;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
         */
        kind?: string;
        /**
         * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string;
        /**
         * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
         */
        namedPorts?: Schema$NamedPort[];
        /**
         * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
         */
        region?: string;
        /**
         * [Output Only] The URL for this managed instance group. The server defines this URL.
         */
        selfLink?: string;
        /**
         * [Output Only] The status of this managed instance group.
         */
        status?: Schema$InstanceGroupManagerStatus;
        /**
         * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
         */
        targetPools?: string[];
        /**
         * The target number of running instances for this managed instance group. Deleting or abandoning instances reduces this number. Resizing the group changes this number.
         */
        targetSize?: number;
        /**
         * The update policy for this managed instance group.
         */
        updatePolicy?: Schema$InstanceGroupManagerUpdatePolicy;
        /**
         * Specifies the instance templates used by this managed instance group to create instances.  Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
         */
        versions?: Schema$InstanceGroupManagerVersion[];
        /**
         * [Output Only] The URL of the zone where the managed instance group is located (for zonal resources).
         */
        zone?: string;
    }
    export interface Schema$InstanceGroupManagerActionsSummary {
        /**
         * [Output Only] The total number of instances in the managed instance group that are scheduled to be abandoned. Abandoning an instance removes it from the managed instance group without deleting it.
         */
        abandoning?: number;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be created or are currently being created. If the group fails to create any of these instances, it tries again until it creates the instance successfully.  If you have disabled creation retries, this field will not be populated; instead, the creatingWithoutRetries field will be populated.
         */
        creating?: number;
        /**
         * [Output Only] The number of instances that the managed instance group will attempt to create. The group attempts to create each instance only once. If the group fails to create any of these instances, it decreases the group&#39;s targetSize value accordingly.
         */
        creatingWithoutRetries?: number;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be deleted or are currently being deleted.
         */
        deleting?: number;
        /**
         * [Output Only] The number of instances in the managed instance group that are running and have no scheduled actions.
         */
        none?: number;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be recreated or are currently being being recreated. Recreating an instance deletes the existing root persistent disk and creates a new disk from the image that is defined in the instance template.
         */
        recreating?: number;
        /**
         * [Output Only] The number of instances in the managed instance group that are being reconfigured with properties that do not require a restart or a recreate action. For example, setting or removing target pools for the instance.
         */
        refreshing?: number;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be restarted or are currently being restarted.
         */
        restarting?: number;
        /**
         * [Output Only] The number of instances in the managed instance group that are being verified. See the managedInstances[].currentAction property in the listManagedInstances method documentation.
         */
        verifying?: number;
    }
    export interface Schema$InstanceGroupManagerAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InstanceGroupManagersScopedList resources.
         */
        items?: {
            [key: string]: Schema$InstanceGroupManagersScopedList;
        };
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerAggregatedList for an aggregated list of managed instance groups.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$InstanceGroupManagerAutoHealingPolicy {
        /**
         * The URL for the health check that signals autohealing.
         */
        healthCheck?: string;
        /**
         * The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. This initial delay allows instances to initialize and run their startup scripts before the instance group determines that they are UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely. This value must be from range [0, 3600].
         */
        initialDelaySec?: number;
    }
    /**
     * [Output Only] A list of managed instance groups.
     */
    export interface Schema$InstanceGroupManagerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InstanceGroupManager resources.
         */
        items?: Schema$InstanceGroupManager[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of managed instance groups.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$InstanceGroupManagersAbandonInstancesRequest {
        /**
         * The URLs of one or more instances to abandon. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[];
    }
    export interface Schema$InstanceGroupManagersDeleteInstancesRequest {
        /**
         * The URLs of one or more instances to delete. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[];
    }
    export interface Schema$InstanceGroupManagersListManagedInstancesResponse {
        /**
         * [Output Only] The list of instances in the managed instance group.
         */
        managedInstances?: Schema$ManagedInstance[];
    }
    export interface Schema$InstanceGroupManagersRecreateInstancesRequest {
        /**
         * The URLs of one or more instances to recreate. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[];
    }
    export interface Schema$InstanceGroupManagersScopedList {
        /**
         * [Output Only] The list of managed instance groups that are contained in the specified project and zone.
         */
        instanceGroupManagers?: Schema$InstanceGroupManager[];
        /**
         * [Output Only] The warning that replaces the list of managed instance groups when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$InstanceGroupManagersSetInstanceTemplateRequest {
        /**
         * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group.
         */
        instanceTemplate?: string;
    }
    export interface Schema$InstanceGroupManagersSetTargetPoolsRequest {
        /**
         * The fingerprint of the target pools information. Use this optional property to prevent conflicts when multiple users change the target pools settings concurrently. Obtain the fingerprint with the instanceGroupManagers.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request.
         */
        fingerprint?: string;
        /**
         * The list of target pool URLs that instances in this managed instance group belong to. The managed instance group applies these target pools to all of the instances in the group. Existing instances and new instances in the group all receive these target pool settings.
         */
        targetPools?: string[];
    }
    export interface Schema$InstanceGroupManagerStatus {
        /**
         * [Output Only] A bit indicating whether the managed instance group is in a stable state. A stable state means that: none of the instances in the managed instance group is currently undergoing any type of change (for example, creation, restart, or deletion); no future changes are scheduled for instances in the managed instance group; and the managed instance group itself is not being modified.
         */
        isStable?: boolean;
    }
    export interface Schema$InstanceGroupManagerUpdatePolicy {
        /**
         * The maximum number of instances that can be created above the specified targetSize during the update process. By default, a fixed value of 1 is used. This value can be either a fixed number or a percentage if the instance group has 10 or more instances. If you set a percentage, the number of instances will be rounded up if necessary.  At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
         */
        maxSurge?: Schema$FixedOrPercent;
        /**
         * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied:    - The instance&#39;s status is RUNNING.  - If there is a health check on the instance group, the instance&#39;s liveness health check result must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available.  By default, a fixed value of 1 is used. This value can be either a fixed number or a percentage if the instance group has 10 or more instances. If you set a percentage, the number of instances will be rounded up if necessary.  At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
         */
        maxUnavailable?: Schema$FixedOrPercent;
        /**
         * Minimal action to be taken on an instance. You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
         */
        minimalAction?: string;
        /**
         * The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
         */
        type?: string;
    }
    export interface Schema$InstanceGroupManagerVersion {
        /**
         * The URL of the instance template that is specified for this managed instance group. The group uses this template to create new instances in the managed instance group until the `targetSize` for this version is reached.
         */
        instanceTemplate?: string;
        /**
         * Name of the version. Unique among all versions in the scope of this managed instance group.
         */
        name?: string;
        /**
         * Specifies the intended number of instances to be created from the instanceTemplate. The final number of instances created from the template will be equal to:   - If expressed as a fixed number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used.  - if expressed as a percent, the targetSize would be (targetSize.percent/100 * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded up.  If unset, this version will update any remaining instances not updated by another version. Read Starting a canary update for more information.
         */
        targetSize?: Schema$FixedOrPercent;
    }
    export interface Schema$InstanceGroupsAddInstancesRequest {
        /**
         * The list of instances to add to the instance group.
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$InstanceGroupsListInstances {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InstanceWithNamedPorts resources.
         */
        items?: Schema$InstanceWithNamedPorts[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupsListInstances for the list of instances in the specified instance group.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$InstanceGroupsListInstancesRequest {
        /**
         * A filter for the state of the instances in the instance group. Valid options are ALL or RUNNING. If you do not specify this parameter the list includes all instances regardless of their state.
         */
        instanceState?: string;
    }
    export interface Schema$InstanceGroupsRemoveInstancesRequest {
        /**
         * The list of instances to remove from the instance group.
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$InstanceGroupsScopedList {
        /**
         * [Output Only] The list of instance groups that are contained in this scope.
         */
        instanceGroups?: Schema$InstanceGroup[];
        /**
         * [Output Only] An informational warning that replaces the list of instance groups when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$InstanceGroupsSetNamedPortsRequest {
        /**
         * The fingerprint of the named ports information for this instance group. Use this optional property to prevent conflicts when multiple users change the named ports settings concurrently. Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request. A request with an incorrect fingerprint will fail with error 412 conditionNotMet.
         */
        fingerprint?: string;
        /**
         * The list of named ports to set for this instance group.
         */
        namedPorts?: Schema$NamedPort[];
    }
    /**
     * Contains a list of instances.
     */
    export interface Schema$InstanceList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Instance resources.
         */
        items?: Schema$Instance[];
        /**
         * [Output Only] Type of resource. Always compute#instanceList for lists of Instance resources.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of instance referrers.
     */
    export interface Schema$InstanceListReferrers {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Reference resources.
         */
        items?: Schema$Reference[];
        /**
         * [Output Only] Type of resource. Always compute#instanceListReferrers for lists of Instance referrers.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$InstanceMoveRequest {
        /**
         * The URL of the destination zone to move the instance. This can be a full or partial URL. For example, the following are all valid URLs to a zone:   - https://www.googleapis.com/compute/v1/projects/project/zones/zone  - projects/project/zones/zone  - zones/zone
         */
        destinationZone?: string;
        /**
         * The URL of the target instance to move. This can be a full or partial URL. For example, the following are all valid URLs to an instance:   - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance  - projects/project/zones/zone/instances/instance  - zones/zone/instances/instance
         */
        targetInstance?: string;
    }
    export interface Schema$InstanceProperties {
        /**
         * Enables instances created based on this template to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
         */
        canIpForward?: boolean;
        /**
         * An optional text description for the instances that are created from this instance template.
         */
        description?: string;
        /**
         * An array of disks that are associated with the instances that are created from this template.
         */
        disks?: Schema$AttachedDisk[];
        /**
         * A list of guest accelerator cards&#39; type and count to use for instances created from the instance template.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * Labels to apply to instances that are created from this template.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * The machine type to use for instances that are created from this template.
         */
        machineType?: string;
        /**
         * The metadata key/value pairs to assign to instances that are created from this template. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
         */
        metadata?: Schema$Metadata;
        /**
         * Minimum cpu/platform to be used by this instance. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: &quot;Intel Haswell&quot; or minCpuPlatform: &quot;Intel Sandy Bridge&quot;. For more information, read Specifying a Minimum CPU Platform.
         */
        minCpuPlatform?: string;
        /**
         * An array of network access configurations for this interface.
         */
        networkInterfaces?: Schema$NetworkInterface[];
        /**
         * Specifies the reservations that this instance can consume from.
         */
        reservationAffinity?: Schema$ReservationAffinity;
        /**
         * Specifies the scheduling options for the instances that are created from this template.
         */
        scheduling?: Schema$Scheduling;
        /**
         * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this template. Use metadata queries to obtain the access tokens for these instances.
         */
        serviceAccounts?: Schema$ServiceAccount[];
        shieldedInstanceConfig?: Schema$ShieldedInstanceConfig;
        /**
         * A list of tags to apply to the instances that are created from this template. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
         */
        tags?: Schema$Tags;
    }
    export interface Schema$InstanceReference {
        /**
         * The URL for a specific instance.
         */
        instance?: string;
    }
    export interface Schema$InstancesScopedList {
        /**
         * [Output Only] A list of instances contained in this scope.
         */
        instances?: Schema$Instance[];
        /**
         * [Output Only] Informational warning which replaces the list of instances when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$InstancesSetLabelsRequest {
        /**
         * Fingerprint of the previous set of labels for this resource, used to prevent conflicts. Provide the latest fingerprint value when making a request to add or change labels.
         */
        labelFingerprint?: string;
        labels?: {
            [key: string]: string;
        };
    }
    export interface Schema$InstancesSetMachineResourcesRequest {
        /**
         * A list of the type and count of accelerator cards attached to the instance.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
    }
    export interface Schema$InstancesSetMachineTypeRequest {
        /**
         * Full or partial URL of the machine type resource. See Machine Types for a full list of machine types. For example: zones/us-central1-f/machineTypes/n1-standard-1
         */
        machineType?: string;
    }
    export interface Schema$InstancesSetMinCpuPlatformRequest {
        /**
         * Minimum cpu/platform this instance should be started at.
         */
        minCpuPlatform?: string;
    }
    export interface Schema$InstancesSetServiceAccountRequest {
        /**
         * Email address of the service account.
         */
        email?: string;
        /**
         * The list of scopes to be made available for this service account.
         */
        scopes?: string[];
    }
    export interface Schema$InstancesStartWithEncryptionKeyRequest {
        /**
         * Array of disks associated with this instance that are protected with a customer-supplied encryption key.  In order to start the instance, the disk url and its corresponding key must be provided.  If the disk is not protected with a customer-supplied encryption key it should not be specified.
         */
        disks?: Schema$CustomerEncryptionKeyProtectedDisk[];
    }
    /**
     * Represents an Instance Template resource.  You can use instance templates to create VM instances and managed instance groups. For more information, read Instance Templates. (== resource_for beta.instanceTemplates ==) (== resource_for v1.instanceTemplates ==)
     */
    export interface Schema$InstanceTemplate {
        /**
         * [Output Only] The creation timestamp for this instance template in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] A unique identifier for this instance template. The server defines this identifier.
         */
        id?: string;
        /**
         * [Output Only] The resource type, which is always compute#instanceTemplate for instance templates.
         */
        kind?: string;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The instance properties for this instance template.
         */
        properties?: Schema$InstanceProperties;
        /**
         * [Output Only] The URL for this instance template. The server defines this URL.
         */
        selfLink?: string;
        /**
         * The source instance used to create the template. You can provide this as a partial or full URL to the resource. For example, the following are valid values:   - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance  - projects/project/zones/zone/instances/instance
         */
        sourceInstance?: string;
        /**
         * The source instance params to use to create this instance template.
         */
        sourceInstanceParams?: Schema$SourceInstanceParams;
    }
    /**
     * A list of instance templates.
     */
    export interface Schema$InstanceTemplateList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InstanceTemplate resources.
         */
        items?: Schema$InstanceTemplate[];
        /**
         * [Output Only] The resource type, which is always compute#instanceTemplatesListResponse for instance template lists.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$InstanceWithNamedPorts {
        /**
         * [Output Only] The URL of the instance.
         */
        instance?: string;
        /**
         * [Output Only] The named ports that belong to this instance group.
         */
        namedPorts?: Schema$NamedPort[];
        /**
         * [Output Only] The status of the instance.
         */
        status?: string;
    }
    /**
     * Represents an Interconnect resource.  An Interconnect resource is a dedicated connection between the GCP network and your on-premises network. For more information, read the  Dedicated Interconnect Overview. (== resource_for v1.interconnects ==) (== resource_for beta.interconnects ==)
     */
    export interface Schema$Interconnect {
        /**
         * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
         */
        adminEnabled?: boolean;
        /**
         * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
         */
        circuitInfos?: Schema$InterconnectCircuitInfo[];
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
         */
        customerName?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] A list of outages expected for this Interconnect.
         */
        expectedOutages?: Schema$InterconnectOutageNotification[];
        /**
         * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
         */
        googleIpAddress?: string;
        /**
         * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
         */
        googleReferenceId?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
         */
        interconnectAttachments?: string[];
        /**
         * Type of interconnect, which can take one of the following values:  - PARTNER: A partner-managed interconnection shared between customers though a partner.  - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
         */
        interconnectType?: string;
        /**
         * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
         */
        kind?: string;
        /**
         * Type of link requested, which can take one of the following values:  - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics  - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
         */
        linkType?: string;
        /**
         * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
         */
        location?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Stackdriver logs alerting and Cloud Notifications.
         */
        nocContactEmail?: string;
        /**
         * [Output Only] The current status of this Interconnect&#39;s functionality, which can take one of the following values:  - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect.  - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect.  - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
         */
        operationalStatus?: string;
        /**
         * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
         */
        peerIpAddress?: string;
        /**
         * [Output Only] Number of links actually provisioned in this interconnect.
         */
        provisionedLinkCount?: number;
        /**
         * Target number of physical links in the link bundle, as requested by the customer.
         */
        requestedLinkCount?: number;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The current state of Interconnect functionality, which can take one of the following values:  - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect.  - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect.  - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
         */
        state?: string;
    }
    /**
     * Represents an Interconnect Attachment (VLAN) resource.  You can use Interconnect attachments (VLANS) to connect your Virtual Private Cloud networks to your on-premises networks through an Interconnect. For more information, read  Creating VLAN Attachments. (== resource_for beta.interconnectAttachments ==) (== resource_for v1.interconnectAttachments ==)
     */
    export interface Schema$InterconnectAttachment {
        /**
         * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
         */
        adminEnabled?: boolean;
        /**
         * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values:  - BPS_50M: 50 Mbit/s  - BPS_100M: 100 Mbit/s  - BPS_200M: 200 Mbit/s  - BPS_300M: 300 Mbit/s  - BPS_400M: 400 Mbit/s  - BPS_500M: 500 Mbit/s  - BPS_1G: 1 Gbit/s  - BPS_2G: 2 Gbit/s  - BPS_5G: 5 Gbit/s  - BPS_10G: 10 Gbit/s  - BPS_20G: 20 Gbit/s  - BPS_50G: 50 Gbit/s
         */
        bandwidth?: string;
        /**
         * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google?s edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
         */
        candidateSubnets?: string[];
        /**
         * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
         */
        cloudRouterIpAddress?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
         */
        customerRouterIpAddress?: string;
        /**
         * An optional description of this resource.
         */
        description?: string;
        /**
         * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values:  - AVAILABILITY_DOMAIN_ANY  - AVAILABILITY_DOMAIN_1  - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
         */
        edgeAvailabilityDomain?: string;
        /**
         * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
         */
        googleReferenceId?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * URL of the underlying Interconnect object that this attachment&#39;s traffic will traverse through.
         */
        interconnect?: string;
        /**
         * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values:  - OS_ACTIVE: The attachment has been turned up and is ready to use.  - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
         */
        operationalStatus?: string;
        /**
         * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form &quot;XXXXX/region/domain&quot;
         */
        pairingKey?: string;
        /**
         * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
         */
        partnerAsn?: string;
        /**
         * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
         */
        partnerMetadata?: Schema$InterconnectAttachmentPartnerMetadata;
        /**
         * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
         */
        privateInterconnectInfo?: Schema$InterconnectAttachmentPrivateInfo;
        /**
         * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string;
        /**
         * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
         */
        router?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The current state of this attachment&#39;s functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values:  - ACTIVE: The attachment has been turned up and is ready to use.  - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.  - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side.  - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.  - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it.  - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
         */
        state?: string;
        /**
         * The type of interconnect attachment this is, which can take one of the following values:  - DEDICATED: an attachment to a Dedicated Interconnect.  - PARTNER: an attachment to a Partner Interconnect, created by the customer.  - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
         */
        type?: string;
        /**
         * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
         */
        vlanTag8021q?: number;
    }
    export interface Schema$InterconnectAttachmentAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InterconnectAttachmentsScopedList resources.
         */
        items?: {
            [key: string]: Schema$InterconnectAttachmentsScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#interconnectAttachmentAggregatedList for aggregated lists of interconnect attachments.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Response to the list request, and contains a list of interconnect attachments.
     */
    export interface Schema$InterconnectAttachmentList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InterconnectAttachment resources.
         */
        items?: Schema$InterconnectAttachment[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectAttachmentList for lists of interconnect attachments.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Informational metadata about Partner attachments from Partners to display to customers. These fields are propagated from PARTNER_PROVIDER attachments to their corresponding PARTNER attachments.
     */
    export interface Schema$InterconnectAttachmentPartnerMetadata {
        /**
         * Plain text name of the Interconnect this attachment is connected to, as displayed in the Partner?s portal. For instance &quot;Chicago 1&quot;. This value may be validated to match approved Partner values.
         */
        interconnectName?: string;
        /**
         * Plain text name of the Partner providing this attachment. This value may be validated to match approved Partner values.
         */
        partnerName?: string;
        /**
         * URL of the Partner?s portal for this Attachment. Partners may customise this to be a deep link to the specific resource on the Partner portal. This value may be validated to match approved Partner values.
         */
        portalUrl?: string;
    }
    /**
     * Information for an interconnect attachment when this belongs to an interconnect of type DEDICATED.
     */
    export interface Schema$InterconnectAttachmentPrivateInfo {
        /**
         * [Output Only] 802.1q encapsulation tag to be used for traffic between Google and the customer, going to and from this network and region.
         */
        tag8021q?: number;
    }
    export interface Schema$InterconnectAttachmentsScopedList {
        /**
         * A list of interconnect attachments contained in this scope.
         */
        interconnectAttachments?: Schema$InterconnectAttachment[];
        /**
         * Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Describes a single physical circuit between the Customer and Google. CircuitInfo objects are created by Google, so all fields are output only. Next id: 4
     */
    export interface Schema$InterconnectCircuitInfo {
        /**
         * Customer-side demarc ID for this circuit.
         */
        customerDemarcId?: string;
        /**
         * Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
         */
        googleCircuitId?: string;
        /**
         * Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to the customer in the LOA.
         */
        googleDemarcId?: string;
    }
    /**
     * Diagnostics information about interconnect, contains detailed and current technical information about Google?s side of the connection.
     */
    export interface Schema$InterconnectDiagnostics {
        /**
         * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
         */
        arpCaches?: Schema$InterconnectDiagnosticsARPEntry[];
        /**
         * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
         */
        links?: Schema$InterconnectDiagnosticsLinkStatus[];
        /**
         * The MAC address of the Interconnect&#39;s bundle interface.
         */
        macAddress?: string;
    }
    /**
     * Describing the ARP neighbor entries seen on this link
     */
    export interface Schema$InterconnectDiagnosticsARPEntry {
        /**
         * The IP address of this ARP neighbor.
         */
        ipAddress?: string;
        /**
         * The MAC address of this ARP neighbor.
         */
        macAddress?: string;
    }
    export interface Schema$InterconnectDiagnosticsLinkLACPStatus {
        /**
         * System ID of the port on Google?s side of the LACP exchange.
         */
        googleSystemId?: string;
        /**
         * System ID of the port on the neighbor?s side of the LACP exchange.
         */
        neighborSystemId?: string;
        /**
         * The state of a LACP link, which can take one of the following values:  - ACTIVE: The link is configured and active within the bundle.  - DETACHED: The link is not configured within the bundle. This means that the rest of the object should be empty.
         */
        state?: string;
    }
    export interface Schema$InterconnectDiagnosticsLinkOpticalPower {
        /**
         * The status of the current value when compared to the warning and alarm levels for the receiving or transmitting transceiver. Possible states include:   - OK: The value has not crossed a warning threshold.  - LOW_WARNING: The value has crossed below the low warning threshold.  - HIGH_WARNING: The value has crossed above the high warning threshold.  - LOW_ALARM: The value has crossed below the low alarm threshold.  - HIGH_ALARM: The value has crossed above the high alarm threshold.
         */
        state?: string;
        /**
         * Value of the current receiving or transmitting optical power, read in dBm. Take a known good optical value, give it a 10% margin and trigger warnings relative to that value. In general, a -7dBm warning and a -11dBm alarm are good optical value estimates for most links.
         */
        value?: number;
    }
    export interface Schema$InterconnectDiagnosticsLinkStatus {
        /**
         * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
         */
        arpCaches?: Schema$InterconnectDiagnosticsARPEntry[];
        /**
         * The unique ID for this link assigned during turn up by Google.
         */
        circuitId?: string;
        /**
         * The Demarc address assigned by Google and provided in the LoA.
         */
        googleDemarc?: string;
        lacpStatus?: Schema$InterconnectDiagnosticsLinkLACPStatus;
        /**
         * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
         */
        receivingOpticalPower?: Schema$InterconnectDiagnosticsLinkOpticalPower;
        /**
         * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
         */
        transmittingOpticalPower?: Schema$InterconnectDiagnosticsLinkOpticalPower;
    }
    /**
     * Response to the list request, and contains a list of interconnects.
     */
    export interface Schema$InterconnectList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Interconnect resources.
         */
        items?: Schema$Interconnect[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectList for lists of interconnects.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents an Interconnect Attachment (VLAN) Location resource.  You can use this resource to find location details about an Interconnect attachment (VLAN). For more information about interconnect attachments, read  Creating VLAN Attachments.
     */
    export interface Schema$InterconnectLocation {
        /**
         * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
         */
        address?: string;
        /**
         * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: &quot;zone1&quot; or &quot;zone2&quot;.
         */
        availabilityZone?: string;
        /**
         * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: &quot;Chicago, IL&quot;, &quot;Amsterdam, Netherlands&quot;.
         */
        city?: string;
        /**
         * [Output Only] Continent for this location, which can take one of the following values:  - AFRICA  - ASIA_PAC  - EUROPE  - NORTH_AMERICA  - SOUTH_AMERICA
         */
        continent?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] An optional description of the resource.
         */
        description?: string;
        /**
         * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
         */
        facilityProvider?: string;
        /**
         * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
         */
        facilityProviderFacilityId?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
         */
        kind?: string;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string;
        /**
         * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
         */
        peeringdbFacilityId?: string;
        /**
         * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
         */
        regionInfos?: Schema$InterconnectLocationRegionInfo[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The status of this InterconnectLocation, which can take one of the following values:  - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects.  - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
         */
        status?: string;
    }
    /**
     * Response to the list request, and contains a list of interconnect locations.
     */
    export interface Schema$InterconnectLocationList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InterconnectLocation resources.
         */
        items?: Schema$InterconnectLocation[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectLocationList for lists of interconnect locations.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Information about any potential InterconnectAttachments between an Interconnect at a specific InterconnectLocation, and a specific Cloud Region.
     */
    export interface Schema$InterconnectLocationRegionInfo {
        /**
         * Expected round-trip time in milliseconds, from this InterconnectLocation to a VM in this region.
         */
        expectedRttMs?: string;
        /**
         * Identifies the network presence of this location.
         */
        locationPresence?: string;
        /**
         * URL for the region of this location.
         */
        region?: string;
    }
    /**
     * Description of a planned outage on this Interconnect. Next id: 9
     */
    export interface Schema$InterconnectOutageNotification {
        /**
         * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
         */
        affectedCircuits?: string[];
        /**
         * A description about the purpose of the outage.
         */
        description?: string;
        /**
         * Scheduled end time for the outage (milliseconds since Unix epoch).
         */
        endTime?: string;
        /**
         * Form this outage is expected to take, which can take one of the following values:  - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window.  - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with &quot;IT_&quot; have been deprecated in favor of the unprefixed values.
         */
        issueType?: string;
        /**
         * Unique identifier for this outage notification.
         */
        name?: string;
        /**
         * The party that generated this notification, which can take the following value:  - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
         */
        source?: string;
        /**
         * Scheduled start time for the outage (milliseconds since Unix epoch).
         */
        startTime?: string;
        /**
         * State of this notification, which can take one of the following values:  - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling.  - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. Note that the versions of this enum prefixed with &quot;NS_&quot; have been deprecated in favor of the unprefixed values.
         */
        state?: string;
    }
    /**
     * Response for the InterconnectsGetDiagnosticsRequest.
     */
    export interface Schema$InterconnectsGetDiagnosticsResponse {
        result?: Schema$InterconnectDiagnostics;
    }
    /**
     * A license resource.
     */
    export interface Schema$License {
        /**
         * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
         */
        chargesUseFee?: boolean;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional textual description of the resource; provided by the client when the resource is created.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of resource. Always compute#license for licenses.
         */
        kind?: string;
        /**
         * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
         */
        licenseCode?: string;
        /**
         * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
         */
        name?: string;
        resourceRequirements?: Schema$LicenseResourceRequirements;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
         */
        transferable?: boolean;
    }
    export interface Schema$LicenseCode {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] Description of this License Code.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of resource. Always compute#licenseCode for licenses.
         */
        kind?: string;
        /**
         * [Output Only] URL and description aliases of Licenses with the same License Code.
         */
        licenseAlias?: Schema$LicenseCodeLicenseAlias[];
        /**
         * [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit integer.
         */
        name?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Current state of this License Code.
         */
        state?: string;
        /**
         * [Output Only] If true, the license will remain attached when creating images or snapshots from disks. Otherwise, the license is not transferred.
         */
        transferable?: boolean;
    }
    export interface Schema$LicenseCodeLicenseAlias {
        /**
         * [Output Only] Description of this License Code.
         */
        description?: string;
        /**
         * [Output Only] URL of license corresponding to this License Code.
         */
        selfLink?: string;
    }
    export interface Schema$LicenseResourceRequirements {
        /**
         * Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and Instance start.
         */
        minGuestCpuCount?: number;
        /**
         * Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
         */
        minMemoryMb?: number;
    }
    export interface Schema$LicensesListResponse {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of License resources.
         */
        items?: Schema$License[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Specifies what kind of log the caller must write
     */
    export interface Schema$LogConfig {
        /**
         * Cloud audit options.
         */
        cloudAudit?: Schema$LogConfigCloudAuditOptions;
        /**
         * Counter options.
         */
        counter?: Schema$LogConfigCounterOptions;
        /**
         * Data access options.
         */
        dataAccess?: Schema$LogConfigDataAccessOptions;
    }
    /**
     * Write a Cloud Audit log
     */
    export interface Schema$LogConfigCloudAuditOptions {
        /**
         * Information used by the Cloud Audit Logging pipeline.
         */
        authorizationLoggingOptions?: Schema$AuthorizationLoggingOptions;
        /**
         * The log_name to populate in the Cloud Audit Record.
         */
        logName?: string;
    }
    /**
     * Increment a streamz counter with the specified metric and field names.  Metric names should start with a &#39;/&#39;, generally be lowercase-only, and end in &quot;_count&quot;. Field names should not contain an initial slash. The actual exported metric names will have &quot;/iam/policy&quot; prepended.  Field names correspond to IAM request parameters and field values are their respective values.  Supported field names: - &quot;authority&quot;, which is &quot;[token]&quot; if IAMContext.token is present, otherwise the value of IAMContext.authority_selector if present, and otherwise a representation of IAMContext.principal; or - &quot;iam_principal&quot;, a representation of IAMContext.principal even if a token or authority selector is present; or - &quot;&quot; (empty string), resulting in a counter with no fields.  Examples: counter { metric: &quot;/debug_access_count&quot; field: &quot;iam_principal&quot; } ==&gt; increment counter /iam/policy/backend_debug_access_count {iam_principal=[value of IAMContext.principal]}  At this time we do not support multiple field names (though this may be supported in the future).
     */
    export interface Schema$LogConfigCounterOptions {
        /**
         * The field value to attribute.
         */
        field?: string;
        /**
         * The metric to update.
         */
        metric?: string;
    }
    /**
     * Write a Data Access (Gin) log
     */
    export interface Schema$LogConfigDataAccessOptions {
        /**
         * Whether Gin logging should happen in a fail-closed manner at the caller. This is relevant only in the LocalIAM implementation, for now.
         */
        logMode?: string;
    }
    /**
     * Represents a Machine Type resource.  You can use specific machine types for your VM instances based on performance and pricing requirements. For more information, read Machine Types. (== resource_for v1.machineTypes ==) (== resource_for beta.machineTypes ==)
     */
    export interface Schema$MachineType {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] The deprecation status associated with this machine type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional textual description of the resource.
         */
        description?: string;
        /**
         * [Output Only] The number of virtual CPUs that are available to the instance.
         */
        guestCpus?: number;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Deprecated] This property is deprecated and will never be populated with any relevant values.
         */
        imageSpaceGb?: number;
        /**
         * [Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.
         */
        isSharedCpu?: boolean;
        /**
         * [Output Only] The type of the resource. Always compute#machineType for machine types.
         */
        kind?: string;
        /**
         * [Output Only] Maximum persistent disks allowed.
         */
        maximumPersistentDisks?: number;
        /**
         * [Output Only] Maximum total persistent disks size (GB) allowed.
         */
        maximumPersistentDisksSizeGb?: string;
        /**
         * [Output Only] The amount of physical memory available to the instance, defined in MB.
         */
        memoryMb?: number;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string;
        /**
         * [Output Only] A list of extended scratch disks assigned to the instance.
         */
        scratchDisks?: Array<{
            diskGb?: number;
        }>;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
         */
        zone?: string;
    }
    export interface Schema$MachineTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of MachineTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$MachineTypesScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#machineTypeAggregatedList for aggregated lists of machine types.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of machine types.
     */
    export interface Schema$MachineTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of MachineType resources.
         */
        items?: Schema$MachineType[];
        /**
         * [Output Only] Type of resource. Always compute#machineTypeList for lists of machine types.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$MachineTypesScopedList {
        /**
         * [Output Only] A list of machine types contained in this scope.
         */
        machineTypes?: Schema$MachineType[];
        /**
         * [Output Only] An informational warning that appears when the machine types list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A Managed Instance resource.
     */
    export interface Schema$ManagedInstance {
        /**
         * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values:  - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance.  - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.  - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group&#39;s targetSize value is decreased instead.  - RECREATING The managed instance group is recreating this instance.  - DELETING The managed instance group is permanently deleting this instance.  - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.  - RESTARTING The managed instance group is restarting the instance.  - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.  - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
         */
        currentAction?: string;
        /**
         * [Output only] The unique identifier for this resource. This field is empty when instance does not exist.
         */
        id?: string;
        /**
         * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
         */
        instance?: string;
        /**
         * [Output Only] The status of the instance. This field is empty when the instance does not exist.
         */
        instanceStatus?: string;
        /**
         * [Output Only] Information about the last attempt to create or delete the instance.
         */
        lastAttempt?: Schema$ManagedInstanceLastAttempt;
        /**
         * [Output Only] Intended version of this instance.
         */
        version?: Schema$ManagedInstanceVersion;
    }
    export interface Schema$ManagedInstanceLastAttempt {
        /**
         * [Output Only] Encountered errors during the last attempt to create or delete the instance.
         */
        errors?: {
            errors?: Array<{
                code?: string;
                location?: string;
                message?: string;
            }>;
        };
    }
    export interface Schema$ManagedInstanceVersion {
        /**
         * [Output Only] The intended template of the instance. This field is empty when current_action is one of { DELETING, ABANDONING }.
         */
        instanceTemplate?: string;
        /**
         * [Output Only] Name of the version.
         */
        name?: string;
    }
    /**
     * A metadata key/value entry.
     */
    export interface Schema$Metadata {
        /**
         * Specifies a fingerprint for this request, which is essentially a hash of the metadata&#39;s contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve the resource.
         */
        fingerprint?: string;
        /**
         * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
         */
        items?: Array<{
            key?: string;
            value?: string;
        }>;
        /**
         * [Output Only] Type of the resource. Always compute#metadata for metadata.
         */
        kind?: string;
    }
    /**
     * The named port. For example: .
     */
    export interface Schema$NamedPort {
        /**
         * The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string;
        /**
         * The port number, which can be a value between 1 and 65535.
         */
        port?: number;
    }
    /**
     * Represents a VPC Network resource.  Networks connect resources to each other and to the internet. For more information, read Virtual Private Cloud (VPC) Network. (== resource_for v1.networks ==) (== resource_for beta.networks ==)
     */
    export interface Schema$Network {
        /**
         * When set to true, the VPC network is created in &quot;auto&quot; mode. When set to false, the VPC network is created in &quot;custom&quot; mode.  An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges.
         */
        autoCreateSubnetworks?: boolean;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The gateway address for default routing out of the network, selected by GCP.
         */
        gatewayIPv4?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
         */
        IPv4Range?: string;
        /**
         * [Output Only] Type of the resource. Always compute#network for networks.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string;
        /**
         * [Output Only] A list of network peerings for the resource.
         */
        peerings?: Schema$NetworkPeering[];
        /**
         * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
         */
        routingConfig?: Schema$NetworkRoutingConfig;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
         */
        subnetworks?: string[];
    }
    /**
     * The network endpoint.
     */
    export interface Schema$NetworkEndpoint {
        /**
         * The name for a specific VM instance that the IP address belongs to. This is required for network endpoints of type GCE_VM_IP_PORT. The instance must be in the same zone of network endpoint group.  The name must be 1-63 characters long, and comply with RFC1035.
         */
        instance?: string;
        /**
         * Optional IPv4 address of network endpoint. The IP address must belong to a VM in Compute Engine (either the primary IP or as part of an aliased IP range). If the IP address is not specified, then the primary IP address for the VM instance in the network that the network endpoint group belongs to will be used.
         */
        ipAddress?: string;
        /**
         * Optional port number of network endpoint. If not specified and the NetworkEndpointGroup.network_endpoint_type is GCE_IP_PORT, the defaultPort for the network endpoint group will be used.
         */
        port?: number;
    }
    /**
     * Represents a collection of network endpoints.
     */
    export interface Schema$NetworkEndpointGroup {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * The default port used if the port number is not specified in the network endpoint.
         */
        defaultPort?: number;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
         */
        kind?: string;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The URL of the network to which all network endpoints in the NEG belong. Uses &quot;default&quot; project network if unspecified.
         */
        network?: string;
        /**
         * Type of network endpoints in this network endpoint group. Currently the only supported value is GCE_VM_IP_PORT.
         */
        networkEndpointType?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output only] Number of network endpoints in the network endpoint group.
         */
        size?: number;
        /**
         * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
         */
        subnetwork?: string;
        /**
         * [Output Only] The URL of the zone where the network endpoint group is located.
         */
        zone?: string;
    }
    export interface Schema$NetworkEndpointGroupAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of NetworkEndpointGroupsScopedList resources.
         */
        items?: {
            [key: string]: Schema$NetworkEndpointGroupsScopedList;
        };
        /**
         * [Output Only] The resource type, which is always compute#networkEndpointGroupAggregatedList for aggregated lists of network endpoint groups.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$NetworkEndpointGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of NetworkEndpointGroup resources.
         */
        items?: Schema$NetworkEndpointGroup[];
        /**
         * [Output Only] The resource type, which is always compute#networkEndpointGroupList for network endpoint group lists.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$NetworkEndpointGroupsAttachEndpointsRequest {
        /**
         * The list of network endpoints to be attached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$NetworkEndpointGroupsDetachEndpointsRequest {
        /**
         * The list of network endpoints to be detached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$NetworkEndpointGroupsListEndpointsRequest {
        /**
         * Optional query parameter for showing the health status of each network endpoint. Valid options are SKIP or SHOW. If you don&#39;t specifiy this parameter, the health status of network endpoints will not be provided.
         */
        healthStatus?: string;
    }
    export interface Schema$NetworkEndpointGroupsListNetworkEndpoints {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of NetworkEndpointWithHealthStatus resources.
         */
        items?: Schema$NetworkEndpointWithHealthStatus[];
        /**
         * [Output Only] The resource type, which is always compute#networkEndpointGroupsListNetworkEndpoints for the list of network endpoints in the specified network endpoint group.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$NetworkEndpointGroupsScopedList {
        /**
         * [Output Only] The list of network endpoint groups that are contained in this scope.
         */
        networkEndpointGroups?: Schema$NetworkEndpointGroup[];
        /**
         * [Output Only] An informational warning that replaces the list of network endpoint groups when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$NetworkEndpointWithHealthStatus {
        /**
         * [Output only] The health status of network endpoint;
         */
        healths?: Schema$HealthStatusForNetworkEndpoint[];
        /**
         * [Output only] The network endpoint;
         */
        networkEndpoint?: Schema$NetworkEndpoint;
    }
    /**
     * A network interface resource attached to an instance.
     */
    export interface Schema$NetworkInterface {
        /**
         * An array of configurations for this interface. Currently, only one access config, ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance will have no external internet access.
         */
        accessConfigs?: Schema$AccessConfig[];
        /**
         * An array of alias IP ranges for this network interface. You can only specify this field for network interfaces in VPC networks.
         */
        aliasIpRanges?: Schema$AliasIpRange[];
        /**
         * Fingerprint hash of contents stored in this network interface. This field will be ignored when inserting an Instance or adding a NetworkInterface. An up-to-date fingerprint must be provided in order to update the NetworkInterface, otherwise the request will fail with error 412 conditionNotMet.
         */
        fingerprint?: string;
        /**
         * [Output Only] Type of the resource. Always compute#networkInterface for network interfaces.
         */
        kind?: string;
        /**
         * [Output Only] The name of the network interface, which is generated by the server. For network devices, these are eth0, eth1, etc.
         */
        name?: string;
        /**
         * URL of the network resource for this instance. When creating an instance, if neither the network nor the subnetwork is specified, the default network global/networks/default is used; if the network is not specified but the subnetwork is specified, the network is inferred.  If you specify this property, you can specify the network as a full or partial URL. For example, the following are all valid URLs:   - https://www.googleapis.com/compute/v1/projects/project/global/networks/network  - projects/project/global/networks/network  - global/networks/default
         */
        network?: string;
        /**
         * An IPv4 internal IP address to assign to the instance for this network interface. If not specified by the user, an unused internal IP is assigned by the system.
         */
        networkIP?: string;
        /**
         * The URL of the Subnetwork resource for this instance. If the network resource is in legacy mode, do not specify this field. If the network is in auto subnet mode, specifying the subnetwork is optional. If the network is in custom subnet mode, specifying the subnetwork is required. If you specify this field, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs:   - https://www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/subnetwork  - regions/region/subnetworks/subnetwork
         */
        subnetwork?: string;
    }
    /**
     * Contains a list of networks.
     */
    export interface Schema$NetworkList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Network resources.
         */
        items?: Schema$Network[];
        /**
         * [Output Only] Type of resource. Always compute#networkList for lists of networks.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A network peering attached to a network resource. The message includes the peering name, peer network, peering state, and a flag indicating whether Google Compute Engine should automatically create routes for the peering.
     */
    export interface Schema$NetworkPeering {
        /**
         * This field will be deprecated soon. Use the exchange_subnet_routes field instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
         */
        autoCreateRoutes?: boolean;
        /**
         * Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
         */
        exchangeSubnetRoutes?: boolean;
        /**
         * Whether to export the custom routes to peer network.
         */
        exportCustomRoutes?: boolean;
        /**
         * Whether to import the custom routes from peer network.
         */
        importCustomRoutes?: boolean;
        /**
         * Name of this peering. Provided by the client when the peering is created. The name must comply with RFC1035. Specifically, the name must be 1-63 characters long and match regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all the following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.
         */
        network?: string;
        /**
         * [Output Only] State for the peering, either `ACTIVE` or `INACTIVE`. The peering is `ACTIVE` when there&#39;s a matching configuration in the peer network.
         */
        state?: string;
        /**
         * [Output Only] Details about the current state of the peering.
         */
        stateDetails?: string;
    }
    /**
     * A routing configuration attached to a network resource. The message includes the list of routers associated with the network, and a flag indicating the type of routing behavior to enforce network-wide.
     */
    export interface Schema$NetworkRoutingConfig {
        /**
         * The network-wide routing mode to use. If set to REGIONAL, this network&#39;s Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network&#39;s Cloud Routers will advertise routes with all subnets of this network, across regions.
         */
        routingMode?: string;
    }
    export interface Schema$NetworksAddPeeringRequest {
        /**
         * This field will be deprecated soon. Use exchange_subnet_routes in network_peering instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
         */
        autoCreateRoutes?: boolean;
        /**
         * Name of the peering, which should conform to RFC1035.
         */
        name?: string;
        /**
         * Network peering parameters. In order to specify route policies for peering using import and export custom routes, you must specify all peering related parameters (name, peer network, exchange_subnet_routes) in the network_peering field. The corresponding fields in NetworksAddPeeringRequest will be deprecated soon.
         */
        networkPeering?: Schema$NetworkPeering;
        /**
         * URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.
         */
        peerNetwork?: string;
    }
    export interface Schema$NetworksRemovePeeringRequest {
        /**
         * Name of the peering, which should conform to RFC1035.
         */
        name?: string;
    }
    export interface Schema$NetworksUpdatePeeringRequest {
        networkPeering?: Schema$NetworkPeering;
    }
    /**
     * Represent a sole-tenant Node Group resource.  A sole-tenant node is a physical server that is dedicated to hosting VM instances only for your specific project. Use sole-tenant nodes to keep your instances physically separated from instances in other projects, or to group your instances together on the same host hardware. For more information, read Sole-tenant nodes. (== resource_for beta.nodeGroups ==) (== resource_for v1.nodeGroups ==) NextID: 15
     */
    export interface Schema$NodeGroup {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
         */
        kind?: string;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The URL of the node template to which this node group belongs.
         */
        nodeTemplate?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The total number of nodes in the node group.
         */
        size?: number;
        status?: string;
        /**
         * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
         */
        zone?: string;
    }
    export interface Schema$NodeGroupAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of NodeGroupsScopedList resources.
         */
        items?: {
            [key: string]: Schema$NodeGroupsScopedList;
        };
        /**
         * [Output Only] Type of resource.Always compute#nodeGroupAggregatedList for aggregated lists of node groups.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of nodeGroups.
     */
    export interface Schema$NodeGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of NodeGroup resources.
         */
        items?: Schema$NodeGroup[];
        /**
         * [Output Only] Type of resource.Always compute#nodeGroupList for lists of node groups.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$NodeGroupNode {
        /**
         * Instances scheduled on this node.
         */
        instances?: string[];
        /**
         * The name of the node.
         */
        name?: string;
        /**
         * The type of this node.
         */
        nodeType?: string;
        /**
         * Binding properties for the physical server.
         */
        serverBinding?: Schema$ServerBinding;
        status?: string;
    }
    export interface Schema$NodeGroupsAddNodesRequest {
        /**
         * Count of additional nodes to be added to the node group.
         */
        additionalNodeCount?: number;
    }
    export interface Schema$NodeGroupsDeleteNodesRequest {
        /**
         * Names of the nodes to delete.
         */
        nodes?: string[];
    }
    export interface Schema$NodeGroupsListNodes {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Node resources.
         */
        items?: Schema$NodeGroupNode[];
        /**
         * [Output Only] The resource type, which is always compute.nodeGroupsListNodes for the list of nodes in the specified node group.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$NodeGroupsScopedList {
        /**
         * [Output Only] A list of node groups contained in this scope.
         */
        nodeGroups?: Schema$NodeGroup[];
        /**
         * [Output Only] An informational warning that appears when the nodeGroup list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$NodeGroupsSetNodeTemplateRequest {
        /**
         * Full or partial URL of the node template resource to be updated for this node group.
         */
        nodeTemplate?: string;
    }
    /**
     * Represent a sole-tenant Node Template resource.  You can use a template to define properties for nodes in a node group. For more information, read Creating node groups and instances. (== resource_for beta.nodeTemplates ==) (== resource_for v1.nodeTemplates ==) (== NextID: 16 ==)
     */
    export interface Schema$NodeTemplate {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
         */
        kind?: string;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Labels to use for node affinity, which will be used in instance scheduling.
         */
        nodeAffinityLabels?: {
            [key: string]: string;
        };
        /**
         * The node type to use for nodes group that are created from this template.
         */
        nodeType?: string;
        /**
         * The flexible properties of the desired node type. Node groups that use this node template will create nodes of a type that matches these properties.  This field is mutually exclusive with the node_type property; you can only define one or the other, but not both.
         */
        nodeTypeFlexibility?: Schema$NodeTemplateNodeTypeFlexibility;
        /**
         * [Output Only] The name of the region where the node template resides, such as us-central1.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * Sets the binding properties for the physical server. Valid values include:   - [Default] RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server  - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible    See Sole-tenant node options for more information.
         */
        serverBinding?: Schema$ServerBinding;
        /**
         * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
         */
        status?: string;
        /**
         * [Output Only] An optional, human-readable explanation of the status.
         */
        statusMessage?: string;
    }
    export interface Schema$NodeTemplateAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of NodeTemplatesScopedList resources.
         */
        items?: {
            [key: string]: Schema$NodeTemplatesScopedList;
        };
        /**
         * [Output Only] Type of resource.Always compute#nodeTemplateAggregatedList for aggregated lists of node templates.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of node templates.
     */
    export interface Schema$NodeTemplateList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of NodeTemplate resources.
         */
        items?: Schema$NodeTemplate[];
        /**
         * [Output Only] Type of resource.Always compute#nodeTemplateList for lists of node templates.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$NodeTemplateNodeTypeFlexibility {
        cpus?: string;
        localSsd?: string;
        memory?: string;
    }
    export interface Schema$NodeTemplatesScopedList {
        /**
         * [Output Only] A list of node templates contained in this scope.
         */
        nodeTemplates?: Schema$NodeTemplate[];
        /**
         * [Output Only] An informational warning that appears when the node templates list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represent a sole-tenant Node Type resource.  Each node within a node group must have a node type. A node type specifies the total amount of cores and memory for that node. Currently, the only available node type is n1-node-96-624 node type that has 96 vCPUs and 624 GB of memory, available in multiple zones. For more information read Node types. (== resource_for beta.nodeTypes ==) (== resource_for v1.nodeTypes ==)
     */
    export interface Schema$NodeType {
        /**
         * [Output Only] The CPU platform used by this node type.
         */
        cpuPlatform?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] The deprecation status associated with this node type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional textual description of the resource.
         */
        description?: string;
        /**
         * [Output Only] The number of virtual CPUs that are available to the node type.
         */
        guestCpus?: number;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] The type of the resource. Always compute#nodeType for node types.
         */
        kind?: string;
        /**
         * [Output Only] Local SSD available to the node type, defined in GB.
         */
        localSsdGb?: number;
        /**
         * [Output Only] The amount of physical memory available to the node type, defined in MB.
         */
        memoryMb?: number;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The name of the zone where the node type resides, such as us-central1-a.
         */
        zone?: string;
    }
    export interface Schema$NodeTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of NodeTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$NodeTypesScopedList;
        };
        /**
         * [Output Only] Type of resource.Always compute#nodeTypeAggregatedList for aggregated lists of node types.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of node types.
     */
    export interface Schema$NodeTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of NodeType resources.
         */
        items?: Schema$NodeType[];
        /**
         * [Output Only] Type of resource.Always compute#nodeTypeList for lists of node types.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$NodeTypesScopedList {
        /**
         * [Output Only] A list of node types contained in this scope.
         */
        nodeTypes?: Schema$NodeType[];
        /**
         * [Output Only] An informational warning that appears when the node types list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents an Operation resource.  You can use an operation resource to manage asynchronous API requests. For more information, read Handling API responses.  Operations can be global, regional or zonal.   - For global operations, use the globalOperations resource.  - For regional operations, use the regionOperations resource.  - For zonal operations, use the zonalOperations resource.    For more information, read  Global, Regional, and Zonal Resources. (== resource_for v1.globalOperations ==) (== resource_for beta.globalOperations ==) (== resource_for v1.regionOperations ==) (== resource_for beta.regionOperations ==) (== resource_for v1.zoneOperations ==) (== resource_for beta.zoneOperations ==)
     */
    export interface Schema$Operation {
        /**
         * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
         */
        clientOperationId?: string;
        /**
         * [Deprecated] This field is deprecated.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] A textual description of the operation, which is set when the operation is created.
         */
        description?: string;
        /**
         * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
         */
        endTime?: string;
        /**
         * [Output Only] If errors are generated during processing of the operation, this field will be populated.
         */
        error?: {
            errors?: Array<{
                code?: string;
                location?: string;
                message?: string;
            }>;
        };
        /**
         * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as NOT FOUND.
         */
        httpErrorMessage?: string;
        /**
         * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a 404 means the resource was not found.
         */
        httpErrorStatusCode?: number;
        /**
         * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
         */
        insertTime?: string;
        /**
         * [Output Only] Type of the resource. Always compute#operation for Operation resources.
         */
        kind?: string;
        /**
         * [Output Only] Name of the operation.
         */
        name?: string;
        /**
         * [Output Only] The type of operation, such as insert, update, or delete, and so on.
         */
        operationType?: string;
        /**
         * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
         */
        progress?: number;
        /**
         * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
         */
        startTime?: string;
        /**
         * [Output Only] The status of the operation, which can be one of the following: PENDING, RUNNING, or DONE.
         */
        status?: string;
        /**
         * [Output Only] An optional textual description of the current status of the operation.
         */
        statusMessage?: string;
        /**
         * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
         */
        targetId?: string;
        /**
         * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
         */
        targetLink?: string;
        /**
         * [Output Only] User who requested the operation, for example: user@example.com.
         */
        user?: string;
        /**
         * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
         */
        warnings?: Array<{
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        }>;
        /**
         * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
         */
        zone?: string;
    }
    export interface Schema$OperationAggregatedList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] A map of scoped operation lists.
         */
        items?: {
            [key: string]: Schema$OperationsScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#operationAggregatedList for aggregated lists of operations.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of Operation resources.
     */
    export interface Schema$OperationList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] A list of Operation resources.
         */
        items?: Schema$Operation[];
        /**
         * [Output Only] Type of resource. Always compute#operations for Operations resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$OperationsScopedList {
        /**
         * [Output Only] A list of operations contained in this scope.
         */
        operations?: Schema$Operation[];
        /**
         * [Output Only] Informational warning which replaces the list of operations when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A matcher for the path portion of the URL. The BackendService from the longest-matched rule will serve the URL. If no rule was matched, the default service will be used.
     */
    export interface Schema$PathMatcher {
        /**
         * The full or partial URL to the BackendService resource. This will be used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource:   - https://www.googleapis.com/compute/v1/projects/project/global/backendServices/backendService  - compute/v1/projects/project/global/backendServices/backendService  - global/backendServices/backendService  If defaultRouteAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. Only one of defaultService, defaultUrlRedirect  or defaultRouteAction.weightedBackendService must be set. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service:   - compute.backendBuckets.use  - compute.backendServices.use
         */
        defaultService?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * The name to which this PathMatcher is referred by the HostRule.
         */
        name?: string;
        /**
         * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that&#39;s required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/* will match before /a/b/* irrespective of the order in which those paths appear in this list. Only one of pathRules or routeRules must be set.
         */
        pathRules?: Schema$PathRule[];
    }
    /**
     * A path-matching rule for a URL. If matched, will use the specified BackendService to handle the traffic arriving at this URL.
     */
    export interface Schema$PathRule {
        /**
         * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
         */
        paths?: string[];
        /**
         * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendService s. Conversely, if routeAction specifies any  weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
         */
        service?: string;
    }
    /**
     * Defines an Identity and Access Management (IAM) policy. It is used to specify access control policies for Cloud Platform resources.    A `Policy` consists of a list of `bindings`. A `binding` binds a list of `members` to a `role`, where the members can be user accounts, Google groups, Google domains, and service accounts. A `role` is a named list of permissions defined by IAM.  **JSON Example**  { &quot;bindings&quot;: [ { &quot;role&quot;: &quot;roles/owner&quot;, &quot;members&quot;: [ &quot;user:mike@example.com&quot;, &quot;group:admins@example.com&quot;, &quot;domain:google.com&quot;, &quot;serviceAccount:my-other-app@appspot.gserviceaccount.com&quot; ] }, { &quot;role&quot;: &quot;roles/viewer&quot;, &quot;members&quot;: [&quot;user:sean@example.com&quot;] } ] }  **YAML Example**  bindings: - members: - user:mike@example.com - group:admins@example.com - domain:google.com - serviceAccount:my-other-app@appspot.gserviceaccount.com role: roles/owner - members: - user:sean@example.com role: roles/viewer    For a description of IAM and its features, see the [IAM developer&#39;s guide](https://cloud.google.com/iam/docs).
     */
    export interface Schema$Policy {
        /**
         * Specifies cloud audit logging configuration for this policy.
         */
        auditConfigs?: Schema$AuditConfig[];
        /**
         * Associates a list of `members` to a `role`. `bindings` with no members will result in an error.
         */
        bindings?: Schema$Binding[];
        /**
         * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy.  If no `etag` is provided in the call to `setIamPolicy`, then the existing policy is overwritten.
         */
        etag?: string;
        iamOwned?: boolean;
        /**
         * If more than one rule is specified, the rules are applied in the following manner: - All matching LOG rules are always applied. - If any DENY/DENY_WITH_LOG rule matches, permission is denied. Logging will be applied if one or more matching rule requires logging. - Otherwise, if any ALLOW/ALLOW_WITH_LOG rule matches, permission is granted. Logging will be applied if one or more matching rule requires logging. - Otherwise, if no rule applies, permission is denied.
         */
        rules?: Schema$Rule[];
        /**
         * Deprecated.
         */
        version?: number;
    }
    /**
     * Represents a Project resource.  A project is used to organize resources in a Google Cloud Platform environment. For more information, read about the  Resource Hierarchy. (== resource_for v1.projects ==) (== resource_for beta.projects ==)
     */
    export interface Schema$Project {
        /**
         * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
         */
        commonInstanceMetadata?: Schema$Metadata;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
         */
        defaultNetworkTier?: string;
        /**
         * [Output Only] Default service account used by VMs running in this project.
         */
        defaultServiceAccount?: string;
        /**
         * An optional textual description of the resource.
         */
        description?: string;
        /**
         * Restricted features enabled for use on this project.
         */
        enabledFeatures?: string[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server. This is not the project ID, and is just a unique ID used by Compute Engine to identify resources.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#project for projects.
         */
        kind?: string;
        /**
         * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
         */
        name?: string;
        /**
         * [Output Only] Quotas assigned to this project.
         */
        quotas?: Schema$Quota[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * The naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
         */
        usageExportLocation?: Schema$UsageExportLocation;
        /**
         * [Output Only] The role this project has in a shared VPC configuration. Currently only HOST projects are differentiated.
         */
        xpnProjectStatus?: string;
    }
    export interface Schema$ProjectsDisableXpnResourceRequest {
        /**
         * Service resource (a.k.a service project) ID.
         */
        xpnResource?: Schema$XpnResourceId;
    }
    export interface Schema$ProjectsEnableXpnResourceRequest {
        /**
         * Service resource (a.k.a service project) ID.
         */
        xpnResource?: Schema$XpnResourceId;
    }
    export interface Schema$ProjectsGetXpnResources {
        /**
         * [Output Only] Type of resource. Always compute#projectsGetXpnResources for lists of service resources (a.k.a service projects)
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * Service resources (a.k.a service projects) attached to this project as their shared VPC host.
         */
        resources?: Schema$XpnResourceId[];
    }
    export interface Schema$ProjectsListXpnHostsRequest {
        /**
         * Optional organization ID managed by Cloud Resource Manager, for which to list shared VPC host projects. If not specified, the organization will be inferred from the project.
         */
        organization?: string;
    }
    export interface Schema$ProjectsSetDefaultNetworkTierRequest {
        /**
         * Default network tier to be set.
         */
        networkTier?: string;
    }
    /**
     * A quotas entry.
     */
    export interface Schema$Quota {
        /**
         * [Output Only] Quota limit for this metric.
         */
        limit?: number;
        /**
         * [Output Only] Name of the quota metric.
         */
        metric?: string;
        /**
         * [Output Only] Owning resource. This is the resource on which this quota is applied.
         */
        owner?: string;
        /**
         * [Output Only] Current usage of this metric.
         */
        usage?: number;
    }
    /**
     * Represents a reference to a resource.
     */
    export interface Schema$Reference {
        /**
         * [Output Only] Type of the resource. Always compute#reference for references.
         */
        kind?: string;
        /**
         * A description of the reference type with no implied semantics. Possible values include:   - MEMBER_OF
         */
        referenceType?: string;
        /**
         * URL of the resource which refers to the target.
         */
        referrer?: string;
        /**
         * URL of the resource to which this reference points.
         */
        target?: string;
    }
    /**
     * Represents a Region resource.  A region is a geographical area where a resource is located. For more information, read Regions and Zones. (== resource_for beta.regions ==) (== resource_for v1.regions ==)
     */
    export interface Schema$Region {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] The deprecation status associated with this region.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] Textual description of the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#region for regions.
         */
        kind?: string;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string;
        /**
         * [Output Only] Quotas assigned to this region.
         */
        quotas?: Schema$Quota[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Status of the region, either UP or DOWN.
         */
        status?: string;
        /**
         * [Output Only] A list of zones available in this region, in the form of resource URLs.
         */
        zones?: string[];
    }
    /**
     * Contains a list of autoscalers.
     */
    export interface Schema$RegionAutoscalerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Autoscaler resources.
         */
        items?: Schema$Autoscaler[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$RegionDisksAddResourcePoliciesRequest {
        /**
         * Resource policies to be added to this disk.
         */
        resourcePolicies?: string[];
    }
    export interface Schema$RegionDisksRemoveResourcePoliciesRequest {
        /**
         * Resource policies to be removed from this disk.
         */
        resourcePolicies?: string[];
    }
    export interface Schema$RegionDisksResizeRequest {
        /**
         * The new size of the regional persistent disk, which is specified in GB.
         */
        sizeGb?: string;
    }
    export interface Schema$RegionDiskTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of DiskType resources.
         */
        items?: Schema$DiskType[];
        /**
         * [Output Only] Type of resource. Always compute#regionDiskTypeList for region disk types.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of InstanceGroup resources.
     */
    export interface Schema$RegionInstanceGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InstanceGroup resources.
         */
        items?: Schema$InstanceGroup[];
        /**
         * The resource type.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of managed instance groups.
     */
    export interface Schema$RegionInstanceGroupManagerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InstanceGroupManager resources.
         */
        items?: Schema$InstanceGroupManager[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of managed instance groups that exist in th regional scope.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$RegionInstanceGroupManagersAbandonInstancesRequest {
        /**
         * The URLs of one or more instances to abandon. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[];
    }
    export interface Schema$RegionInstanceGroupManagersDeleteInstancesRequest {
        /**
         * The URLs of one or more instances to delete. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[];
    }
    export interface Schema$RegionInstanceGroupManagersListInstancesResponse {
        /**
         * A list of managed instances.
         */
        managedInstances?: Schema$ManagedInstance[];
    }
    export interface Schema$RegionInstanceGroupManagersRecreateRequest {
        /**
         * The URLs of one or more instances to recreate. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[];
    }
    export interface Schema$RegionInstanceGroupManagersSetTargetPoolsRequest {
        /**
         * Fingerprint of the target pools information, which is a hash of the contents. This field is used for optimistic locking when you update the target pool entries. This field is optional.
         */
        fingerprint?: string;
        /**
         * The URL of all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
         */
        targetPools?: string[];
    }
    export interface Schema$RegionInstanceGroupManagersSetTemplateRequest {
        /**
         * URL of the InstanceTemplate resource from which all new instances will be created.
         */
        instanceTemplate?: string;
    }
    export interface Schema$RegionInstanceGroupsListInstances {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of InstanceWithNamedPorts resources.
         */
        items?: Schema$InstanceWithNamedPorts[];
        /**
         * The resource type.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$RegionInstanceGroupsListInstancesRequest {
        /**
         * Instances in which state should be returned. Valid options are: &#39;ALL&#39;, &#39;RUNNING&#39;. By default, it lists all instances.
         */
        instanceState?: string;
        /**
         * Name of port user is interested in. It is optional. If it is set, only information about this ports will be returned. If it is not set, all the named ports will be returned. Always lists all instances.
         */
        portName?: string;
    }
    export interface Schema$RegionInstanceGroupsSetNamedPortsRequest {
        /**
         * The fingerprint of the named ports information for this instance group. Use this optional property to prevent conflicts when multiple users change the named ports settings concurrently. Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request.
         */
        fingerprint?: string;
        /**
         * The list of named ports to set for this instance group.
         */
        namedPorts?: Schema$NamedPort[];
    }
    /**
     * Contains a list of region resources.
     */
    export interface Schema$RegionList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Region resources.
         */
        items?: Schema$Region[];
        /**
         * [Output Only] Type of resource. Always compute#regionList for lists of regions.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$RegionSetLabelsRequest {
        /**
         * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. Make a get() request to the resource to get the latest fingerprint.
         */
        labelFingerprint?: string;
        /**
         * The labels to set for this resource.
         */
        labels?: {
            [key: string]: string;
        };
    }
    export interface Schema$RegionSetPolicyRequest {
        /**
         * Flatten Policy to create a backwacd compatible wire-format. Deprecated. Use &#39;policy&#39; to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use &#39;policy&#39; to specify the etag.
         */
        etag?: string;
        /**
         * REQUIRED: The complete policy to be applied to the &#39;resource&#39;. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    /**
     * Represents a reservation resource. A reservation ensures that capacity is held in a specific zone even if the reserved VMs are not running. For more information, read  Reserving zonal resources. (== resource_for beta.reservations ==) (== resource_for v1.reservations ==)
     */
    export interface Schema$Reservation {
        /**
         * [OutputOnly] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
         */
        commitment?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#reservations for reservations.
         */
        kind?: string;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string;
        /**
         * Reservation for instances with specific machine shapes.
         */
        specificReservation?: Schema$AllocationSpecificSKUReservation;
        /**
         * Indicates whether the reservation can be consumed by VMs with affinity for &quot;any&quot; reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
         */
        specificReservationRequired?: boolean;
        /**
         * [Output Only] The status of the reservation.
         */
        status?: string;
        /**
         * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
         */
        zone?: string;
    }
    /**
     * Specifies the reservations that this instance can consume from.
     */
    export interface Schema$ReservationAffinity {
        /**
         * Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See  Consuming reserved instances for examples.
         */
        consumeReservationType?: string;
        /**
         * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify googleapis.com/reservation-name as the key and specify the name of your reservation as its value.
         */
        key?: string;
        /**
         * Corresponds to the label values of a reservation resource.
         */
        values?: string[];
    }
    /**
     * Contains a list of reservations.
     */
    export interface Schema$ReservationAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Allocation resources.
         */
        items?: {
            [key: string]: Schema$ReservationsScopedList;
        };
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$ReservationList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] A list of Allocation resources.
         */
        items?: Schema$Reservation[];
        /**
         * [Output Only] Type of resource.Always compute#reservationsList for listsof reservations
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$ReservationsResizeRequest {
        /**
         * Number of allocated resources can be resized with minimum = 1 and maximum = 1000.
         */
        specificSkuCount?: string;
    }
    export interface Schema$ReservationsScopedList {
        /**
         * A list of reservations contained in this scope.
         */
        reservations?: Schema$Reservation[];
        /**
         * Informational warning which replaces the list of reservations when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Commitment for a particular resource (a Commitment is composed of one or more of these).
     */
    export interface Schema$ResourceCommitment {
        /**
         * Name of the accelerator type resource. Applicable only when the type is ACCELERATOR.
         */
        acceleratorType?: string;
        /**
         * The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of 256 MB, with up to 6.5GB of memory per every vCPU.
         */
        amount?: string;
        /**
         * Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
         */
        type?: string;
    }
    export interface Schema$ResourceGroupReference {
        /**
         * A URI referencing one of the instance groups or network endpoint groups listed in the backend service.
         */
        group?: string;
    }
    export interface Schema$ResourcePoliciesScopedList {
        /**
         * A list of resourcePolicies contained in this scope.
         */
        resourcePolicies?: Schema$ResourcePolicy[];
        /**
         * Informational warning which replaces the list of resourcePolicies when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$ResourcePolicy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
         */
        kind?: string;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        region?: string;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string;
        /**
         * Resource policy for persistent disks for creating snapshots.
         */
        snapshotSchedulePolicy?: Schema$ResourcePolicySnapshotSchedulePolicy;
        /**
         * [Output Only] The status of resource policy creation.
         */
        status?: string;
    }
    /**
     * Contains a list of resourcePolicies.
     */
    export interface Schema$ResourcePolicyAggregatedList {
        etag?: string;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of ResourcePolicy resources.
         */
        items?: {
            [key: string]: Schema$ResourcePoliciesScopedList;
        };
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Time window specified for daily operations.
     */
    export interface Schema$ResourcePolicyDailyCycle {
        /**
         * Defines a schedule that runs every nth day of the month.
         */
        daysInCycle?: number;
        /**
         * [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
         */
        duration?: string;
        /**
         * Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
         */
        startTime?: string;
    }
    /**
     * Time window specified for hourly operations.
     */
    export interface Schema$ResourcePolicyHourlyCycle {
        /**
         * [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
         */
        duration?: string;
        /**
         * Allows to define schedule that runs every nth hour.
         */
        hoursInCycle?: number;
        /**
         * Time within the window to start the operations. It must be in format &quot;HH:MM&quot;, where HH : [00-23] and MM : [00-00] GMT.
         */
        startTime?: string;
    }
    export interface Schema$ResourcePolicyList {
        etag?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] A list of ResourcePolicy resources.
         */
        items?: Schema$ResourcePolicy[];
        /**
         * [Output Only] Type of resource.Always compute#resourcePoliciesList for listsof resourcePolicies
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A snapshot schedule policy specifies when and how frequently snapshots are to be created for the target disk. Also specifies how many and how long these scheduled snapshots should be retained.
     */
    export interface Schema$ResourcePolicySnapshotSchedulePolicy {
        /**
         * Retention policy applied to snapshots created by this resource policy.
         */
        retentionPolicy?: Schema$ResourcePolicySnapshotSchedulePolicyRetentionPolicy;
        /**
         * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
         */
        schedule?: Schema$ResourcePolicySnapshotSchedulePolicySchedule;
        /**
         * Properties with which snapshots are created such as labels, encryption keys.
         */
        snapshotProperties?: Schema$ResourcePolicySnapshotSchedulePolicySnapshotProperties;
    }
    /**
     * Policy for retention of scheduled snapshots.
     */
    export interface Schema$ResourcePolicySnapshotSchedulePolicyRetentionPolicy {
        /**
         * Maximum age of the snapshot that is allowed to be kept.
         */
        maxRetentionDays?: number;
        /**
         * Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
         */
        onSourceDiskDelete?: string;
    }
    /**
     * A schedule for disks where the schedueled operations are performed.
     */
    export interface Schema$ResourcePolicySnapshotSchedulePolicySchedule {
        dailySchedule?: Schema$ResourcePolicyDailyCycle;
        hourlySchedule?: Schema$ResourcePolicyHourlyCycle;
        weeklySchedule?: Schema$ResourcePolicyWeeklyCycle;
    }
    /**
     * Specified snapshot properties for scheduled snapshots created by this policy.
     */
    export interface Schema$ResourcePolicySnapshotSchedulePolicySnapshotProperties {
        /**
         * Indication to perform a ?guest aware? snapshot.
         */
        guestFlush?: boolean;
        /**
         * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
         */
        storageLocations?: string[];
    }
    /**
     * Time window specified for weekly operations.
     */
    export interface Schema$ResourcePolicyWeeklyCycle {
        /**
         * Up to 7 intervals/windows, one for each day of the week.
         */
        dayOfWeeks?: Schema$ResourcePolicyWeeklyCycleDayOfWeek[];
    }
    export interface Schema$ResourcePolicyWeeklyCycleDayOfWeek {
        /**
         * Allows to define schedule that runs specified day of the week.
         */
        day?: string;
        /**
         * [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
         */
        duration?: string;
        /**
         * Time within the window to start the operations. It must be in format &quot;HH:MM&quot;, where HH : [00-23] and MM : [00-00] GMT.
         */
        startTime?: string;
    }
    /**
     * Represents a Route resource.  A route defines a path from VM instances in the VPC network to a specific destination. This destination can be inside or outside the VPC network. For more information, read the Routes overview. (== resource_for beta.routes ==) (== resource_for v1.routes ==)
     */
    export interface Schema$Route {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string;
        /**
         * The destination range of outgoing packets that this route applies to. Only IPv4 is supported.
         */
        destRange?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of this resource. Always compute#routes for Route resources.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string;
        /**
         * Fully-qualified URL of the network that this route applies to.
         */
        network?: string;
        /**
         * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL:  projects/project/global/gateways/default-internet-gateway
         */
        nextHopGateway?: string;
        /**
         * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
         */
        nextHopInstance?: string;
        /**
         * The network IP address of an instance that should handle matching packets. Only IPv4 is supported.
         */
        nextHopIp?: string;
        /**
         * The URL of the local network if it should handle matching packets.
         */
        nextHopNetwork?: string;
        /**
         * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
         */
        nextHopPeering?: string;
        /**
         * The URL to a VpnTunnel that should handle matching packets.
         */
        nextHopVpnTunnel?: string;
        /**
         * The priority of this route. Priority is used to break ties in cases where there is more than one matching route of equal prefix length. In cases where multiple routes have equal prefix length, the one with the lowest-numbered priority value wins. The default value is `1000`. The priority value must be from `0` to `65535`, inclusive.
         */
        priority?: number;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string;
        /**
         * A list of instance tags to which this route applies.
         */
        tags?: string[];
        /**
         * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
         */
        warnings?: Array<{
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        }>;
    }
    /**
     * Contains a list of Route resources.
     */
    export interface Schema$RouteList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Route resources.
         */
        items?: Schema$Route[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a Cloud Router resource.  For more information about Cloud Router, read the the Cloud Router overview.
     */
    export interface Schema$Router {
        /**
         * BGP information specific to this router.
         */
        bgp?: Schema$RouterBgp;
        /**
         * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
         */
        bgpPeers?: Schema$RouterBgpPeer[];
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * Router interfaces. Each interface requires either one linked resource, (for example, linkedVpnTunnel), or IP address and IP address range (for example, ipRange), or both.
         */
        interfaces?: Schema$RouterInterface[];
        /**
         * [Output Only] Type of resource. Always compute#router for routers.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * A list of NAT services created in this router.
         */
        nats?: Schema$RouterNat[];
        /**
         * URI of the network to which this router belongs.
         */
        network?: string;
        /**
         * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
    }
    /**
     * Description-tagged IP ranges for the router to advertise.
     */
    export interface Schema$RouterAdvertisedIpRange {
        /**
         * User-specified description for the IP range.
         */
        description?: string;
        /**
         * The IP range to advertise. The value must be a CIDR-formatted string.
         */
        range?: string;
    }
    /**
     * Contains a list of routers.
     */
    export interface Schema$RouterAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Router resources.
         */
        items?: {
            [key: string]: Schema$RoutersScopedList;
        };
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$RouterBgp {
        /**
         * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
         */
        advertisedGroups?: string[];
        /**
         * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
         */
        advertisedIpRanges?: Schema$RouterAdvertisedIpRange[];
        /**
         * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
         */
        advertiseMode?: string;
        /**
         * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
         */
        asn?: number;
    }
    export interface Schema$RouterBgpPeer {
        /**
         * User-specified list of prefix groups to advertise in custom mode, which can take one of the following options:  - ALL_SUBNETS: Advertises all available subnets, including peer VPC subnets.  - ALL_VPC_SUBNETS: Advertises the router&#39;s own VPC subnets.  - ALL_PEER_VPC_SUBNETS: Advertises peer subnets of the router&#39;s VPC network. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the &quot;bgp&quot; message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
         */
        advertisedGroups?: string[];
        /**
         * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the &quot;bgp&quot; message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
         */
        advertisedIpRanges?: Schema$RouterAdvertisedIpRange[];
        /**
         * The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
         */
        advertisedRoutePriority?: number;
        /**
         * User-specified flag to indicate which mode to use for advertisement.
         */
        advertiseMode?: string;
        /**
         * Name of the interface the BGP peer is associated with.
         */
        interfaceName?: string;
        /**
         * IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.
         */
        ipAddress?: string;
        /**
         * [Output Only] The resource that configures and manages this BGP peer.  - MANAGED_BY_USER is the default value and can be managed by you or other users  - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
         */
        managementType?: string;
        /**
         * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
         */
        peerAsn?: number;
        /**
         * IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported.
         */
        peerIpAddress?: string;
    }
    export interface Schema$RouterInterface {
        /**
         * IP address and range of the interface. The IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate the address as it represents the IP address of the interface.
         */
        ipRange?: string;
        /**
         * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be either be a VPN tunnel or an Interconnect attachment.
         */
        linkedInterconnectAttachment?: string;
        /**
         * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be either a VPN tunnel or an Interconnect attachment.
         */
        linkedVpnTunnel?: string;
        /**
         * [Output Only] The resource that configures and manages this interface.  - MANAGED_BY_USER is the default value and can be managed directly by users.  - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
         */
        managementType?: string;
        /**
         * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
    }
    /**
     * Contains a list of Router resources.
     */
    export interface Schema$RouterList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Router resources.
         */
        items?: Schema$Router[];
        /**
         * [Output Only] Type of resource. Always compute#router for routers.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a Nat resource. It enables the VMs within the specified subnetworks to access Internet without external IP addresses. It specifies a list of subnetworks (and the ranges within) that want to use NAT. Customers can also provide the external IPs that would be used for NAT. GCP would auto-allocate ephemeral IPs if no external IPs are provided.
     */
    export interface Schema$RouterNat {
        /**
         * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
         */
        icmpIdleTimeoutSec?: number;
        /**
         * Configure logging on this NAT.
         */
        logConfig?: Schema$RouterNatLogConfig;
        /**
         * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
         */
        minPortsPerVm?: number;
        /**
         * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
         */
        name?: string;
        /**
         * Specify the NatIpAllocateOption, which can take one of the following values:  - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs.  - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can&#39;t specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
         */
        natIpAllocateOption?: string;
        /**
         * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
         */
        natIps?: string[];
        /**
         * Specify the Nat option, which can take one of the following values:  - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat.  - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat.  - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
         */
        sourceSubnetworkIpRangesToNat?: string;
        /**
         * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
         */
        subnetworks?: Schema$RouterNatSubnetworkToNat[];
        /**
         * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
         */
        tcpEstablishedIdleTimeoutSec?: number;
        /**
         * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
         */
        tcpTransitoryIdleTimeoutSec?: number;
        /**
         * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
         */
        udpIdleTimeoutSec?: number;
    }
    /**
     * Configuration of logging on a NAT.
     */
    export interface Schema$RouterNatLogConfig {
        /**
         * Indicates whether or not to export logs. This is false by default.
         */
        enable?: boolean;
        /**
         * Specifies the desired filtering of logs on this NAT. If unspecified, logs are exported for all connections handled by this NAT.
         */
        filter?: string;
    }
    /**
     * Defines the IP ranges that want to use NAT for a subnetwork.
     */
    export interface Schema$RouterNatSubnetworkToNat {
        /**
         * URL for the subnetwork resource that will use NAT.
         */
        name?: string;
        /**
         * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if &quot;LIST_OF_SECONDARY_IP_RANGES&quot; is one of the values in source_ip_ranges_to_nat.
         */
        secondaryIpRangeNames?: string[];
        /**
         * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: [&quot;PRIMARY_IP_RANGE&quot;, &quot;LIST_OF_SECONDARY_IP_RANGES&quot;] Default: [ALL_IP_RANGES]
         */
        sourceIpRangesToNat?: string[];
    }
    export interface Schema$RoutersPreviewResponse {
        /**
         * Preview of given router.
         */
        resource?: Schema$Router;
    }
    export interface Schema$RoutersScopedList {
        /**
         * A list of routers contained in this scope.
         */
        routers?: Schema$Router[];
        /**
         * Informational warning which replaces the list of routers when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$RouterStatus {
        /**
         * Best routes for this router&#39;s network.
         */
        bestRoutes?: Schema$Route[];
        /**
         * Best routes learned by this router.
         */
        bestRoutesForRouter?: Schema$Route[];
        bgpPeerStatus?: Schema$RouterStatusBgpPeerStatus[];
        natStatus?: Schema$RouterStatusNatStatus[];
        /**
         * URI of the network to which this router belongs.
         */
        network?: string;
    }
    export interface Schema$RouterStatusBgpPeerStatus {
        /**
         * Routes that were advertised to the remote BGP peer
         */
        advertisedRoutes?: Schema$Route[];
        /**
         * IP address of the local BGP interface.
         */
        ipAddress?: string;
        /**
         * URL of the VPN tunnel that this BGP peer controls.
         */
        linkedVpnTunnel?: string;
        /**
         * Name of this BGP peer. Unique within the Routers resource.
         */
        name?: string;
        /**
         * Number of routes learned from the remote BGP Peer.
         */
        numLearnedRoutes?: number;
        /**
         * IP address of the remote BGP interface.
         */
        peerIpAddress?: string;
        /**
         * BGP state as specified in RFC1771.
         */
        state?: string;
        /**
         * Status of the BGP peer: {UP, DOWN}
         */
        status?: string;
        /**
         * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
         */
        uptime?: string;
        /**
         * Time this session has been up, in seconds. Format: 145
         */
        uptimeSeconds?: string;
    }
    /**
     * Status of a NAT contained in this router. Next tag: 9
     */
    export interface Schema$RouterStatusNatStatus {
        /**
         * A list of IPs auto-allocated for NAT. Example: [&quot;1.1.1.1&quot;, &quot;129.2.16.89&quot;]
         */
        autoAllocatedNatIps?: string[];
        /**
         * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-allocation of NAT IPs is *not* used.
         */
        minExtraNatIpsNeeded?: number;
        /**
         * Unique name of this NAT.
         */
        name?: string;
        /**
         * Number of VM endpoints (i.e., Nics) that can use NAT.
         */
        numVmEndpointsWithNatMappings?: number;
        /**
         * A list of fully qualified URLs of reserved IP address resources.
         */
        userAllocatedNatIpResources?: string[];
        /**
         * A list of IPs user-allocated for NAT. They will be raw IP strings like &quot;179.12.26.133&quot;.
         */
        userAllocatedNatIps?: string[];
    }
    export interface Schema$RouterStatusResponse {
        /**
         * Type of resource.
         */
        kind?: string;
        result?: Schema$RouterStatus;
    }
    /**
     * A rule to be applied in a Policy.
     */
    export interface Schema$Rule {
        /**
         * Required
         */
        action?: string;
        /**
         * Additional restrictions that must be met. All conditions must pass for the rule to match.
         */
        conditions?: Schema$Condition[];
        /**
         * Human-readable description of the rule.
         */
        description?: string;
        /**
         * If one or more &#39;in&#39; clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
         */
        ins?: string[];
        /**
         * The config returned to callers of tech.iam.IAM.CheckPolicy for any entries that match the LOG action.
         */
        logConfigs?: Schema$LogConfig[];
        /**
         * If one or more &#39;not_in&#39; clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries.
         */
        notIns?: string[];
        /**
         * A permission is a string of form &#39;..&#39; (e.g., &#39;storage.buckets.list&#39;). A value of &#39;*&#39; matches all permissions, and a verb part of &#39;*&#39; (e.g., &#39;storage.buckets.*&#39;) matches all verbs.
         */
        permissions?: string[];
    }
    /**
     * Sets the scheduling options for an Instance. NextID: 9
     */
    export interface Schema$Scheduling {
        /**
         * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted.  By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
         */
        automaticRestart?: boolean;
        /**
         * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information.
         */
        nodeAffinities?: Schema$SchedulingNodeAffinity[];
        /**
         * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Setting Instance Scheduling Options.
         */
        onHostMaintenance?: string;
        /**
         * Defines whether the instance is preemptible. This can only be set during instance creation, it cannot be set or changed after the instance has been created.
         */
        preemptible?: boolean;
    }
    /**
     * Node Affinity: the configuration of desired nodes onto which this Instance could be scheduled.
     */
    export interface Schema$SchedulingNodeAffinity {
        /**
         * Corresponds to the label key of Node resource.
         */
        key?: string;
        /**
         * Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for anti-affinity.
         */
        operator?: string;
        /**
         * Corresponds to the label values of Node resource.
         */
        values?: string[];
    }
    /**
     * Represents a Cloud Armor Security Policy resource.  Only external backend services that use load balancers can reference a Security Policy. For more information, read  Cloud Armor Security Policy Concepts. (== resource_for v1.securityPolicies ==) (== resource_for beta.securityPolicies ==)
     */
    export interface Schema$SecurityPolicy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * Specifies a fingerprint for this resource, which is essentially a hash of the metadata&#39;s contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make get() request to the security policy.
         */
        fingerprint?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * A list of rules that belong to this policy. There must always be a default rule (rule with priority 2147483647 and match &quot;*&quot;). If no rules are provided when creating a security policy, a default rule with action &quot;allow&quot; will be added.
         */
        rules?: Schema$SecurityPolicyRule[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
    }
    export interface Schema$SecurityPolicyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of SecurityPolicy resources.
         */
        items?: Schema$SecurityPolicy[];
        /**
         * [Output Only] Type of resource. Always compute#securityPolicyList for listsof securityPolicies
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$SecurityPolicyReference {
        securityPolicy?: string;
    }
    /**
     * Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
     */
    export interface Schema$SecurityPolicyRule {
        /**
         * The Action to preform when the client connection triggers the rule. Can currently be either &quot;allow&quot; or &quot;deny()&quot; where valid values for status are 403, 404, and 502.
         */
        action?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
         */
        kind?: string;
        /**
         * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding ?action? is enforced.
         */
        match?: Schema$SecurityPolicyRuleMatcher;
        /**
         * If set to true, the specified action is not enforced.
         */
        preview?: boolean;
        /**
         * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
         */
        priority?: number;
    }
    /**
     * Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
     */
    export interface Schema$SecurityPolicyRuleMatcher {
        /**
         * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
         */
        config?: Schema$SecurityPolicyRuleMatcherConfig;
        /**
         * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
         */
        versionedExpr?: string;
    }
    export interface Schema$SecurityPolicyRuleMatcherConfig {
        /**
         * CIDR IP address range.
         */
        srcIpRanges?: string[];
    }
    /**
     * An instance&#39;s serial console output.
     */
    export interface Schema$SerialPortOutput {
        /**
         * [Output Only] The contents of the console output.
         */
        contents?: string;
        /**
         * [Output Only] Type of the resource. Always compute#serialPortOutput for serial port output.
         */
        kind?: string;
        /**
         * [Output Only] The position of the next byte of content from the serial console output. Use this value in the next request as the start parameter.
         */
        next?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * The starting byte position of the output that was returned. This should match the start parameter sent with the request. If the serial console output exceeds the size of the buffer, older output will be overwritten by newer content and the start values will be mismatched.
         */
        start?: string;
    }
    export interface Schema$ServerBinding {
        type?: string;
    }
    /**
     * A service account.
     */
    export interface Schema$ServiceAccount {
        /**
         * Email address of the service account.
         */
        email?: string;
        /**
         * The list of scopes to be made available for this service account.
         */
        scopes?: string[];
    }
    /**
     * A set of Shielded Instance options.
     */
    export interface Schema$ShieldedInstanceConfig {
        /**
         * Defines whether the instance has integrity monitoring enabled.
         */
        enableIntegrityMonitoring?: boolean;
        /**
         * Defines whether the instance has Secure Boot enabled.
         */
        enableSecureBoot?: boolean;
        /**
         * Defines whether the instance has the vTPM enabled.
         */
        enableVtpm?: boolean;
    }
    /**
     * A shielded Instance identity entry.
     */
    export interface Schema$ShieldedInstanceIdentity {
        /**
         * An Endorsement Key (EK) issued to the Shielded Instance&#39;s vTPM.
         */
        encryptionKey?: Schema$ShieldedInstanceIdentityEntry;
        /**
         * [Output Only] Type of the resource. Always compute#shieldedInstanceIdentity for shielded Instance identity entry.
         */
        kind?: string;
        /**
         * An Attestation Key (AK) issued to the Shielded Instance&#39;s vTPM.
         */
        signingKey?: Schema$ShieldedInstanceIdentityEntry;
    }
    /**
     * A Shielded Instance Identity Entry.
     */
    export interface Schema$ShieldedInstanceIdentityEntry {
        /**
         * A PEM-encoded X.509 certificate. This field can be empty.
         */
        ekCert?: string;
        /**
         * A PEM-encoded public key.
         */
        ekPub?: string;
    }
    /**
     * The policy describes the baseline against which Instance boot integrity is measured.
     */
    export interface Schema$ShieldedInstanceIntegrityPolicy {
        /**
         * Updates the integrity policy baseline using the measurements from the VM instance&#39;s most recent boot.
         */
        updateAutoLearnPolicy?: boolean;
    }
    /**
     * Represents a customer-supplied Signing Key used by Cloud CDN Signed URLs
     */
    export interface Schema$SignedUrlKey {
        /**
         * Name of the key. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        keyName?: string;
        /**
         * 128-bit key value used for signing the URL. The key value must be a valid RFC 4648 Section 5 base64url encoded string.
         */
        keyValue?: string;
    }
    /**
     * Represents a Persistent Disk Snapshot resource.  You can use snapshots to back up data on a regular interval. For more information, read  Creating persistent disk snapshots. (== resource_for beta.snapshots ==) (== resource_for v1.snapshots ==)
     */
    export interface Schema$Snapshot {
        /**
         * [Output Only] Set to true if snapshots are automatically by applying resource policy on the target disk.
         */
        autoCreated?: boolean;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] Size of the snapshot, specified in GB.
         */
        diskSizeGb?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
         */
        kind?: string;
        /**
         * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve a snapshot.
         */
        labelFingerprint?: string;
        /**
         * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
         */
        licenseCodes?: string[];
        /**
         * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
         */
        licenses?: string[];
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * Encrypts the snapshot using a customer-supplied encryption key.  After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request.  Customer-supplied encryption keys do not protect access to metadata of the snapshot.  If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
         */
        snapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The source disk used to create this snapshot.
         */
        sourceDisk?: string;
        /**
         * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
         */
        sourceDiskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
         */
        sourceDiskId?: string;
        /**
         * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
         */
        status?: string;
        /**
         * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
         */
        storageBytes?: string;
        /**
         * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
         */
        storageBytesStatus?: string;
        /**
         * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
         */
        storageLocations?: string[];
    }
    /**
     * Contains a list of Snapshot resources.
     */
    export interface Schema$SnapshotList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Snapshot resources.
         */
        items?: Schema$Snapshot[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * A specification of the parameters to use when creating the instance template from a source instance.
     */
    export interface Schema$SourceInstanceParams {
        /**
         * Attached disks configuration. If not provided, defaults are applied: For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
         */
        diskConfigs?: Schema$DiskInstantiationConfig[];
    }
    /**
     * Represents an SSL Certificate resource.  This SSL certificate resource also contains a private key. You can use SSL keys and certificates to secure connections to a load balancer. For more information, read  Creating and Using SSL Certificates. (== resource_for beta.sslCertificates ==) (== resource_for v1.sslCertificates ==)
     */
    export interface Schema$SslCertificate {
        /**
         * A local certificate file. The certificate must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
         */
        certificate?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * A write-only private key in PEM format. Only insert requests will include this field.
         */
        privateKey?: string;
        /**
         * [Output only] Server-defined URL for the resource.
         */
        selfLink?: string;
    }
    /**
     * Contains a list of SslCertificate resources.
     */
    export interface Schema$SslCertificateList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of SslCertificate resources.
         */
        items?: Schema$SslCertificate[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$SSLHealthCheck {
        /**
         * The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
         */
        port?: number;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string;
        /**
         * Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.   If not specified, SSL health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string;
        /**
         * The application data to send once the SSL connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
         */
        request?: string;
        /**
         * The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
         */
        response?: string;
    }
    export interface Schema$SslPoliciesList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of SslPolicy resources.
         */
        items?: Schema$SslPolicy[];
        /**
         * [Output Only] Type of the resource. Always compute#sslPoliciesList for lists of sslPolicies.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$SslPoliciesListAvailableFeaturesResponse {
        features?: string[];
    }
    /**
     * Represents a Cloud Armor Security Policy resource.  Only external backend services used by HTTP or HTTPS load balancers can reference a Security Policy. For more information, read read  Cloud Armor Security Policy Concepts. (== resource_for beta.sslPolicies ==) (== resource_for v1.sslPolicies ==)
     */
    export interface Schema$SslPolicy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * A list of features enabled when the selected profile is CUSTOM. The - method returns the set of features that can be specified in this list. This field must be empty if the profile is not CUSTOM.
         */
        customFeatures?: string[];
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The list of features enabled in the SSL policy.
         */
        enabledFeatures?: string[];
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a SslPolicy. An up-to-date fingerprint must be provided in order to update the SslPolicy, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve an SslPolicy.
         */
        fingerprint?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output only] Type of the resource. Always compute#sslPolicyfor SSL policies.
         */
        kind?: string;
        /**
         * The minimum version of SSL protocol that can be used by the clients to establish a connection with the load balancer. This can be one of TLS_1_0, TLS_1_1, TLS_1_2.
         */
        minTlsVersion?: string;
        /**
         * Name of the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Profile specifies the set of SSL features that can be used by the load balancer when negotiating SSL with clients. This can be one of COMPATIBLE, MODERN, RESTRICTED, or CUSTOM. If using CUSTOM, the set of SSL features to enable must be specified in the customFeatures field.
         */
        profile?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] If potential misconfigurations are detected for this SSL policy, this field will be populated with warning messages.
         */
        warnings?: Array<{
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        }>;
    }
    export interface Schema$SslPolicyReference {
        /**
         * URL of the SSL policy resource. Set this to empty string to clear any existing SSL policy associated with the target proxy resource.
         */
        sslPolicy?: string;
    }
    /**
     * Represents a Subnetwork resource.  A subnetwork (also known as a subnet) is a logical partition of a Virtual Private Cloud network with one primary IP range and zero or more secondary IP ranges. For more information, read  Virtual Private Cloud (VPC) Network. (== resource_for beta.subnetworks ==) (== resource_for v1.subnetworks ==)
     */
    export interface Schema$Subnetwork {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
         */
        description?: string;
        /**
         * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is to disable flow logging.
         */
        enableFlowLogs?: boolean;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
         */
        fingerprint?: string;
        /**
         * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
         */
        gatewayAddress?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field can be set only at resource creation time.
         */
        ipCidrRange?: string;
        /**
         * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
         */
        kind?: string;
        /**
         * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Stackdriver.
         */
        logConfig?: Schema$SubnetworkLogConfig;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. Only networks that are in the distributed mode can have subnetworks. This field can be set only at resource creation time.
         */
        network?: string;
        /**
         * Whether the VMs in this subnet can access Google services without assigned external IP addresses. This field can be both set at resource creation time and updated using setPrivateIpGoogleAccess.
         */
        privateIpGoogleAccess?: boolean;
        /**
         * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
         */
        region?: string;
        /**
         * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
         */
        secondaryIpRanges?: Schema$SubnetworkSecondaryRange[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
    }
    export interface Schema$SubnetworkAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of SubnetworksScopedList resources.
         */
        items?: {
            [key: string]: Schema$SubnetworksScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#subnetworkAggregatedList for aggregated lists of subnetworks.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of Subnetwork resources.
     */
    export interface Schema$SubnetworkList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Subnetwork resources.
         */
        items?: Schema$Subnetwork[];
        /**
         * [Output Only] Type of resource. Always compute#subnetworkList for lists of subnetworks.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * The available logging options for this subnetwork.
     */
    export interface Schema$SubnetworkLogConfig {
        /**
         * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
         */
        aggregationInterval?: string;
        /**
         * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is to disable flow logging.
         */
        enable?: boolean;
        /**
         * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5, which means half of all collected logs are reported.
         */
        flowSampling?: number;
        /**
         * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is INCLUDE_ALL_METADATA.
         */
        metadata?: string;
    }
    /**
     * Represents a secondary IP range of a subnetwork.
     */
    export interface Schema$SubnetworkSecondaryRange {
        /**
         * The range of IP addresses belonging to this subnetwork secondary range. Provide this property when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and secondary IP ranges within a network. Only IPv4 is supported.
         */
        ipCidrRange?: string;
        /**
         * The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.
         */
        rangeName?: string;
    }
    export interface Schema$SubnetworksExpandIpCidrRangeRequest {
        /**
         * The IP (in CIDR format or netmask) of internal addresses that are legal on this Subnetwork. This range should be disjoint from other subnetworks within this network. This range can only be larger than (i.e. a superset of) the range previously defined before the update.
         */
        ipCidrRange?: string;
    }
    export interface Schema$SubnetworksScopedList {
        /**
         * A list of subnetworks contained in this scope.
         */
        subnetworks?: Schema$Subnetwork[];
        /**
         * An informational warning that appears when the list of addresses is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$SubnetworksSetPrivateIpGoogleAccessRequest {
        privateIpGoogleAccess?: boolean;
    }
    /**
     * A set of instance tags.
     */
    export interface Schema$Tags {
        /**
         * Specifies a fingerprint for this request, which is essentially a hash of the tags&#39; contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update tags. You must always provide an up-to-date fingerprint hash in order to update or change tags.  To see the latest fingerprint, make get() request to the instance.
         */
        fingerprint?: string;
        /**
         * An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.
         */
        items?: string[];
    }
    /**
     * Represents a Target HTTP Proxy resource.  A target HTTP proxy is a component of certain types of load balancers. Global forwarding rules reference a target HTTP proxy, and the target proxy then references a URL map. For more information, read Using Target Proxies. (== resource_for beta.targetHttpProxies ==) (== resource_for v1.targetHttpProxies ==)
     */
    export interface Schema$TargetHttpProxy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of resource. Always compute#targetHttpProxy for target HTTP proxies.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * URL to the UrlMap resource that defines the mapping from URL to the BackendService.
         */
        urlMap?: string;
    }
    /**
     * A list of TargetHttpProxy resources.
     */
    export interface Schema$TargetHttpProxyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetHttpProxy resources.
         */
        items?: Schema$TargetHttpProxy[];
        /**
         * Type of resource. Always compute#targetHttpProxyList for lists of target HTTP proxies.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$TargetHttpsProxiesSetQuicOverrideRequest {
        /**
         * QUIC policy for the TargetHttpsProxy resource.
         */
        quicOverride?: string;
    }
    export interface Schema$TargetHttpsProxiesSetSslCertificatesRequest {
        /**
         * New set of SslCertificate resources to associate with this TargetHttpsProxy resource. Currently exactly one SslCertificate resource must be specified.
         */
        sslCertificates?: string[];
    }
    /**
     * Represents a Target HTTPS Proxy resource.  A target HTTPS proxy is a component of certain types of load balancers. Global forwarding rules reference a target HTTPS proxy, and the target proxy then references a URL map. For more information, read Using Target Proxies. (== resource_for beta.targetHttpsProxies ==) (== resource_for v1.targetHttpsProxies ==)
     */
    export interface Schema$TargetHttpsProxy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of resource. Always compute#targetHttpsProxy for target HTTPS proxies.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Specifies the QUIC override policy for this TargetHttpsProxy resource. This determines whether the load balancer will attempt to negotiate QUIC with clients or not. Can specify one of NONE, ENABLE, or DISABLE. Specify ENABLE to always enable QUIC, Enables QUIC when set to ENABLE, and disables QUIC when set to DISABLE. If NONE is specified, uses the QUIC policy with no user overrides, which is equivalent to DISABLE. Not specifying this field is equivalent to specifying NONE.
         */
        quicOverride?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer. At least one SSL certificate must be specified. Currently, you may specify up to 15 SSL certificates.
         */
        sslCertificates?: string[];
        /**
         * URL of SslPolicy resource that will be associated with the TargetHttpsProxy resource. If not set, the TargetHttpsProxy resource will not have any SSL policy configured.
         */
        sslPolicy?: string;
        /**
         * A fully-qualified or valid partial URL to the UrlMap resource that defines the mapping from URL to the BackendService. For example, the following are all valid URLs for specifying a URL map:   - https://www.googleapis.compute/v1/projects/project/global/urlMaps/url-map  - projects/project/global/urlMaps/url-map  - global/urlMaps/url-map
         */
        urlMap?: string;
    }
    /**
     * Contains a list of TargetHttpsProxy resources.
     */
    export interface Schema$TargetHttpsProxyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetHttpsProxy resources.
         */
        items?: Schema$TargetHttpsProxy[];
        /**
         * Type of resource. Always compute#targetHttpsProxyList for lists of target HTTPS proxies.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a Target Instance resource.  You can use a target instance to handle traffic for one or more forwarding rules, which is ideal for forwarding protocol traffic that is managed by a single source. For example, ESP, AH, TCP, or UDP. For more information, read Target instances. (== resource_for beta.targetInstances ==) (== resource_for v1.targetInstances ==)
     */
    export interface Schema$TargetInstance {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * A URL to the virtual machine instance that handles traffic for this target instance. When creating a target instance, you can provide the fully-qualified URL or a valid partial URL to the desired virtual machine. For example, the following are all valid URLs:  - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance  - projects/project/zones/zone/instances/instance  - zones/zone/instances/instance
         */
        instance?: string;
        /**
         * [Output Only] The type of the resource. Always compute#targetInstance for target instances.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * NAT option controlling how IPs are NAT&#39;ed to the instance. Currently only NO_NAT (default value) is supported.
         */
        natPolicy?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] URL of the zone where the target instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string;
    }
    export interface Schema$TargetInstanceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetInstance resources.
         */
        items?: {
            [key: string]: Schema$TargetInstancesScopedList;
        };
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of TargetInstance resources.
     */
    export interface Schema$TargetInstanceList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetInstance resources.
         */
        items?: Schema$TargetInstance[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$TargetInstancesScopedList {
        /**
         * A list of target instances contained in this scope.
         */
        targetInstances?: Schema$TargetInstance[];
        /**
         * Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a Target Pool resource.  Target pools are used for network TCP/UDP load balancing. A target pool references member instances, an associated legacy HttpHealthCheck resource, and, optionally, a backup target pool. For more information, read Using target pools. (== resource_for beta.targetPools ==) (== resource_for v1.targetPools ==)
     */
    export interface Schema$TargetPool {
        /**
         * This field is applicable only when the containing target pool is serving a forwarding rule as the primary pool, and its failoverRatio field is properly set to a value between [0, 1].  backupPool and failoverRatio together define the fallback behavior of the primary target pool: if the ratio of the healthy instances in the primary pool is at or below failoverRatio, traffic arriving at the load-balanced IP will be directed to the backup pool.  In case where failoverRatio and backupPool are not set, or all the instances in the backup pool are unhealthy, the traffic will be directed back to the primary pool in the &quot;force&quot; mode, where traffic will be spread to the healthy instances with the best effort, or to all instances when no instance is healthy.
         */
        backupPool?: string;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * This field is applicable only when the containing target pool is serving a forwarding rule as the primary pool (i.e., not as a backup pool to some other target pool). The value of the field must be in [0, 1].  If set, backupPool must also be set. They together define the fallback behavior of the primary target pool: if the ratio of the healthy instances in the primary pool is at or below this number, traffic arriving at the load-balanced IP will be directed to the backup pool.  In case where failoverRatio is not set or all the instances in the backup pool are unhealthy, the traffic will be directed back to the primary pool in the &quot;force&quot; mode, where traffic will be spread to the healthy instances with the best effort, or to all instances when no instance is healthy.
         */
        failoverRatio?: number;
        /**
         * The URL of the HttpHealthCheck resource. A member instance in this pool is considered healthy if and only if the health checks pass. An empty list means all member instances will be considered healthy at all times. Only HttpHealthChecks are supported. Only one health check may be specified.
         */
        healthChecks?: string[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * A list of resource URLs to the virtual machine instances serving this pool. They must live in zones contained in the same region as this pool.
         */
        instances?: string[];
        /**
         * [Output Only] Type of the resource. Always compute#targetPool for target pools.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * [Output Only] URL of the region where the target pool resides.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * Session affinity option, must be one of the following values: NONE: Connections from the same client IP may go to any instance in the pool. CLIENT_IP: Connections from the same client IP will go to the same instance in the pool while that instance remains healthy. CLIENT_IP_PROTO: Connections from the same client IP with the same IP protocol will go to the same instance in the pool while that instance remains healthy.
         */
        sessionAffinity?: string;
    }
    export interface Schema$TargetPoolAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetPool resources.
         */
        items?: {
            [key: string]: Schema$TargetPoolsScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#targetPoolAggregatedList for aggregated lists of target pools.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$TargetPoolInstanceHealth {
        healthStatus?: Schema$HealthStatus[];
        /**
         * [Output Only] Type of resource. Always compute#targetPoolInstanceHealth when checking the health of an instance.
         */
        kind?: string;
    }
    /**
     * Contains a list of TargetPool resources.
     */
    export interface Schema$TargetPoolList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetPool resources.
         */
        items?: Schema$TargetPool[];
        /**
         * [Output Only] Type of resource. Always compute#targetPoolList for lists of target pools.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$TargetPoolsAddHealthCheckRequest {
        /**
         * The HttpHealthCheck to add to the target pool.
         */
        healthChecks?: Schema$HealthCheckReference[];
    }
    export interface Schema$TargetPoolsAddInstanceRequest {
        /**
         * A full or partial URL to an instance to add to this target pool. This can be a full or partial URL. For example, the following are valid URLs:   - https://www.googleapis.com/compute/v1/projects/project-id/zones/zone/instances/instance-name  - projects/project-id/zones/zone/instances/instance-name  - zones/zone/instances/instance-name
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$TargetPoolsRemoveHealthCheckRequest {
        /**
         * Health check URL to be removed. This can be a full or valid partial URL. For example, the following are valid URLs:   - https://www.googleapis.com/compute/beta/projects/project/global/httpHealthChecks/health-check  - projects/project/global/httpHealthChecks/health-check  - global/httpHealthChecks/health-check
         */
        healthChecks?: Schema$HealthCheckReference[];
    }
    export interface Schema$TargetPoolsRemoveInstanceRequest {
        /**
         * URLs of the instances to be removed from target pool.
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$TargetPoolsScopedList {
        /**
         * A list of target pools contained in this scope.
         */
        targetPools?: Schema$TargetPool[];
        /**
         * Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$TargetReference {
        target?: string;
    }
    export interface Schema$TargetSslProxiesSetBackendServiceRequest {
        /**
         * The URL of the new BackendService resource for the targetSslProxy.
         */
        service?: string;
    }
    export interface Schema$TargetSslProxiesSetProxyHeaderRequest {
        /**
         * The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.
         */
        proxyHeader?: string;
    }
    export interface Schema$TargetSslProxiesSetSslCertificatesRequest {
        /**
         * New set of URLs to SslCertificate resources to associate with this TargetSslProxy. Currently exactly one ssl certificate must be specified.
         */
        sslCertificates?: string[];
    }
    /**
     * Represents a Target SSL Proxy resource.  A target SSL proxy is a component of a SSL Proxy load balancer. Global forwarding rules reference a target SSL proxy, and the target proxy then references an external backend service. For more information, read Using Target Proxies. (== resource_for beta.targetSslProxies ==) (== resource_for v1.targetSslProxies ==)
     */
    export interface Schema$TargetSslProxy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#targetSslProxy for target SSL proxies.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * URL to the BackendService resource.
         */
        service?: string;
        /**
         * URLs to SslCertificate resources that are used to authenticate connections to Backends. At least one SSL certificate must be specified. Currently, you may specify up to 15 SSL certificates.
         */
        sslCertificates?: string[];
        /**
         * URL of SslPolicy resource that will be associated with the TargetSslProxy resource. If not set, the TargetSslProxy resource will not have any SSL policy configured.
         */
        sslPolicy?: string;
    }
    /**
     * Contains a list of TargetSslProxy resources.
     */
    export interface Schema$TargetSslProxyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetSslProxy resources.
         */
        items?: Schema$TargetSslProxy[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$TargetTcpProxiesSetBackendServiceRequest {
        /**
         * The URL of the new BackendService resource for the targetTcpProxy.
         */
        service?: string;
    }
    export interface Schema$TargetTcpProxiesSetProxyHeaderRequest {
        /**
         * The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.
         */
        proxyHeader?: string;
    }
    /**
     * Represents a Target TCP Proxy resource.  A target TCP proxy is a component of a TCP Proxy load balancer. Global forwarding rules reference ta target TCP proxy, and the target proxy then references an external backend service. For more information, read TCP Proxy Load Balancing Concepts. (== resource_for beta.targetTcpProxies ==) (== resource_for v1.targetTcpProxies ==)
     */
    export interface Schema$TargetTcpProxy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#targetTcpProxy for target TCP proxies.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * URL to the BackendService resource.
         */
        service?: string;
    }
    /**
     * Contains a list of TargetTcpProxy resources.
     */
    export interface Schema$TargetTcpProxyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetTcpProxy resources.
         */
        items?: Schema$TargetTcpProxy[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a Target VPN Gateway resource.  The target VPN gateway resource represents a Classic Cloud VPN gateway. For more information, read the the Cloud VPN Overview. (== resource_for beta.targetVpnGateways ==) (== resource_for v1.targetVpnGateways ==)
     */
    export interface Schema$TargetVpnGateway {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] A list of URLs to the ForwardingRule resources. ForwardingRules are created using compute.forwardingRules.insert and associated with a VPN gateway.
         */
        forwardingRules?: string[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of resource. Always compute#targetVpnGateway for target VPN gateways.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * URL of the network to which this VPN gateway is attached. Provided by the client when the VPN gateway is created.
         */
        network?: string;
        /**
         * [Output Only] URL of the region where the target VPN gateway resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] The status of the VPN gateway, which can be one of the following: CREATING, READY, FAILED, or DELETING.
         */
        status?: string;
        /**
         * [Output Only] A list of URLs to VpnTunnel resources. VpnTunnels are created using the compute.vpntunnels.insert method and associated with a VPN gateway.
         */
        tunnels?: string[];
    }
    export interface Schema$TargetVpnGatewayAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetVpnGateway resources.
         */
        items?: {
            [key: string]: Schema$TargetVpnGatewaysScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#targetVpnGateway for target VPN gateways.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of TargetVpnGateway resources.
     */
    export interface Schema$TargetVpnGatewayList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of TargetVpnGateway resources.
         */
        items?: Schema$TargetVpnGateway[];
        /**
         * [Output Only] Type of resource. Always compute#targetVpnGateway for target VPN gateways.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$TargetVpnGatewaysScopedList {
        /**
         * [Output Only] A list of target VPN gateways contained in this scope.
         */
        targetVpnGateways?: Schema$TargetVpnGateway[];
        /**
         * [Output Only] Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$TCPHealthCheck {
        /**
         * The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
         */
        port?: number;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string;
        /**
         * Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.   If not specified, TCP health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string;
        /**
         * The application data to send once the TCP connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
         */
        request?: string;
        /**
         * The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
         */
        response?: string;
    }
    export interface Schema$TestFailure {
        actualService?: string;
        expectedService?: string;
        host?: string;
        path?: string;
    }
    export interface Schema$TestPermissionsRequest {
        /**
         * The set of permissions to check for the &#39;resource&#39;. Permissions with wildcards (such as &#39;*&#39; or &#39;storage.*&#39;) are not allowed.
         */
        permissions?: string[];
    }
    export interface Schema$TestPermissionsResponse {
        /**
         * A subset of `TestPermissionsRequest.permissions` that the caller is allowed.
         */
        permissions?: string[];
    }
    /**
     * Represents a URL Map resource.  A URL map resource is a component of certain types of load balancers. This resource defines mappings from host names and URL paths to either a backend service or a backend bucket.  To use this resource, the backend service must have a loadBalancingScheme of either EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED For more information, read URL Map Concepts.
     */
    export interface Schema$UrlMap {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of defaultService, defaultUrlRedirect  or defaultRouteAction.weightedBackendService must be set.
         */
        defaultService?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve a UrlMap.
         */
        fingerprint?: string;
        /**
         * The list of HostRules to use against the URL.
         */
        hostRules?: Schema$HostRule[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
         */
        kind?: string;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * The list of named PathMatchers to use against the URL.
         */
        pathMatchers?: Schema$PathMatcher[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * The list of expected URL mapping tests. Request to update this UrlMap will succeed only if all of the test cases pass. You can specify a maximum of 100 tests per UrlMap.
         */
        tests?: Schema$UrlMapTest[];
    }
    /**
     * Contains a list of UrlMap resources.
     */
    export interface Schema$UrlMapList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of UrlMap resources.
         */
        items?: Schema$UrlMap[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$UrlMapReference {
        urlMap?: string;
    }
    export interface Schema$UrlMapsValidateRequest {
        /**
         * Content of the UrlMap to be validated.
         */
        resource?: Schema$UrlMap;
    }
    export interface Schema$UrlMapsValidateResponse {
        result?: Schema$UrlMapValidationResult;
    }
    /**
     * Message for the expected URL mappings.
     */
    export interface Schema$UrlMapTest {
        /**
         * Description of this test case.
         */
        description?: string;
        /**
         * Host portion of the URL.
         */
        host?: string;
        /**
         * Path portion of the URL.
         */
        path?: string;
        /**
         * Expected BackendService resource the given URL should be mapped to.
         */
        service?: string;
    }
    /**
     * Message representing the validation result for a UrlMap.
     */
    export interface Schema$UrlMapValidationResult {
        loadErrors?: string[];
        /**
         * Whether the given UrlMap can be successfully loaded. If false, &#39;loadErrors&#39; indicates the reasons.
         */
        loadSucceeded?: boolean;
        testFailures?: Schema$TestFailure[];
        /**
         * If successfully loaded, this field indicates whether the test passed. If false, &#39;testFailures&#39;s indicate the reason of failure.
         */
        testPassed?: boolean;
    }
    /**
     * Subnetwork which the current user has compute.subnetworks.use permission on.
     */
    export interface Schema$UsableSubnetwork {
        /**
         * The range of internal addresses that are owned by this subnetwork.
         */
        ipCidrRange?: string;
        /**
         * Network URL.
         */
        network?: string;
        /**
         * Secondary IP ranges.
         */
        secondaryIpRanges?: Schema$UsableSubnetworkSecondaryRange[];
        /**
         * Subnetwork URL.
         */
        subnetwork?: string;
    }
    export interface Schema$UsableSubnetworksAggregatedList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output] A list of usable subnetwork URLs.
         */
        items?: Schema$UsableSubnetwork[];
        /**
         * [Output Only] Type of resource. Always compute#usableSubnetworksAggregatedList for aggregated lists of usable subnetworks.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Secondary IP range of a usable subnetwork.
     */
    export interface Schema$UsableSubnetworkSecondaryRange {
        /**
         * The range of IP addresses belonging to this subnetwork secondary range.
         */
        ipCidrRange?: string;
        /**
         * The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.
         */
        rangeName?: string;
    }
    /**
     * The location in Cloud Storage and naming method of the daily usage report. Contains bucket_name and report_name prefix.
     */
    export interface Schema$UsageExportLocation {
        /**
         * The name of an existing bucket in Cloud Storage where the usage report object is stored. The Google Service Account is granted write access to this bucket. This can either be the bucket name by itself, such as example-bucket, or the bucket name with gs:// or https://storage.googleapis.com/ in front of it, such as gs://example-bucket.
         */
        bucketName?: string;
        /**
         * An optional prefix for the name of the usage report object stored in bucketName. If not supplied, defaults to usage. The report is stored as a CSV file named report_name_prefix_gce_YYYYMMDD.csv where YYYYMMDD is the day of the usage according to Pacific Time. If you supply a prefix, it should conform to Cloud Storage object naming conventions.
         */
        reportNamePrefix?: string;
    }
    /**
     * Contain information of Nat mapping for a VM endpoint (i.e., NIC).
     */
    export interface Schema$VmEndpointNatMappings {
        /**
         * Name of the VM instance which the endpoint belongs to
         */
        instanceName?: string;
        interfaceNatMappings?: Schema$VmEndpointNatMappingsInterfaceNatMappings[];
    }
    /**
     * Contain information of Nat mapping for an interface of this endpoint.
     */
    export interface Schema$VmEndpointNatMappingsInterfaceNatMappings {
        /**
         * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: [&quot;2.2.2.2:12345-12355&quot;, &quot;1.1.1.1:2234-2234&quot;].
         */
        natIpPortRanges?: string[];
        /**
         * Total number of ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field nat_ip_port_ranges.
         */
        numTotalNatPorts?: number;
        /**
         * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: &quot;10.33.4.55/32&quot;, or &quot;192.168.5.0/24&quot;.
         */
        sourceAliasIpRange?: string;
        /**
         * Primary IP of the VM for this NIC.
         */
        sourceVirtualIp?: string;
    }
    /**
     * Contains a list of VmEndpointNatMappings.
     */
    export interface Schema$VmEndpointNatMappingsList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of resource. Always compute#vmEndpointNatMappingsList for lists of Nat mappings of VM endpoints.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] A list of Nat mapping information of VM endpoints.
         */
        result?: Schema$VmEndpointNatMappings[];
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Represents a VPN gateway resource.
     */
    export interface Schema$VpnGateway {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.
         */
        kind?: string;
        /**
         * A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.  To see the latest fingerprint, make a get() request to retrieve an VpnGateway.
         */
        labelFingerprint?: string;
        /**
         * Labels to apply to this VpnGateway resource. These can be later modified by the setLabels method. Each label key/value must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * URL of the network to which this VPN gateway is attached. Provided by the client when the VPN gateway is created.
         */
        network?: string;
        /**
         * [Output Only] URL of the region where the VPN gateway resides.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] A list of interfaces on this VPN gateway.
         */
        vpnInterfaces?: Schema$VpnGatewayVpnGatewayInterface[];
    }
    export interface Schema$VpnGatewayAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of VpnGateway resources.
         */
        items?: {
            [key: string]: Schema$VpnGatewaysScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of VpnGateway resources.
     */
    export interface Schema$VpnGatewayList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of VpnGateway resources.
         */
        items?: Schema$VpnGateway[];
        /**
         * [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$VpnGatewaysGetStatusResponse {
        result?: Schema$VpnGatewayStatus;
    }
    export interface Schema$VpnGatewaysScopedList {
        /**
         * [Output Only] A list of VPN gateways contained in this scope.
         */
        vpnGateways?: Schema$VpnGateway[];
        /**
         * [Output Only] Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$VpnGatewayStatus {
        /**
         * List of VPN connection for this VpnGateway.
         */
        vpnConnections?: Schema$VpnGatewayStatusVpnConnection[];
    }
    /**
     * Describes the high availability requirement state for the VPN connection between this Cloud VPN gateway and a peer gateway.
     */
    export interface Schema$VpnGatewayStatusHighAvailabilityRequirementState {
        /**
         * Indicates the high availability requirement state for the VPN connection. Valid values are CONNECTION_REDUNDANCY_MET, CONNECTION_REDUNDANCY_NOT_MET.
         */
        state?: string;
        /**
         * Indicates the reason why the VPN connection does not meet the high availability redundancy criteria/requirement. Valid values is INCOMPLETE_TUNNELS_COVERAGE.
         */
        unsatisfiedReason?: string;
    }
    /**
     * Contains some information about a VPN tunnel.
     */
    export interface Schema$VpnGatewayStatusTunnel {
        /**
         * The VPN gateway interface this VPN tunnel is associated with.
         */
        localGatewayInterface?: number;
        /**
         * The peer gateway interface this VPN tunnel is connected to, the peer gateway could either be an external VPN gateway or GCP VPN gateway.
         */
        peerGatewayInterface?: number;
        /**
         * URL reference to the VPN tunnel.
         */
        tunnelUrl?: string;
    }
    /**
     * A VPN connection contains all VPN tunnels connected from this VpnGateway to the same peer gateway. The peer gateway could either be a external VPN gateway or GCP VPN gateway.
     */
    export interface Schema$VpnGatewayStatusVpnConnection {
        /**
         * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
         */
        peerExternalGateway?: string;
        /**
         * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
         */
        peerGcpGateway?: string;
        /**
         * HighAvailabilityRequirementState for the VPN connection.
         */
        state?: Schema$VpnGatewayStatusHighAvailabilityRequirementState;
        /**
         * List of VPN tunnels that are in this VPN connection.
         */
        tunnels?: Schema$VpnGatewayStatusTunnel[];
    }
    /**
     * A VPN gateway interface.
     */
    export interface Schema$VpnGatewayVpnGatewayInterface {
        /**
         * The numeric ID of this VPN gateway interface.
         */
        id?: number;
        /**
         * The external IP address for this VPN gateway interface.
         */
        ipAddress?: string;
    }
    /**
     * Represents a Cloud VPN Tunnel resource.  For more information about VPN, read the the Cloud VPN Overview. (== resource_for beta.vpnTunnels ==) (== resource_for v1.vpnTunnels ==)
     */
    export interface Schema$VpnTunnel {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string;
        /**
         * [Output Only] Detailed status message for the VPN tunnel.
         */
        detailedStatus?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
         */
        ikeVersion?: number;
        /**
         * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
         */
        kind?: string;
        /**
         * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported.
         */
        localTrafficSelector?: string[];
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string;
        /**
         * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
         */
        peerExternalGateway?: string;
        /**
         * The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created.
         */
        peerExternalGatewayInterface?: number;
        /**
         * URL of the peer side HA GCP VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer GCP VPN gateway.
         */
        peerGcpGateway?: string;
        /**
         * IP address of the peer VPN gateway. Only IPv4 is supported.
         */
        peerIp?: string;
        /**
         * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string;
        /**
         * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported.
         */
        remoteTrafficSelector?: string[];
        /**
         * URL of the router resource to be used for dynamic routing.
         */
        router?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
         */
        sharedSecret?: string;
        /**
         * Hash of the shared secret.
         */
        sharedSecretHash?: string;
        /**
         * [Output Only] The status of the VPN tunnel, which can be one of the following:  - PROVISIONING: Resource is being allocated for the VPN tunnel.  - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel.  - FIRST_HANDSHAKE: Successful first handshake with the peer VPN.  - ESTABLISHED: Secure session is successfully established with the peer VPN.  - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS  - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret).  - NEGOTIATION_FAILURE: Handshake failed.  - DEPROVISIONING: Resources are being deallocated for the VPN tunnel.  - FAILED: Tunnel creation has failed and the tunnel is not ready to be used.
         */
        status?: string;
        /**
         * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created.
         */
        targetVpnGateway?: string;
        /**
         * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
         */
        vpnGateway?: string;
        /**
         * The interface ID of the VPN gateway with which this VPN tunnel is associated.
         */
        vpnGatewayInterface?: number;
    }
    export interface Schema$VpnTunnelAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of VpnTunnelsScopedList resources.
         */
        items?: {
            [key: string]: Schema$VpnTunnelsScopedList;
        };
        /**
         * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Contains a list of VpnTunnel resources.
     */
    export interface Schema$VpnTunnelList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of VpnTunnel resources.
         */
        items?: Schema$VpnTunnel[];
        /**
         * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$VpnTunnelsScopedList {
        /**
         * A list of VPN tunnels contained in this scope.
         */
        vpnTunnels?: Schema$VpnTunnel[];
        /**
         * Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$XpnHostList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * [Output Only] A list of shared VPC host project URLs.
         */
        items?: Schema$Project[];
        /**
         * [Output Only] Type of resource. Always compute#xpnHostList for lists of shared VPC hosts.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    /**
     * Service resource (a.k.a service project) ID.
     */
    export interface Schema$XpnResourceId {
        /**
         * The ID of the service resource. In the case of projects, this field supports project id (e.g., my-project-123) and project number (e.g. 12345678).
         */
        id?: string;
        /**
         * The type of the service resource.
         */
        type?: string;
    }
    /**
     * Represents a Zone resource.  A zone is a deployment area. These deployment areas are subsets of a region. For example the zone us-east1-a is located in the us-east1 region. For more information, read Regions and Zones. (== resource_for beta.zones ==) (== resource_for v1.zones ==)
     */
    export interface Schema$Zone {
        /**
         * [Output Only] Available cpu/platform selections for the zone.
         */
        availableCpuPlatforms?: string[];
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string;
        /**
         * [Output Only] The deprecation status associated with this zone.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] Textual description of the resource.
         */
        description?: string;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string;
        /**
         * [Output Only] Type of the resource. Always compute#zone for zones.
         */
        kind?: string;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string;
        /**
         * [Output Only] Full URL reference to the region which hosts the zone.
         */
        region?: string;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Status of the zone, either UP or DOWN.
         */
        status?: string;
    }
    /**
     * Contains a list of zone resources.
     */
    export interface Schema$ZoneList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string;
        /**
         * A list of Zone resources.
         */
        items?: Schema$Zone[];
        /**
         * Type of resource.
         */
        kind?: string;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        };
    }
    export interface Schema$ZoneSetLabelsRequest {
        /**
         * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. Make a get() request to the resource to get the latest fingerprint.
         */
        labelFingerprint?: string;
        /**
         * The labels to set for this resource.
         */
        labels?: {
            [key: string]: string;
        };
    }
    export interface Schema$ZoneSetPolicyRequest {
        /**
         * Flatten Policy to create a backwacd compatible wire-format. Deprecated. Use &#39;policy&#39; to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use &#39;policy&#39; to specify the etag.
         */
        etag?: string;
        /**
         * REQUIRED: The complete policy to be applied to the &#39;resource&#39;. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    export class Resource$Acceleratortypes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.acceleratorTypes.aggregatedList
         * @desc Retrieves an aggregated list of accelerator types.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     Object.keys(itemsPage).forEach(function(name) {
         *       // TODO: Change code below to process each `name` property:
         *       console.log(name + ': ' + JSON.stringify(itemsPage[name], null, 2));
         *     });
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.acceleratorTypes.aggregatedList(request, handlePage);
         *     }
         *   };
         *
         *   compute.acceleratorTypes.aggregatedList(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.acceleratorTypes.aggregatedList
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        aggregatedList(params?: Params$Resource$Acceleratortypes$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$AcceleratorTypeAggregatedList>;
        aggregatedList(params: Params$Resource$Acceleratortypes$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$AcceleratorTypeAggregatedList>, callback: BodyResponseCallback<Schema$AcceleratorTypeAggregatedList>): void;
        aggregatedList(params: Params$Resource$Acceleratortypes$Aggregatedlist, callback: BodyResponseCallback<Schema$AcceleratorTypeAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$AcceleratorTypeAggregatedList>): void;
        /**
         * compute.acceleratorTypes.get
         * @desc Returns the specified accelerator type.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     // Name of the accelerator type to return.
         *     acceleratorType: 'my-accelerator-type',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.acceleratorTypes.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.acceleratorTypes.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.acceleratorType Name of the accelerator type to return.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Acceleratortypes$Get, options?: MethodOptions): GaxiosPromise<Schema$AcceleratorType>;
        get(params: Params$Resource$Acceleratortypes$Get, options: MethodOptions | BodyResponseCallback<Schema$AcceleratorType>, callback: BodyResponseCallback<Schema$AcceleratorType>): void;
        get(params: Params$Resource$Acceleratortypes$Get, callback: BodyResponseCallback<Schema$AcceleratorType>): void;
        get(callback: BodyResponseCallback<Schema$AcceleratorType>): void;
        /**
         * compute.acceleratorTypes.list
         * @desc Retrieves a list of accelerator types available to the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.acceleratorTypes.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.acceleratorTypes.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.acceleratorTypes.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Acceleratortypes$List, options?: MethodOptions): GaxiosPromise<Schema$AcceleratorTypeList>;
        list(params: Params$Resource$Acceleratortypes$List, options: MethodOptions | BodyResponseCallback<Schema$AcceleratorTypeList>, callback: BodyResponseCallback<Schema$AcceleratorTypeList>): void;
        list(params: Params$Resource$Acceleratortypes$List, callback: BodyResponseCallback<Schema$AcceleratorTypeList>): void;
        list(callback: BodyResponseCallback<Schema$AcceleratorTypeList>): void;
    }
    export interface Params$Resource$Acceleratortypes$Aggregatedlist extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Acceleratortypes$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the accelerator type to return.
         */
        acceleratorType?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Acceleratortypes$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export class Resource$Addresses {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.addresses.aggregatedList
         * @desc Retrieves an aggregated list of addresses.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     Object.keys(itemsPage).forEach(function(name) {
         *       // TODO: Change code below to process each `name` property:
         *       console.log(name + ': ' + JSON.stringify(itemsPage[name], null, 2));
         *     });
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.addresses.aggregatedList(request, handlePage);
         *     }
         *   };
         *
         *   compute.addresses.aggregatedList(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.addresses.aggregatedList
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        aggregatedList(params?: Params$Resource$Addresses$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$AddressAggregatedList>;
        aggregatedList(params: Params$Resource$Addresses$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$AddressAggregatedList>, callback: BodyResponseCallback<Schema$AddressAggregatedList>): void;
        aggregatedList(params: Params$Resource$Addresses$Aggregatedlist, callback: BodyResponseCallback<Schema$AddressAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$AddressAggregatedList>): void;
        /**
         * compute.addresses.delete
         * @desc Deletes the specified address resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the region for this request.
         *     region: 'my-region',  // TODO: Update placeholder value.
         *
         *     // Name of the address resource to delete.
         *     address: 'my-address',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.addresses.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.addresses.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.address Name of the address resource to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.region Name of the region for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Addresses$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Addresses$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Addresses$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.addresses.get
         * @desc Returns the specified address resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the region for this request.
         *     region: 'my-region',  // TODO: Update placeholder value.
         *
         *     // Name of the address resource to return.
         *     address: 'my-address',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.addresses.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.addresses.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.address Name of the address resource to return.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.region Name of the region for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Addresses$Get, options?: MethodOptions): GaxiosPromise<Schema$Address>;
        get(params: Params$Resource$Addresses$Get, options: MethodOptions | BodyResponseCallback<Schema$Address>, callback: BodyResponseCallback<Schema$Address>): void;
        get(params: Params$Resource$Addresses$Get, callback: BodyResponseCallback<Schema$Address>): void;
        get(callback: BodyResponseCallback<Schema$Address>): void;
        /**
         * compute.addresses.insert
         * @desc Creates an address resource in the specified project by using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the region for this request.
         *     region: 'my-region',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.addresses.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.addresses.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string} params.region Name of the region for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().Address} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Addresses$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Addresses$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Addresses$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.addresses.list
         * @desc Retrieves a list of addresses contained within the specified region.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the region for this request.
         *     region: 'my-region',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.addresses.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.addresses.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.addresses.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.region Name of the region for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Addresses$List, options?: MethodOptions): GaxiosPromise<Schema$AddressList>;
        list(params: Params$Resource$Addresses$List, options: MethodOptions | BodyResponseCallback<Schema$AddressList>, callback: BodyResponseCallback<Schema$AddressList>): void;
        list(params: Params$Resource$Addresses$List, callback: BodyResponseCallback<Schema$AddressList>): void;
        list(callback: BodyResponseCallback<Schema$AddressList>): void;
    }
    export interface Params$Resource$Addresses$Aggregatedlist extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Addresses$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the address resource to delete.
         */
        address?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region for this request.
         */
        region?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Addresses$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the address resource to return.
         */
        address?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region for this request.
         */
        region?: string;
    }
    export interface Params$Resource$Addresses$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region for this request.
         */
        region?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Address;
    }
    export interface Params$Resource$Addresses$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region for this request.
         */
        region?: string;
    }
    export class Resource$Autoscalers {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.autoscalers.aggregatedList
         * @desc Retrieves an aggregated list of autoscalers.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     Object.keys(itemsPage).forEach(function(name) {
         *       // TODO: Change code below to process each `name` property:
         *       console.log(name + ': ' + JSON.stringify(itemsPage[name], null, 2));
         *     });
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.autoscalers.aggregatedList(request, handlePage);
         *     }
         *   };
         *
         *   compute.autoscalers.aggregatedList(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.autoscalers.aggregatedList
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        aggregatedList(params?: Params$Resource$Autoscalers$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$AutoscalerAggregatedList>;
        aggregatedList(params: Params$Resource$Autoscalers$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$AutoscalerAggregatedList>, callback: BodyResponseCallback<Schema$AutoscalerAggregatedList>): void;
        aggregatedList(params: Params$Resource$Autoscalers$Aggregatedlist, callback: BodyResponseCallback<Schema$AutoscalerAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$AutoscalerAggregatedList>): void;
        /**
         * compute.autoscalers.delete
         * @desc Deletes the specified autoscaler.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     // Name of the autoscaler to delete.
         *     autoscaler: 'my-autoscaler',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.autoscalers.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.autoscalers.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.autoscaler Name of the autoscaler to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.zone Name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Autoscalers$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Autoscalers$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Autoscalers$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.autoscalers.get
         * @desc Returns the specified autoscaler resource. Gets a list of available autoscalers by making a list() request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     // Name of the autoscaler to return.
         *     autoscaler: 'my-autoscaler',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.autoscalers.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.autoscalers.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.autoscaler Name of the autoscaler to return.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.zone Name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Autoscalers$Get, options?: MethodOptions): GaxiosPromise<Schema$Autoscaler>;
        get(params: Params$Resource$Autoscalers$Get, options: MethodOptions | BodyResponseCallback<Schema$Autoscaler>, callback: BodyResponseCallback<Schema$Autoscaler>): void;
        get(params: Params$Resource$Autoscalers$Get, callback: BodyResponseCallback<Schema$Autoscaler>): void;
        get(callback: BodyResponseCallback<Schema$Autoscaler>): void;
        /**
         * compute.autoscalers.insert
         * @desc Creates an autoscaler in the specified project using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.autoscalers.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.autoscalers.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.zone Name of the zone for this request.
         * @param {().Autoscaler} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Autoscalers$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Autoscalers$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Autoscalers$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.autoscalers.list
         * @desc Retrieves a list of autoscalers contained within the specified zone.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.autoscalers.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.autoscalers.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.autoscalers.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.zone Name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Autoscalers$List, options?: MethodOptions): GaxiosPromise<Schema$AutoscalerList>;
        list(params: Params$Resource$Autoscalers$List, options: MethodOptions | BodyResponseCallback<Schema$AutoscalerList>, callback: BodyResponseCallback<Schema$AutoscalerList>): void;
        list(params: Params$Resource$Autoscalers$List, callback: BodyResponseCallback<Schema$AutoscalerList>): void;
        list(callback: BodyResponseCallback<Schema$AutoscalerList>): void;
        /**
         * compute.autoscalers.patch
         * @desc Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. Only these properties
         *       // will be changed.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.autoscalers.patch(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.autoscalers.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.autoscaler Name of the autoscaler to patch.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.zone Name of the zone for this request.
         * @param {().Autoscaler} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Autoscalers$Patch, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        patch(params: Params$Resource$Autoscalers$Patch, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(params: Params$Resource$Autoscalers$Patch, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.autoscalers.update
         * @desc Updates an autoscaler in the specified project using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. All existing properties
         *       // will be replaced.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.autoscalers.update(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.autoscalers.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.autoscaler Name of the autoscaler to update.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.zone Name of the zone for this request.
         * @param {().Autoscaler} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Autoscalers$Update, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        update(params: Params$Resource$Autoscalers$Update, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        update(params: Params$Resource$Autoscalers$Update, callback: BodyResponseCallback<Schema$Operation>): void;
        update(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Autoscalers$Aggregatedlist extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Autoscalers$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the autoscaler to delete.
         */
        autoscaler?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Autoscalers$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the autoscaler to return.
         */
        autoscaler?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Autoscalers$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Autoscaler;
    }
    export interface Params$Resource$Autoscalers$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Autoscalers$Patch extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the autoscaler to patch.
         */
        autoscaler?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Autoscaler;
    }
    export interface Params$Resource$Autoscalers$Update extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the autoscaler to update.
         */
        autoscaler?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Autoscaler;
    }
    export class Resource$Backendbuckets {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.backendBuckets.addSignedUrlKey
         * @desc Adds a key for validating requests with signed URLs for this backend bucket.
         * @alias compute.backendBuckets.addSignedUrlKey
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should conform to RFC1035.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().SignedUrlKey} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        addSignedUrlKey(params?: Params$Resource$Backendbuckets$Addsignedurlkey, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        addSignedUrlKey(params: Params$Resource$Backendbuckets$Addsignedurlkey, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        addSignedUrlKey(params: Params$Resource$Backendbuckets$Addsignedurlkey, callback: BodyResponseCallback<Schema$Operation>): void;
        addSignedUrlKey(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendBuckets.delete
         * @desc Deletes the specified BackendBucket resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the BackendBucket resource to delete.
         *     backendBucket: 'my-backend-bucket',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendBuckets.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendBuckets.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendBucket Name of the BackendBucket resource to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Backendbuckets$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Backendbuckets$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Backendbuckets$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendBuckets.deleteSignedUrlKey
         * @desc Deletes a key for validating requests with signed URLs for this backend bucket.
         * @alias compute.backendBuckets.deleteSignedUrlKey
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should conform to RFC1035.
         * @param {string} params.keyName The name of the Signed URL Key to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        deleteSignedUrlKey(params?: Params$Resource$Backendbuckets$Deletesignedurlkey, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        deleteSignedUrlKey(params: Params$Resource$Backendbuckets$Deletesignedurlkey, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        deleteSignedUrlKey(params: Params$Resource$Backendbuckets$Deletesignedurlkey, callback: BodyResponseCallback<Schema$Operation>): void;
        deleteSignedUrlKey(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendBuckets.get
         * @desc Returns the specified BackendBucket resource. Gets a list of available backend buckets by making a list() request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the BackendBucket resource to return.
         *     backendBucket: 'my-backend-bucket',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendBuckets.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendBuckets.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendBucket Name of the BackendBucket resource to return.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Backendbuckets$Get, options?: MethodOptions): GaxiosPromise<Schema$BackendBucket>;
        get(params: Params$Resource$Backendbuckets$Get, options: MethodOptions | BodyResponseCallback<Schema$BackendBucket>, callback: BodyResponseCallback<Schema$BackendBucket>): void;
        get(params: Params$Resource$Backendbuckets$Get, callback: BodyResponseCallback<Schema$BackendBucket>): void;
        get(callback: BodyResponseCallback<Schema$BackendBucket>): void;
        /**
         * compute.backendBuckets.insert
         * @desc Creates a BackendBucket resource in the specified project using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendBuckets.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendBuckets.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().BackendBucket} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Backendbuckets$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Backendbuckets$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Backendbuckets$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendBuckets.list
         * @desc Retrieves the list of BackendBucket resources available to the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.backendBuckets.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.backendBuckets.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendBuckets.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Backendbuckets$List, options?: MethodOptions): GaxiosPromise<Schema$BackendBucketList>;
        list(params: Params$Resource$Backendbuckets$List, options: MethodOptions | BodyResponseCallback<Schema$BackendBucketList>, callback: BodyResponseCallback<Schema$BackendBucketList>): void;
        list(params: Params$Resource$Backendbuckets$List, callback: BodyResponseCallback<Schema$BackendBucketList>): void;
        list(callback: BodyResponseCallback<Schema$BackendBucketList>): void;
        /**
         * compute.backendBuckets.patch
         * @desc Updates the specified BackendBucket resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the BackendBucket resource to patch.
         *     backendBucket: 'my-backend-bucket',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. Only these properties
         *       // will be changed.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendBuckets.patch(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendBuckets.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendBucket Name of the BackendBucket resource to patch.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().BackendBucket} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Backendbuckets$Patch, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        patch(params: Params$Resource$Backendbuckets$Patch, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(params: Params$Resource$Backendbuckets$Patch, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendBuckets.update
         * @desc Updates the specified BackendBucket resource with the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the BackendBucket resource to update.
         *     backendBucket: 'my-backend-bucket',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. All existing properties
         *       // will be replaced.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendBuckets.update(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendBuckets.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendBucket Name of the BackendBucket resource to update.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().BackendBucket} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Backendbuckets$Update, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        update(params: Params$Resource$Backendbuckets$Update, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        update(params: Params$Resource$Backendbuckets$Update, callback: BodyResponseCallback<Schema$Operation>): void;
        update(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Backendbuckets$Addsignedurlkey extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendBucket resource to which the Signed URL Key should be added. The name should conform to RFC1035.
         */
        backendBucket?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$SignedUrlKey;
    }
    export interface Params$Resource$Backendbuckets$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendBucket resource to delete.
         */
        backendBucket?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Backendbuckets$Deletesignedurlkey extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendBucket resource to which the Signed URL Key should be added. The name should conform to RFC1035.
         */
        backendBucket?: string;
        /**
         * The name of the Signed URL Key to delete.
         */
        keyName?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Backendbuckets$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendBucket resource to return.
         */
        backendBucket?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Backendbuckets$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$BackendBucket;
    }
    export interface Params$Resource$Backendbuckets$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Backendbuckets$Patch extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendBucket resource to patch.
         */
        backendBucket?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$BackendBucket;
    }
    export interface Params$Resource$Backendbuckets$Update extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendBucket resource to update.
         */
        backendBucket?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$BackendBucket;
    }
    export class Resource$Backendservices {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.backendServices.addSignedUrlKey
         * @desc Adds a key for validating requests with signed URLs for this backend service.
         * @alias compute.backendServices.addSignedUrlKey
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should conform to RFC1035.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().SignedUrlKey} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        addSignedUrlKey(params?: Params$Resource$Backendservices$Addsignedurlkey, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        addSignedUrlKey(params: Params$Resource$Backendservices$Addsignedurlkey, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        addSignedUrlKey(params: Params$Resource$Backendservices$Addsignedurlkey, callback: BodyResponseCallback<Schema$Operation>): void;
        addSignedUrlKey(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendServices.aggregatedList
         * @desc Retrieves the list of all BackendService resources, regional and global, available to the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Name of the project scoping this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     Object.keys(itemsPage).forEach(function(name) {
         *       // TODO: Change code below to process each `name` property:
         *       console.log(name + ': ' + JSON.stringify(itemsPage[name], null, 2));
         *     });
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.backendServices.aggregatedList(request, handlePage);
         *     }
         *   };
         *
         *   compute.backendServices.aggregatedList(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendServices.aggregatedList
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Name of the project scoping this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        aggregatedList(params?: Params$Resource$Backendservices$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$BackendServiceAggregatedList>;
        aggregatedList(params: Params$Resource$Backendservices$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$BackendServiceAggregatedList>, callback: BodyResponseCallback<Schema$BackendServiceAggregatedList>): void;
        aggregatedList(params: Params$Resource$Backendservices$Aggregatedlist, callback: BodyResponseCallback<Schema$BackendServiceAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$BackendServiceAggregatedList>): void;
        /**
         * compute.backendServices.delete
         * @desc Deletes the specified BackendService resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the BackendService resource to delete.
         *     backendService: 'my-backend-service',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendServices.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendServices.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendService Name of the BackendService resource to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Backendservices$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Backendservices$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Backendservices$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendServices.deleteSignedUrlKey
         * @desc Deletes a key for validating requests with signed URLs for this backend service.
         * @alias compute.backendServices.deleteSignedUrlKey
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should conform to RFC1035.
         * @param {string} params.keyName The name of the Signed URL Key to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        deleteSignedUrlKey(params?: Params$Resource$Backendservices$Deletesignedurlkey, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        deleteSignedUrlKey(params: Params$Resource$Backendservices$Deletesignedurlkey, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        deleteSignedUrlKey(params: Params$Resource$Backendservices$Deletesignedurlkey, callback: BodyResponseCallback<Schema$Operation>): void;
        deleteSignedUrlKey(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendServices.get
         * @desc Returns the specified BackendService resource. Gets a list of available backend services.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the BackendService resource to return.
         *     backendService: 'my-backend-service',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendServices.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendServices.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendService Name of the BackendService resource to return.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Backendservices$Get, options?: MethodOptions): GaxiosPromise<Schema$BackendService>;
        get(params: Params$Resource$Backendservices$Get, options: MethodOptions | BodyResponseCallback<Schema$BackendService>, callback: BodyResponseCallback<Schema$BackendService>): void;
        get(params: Params$Resource$Backendservices$Get, callback: BodyResponseCallback<Schema$BackendService>): void;
        get(callback: BodyResponseCallback<Schema$BackendService>): void;
        /**
         * compute.backendServices.getHealth
         * @desc Gets the most recent health check results for this BackendService.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the BackendService resource to which the queried instance belongs.
         *     backendService: 'my-backend-service',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendServices.getHealth(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendServices.getHealth
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendService Name of the BackendService resource to which the queried instance belongs.
         * @param {string} params.project
         * @param {().ResourceGroupReference} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        getHealth(params?: Params$Resource$Backendservices$Gethealth, options?: MethodOptions): GaxiosPromise<Schema$BackendServiceGroupHealth>;
        getHealth(params: Params$Resource$Backendservices$Gethealth, options: MethodOptions | BodyResponseCallback<Schema$BackendServiceGroupHealth>, callback: BodyResponseCallback<Schema$BackendServiceGroupHealth>): void;
        getHealth(params: Params$Resource$Backendservices$Gethealth, callback: BodyResponseCallback<Schema$BackendServiceGroupHealth>): void;
        getHealth(callback: BodyResponseCallback<Schema$BackendServiceGroupHealth>): void;
        /**
         * compute.backendServices.insert
         * @desc Creates a BackendService resource in the specified project using the data included in the request. There are several restrictions and guidelines to keep in mind when creating a backend service. Read  Restrictions and Guidelines for more information.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendServices.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendServices.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().BackendService} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Backendservices$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Backendservices$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Backendservices$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendServices.list
         * @desc Retrieves the list of BackendService resources available to the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.backendServices.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.backendServices.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendServices.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Backendservices$List, options?: MethodOptions): GaxiosPromise<Schema$BackendServiceList>;
        list(params: Params$Resource$Backendservices$List, options: MethodOptions | BodyResponseCallback<Schema$BackendServiceList>, callback: BodyResponseCallback<Schema$BackendServiceList>): void;
        list(params: Params$Resource$Backendservices$List, callback: BodyResponseCallback<Schema$BackendServiceList>): void;
        list(callback: BodyResponseCallback<Schema$BackendServiceList>): void;
        /**
         * compute.backendServices.patch
         * @desc Patches the specified BackendService resource with the data included in the request. There are several restrictions and guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines for more information. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the BackendService resource to patch.
         *     backendService: 'my-backend-service',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. Only these properties
         *       // will be changed.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendServices.patch(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendServices.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendService Name of the BackendService resource to patch.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().BackendService} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Backendservices$Patch, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        patch(params: Params$Resource$Backendservices$Patch, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(params: Params$Resource$Backendservices$Patch, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendServices.setSecurityPolicy
         * @desc Sets the security policy for the specified backend service.
         * @alias compute.backendServices.setSecurityPolicy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendService Name of the BackendService resource to which the security policy should be set. The name should conform to RFC1035.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().SecurityPolicyReference} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        setSecurityPolicy(params?: Params$Resource$Backendservices$Setsecuritypolicy, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        setSecurityPolicy(params: Params$Resource$Backendservices$Setsecuritypolicy, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        setSecurityPolicy(params: Params$Resource$Backendservices$Setsecuritypolicy, callback: BodyResponseCallback<Schema$Operation>): void;
        setSecurityPolicy(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.backendServices.update
         * @desc Updates the specified BackendService resource with the data included in the request. There are several restrictions and guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines for more information.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the BackendService resource to update.
         *     backendService: 'my-backend-service',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. All existing properties
         *       // will be replaced.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.backendServices.update(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.backendServices.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.backendService Name of the BackendService resource to update.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().BackendService} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Backendservices$Update, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        update(params: Params$Resource$Backendservices$Update, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        update(params: Params$Resource$Backendservices$Update, callback: BodyResponseCallback<Schema$Operation>): void;
        update(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Backendservices$Addsignedurlkey extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendService resource to which the Signed URL Key should be added. The name should conform to RFC1035.
         */
        backendService?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$SignedUrlKey;
    }
    export interface Params$Resource$Backendservices$Aggregatedlist extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Name of the project scoping this request.
         */
        project?: string;
    }
    export interface Params$Resource$Backendservices$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendService resource to delete.
         */
        backendService?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Backendservices$Deletesignedurlkey extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendService resource to which the Signed URL Key should be added. The name should conform to RFC1035.
         */
        backendService?: string;
        /**
         * The name of the Signed URL Key to delete.
         */
        keyName?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Backendservices$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendService resource to return.
         */
        backendService?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Backendservices$Gethealth extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendService resource to which the queried instance belongs.
         */
        backendService?: string;
        /**
         *
         */
        project?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ResourceGroupReference;
    }
    export interface Params$Resource$Backendservices$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$BackendService;
    }
    export interface Params$Resource$Backendservices$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Backendservices$Patch extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendService resource to patch.
         */
        backendService?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$BackendService;
    }
    export interface Params$Resource$Backendservices$Setsecuritypolicy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendService resource to which the security policy should be set. The name should conform to RFC1035.
         */
        backendService?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$SecurityPolicyReference;
    }
    export interface Params$Resource$Backendservices$Update extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the BackendService resource to update.
         */
        backendService?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$BackendService;
    }
    export class Resource$Disks {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.disks.addResourcePolicies
         * @desc Adds existing resource policies to a disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.
         * @alias compute.disks.addResourcePolicies
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.disk The disk name for this request.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.zone The name of the zone for this request.
         * @param {().DisksAddResourcePoliciesRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        addResourcePolicies(params?: Params$Resource$Disks$Addresourcepolicies, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        addResourcePolicies(params: Params$Resource$Disks$Addresourcepolicies, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        addResourcePolicies(params: Params$Resource$Disks$Addresourcepolicies, callback: BodyResponseCallback<Schema$Operation>): void;
        addResourcePolicies(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.disks.aggregatedList
         * @desc Retrieves an aggregated list of persistent disks.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     Object.keys(itemsPage).forEach(function(name) {
         *       // TODO: Change code below to process each `name` property:
         *       console.log(name + ': ' + JSON.stringify(itemsPage[name], null, 2));
         *     });
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.disks.aggregatedList(request, handlePage);
         *     }
         *   };
         *
         *   compute.disks.aggregatedList(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.disks.aggregatedList
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        aggregatedList(params?: Params$Resource$Disks$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$DiskAggregatedList>;
        aggregatedList(params: Params$Resource$Disks$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$DiskAggregatedList>, callback: BodyResponseCallback<Schema$DiskAggregatedList>): void;
        aggregatedList(params: Params$Resource$Disks$Aggregatedlist, callback: BodyResponseCallback<Schema$DiskAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$DiskAggregatedList>): void;
        /**
         * compute.disks.createSnapshot
         * @desc Creates a snapshot of a specified persistent disk.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     // Name of the persistent disk to snapshot.
         *     disk: 'my-disk',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.disks.createSnapshot(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.disks.createSnapshot
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.disk Name of the persistent disk to snapshot.
         * @param {boolean=} params.guestFlush [Input Only] Specifies to create an application consistent snapshot by informing the OS to prepare for the snapshot process. Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.zone The name of the zone for this request.
         * @param {().Snapshot} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        createSnapshot(params?: Params$Resource$Disks$Createsnapshot, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        createSnapshot(params: Params$Resource$Disks$Createsnapshot, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        createSnapshot(params: Params$Resource$Disks$Createsnapshot, callback: BodyResponseCallback<Schema$Operation>): void;
        createSnapshot(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.disks.delete
         * @desc Deletes the specified persistent disk. Deleting a disk removes its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     // Name of the persistent disk to delete.
         *     disk: 'my-disk',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.disks.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.disks.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.disk Name of the persistent disk to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.zone The name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Disks$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Disks$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Disks$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.disks.get
         * @desc Returns a specified persistent disk. Gets a list of available persistent disks by making a list() request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     // Name of the persistent disk to return.
         *     disk: 'my-disk',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.disks.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.disks.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.disk Name of the persistent disk to return.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Disks$Get, options?: MethodOptions): GaxiosPromise<Schema$Disk>;
        get(params: Params$Resource$Disks$Get, options: MethodOptions | BodyResponseCallback<Schema$Disk>, callback: BodyResponseCallback<Schema$Disk>): void;
        get(params: Params$Resource$Disks$Get, callback: BodyResponseCallback<Schema$Disk>): void;
        get(callback: BodyResponseCallback<Schema$Disk>): void;
        /**
         * compute.disks.getIamPolicy
         * @desc Gets the access control policy for a resource. May be empty if no such policy or resource exists.
         * @alias compute.disks.getIamPolicy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string} params.resource_ Name or id of the resource for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        getIamPolicy(params?: Params$Resource$Disks$Getiampolicy, options?: MethodOptions): GaxiosPromise<Schema$Policy>;
        getIamPolicy(params: Params$Resource$Disks$Getiampolicy, options: MethodOptions | BodyResponseCallback<Schema$Policy>, callback: BodyResponseCallback<Schema$Policy>): void;
        getIamPolicy(params: Params$Resource$Disks$Getiampolicy, callback: BodyResponseCallback<Schema$Policy>): void;
        getIamPolicy(callback: BodyResponseCallback<Schema$Policy>): void;
        /**
         * compute.disks.insert
         * @desc Creates a persistent disk in the specified project using the data in the request. You can create a disk with a sourceImage, a sourceSnapshot, or create an empty 500 GB data disk by omitting all properties. You can also create a disk that is larger than the default size by specifying the sizeGb property.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.disks.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.disks.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string=} params.sourceImage Optional. Source image to restore onto a disk.
         * @param {string} params.zone The name of the zone for this request.
         * @param {().Disk} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Disks$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Disks$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Disks$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.disks.list
         * @desc Retrieves a list of persistent disks contained within the specified zone.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.disks.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.disks.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.disks.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Disks$List, options?: MethodOptions): GaxiosPromise<Schema$DiskList>;
        list(params: Params$Resource$Disks$List, options: MethodOptions | BodyResponseCallback<Schema$DiskList>, callback: BodyResponseCallback<Schema$DiskList>): void;
        list(params: Params$Resource$Disks$List, callback: BodyResponseCallback<Schema$DiskList>): void;
        list(callback: BodyResponseCallback<Schema$DiskList>): void;
        /**
         * compute.disks.removeResourcePolicies
         * @desc Removes resource policies from a disk.
         * @alias compute.disks.removeResourcePolicies
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.disk The disk name for this request.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.zone The name of the zone for this request.
         * @param {().DisksRemoveResourcePoliciesRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        removeResourcePolicies(params?: Params$Resource$Disks$Removeresourcepolicies, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        removeResourcePolicies(params: Params$Resource$Disks$Removeresourcepolicies, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        removeResourcePolicies(params: Params$Resource$Disks$Removeresourcepolicies, callback: BodyResponseCallback<Schema$Operation>): void;
        removeResourcePolicies(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.disks.resize
         * @desc Resizes the specified persistent disk. You can only increase the size of the disk.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     // The name of the persistent disk.
         *     disk: 'my-disk',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.disks.resize(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.disks.resize
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.disk The name of the persistent disk.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.zone The name of the zone for this request.
         * @param {().DisksResizeRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        resize(params?: Params$Resource$Disks$Resize, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        resize(params: Params$Resource$Disks$Resize, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        resize(params: Params$Resource$Disks$Resize, callback: BodyResponseCallback<Schema$Operation>): void;
        resize(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.disks.setIamPolicy
         * @desc Sets the access control policy on the specified resource. Replaces any existing policy.
         * @alias compute.disks.setIamPolicy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string} params.resource_ Name or id of the resource for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {().ZoneSetPolicyRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        setIamPolicy(params?: Params$Resource$Disks$Setiampolicy, options?: MethodOptions): GaxiosPromise<Schema$Policy>;
        setIamPolicy(params: Params$Resource$Disks$Setiampolicy, options: MethodOptions | BodyResponseCallback<Schema$Policy>, callback: BodyResponseCallback<Schema$Policy>): void;
        setIamPolicy(params: Params$Resource$Disks$Setiampolicy, callback: BodyResponseCallback<Schema$Policy>): void;
        setIamPolicy(callback: BodyResponseCallback<Schema$Policy>): void;
        /**
         * compute.disks.setLabels
         * @desc Sets the labels on a disk. To learn more about labels, read the Labeling Resources documentation.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     // Name of the resource for this request.
         *     resource_: 'my-resource',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.disks.setLabels(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.disks.setLabels
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {string} params.resource_ Name or id of the resource for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {().ZoneSetLabelsRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        setLabels(params?: Params$Resource$Disks$Setlabels, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        setLabels(params: Params$Resource$Disks$Setlabels, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        setLabels(params: Params$Resource$Disks$Setlabels, callback: BodyResponseCallback<Schema$Operation>): void;
        setLabels(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.disks.testIamPermissions
         * @desc Returns permissions that a caller has on the specified resource.
         * @alias compute.disks.testIamPermissions
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string} params.resource_ Name or id of the resource for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {().TestPermissionsRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        testIamPermissions(params?: Params$Resource$Disks$Testiampermissions, options?: MethodOptions): GaxiosPromise<Schema$TestPermissionsResponse>;
        testIamPermissions(params: Params$Resource$Disks$Testiampermissions, options: MethodOptions | BodyResponseCallback<Schema$TestPermissionsResponse>, callback: BodyResponseCallback<Schema$TestPermissionsResponse>): void;
        testIamPermissions(params: Params$Resource$Disks$Testiampermissions, callback: BodyResponseCallback<Schema$TestPermissionsResponse>): void;
        testIamPermissions(callback: BodyResponseCallback<Schema$TestPermissionsResponse>): void;
    }
    export interface Params$Resource$Disks$Addresourcepolicies extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The disk name for this request.
         */
        disk?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$DisksAddResourcePoliciesRequest;
    }
    export interface Params$Resource$Disks$Aggregatedlist extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Disks$Createsnapshot extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the persistent disk to snapshot.
         */
        disk?: string;
        /**
         * [Input Only] Specifies to create an application consistent snapshot by informing the OS to prepare for the snapshot process. Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
         */
        guestFlush?: boolean;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Snapshot;
    }
    export interface Params$Resource$Disks$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the persistent disk to delete.
         */
        disk?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Disks$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the persistent disk to return.
         */
        disk?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Disks$Getiampolicy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name or id of the resource for this request.
         */
        resource?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Disks$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Optional. Source image to restore onto a disk.
         */
        sourceImage?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Disk;
    }
    export interface Params$Resource$Disks$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Disks$Removeresourcepolicies extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The disk name for this request.
         */
        disk?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$DisksRemoveResourcePoliciesRequest;
    }
    export interface Params$Resource$Disks$Resize extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the persistent disk.
         */
        disk?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$DisksResizeRequest;
    }
    export interface Params$Resource$Disks$Setiampolicy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name or id of the resource for this request.
         */
        resource?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ZoneSetPolicyRequest;
    }
    export interface Params$Resource$Disks$Setlabels extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Name or id of the resource for this request.
         */
        resource?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ZoneSetLabelsRequest;
    }
    export interface Params$Resource$Disks$Testiampermissions extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name or id of the resource for this request.
         */
        resource?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$TestPermissionsRequest;
    }
    export class Resource$Disktypes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.diskTypes.aggregatedList
         * @desc Retrieves an aggregated list of disk types.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     Object.keys(itemsPage).forEach(function(name) {
         *       // TODO: Change code below to process each `name` property:
         *       console.log(name + ': ' + JSON.stringify(itemsPage[name], null, 2));
         *     });
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.diskTypes.aggregatedList(request, handlePage);
         *     }
         *   };
         *
         *   compute.diskTypes.aggregatedList(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.diskTypes.aggregatedList
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        aggregatedList(params?: Params$Resource$Disktypes$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$DiskTypeAggregatedList>;
        aggregatedList(params: Params$Resource$Disktypes$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$DiskTypeAggregatedList>, callback: BodyResponseCallback<Schema$DiskTypeAggregatedList>): void;
        aggregatedList(params: Params$Resource$Disktypes$Aggregatedlist, callback: BodyResponseCallback<Schema$DiskTypeAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$DiskTypeAggregatedList>): void;
        /**
         * compute.diskTypes.get
         * @desc Returns the specified disk type. Gets a list of available disk types by making a list() request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     // Name of the disk type to return.
         *     diskType: 'my-disk-type',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.diskTypes.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.diskTypes.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.diskType Name of the disk type to return.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Disktypes$Get, options?: MethodOptions): GaxiosPromise<Schema$DiskType>;
        get(params: Params$Resource$Disktypes$Get, options: MethodOptions | BodyResponseCallback<Schema$DiskType>, callback: BodyResponseCallback<Schema$DiskType>): void;
        get(params: Params$Resource$Disktypes$Get, callback: BodyResponseCallback<Schema$DiskType>): void;
        get(callback: BodyResponseCallback<Schema$DiskType>): void;
        /**
         * compute.diskTypes.list
         * @desc Retrieves a list of disk types available to the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // The name of the zone for this request.
         *     zone: 'my-zone',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.diskTypes.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.diskTypes.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.diskTypes.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.zone The name of the zone for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Disktypes$List, options?: MethodOptions): GaxiosPromise<Schema$DiskTypeList>;
        list(params: Params$Resource$Disktypes$List, options: MethodOptions | BodyResponseCallback<Schema$DiskTypeList>, callback: BodyResponseCallback<Schema$DiskTypeList>): void;
        list(params: Params$Resource$Disktypes$List, callback: BodyResponseCallback<Schema$DiskTypeList>): void;
        list(callback: BodyResponseCallback<Schema$DiskTypeList>): void;
    }
    export interface Params$Resource$Disktypes$Aggregatedlist extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Disktypes$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the disk type to return.
         */
        diskType?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Disktypes$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export class Resource$Externalvpngateways {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.externalVpnGateways.delete
         * @desc Deletes the specified externalVpnGateway.
         * @alias compute.externalVpnGateways.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.externalVpnGateway Name of the externalVpnGateways to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Externalvpngateways$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Externalvpngateways$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Externalvpngateways$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.externalVpnGateways.get
         * @desc Returns the specified externalVpnGateway. Get a list of available externalVpnGateways by making a list() request.
         * @alias compute.externalVpnGateways.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.externalVpnGateway Name of the externalVpnGateway to return.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Externalvpngateways$Get, options?: MethodOptions): GaxiosPromise<Schema$ExternalVpnGateway>;
        get(params: Params$Resource$Externalvpngateways$Get, options: MethodOptions | BodyResponseCallback<Schema$ExternalVpnGateway>, callback: BodyResponseCallback<Schema$ExternalVpnGateway>): void;
        get(params: Params$Resource$Externalvpngateways$Get, callback: BodyResponseCallback<Schema$ExternalVpnGateway>): void;
        get(callback: BodyResponseCallback<Schema$ExternalVpnGateway>): void;
        /**
         * compute.externalVpnGateways.insert
         * @desc Creates a ExternalVpnGateway in the specified project using the data included in the request.
         * @alias compute.externalVpnGateways.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().ExternalVpnGateway} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Externalvpngateways$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Externalvpngateways$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Externalvpngateways$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.externalVpnGateways.list
         * @desc Retrieves the list of ExternalVpnGateway available to the specified project.
         * @alias compute.externalVpnGateways.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Externalvpngateways$List, options?: MethodOptions): GaxiosPromise<Schema$ExternalVpnGatewayList>;
        list(params: Params$Resource$Externalvpngateways$List, options: MethodOptions | BodyResponseCallback<Schema$ExternalVpnGatewayList>, callback: BodyResponseCallback<Schema$ExternalVpnGatewayList>): void;
        list(params: Params$Resource$Externalvpngateways$List, callback: BodyResponseCallback<Schema$ExternalVpnGatewayList>): void;
        list(callback: BodyResponseCallback<Schema$ExternalVpnGatewayList>): void;
        /**
         * compute.externalVpnGateways.setLabels
         * @desc Sets the labels on an ExternalVpnGateway. To learn more about labels, read the Labeling Resources documentation.
         * @alias compute.externalVpnGateways.setLabels
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string} params.resource_ Name or id of the resource for this request.
         * @param {().GlobalSetLabelsRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        setLabels(params?: Params$Resource$Externalvpngateways$Setlabels, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        setLabels(params: Params$Resource$Externalvpngateways$Setlabels, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        setLabels(params: Params$Resource$Externalvpngateways$Setlabels, callback: BodyResponseCallback<Schema$Operation>): void;
        setLabels(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.externalVpnGateways.testIamPermissions
         * @desc Returns permissions that a caller has on the specified resource.
         * @alias compute.externalVpnGateways.testIamPermissions
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string} params.resource_ Name or id of the resource for this request.
         * @param {().TestPermissionsRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        testIamPermissions(params?: Params$Resource$Externalvpngateways$Testiampermissions, options?: MethodOptions): GaxiosPromise<Schema$TestPermissionsResponse>;
        testIamPermissions(params: Params$Resource$Externalvpngateways$Testiampermissions, options: MethodOptions | BodyResponseCallback<Schema$TestPermissionsResponse>, callback: BodyResponseCallback<Schema$TestPermissionsResponse>): void;
        testIamPermissions(params: Params$Resource$Externalvpngateways$Testiampermissions, callback: BodyResponseCallback<Schema$TestPermissionsResponse>): void;
        testIamPermissions(callback: BodyResponseCallback<Schema$TestPermissionsResponse>): void;
    }
    export interface Params$Resource$Externalvpngateways$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the externalVpnGateways to delete.
         */
        externalVpnGateway?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Externalvpngateways$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the externalVpnGateway to return.
         */
        externalVpnGateway?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Externalvpngateways$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ExternalVpnGateway;
    }
    export interface Params$Resource$Externalvpngateways$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Externalvpngateways$Setlabels extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name or id of the resource for this request.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GlobalSetLabelsRequest;
    }
    export interface Params$Resource$Externalvpngateways$Testiampermissions extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name or id of the resource for this request.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$TestPermissionsRequest;
    }
    export class Resource$Firewalls {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.firewalls.delete
         * @desc Deletes the specified firewall.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the firewall rule to delete.
         *     firewall: 'my-firewall',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.firewalls.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.firewalls.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.firewall Name of the firewall rule to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Firewalls$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Firewalls$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Firewalls$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.firewalls.get
         * @desc Returns the specified firewall.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the firewall rule to return.
         *     firewall: 'my-firewall',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.firewalls.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.firewalls.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.firewall Name of the firewall rule to return.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Firewalls$Get, options?: MethodOptions): GaxiosPromise<Schema$Firewall>;
        get(params: Params$Resource$Firewalls$Get, options: MethodOptions | BodyResponseCallback<Schema$Firewall>, callback: BodyResponseCallback<Schema$Firewall>): void;
        get(params: Params$Resource$Firewalls$Get, callback: BodyResponseCallback<Schema$Firewall>): void;
        get(callback: BodyResponseCallback<Schema$Firewall>): void;
        /**
         * compute.firewalls.insert
         * @desc Creates a firewall rule in the specified project using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.firewalls.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.firewalls.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().Firewall} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Firewalls$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Firewalls$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Firewalls$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.firewalls.list
         * @desc Retrieves the list of firewall rules available to the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.firewalls.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.firewalls.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.firewalls.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Firewalls$List, options?: MethodOptions): GaxiosPromise<Schema$FirewallList>;
        list(params: Params$Resource$Firewalls$List, options: MethodOptions | BodyResponseCallback<Schema$FirewallList>, callback: BodyResponseCallback<Schema$FirewallList>): void;
        list(params: Params$Resource$Firewalls$List, callback: BodyResponseCallback<Schema$FirewallList>): void;
        list(callback: BodyResponseCallback<Schema$FirewallList>): void;
        /**
         * compute.firewalls.patch
         * @desc Updates the specified firewall rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the firewall rule to patch.
         *     firewall: 'my-firewall',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. Only these properties
         *       // will be changed.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.firewalls.patch(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.firewalls.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.firewall Name of the firewall rule to patch.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().Firewall} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Firewalls$Patch, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        patch(params: Params$Resource$Firewalls$Patch, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(params: Params$Resource$Firewalls$Patch, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.firewalls.update
         * @desc Updates the specified firewall rule with the data included in the request. The PUT method can only update the following fields of firewall rule: allowed, description, sourceRanges, sourceTags, targetTags.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the firewall rule to update.
         *     firewall: 'my-firewall',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. All existing properties
         *       // will be replaced.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.firewalls.update(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.firewalls.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.firewall Name of the firewall rule to update.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().Firewall} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Firewalls$Update, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        update(params: Params$Resource$Firewalls$Update, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        update(params: Params$Resource$Firewalls$Update, callback: BodyResponseCallback<Schema$Operation>): void;
        update(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Firewalls$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the firewall rule to delete.
         */
        firewall?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Firewalls$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the firewall rule to return.
         */
        firewall?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Firewalls$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Firewall;
    }
    export interface Params$Resource$Firewalls$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Firewalls$Patch extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the firewall rule to patch.
         */
        firewall?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Firewall;
    }
    export interface Params$Resource$Firewalls$Update extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the firewall rule to update.
         */
        firewall?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Firewall;
    }
    export class Resource$Forwardingrules {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.forwardingRules.aggregatedList
         * @desc Retrieves an aggregated list of forwarding rules.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     Object.keys(itemsPage).forEach(function(name) {
         *       // TODO: Change code below to process each `name` property:
         *       console.log(name + ': ' + JSON.stringify(itemsPage[name], null, 2));
         *     });
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.forwardingRules.aggregatedList(request, handlePage);
         *     }
         *   };
         *
         *   compute.forwardingRules.aggregatedList(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.forwardingRules.aggregatedList
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        aggregatedList(params?: Params$Resource$Forwardingrules$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$ForwardingRuleAggregatedList>;
        aggregatedList(params: Params$Resource$Forwardingrules$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$ForwardingRuleAggregatedList>, callback: BodyResponseCallback<Schema$ForwardingRuleAggregatedList>): void;
        aggregatedList(params: Params$Resource$Forwardingrules$Aggregatedlist, callback: BodyResponseCallback<Schema$ForwardingRuleAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$ForwardingRuleAggregatedList>): void;
        /**
         * compute.forwardingRules.delete
         * @desc Deletes the specified ForwardingRule resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the region scoping this request.
         *     region: 'my-region',  // TODO: Update placeholder value.
         *
         *     // Name of the ForwardingRule resource to delete.
         *     forwardingRule: 'my-forwarding-rule',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.forwardingRules.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.forwardingRules.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.forwardingRule Name of the ForwardingRule resource to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.region Name of the region scoping this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Forwardingrules$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Forwardingrules$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Forwardingrules$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.forwardingRules.get
         * @desc Returns the specified ForwardingRule resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the region scoping this request.
         *     region: 'my-region',  // TODO: Update placeholder value.
         *
         *     // Name of the ForwardingRule resource to return.
         *     forwardingRule: 'my-forwarding-rule',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.forwardingRules.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.forwardingRules.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.forwardingRule Name of the ForwardingRule resource to return.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.region Name of the region scoping this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Forwardingrules$Get, options?: MethodOptions): GaxiosPromise<Schema$ForwardingRule>;
        get(params: Params$Resource$Forwardingrules$Get, options: MethodOptions | BodyResponseCallback<Schema$ForwardingRule>, callback: BodyResponseCallback<Schema$ForwardingRule>): void;
        get(params: Params$Resource$Forwardingrules$Get, callback: BodyResponseCallback<Schema$ForwardingRule>): void;
        get(callback: BodyResponseCallback<Schema$ForwardingRule>): void;
        /**
         * compute.forwardingRules.insert
         * @desc Creates a ForwardingRule resource in the specified project and region using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the region scoping this request.
         *     region: 'my-region',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.forwardingRules.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.forwardingRules.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string} params.region Name of the region scoping this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().ForwardingRule} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Forwardingrules$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Forwardingrules$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Forwardingrules$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.forwardingRules.list
         * @desc Retrieves a list of ForwardingRule resources available to the specified project and region.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the region scoping this request.
         *     region: 'my-region',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.forwardingRules.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.forwardingRules.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.forwardingRules.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.region Name of the region scoping this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Forwardingrules$List, options?: MethodOptions): GaxiosPromise<Schema$ForwardingRuleList>;
        list(params: Params$Resource$Forwardingrules$List, options: MethodOptions | BodyResponseCallback<Schema$ForwardingRuleList>, callback: BodyResponseCallback<Schema$ForwardingRuleList>): void;
        list(params: Params$Resource$Forwardingrules$List, callback: BodyResponseCallback<Schema$ForwardingRuleList>): void;
        list(callback: BodyResponseCallback<Schema$ForwardingRuleList>): void;
        /**
         * compute.forwardingRules.setTarget
         * @desc Changes target URL for forwarding rule. The new target should be of the same type as the old target.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the region scoping this request.
         *     region: 'my-region',  // TODO: Update placeholder value.
         *
         *     // Name of the ForwardingRule resource in which target is to be set.
         *     forwardingRule: 'my-forwarding-rule',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.forwardingRules.setTarget(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.forwardingRules.setTarget
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.forwardingRule Name of the ForwardingRule resource in which target is to be set.
         * @param {string} params.project Project ID for this request.
         * @param {string} params.region Name of the region scoping this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().TargetReference} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        setTarget(params?: Params$Resource$Forwardingrules$Settarget, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        setTarget(params: Params$Resource$Forwardingrules$Settarget, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        setTarget(params: Params$Resource$Forwardingrules$Settarget, callback: BodyResponseCallback<Schema$Operation>): void;
        setTarget(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Forwardingrules$Aggregatedlist extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Forwardingrules$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the ForwardingRule resource to delete.
         */
        forwardingRule?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region scoping this request.
         */
        region?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Forwardingrules$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the ForwardingRule resource to return.
         */
        forwardingRule?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region scoping this request.
         */
        region?: string;
    }
    export interface Params$Resource$Forwardingrules$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region scoping this request.
         */
        region?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ForwardingRule;
    }
    export interface Params$Resource$Forwardingrules$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region scoping this request.
         */
        region?: string;
    }
    export interface Params$Resource$Forwardingrules$Settarget extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the ForwardingRule resource in which target is to be set.
         */
        forwardingRule?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region scoping this request.
         */
        region?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$TargetReference;
    }
    export class Resource$Globaladdresses {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.globalAddresses.delete
         * @desc Deletes the specified address resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the address resource to delete.
         *     address: 'my-address',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.globalAddresses.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalAddresses.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.address Name of the address resource to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Globaladdresses$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Globaladdresses$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Globaladdresses$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.globalAddresses.get
         * @desc Returns the specified address resource. Gets a list of available addresses by making a list() request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the address resource to return.
         *     address: 'my-address',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.globalAddresses.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalAddresses.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.address Name of the address resource to return.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Globaladdresses$Get, options?: MethodOptions): GaxiosPromise<Schema$Address>;
        get(params: Params$Resource$Globaladdresses$Get, options: MethodOptions | BodyResponseCallback<Schema$Address>, callback: BodyResponseCallback<Schema$Address>): void;
        get(params: Params$Resource$Globaladdresses$Get, callback: BodyResponseCallback<Schema$Address>): void;
        get(callback: BodyResponseCallback<Schema$Address>): void;
        /**
         * compute.globalAddresses.insert
         * @desc Creates an address resource in the specified project by using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.globalAddresses.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalAddresses.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().Address} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Globaladdresses$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Globaladdresses$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Globaladdresses$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.globalAddresses.list
         * @desc Retrieves a list of global addresses.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.globalAddresses.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.globalAddresses.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalAddresses.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Globaladdresses$List, options?: MethodOptions): GaxiosPromise<Schema$AddressList>;
        list(params: Params$Resource$Globaladdresses$List, options: MethodOptions | BodyResponseCallback<Schema$AddressList>, callback: BodyResponseCallback<Schema$AddressList>): void;
        list(params: Params$Resource$Globaladdresses$List, callback: BodyResponseCallback<Schema$AddressList>): void;
        list(callback: BodyResponseCallback<Schema$AddressList>): void;
    }
    export interface Params$Resource$Globaladdresses$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the address resource to delete.
         */
        address?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Globaladdresses$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the address resource to return.
         */
        address?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Globaladdresses$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Address;
    }
    export interface Params$Resource$Globaladdresses$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export class Resource$Globalforwardingrules {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.globalForwardingRules.delete
         * @desc Deletes the specified GlobalForwardingRule resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the ForwardingRule resource to delete.
         *     forwardingRule: 'my-forwarding-rule',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.globalForwardingRules.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalForwardingRules.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.forwardingRule Name of the ForwardingRule resource to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Globalforwardingrules$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Globalforwardingrules$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Globalforwardingrules$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.globalForwardingRules.get
         * @desc Returns the specified GlobalForwardingRule resource. Gets a list of available forwarding rules by making a list() request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the ForwardingRule resource to return.
         *     forwardingRule: 'my-forwarding-rule',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.globalForwardingRules.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalForwardingRules.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.forwardingRule Name of the ForwardingRule resource to return.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Globalforwardingrules$Get, options?: MethodOptions): GaxiosPromise<Schema$ForwardingRule>;
        get(params: Params$Resource$Globalforwardingrules$Get, options: MethodOptions | BodyResponseCallback<Schema$ForwardingRule>, callback: BodyResponseCallback<Schema$ForwardingRule>): void;
        get(params: Params$Resource$Globalforwardingrules$Get, callback: BodyResponseCallback<Schema$ForwardingRule>): void;
        get(callback: BodyResponseCallback<Schema$ForwardingRule>): void;
        /**
         * compute.globalForwardingRules.insert
         * @desc Creates a GlobalForwardingRule resource in the specified project using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.globalForwardingRules.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalForwardingRules.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().ForwardingRule} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Globalforwardingrules$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Globalforwardingrules$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Globalforwardingrules$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.globalForwardingRules.list
         * @desc Retrieves a list of GlobalForwardingRule resources available to the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.globalForwardingRules.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.globalForwardingRules.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalForwardingRules.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Globalforwardingrules$List, options?: MethodOptions): GaxiosPromise<Schema$ForwardingRuleList>;
        list(params: Params$Resource$Globalforwardingrules$List, options: MethodOptions | BodyResponseCallback<Schema$ForwardingRuleList>, callback: BodyResponseCallback<Schema$ForwardingRuleList>): void;
        list(params: Params$Resource$Globalforwardingrules$List, callback: BodyResponseCallback<Schema$ForwardingRuleList>): void;
        list(callback: BodyResponseCallback<Schema$ForwardingRuleList>): void;
        /**
         * compute.globalForwardingRules.setTarget
         * @desc Changes target URL for the GlobalForwardingRule resource. The new target should be of the same type as the old target.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the ForwardingRule resource in which target is to be set.
         *     forwardingRule: 'my-forwarding-rule',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.globalForwardingRules.setTarget(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalForwardingRules.setTarget
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.forwardingRule Name of the ForwardingRule resource in which target is to be set.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().TargetReference} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        setTarget(params?: Params$Resource$Globalforwardingrules$Settarget, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        setTarget(params: Params$Resource$Globalforwardingrules$Settarget, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        setTarget(params: Params$Resource$Globalforwardingrules$Settarget, callback: BodyResponseCallback<Schema$Operation>): void;
        setTarget(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Globalforwardingrules$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the ForwardingRule resource to delete.
         */
        forwardingRule?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Globalforwardingrules$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the ForwardingRule resource to return.
         */
        forwardingRule?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Globalforwardingrules$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ForwardingRule;
    }
    export interface Params$Resource$Globalforwardingrules$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Globalforwardingrules$Settarget extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the ForwardingRule resource in which target is to be set.
         */
        forwardingRule?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$TargetReference;
    }
    export class Resource$Globaloperations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.globalOperations.aggregatedList
         * @desc Retrieves an aggregated list of all operations.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     Object.keys(itemsPage).forEach(function(name) {
         *       // TODO: Change code below to process each `name` property:
         *       console.log(name + ': ' + JSON.stringify(itemsPage[name], null, 2));
         *     });
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.globalOperations.aggregatedList(request, handlePage);
         *     }
         *   };
         *
         *   compute.globalOperations.aggregatedList(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalOperations.aggregatedList
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        aggregatedList(params?: Params$Resource$Globaloperations$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$OperationAggregatedList>;
        aggregatedList(params: Params$Resource$Globaloperations$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$OperationAggregatedList>, callback: BodyResponseCallback<Schema$OperationAggregatedList>): void;
        aggregatedList(params: Params$Resource$Globaloperations$Aggregatedlist, callback: BodyResponseCallback<Schema$OperationAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$OperationAggregatedList>): void;
        /**
         * compute.globalOperations.delete
         * @desc Deletes the specified Operations resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the Operations resource to delete.
         *     operation: 'my-operation',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.globalOperations.delete(request, function(err) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalOperations.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.operation Name of the Operations resource to delete.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Globaloperations$Delete, options?: MethodOptions): GaxiosPromise<void>;
        delete(params: Params$Resource$Globaloperations$Delete, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        delete(params: Params$Resource$Globaloperations$Delete, callback: BodyResponseCallback<void>): void;
        delete(callback: BodyResponseCallback<void>): void;
        /**
         * compute.globalOperations.get
         * @desc Retrieves the specified Operations resource. Gets a list of operations by making a list() request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the Operations resource to return.
         *     operation: 'my-operation',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.globalOperations.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalOperations.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.operation Name of the Operations resource to return.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Globaloperations$Get, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        get(params: Params$Resource$Globaloperations$Get, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        get(params: Params$Resource$Globaloperations$Get, callback: BodyResponseCallback<Schema$Operation>): void;
        get(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.globalOperations.list
         * @desc Retrieves a list of Operation resources contained within the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.globalOperations.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.globalOperations.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.globalOperations.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Globaloperations$List, options?: MethodOptions): GaxiosPromise<Schema$OperationList>;
        list(params: Params$Resource$Globaloperations$List, options: MethodOptions | BodyResponseCallback<Schema$OperationList>, callback: BodyResponseCallback<Schema$OperationList>): void;
        list(params: Params$Resource$Globaloperations$List, callback: BodyResponseCallback<Schema$OperationList>): void;
        list(callback: BodyResponseCallback<Schema$OperationList>): void;
    }
    export interface Params$Resource$Globaloperations$Aggregatedlist extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Globaloperations$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the Operations resource to delete.
         */
        operation?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Globaloperations$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the Operations resource to return.
         */
        operation?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Globaloperations$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export class Resource$Healthchecks {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.healthChecks.delete
         * @desc Deletes the specified HealthCheck resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the HealthCheck resource to delete.
         *     healthCheck: 'my-health-check',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.healthChecks.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.healthChecks.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.healthCheck Name of the HealthCheck resource to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Healthchecks$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Healthchecks$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Healthchecks$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.healthChecks.get
         * @desc Returns the specified HealthCheck resource. Gets a list of available health checks by making a list() request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the HealthCheck resource to return.
         *     healthCheck: 'my-health-check',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.healthChecks.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.healthChecks.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.healthCheck Name of the HealthCheck resource to return.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Healthchecks$Get, options?: MethodOptions): GaxiosPromise<Schema$HealthCheck>;
        get(params: Params$Resource$Healthchecks$Get, options: MethodOptions | BodyResponseCallback<Schema$HealthCheck>, callback: BodyResponseCallback<Schema$HealthCheck>): void;
        get(params: Params$Resource$Healthchecks$Get, callback: BodyResponseCallback<Schema$HealthCheck>): void;
        get(callback: BodyResponseCallback<Schema$HealthCheck>): void;
        /**
         * compute.healthChecks.insert
         * @desc Creates a HealthCheck resource in the specified project using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.healthChecks.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.healthChecks.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().HealthCheck} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Healthchecks$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Healthchecks$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Healthchecks$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.healthChecks.list
         * @desc Retrieves the list of HealthCheck resources available to the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.healthChecks.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.healthChecks.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.healthChecks.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Healthchecks$List, options?: MethodOptions): GaxiosPromise<Schema$HealthCheckList>;
        list(params: Params$Resource$Healthchecks$List, options: MethodOptions | BodyResponseCallback<Schema$HealthCheckList>, callback: BodyResponseCallback<Schema$HealthCheckList>): void;
        list(params: Params$Resource$Healthchecks$List, callback: BodyResponseCallback<Schema$HealthCheckList>): void;
        list(callback: BodyResponseCallback<Schema$HealthCheckList>): void;
        /**
         * compute.healthChecks.patch
         * @desc Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the HealthCheck resource to patch.
         *     healthCheck: 'my-health-check',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. Only these properties
         *       // will be changed.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.healthChecks.patch(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.healthChecks.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.healthCheck Name of the HealthCheck resource to patch.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().HealthCheck} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Healthchecks$Patch, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        patch(params: Params$Resource$Healthchecks$Patch, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(params: Params$Resource$Healthchecks$Patch, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.healthChecks.update
         * @desc Updates a HealthCheck resource in the specified project using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the HealthCheck resource to update.
         *     healthCheck: 'my-health-check',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body. All existing properties
         *       // will be replaced.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.healthChecks.update(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.healthChecks.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.healthCheck Name of the HealthCheck resource to update.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().HealthCheck} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Healthchecks$Update, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        update(params: Params$Resource$Healthchecks$Update, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        update(params: Params$Resource$Healthchecks$Update, callback: BodyResponseCallback<Schema$Operation>): void;
        update(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Healthchecks$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the HealthCheck resource to delete.
         */
        healthCheck?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Healthchecks$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the HealthCheck resource to return.
         */
        healthCheck?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Healthchecks$Insert extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$HealthCheck;
    }
    export interface Params$Resource$Healthchecks$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
    }
    export interface Params$Resource$Healthchecks$Patch extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the HealthCheck resource to patch.
         */
        healthCheck?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$HealthCheck;
    }
    export interface Params$Resource$Healthchecks$Update extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Name of the HealthCheck resource to update.
         */
        healthCheck?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$HealthCheck;
    }
    export class Resource$Httphealthchecks {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * compute.httpHealthChecks.delete
         * @desc Deletes the specified HttpHealthCheck resource.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the HttpHealthCheck resource to delete.
         *     httpHealthCheck: 'my-http-health-check',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.httpHealthChecks.delete(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.httpHealthChecks.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.httpHealthCheck Name of the HttpHealthCheck resource to delete.
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Httphealthchecks$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Httphealthchecks$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Httphealthchecks$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.httpHealthChecks.get
         * @desc Returns the specified HttpHealthCheck resource. Gets a list of available HTTP health checks by making a list() request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     // Name of the HttpHealthCheck resource to return.
         *     httpHealthCheck: 'my-http-health-check',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   compute.httpHealthChecks.get(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.httpHealthChecks.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.httpHealthCheck Name of the HttpHealthCheck resource to return.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Httphealthchecks$Get, options?: MethodOptions): GaxiosPromise<Schema$HttpHealthCheck>;
        get(params: Params$Resource$Httphealthchecks$Get, options: MethodOptions | BodyResponseCallback<Schema$HttpHealthCheck>, callback: BodyResponseCallback<Schema$HttpHealthCheck>): void;
        get(params: Params$Resource$Httphealthchecks$Get, callback: BodyResponseCallback<Schema$HttpHealthCheck>): void;
        get(callback: BodyResponseCallback<Schema$HttpHealthCheck>): void;
        /**
         * compute.httpHealthChecks.insert
         * @desc Creates a HttpHealthCheck resource in the specified project using the data included in the request.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     resource: {
         *       // TODO: Add desired properties to the request body.
         *     },
         *
         *     auth: authClient,
         *   };
         *
         *   compute.httpHealthChecks.insert(request, function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     // TODO: Change code below to process the `response` object:
         *     console.log(JSON.stringify(response, null, 2));
         *   });
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.httpHealthChecks.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.project Project ID for this request.
         * @param {string=} params.requestId An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.  For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.  The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         * @param {().HttpHealthCheck} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Httphealthchecks$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Httphealthchecks$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Httphealthchecks$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * compute.httpHealthChecks.list
         * @desc Retrieves the list of HttpHealthCheck resources available to the specified project.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //    and check the quota for your project at
         * //    https://console.developers.google.com/apis/api/compute
         * // 2. This sample uses Application Default Credentials for authentication.
         * //    If not already done, install the gcloud CLI from
         * //    https://cloud.google.com/sdk and run
         * //    `gcloud beta auth application-default login`.
         * //    For more information, see
         * //    https://developers.google.com/identity/protocols/application-default-credentials
         * // 3. Install the Node.js client library by running
         * //    `npm install googleapis --save`
         *
         * var google = require('googleapis');
         * var compute = google.compute('v1');
         *
         * authorize(function(authClient) {
         *   var request = {
         *     // Project ID for this request.
         *     project: 'my-project',  // TODO: Update placeholder value.
         *
         *     auth: authClient,
         *   };
         *
         *   var handlePage = function(err, response) {
         *     if (err) {
         *       console.error(err);
         *       return;
         *     }
         *
         *     var itemsPage = response['items'];
         *     if (!itemsPage) {
         *       return;
         *     }
         *     for (var i = 0; i < itemsPage.length; i++) {
         *       // TODO: Change code below to process each resource in `itemsPage`:
         *       console.log(JSON.stringify(itemsPage[i], null, 2));
         *     }
         *
         *     if (response.nextPageToken) {
         *       request.pageToken = response.nextPageToken;
         *       compute.httpHealthChecks.list(request, handlePage);
         *     }
         *   };
         *
         *   compute.httpHealthChecks.list(request, handlePage);
         * });
         *
         * function authorize(callback) {
         *   google.auth.getApplicationDefault(function(err, authClient) {
         *     if (err) {
         *       console.error('authentication failed: ', err);
         *       return;
         *     }
         *     if (authClient.createScopedRequired && authClient.createScopedRequired()) {
         *       var scopes = ['https://www.googleapis.com/auth/cloud-platform'];
         *       authClient = authClient.createScoped(scopes);
         *     }
         *     callback(authClient);
         *   });
         * }
         * @alias compute.httpHealthChecks.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.  For example, if you are filtering Compute Engine instances, you can exclude instances named example-instance by specifying name != example-instance.  You can also filter nested fields. For example, you could specify scheduling.automaticRestart = false to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.  To filter on multiple expressions, provide each separate expression within parentheses. For example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each expression is an AND expression. However, you can include AND and OR expressions explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true).
         * @param {integer=} params.maxResults The maximum number of results per page that should be returned. If the number of available results is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
         * @param {string=} params.orderBy Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.  You can also sort results in descending order based on the creation timestamp using orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.  Currently, only sorting by name or creationTimestamp desc is supported.
         * @param {string=} params.pageToken Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list request to get the next page of results.
         * @param {string} params.project Project ID for this request.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Httphealthchecks$List, options?: MethodOptions): GaxiosPromise<Schema$HttpHealthCheckList>;
        list(params: Params$Resource$Httphealthchecks$List, options: MethodOptions | BodyResponseCallback<Schema$HttpHealthCheckList>, callback: BodyResponseCallback<Schema$HttpHealthCheckList>): void;
        list(params: Params$Resource$Httphealthchecks$List, callback: BodyResponseCallback<Schema$HttpHealthCheckList>): void;
        list(callback: BodyResponseCallback<Schema$HttpHealthCheckList>): void;
        /**
         * compute.httpHealthChecks.patch
         * @desc Updates a HttpHealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
         * @example
         * * // BEFORE RUNNING:
         * // ---------------
         * // 1. If not already done, enable the Compute Engine API
         * //   