---
id: version-12.22.2-i18n
title: Internationalization
original_id: i18n
---

![This feature is available to Botpress Enterprise license holders.](../assets/botpress-enterprise-feature.png)
## Add a language

In the Admin section > Your bots > Configs you will find a section for **Supported Languages** as in the screenshot below:

![Bot Config](../assets/i18n-configs.png)

## Switch language

Go back to Studio and switch language.

![Switch Language](../assets/i18n-switch-lang.png)

You'll see a "missing translation" notification on your content.

![Missing Translation](../assets/i18n-missing-translation.png)

## Translate your content

Edit the content and add a translation
![Edit Content](../assets/i18n-edit-content.png)
![Edited Content](../assets/i18n-edited-content.png)

## Change the language

Botpress uses the browser language to detect the user language. The detected language is stored in the `language` field of the user attributes. Thus, it is possible to change the language of a user by modifying this field.

See [updateAttributes](https://botpress.com/reference/modules/_botpress_sdk_.users.html#updateattributes)

Example usage:

```js
await bp.users.updateAttributes('web', 'someId', { language: 'fr' })
```
