---
id: introduction
title: About Botpress
---

## What is Botpress

> Botpress is an open-source platform for developers to build high-quality digital assistants.

We make building chatbots much easier for developers. We have put together the boilerplate code and infrastructure you need to get a chatbot up and running. We propose you a complete dev-friendly platform that ships with all the tools you need to build, deploy and manage production-grade chatbots in record time. The platform includes:
- Built-in **Natural Language Processing** tasks such as intent recognition, spell checking, entity extraction, and slot tagging (and many others)
- A **visual conversation studio** to design multi-turn conversations and workflows.
- An **emulator & a debugger** to simulate conversations and debug your chatbot
- Support for **popular messaging channels** like Slack, Telegram, MS Teams, Facebook Messenger, and an embeddable web chat.
- An **SDK and code editor** to extend the capabilities
- **Post-deployment tools** like analytics dashboards, human handoff
And more… (Complete Features Overview)[botpress.com/features/overview]

## Why Botpress
Botpress has many advantages over other platforms and frameworks:
- It is **cloud-agnostic**, therefore you can run it on the cloud platform or the on-premise infrastructure of your choice, giving you **full control over your data privacy.**
- The core of the Botpress platform is **open-source** with thousands of GitHub contributors and stargazers, and a thriving community forum.
- The platform offers a **great developer experience** by being remarkably flexible, easy to use, and fast.
Support for **multiple languages**, including French, Arabic, Spanish, and 100 more
- **No vendor lock-in**

Most importantly, our platform has proven to deliver a better conversational experience to end-users. 

## With Botpress You Can
**Automate Workflows**: This is a real customer story; you can automate the workflow of applying for a Mortgage by gathering the information you need from potential customers through a chat on your website.

**Support your customer 24/7**: If someone is not behind your Facebook Messenger, your customer is most likely not gonna get the answer they need and he might go to a different business. A chatbot can answer your customer’s questions even when you are asleep.

**Allow employees to self-serve**: The classic example is resetting a password. Some people are required to ask a system administrator or an IT person to reset their password when they get logged out of their email. The truth is they could just ask in Slack for a password reset and it could take care of itself.

**Create a conversational interface for an application**: Some applications are better delivered with a GUI, but in other cases, a conversational interface is simply a better option. It’s just really natural for someone to ask in plain English rather than browsing an interface. ‘’Hey, I am looking for a training plan for my next marathon’’

## Who else uses Botpress?
Botpress has been deployed in production thousands of times across 4 continents. A wide range of companies, including digital agencies, Fortune 500 organizations, governments, and startups are building digital assistants with Botpress Platform.
