/**
 * Copyright (c) 2017-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

const React = require('react')

const CompLibrary = require('../../core/CompLibrary')

const Container = CompLibrary.Container

const CWD = process.cwd()

const siteConfig = require(`${CWD}/siteConfig.js`)
const versions = require(`${CWD}/versions.json`)

function Versions() {
  const latestVersion = versions[0]
  const repoUrl = `https://github.com/${siteConfig.organizationName}/${siteConfig.projectName}`
  return (
    <div className="docMainWrapper wrapper">
      <Container className="mainContainer versionsContainer">
        <div className="post">
          <header className="postHeader">
            <h1>{siteConfig.title} Versions</h1>
          </header>
          <p>New versions of this project are released every so often.</p>
          <h3 id="latest">Current version (Stable)</h3>
          <table className="versions">
            <tbody>
              <tr>
                <th>{latestVersion}</th>
                <td>
                  <a href={`/docs/installation`}>Documentation</a>
                </td>
                <td>
                  <a href={`/docs/releases/release-notes`}>Release Notes</a>
                </td>
              </tr>
            </tbody>
          </table>
          <p>This is the version that is configured automatically when you first install this project.</p>
          <h3 id="rc">Pre-release versions</h3>
          <table className="versions">
            <tbody>
              <tr>
                <th>master</th>
                <td>
                  <a href="/docs/next/installation">Documentation</a>
                </td>
                <td>
                  <a href="https://github.com/botpress/botpress">Source Code</a>
                </td>
              </tr>
            </tbody>
          </table>
          <p>
            Nightly builds are based on this <strong>master</strong> branch
          </p>
          <h3 id="archive">Past Versions</h3>
          <table className="versions">
            <tbody>
              {versions.map(
                version =>
                  version !== latestVersion && (
                    <tr>
                      <th>{version}</th>
                      <td>
                        <a href={`/docs/${version}/installation`}>Documentation</a>
                      </td>
                    </tr>
                  )
              )}
            </tbody>
          </table>

          <h3 id="archive" style={{ color: '#FF0000' }}>
            ⚠️ Deprecated Versions
          </h3>

          <table className="versions">
            <tbody>
              <tr>
                <th>10.50</th>
                <td>Documentation</td>
              </tr>
            </tbody>
          </table>
        </div>
      </Container>
    </div>
  )
}

module.exports = Versions
