---
id: version-11.6.0-i18n
title: Internationalization (i18n)
original_id: i18n
---

Support of multiple languages means answering several questions:

1. How would the bot know which language to use?
2. How would admin add text-translations?
3. How would bot render appropriate content?

## Selecting language

There are many scenarios when dealing with language and depend on your needs, solutions can range from storing a users choice in a variable to fetching the users language from the third-party service.

In our case, we will keep things simple and just a add a Choice for the user to pick from at the beginning of the conversation.

You can then store the user's choice in the `state` by preparing a [simple action](/docs/build/code) for this purpose. Let's assume we offer the choice between English and Arabic, after the user chooses their language, we will set `state.language` either to "En" or "Ar".

## Adopting content schema

Botpress allows you to define a [custom content type](/docs/build/content) that will allow you to store text in multiple languages. Here's an example of a `translate_text` content-type:

```js
function renderElement(data, channel) {
  const language = data.state.language || 'En'
  return [
    {
      type: 'text',
      typing: true,
      markdown: true,
      text: data[`text${language}`],
      'web-style': { direction: language === 'Ar' ? 'rtl' : 'ltr' }
    }
  ]
}

module.exports = {
  id: 'translated_text',
  title: 'Translated Text',
  jsonSchema: {
    title: 'Text Message',
    description: 'A normal text message with translations',
    type: 'object',
    required: ['textEn', 'textAr'],
    properties: {
      textEn: { type: 'string', title: 'Text (English)' },
      textAr: { type: 'string', title: 'Text (Arabic)' }
    }
  },
  uiSchema: {},
  computePreviewText: formData => formData.textEn + ' / ' + formData.textAr,
  renderElemnet: renderElement
}
```

Notice in the above example that via the `web-style` key we are changing the direction in which the text is written, making it right-to-left for Arabic
