/**
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { OAuth2Client, JWT, Compute, UserRefreshClient } from 'google-auth-library';
import { GoogleConfigurable, MethodOptions, GlobalOptions, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { GaxiosPromise } from 'gaxios';
export declare namespace tpu_v1 {
    export interface Options extends GlobalOptions {
        version: 'v1';
    }
    interface StandardParameters {
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Cloud TPU API
     *
     * TPU API provides customers with access to Google TPU technology.
     *
     * @example
     * const {google} = require('googleapis');
     * const tpu = google.tpu('v1');
     *
     * @namespace tpu
     * @type {Function}
     * @version v1
     * @variation v1
     * @param {object=} options Options for Tpu
     */
    export class Tpu {
        context: APIRequestContext;
        projects: Resource$Projects;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * A accelerator type that a Node can be configured with.
     */
    export interface Schema$AcceleratorType {
        /**
         * The resource name.
         */
        name?: string;
        /**
         * the accelerator type.
         */
        type?: string;
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance:      service Foo {       rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The JSON representation for `Empty` is empty JSON object `{}`.
     */
    export interface Schema$Empty {
    }
    /**
     * Response for ListAcceleratorTypes.
     */
    export interface Schema$ListAcceleratorTypesResponse {
        /**
         * The listed nodes.
         */
        acceleratorTypes?: Schema$AcceleratorType[];
        /**
         * The next page token or empty if none.
         */
        nextPageToken?: string;
        /**
         * Locations that could not be reached.
         */
        unreachable?: string[];
    }
    /**
     * The response message for Locations.ListLocations.
     */
    export interface Schema$ListLocationsResponse {
        /**
         * A list of locations that matches the specified filter in the request.
         */
        locations?: Schema$Location[];
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string;
    }
    /**
     * Response for ListNodes.
     */
    export interface Schema$ListNodesResponse {
        /**
         * The next page token or empty if none.
         */
        nextPageToken?: string;
        /**
         * The listed nodes.
         */
        nodes?: Schema$Node[];
        /**
         * Locations that could not be reached.
         */
        unreachable?: string[];
    }
    /**
     * The response message for Operations.ListOperations.
     */
    export interface Schema$ListOperationsResponse {
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string;
        /**
         * A list of operations that matches the specified filter in the request.
         */
        operations?: Schema$Operation[];
    }
    /**
     * Response for ListTensorFlowVersions.
     */
    export interface Schema$ListTensorFlowVersionsResponse {
        /**
         * The next page token or empty if none.
         */
        nextPageToken?: string;
        /**
         * The listed nodes.
         */
        tensorflowVersions?: Schema$TensorFlowVersion[];
        /**
         * Locations that could not be reached.
         */
        unreachable?: string[];
    }
    /**
     * A resource that represents Google Cloud Platform location.
     */
    export interface Schema$Location {
        /**
         * The friendly name for this location, typically a nearby city name. For example, &quot;Tokyo&quot;.
         */
        displayName?: string;
        /**
         * Cross-service attributes for the location. For example      {&quot;cloud.googleapis.com/region&quot;: &quot;us-east1&quot;}
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * The canonical id for this location. For example: `&quot;us-east1&quot;`.
         */
        locationId?: string;
        /**
         * Service-specific metadata. For example the available capacity at the given location.
         */
        metadata?: {
            [key: string]: any;
        };
        /**
         * Resource name for the location, which may vary between implementations. For example: `&quot;projects/example-project/locations/us-east1&quot;`
         */
        name?: string;
    }
    /**
     * A network endpoint over which a TPU worker can be reached.
     */
    export interface Schema$NetworkEndpoint {
        /**
         * The IP address of this network endpoint.
         */
        ipAddress?: string;
        /**
         * The port of this network endpoint.
         */
        port?: number;
    }
    /**
     * A TPU instance.
     */
    export interface Schema$Node {
        /**
         * The type of hardware accelerators associated with this node. Required.
         */
        acceleratorType?: string;
        /**
         * The CIDR block that the TPU node will use when selecting an IP address. This CIDR block must be a /29 block; the Compute Engine networks API forbids a smaller block, and using a larger block would be wasteful (a node can only consume one IP address). Errors will occur if the CIDR block has already been used for a currently existing TPU node, the CIDR block conflicts with any subnetworks in the user&#39;s provided network, or the provided network is peered with another network that is using that CIDR block. Required.
         */
        cidrBlock?: string;
        /**
         * Output only. The time when the node was created.
         */
        createTime?: string;
        /**
         * The user-supplied description of the TPU. Maximum of 512 characters.
         */
        description?: string;
        /**
         * The health status of the TPU node.
         */
        health?: string;
        /**
         * Output only. If this field is populated, it contains a description of why the TPU Node is unhealthy.
         */
        healthDescription?: string;
        /**
         * Output only. DEPRECATED! Use network_endpoints instead. The network address for the TPU Node as visible to Compute Engine instances.
         */
        ipAddress?: string;
        /**
         * Resource labels to represent user-provided metadata.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * Output only. The immutable name of the TPU
         */
        name?: string;
        /**
         * The name of a network they wish to peer the TPU node to. It must be a preexisting Compute Engine network inside of the project on which this API has been activated. If none is provided, &quot;default&quot; will be used.
         */
        network?: string;
        /**
         * Output only. The network endpoints where TPU workers can be accessed and sent work. It is recommended that Tensorflow clients of the node reach out to the 0th entry in this map first.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
        /**
         * Output only. DEPRECATED! Use network_endpoints instead. The network port for the TPU Node as visible to Compute Engine instances.
         */
        port?: string;
        schedulingConfig?: Schema$SchedulingConfig;
        /**
         * Output only. The service account used to run the tensor flow services within the node. To share resources, including Google Cloud Storage data, with the Tensorflow job running in the Node, this account must have permissions to that data.
         */
        serviceAccount?: string;
        /**
         * Output only. The current state for the TPU Node.
         */
        state?: string;
        /**
         * The version of Tensorflow running in the Node. Required.
         */
        tensorflowVersion?: string;
    }
    /**
     * This resource represents a long-running operation that is the result of a network API call.
     */
    export interface Schema$Operation {
        /**
         * If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
         */
        done?: boolean;
        /**
         * The error result of the operation in case of failure or cancellation.
         */
        error?: Schema$Status;
        /**
         * Service-specific metadata associated with the operation.  It typically contains progress information and common metadata such as create time. Some services might not provide such metadata.  Any method that returns a long-running operation should document the metadata type, if any.
         */
        metadata?: {
            [key: string]: any;
        };
        /**
         * The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id}`.
         */
        name?: string;
        /**
         * The normal response of the operation in case of success.  If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`.  If the original method is standard `Get`/`Create`/`Update`, the response should be the resource.  For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name.  For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
         */
        response?: {
            [key: string]: any;
        };
    }
    /**
     * Represents the metadata of the long-running operation.
     */
    export interface Schema$OperationMetadata {
        /**
         * [Output only] API version used to start the operation.
         */
        apiVersion?: string;
        /**
         * [Output only] Identifies whether the user has requested cancellation of the operation. Operations that have successfully been cancelled have Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
         */
        cancelRequested?: boolean;
        /**
         * [Output only] The time the operation was created.
         */
        createTime?: string;
        /**
         * [Output only] The time the operation finished running.
         */
        endTime?: string;
        /**
         * [Output only] Human-readable status of the operation, if any.
         */
        statusDetail?: string;
        /**
         * [Output only] Server-defined resource path for the target of the operation.
         */
        target?: string;
        /**
         * [Output only] Name of the verb executed by the operation.
         */
        verb?: string;
    }
    /**
     * Request for ReimageNode.
     */
    export interface Schema$ReimageNodeRequest {
        /**
         * The version for reimage to create.
         */
        tensorflowVersion?: string;
    }
    export interface Schema$SchedulingConfig {
        preemptible?: boolean;
        /**
         * Whether the node is created under a reservation.
         */
        reserved?: boolean;
    }
    /**
     * Request for StartNode.
     */
    export interface Schema$StartNodeRequest {
    }
    /**
     * The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details.  You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
     */
    export interface Schema$Status {
        /**
         * The status code, which should be an enum value of google.rpc.Code.
         */
        code?: number;
        /**
         * A list of messages that carry the error details.  There is a common set of message types for APIs to use.
         */
        details?: Array<{
            [key: string]: any;
        }>;
        /**
         * A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
         */
        message?: string;
    }
    /**
     * Request for StopNode.
     */
    export interface Schema$StopNodeRequest {
    }
    /**
     * A tensorflow version that a Node can be configured with.
     */
    export interface Schema$TensorFlowVersion {
        /**
         * The resource name.
         */
        name?: string;
        /**
         * the tensorflow version.
         */
        version?: string;
    }
    export class Resource$Projects {
        context: APIRequestContext;
        locations: Resource$Projects$Locations;
        constructor(context: APIRequestContext);
    }
    export class Resource$Projects$Locations {
        context: APIRequestContext;
        acceleratorTypes: Resource$Projects$Locations$Acceleratortypes;
        nodes: Resource$Projects$Locations$Nodes;
        operations: Resource$Projects$Locations$Operations;
        tensorflowVersions: Resource$Projects$Locations$Tensorflowversions;
        constructor(context: APIRequestContext);
        /**
         * tpu.projects.locations.get
         * @desc Gets information about a location.
         * @alias tpu.projects.locations.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name Resource name for the location.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Projects$Locations$Get, options?: MethodOptions): GaxiosPromise<Schema$Location>;
        get(params: Params$Resource$Projects$Locations$Get, options: MethodOptions | BodyResponseCallback<Schema$Location>, callback: BodyResponseCallback<Schema$Location>): void;
        get(params: Params$Resource$Projects$Locations$Get, callback: BodyResponseCallback<Schema$Location>): void;
        get(callback: BodyResponseCallback<Schema$Location>): void;
        /**
         * tpu.projects.locations.list
         * @desc Lists information about the supported locations for this service.
         * @alias tpu.projects.locations.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter The standard list filter.
         * @param {string} params.name The resource that owns the locations collection, if applicable.
         * @param {integer=} params.pageSize The standard list page size.
         * @param {string=} params.pageToken The standard list page token.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Projects$Locations$List, options?: MethodOptions): GaxiosPromise<Schema$ListLocationsResponse>;
        list(params: Params$Resource$Projects$Locations$List, options: MethodOptions | BodyResponseCallback<Schema$ListLocationsResponse>, callback: BodyResponseCallback<Schema$ListLocationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$List, callback: BodyResponseCallback<Schema$ListLocationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListLocationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Resource name for the location.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The resource that owns the locations collection, if applicable.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
    }
    export class Resource$Projects$Locations$Acceleratortypes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * tpu.projects.locations.acceleratorTypes.get
         * @desc Gets AcceleratorType.
         * @alias tpu.projects.locations.acceleratorTypes.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Projects$Locations$Acceleratortypes$Get, options?: MethodOptions): GaxiosPromise<Schema$AcceleratorType>;
        get(params: Params$Resource$Projects$Locations$Acceleratortypes$Get, options: MethodOptions | BodyResponseCallback<Schema$AcceleratorType>, callback: BodyResponseCallback<Schema$AcceleratorType>): void;
        get(params: Params$Resource$Projects$Locations$Acceleratortypes$Get, callback: BodyResponseCallback<Schema$AcceleratorType>): void;
        get(callback: BodyResponseCallback<Schema$AcceleratorType>): void;
        /**
         * tpu.projects.locations.acceleratorTypes.list
         * @desc Lists accelerator types supported by this API.
         * @alias tpu.projects.locations.acceleratorTypes.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter List filter.
         * @param {string=} params.orderBy Sort results.
         * @param {integer=} params.pageSize The maximum number of items to return.
         * @param {string=} params.pageToken The next_page_token value returned from a previous List request, if any.
         * @param {string} params.parent The parent resource name.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Projects$Locations$Acceleratortypes$List, options?: MethodOptions): GaxiosPromise<Schema$ListAcceleratorTypesResponse>;
        list(params: Params$Resource$Projects$Locations$Acceleratortypes$List, options: MethodOptions | BodyResponseCallback<Schema$ListAcceleratorTypesResponse>, callback: BodyResponseCallback<Schema$ListAcceleratorTypesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Acceleratortypes$List, callback: BodyResponseCallback<Schema$ListAcceleratorTypesResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListAcceleratorTypesResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Acceleratortypes$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Acceleratortypes$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * List filter.
         */
        filter?: string;
        /**
         * Sort results.
         */
        orderBy?: string;
        /**
         * The maximum number of items to return.
         */
        pageSize?: number;
        /**
         * The next_page_token value returned from a previous List request, if any.
         */
        pageToken?: string;
        /**
         * The parent resource name.
         */
        parent?: string;
    }
    export class Resource$Projects$Locations$Nodes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * tpu.projects.locations.nodes.create
         * @desc Creates a node.
         * @alias tpu.projects.locations.nodes.create
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.nodeId The unqualified resource name.
         * @param {string} params.parent The parent resource name.
         * @param {().Node} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        create(params?: Params$Resource$Projects$Locations$Nodes$Create, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        create(params: Params$Resource$Projects$Locations$Nodes$Create, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        create(params: Params$Resource$Projects$Locations$Nodes$Create, callback: BodyResponseCallback<Schema$Operation>): void;
        create(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * tpu.projects.locations.nodes.delete
         * @desc Deletes a node.
         * @alias tpu.projects.locations.nodes.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Projects$Locations$Nodes$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Projects$Locations$Nodes$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Projects$Locations$Nodes$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * tpu.projects.locations.nodes.get
         * @desc Gets the details of a node.
         * @alias tpu.projects.locations.nodes.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Projects$Locations$Nodes$Get, options?: MethodOptions): GaxiosPromise<Schema$Node>;
        get(params: Params$Resource$Projects$Locations$Nodes$Get, options: MethodOptions | BodyResponseCallback<Schema$Node>, callback: BodyResponseCallback<Schema$Node>): void;
        get(params: Params$Resource$Projects$Locations$Nodes$Get, callback: BodyResponseCallback<Schema$Node>): void;
        get(callback: BodyResponseCallback<Schema$Node>): void;
        /**
         * tpu.projects.locations.nodes.list
         * @desc Lists nodes.
         * @alias tpu.projects.locations.nodes.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.pageSize The maximum number of items to return.
         * @param {string=} params.pageToken The next_page_token value returned from a previous List request, if any.
         * @param {string} params.parent The parent resource name.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Projects$Locations$Nodes$List, options?: MethodOptions): GaxiosPromise<Schema$ListNodesResponse>;
        list(params: Params$Resource$Projects$Locations$Nodes$List, options: MethodOptions | BodyResponseCallback<Schema$ListNodesResponse>, callback: BodyResponseCallback<Schema$ListNodesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Nodes$List, callback: BodyResponseCallback<Schema$ListNodesResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListNodesResponse>): void;
        /**
         * tpu.projects.locations.nodes.reimage
         * @desc Reimages a node's OS.
         * @alias tpu.projects.locations.nodes.reimage
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name.
         * @param {().ReimageNodeRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        reimage(params?: Params$Resource$Projects$Locations$Nodes$Reimage, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        reimage(params: Params$Resource$Projects$Locations$Nodes$Reimage, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        reimage(params: Params$Resource$Projects$Locations$Nodes$Reimage, callback: BodyResponseCallback<Schema$Operation>): void;
        reimage(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * tpu.projects.locations.nodes.start
         * @desc Starts a node.
         * @alias tpu.projects.locations.nodes.start
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name.
         * @param {().StartNodeRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        start(params?: Params$Resource$Projects$Locations$Nodes$Start, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        start(params: Params$Resource$Projects$Locations$Nodes$Start, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        start(params: Params$Resource$Projects$Locations$Nodes$Start, callback: BodyResponseCallback<Schema$Operation>): void;
        start(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * tpu.projects.locations.nodes.stop
         * @desc Stops a node.
         * @alias tpu.projects.locations.nodes.stop
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name.
         * @param {().StopNodeRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        stop(params?: Params$Resource$Projects$Locations$Nodes$Stop, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        stop(params: Params$Resource$Projects$Locations$Nodes$Stop, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        stop(params: Params$Resource$Projects$Locations$Nodes$Stop, callback: BodyResponseCallback<Schema$Operation>): void;
        stop(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    export interface Params$Resource$Projects$Locations$Nodes$Create extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unqualified resource name.
         */
        nodeId?: string;
        /**
         * The parent resource name.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Node;
    }
    export interface Params$Resource$Projects$Locations$Nodes$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Nodes$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Nodes$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The maximum number of items to return.
         */
        pageSize?: number;
        /**
         * The next_page_token value returned from a previous List request, if any.
         */
        pageToken?: string;
        /**
         * The parent resource name.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Nodes$Reimage extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ReimageNodeRequest;
    }
    export interface Params$Resource$Projects$Locations$Nodes$Start extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$StartNodeRequest;
    }
    export interface Params$Resource$Projects$Locations$Nodes$Stop extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$StopNodeRequest;
    }
    export class Resource$Projects$Locations$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * tpu.projects.locations.operations.cancel
         * @desc Starts asynchronous cancellation on a long-running operation.  The server makes a best effort to cancel the operation, but success is not guaranteed.  If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.  Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
         * @alias tpu.projects.locations.operations.cancel
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The name of the operation resource to be cancelled.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        cancel(params?: Params$Resource$Projects$Locations$Operations$Cancel, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        cancel(params: Params$Resource$Projects$Locations$Operations$Cancel, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        cancel(params: Params$Resource$Projects$Locations$Operations$Cancel, callback: BodyResponseCallback<Schema$Empty>): void;
        cancel(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * tpu.projects.locations.operations.delete
         * @desc Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
         * @alias tpu.projects.locations.operations.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The name of the operation resource to be deleted.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Projects$Locations$Operations$Delete, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        delete(params: Params$Resource$Projects$Locations$Operations$Delete, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(params: Params$Resource$Projects$Locations$Operations$Delete, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * tpu.projects.locations.operations.get
         * @desc Gets the latest state of a long-running operation.  Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @alias tpu.projects.locations.operations.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The name of the operation resource.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Projects$Locations$Operations$Get, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        get(params: Params$Resource$Projects$Locations$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        get(params: Params$Resource$Projects$Locations$Operations$Get, callback: BodyResponseCallback<Schema$Operation>): void;
        get(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * tpu.projects.locations.operations.list
         * @desc Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.  NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/x/operations`. To override the binding, API services can add a binding such as `"/v1/{name=users/x}/operations"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.
         * @alias tpu.projects.locations.operations.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter The standard list filter.
         * @param {string} params.name The name of the operation's parent resource.
         * @param {integer=} params.pageSize The standard list page size.
         * @param {string=} params.pageToken The standard list page token.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Projects$Locations$Operations$List, options?: MethodOptions): GaxiosPromise<Schema$ListOperationsResponse>;
        list(params: Params$Resource$Projects$Locations$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$ListOperationsResponse>, callback: BodyResponseCallback<Schema$ListOperationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Operations$List, callback: BodyResponseCallback<Schema$ListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListOperationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Operations$Cancel extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the operation resource to be cancelled.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Operations$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the operation resource to be deleted.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Operations$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Operations$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
    }
    export class Resource$Projects$Locations$Tensorflowversions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * tpu.projects.locations.tensorflowVersions.get
         * @desc Gets TensorFlow Version.
         * @alias tpu.projects.locations.tensorflowVersions.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Projects$Locations$Tensorflowversions$Get, options?: MethodOptions): GaxiosPromise<Schema$TensorFlowVersion>;
        get(params: Params$Resource$Projects$Locations$Tensorflowversions$Get, options: MethodOptions | BodyResponseCallback<Schema$TensorFlowVersion>, callback: BodyResponseCallback<Schema$TensorFlowVersion>): void;
        get(params: Params$Resource$Projects$Locations$Tensorflowversions$Get, callback: BodyResponseCallback<Schema$TensorFlowVersion>): void;
        get(callback: BodyResponseCallback<Schema$TensorFlowVersion>): void;
        /**
         * tpu.projects.locations.tensorflowVersions.list
         * @desc List TensorFlow versions supported by this API.
         * @alias tpu.projects.locations.tensorflowVersions.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter List filter.
         * @param {string=} params.orderBy Sort results.
         * @param {integer=} params.pageSize The maximum number of items to return.
         * @param {string=} params.pageToken The next_page_token value returned from a previous List request, if any.
         * @param {string} params.parent The parent resource name.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Projects$Locations$Tensorflowversions$List, options?: MethodOptions): GaxiosPromise<Schema$ListTensorFlowVersionsResponse>;
        list(params: Params$Resource$Projects$Locations$Tensorflowversions$List, options: MethodOptions | BodyResponseCallback<Schema$ListTensorFlowVersionsResponse>, callback: BodyResponseCallback<Schema$ListTensorFlowVersionsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Tensorflowversions$List, callback: BodyResponseCallback<Schema$ListTensorFlowVersionsResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListTensorFlowVersionsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Tensorflowversions$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Tensorflowversions$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * List filter.
         */
        filter?: string;
        /**
         * Sort results.
         */
        orderBy?: string;
        /**
         * The maximum number of items to return.
         */
        pageSize?: number;
        /**
         * The next_page_token value returned from a previous List request, if any.
         */
        pageToken?: string;
        /**
         * The parent resource name.
         */
        parent?: string;
    }
    export {};
}
