"use strict";
/**
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const googleapis_common_1 = require("googleapis-common");
// tslint:disable: no-any
// tslint:disable: class-name
// tslint:disable: variable-name
// tslint:disable: jsdoc-format
// tslint:disable: no-namespace
var commentanalyzer_v1alpha1;
(function (commentanalyzer_v1alpha1) {
    /**
     * Perspective Comment Analyzer API
     *
     * The Perspective Comment Analyzer API provides information about the potential impact of a comment on a conversation (e.g. it can provide a score for the &quot;toxicity&quot; of a comment). Users can leverage the &quot;SuggestCommentScore&quot; method to submit corrections to improve Perspective over time. Users can set the &quot;doNotStore&quot; flag to ensure that all submitted comments are automatically deleted after scores are returned.
     *
     * @example
     * const {google} = require('googleapis');
     * const commentanalyzer = google.commentanalyzer('v1alpha1');
     *
     * @namespace commentanalyzer
     * @type {Function}
     * @version v1alpha1
     * @variation v1alpha1
     * @param {object=} options Options for Commentanalyzer
     */
    class Commentanalyzer {
        constructor(options, google) {
            this.context = {
                _options: options || {},
                google,
            };
            this.comments = new Resource$Comments(this.context);
        }
    }
    commentanalyzer_v1alpha1.Commentanalyzer = Commentanalyzer;
    class Resource$Comments {
        constructor(context) {
            this.context = context;
        }
        analyze(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://commentanalyzer.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1alpha1/comments:analyze').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST',
                }, options),
                params,
                requiredParams: [],
                pathParams: [],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
        suggestscore(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback ||
                {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://commentanalyzer.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1alpha1/comments:suggestscore').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST',
                }, options),
                params,
                requiredParams: [],
                pathParams: [],
                context: this.context,
            };
            if (callback) {
                googleapis_common_1.createAPIRequest(parameters, callback);
            }
            else {
                return googleapis_common_1.createAPIRequest(parameters);
            }
        }
    }
    commentanalyzer_v1alpha1.Resource$Comments = Resource$Comments;
})(commentanalyzer_v1alpha1 = exports.commentanalyzer_v1alpha1 || (exports.commentanalyzer_v1alpha1 = {}));
//# sourceMappingURL=v1alpha1.js.map