/**
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { OAuth2Client, JWT, Compute, UserRefreshClient } from 'google-auth-library';
import { GoogleConfigurable, MethodOptions, GlobalOptions, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { GaxiosPromise } from 'gaxios';
export declare namespace cloudprivatecatalogproducer_v1beta1 {
    export interface Options extends GlobalOptions {
        version: 'v1beta1';
    }
    interface StandardParameters {
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Cloud Private Catalog Producer API
     *
     * Enables cloud users to manage and share enterprise catalogs intheir organizations.
     *
     * @example
     * const {google} = require('googleapis');
     * const cloudprivatecatalogproducer = google.cloudprivatecatalogproducer('v1beta1');
     *
     * @namespace cloudprivatecatalogproducer
     * @type {Function}
     * @version v1beta1
     * @variation v1beta1
     * @param {object=} options Options for Cloudprivatecatalogproducer
     */
    export class Cloudprivatecatalogproducer {
        context: APIRequestContext;
        catalogs: Resource$Catalogs;
        operations: Resource$Operations;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * An association tuple that pairs a `Catalog` to a resource that can use the `Catalog`. After association, a google.cloud.privatecatalog.v1beta1.Catalog becomes available to consumers under specified Association.resource and all of its child nodes. Users who have the `cloudprivatecatalog.targets.get` permission on any of the resource nodes can access the catalog and child products under the node.  For example, suppose the cloud resource hierarchy is as follows:  * organizations/example.com   * folders/team     * projects/test  After creating an association with `organizations/example.com`, the catalog `catalogs/1`  is accessible from the following paths:  * organizations/example.com * folders/team * projects/test  Users can access them by google.cloud.v1beta1.PrivateCatalog.SearchCatalogs action.
     */
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1Association {
        /**
         * The creation time of the association.
         */
        createTime?: string;
        /**
         * Output only. The resource name of the catalog association, in the format `catalogs/{catalog_id}/associations/{association_id}&#39;.  A unique identifier for the catalog association, which is generated by catalog service.
         */
        name?: string;
        /**
         * Required. The user-supplied fully qualified name of the `Resource` associated to the `Catalog`. It supports `Organization`, `Folder`, and `Project`. Values are of the form  * `//cloudresourcemanager.googleapis.com/projects/{product_number}` * `//cloudresourcemanager.googleapis.com/folders/{folder_id}` * `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
         */
        resource?: string;
    }
    /**
     * The producer representation of a catalog which is a curated collection of solutions that can be managed, controlled, and shared by cloud admins.
     */
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog {
        /**
         * Output only. The time when the catalog was created.
         */
        createTime?: string;
        /**
         * Required. The user-supplied description of the catalog. Maximum of 512 characters.
         */
        description?: string;
        /**
         * Required. The user-supplied descriptive name of the catalog as it appears in UIs. Maximum 256 characters in length.
         */
        displayName?: string;
        /**
         * Output only. The resource name of the catalog, in the format `catalogs/{catalog_id}&#39;.  A unique identifier for the catalog, which is generated by catalog service.
         */
        name?: string;
        /**
         * Required. The parent resource name of the catalog, which can&#39;t be changed after a catalog is created. It can only be an organization. Values are of the form `//cloudresourcemanager.googleapis.com/organizations/&lt;id&gt;`. Maximum 256 characters in length.
         */
        parent?: string;
        /**
         * Output only. The time when the catalog was last updated.
         */
        updateTime?: string;
    }
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1CopyProductRequest {
        /**
         * The resource name of the destination product that is copied to.
         */
        destinationProductName?: string;
    }
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1CreateAssociationRequest {
        /**
         * The user-supplied `Association` that is going to be created.  If the `resource` field is set, the `privatecatalogproducer.catalogTargets.associate` permission is checked on the target resource.
         */
        association?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Association;
    }
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1ListAssociationsResponse {
        /**
         * The returned `Association` resources from the list call.
         */
        associations?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Association[];
        /**
         * A pagination token returned from a previous call to `ListAssociations` that indicates where the listing should continue from. This field is optional.
         */
        nextPageToken?: string;
    }
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1ListCatalogsResponse {
        /**
         * The `Catalogs` returned from the list call.
         */
        catalogs?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog[];
        /**
         * A pagination token returned from a previous call to ListCatalogs that indicates where the listing should continue from. This field is optional.
         */
        nextPageToken?: string;
    }
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1ListProductsResponse {
        /**
         * A pagination token returned from a previous call to ListProducts that indicates where the listing should continue from. This field is optional.
         */
        nextPageToken?: string;
        /**
         * The `Product` returned from the list call.
         */
        products?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Product[];
    }
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1ListVersionsResponse {
        /**
         * A pagination token returned from a previous call to ListProducts that indicates where the listing should continue from. This field is optional.
         */
        nextPageToken?: string;
        /**
         * The `VersiVersionon` returned from the list call.
         */
        versions?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Version[];
    }
    /**
     * The producer representation of a product which is a child resource of `Catalog` with display metadata and a list of `Version` resources.
     */
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1Product {
        /**
         * Required. The type of the product asset, which cannot be changed after the product is created. It supports the values `google.deploymentmanager.Template` and `google.cloudprivatecatalog.ListingOnly`. Other values will be rejected by the server. Read only after creation.  The following fields or resource types have different validation rules under each `asset_type` values:  * Product.display_metadata has different validation schema for each asset type value. See its comment for details. * Version resource isn&#39;t allowed to be added under the `google.cloudprivatecatalog.ListingOnly` type.
         */
        assetType?: string;
        /**
         * Output only. The time when the product was created.
         */
        createTime?: string;
        /**
         * The user-supplied display metadata to describe the product. The JSON schema of the metadata differs by Product.asset_type. When the type is `google.deploymentmanager.Template`, the schema is as follows:  ``` &quot;$schema&quot;: http://json-schema.org/draft-04/schema# type: object properties:   name:     type: string     minLength: 1     maxLength: 64   description:     type: string     minLength: 1     maxLength: 2048   tagline:     type: string     minLength: 1     maxLength: 100   support_info:     type: string     minLength: 1     maxLength: 2048   creator:     type: string     minLength: 1     maxLength: 100   documentation:     type: array     items:       type: object       properties:         url:           type: string           pattern:           &quot;^(https?)://[-a-zA-Z0-9+&amp;@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&amp;@#/%=~_|]&quot;         title:           type: string           minLength: 1           maxLength: 64         description:           type: string           minLength: 1           maxLength: 2048 required: - name - description additionalProperties: false  ```  When the asset type is `google.cloudprivatecatalog.ListingOnly`, the schema is as follows:  ``` &quot;$schema&quot;: http://json-schema.org/draft-04/schema# type: object properties:   name:     type: string     minLength: 1     maxLength: 64   description:     type: string     minLength: 1     maxLength: 2048   tagline:     type: string     minLength: 1     maxLength: 100   support_info:     type: string     minLength: 1     maxLength: 2048   creator:     type: string     minLength: 1     maxLength: 100   documentation:     type: array     items:       type: object       properties:         url:           type: string           pattern:           &quot;^(https?)://[-a-zA-Z0-9+&amp;@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&amp;@#/%=~_|]&quot;         title:           type: string           minLength: 1           maxLength: 64         description:           type: string           minLength: 1           maxLength: 2048   signup_url:     type: string     pattern:     &quot;^(https?)://[-a-zA-Z0-9+&amp;@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&amp;@#/%=~_|]&quot; required: - name - description - signup_url additionalProperties: false ```
         */
        displayMetadata?: {
            [key: string]: any;
        };
        /**
         * Output only. The public accessible URI of the icon uploaded by PrivateCatalogProducer.UploadIcon.  If no icon is uploaded, it will be the default icon&#39;s URI.
         */
        iconUri?: string;
        /**
         * Required. The resource name of the product in the format `catalogs/{catalog_id}/products/a-z*[a-z0-9]&#39;.  A unique identifier for the product under a catalog, which cannot be changed after the product is created. The final segment of the name must between 1 and 256 characters in length.
         */
        name?: string;
        /**
         * Output only. The time when the product was last updated.
         */
        updateTime?: string;
    }
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1UndeleteCatalogRequest {
    }
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1UploadIconRequest {
        /**
         * The raw icon bytes user-supplied to be uploaded to the product. The format of the icon can only be PNG or JPEG. The minimum allowed dimensions are 130x130 pixels and the maximum dimensions are 10000x10000 pixels. Required.
         */
        icon?: string;
    }
    /**
     * The producer representation of a version, which is a child resource under a `Product` with asset data.
     */
    export interface Schema$GoogleCloudPrivatecatalogproducerV1beta1Version {
        /**
         * Output only. The asset which has been validated and is ready to be provisioned. See Version.original_asset for the schema.
         */
        asset?: {
            [key: string]: any;
        };
        /**
         * Output only. The time when the version was created.
         */
        createTime?: string;
        /**
         * The user-supplied description of the version. Maximum of 256 characters.
         */
        description?: string;
        /**
         * Required. The resource name of the version, in the format `catalogs/{catalog_id}/products/{product_id}/versions/a-z*[a-z0-9]&#39;.  A unique identifier for the version under a product, which can&#39;t be changed after the version is created. The final segment of the name must between 1 and 63 characters in length.
         */
        name?: string;
        /**
         * The user-supplied asset payload. The maximum size of the payload is 2MB. The JSON schema of the payload is defined as:  ``` type: object properties:   mainTemplate:     type: string     description: The file name of the main template and name prefix of     schema file. The content of the main template should be set in the     imports list. The schema file name is expected to be     &lt;mainTemplate&gt;.schema in the imports list. required: true   imports:     type: array     description: Import template and schema file contents. Required to have     both &lt;mainTemplate&gt; and &lt;mainTemplate&gt;.schema files. required: true     minItems: 2     items:       type: object       properties:         name:           type: string         content:           type: string ```
         */
        originalAsset?: {
            [key: string]: any;
        };
        /**
         * Output only. The time when the version was last updated.
         */
        updateTime?: string;
    }
    /**
     * Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted.  Example Policy with multiple AuditConfigs:      {       &quot;audit_configs&quot;: [         {           &quot;service&quot;: &quot;allServices&quot;           &quot;audit_log_configs&quot;: [             {               &quot;log_type&quot;: &quot;DATA_READ&quot;,               &quot;exempted_members&quot;: [                 &quot;user:jose@example.com&quot;               ]             },             {               &quot;log_type&quot;: &quot;DATA_WRITE&quot;,             },             {               &quot;log_type&quot;: &quot;ADMIN_READ&quot;,             }           ]         },         {           &quot;service&quot;: &quot;sampleservice.googleapis.com&quot;           &quot;audit_log_configs&quot;: [             {               &quot;log_type&quot;: &quot;DATA_READ&quot;,             },             {               &quot;log_type&quot;: &quot;DATA_WRITE&quot;,               &quot;exempted_members&quot;: [                 &quot;user:aliya@example.com&quot;               ]             }           ]         }       ]     }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
     */
    export interface Schema$GoogleIamV1AuditConfig {
        /**
         * The configuration for logging of each type of permission.
         */
        auditLogConfigs?: Schema$GoogleIamV1AuditLogConfig[];
        /**
         * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
         */
        service?: string;
    }
    /**
     * Provides the configuration for logging a type of permissions. Example:      {       &quot;audit_log_configs&quot;: [         {           &quot;log_type&quot;: &quot;DATA_READ&quot;,           &quot;exempted_members&quot;: [             &quot;user:jose@example.com&quot;           ]         },         {           &quot;log_type&quot;: &quot;DATA_WRITE&quot;,         }       ]     }  This enables &#39;DATA_READ&#39; and &#39;DATA_WRITE&#39; logging, while exempting jose@example.com from DATA_READ logging.
     */
    export interface Schema$GoogleIamV1AuditLogConfig {
        /**
         * Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
         */
        exemptedMembers?: string[];
        /**
         * The log type that this config enables.
         */
        logType?: string;
    }
    /**
     * Associates `members` with a `role`.
     */
    export interface Schema$GoogleIamV1Binding {
        /**
         * The condition that is associated with this binding. NOTE: An unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
         */
        condition?: Schema$GoogleTypeExpr;
        /**
         * Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values:  * `allUsers`: A special identifier that represents anyone who is    on the internet; with or without a Google account.  * `allAuthenticatedUsers`: A special identifier that represents anyone    who is authenticated with a Google account or a service account.  * `user:{emailid}`: An email address that represents a specific Google    account. For example, `alice@example.com` .   * `serviceAccount:{emailid}`: An email address that represents a service    account. For example, `my-other-app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address that represents a Google group.    For example, `admins@example.com`.   * `domain:{domain}`: The G Suite domain (primary) that represents all the    users of that domain. For example, `google.com` or `example.com`.
         */
        members?: string[];
        /**
         * Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
         */
        role?: string;
    }
    /**
     * Defines an Identity and Access Management (IAM) policy. It is used to specify access control policies for Cloud Platform resources.   A `Policy` consists of a list of `bindings`. A `binding` binds a list of `members` to a `role`, where the members can be user accounts, Google groups, Google domains, and service accounts. A `role` is a named list of permissions defined by IAM.  **JSON Example**      {       &quot;bindings&quot;: [         {           &quot;role&quot;: &quot;roles/owner&quot;,           &quot;members&quot;: [             &quot;user:mike@example.com&quot;,             &quot;group:admins@example.com&quot;,             &quot;domain:google.com&quot;,             &quot;serviceAccount:my-other-app@appspot.gserviceaccount.com&quot;           ]         },         {           &quot;role&quot;: &quot;roles/viewer&quot;,           &quot;members&quot;: [&quot;user:sean@example.com&quot;]         }       ]     }  **YAML Example**      bindings:     - members:       - user:mike@example.com       - group:admins@example.com       - domain:google.com       - serviceAccount:my-other-app@appspot.gserviceaccount.com       role: roles/owner     - members:       - user:sean@example.com       role: roles/viewer   For a description of IAM and its features, see the [IAM developer&#39;s guide](https://cloud.google.com/iam/docs).
     */
    export interface Schema$GoogleIamV1Policy {
        /**
         * Specifies cloud audit logging configuration for this policy.
         */
        auditConfigs?: Schema$GoogleIamV1AuditConfig[];
        /**
         * Associates a list of `members` to a `role`. `bindings` with no members will result in an error.
         */
        bindings?: Schema$GoogleIamV1Binding[];
        /**
         * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy.  If no `etag` is provided in the call to `setIamPolicy`, then the existing policy is overwritten.
         */
        etag?: string;
        /**
         * Deprecated.
         */
        version?: number;
    }
    /**
     * Request message for `SetIamPolicy` method.
     */
    export interface Schema$GoogleIamV1SetIamPolicyRequest {
        /**
         * REQUIRED: The complete policy to be applied to the `resource`. The size of the policy is limited to a few 10s of KB. An empty policy is a valid policy but certain Cloud Platform services (such as Projects) might reject them.
         */
        policy?: Schema$GoogleIamV1Policy;
        /**
         * OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only the fields in the mask will be modified. If no mask is provided, the following default mask is used: paths: &quot;bindings, etag&quot; This field is only used by Cloud IAM.
         */
        updateMask?: string;
    }
    /**
     * Request message for `TestIamPermissions` method.
     */
    export interface Schema$GoogleIamV1TestIamPermissionsRequest {
        /**
         * The set of permissions to check for the `resource`. Permissions with wildcards (such as &#39;*&#39; or &#39;storage.*&#39;) are not allowed. For more information see [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
         */
        permissions?: string[];
    }
    /**
     * Response message for `TestIamPermissions` method.
     */
    export interface Schema$GoogleIamV1TestIamPermissionsResponse {
        /**
         * A subset of `TestPermissionsRequest.permissions` that the caller is allowed.
         */
        permissions?: string[];
    }
    /**
     * The request message for Operations.CancelOperation.
     */
    export interface Schema$GoogleLongrunningCancelOperationRequest {
    }
    /**
     * The response message for Operations.ListOperations.
     */
    export interface Schema$GoogleLongrunningListOperationsResponse {
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string;
        /**
         * A list of operations that matches the specified filter in the request.
         */
        operations?: Schema$GoogleLongrunningOperation[];
    }
    /**
     * This resource represents a long-running operation that is the result of a network API call.
     */
    export interface Schema$GoogleLongrunningOperation {
        /**
         * If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
         */
        done?: boolean;
        /**
         * The error result of the operation in case of failure or cancellation.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Service-specific metadata associated with the operation.  It typically contains progress information and common metadata such as create time. Some services might not provide such metadata.  Any method that returns a long-running operation should document the metadata type, if any.
         */
        metadata?: {
            [key: string]: any;
        };
        /**
         * The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id}`.
         */
        name?: string;
        /**
         * The normal response of the operation in case of success.  If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`.  If the original method is standard `Get`/`Create`/`Update`, the response should be the resource.  For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name.  For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
         */
        response?: {
            [key: string]: any;
        };
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance:      service Foo {       rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The JSON representation for `Empty` is empty JSON object `{}`.
     */
    export interface Schema$GoogleProtobufEmpty {
    }
    /**
     * The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details.  You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
     */
    export interface Schema$GoogleRpcStatus {
        /**
         * The status code, which should be an enum value of google.rpc.Code.
         */
        code?: number;
        /**
         * A list of messages that carry the error details.  There is a common set of message types for APIs to use.
         */
        details?: Array<{
            [key: string]: any;
        }>;
        /**
         * A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
         */
        message?: string;
    }
    /**
     * Represents an expression text. Example:      title: &quot;User account presence&quot;     description: &quot;Determines whether the request has a user account&quot;     expression: &quot;size(request.user) &gt; 0&quot;
     */
    export interface Schema$GoogleTypeExpr {
        /**
         * An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
         */
        description?: string;
        /**
         * Textual representation of an expression in Common Expression Language syntax.  The application context of the containing message determines which well-known feature set of CEL is supported.
         */
        expression?: string;
        /**
         * An optional string indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
         */
        location?: string;
        /**
         * An optional title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
         */
        title?: string;
    }
    export class Resource$Catalogs {
        context: APIRequestContext;
        associations: Resource$Catalogs$Associations;
        products: Resource$Catalogs$Products;
        constructor(context: APIRequestContext);
        /**
         * cloudprivatecatalogproducer.catalogs.create
         * @desc Creates a new Catalog resource.
         * @alias cloudprivatecatalogproducer.catalogs.create
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1Catalog} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        create(params?: Params$Resource$Catalogs$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        create(params: Params$Resource$Catalogs$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(params: Params$Resource$Catalogs$Create, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.delete
         * @desc Soft deletes an existing Catalog and all resources under it. The catalog can only be deleted if there is no associations under it or DeleteCatalogRequest.force is true. The delete operation can be recovered by the PrivateCatalogProducer.UndeleteCatalog method.
         * @alias cloudprivatecatalogproducer.catalogs.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {boolean=} params.force Forces deletion of the `Catalog` and its `Association` resources. If the `Catalog` is still associated with other resources and force is not set to true, then the operation fails.
         * @param {string} params.name The resource name of the catalog.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Catalogs$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>;
        delete(params: Params$Resource$Catalogs$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        delete(params: Params$Resource$Catalogs$Delete, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.get
         * @desc Returns the requested Catalog resource.
         * @alias cloudprivatecatalogproducer.catalogs.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name of the catalog.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Catalogs$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>;
        get(params: Params$Resource$Catalogs$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        get(params: Params$Resource$Catalogs$Get, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.getIamPolicy
         * @desc Gets IAM policy for the specified Catalog.
         * @alias cloudprivatecatalogproducer.catalogs.getIamPolicy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.options.requestedPolicyVersion Optional. The policy format version to be returned. Acceptable values are 0, 1, and 3. If the value is 0, or the field is omitted, policy format version 1 will be returned.
         * @param {string} params.resource_ REQUIRED: The resource for which the policy is being requested. See the operation documentation for the appropriate value for this field.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        getIamPolicy(params?: Params$Resource$Catalogs$Getiampolicy, options?: MethodOptions): GaxiosPromise<Schema$GoogleIamV1Policy>;
        getIamPolicy(params: Params$Resource$Catalogs$Getiampolicy, options: MethodOptions | BodyResponseCallback<Schema$GoogleIamV1Policy>, callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        getIamPolicy(params: Params$Resource$Catalogs$Getiampolicy, callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        getIamPolicy(callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.list
         * @desc Lists Catalog resources that the producer has access to, within the scope of the parent resource.
         * @alias cloudprivatecatalogproducer.catalogs.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.pageSize The maximum number of catalogs to return.
         * @param {string=} params.pageToken A pagination token returned from a previous call to ListCatalogs that indicates where this listing should continue from. This field is optional.
         * @param {string=} params.parent The resource name of the parent resource.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Catalogs$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListCatalogsResponse>;
        list(params: Params$Resource$Catalogs$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListCatalogsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListCatalogsResponse>): void;
        list(params: Params$Resource$Catalogs$List, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListCatalogsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListCatalogsResponse>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.patch
         * @desc Updates a specific Catalog resource.
         * @alias cloudprivatecatalogproducer.catalogs.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name Output only. The resource name of the catalog, in the format `catalogs/{catalog_id}'.  A unique identifier for the catalog, which is generated by catalog service.
         * @param {string=} params.updateMask Field mask that controls which fields of the catalog should be updated.
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1Catalog} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Catalogs$Patch, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>;
        patch(params: Params$Resource$Catalogs$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        patch(params: Params$Resource$Catalogs$Patch, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.setIamPolicy
         * @desc Sets the IAM policy for the specified Catalog.
         * @alias cloudprivatecatalogproducer.catalogs.setIamPolicy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.resource_ REQUIRED: The resource for which the policy is being specified. See the operation documentation for the appropriate value for this field.
         * @param {().GoogleIamV1SetIamPolicyRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        setIamPolicy(params?: Params$Resource$Catalogs$Setiampolicy, options?: MethodOptions): GaxiosPromise<Schema$GoogleIamV1Policy>;
        setIamPolicy(params: Params$Resource$Catalogs$Setiampolicy, options: MethodOptions | BodyResponseCallback<Schema$GoogleIamV1Policy>, callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        setIamPolicy(params: Params$Resource$Catalogs$Setiampolicy, callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        setIamPolicy(callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.testIamPermissions
         * @desc Tests the IAM permissions for the specified Catalog.
         * @alias cloudprivatecatalogproducer.catalogs.testIamPermissions
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.resource_ REQUIRED: The resource for which the policy detail is being requested. See the operation documentation for the appropriate value for this field.
         * @param {().GoogleIamV1TestIamPermissionsRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        testIamPermissions(params?: Params$Resource$Catalogs$Testiampermissions, options?: MethodOptions): GaxiosPromise<Schema$GoogleIamV1TestIamPermissionsResponse>;
        testIamPermissions(params: Params$Resource$Catalogs$Testiampermissions, options: MethodOptions | BodyResponseCallback<Schema$GoogleIamV1TestIamPermissionsResponse>, callback: BodyResponseCallback<Schema$GoogleIamV1TestIamPermissionsResponse>): void;
        testIamPermissions(params: Params$Resource$Catalogs$Testiampermissions, callback: BodyResponseCallback<Schema$GoogleIamV1TestIamPermissionsResponse>): void;
        testIamPermissions(callback: BodyResponseCallback<Schema$GoogleIamV1TestIamPermissionsResponse>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.undelete
         * @desc Undeletes a deleted Catalog and all resources under it.
         * @alias cloudprivatecatalogproducer.catalogs.undelete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name of the catalog.
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1UndeleteCatalogRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        undelete(params?: Params$Resource$Catalogs$Undelete, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>;
        undelete(params: Params$Resource$Catalogs$Undelete, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        undelete(params: Params$Resource$Catalogs$Undelete, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
        undelete(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog>): void;
    }
    export interface Params$Resource$Catalogs$Create extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog;
    }
    export interface Params$Resource$Catalogs$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Forces deletion of the `Catalog` and its `Association` resources. If the `Catalog` is still associated with other resources and force is not set to true, then the operation fails.
         */
        force?: boolean;
        /**
         * The resource name of the catalog.
         */
        name?: string;
    }
    export interface Params$Resource$Catalogs$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the catalog.
         */
        name?: string;
    }
    export interface Params$Resource$Catalogs$Getiampolicy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Optional. The policy format version to be returned. Acceptable values are 0, 1, and 3. If the value is 0, or the field is omitted, policy format version 1 will be returned.
         */
        'options.requestedPolicyVersion'?: number;
        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation documentation for the appropriate value for this field.
         */
        resource?: string;
    }
    export interface Params$Resource$Catalogs$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The maximum number of catalogs to return.
         */
        pageSize?: number;
        /**
         * A pagination token returned from a previous call to ListCatalogs that indicates where this listing should continue from. This field is optional.
         */
        pageToken?: string;
        /**
         * The resource name of the parent resource.
         */
        parent?: string;
    }
    export interface Params$Resource$Catalogs$Patch extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Output only. The resource name of the catalog, in the format `catalogs/{catalog_id}'.  A unique identifier for the catalog, which is generated by catalog service.
         */
        name?: string;
        /**
         * Field mask that controls which fields of the catalog should be updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Catalog;
    }
    export interface Params$Resource$Catalogs$Setiampolicy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation documentation for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleIamV1SetIamPolicyRequest;
    }
    export interface Params$Resource$Catalogs$Testiampermissions extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation documentation for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleIamV1TestIamPermissionsRequest;
    }
    export interface Params$Resource$Catalogs$Undelete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the catalog.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1UndeleteCatalogRequest;
    }
    export class Resource$Catalogs$Associations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * cloudprivatecatalogproducer.catalogs.associations.create
         * @desc Creates an Association instance under a given Catalog.
         * @alias cloudprivatecatalogproducer.catalogs.associations.create
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.parent The `Catalog` resource's name.
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1CreateAssociationRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        create(params?: Params$Resource$Catalogs$Associations$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>;
        create(params: Params$Resource$Catalogs$Associations$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>): void;
        create(params: Params$Resource$Catalogs$Associations$Create, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.associations.delete
         * @desc Deletes the given Association.
         * @alias cloudprivatecatalogproducer.catalogs.associations.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name of the `Association` to delete.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Catalogs$Associations$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleProtobufEmpty>;
        delete(params: Params$Resource$Catalogs$Associations$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Catalogs$Associations$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.associations.get
         * @desc Returns the requested Association resource.
         * @alias cloudprivatecatalogproducer.catalogs.associations.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name of the `Association` to retrieve.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Catalogs$Associations$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>;
        get(params: Params$Resource$Catalogs$Associations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>): void;
        get(params: Params$Resource$Catalogs$Associations$Get, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Association>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.associations.list
         * @desc Lists all Association resources under a catalog.
         * @alias cloudprivatecatalogproducer.catalogs.associations.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.pageSize The maximum number of catalog associations to return.
         * @param {string=} params.pageToken A pagination token returned from the previous call to `ListAssociations`.
         * @param {string} params.parent The resource name of the `Catalog` whose `Associations` are being retrieved. In the format `catalogs/<catalog>`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Catalogs$Associations$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListAssociationsResponse>;
        list(params: Params$Resource$Catalogs$Associations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListAssociationsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListAssociationsResponse>): void;
        list(params: Params$Resource$Catalogs$Associations$List, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListAssociationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListAssociationsResponse>): void;
    }
    export interface Params$Resource$Catalogs$Associations$Create extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The `Catalog` resource's name.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1CreateAssociationRequest;
    }
    export interface Params$Resource$Catalogs$Associations$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the `Association` to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Catalogs$Associations$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the `Association` to retrieve.
         */
        name?: string;
    }
    export interface Params$Resource$Catalogs$Associations$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The maximum number of catalog associations to return.
         */
        pageSize?: number;
        /**
         * A pagination token returned from the previous call to `ListAssociations`.
         */
        pageToken?: string;
        /**
         * The resource name of the `Catalog` whose `Associations` are being retrieved. In the format `catalogs/<catalog>`.
         */
        parent?: string;
    }
    export class Resource$Catalogs$Products {
        context: APIRequestContext;
        icons: Resource$Catalogs$Products$Icons;
        versions: Resource$Catalogs$Products$Versions;
        constructor(context: APIRequestContext);
        /**
         * cloudprivatecatalogproducer.catalogs.products.copy
         * @desc Copies a Product under another Catalog.
         * @alias cloudprivatecatalogproducer.catalogs.products.copy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name of the current product that is copied from.
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1CopyProductRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        copy(params?: Params$Resource$Catalogs$Products$Copy, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        copy(params: Params$Resource$Catalogs$Products$Copy, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        copy(params: Params$Resource$Catalogs$Products$Copy, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        copy(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.products.create
         * @desc Creates a Product instance under a given Catalog.
         * @alias cloudprivatecatalogproducer.catalogs.products.create
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.parent The catalog name of the new product's parent.
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1Product} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        create(params?: Params$Resource$Catalogs$Products$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>;
        create(params: Params$Resource$Catalogs$Products$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>): void;
        create(params: Params$Resource$Catalogs$Products$Create, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.products.delete
         * @desc Hard deletes a Product.
         * @alias cloudprivatecatalogproducer.catalogs.products.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name of the product.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Catalogs$Products$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleProtobufEmpty>;
        delete(params: Params$Resource$Catalogs$Products$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Catalogs$Products$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.products.get
         * @desc Returns the requested Product resource.
         * @alias cloudprivatecatalogproducer.catalogs.products.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name of the product.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Catalogs$Products$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>;
        get(params: Params$Resource$Catalogs$Products$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>): void;
        get(params: Params$Resource$Catalogs$Products$Get, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.products.list
         * @desc Lists Product resources that the producer has access to, within the scope of the parent catalog.
         * @alias cloudprivatecatalogproducer.catalogs.products.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter A filter expression used to restrict the returned results based upon properties of the product.
         * @param {integer=} params.pageSize The maximum number of products to return.
         * @param {string=} params.pageToken A pagination token returned from a previous call to ListProducts that indicates where this listing should continue from. This field is optional.
         * @param {string} params.parent The resource name of the parent resource.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Catalogs$Products$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListProductsResponse>;
        list(params: Params$Resource$Catalogs$Products$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListProductsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListProductsResponse>): void;
        list(params: Params$Resource$Catalogs$Products$List, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListProductsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListProductsResponse>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.products.patch
         * @desc Updates a specific Product resource.
         * @alias cloudprivatecatalogproducer.catalogs.products.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name Required. The resource name of the product in the format `catalogs/{catalog_id}/products/a-z*[a-z0-9]'.  A unique identifier for the product under a catalog, which cannot be changed after the product is created. The final segment of the name must between 1 and 256 characters in length.
         * @param {string=} params.updateMask Field mask that controls which fields of the product should be updated.
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1Product} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Catalogs$Products$Patch, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>;
        patch(params: Params$Resource$Catalogs$Products$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>): void;
        patch(params: Params$Resource$Catalogs$Products$Patch, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Product>): void;
    }
    export interface Params$Resource$Catalogs$Products$Copy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the current product that is copied from.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1CopyProductRequest;
    }
    export interface Params$Resource$Catalogs$Products$Create extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The catalog name of the new product's parent.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Product;
    }
    export interface Params$Resource$Catalogs$Products$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the product.
         */
        name?: string;
    }
    export interface Params$Resource$Catalogs$Products$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the product.
         */
        name?: string;
    }
    export interface Params$Resource$Catalogs$Products$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * A filter expression used to restrict the returned results based upon properties of the product.
         */
        filter?: string;
        /**
         * The maximum number of products to return.
         */
        pageSize?: number;
        /**
         * A pagination token returned from a previous call to ListProducts that indicates where this listing should continue from. This field is optional.
         */
        pageToken?: string;
        /**
         * The resource name of the parent resource.
         */
        parent?: string;
    }
    export interface Params$Resource$Catalogs$Products$Patch extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Required. The resource name of the product in the format `catalogs/{catalog_id}/products/a-z*[a-z0-9]'.  A unique identifier for the product under a catalog, which cannot be changed after the product is created. The final segment of the name must between 1 and 256 characters in length.
         */
        name?: string;
        /**
         * Field mask that controls which fields of the product should be updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Product;
    }
    export class Resource$Catalogs$Products$Icons {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * cloudprivatecatalogproducer.catalogs.products.icons.upload
         * @desc Creates an Icon instance under a given Product. If Product only has a default icon, a new Icon instance is created and associated with the given Product. If Product already has a non-default icon, the action creates a new Icon instance, associates the newly created Icon with the given Product and deletes the old icon.
         * @alias cloudprivatecatalogproducer.catalogs.products.icons.upload
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.product The resource name of the product.
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1UploadIconRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        upload(params?: Params$Resource$Catalogs$Products$Icons$Upload, options?: MethodOptions): GaxiosPromise<Schema$GoogleProtobufEmpty>;
        upload(params: Params$Resource$Catalogs$Products$Icons$Upload, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        upload(params: Params$Resource$Catalogs$Products$Icons$Upload, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        upload(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
    }
    export interface Params$Resource$Catalogs$Products$Icons$Upload extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the product.
         */
        product?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1UploadIconRequest;
    }
    export class Resource$Catalogs$Products$Versions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * cloudprivatecatalogproducer.catalogs.products.versions.create
         * @desc Creates a Version instance under a given Product.
         * @alias cloudprivatecatalogproducer.catalogs.products.versions.create
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.parent The product name of the new version's parent.
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1Version} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        create(params?: Params$Resource$Catalogs$Products$Versions$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        create(params: Params$Resource$Catalogs$Products$Versions$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(params: Params$Resource$Catalogs$Products$Versions$Create, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.products.versions.delete
         * @desc Hard deletes a Version.
         * @alias cloudprivatecatalogproducer.catalogs.products.versions.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name of the version.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Catalogs$Products$Versions$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleProtobufEmpty>;
        delete(params: Params$Resource$Catalogs$Products$Versions$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Catalogs$Products$Versions$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.products.versions.get
         * @desc Returns the requested Version resource.
         * @alias cloudprivatecatalogproducer.catalogs.products.versions.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The resource name of the version.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Catalogs$Products$Versions$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>;
        get(params: Params$Resource$Catalogs$Products$Versions$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>): void;
        get(params: Params$Resource$Catalogs$Products$Versions$Get, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.products.versions.list
         * @desc Lists Version resources that the producer has access to, within the scope of the parent Product.
         * @alias cloudprivatecatalogproducer.catalogs.products.versions.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.pageSize The maximum number of versions to return.
         * @param {string=} params.pageToken A pagination token returned from a previous call to ListVersions that indicates where this listing should continue from. This field is optional.
         * @param {string} params.parent The resource name of the parent resource.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Catalogs$Products$Versions$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListVersionsResponse>;
        list(params: Params$Resource$Catalogs$Products$Versions$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListVersionsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListVersionsResponse>): void;
        list(params: Params$Resource$Catalogs$Products$Versions$List, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListVersionsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1ListVersionsResponse>): void;
        /**
         * cloudprivatecatalogproducer.catalogs.products.versions.patch
         * @desc Updates a specific Version resource.
         * @alias cloudprivatecatalogproducer.catalogs.products.versions.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name Required. The resource name of the version, in the format `catalogs/{catalog_id}/products/{product_id}/versions/a-z*[a-z0-9]'.  A unique identifier for the version under a product, which can't be changed after the version is created. The final segment of the name must between 1 and 63 characters in length.
         * @param {string=} params.updateMask Field mask that controls which fields of the version should be updated.
         * @param {().GoogleCloudPrivatecatalogproducerV1beta1Version} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Catalogs$Products$Versions$Patch, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>;
        patch(params: Params$Resource$Catalogs$Products$Versions$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>): void;
        patch(params: Params$Resource$Catalogs$Products$Versions$Patch, callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudPrivatecatalogproducerV1beta1Version>): void;
    }
    export interface Params$Resource$Catalogs$Products$Versions$Create extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The product name of the new version's parent.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Version;
    }
    export interface Params$Resource$Catalogs$Products$Versions$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the version.
         */
        name?: string;
    }
    export interface Params$Resource$Catalogs$Products$Versions$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The resource name of the version.
         */
        name?: string;
    }
    export interface Params$Resource$Catalogs$Products$Versions$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The maximum number of versions to return.
         */
        pageSize?: number;
        /**
         * A pagination token returned from a previous call to ListVersions that indicates where this listing should continue from. This field is optional.
         */
        pageToken?: string;
        /**
         * The resource name of the parent resource.
         */
        parent?: string;
    }
    export interface Params$Resource$Catalogs$Products$Versions$Patch extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Required. The resource name of the version, in the format `catalogs/{catalog_id}/products/{product_id}/versions/a-z*[a-z0-9]'.  A unique identifier for the version under a product, which can't be changed after the version is created. The final segment of the name must between 1 and 63 characters in length.
         */
        name?: string;
        /**
         * Field mask that controls which fields of the version should be updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudPrivatecatalogproducerV1beta1Version;
    }
    export class Resource$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * cloudprivatecatalogproducer.operations.cancel
         * @desc Starts asynchronous cancellation on a long-running operation.  The server makes a best effort to cancel the operation, but success is not guaranteed.  If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.  Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
         * @alias cloudprivatecatalogproducer.operations.cancel
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The name of the operation resource to be cancelled.
         * @param {().GoogleLongrunningCancelOperationRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        cancel(params?: Params$Resource$Operations$Cancel, options?: MethodOptions): GaxiosPromise<Schema$GoogleProtobufEmpty>;
        cancel(params: Params$Resource$Operations$Cancel, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        cancel(params: Params$Resource$Operations$Cancel, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        cancel(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * cloudprivatecatalogproducer.operations.delete
         * @desc Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
         * @alias cloudprivatecatalogproducer.operations.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The name of the operation resource to be deleted.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Operations$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleProtobufEmpty>;
        delete(params: Params$Resource$Operations$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Operations$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * cloudprivatecatalogproducer.operations.get
         * @desc Gets the latest state of a long-running operation.  Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @alias cloudprivatecatalogproducer.operations.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The name of the operation resource.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Operations$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        get(params: Params$Resource$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(params: Params$Resource$Operations$Get, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * cloudprivatecatalogproducer.operations.list
         * @desc Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.  NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/x/operations`. To override the binding, API services can add a binding such as `"/v1/{name=users/x}/operations"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.
         * @alias cloudprivatecatalogproducer.operations.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter The standard list filter.
         * @param {string=} params.name The name of the operation's parent resource.
         * @param {integer=} params.pageSize The standard list page size.
         * @param {string=} params.pageToken The standard list page token.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Operations$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningListOperationsResponse>;
        list(params: Params$Resource$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(params: Params$Resource$Operations$List, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
    }
    export interface Params$Resource$Operations$Cancel extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the operation resource to be cancelled.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleLongrunningCancelOperationRequest;
    }
    export interface Params$Resource$Operations$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the operation resource to be deleted.
         */
        name?: string;
    }
    export interface Params$Resource$Operations$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export interface Params$Resource$Operations$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
    }
    export {};
}
