"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("bluebird-global");

var _lodash = _interopRequireDefault(require("lodash"));

var _middleware = require("./middleware");

require("./typings");

var _dialogflow = require("./engines/dialogflow");

var _dataset = require("./dataset");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const dfListenerByBot = {};

const onServerStarted = async bp => {
  await (0, _middleware.registerMiddleware)(bp);
};

const onServerReady = async bp => {};

const onBotMount = async (bp, botId) => {
  const moduleBotConfig = await bp.config.getModuleConfigForBot('nlu-extras', botId);

  if (!moduleBotConfig.dialogflow || !moduleBotConfig.dialogflow.enabled) {
    (0, _middleware.removeForBot)(botId);
    return;
  }

  (0, _middleware.enableForBot)(botId, moduleBotConfig);

  const trainForBot = _lodash.default.debounce(async () => {
    const bpfs = bp.ghost.forBot(botId);
    const dataset = await (0, _dataset.getDataset)(bpfs);
    const zip = await (0, _dialogflow.createZip)(dataset, moduleBotConfig.dialogflow);
    await (0, _dialogflow.restoreAgent)(zip, moduleBotConfig.dialogflow);
    bp.logger.forBot(botId).info(`Started DialogFlow training`);
  }, 5000, {
    maxWait: 30000
  });

  const regex = RegExp(`^data/bots/${botId}/(intents|entities)/`, 'i');
  const listen = bp.ghost.forBot(botId).onFileChanged(async file => {
    if (regex.test(file)) {
      trainForBot();
    }
  });
  dfListenerByBot[botId] = listen;
};

const onBotUnmount = async (bp, botId) => {
  try {
    (0, _middleware.removeForBot)(botId);

    if (dfListenerByBot[botId]) {
      dfListenerByBot[botId].remove();
    }
  } catch {}
};

const onModuleUnmount = async bp => {
  bp.events.removeMiddleware('nlu.incoming');
  bp.http.deleteRouterForBot('nlu');
};

const entryPoint = {
  onServerStarted,
  onServerReady,
  onBotMount,
  onBotUnmount,
  onModuleUnmount,
  definition: {
    name: 'nlu-extras',
    noInterface: true,
    moduleView: {
      stretched: true
    },
    menuIcon: 'translate',
    menuText: 'NLU Extras',
    fullName: 'NLU Extras',
    homepage: 'https://botpress.io'
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=index.js.map